/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a sole-tenant Node Group resource. A sole-tenant node is a physical server that is dedicated to hosting VM instances only for your specific project. Use sole-tenant nodes to keep your instances physically separated from instances in other projects, or to group your instances together on the same host hardware. For more information, read Sole-tenant nodes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NodeGroup}
 */
public final class NodeGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NodeGroup)
    NodeGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeGroup.newBuilder() to construct.
  private NodeGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeGroup() {
    creationTimestamp_ = "";
    description_ = "";
    fingerprint_ = "";
    kind_ = "";
    locationHint_ = "";
    maintenanceInterval_ = "";
    maintenancePolicy_ = "";
    name_ = "";
    nodeTemplate_ = "";
    selfLink_ = "";
    status_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NodeGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NodeGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NodeGroup.class,
            com.google.cloud.compute.v1.NodeGroup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NodeGroup.MaintenanceInterval}
   */
  public enum MaintenanceInterval implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_INTERVAL = 0;</code>
     */
    UNDEFINED_MAINTENANCE_INTERVAL(0),
    /**
     *
     *
     * <pre>
     * VMs are eligible to receive infrastructure and hypervisor updates as they become available. This may result in more maintenance operations (live migrations or terminations) for the VM than the PERIODIC and RECURRENT options.
     * </pre>
     *
     * <code>AS_NEEDED = 500724834;</code>
     */
    AS_NEEDED(500724834),
    /**
     *
     *
     * <pre>
     * VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available. RECURRENT is used for GEN3 and Slice of Hardware VMs.
     * </pre>
     *
     * <code>RECURRENT = 194244550;</code>
     */
    RECURRENT(194244550),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_INTERVAL = 0;</code>
     */
    public static final int UNDEFINED_MAINTENANCE_INTERVAL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * VMs are eligible to receive infrastructure and hypervisor updates as they become available. This may result in more maintenance operations (live migrations or terminations) for the VM than the PERIODIC and RECURRENT options.
     * </pre>
     *
     * <code>AS_NEEDED = 500724834;</code>
     */
    public static final int AS_NEEDED_VALUE = 500724834;
    /**
     *
     *
     * <pre>
     * VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available. RECURRENT is used for GEN3 and Slice of Hardware VMs.
     * </pre>
     *
     * <code>RECURRENT = 194244550;</code>
     */
    public static final int RECURRENT_VALUE = 194244550;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaintenanceInterval valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaintenanceInterval forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MAINTENANCE_INTERVAL;
        case 500724834:
          return AS_NEEDED;
        case 194244550:
          return RECURRENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaintenanceInterval>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MaintenanceInterval>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MaintenanceInterval>() {
              public MaintenanceInterval findValueByNumber(int number) {
                return MaintenanceInterval.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NodeGroup.getDescriptor().getEnumTypes().get(0);
    }

    private static final MaintenanceInterval[] VALUES = values();

    public static MaintenanceInterval valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaintenanceInterval(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NodeGroup.MaintenanceInterval)
  }

  /**
   *
   *
   * <pre>
   * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NodeGroup.MaintenancePolicy}
   */
  public enum MaintenancePolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_POLICY = 0;</code>
     */
    UNDEFINED_MAINTENANCE_POLICY(0),
    /**
     *
     *
     * <pre>
     * Allow the node and corresponding instances to retain default maintenance behavior.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    DEFAULT(115302945),
    /** <code>MAINTENANCE_POLICY_UNSPECIFIED = 72964182;</code> */
    MAINTENANCE_POLICY_UNSPECIFIED(72964182),
    /**
     *
     *
     * <pre>
     * When maintenance must be done on a node, the instances on that node will be moved to other nodes in the group. Instances with onHostMaintenance = MIGRATE will live migrate to their destinations while instances with onHostMaintenance = TERMINATE will terminate and then restart on their destination nodes if automaticRestart = true.
     * </pre>
     *
     * <code>MIGRATE_WITHIN_NODE_GROUP = 153483394;</code>
     */
    MIGRATE_WITHIN_NODE_GROUP(153483394),
    /**
     *
     *
     * <pre>
     * Instances in this group will restart on the same node when maintenance has completed. Instances must have onHostMaintenance = TERMINATE, and they will only restart if automaticRestart = true.
     * </pre>
     *
     * <code>RESTART_IN_PLACE = 228647325;</code>
     */
    RESTART_IN_PLACE(228647325),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MAINTENANCE_POLICY = 0;</code>
     */
    public static final int UNDEFINED_MAINTENANCE_POLICY_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allow the node and corresponding instances to retain default maintenance behavior.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    public static final int DEFAULT_VALUE = 115302945;
    /** <code>MAINTENANCE_POLICY_UNSPECIFIED = 72964182;</code> */
    public static final int MAINTENANCE_POLICY_UNSPECIFIED_VALUE = 72964182;
    /**
     *
     *
     * <pre>
     * When maintenance must be done on a node, the instances on that node will be moved to other nodes in the group. Instances with onHostMaintenance = MIGRATE will live migrate to their destinations while instances with onHostMaintenance = TERMINATE will terminate and then restart on their destination nodes if automaticRestart = true.
     * </pre>
     *
     * <code>MIGRATE_WITHIN_NODE_GROUP = 153483394;</code>
     */
    public static final int MIGRATE_WITHIN_NODE_GROUP_VALUE = 153483394;
    /**
     *
     *
     * <pre>
     * Instances in this group will restart on the same node when maintenance has completed. Instances must have onHostMaintenance = TERMINATE, and they will only restart if automaticRestart = true.
     * </pre>
     *
     * <code>RESTART_IN_PLACE = 228647325;</code>
     */
    public static final int RESTART_IN_PLACE_VALUE = 228647325;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MaintenancePolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MaintenancePolicy forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MAINTENANCE_POLICY;
        case 115302945:
          return DEFAULT;
        case 72964182:
          return MAINTENANCE_POLICY_UNSPECIFIED;
        case 153483394:
          return MIGRATE_WITHIN_NODE_GROUP;
        case 228647325:
          return RESTART_IN_PLACE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MaintenancePolicy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MaintenancePolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MaintenancePolicy>() {
              public MaintenancePolicy findValueByNumber(int number) {
                return MaintenancePolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NodeGroup.getDescriptor().getEnumTypes().get(1);
    }

    private static final MaintenancePolicy[] VALUES = values();

    public static MaintenancePolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MaintenancePolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NodeGroup.MaintenancePolicy)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NodeGroup.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>CREATING = 455564985;</code> */
    CREATING(455564985),
    /** <code>DELETING = 528602024;</code> */
    DELETING(528602024),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /** <code>READY = 77848963;</code> */
    READY(77848963),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /** <code>CREATING = 455564985;</code> */
    public static final int CREATING_VALUE = 455564985;
    /** <code>DELETING = 528602024;</code> */
    public static final int DELETING_VALUE = 528602024;
    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;
    /** <code>READY = 77848963;</code> */
    public static final int READY_VALUE = 77848963;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NodeGroup.getDescriptor().getEnumTypes().get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NodeGroup.Status)
  }

  private int bitField0_;
  public static final int AUTOSCALING_POLICY_FIELD_NUMBER = 221950041;
  private com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscalingPolicy_;
  /**
   *
   *
   * <pre>
   * Specifies how autoscaling should behave.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   *
   * @return Whether the autoscalingPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies how autoscaling should behave.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   *
   * @return The autoscalingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy getAutoscalingPolicy() {
    return autoscalingPolicy_ == null
        ? com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.getDefaultInstance()
        : autoscalingPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies how autoscaling should behave.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeGroupAutoscalingPolicyOrBuilder
      getAutoscalingPolicyOrBuilder() {
    return autoscalingPolicy_ == null
        ? com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.getDefaultInstance()
        : autoscalingPolicy_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_HINT_FIELD_NUMBER = 350519505;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationHint_ = "";
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  @java.lang.Override
  public boolean hasLocationHint() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  @java.lang.Override
  public java.lang.String getLocationHint() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationHint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationHintBytes() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationHint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAINTENANCE_INTERVAL_FIELD_NUMBER = 403368049;

  @SuppressWarnings("serial")
  private volatile java.lang.Object maintenanceInterval_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
   * Check the MaintenanceInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_interval = 403368049;</code>
   *
   * @return Whether the maintenanceInterval field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceInterval() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
   * Check the MaintenanceInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_interval = 403368049;</code>
   *
   * @return The maintenanceInterval.
   */
  @java.lang.Override
  public java.lang.String getMaintenanceInterval() {
    java.lang.Object ref = maintenanceInterval_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maintenanceInterval_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
   * Check the MaintenanceInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_interval = 403368049;</code>
   *
   * @return The bytes for maintenanceInterval.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaintenanceIntervalBytes() {
    java.lang.Object ref = maintenanceInterval_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maintenanceInterval_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 528327646;

  @SuppressWarnings("serial")
  private volatile java.lang.Object maintenancePolicy_ = "";
  /**
   *
   *
   * <pre>
   * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
   * Check the MaintenancePolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_policy = 528327646;</code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePolicy() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
   * Check the MaintenancePolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_policy = 528327646;</code>
   *
   * @return The maintenancePolicy.
   */
  @java.lang.Override
  public java.lang.String getMaintenancePolicy() {
    java.lang.Object ref = maintenancePolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maintenancePolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
   * Check the MaintenancePolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string maintenance_policy = 528327646;</code>
   *
   * @return The bytes for maintenancePolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaintenancePolicyBytes() {
    java.lang.Object ref = maintenancePolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maintenancePolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAINTENANCE_WINDOW_FIELD_NUMBER = 186374812;
  private com.google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenanceWindow_;
  /**
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
   * </code>
   *
   * @return Whether the maintenanceWindow field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceWindow() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
   * </code>
   *
   * @return The maintenanceWindow.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeGroupMaintenanceWindow getMaintenanceWindow() {
    return maintenanceWindow_ == null
        ? com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.getDefaultInstance()
        : maintenanceWindow_;
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NodeGroupMaintenanceWindowOrBuilder
      getMaintenanceWindowOrBuilder() {
    return maintenanceWindow_ == null
        ? com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.getDefaultInstance()
        : maintenanceWindow_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_TEMPLATE_FIELD_NUMBER = 323154455;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeTemplate_ = "";
  /**
   *
   *
   * <pre>
   * URL of the node template to create the node group from.
   * </pre>
   *
   * <code>optional string node_template = 323154455;</code>
   *
   * @return Whether the nodeTemplate field is set.
   */
  @java.lang.Override
  public boolean hasNodeTemplate() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the node template to create the node group from.
   * </pre>
   *
   * <code>optional string node_template = 323154455;</code>
   *
   * @return The nodeTemplate.
   */
  @java.lang.Override
  public java.lang.String getNodeTemplate() {
    java.lang.Object ref = nodeTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the node template to create the node group from.
   * </pre>
   *
   * <code>optional string node_template = 323154455;</code>
   *
   * @return The bytes for nodeTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeTemplateBytes() {
    java.lang.Object ref = nodeTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARE_SETTINGS_FIELD_NUMBER = 266668163;
  private com.google.cloud.compute.v1.ShareSettings shareSettings_;
  /**
   *
   *
   * <pre>
   * Share-settings for the node group
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   *
   * @return Whether the shareSettings field is set.
   */
  @java.lang.Override
  public boolean hasShareSettings() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Share-settings for the node group
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   *
   * @return The shareSettings.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShareSettings getShareSettings() {
    return shareSettings_ == null
        ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
        : shareSettings_;
  }
  /**
   *
   *
   * <pre>
   * Share-settings for the node group
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShareSettingsOrBuilder getShareSettingsOrBuilder() {
    return shareSettings_ == null
        ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
        : shareSettings_;
  }

  public static final int SIZE_FIELD_NUMBER = 3530753;
  private int size_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] The total number of nodes in the node group.
   * </pre>
   *
   * <code>optional int32 size = 3530753;</code>
   *
   * @return Whether the size field is set.
   */
  @java.lang.Override
  public boolean hasSize() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The total number of nodes in the node group.
   * </pre>
   *
   * <code>optional int32 size = 3530753;</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public int getSize() {
    return size_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   *
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   *
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeInt32(3530753, size_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(186374812, getMaintenanceWindow());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(221950041, getAutoscalingPolicy());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(266668163, getShareSettings());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 323154455, nodeTemplate_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 350519505, locationHint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 403368049, maintenanceInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 528327646, maintenancePolicy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3530753, size_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              186374812, getMaintenanceWindow());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              221950041, getAutoscalingPolicy());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(266668163, getShareSettings());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(323154455, nodeTemplate_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(350519505, locationHint_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(403368049, maintenanceInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(528327646, maintenancePolicy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NodeGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NodeGroup other = (com.google.cloud.compute.v1.NodeGroup) obj;

    if (hasAutoscalingPolicy() != other.hasAutoscalingPolicy()) return false;
    if (hasAutoscalingPolicy()) {
      if (!getAutoscalingPolicy().equals(other.getAutoscalingPolicy())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLocationHint() != other.hasLocationHint()) return false;
    if (hasLocationHint()) {
      if (!getLocationHint().equals(other.getLocationHint())) return false;
    }
    if (hasMaintenanceInterval() != other.hasMaintenanceInterval()) return false;
    if (hasMaintenanceInterval()) {
      if (!getMaintenanceInterval().equals(other.getMaintenanceInterval())) return false;
    }
    if (hasMaintenancePolicy() != other.hasMaintenancePolicy()) return false;
    if (hasMaintenancePolicy()) {
      if (!getMaintenancePolicy().equals(other.getMaintenancePolicy())) return false;
    }
    if (hasMaintenanceWindow() != other.hasMaintenanceWindow()) return false;
    if (hasMaintenanceWindow()) {
      if (!getMaintenanceWindow().equals(other.getMaintenanceWindow())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNodeTemplate() != other.hasNodeTemplate()) return false;
    if (hasNodeTemplate()) {
      if (!getNodeTemplate().equals(other.getNodeTemplate())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasShareSettings() != other.hasShareSettings()) return false;
    if (hasShareSettings()) {
      if (!getShareSettings().equals(other.getShareSettings())) return false;
    }
    if (hasSize() != other.hasSize()) return false;
    if (hasSize()) {
      if (getSize() != other.getSize()) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoscalingPolicy()) {
      hash = (37 * hash) + AUTOSCALING_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingPolicy().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLocationHint()) {
      hash = (37 * hash) + LOCATION_HINT_FIELD_NUMBER;
      hash = (53 * hash) + getLocationHint().hashCode();
    }
    if (hasMaintenanceInterval()) {
      hash = (37 * hash) + MAINTENANCE_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceInterval().hashCode();
    }
    if (hasMaintenancePolicy()) {
      hash = (37 * hash) + MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePolicy().hashCode();
    }
    if (hasMaintenanceWindow()) {
      hash = (37 * hash) + MAINTENANCE_WINDOW_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceWindow().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNodeTemplate()) {
      hash = (37 * hash) + NODE_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getNodeTemplate().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasShareSettings()) {
      hash = (37 * hash) + SHARE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getShareSettings().hashCode();
    }
    if (hasSize()) {
      hash = (37 * hash) + SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getSize();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NodeGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.NodeGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a sole-tenant Node Group resource. A sole-tenant node is a physical server that is dedicated to hosting VM instances only for your specific project. Use sole-tenant nodes to keep your instances physically separated from instances in other projects, or to group your instances together on the same host hardware. For more information, read Sole-tenant nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NodeGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NodeGroup)
      com.google.cloud.compute.v1.NodeGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NodeGroup.class,
              com.google.cloud.compute.v1.NodeGroup.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NodeGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoscalingPolicyFieldBuilder();
        getMaintenanceWindowFieldBuilder();
        getShareSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoscalingPolicy_ = null;
      if (autoscalingPolicyBuilder_ != null) {
        autoscalingPolicyBuilder_.dispose();
        autoscalingPolicyBuilder_ = null;
      }
      creationTimestamp_ = "";
      description_ = "";
      fingerprint_ = "";
      id_ = 0L;
      kind_ = "";
      locationHint_ = "";
      maintenanceInterval_ = "";
      maintenancePolicy_ = "";
      maintenanceWindow_ = null;
      if (maintenanceWindowBuilder_ != null) {
        maintenanceWindowBuilder_.dispose();
        maintenanceWindowBuilder_ = null;
      }
      name_ = "";
      nodeTemplate_ = "";
      selfLink_ = "";
      shareSettings_ = null;
      if (shareSettingsBuilder_ != null) {
        shareSettingsBuilder_.dispose();
        shareSettingsBuilder_ = null;
      }
      size_ = 0;
      status_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NodeGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeGroup getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NodeGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeGroup build() {
      com.google.cloud.compute.v1.NodeGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NodeGroup buildPartial() {
      com.google.cloud.compute.v1.NodeGroup result =
          new com.google.cloud.compute.v1.NodeGroup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.NodeGroup result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoscalingPolicy_ =
            autoscalingPolicyBuilder_ == null
                ? autoscalingPolicy_
                : autoscalingPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.locationHint_ = locationHint_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maintenanceInterval_ = maintenanceInterval_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.maintenancePolicy_ = maintenancePolicy_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.maintenanceWindow_ =
            maintenanceWindowBuilder_ == null
                ? maintenanceWindow_
                : maintenanceWindowBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.nodeTemplate_ = nodeTemplate_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.shareSettings_ =
            shareSettingsBuilder_ == null ? shareSettings_ : shareSettingsBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.size_ = size_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00010000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NodeGroup) {
        return mergeFrom((com.google.cloud.compute.v1.NodeGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NodeGroup other) {
      if (other == com.google.cloud.compute.v1.NodeGroup.getDefaultInstance()) return this;
      if (other.hasAutoscalingPolicy()) {
        mergeAutoscalingPolicy(other.getAutoscalingPolicy());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasLocationHint()) {
        locationHint_ = other.locationHint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasMaintenanceInterval()) {
        maintenanceInterval_ = other.maintenanceInterval_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasMaintenancePolicy()) {
        maintenancePolicy_ = other.maintenancePolicy_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasMaintenanceWindow()) {
        mergeMaintenanceWindow(other.getMaintenanceWindow());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasNodeTemplate()) {
        nodeTemplate_ = other.nodeTemplate_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasShareSettings()) {
        mergeShareSettings(other.getShareSettings());
      }
      if (other.hasSize()) {
        setSize(other.getSize());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 28246024:
              {
                size_ = input.readInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case 28246024
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 1450082194
            case 1490998498:
              {
                input.readMessage(
                    getMaintenanceWindowFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 1490998498
            case 1775600330:
              {
                input.readMessage(
                    getAutoscalingPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 1775600330
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1877428002
            case 2133345306:
              {
                input.readMessage(getShareSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 2133345306
            case -1709731654:
              {
                nodeTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -1709731654
            case -1490811254:
              {
                locationHint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -1490811254
            case -1068022902:
              {
                maintenanceInterval_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -1068022902
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -645248918
            case -68346126:
              {
                maintenancePolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -68346126
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscalingPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy,
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.Builder,
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicyOrBuilder>
        autoscalingPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     *
     * @return Whether the autoscalingPolicy field is set.
     */
    public boolean hasAutoscalingPolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     *
     * @return The autoscalingPolicy.
     */
    public com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy getAutoscalingPolicy() {
      if (autoscalingPolicyBuilder_ == null) {
        return autoscalingPolicy_ == null
            ? com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.getDefaultInstance()
            : autoscalingPolicy_;
      } else {
        return autoscalingPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder setAutoscalingPolicy(
        com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy value) {
      if (autoscalingPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingPolicy_ = value;
      } else {
        autoscalingPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder setAutoscalingPolicy(
        com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.Builder builderForValue) {
      if (autoscalingPolicyBuilder_ == null) {
        autoscalingPolicy_ = builderForValue.build();
      } else {
        autoscalingPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder mergeAutoscalingPolicy(
        com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy value) {
      if (autoscalingPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && autoscalingPolicy_ != null
            && autoscalingPolicy_
                != com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.getDefaultInstance()) {
          getAutoscalingPolicyBuilder().mergeFrom(value);
        } else {
          autoscalingPolicy_ = value;
        }
      } else {
        autoscalingPolicyBuilder_.mergeFrom(value);
      }
      if (autoscalingPolicy_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public Builder clearAutoscalingPolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      autoscalingPolicy_ = null;
      if (autoscalingPolicyBuilder_ != null) {
        autoscalingPolicyBuilder_.dispose();
        autoscalingPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.Builder
        getAutoscalingPolicyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAutoscalingPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeGroupAutoscalingPolicyOrBuilder
        getAutoscalingPolicyOrBuilder() {
      if (autoscalingPolicyBuilder_ != null) {
        return autoscalingPolicyBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingPolicy_ == null
            ? com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.getDefaultInstance()
            : autoscalingPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how autoscaling should behave.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupAutoscalingPolicy autoscaling_policy = 221950041;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy,
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.Builder,
            com.google.cloud.compute.v1.NodeGroupAutoscalingPolicyOrBuilder>
        getAutoscalingPolicyFieldBuilder() {
      if (autoscalingPolicyBuilder_ == null) {
        autoscalingPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy,
                com.google.cloud.compute.v1.NodeGroupAutoscalingPolicy.Builder,
                com.google.cloud.compute.v1.NodeGroupAutoscalingPolicyOrBuilder>(
                getAutoscalingPolicy(), getParentForChildren(), isClean());
        autoscalingPolicy_ = null;
      }
      return autoscalingPolicyBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#nodeGroup for node group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object locationHint_ = "";
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return Whether the locationHint field is set.
     */
    public boolean hasLocationHint() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The locationHint.
     */
    public java.lang.String getLocationHint() {
      java.lang.Object ref = locationHint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationHint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The bytes for locationHint.
     */
    public com.google.protobuf.ByteString getLocationHintBytes() {
      java.lang.Object ref = locationHint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationHint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationHint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationHint() {
      locationHint_ = getDefaultInstance().getLocationHint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the Node close to other resources. This field is for use by internal tools that use the public API. The location hint here on the NodeGroup overrides any location_hint present in the NodeTemplate.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The bytes for locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationHint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object maintenanceInterval_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @return Whether the maintenanceInterval field is set.
     */
    public boolean hasMaintenanceInterval() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @return The maintenanceInterval.
     */
    public java.lang.String getMaintenanceInterval() {
      java.lang.Object ref = maintenanceInterval_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maintenanceInterval_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @return The bytes for maintenanceInterval.
     */
    public com.google.protobuf.ByteString getMaintenanceIntervalBytes() {
      java.lang.Object ref = maintenanceInterval_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maintenanceInterval_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @param value The maintenanceInterval to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceInterval(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      maintenanceInterval_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenanceInterval() {
      maintenanceInterval_ = getDefaultInstance().getMaintenanceInterval();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
     * Check the MaintenanceInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_interval = 403368049;</code>
     *
     * @param value The bytes for maintenanceInterval to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceIntervalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      maintenanceInterval_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object maintenancePolicy_ = "";
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @return Whether the maintenancePolicy field is set.
     */
    public boolean hasMaintenancePolicy() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @return The maintenancePolicy.
     */
    public java.lang.String getMaintenancePolicy() {
      java.lang.Object ref = maintenancePolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maintenancePolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @return The bytes for maintenancePolicy.
     */
    public com.google.protobuf.ByteString getMaintenancePolicyBytes() {
      java.lang.Object ref = maintenancePolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maintenancePolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @param value The maintenancePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenancePolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      maintenancePolicy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenancePolicy() {
      maintenancePolicy_ = getDefaultInstance().getMaintenancePolicy();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
     * Check the MaintenancePolicy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string maintenance_policy = 528327646;</code>
     *
     * @param value The bytes for maintenancePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenancePolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      maintenancePolicy_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenanceWindow_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindow,
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.Builder,
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindowOrBuilder>
        maintenanceWindowBuilder_;
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     *
     * @return Whether the maintenanceWindow field is set.
     */
    public boolean hasMaintenanceWindow() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     *
     * @return The maintenanceWindow.
     */
    public com.google.cloud.compute.v1.NodeGroupMaintenanceWindow getMaintenanceWindow() {
      if (maintenanceWindowBuilder_ == null) {
        return maintenanceWindow_ == null
            ? com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.getDefaultInstance()
            : maintenanceWindow_;
      } else {
        return maintenanceWindowBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public Builder setMaintenanceWindow(
        com.google.cloud.compute.v1.NodeGroupMaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenanceWindow_ = value;
      } else {
        maintenanceWindowBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public Builder setMaintenanceWindow(
        com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.Builder builderForValue) {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindow_ = builderForValue.build();
      } else {
        maintenanceWindowBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public Builder mergeMaintenanceWindow(
        com.google.cloud.compute.v1.NodeGroupMaintenanceWindow value) {
      if (maintenanceWindowBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && maintenanceWindow_ != null
            && maintenanceWindow_
                != com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.getDefaultInstance()) {
          getMaintenanceWindowBuilder().mergeFrom(value);
        } else {
          maintenanceWindow_ = value;
        }
      } else {
        maintenanceWindowBuilder_.mergeFrom(value);
      }
      if (maintenanceWindow_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public Builder clearMaintenanceWindow() {
      bitField0_ = (bitField0_ & ~0x00000200);
      maintenanceWindow_ = null;
      if (maintenanceWindowBuilder_ != null) {
        maintenanceWindowBuilder_.dispose();
        maintenanceWindowBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.Builder
        getMaintenanceWindowBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMaintenanceWindowFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    public com.google.cloud.compute.v1.NodeGroupMaintenanceWindowOrBuilder
        getMaintenanceWindowOrBuilder() {
      if (maintenanceWindowBuilder_ != null) {
        return maintenanceWindowBuilder_.getMessageOrBuilder();
      } else {
        return maintenanceWindow_ == null
            ? com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.getDefaultInstance()
            : maintenanceWindow_;
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.NodeGroupMaintenanceWindow maintenance_window = 186374812;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindow,
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.Builder,
            com.google.cloud.compute.v1.NodeGroupMaintenanceWindowOrBuilder>
        getMaintenanceWindowFieldBuilder() {
      if (maintenanceWindowBuilder_ == null) {
        maintenanceWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NodeGroupMaintenanceWindow,
                com.google.cloud.compute.v1.NodeGroupMaintenanceWindow.Builder,
                com.google.cloud.compute.v1.NodeGroupMaintenanceWindowOrBuilder>(
                getMaintenanceWindow(), getParentForChildren(), isClean());
        maintenanceWindow_ = null;
      }
      return maintenanceWindowBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object nodeTemplate_ = "";
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @return Whether the nodeTemplate field is set.
     */
    public boolean hasNodeTemplate() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @return The nodeTemplate.
     */
    public java.lang.String getNodeTemplate() {
      java.lang.Object ref = nodeTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @return The bytes for nodeTemplate.
     */
    public com.google.protobuf.ByteString getNodeTemplateBytes() {
      java.lang.Object ref = nodeTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @param value The nodeTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setNodeTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeTemplate_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeTemplate() {
      nodeTemplate_ = getDefaultInstance().getNodeTemplate();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the node template to create the node group from.
     * </pre>
     *
     * <code>optional string node_template = 323154455;</code>
     *
     * @param value The bytes for nodeTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setNodeTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeTemplate_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ShareSettings shareSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShareSettings,
            com.google.cloud.compute.v1.ShareSettings.Builder,
            com.google.cloud.compute.v1.ShareSettingsOrBuilder>
        shareSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     *
     * @return Whether the shareSettings field is set.
     */
    public boolean hasShareSettings() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     *
     * @return The shareSettings.
     */
    public com.google.cloud.compute.v1.ShareSettings getShareSettings() {
      if (shareSettingsBuilder_ == null) {
        return shareSettings_ == null
            ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
            : shareSettings_;
      } else {
        return shareSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder setShareSettings(com.google.cloud.compute.v1.ShareSettings value) {
      if (shareSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shareSettings_ = value;
      } else {
        shareSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder setShareSettings(
        com.google.cloud.compute.v1.ShareSettings.Builder builderForValue) {
      if (shareSettingsBuilder_ == null) {
        shareSettings_ = builderForValue.build();
      } else {
        shareSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder mergeShareSettings(com.google.cloud.compute.v1.ShareSettings value) {
      if (shareSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && shareSettings_ != null
            && shareSettings_ != com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()) {
          getShareSettingsBuilder().mergeFrom(value);
        } else {
          shareSettings_ = value;
        }
      } else {
        shareSettingsBuilder_.mergeFrom(value);
      }
      if (shareSettings_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public Builder clearShareSettings() {
      bitField0_ = (bitField0_ & ~0x00002000);
      shareSettings_ = null;
      if (shareSettingsBuilder_ != null) {
        shareSettingsBuilder_.dispose();
        shareSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public com.google.cloud.compute.v1.ShareSettings.Builder getShareSettingsBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getShareSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    public com.google.cloud.compute.v1.ShareSettingsOrBuilder getShareSettingsOrBuilder() {
      if (shareSettingsBuilder_ != null) {
        return shareSettingsBuilder_.getMessageOrBuilder();
      } else {
        return shareSettings_ == null
            ? com.google.cloud.compute.v1.ShareSettings.getDefaultInstance()
            : shareSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Share-settings for the node group
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ShareSettings share_settings = 266668163;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShareSettings,
            com.google.cloud.compute.v1.ShareSettings.Builder,
            com.google.cloud.compute.v1.ShareSettingsOrBuilder>
        getShareSettingsFieldBuilder() {
      if (shareSettingsBuilder_ == null) {
        shareSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ShareSettings,
                com.google.cloud.compute.v1.ShareSettings.Builder,
                com.google.cloud.compute.v1.ShareSettingsOrBuilder>(
                getShareSettings(), getParentForChildren(), isClean());
        shareSettings_ = null;
      }
      return shareSettingsBuilder_;
    }

    private int size_;
    /**
     *
     *
     * <pre>
     * [Output Only] The total number of nodes in the node group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return Whether the size field is set.
     */
    @java.lang.Override
    public boolean hasSize() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The total number of nodes in the node group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public int getSize() {
      return size_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The total number of nodes in the node group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(int value) {

      size_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The total number of nodes in the node group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00004000);
      size_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the node group resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NodeGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NodeGroup)
  private static final com.google.cloud.compute.v1.NodeGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NodeGroup();
  }

  public static com.google.cloud.compute.v1.NodeGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeGroup> PARSER =
      new com.google.protobuf.AbstractParser<NodeGroup>() {
        @java.lang.Override
        public NodeGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NodeGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
