/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.OutlierDetection}
 */
public final class OutlierDetection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.OutlierDetection)
    OutlierDetectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OutlierDetection.newBuilder() to construct.
  private OutlierDetection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OutlierDetection() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OutlierDetection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_OutlierDetection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_OutlierDetection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.OutlierDetection.class,
            com.google.cloud.compute.v1.OutlierDetection.Builder.class);
  }

  private int bitField0_;
  public static final int BASE_EJECTION_TIME_FIELD_NUMBER = 80997255;
  private com.google.cloud.compute.v1.Duration baseEjectionTime_;
  /**
   *
   *
   * <pre>
   * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
   *
   * @return Whether the baseEjectionTime field is set.
   */
  @java.lang.Override
  public boolean hasBaseEjectionTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
   *
   * @return The baseEjectionTime.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getBaseEjectionTime() {
    return baseEjectionTime_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : baseEjectionTime_;
  }
  /**
   *
   *
   * <pre>
   * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getBaseEjectionTimeOrBuilder() {
    return baseEjectionTime_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : baseEjectionTime_;
  }

  public static final int CONSECUTIVE_ERRORS_FIELD_NUMBER = 387193248;
  private int consecutiveErrors_ = 0;
  /**
   *
   *
   * <pre>
   * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
   * </pre>
   *
   * <code>optional int32 consecutive_errors = 387193248;</code>
   *
   * @return Whether the consecutiveErrors field is set.
   */
  @java.lang.Override
  public boolean hasConsecutiveErrors() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
   * </pre>
   *
   * <code>optional int32 consecutive_errors = 387193248;</code>
   *
   * @return The consecutiveErrors.
   */
  @java.lang.Override
  public int getConsecutiveErrors() {
    return consecutiveErrors_;
  }

  public static final int CONSECUTIVE_GATEWAY_FAILURE_FIELD_NUMBER = 417504250;
  private int consecutiveGatewayFailure_ = 0;
  /**
   *
   *
   * <pre>
   * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
   * </pre>
   *
   * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
   *
   * @return Whether the consecutiveGatewayFailure field is set.
   */
  @java.lang.Override
  public boolean hasConsecutiveGatewayFailure() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
   * </pre>
   *
   * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
   *
   * @return The consecutiveGatewayFailure.
   */
  @java.lang.Override
  public int getConsecutiveGatewayFailure() {
    return consecutiveGatewayFailure_;
  }

  public static final int ENFORCING_CONSECUTIVE_ERRORS_FIELD_NUMBER = 213133760;
  private int enforcingConsecutiveErrors_ = 0;
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
   * </pre>
   *
   * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
   *
   * @return Whether the enforcingConsecutiveErrors field is set.
   */
  @java.lang.Override
  public boolean hasEnforcingConsecutiveErrors() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
   * </pre>
   *
   * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
   *
   * @return The enforcingConsecutiveErrors.
   */
  @java.lang.Override
  public int getEnforcingConsecutiveErrors() {
    return enforcingConsecutiveErrors_;
  }

  public static final int ENFORCING_CONSECUTIVE_GATEWAY_FAILURE_FIELD_NUMBER = 394440666;
  private int enforcingConsecutiveGatewayFailure_ = 0;
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
   * </pre>
   *
   * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
   *
   * @return Whether the enforcingConsecutiveGatewayFailure field is set.
   */
  @java.lang.Override
  public boolean hasEnforcingConsecutiveGatewayFailure() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
   * </pre>
   *
   * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
   *
   * @return The enforcingConsecutiveGatewayFailure.
   */
  @java.lang.Override
  public int getEnforcingConsecutiveGatewayFailure() {
    return enforcingConsecutiveGatewayFailure_;
  }

  public static final int ENFORCING_SUCCESS_RATE_FIELD_NUMBER = 194508732;
  private int enforcingSuccessRate_ = 0;
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 enforcing_success_rate = 194508732;</code>
   *
   * @return Whether the enforcingSuccessRate field is set.
   */
  @java.lang.Override
  public boolean hasEnforcingSuccessRate() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 enforcing_success_rate = 194508732;</code>
   *
   * @return The enforcingSuccessRate.
   */
  @java.lang.Override
  public int getEnforcingSuccessRate() {
    return enforcingSuccessRate_;
  }

  public static final int INTERVAL_FIELD_NUMBER = 33547461;
  private com.google.cloud.compute.v1.Duration interval_;
  /**
   *
   *
   * <pre>
   * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
   *
   * @return Whether the interval field is set.
   */
  @java.lang.Override
  public boolean hasInterval() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
   *
   * @return The interval.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getInterval() {
    return interval_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : interval_;
  }
  /**
   *
   *
   * <pre>
   * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getIntervalOrBuilder() {
    return interval_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : interval_;
  }

  public static final int MAX_EJECTION_PERCENT_FIELD_NUMBER = 18436888;
  private int maxEjectionPercent_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
   * </pre>
   *
   * <code>optional int32 max_ejection_percent = 18436888;</code>
   *
   * @return Whether the maxEjectionPercent field is set.
   */
  @java.lang.Override
  public boolean hasMaxEjectionPercent() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
   * </pre>
   *
   * <code>optional int32 max_ejection_percent = 18436888;</code>
   *
   * @return The maxEjectionPercent.
   */
  @java.lang.Override
  public int getMaxEjectionPercent() {
    return maxEjectionPercent_;
  }

  public static final int SUCCESS_RATE_MINIMUM_HOSTS_FIELD_NUMBER = 525766903;
  private int successRateMinimumHosts_ = 0;
  /**
   *
   *
   * <pre>
   * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
   *
   * @return Whether the successRateMinimumHosts field is set.
   */
  @java.lang.Override
  public boolean hasSuccessRateMinimumHosts() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
   *
   * @return The successRateMinimumHosts.
   */
  @java.lang.Override
  public int getSuccessRateMinimumHosts() {
    return successRateMinimumHosts_;
  }

  public static final int SUCCESS_RATE_REQUEST_VOLUME_FIELD_NUMBER = 281425357;
  private int successRateRequestVolume_ = 0;
  /**
   *
   *
   * <pre>
   * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_request_volume = 281425357;</code>
   *
   * @return Whether the successRateRequestVolume field is set.
   */
  @java.lang.Override
  public boolean hasSuccessRateRequestVolume() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_request_volume = 281425357;</code>
   *
   * @return The successRateRequestVolume.
   */
  @java.lang.Override
  public int getSuccessRateRequestVolume() {
    return successRateRequestVolume_;
  }

  public static final int SUCCESS_RATE_STDEV_FACTOR_FIELD_NUMBER = 174735773;
  private int successRateStdevFactor_ = 0;
  /**
   *
   *
   * <pre>
   * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
   *
   * @return Whether the successRateStdevFactor field is set.
   */
  @java.lang.Override
  public boolean hasSuccessRateStdevFactor() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
   * </pre>
   *
   * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
   *
   * @return The successRateStdevFactor.
   */
  @java.lang.Override
  public int getSuccessRateStdevFactor() {
    return successRateStdevFactor_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt32(18436888, maxEjectionPercent_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(33547461, getInterval());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(80997255, getBaseEjectionTime());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt32(174735773, successRateStdevFactor_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(194508732, enforcingSuccessRate_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(213133760, enforcingConsecutiveErrors_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt32(281425357, successRateRequestVolume_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(387193248, consecutiveErrors_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(394440666, enforcingConsecutiveGatewayFailure_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(417504250, consecutiveGatewayFailure_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt32(525766903, successRateMinimumHosts_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(18436888, maxEjectionPercent_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33547461, getInterval());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(80997255, getBaseEjectionTime());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              174735773, successRateStdevFactor_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(194508732, enforcingSuccessRate_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              213133760, enforcingConsecutiveErrors_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              281425357, successRateRequestVolume_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(387193248, consecutiveErrors_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              394440666, enforcingConsecutiveGatewayFailure_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              417504250, consecutiveGatewayFailure_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              525766903, successRateMinimumHosts_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.OutlierDetection)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.OutlierDetection other =
        (com.google.cloud.compute.v1.OutlierDetection) obj;

    if (hasBaseEjectionTime() != other.hasBaseEjectionTime()) return false;
    if (hasBaseEjectionTime()) {
      if (!getBaseEjectionTime().equals(other.getBaseEjectionTime())) return false;
    }
    if (hasConsecutiveErrors() != other.hasConsecutiveErrors()) return false;
    if (hasConsecutiveErrors()) {
      if (getConsecutiveErrors() != other.getConsecutiveErrors()) return false;
    }
    if (hasConsecutiveGatewayFailure() != other.hasConsecutiveGatewayFailure()) return false;
    if (hasConsecutiveGatewayFailure()) {
      if (getConsecutiveGatewayFailure() != other.getConsecutiveGatewayFailure()) return false;
    }
    if (hasEnforcingConsecutiveErrors() != other.hasEnforcingConsecutiveErrors()) return false;
    if (hasEnforcingConsecutiveErrors()) {
      if (getEnforcingConsecutiveErrors() != other.getEnforcingConsecutiveErrors()) return false;
    }
    if (hasEnforcingConsecutiveGatewayFailure() != other.hasEnforcingConsecutiveGatewayFailure())
      return false;
    if (hasEnforcingConsecutiveGatewayFailure()) {
      if (getEnforcingConsecutiveGatewayFailure() != other.getEnforcingConsecutiveGatewayFailure())
        return false;
    }
    if (hasEnforcingSuccessRate() != other.hasEnforcingSuccessRate()) return false;
    if (hasEnforcingSuccessRate()) {
      if (getEnforcingSuccessRate() != other.getEnforcingSuccessRate()) return false;
    }
    if (hasInterval() != other.hasInterval()) return false;
    if (hasInterval()) {
      if (!getInterval().equals(other.getInterval())) return false;
    }
    if (hasMaxEjectionPercent() != other.hasMaxEjectionPercent()) return false;
    if (hasMaxEjectionPercent()) {
      if (getMaxEjectionPercent() != other.getMaxEjectionPercent()) return false;
    }
    if (hasSuccessRateMinimumHosts() != other.hasSuccessRateMinimumHosts()) return false;
    if (hasSuccessRateMinimumHosts()) {
      if (getSuccessRateMinimumHosts() != other.getSuccessRateMinimumHosts()) return false;
    }
    if (hasSuccessRateRequestVolume() != other.hasSuccessRateRequestVolume()) return false;
    if (hasSuccessRateRequestVolume()) {
      if (getSuccessRateRequestVolume() != other.getSuccessRateRequestVolume()) return false;
    }
    if (hasSuccessRateStdevFactor() != other.hasSuccessRateStdevFactor()) return false;
    if (hasSuccessRateStdevFactor()) {
      if (getSuccessRateStdevFactor() != other.getSuccessRateStdevFactor()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBaseEjectionTime()) {
      hash = (37 * hash) + BASE_EJECTION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getBaseEjectionTime().hashCode();
    }
    if (hasConsecutiveErrors()) {
      hash = (37 * hash) + CONSECUTIVE_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getConsecutiveErrors();
    }
    if (hasConsecutiveGatewayFailure()) {
      hash = (37 * hash) + CONSECUTIVE_GATEWAY_FAILURE_FIELD_NUMBER;
      hash = (53 * hash) + getConsecutiveGatewayFailure();
    }
    if (hasEnforcingConsecutiveErrors()) {
      hash = (37 * hash) + ENFORCING_CONSECUTIVE_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getEnforcingConsecutiveErrors();
    }
    if (hasEnforcingConsecutiveGatewayFailure()) {
      hash = (37 * hash) + ENFORCING_CONSECUTIVE_GATEWAY_FAILURE_FIELD_NUMBER;
      hash = (53 * hash) + getEnforcingConsecutiveGatewayFailure();
    }
    if (hasEnforcingSuccessRate()) {
      hash = (37 * hash) + ENFORCING_SUCCESS_RATE_FIELD_NUMBER;
      hash = (53 * hash) + getEnforcingSuccessRate();
    }
    if (hasInterval()) {
      hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getInterval().hashCode();
    }
    if (hasMaxEjectionPercent()) {
      hash = (37 * hash) + MAX_EJECTION_PERCENT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxEjectionPercent();
    }
    if (hasSuccessRateMinimumHosts()) {
      hash = (37 * hash) + SUCCESS_RATE_MINIMUM_HOSTS_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessRateMinimumHosts();
    }
    if (hasSuccessRateRequestVolume()) {
      hash = (37 * hash) + SUCCESS_RATE_REQUEST_VOLUME_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessRateRequestVolume();
    }
    if (hasSuccessRateStdevFactor()) {
      hash = (37 * hash) + SUCCESS_RATE_STDEV_FACTOR_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessRateStdevFactor();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.OutlierDetection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.OutlierDetection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.OutlierDetection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.OutlierDetection)
      com.google.cloud.compute.v1.OutlierDetectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_OutlierDetection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_OutlierDetection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.OutlierDetection.class,
              com.google.cloud.compute.v1.OutlierDetection.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.OutlierDetection.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBaseEjectionTimeFieldBuilder();
        getIntervalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      baseEjectionTime_ = null;
      if (baseEjectionTimeBuilder_ != null) {
        baseEjectionTimeBuilder_.dispose();
        baseEjectionTimeBuilder_ = null;
      }
      consecutiveErrors_ = 0;
      consecutiveGatewayFailure_ = 0;
      enforcingConsecutiveErrors_ = 0;
      enforcingConsecutiveGatewayFailure_ = 0;
      enforcingSuccessRate_ = 0;
      interval_ = null;
      if (intervalBuilder_ != null) {
        intervalBuilder_.dispose();
        intervalBuilder_ = null;
      }
      maxEjectionPercent_ = 0;
      successRateMinimumHosts_ = 0;
      successRateRequestVolume_ = 0;
      successRateStdevFactor_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_OutlierDetection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.OutlierDetection getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.OutlierDetection build() {
      com.google.cloud.compute.v1.OutlierDetection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.OutlierDetection buildPartial() {
      com.google.cloud.compute.v1.OutlierDetection result =
          new com.google.cloud.compute.v1.OutlierDetection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.OutlierDetection result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.baseEjectionTime_ =
            baseEjectionTimeBuilder_ == null ? baseEjectionTime_ : baseEjectionTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.consecutiveErrors_ = consecutiveErrors_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.consecutiveGatewayFailure_ = consecutiveGatewayFailure_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enforcingConsecutiveErrors_ = enforcingConsecutiveErrors_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enforcingConsecutiveGatewayFailure_ = enforcingConsecutiveGatewayFailure_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.enforcingSuccessRate_ = enforcingSuccessRate_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.interval_ = intervalBuilder_ == null ? interval_ : intervalBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxEjectionPercent_ = maxEjectionPercent_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.successRateMinimumHosts_ = successRateMinimumHosts_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.successRateRequestVolume_ = successRateRequestVolume_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.successRateStdevFactor_ = successRateStdevFactor_;
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.OutlierDetection) {
        return mergeFrom((com.google.cloud.compute.v1.OutlierDetection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.OutlierDetection other) {
      if (other == com.google.cloud.compute.v1.OutlierDetection.getDefaultInstance()) return this;
      if (other.hasBaseEjectionTime()) {
        mergeBaseEjectionTime(other.getBaseEjectionTime());
      }
      if (other.hasConsecutiveErrors()) {
        setConsecutiveErrors(other.getConsecutiveErrors());
      }
      if (other.hasConsecutiveGatewayFailure()) {
        setConsecutiveGatewayFailure(other.getConsecutiveGatewayFailure());
      }
      if (other.hasEnforcingConsecutiveErrors()) {
        setEnforcingConsecutiveErrors(other.getEnforcingConsecutiveErrors());
      }
      if (other.hasEnforcingConsecutiveGatewayFailure()) {
        setEnforcingConsecutiveGatewayFailure(other.getEnforcingConsecutiveGatewayFailure());
      }
      if (other.hasEnforcingSuccessRate()) {
        setEnforcingSuccessRate(other.getEnforcingSuccessRate());
      }
      if (other.hasInterval()) {
        mergeInterval(other.getInterval());
      }
      if (other.hasMaxEjectionPercent()) {
        setMaxEjectionPercent(other.getMaxEjectionPercent());
      }
      if (other.hasSuccessRateMinimumHosts()) {
        setSuccessRateMinimumHosts(other.getSuccessRateMinimumHosts());
      }
      if (other.hasSuccessRateRequestVolume()) {
        setSuccessRateRequestVolume(other.getSuccessRateRequestVolume());
      }
      if (other.hasSuccessRateStdevFactor()) {
        setSuccessRateStdevFactor(other.getSuccessRateStdevFactor());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 147495104:
              {
                maxEjectionPercent_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 147495104
            case 268379690:
              {
                input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 268379690
            case 647978042:
              {
                input.readMessage(
                    getBaseEjectionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 647978042
            case 1397886184:
              {
                successRateStdevFactor_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 1397886184
            case 1556069856:
              {
                enforcingSuccessRate_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 1556069856
            case 1705070080:
              {
                enforcingConsecutiveErrors_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 1705070080
            case -2043564440:
              {
                successRateRequestVolume_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case -2043564440
            case -1197421312:
              {
                consecutiveErrors_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case -1197421312
            case -1139441968:
              {
                enforcingConsecutiveGatewayFailure_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -1139441968
            case -954933296:
              {
                consecutiveGatewayFailure_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case -954933296
            case -88832072:
              {
                successRateMinimumHosts_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case -88832072
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.Duration baseEjectionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        baseEjectionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     *
     * @return Whether the baseEjectionTime field is set.
     */
    public boolean hasBaseEjectionTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     *
     * @return The baseEjectionTime.
     */
    public com.google.cloud.compute.v1.Duration getBaseEjectionTime() {
      if (baseEjectionTimeBuilder_ == null) {
        return baseEjectionTime_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : baseEjectionTime_;
      } else {
        return baseEjectionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public Builder setBaseEjectionTime(com.google.cloud.compute.v1.Duration value) {
      if (baseEjectionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baseEjectionTime_ = value;
      } else {
        baseEjectionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public Builder setBaseEjectionTime(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (baseEjectionTimeBuilder_ == null) {
        baseEjectionTime_ = builderForValue.build();
      } else {
        baseEjectionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public Builder mergeBaseEjectionTime(com.google.cloud.compute.v1.Duration value) {
      if (baseEjectionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && baseEjectionTime_ != null
            && baseEjectionTime_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getBaseEjectionTimeBuilder().mergeFrom(value);
        } else {
          baseEjectionTime_ = value;
        }
      } else {
        baseEjectionTimeBuilder_.mergeFrom(value);
      }
      if (baseEjectionTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public Builder clearBaseEjectionTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      baseEjectionTime_ = null;
      if (baseEjectionTimeBuilder_ != null) {
        baseEjectionTimeBuilder_.dispose();
        baseEjectionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getBaseEjectionTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBaseEjectionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getBaseEjectionTimeOrBuilder() {
      if (baseEjectionTimeBuilder_ != null) {
        return baseEjectionTimeBuilder_.getMessageOrBuilder();
      } else {
        return baseEjectionTime_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : baseEjectionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The base time that a backend endpoint is ejected for. Defaults to 30000ms or 30s. After a backend endpoint is returned back to the load balancing pool, it can be ejected again in another ejection analysis. Thus, the total ejection time is equal to the base ejection time multiplied by the number of times the backend endpoint has been ejected. Defaults to 30000ms or 30s.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration base_ejection_time = 80997255;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getBaseEjectionTimeFieldBuilder() {
      if (baseEjectionTimeBuilder_ == null) {
        baseEjectionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getBaseEjectionTime(), getParentForChildren(), isClean());
        baseEjectionTime_ = null;
      }
      return baseEjectionTimeBuilder_;
    }

    private int consecutiveErrors_;
    /**
     *
     *
     * <pre>
     * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
     * </pre>
     *
     * <code>optional int32 consecutive_errors = 387193248;</code>
     *
     * @return Whether the consecutiveErrors field is set.
     */
    @java.lang.Override
    public boolean hasConsecutiveErrors() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
     * </pre>
     *
     * <code>optional int32 consecutive_errors = 387193248;</code>
     *
     * @return The consecutiveErrors.
     */
    @java.lang.Override
    public int getConsecutiveErrors() {
      return consecutiveErrors_;
    }
    /**
     *
     *
     * <pre>
     * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
     * </pre>
     *
     * <code>optional int32 consecutive_errors = 387193248;</code>
     *
     * @param value The consecutiveErrors to set.
     * @return This builder for chaining.
     */
    public Builder setConsecutiveErrors(int value) {

      consecutiveErrors_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of consecutive errors before a backend endpoint is ejected from the load balancing pool. When the backend endpoint is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
     * </pre>
     *
     * <code>optional int32 consecutive_errors = 387193248;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsecutiveErrors() {
      bitField0_ = (bitField0_ & ~0x00000002);
      consecutiveErrors_ = 0;
      onChanged();
      return this;
    }

    private int consecutiveGatewayFailure_;
    /**
     *
     *
     * <pre>
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
     * </pre>
     *
     * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
     *
     * @return Whether the consecutiveGatewayFailure field is set.
     */
    @java.lang.Override
    public boolean hasConsecutiveGatewayFailure() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
     * </pre>
     *
     * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
     *
     * @return The consecutiveGatewayFailure.
     */
    @java.lang.Override
    public int getConsecutiveGatewayFailure() {
      return consecutiveGatewayFailure_;
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
     * </pre>
     *
     * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
     *
     * @param value The consecutiveGatewayFailure to set.
     * @return This builder for chaining.
     */
    public Builder setConsecutiveGatewayFailure(int value) {

      consecutiveGatewayFailure_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
     * </pre>
     *
     * <code>optional int32 consecutive_gateway_failure = 417504250;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsecutiveGatewayFailure() {
      bitField0_ = (bitField0_ & ~0x00000004);
      consecutiveGatewayFailure_ = 0;
      onChanged();
      return this;
    }

    private int enforcingConsecutiveErrors_;
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
     *
     * @return Whether the enforcingConsecutiveErrors field is set.
     */
    @java.lang.Override
    public boolean hasEnforcingConsecutiveErrors() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
     *
     * @return The enforcingConsecutiveErrors.
     */
    @java.lang.Override
    public int getEnforcingConsecutiveErrors() {
      return enforcingConsecutiveErrors_;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
     *
     * @param value The enforcingConsecutiveErrors to set.
     * @return This builder for chaining.
     */
    public Builder setEnforcingConsecutiveErrors(int value) {

      enforcingConsecutiveErrors_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_errors = 213133760;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforcingConsecutiveErrors() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enforcingConsecutiveErrors_ = 0;
      onChanged();
      return this;
    }

    private int enforcingConsecutiveGatewayFailure_;
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
     *
     * @return Whether the enforcingConsecutiveGatewayFailure field is set.
     */
    @java.lang.Override
    public boolean hasEnforcingConsecutiveGatewayFailure() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
     *
     * @return The enforcingConsecutiveGatewayFailure.
     */
    @java.lang.Override
    public int getEnforcingConsecutiveGatewayFailure() {
      return enforcingConsecutiveGatewayFailure_;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
     *
     * @param value The enforcingConsecutiveGatewayFailure to set.
     * @return This builder for chaining.
     */
    public Builder setEnforcingConsecutiveGatewayFailure(int value) {

      enforcingConsecutiveGatewayFailure_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
     * </pre>
     *
     * <code>optional int32 enforcing_consecutive_gateway_failure = 394440666;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforcingConsecutiveGatewayFailure() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enforcingConsecutiveGatewayFailure_ = 0;
      onChanged();
      return this;
    }

    private int enforcingSuccessRate_;
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 enforcing_success_rate = 194508732;</code>
     *
     * @return Whether the enforcingSuccessRate field is set.
     */
    @java.lang.Override
    public boolean hasEnforcingSuccessRate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 enforcing_success_rate = 194508732;</code>
     *
     * @return The enforcingSuccessRate.
     */
    @java.lang.Override
    public int getEnforcingSuccessRate() {
      return enforcingSuccessRate_;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 enforcing_success_rate = 194508732;</code>
     *
     * @param value The enforcingSuccessRate to set.
     * @return This builder for chaining.
     */
    public Builder setEnforcingSuccessRate(int value) {

      enforcingSuccessRate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percentage chance that a backend endpoint will be ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 enforcing_success_rate = 194508732;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforcingSuccessRate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      enforcingSuccessRate_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration interval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        intervalBuilder_;
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     *
     * @return Whether the interval field is set.
     */
    public boolean hasInterval() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     *
     * @return The interval.
     */
    public com.google.cloud.compute.v1.Duration getInterval() {
      if (intervalBuilder_ == null) {
        return interval_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : interval_;
      } else {
        return intervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public Builder setInterval(com.google.cloud.compute.v1.Duration value) {
      if (intervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        interval_ = value;
      } else {
        intervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public Builder setInterval(com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (intervalBuilder_ == null) {
        interval_ = builderForValue.build();
      } else {
        intervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public Builder mergeInterval(com.google.cloud.compute.v1.Duration value) {
      if (intervalBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && interval_ != null
            && interval_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getIntervalBuilder().mergeFrom(value);
        } else {
          interval_ = value;
        }
      } else {
        intervalBuilder_.mergeFrom(value);
      }
      if (interval_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public Builder clearInterval() {
      bitField0_ = (bitField0_ & ~0x00000040);
      interval_ = null;
      if (intervalBuilder_ != null) {
        intervalBuilder_.dispose();
        intervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getIntervalBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getIntervalOrBuilder() {
      if (intervalBuilder_ != null) {
        return intervalBuilder_.getMessageOrBuilder();
      } else {
        return interval_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : interval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time interval between ejection analysis sweeps. This can result in both new ejections and backend endpoints being returned to service. The interval is equal to the number of seconds as defined in outlierDetection.interval.seconds plus the number of nanoseconds as defined in outlierDetection.interval.nanos. Defaults to 1 second.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration interval = 33547461;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getIntervalFieldBuilder() {
      if (intervalBuilder_ == null) {
        intervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getInterval(), getParentForChildren(), isClean());
        interval_ = null;
      }
      return intervalBuilder_;
    }

    private int maxEjectionPercent_;
    /**
     *
     *
     * <pre>
     * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
     * </pre>
     *
     * <code>optional int32 max_ejection_percent = 18436888;</code>
     *
     * @return Whether the maxEjectionPercent field is set.
     */
    @java.lang.Override
    public boolean hasMaxEjectionPercent() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
     * </pre>
     *
     * <code>optional int32 max_ejection_percent = 18436888;</code>
     *
     * @return The maxEjectionPercent.
     */
    @java.lang.Override
    public int getMaxEjectionPercent() {
      return maxEjectionPercent_;
    }
    /**
     *
     *
     * <pre>
     * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
     * </pre>
     *
     * <code>optional int32 max_ejection_percent = 18436888;</code>
     *
     * @param value The maxEjectionPercent to set.
     * @return This builder for chaining.
     */
    public Builder setMaxEjectionPercent(int value) {

      maxEjectionPercent_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum percentage of backend endpoints in the load balancing pool for the backend service that can be ejected if the ejection conditions are met. Defaults to 50%.
     * </pre>
     *
     * <code>optional int32 max_ejection_percent = 18436888;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxEjectionPercent() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxEjectionPercent_ = 0;
      onChanged();
      return this;
    }

    private int successRateMinimumHosts_;
    /**
     *
     *
     * <pre>
     * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
     *
     * @return Whether the successRateMinimumHosts field is set.
     */
    @java.lang.Override
    public boolean hasSuccessRateMinimumHosts() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
     *
     * @return The successRateMinimumHosts.
     */
    @java.lang.Override
    public int getSuccessRateMinimumHosts() {
      return successRateMinimumHosts_;
    }
    /**
     *
     *
     * <pre>
     * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
     *
     * @param value The successRateMinimumHosts to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessRateMinimumHosts(int value) {

      successRateMinimumHosts_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of backend endpoints in the load balancing pool that must have enough request volume to detect success rate outliers. If the number of backend endpoints is fewer than this setting, outlier detection via success rate statistics is not performed for any backend endpoint in the load balancing pool. Defaults to 5. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_minimum_hosts = 525766903;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessRateMinimumHosts() {
      bitField0_ = (bitField0_ & ~0x00000100);
      successRateMinimumHosts_ = 0;
      onChanged();
      return this;
    }

    private int successRateRequestVolume_;
    /**
     *
     *
     * <pre>
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_request_volume = 281425357;</code>
     *
     * @return Whether the successRateRequestVolume field is set.
     */
    @java.lang.Override
    public boolean hasSuccessRateRequestVolume() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_request_volume = 281425357;</code>
     *
     * @return The successRateRequestVolume.
     */
    @java.lang.Override
    public int getSuccessRateRequestVolume() {
      return successRateRequestVolume_;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_request_volume = 281425357;</code>
     *
     * @param value The successRateRequestVolume to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessRateRequestVolume(int value) {

      successRateRequestVolume_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this backend endpoint in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that backend endpoint. Defaults to 100. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_request_volume = 281425357;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessRateRequestVolume() {
      bitField0_ = (bitField0_ & ~0x00000200);
      successRateRequestVolume_ = 0;
      onChanged();
      return this;
    }

    private int successRateStdevFactor_;
    /**
     *
     *
     * <pre>
     * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
     *
     * @return Whether the successRateStdevFactor field is set.
     */
    @java.lang.Override
    public boolean hasSuccessRateStdevFactor() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
     *
     * @return The successRateStdevFactor.
     */
    @java.lang.Override
    public int getSuccessRateStdevFactor() {
      return successRateStdevFactor_;
    }
    /**
     *
     *
     * <pre>
     * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
     *
     * @param value The successRateStdevFactor to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessRateStdevFactor(int value) {

      successRateStdevFactor_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * successRateStdevFactor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900. Not supported when the backend service uses Serverless NEG.
     * </pre>
     *
     * <code>optional int32 success_rate_stdev_factor = 174735773;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessRateStdevFactor() {
      bitField0_ = (bitField0_ & ~0x00000400);
      successRateStdevFactor_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.OutlierDetection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.OutlierDetection)
  private static final com.google.cloud.compute.v1.OutlierDetection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.OutlierDetection();
  }

  public static com.google.cloud.compute.v1.OutlierDetection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OutlierDetection> PARSER =
      new com.google.protobuf.AbstractParser<OutlierDetection>() {
        @java.lang.Override
        public OutlierDetection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OutlierDetection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OutlierDetection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.OutlierDetection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
