/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PacketMirroringFilter}
 */
public final class PacketMirroringFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PacketMirroringFilter)
    PacketMirroringFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PacketMirroringFilter.newBuilder() to construct.
  private PacketMirroringFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PacketMirroringFilter() {
    iPProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
    cidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    direction_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PacketMirroringFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketMirroringFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketMirroringFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PacketMirroringFilter.class,
            com.google.cloud.compute.v1.PacketMirroringFilter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PacketMirroringFilter.Direction}
   */
  public enum Direction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    UNDEFINED_DIRECTION(0),
    /**
     *
     *
     * <pre>
     * Default, both directions are mirrored.
     * </pre>
     *
     * <code>BOTH = 2044801;</code>
     */
    BOTH(2044801),
    /**
     *
     *
     * <pre>
     * Only egress traffic is mirrored.
     * </pre>
     *
     * <code>EGRESS = 432880501;</code>
     */
    EGRESS(432880501),
    /**
     *
     *
     * <pre>
     * Only ingress traffic is mirrored.
     * </pre>
     *
     * <code>INGRESS = 516931221;</code>
     */
    INGRESS(516931221),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    public static final int UNDEFINED_DIRECTION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default, both directions are mirrored.
     * </pre>
     *
     * <code>BOTH = 2044801;</code>
     */
    public static final int BOTH_VALUE = 2044801;
    /**
     *
     *
     * <pre>
     * Only egress traffic is mirrored.
     * </pre>
     *
     * <code>EGRESS = 432880501;</code>
     */
    public static final int EGRESS_VALUE = 432880501;
    /**
     *
     *
     * <pre>
     * Only ingress traffic is mirrored.
     * </pre>
     *
     * <code>INGRESS = 516931221;</code>
     */
    public static final int INGRESS_VALUE = 516931221;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Direction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Direction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DIRECTION;
        case 2044801:
          return BOTH;
        case 432880501:
          return EGRESS;
        case 516931221:
          return INGRESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Direction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Direction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
          public Direction findValueByNumber(int number) {
            return Direction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PacketMirroringFilter.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Direction[] VALUES = values();

    public static Direction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Direction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PacketMirroringFilter.Direction)
  }

  private int bitField0_;
  public static final int I_P_PROTOCOLS_FIELD_NUMBER = 98544854;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList iPProtocols_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
   * </pre>
   *
   * <code>repeated string I_p_protocols = 98544854;</code>
   *
   * @return A list containing the iPProtocols.
   */
  public com.google.protobuf.ProtocolStringList getIPProtocolsList() {
    return iPProtocols_;
  }
  /**
   *
   *
   * <pre>
   * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
   * </pre>
   *
   * <code>repeated string I_p_protocols = 98544854;</code>
   *
   * @return The count of iPProtocols.
   */
  public int getIPProtocolsCount() {
    return iPProtocols_.size();
  }
  /**
   *
   *
   * <pre>
   * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
   * </pre>
   *
   * <code>repeated string I_p_protocols = 98544854;</code>
   *
   * @param index The index of the element to return.
   * @return The iPProtocols at the given index.
   */
  public java.lang.String getIPProtocols(int index) {
    return iPProtocols_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
   * </pre>
   *
   * <code>repeated string I_p_protocols = 98544854;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the iPProtocols at the given index.
   */
  public com.google.protobuf.ByteString getIPProtocolsBytes(int index) {
    return iPProtocols_.getByteString(index);
  }

  public static final int CIDR_RANGES_FIELD_NUMBER = 487901697;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList cidrRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
   * </pre>
   *
   * <code>repeated string cidr_ranges = 487901697;</code>
   *
   * @return A list containing the cidrRanges.
   */
  public com.google.protobuf.ProtocolStringList getCidrRangesList() {
    return cidrRanges_;
  }
  /**
   *
   *
   * <pre>
   * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
   * </pre>
   *
   * <code>repeated string cidr_ranges = 487901697;</code>
   *
   * @return The count of cidrRanges.
   */
  public int getCidrRangesCount() {
    return cidrRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
   * </pre>
   *
   * <code>repeated string cidr_ranges = 487901697;</code>
   *
   * @param index The index of the element to return.
   * @return The cidrRanges at the given index.
   */
  public java.lang.String getCidrRanges(int index) {
    return cidrRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
   * </pre>
   *
   * <code>repeated string cidr_ranges = 487901697;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the cidrRanges at the given index.
   */
  public com.google.protobuf.ByteString getCidrRangesBytes(int index) {
    return cidrRanges_.getByteString(index);
  }

  public static final int DIRECTION_FIELD_NUMBER = 111150975;

  @SuppressWarnings("serial")
  private volatile java.lang.Object direction_ = "";
  /**
   *
   *
   * <pre>
   * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return Whether the direction field is set.
   */
  @java.lang.Override
  public boolean hasDirection() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The direction.
   */
  @java.lang.Override
  public java.lang.String getDirection() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      direction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The bytes for direction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirectionBytes() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      direction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < iPProtocols_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 98544854, iPProtocols_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 111150975, direction_);
    }
    for (int i = 0; i < cidrRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 487901697, cidrRanges_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < iPProtocols_.size(); i++) {
        dataSize += computeStringSizeNoTag(iPProtocols_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getIPProtocolsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(111150975, direction_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < cidrRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(cidrRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCidrRangesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PacketMirroringFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PacketMirroringFilter other =
        (com.google.cloud.compute.v1.PacketMirroringFilter) obj;

    if (!getIPProtocolsList().equals(other.getIPProtocolsList())) return false;
    if (!getCidrRangesList().equals(other.getCidrRangesList())) return false;
    if (hasDirection() != other.hasDirection()) return false;
    if (hasDirection()) {
      if (!getDirection().equals(other.getDirection())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIPProtocolsCount() > 0) {
      hash = (37 * hash) + I_P_PROTOCOLS_FIELD_NUMBER;
      hash = (53 * hash) + getIPProtocolsList().hashCode();
    }
    if (getCidrRangesCount() > 0) {
      hash = (37 * hash) + CIDR_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getCidrRangesList().hashCode();
    }
    if (hasDirection()) {
      hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
      hash = (53 * hash) + getDirection().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PacketMirroringFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PacketMirroringFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PacketMirroringFilter)
      com.google.cloud.compute.v1.PacketMirroringFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PacketMirroringFilter.class,
              com.google.cloud.compute.v1.PacketMirroringFilter.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PacketMirroringFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      iPProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      cidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      direction_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringFilter getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PacketMirroringFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringFilter build() {
      com.google.cloud.compute.v1.PacketMirroringFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringFilter buildPartial() {
      com.google.cloud.compute.v1.PacketMirroringFilter result =
          new com.google.cloud.compute.v1.PacketMirroringFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.PacketMirroringFilter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        iPProtocols_.makeImmutable();
        result.iPProtocols_ = iPProtocols_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        cidrRanges_.makeImmutable();
        result.cidrRanges_ = cidrRanges_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.direction_ = direction_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PacketMirroringFilter) {
        return mergeFrom((com.google.cloud.compute.v1.PacketMirroringFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PacketMirroringFilter other) {
      if (other == com.google.cloud.compute.v1.PacketMirroringFilter.getDefaultInstance())
        return this;
      if (!other.iPProtocols_.isEmpty()) {
        if (iPProtocols_.isEmpty()) {
          iPProtocols_ = other.iPProtocols_;
          bitField0_ |= 0x00000001;
        } else {
          ensureIPProtocolsIsMutable();
          iPProtocols_.addAll(other.iPProtocols_);
        }
        onChanged();
      }
      if (!other.cidrRanges_.isEmpty()) {
        if (cidrRanges_.isEmpty()) {
          cidrRanges_ = other.cidrRanges_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCidrRangesIsMutable();
          cidrRanges_.addAll(other.cidrRanges_);
        }
        onChanged();
      }
      if (other.hasDirection()) {
        direction_ = other.direction_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 788358834:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIPProtocolsIsMutable();
                iPProtocols_.add(s);
                break;
              } // case 788358834
            case 889207802:
              {
                direction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 889207802
            case -391753718:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCidrRangesIsMutable();
                cidrRanges_.add(s);
                break;
              } // case -391753718
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList iPProtocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIPProtocolsIsMutable() {
      if (!iPProtocols_.isModifiable()) {
        iPProtocols_ = new com.google.protobuf.LazyStringArrayList(iPProtocols_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @return A list containing the iPProtocols.
     */
    public com.google.protobuf.ProtocolStringList getIPProtocolsList() {
      iPProtocols_.makeImmutable();
      return iPProtocols_;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @return The count of iPProtocols.
     */
    public int getIPProtocolsCount() {
      return iPProtocols_.size();
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param index The index of the element to return.
     * @return The iPProtocols at the given index.
     */
    public java.lang.String getIPProtocols(int index) {
      return iPProtocols_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the iPProtocols at the given index.
     */
    public com.google.protobuf.ByteString getIPProtocolsBytes(int index) {
      return iPProtocols_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param index The index to set the value at.
     * @param value The iPProtocols to set.
     * @return This builder for chaining.
     */
    public Builder setIPProtocols(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIPProtocolsIsMutable();
      iPProtocols_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param value The iPProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addIPProtocols(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIPProtocolsIsMutable();
      iPProtocols_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param values The iPProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addAllIPProtocols(java.lang.Iterable<java.lang.String> values) {
      ensureIPProtocolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, iPProtocols_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIPProtocols() {
      iPProtocols_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Protocols that apply as filter on mirrored traffic. If no protocols are specified, all traffic that matches the specified CIDR ranges is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored.
     * </pre>
     *
     * <code>repeated string I_p_protocols = 98544854;</code>
     *
     * @param value The bytes of the iPProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addIPProtocolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIPProtocolsIsMutable();
      iPProtocols_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList cidrRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCidrRangesIsMutable() {
      if (!cidrRanges_.isModifiable()) {
        cidrRanges_ = new com.google.protobuf.LazyStringArrayList(cidrRanges_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @return A list containing the cidrRanges.
     */
    public com.google.protobuf.ProtocolStringList getCidrRangesList() {
      cidrRanges_.makeImmutable();
      return cidrRanges_;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @return The count of cidrRanges.
     */
    public int getCidrRangesCount() {
      return cidrRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param index The index of the element to return.
     * @return The cidrRanges at the given index.
     */
    public java.lang.String getCidrRanges(int index) {
      return cidrRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the cidrRanges at the given index.
     */
    public com.google.protobuf.ByteString getCidrRangesBytes(int index) {
      return cidrRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param index The index to set the value at.
     * @param value The cidrRanges to set.
     * @return This builder for chaining.
     */
    public Builder setCidrRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCidrRangesIsMutable();
      cidrRanges_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param value The cidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addCidrRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCidrRangesIsMutable();
      cidrRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param values The cidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllCidrRanges(java.lang.Iterable<java.lang.String> values) {
      ensureCidrRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cidrRanges_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCidrRanges() {
      cidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more IPv4 or IPv6 CIDR ranges that apply as filters on the source (ingress) or destination (egress) IP in the IP header. If no ranges are specified, all IPv4 traffic that matches the specified IPProtocols is mirrored. If neither cidrRanges nor IPProtocols is specified, all IPv4 traffic is mirrored. To mirror all IPv4 and IPv6 traffic, use "0.0.0.0/0,::/0".
     * </pre>
     *
     * <code>repeated string cidr_ranges = 487901697;</code>
     *
     * @param value The bytes of the cidrRanges to add.
     * @return This builder for chaining.
     */
    public Builder addCidrRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCidrRangesIsMutable();
      cidrRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object direction_ = "";
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return Whether the direction field is set.
     */
    public boolean hasDirection() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The direction.
     */
    public java.lang.String getDirection() {
      java.lang.Object ref = direction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        direction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The bytes for direction.
     */
    public com.google.protobuf.ByteString getDirectionBytes() {
      java.lang.Object ref = direction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        direction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirection(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirection() {
      direction_ = getDefaultInstance().getDirection();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The bytes for direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirectionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PacketMirroringFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PacketMirroringFilter)
  private static final com.google.cloud.compute.v1.PacketMirroringFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PacketMirroringFilter();
  }

  public static com.google.cloud.compute.v1.PacketMirroringFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PacketMirroringFilter> PARSER =
      new com.google.protobuf.AbstractParser<PacketMirroringFilter>() {
        @java.lang.Override
        public PacketMirroringFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PacketMirroringFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PacketMirroringFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
