/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PacketMirroringMirroredResourceInfo}
 */
public final class PacketMirroringMirroredResourceInfo
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PacketMirroringMirroredResourceInfo)
    PacketMirroringMirroredResourceInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PacketMirroringMirroredResourceInfo.newBuilder() to construct.
  private PacketMirroringMirroredResourceInfo(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PacketMirroringMirroredResourceInfo() {
    instances_ = java.util.Collections.emptyList();
    subnetworks_ = java.util.Collections.emptyList();
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PacketMirroringMirroredResourceInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketMirroringMirroredResourceInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketMirroringMirroredResourceInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.class,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.Builder.class);
  }

  public static final int INSTANCES_FIELD_NUMBER = 29097598;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>
      instances_;
  /**
   *
   *
   * <pre>
   * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>
      getInstancesList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder>
      getInstancesOrBuilderList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
   * </code>
   */
  @java.lang.Override
  public int getInstancesCount() {
    return instances_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo getInstances(
      int index) {
    return instances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder
      getInstancesOrBuilder(int index) {
    return instances_.get(index);
  }

  public static final int SUBNETWORKS_FIELD_NUMBER = 415853125;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>
      subnetworks_;
  /**
   *
   *
   * <pre>
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>
      getSubnetworksList() {
    return subnetworks_;
  }
  /**
   *
   *
   * <pre>
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder>
      getSubnetworksOrBuilderList() {
    return subnetworks_;
  }
  /**
   *
   *
   * <pre>
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public int getSubnetworksCount() {
    return subnetworks_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo getSubnetworks(
      int index) {
    return subnetworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder
      getSubnetworksOrBuilder(int index) {
    return subnetworks_.get(index);
  }

  public static final int TAGS_FIELD_NUMBER = 3552281;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3552281, tags_.getRaw(i));
    }
    for (int i = 0; i < instances_.size(); i++) {
      output.writeMessage(29097598, instances_.get(i));
    }
    for (int i = 0; i < subnetworks_.size(); i++) {
      output.writeMessage(415853125, subnetworks_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getTagsList().size();
    }
    for (int i = 0; i < instances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29097598, instances_.get(i));
    }
    for (int i = 0; i < subnetworks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(415853125, subnetworks_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo other =
        (com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo) obj;

    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (!getSubnetworksList().equals(other.getSubnetworksList())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (getSubnetworksCount() > 0) {
      hash = (37 * hash) + SUBNETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetworksList().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PacketMirroringMirroredResourceInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PacketMirroringMirroredResourceInfo)
      com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringMirroredResourceInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringMirroredResourceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.class,
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
      } else {
        instances_ = null;
        instancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (subnetworksBuilder_ == null) {
        subnetworks_ = java.util.Collections.emptyList();
      } else {
        subnetworks_ = null;
        subnetworksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketMirroringMirroredResourceInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo build() {
      com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo buildPartial() {
      com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo result =
          new com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo result) {
      if (instancesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          instances_ = java.util.Collections.unmodifiableList(instances_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.instances_ = instances_;
      } else {
        result.instances_ = instancesBuilder_.build();
      }
      if (subnetworksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          subnetworks_ = java.util.Collections.unmodifiableList(subnetworks_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.subnetworks_ = subnetworks_;
      } else {
        result.subnetworks_ = subnetworksBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo) {
        return mergeFrom((com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo other) {
      if (other
          == com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo.getDefaultInstance())
        return this;
      if (instancesBuilder_ == null) {
        if (!other.instances_.isEmpty()) {
          if (instances_.isEmpty()) {
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInstancesIsMutable();
            instances_.addAll(other.instances_);
          }
          onChanged();
        }
      } else {
        if (!other.instances_.isEmpty()) {
          if (instancesBuilder_.isEmpty()) {
            instancesBuilder_.dispose();
            instancesBuilder_ = null;
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
            instancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstancesFieldBuilder()
                    : null;
          } else {
            instancesBuilder_.addAllMessages(other.instances_);
          }
        }
      }
      if (subnetworksBuilder_ == null) {
        if (!other.subnetworks_.isEmpty()) {
          if (subnetworks_.isEmpty()) {
            subnetworks_ = other.subnetworks_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSubnetworksIsMutable();
            subnetworks_.addAll(other.subnetworks_);
          }
          onChanged();
        }
      } else {
        if (!other.subnetworks_.isEmpty()) {
          if (subnetworksBuilder_.isEmpty()) {
            subnetworksBuilder_.dispose();
            subnetworksBuilder_ = null;
            subnetworks_ = other.subnetworks_;
            bitField0_ = (bitField0_ & ~0x00000002);
            subnetworksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSubnetworksFieldBuilder()
                    : null;
          } else {
            subnetworksBuilder_.addAllMessages(other.subnetworks_);
          }
        }
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28418250:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 28418250
            case 232780786:
              {
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo
                            .parser(),
                        extensionRegistry);
                if (instancesBuilder_ == null) {
                  ensureInstancesIsMutable();
                  instances_.add(m);
                } else {
                  instancesBuilder_.addMessage(m);
                }
                break;
              } // case 232780786
            case -968142294:
              {
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo
                            .parser(),
                        extensionRegistry);
                if (subnetworksBuilder_ == null) {
                  ensureSubnetworksIsMutable();
                  subnetworks_.add(m);
                } else {
                  subnetworksBuilder_.addMessage(m);
                }
                break;
              } // case -968142294
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>
        instances_ = java.util.Collections.emptyList();

    private void ensureInstancesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        instances_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>(
                instances_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder>
        instancesBuilder_;

    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>
        getInstancesList() {
      if (instancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instances_);
      } else {
        return instancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public int getInstancesCount() {
      if (instancesBuilder_ == null) {
        return instances_.size();
      } else {
        return instancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo getInstances(
        int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder setInstances(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.set(index, value);
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder setInstances(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.set(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder addInstances(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder addInstances(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(index, value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder addInstances(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder addInstances(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder addAllInstances(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo>
            values) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
        onChanged();
      } else {
        instancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder clearInstances() {
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        instancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public Builder removeInstances(int index) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.remove(index);
        onChanged();
      } else {
        instancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
        getInstancesBuilder(int index) {
      return getInstancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder
        getInstancesOrBuilder(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder>
        getInstancesOrBuilderList() {
      if (instancesBuilder_ != null) {
        return instancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instances_);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
        addInstancesBuilder() {
      return getInstancesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder
        addInstancesBuilder(int index) {
      return getInstancesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of virtual machine instances that are being mirrored. They must live in zones contained in the same region as this packetMirroring. Note that this config will apply only to those network interfaces of the Instances that belong to the network specified in this packetMirroring. You may specify a maximum of 50 Instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo instances = 29097598;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder>
        getInstancesBuilderList() {
      return getInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder>
        getInstancesFieldBuilder() {
      if (instancesBuilder_ == null) {
        instancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo,
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoInstanceInfo.Builder,
                com.google.cloud.compute.v1
                    .PacketMirroringMirroredResourceInfoInstanceInfoOrBuilder>(
                instances_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        instances_ = null;
      }
      return instancesBuilder_;
    }

    private java.util.List<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>
        subnetworks_ = java.util.Collections.emptyList();

    private void ensureSubnetworksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        subnetworks_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>(
                subnetworks_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder>
        subnetworksBuilder_;

    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>
        getSubnetworksList() {
      if (subnetworksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(subnetworks_);
      } else {
        return subnetworksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public int getSubnetworksCount() {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.size();
      } else {
        return subnetworksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo getSubnetworks(
        int index) {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.get(index);
      } else {
        return subnetworksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder setSubnetworks(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.set(index, value);
        onChanged();
      } else {
        subnetworksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder setSubnetworks(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
            builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.set(index, builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.add(value);
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.add(index, value);
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
            builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.add(builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        int index,
        com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
            builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.add(index, builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder addAllSubnetworks(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo>
            values) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subnetworks_);
        onChanged();
      } else {
        subnetworksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder clearSubnetworks() {
      if (subnetworksBuilder_ == null) {
        subnetworks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        subnetworksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public Builder removeSubnetworks(int index) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.remove(index);
        onChanged();
      } else {
        subnetworksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
        getSubnetworksBuilder(int index) {
      return getSubnetworksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder
        getSubnetworksOrBuilder(int index) {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.get(index);
      } else {
        return subnetworksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder>
        getSubnetworksOrBuilderList() {
      if (subnetworksBuilder_ != null) {
        return subnetworksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(subnetworks_);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
        addSubnetworksBuilder() {
      return getSubnetworksFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder
        addSubnetworksBuilder(int index) {
      return getSubnetworksFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of subnetworks for which traffic from/to all VM instances will be mirrored. They must live in the same region as this packetMirroring. You may specify a maximum of 5 subnetworks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo subnetworks = 415853125;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder>
        getSubnetworksBuilderList() {
      return getSubnetworksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder,
            com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder>
        getSubnetworksFieldBuilder() {
      if (subnetworksBuilder_ == null) {
        subnetworksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo,
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfo.Builder,
                com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfoSubnetInfoOrBuilder>(
                subnetworks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        subnetworks_ = null;
      }
      return subnetworksBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of mirrored tags. Traffic from/to all VM instances that have one or more of these tags will be mirrored.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PacketMirroringMirroredResourceInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PacketMirroringMirroredResourceInfo)
  private static final com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo();
  }

  public static com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PacketMirroringMirroredResourceInfo> PARSER =
      new com.google.protobuf.AbstractParser<PacketMirroringMirroredResourceInfo>() {
        @java.lang.Override
        public PacketMirroringMirroredResourceInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PacketMirroringMirroredResourceInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PacketMirroringMirroredResourceInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PacketMirroringMirroredResourceInfo
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
