/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PathMatcher}
 */
public final class PathMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PathMatcher)
    PathMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PathMatcher.newBuilder() to construct.
  private PathMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PathMatcher() {
    defaultService_ = "";
    description_ = "";
    name_ = "";
    pathRules_ = java.util.Collections.emptyList();
    routeRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PathMatcher();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PathMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PathMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PathMatcher.class,
            com.google.cloud.compute.v1.PathMatcher.Builder.class);
  }

  private int bitField0_;
  public static final int DEFAULT_ROUTE_ACTION_FIELD_NUMBER = 378919466;
  private com.google.cloud.compute.v1.HttpRouteAction defaultRouteAction_;
  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   *
   * @return Whether the defaultRouteAction field is set.
   */
  @java.lang.Override
  public boolean hasDefaultRouteAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   *
   * @return The defaultRouteAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteAction getDefaultRouteAction() {
    return defaultRouteAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : defaultRouteAction_;
  }
  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getDefaultRouteActionOrBuilder() {
    return defaultRouteAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : defaultRouteAction_;
  }

  public static final int DEFAULT_SERVICE_FIELD_NUMBER = 370242231;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultService_ = "";
  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return Whether the defaultService field is set.
   */
  @java.lang.Override
  public boolean hasDefaultService() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return The defaultService.
   */
  @java.lang.Override
  public java.lang.String getDefaultService() {
    java.lang.Object ref = defaultService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return The bytes for defaultService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultServiceBytes() {
    java.lang.Object ref = defaultService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_URL_REDIRECT_FIELD_NUMBER = 359503338;
  private com.google.cloud.compute.v1.HttpRedirectAction defaultUrlRedirect_;
  /**
   *
   *
   * <pre>
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   *
   * @return Whether the defaultUrlRedirect field is set.
   */
  @java.lang.Override
  public boolean hasDefaultUrlRedirect() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   *
   * @return The defaultUrlRedirect.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectAction getDefaultUrlRedirect() {
    return defaultUrlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : defaultUrlRedirect_;
  }
  /**
   *
   *
   * <pre>
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getDefaultUrlRedirectOrBuilder() {
    return defaultUrlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : defaultUrlRedirect_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_ACTION_FIELD_NUMBER = 328077352;
  private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return Whether the headerAction field is set.
   */
  @java.lang.Override
  public boolean hasHeaderAction() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return The headerAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name to which this PathMatcher is referred by the HostRule.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name to which this PathMatcher is referred by the HostRule.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name to which this PathMatcher is referred by the HostRule.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH_RULES_FIELD_NUMBER = 104439901;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PathRule> pathRules_;
  /**
   *
   *
   * <pre>
   * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PathRule> getPathRulesList() {
    return pathRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.PathRuleOrBuilder>
      getPathRulesOrBuilderList() {
    return pathRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
   */
  @java.lang.Override
  public int getPathRulesCount() {
    return pathRules_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PathRule getPathRules(int index) {
    return pathRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PathRuleOrBuilder getPathRulesOrBuilder(int index) {
    return pathRules_.get(index);
  }

  public static final int ROUTE_RULES_FIELD_NUMBER = 376292225;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpRouteRule> routeRules_;
  /**
   *
   *
   * <pre>
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpRouteRule> getRouteRulesList() {
    return routeRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpRouteRuleOrBuilder>
      getRouteRulesOrBuilderList() {
    return routeRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
   */
  @java.lang.Override
  public int getRouteRulesCount() {
    return routeRules_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRule getRouteRules(int index) {
    return routeRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRuleOrBuilder getRouteRulesOrBuilder(int index) {
    return routeRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < pathRules_.size(); i++) {
      output.writeMessage(104439901, pathRules_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(359503338, getDefaultUrlRedirect());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 370242231, defaultService_);
    }
    for (int i = 0; i < routeRules_.size(); i++) {
      output.writeMessage(376292225, routeRules_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(378919466, getDefaultRouteAction());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    for (int i = 0; i < pathRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(104439901, pathRules_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              359503338, getDefaultUrlRedirect());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(370242231, defaultService_);
    }
    for (int i = 0; i < routeRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(376292225, routeRules_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              378919466, getDefaultRouteAction());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PathMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PathMatcher other = (com.google.cloud.compute.v1.PathMatcher) obj;

    if (hasDefaultRouteAction() != other.hasDefaultRouteAction()) return false;
    if (hasDefaultRouteAction()) {
      if (!getDefaultRouteAction().equals(other.getDefaultRouteAction())) return false;
    }
    if (hasDefaultService() != other.hasDefaultService()) return false;
    if (hasDefaultService()) {
      if (!getDefaultService().equals(other.getDefaultService())) return false;
    }
    if (hasDefaultUrlRedirect() != other.hasDefaultUrlRedirect()) return false;
    if (hasDefaultUrlRedirect()) {
      if (!getDefaultUrlRedirect().equals(other.getDefaultUrlRedirect())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasHeaderAction() != other.hasHeaderAction()) return false;
    if (hasHeaderAction()) {
      if (!getHeaderAction().equals(other.getHeaderAction())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getPathRulesList().equals(other.getPathRulesList())) return false;
    if (!getRouteRulesList().equals(other.getRouteRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDefaultRouteAction()) {
      hash = (37 * hash) + DEFAULT_ROUTE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultRouteAction().hashCode();
    }
    if (hasDefaultService()) {
      hash = (37 * hash) + DEFAULT_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultService().hashCode();
    }
    if (hasDefaultUrlRedirect()) {
      hash = (37 * hash) + DEFAULT_URL_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultUrlRedirect().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasHeaderAction()) {
      hash = (37 * hash) + HEADER_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderAction().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getPathRulesCount() > 0) {
      hash = (37 * hash) + PATH_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getPathRulesList().hashCode();
    }
    if (getRouteRulesCount() > 0) {
      hash = (37 * hash) + ROUTE_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRouteRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PathMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will serve the URL. If no rule was matched, the default service is used.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PathMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PathMatcher)
      com.google.cloud.compute.v1.PathMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PathMatcher.class,
              com.google.cloud.compute.v1.PathMatcher.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PathMatcher.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultRouteActionFieldBuilder();
        getDefaultUrlRedirectFieldBuilder();
        getHeaderActionFieldBuilder();
        getPathRulesFieldBuilder();
        getRouteRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      defaultRouteAction_ = null;
      if (defaultRouteActionBuilder_ != null) {
        defaultRouteActionBuilder_.dispose();
        defaultRouteActionBuilder_ = null;
      }
      defaultService_ = "";
      defaultUrlRedirect_ = null;
      if (defaultUrlRedirectBuilder_ != null) {
        defaultUrlRedirectBuilder_.dispose();
        defaultUrlRedirectBuilder_ = null;
      }
      description_ = "";
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      name_ = "";
      if (pathRulesBuilder_ == null) {
        pathRules_ = java.util.Collections.emptyList();
      } else {
        pathRules_ = null;
        pathRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (routeRulesBuilder_ == null) {
        routeRules_ = java.util.Collections.emptyList();
      } else {
        routeRules_ = null;
        routeRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathMatcher getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PathMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathMatcher build() {
      com.google.cloud.compute.v1.PathMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathMatcher buildPartial() {
      com.google.cloud.compute.v1.PathMatcher result =
          new com.google.cloud.compute.v1.PathMatcher(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.PathMatcher result) {
      if (pathRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          pathRules_ = java.util.Collections.unmodifiableList(pathRules_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.pathRules_ = pathRules_;
      } else {
        result.pathRules_ = pathRulesBuilder_.build();
      }
      if (routeRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          routeRules_ = java.util.Collections.unmodifiableList(routeRules_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.routeRules_ = routeRules_;
      } else {
        result.routeRules_ = routeRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.PathMatcher result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.defaultRouteAction_ =
            defaultRouteActionBuilder_ == null
                ? defaultRouteAction_
                : defaultRouteActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultService_ = defaultService_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultUrlRedirect_ =
            defaultUrlRedirectBuilder_ == null
                ? defaultUrlRedirect_
                : defaultUrlRedirectBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.headerAction_ =
            headerActionBuilder_ == null ? headerAction_ : headerActionBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PathMatcher) {
        return mergeFrom((com.google.cloud.compute.v1.PathMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PathMatcher other) {
      if (other == com.google.cloud.compute.v1.PathMatcher.getDefaultInstance()) return this;
      if (other.hasDefaultRouteAction()) {
        mergeDefaultRouteAction(other.getDefaultRouteAction());
      }
      if (other.hasDefaultService()) {
        defaultService_ = other.defaultService_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDefaultUrlRedirect()) {
        mergeDefaultUrlRedirect(other.getDefaultUrlRedirect());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasHeaderAction()) {
        mergeHeaderAction(other.getHeaderAction());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (pathRulesBuilder_ == null) {
        if (!other.pathRules_.isEmpty()) {
          if (pathRules_.isEmpty()) {
            pathRules_ = other.pathRules_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensurePathRulesIsMutable();
            pathRules_.addAll(other.pathRules_);
          }
          onChanged();
        }
      } else {
        if (!other.pathRules_.isEmpty()) {
          if (pathRulesBuilder_.isEmpty()) {
            pathRulesBuilder_.dispose();
            pathRulesBuilder_ = null;
            pathRules_ = other.pathRules_;
            bitField0_ = (bitField0_ & ~0x00000040);
            pathRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPathRulesFieldBuilder()
                    : null;
          } else {
            pathRulesBuilder_.addAllMessages(other.pathRules_);
          }
        }
      }
      if (routeRulesBuilder_ == null) {
        if (!other.routeRules_.isEmpty()) {
          if (routeRules_.isEmpty()) {
            routeRules_ = other.routeRules_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureRouteRulesIsMutable();
            routeRules_.addAll(other.routeRules_);
          }
          onChanged();
        }
      } else {
        if (!other.routeRules_.isEmpty()) {
          if (routeRulesBuilder_.isEmpty()) {
            routeRulesBuilder_.dispose();
            routeRulesBuilder_ = null;
            routeRules_ = other.routeRules_;
            bitField0_ = (bitField0_ & ~0x00000080);
            routeRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRouteRulesFieldBuilder()
                    : null;
          } else {
            routeRulesBuilder_.addAllMessages(other.routeRules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26989658
            case 835519210:
              {
                com.google.cloud.compute.v1.PathRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PathRule.parser(), extensionRegistry);
                if (pathRulesBuilder_ == null) {
                  ensurePathRulesIsMutable();
                  pathRules_.add(m);
                } else {
                  pathRulesBuilder_.addMessage(m);
                }
                break;
              } // case 835519210
            case -1670348478:
              {
                input.readMessage(getHeaderActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -1670348478
            case -1418940590:
              {
                input.readMessage(
                    getDefaultUrlRedirectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1418940590
            case -1333029446:
              {
                defaultService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1333029446
            case -1284629494:
              {
                com.google.cloud.compute.v1.HttpRouteRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpRouteRule.parser(), extensionRegistry);
                if (routeRulesBuilder_ == null) {
                  ensureRouteRulesIsMutable();
                  routeRules_.add(m);
                } else {
                  routeRulesBuilder_.addMessage(m);
                }
                break;
              } // case -1284629494
            case -1263611566:
              {
                input.readMessage(
                    getDefaultRouteActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1263611566
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.HttpRouteAction defaultRouteAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        defaultRouteActionBuilder_;
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     *
     * @return Whether the defaultRouteAction field is set.
     */
    public boolean hasDefaultRouteAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     *
     * @return The defaultRouteAction.
     */
    public com.google.cloud.compute.v1.HttpRouteAction getDefaultRouteAction() {
      if (defaultRouteActionBuilder_ == null) {
        return defaultRouteAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : defaultRouteAction_;
      } else {
        return defaultRouteActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder setDefaultRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (defaultRouteActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultRouteAction_ = value;
      } else {
        defaultRouteActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder setDefaultRouteAction(
        com.google.cloud.compute.v1.HttpRouteAction.Builder builderForValue) {
      if (defaultRouteActionBuilder_ == null) {
        defaultRouteAction_ = builderForValue.build();
      } else {
        defaultRouteActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder mergeDefaultRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (defaultRouteActionBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && defaultRouteAction_ != null
            && defaultRouteAction_
                != com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()) {
          getDefaultRouteActionBuilder().mergeFrom(value);
        } else {
          defaultRouteAction_ = value;
        }
      } else {
        defaultRouteActionBuilder_.mergeFrom(value);
      }
      if (defaultRouteAction_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder clearDefaultRouteAction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      defaultRouteAction_ = null;
      if (defaultRouteActionBuilder_ != null) {
        defaultRouteActionBuilder_.dispose();
        defaultRouteActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRouteAction.Builder getDefaultRouteActionBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDefaultRouteActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getDefaultRouteActionOrBuilder() {
      if (defaultRouteActionBuilder_ != null) {
        return defaultRouteActionBuilder_.getMessageOrBuilder();
      } else {
        return defaultRouteAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : defaultRouteAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices. If defaultRouteAction is specified, don't set defaultUrlRedirect. If defaultRouteAction.weightedBackendServices is specified, don't set defaultService. URL maps for classic Application Load Balancers only support the urlRewrite action within a path matcher's defaultRouteAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        getDefaultRouteActionFieldBuilder() {
      if (defaultRouteActionBuilder_ == null) {
        defaultRouteActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteAction,
                com.google.cloud.compute.v1.HttpRouteAction.Builder,
                com.google.cloud.compute.v1.HttpRouteActionOrBuilder>(
                getDefaultRouteAction(), getParentForChildren(), isClean());
        defaultRouteAction_ = null;
      }
      return defaultRouteActionBuilder_;
    }

    private java.lang.Object defaultService_ = "";
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return Whether the defaultService field is set.
     */
    public boolean hasDefaultService() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return The defaultService.
     */
    public java.lang.String getDefaultService() {
      java.lang.Object ref = defaultService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return The bytes for defaultService.
     */
    public com.google.protobuf.ByteString getDefaultServiceBytes() {
      java.lang.Object ref = defaultService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @param value The defaultService to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultService() {
      defaultService_ = getDefaultInstance().getDefaultService();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendService resource. This URL is used if none of the pathRules or routeRules defined by this PathMatcher are matched. For example, the following are all valid URLs to a BackendService resource: - https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService - compute/v1/projects/project/global/backendServices/backendService - global/backendServices/backendService If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices. Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must not be specified. If defaultService is specified, then set either defaultUrlRedirect or defaultRouteAction.weightedBackendService. Don't set both. Authorization requires one or more of the following Google IAM permissions on the specified resource default_service: - compute.backendBuckets.use - compute.backendServices.use
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @param value The bytes for defaultService to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRedirectAction defaultUrlRedirect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        defaultUrlRedirectBuilder_;
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     *
     * @return Whether the defaultUrlRedirect field is set.
     */
    public boolean hasDefaultUrlRedirect() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     *
     * @return The defaultUrlRedirect.
     */
    public com.google.cloud.compute.v1.HttpRedirectAction getDefaultUrlRedirect() {
      if (defaultUrlRedirectBuilder_ == null) {
        return defaultUrlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : defaultUrlRedirect_;
      } else {
        return defaultUrlRedirectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder setDefaultUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (defaultUrlRedirectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultUrlRedirect_ = value;
      } else {
        defaultUrlRedirectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder setDefaultUrlRedirect(
        com.google.cloud.compute.v1.HttpRedirectAction.Builder builderForValue) {
      if (defaultUrlRedirectBuilder_ == null) {
        defaultUrlRedirect_ = builderForValue.build();
      } else {
        defaultUrlRedirectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder mergeDefaultUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (defaultUrlRedirectBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && defaultUrlRedirect_ != null
            && defaultUrlRedirect_
                != com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()) {
          getDefaultUrlRedirectBuilder().mergeFrom(value);
        } else {
          defaultUrlRedirect_ = value;
        }
      } else {
        defaultUrlRedirectBuilder_.mergeFrom(value);
      }
      if (defaultUrlRedirect_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder clearDefaultUrlRedirect() {
      bitField0_ = (bitField0_ & ~0x00000004);
      defaultUrlRedirect_ = null;
      if (defaultUrlRedirectBuilder_ != null) {
        defaultUrlRedirectBuilder_.dispose();
        defaultUrlRedirectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRedirectAction.Builder getDefaultUrlRedirectBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDefaultUrlRedirectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder
        getDefaultUrlRedirectOrBuilder() {
      if (defaultUrlRedirectBuilder_ != null) {
        return defaultUrlRedirectBuilder_.getMessageOrBuilder();
      } else {
        return defaultUrlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : defaultUrlRedirect_;
      }
    }
    /**
     *
     *
     * <pre>
     * When none of the specified pathRules or routeRules match, the request is redirected to a URL specified by defaultUrlRedirect. If defaultUrlRedirect is specified, then set either defaultService or defaultRouteAction. Don't set both. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        getDefaultUrlRedirectFieldBuilder() {
      if (defaultUrlRedirectBuilder_ == null) {
        defaultUrlRedirectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRedirectAction,
                com.google.cloud.compute.v1.HttpRedirectAction.Builder,
                com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>(
                getDefaultUrlRedirect(), getParentForChildren(), isClean());
        defaultUrlRedirect_ = null;
      }
      return defaultUrlRedirectBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        headerActionBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return Whether the headerAction field is set.
     */
    public boolean hasHeaderAction() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return The headerAction.
     */
    public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
      if (headerActionBuilder_ == null) {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      } else {
        return headerActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headerAction_ = value;
      } else {
        headerActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.HttpHeaderAction.Builder builderForValue) {
      if (headerActionBuilder_ == null) {
        headerAction_ = builderForValue.build();
      } else {
        headerActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder mergeHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && headerAction_ != null
            && headerAction_ != com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()) {
          getHeaderActionBuilder().mergeFrom(value);
        } else {
          headerAction_ = value;
        }
      } else {
        headerActionBuilder_.mergeFrom(value);
      }
      if (headerAction_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder clearHeaderAction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderAction.Builder getHeaderActionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getHeaderActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
      if (headerActionBuilder_ != null) {
        return headerActionBuilder_.getMessageOrBuilder();
      } else {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backend service. HeaderAction specified here are applied after the matching HttpRouteRule HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        getHeaderActionFieldBuilder() {
      if (headerActionBuilder_ == null) {
        headerActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderAction,
                com.google.cloud.compute.v1.HttpHeaderAction.Builder,
                com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>(
                getHeaderAction(), getParentForChildren(), isClean());
        headerAction_ = null;
      }
      return headerActionBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name to which this PathMatcher is referred by the HostRule.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.PathRule> pathRules_ =
        java.util.Collections.emptyList();

    private void ensurePathRulesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        pathRules_ = new java.util.ArrayList<com.google.cloud.compute.v1.PathRule>(pathRules_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PathRule,
            com.google.cloud.compute.v1.PathRule.Builder,
            com.google.cloud.compute.v1.PathRuleOrBuilder>
        pathRulesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.PathRule> getPathRulesList() {
      if (pathRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pathRules_);
      } else {
        return pathRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public int getPathRulesCount() {
      if (pathRulesBuilder_ == null) {
        return pathRules_.size();
      } else {
        return pathRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public com.google.cloud.compute.v1.PathRule getPathRules(int index) {
      if (pathRulesBuilder_ == null) {
        return pathRules_.get(index);
      } else {
        return pathRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder setPathRules(int index, com.google.cloud.compute.v1.PathRule value) {
      if (pathRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathRulesIsMutable();
        pathRules_.set(index, value);
        onChanged();
      } else {
        pathRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder setPathRules(
        int index, com.google.cloud.compute.v1.PathRule.Builder builderForValue) {
      if (pathRulesBuilder_ == null) {
        ensurePathRulesIsMutable();
        pathRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        pathRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder addPathRules(com.google.cloud.compute.v1.PathRule value) {
      if (pathRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathRulesIsMutable();
        pathRules_.add(value);
        onChanged();
      } else {
        pathRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder addPathRules(int index, com.google.cloud.compute.v1.PathRule value) {
      if (pathRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathRulesIsMutable();
        pathRules_.add(index, value);
        onChanged();
      } else {
        pathRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder addPathRules(com.google.cloud.compute.v1.PathRule.Builder builderForValue) {
      if (pathRulesBuilder_ == null) {
        ensurePathRulesIsMutable();
        pathRules_.add(builderForValue.build());
        onChanged();
      } else {
        pathRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder addPathRules(
        int index, com.google.cloud.compute.v1.PathRule.Builder builderForValue) {
      if (pathRulesBuilder_ == null) {
        ensurePathRulesIsMutable();
        pathRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        pathRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder addAllPathRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.PathRule> values) {
      if (pathRulesBuilder_ == null) {
        ensurePathRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pathRules_);
        onChanged();
      } else {
        pathRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder clearPathRules() {
      if (pathRulesBuilder_ == null) {
        pathRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        pathRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public Builder removePathRules(int index) {
      if (pathRulesBuilder_ == null) {
        ensurePathRulesIsMutable();
        pathRules_.remove(index);
        onChanged();
      } else {
        pathRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public com.google.cloud.compute.v1.PathRule.Builder getPathRulesBuilder(int index) {
      return getPathRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public com.google.cloud.compute.v1.PathRuleOrBuilder getPathRulesOrBuilder(int index) {
      if (pathRulesBuilder_ == null) {
        return pathRules_.get(index);
      } else {
        return pathRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.PathRuleOrBuilder>
        getPathRulesOrBuilderList() {
      if (pathRulesBuilder_ != null) {
        return pathRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pathRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public com.google.cloud.compute.v1.PathRule.Builder addPathRulesBuilder() {
      return getPathRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.PathRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public com.google.cloud.compute.v1.PathRule.Builder addPathRulesBuilder(int index) {
      return getPathRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.PathRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of path rules. Use this list instead of routeRules when routing based on simple path matching is all that's required. The order by which path rules are specified does not matter. Matches are always done on the longest-path-first basis. For example: a pathRule with a path /a/b/c/&#42; will match before /a/b/&#42; irrespective of the order in which those paths appear in this list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathRule path_rules = 104439901;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.PathRule.Builder> getPathRulesBuilderList() {
      return getPathRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PathRule,
            com.google.cloud.compute.v1.PathRule.Builder,
            com.google.cloud.compute.v1.PathRuleOrBuilder>
        getPathRulesFieldBuilder() {
      if (pathRulesBuilder_ == null) {
        pathRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PathRule,
                com.google.cloud.compute.v1.PathRule.Builder,
                com.google.cloud.compute.v1.PathRuleOrBuilder>(
                pathRules_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        pathRules_ = null;
      }
      return pathRulesBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.HttpRouteRule> routeRules_ =
        java.util.Collections.emptyList();

    private void ensureRouteRulesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        routeRules_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpRouteRule>(routeRules_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteRule,
            com.google.cloud.compute.v1.HttpRouteRule.Builder,
            com.google.cloud.compute.v1.HttpRouteRuleOrBuilder>
        routeRulesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpRouteRule> getRouteRulesList() {
      if (routeRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routeRules_);
      } else {
        return routeRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public int getRouteRulesCount() {
      if (routeRulesBuilder_ == null) {
        return routeRules_.size();
      } else {
        return routeRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRule getRouteRules(int index) {
      if (routeRulesBuilder_ == null) {
        return routeRules_.get(index);
      } else {
        return routeRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder setRouteRules(int index, com.google.cloud.compute.v1.HttpRouteRule value) {
      if (routeRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRouteRulesIsMutable();
        routeRules_.set(index, value);
        onChanged();
      } else {
        routeRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder setRouteRules(
        int index, com.google.cloud.compute.v1.HttpRouteRule.Builder builderForValue) {
      if (routeRulesBuilder_ == null) {
        ensureRouteRulesIsMutable();
        routeRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        routeRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder addRouteRules(com.google.cloud.compute.v1.HttpRouteRule value) {
      if (routeRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRouteRulesIsMutable();
        routeRules_.add(value);
        onChanged();
      } else {
        routeRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder addRouteRules(int index, com.google.cloud.compute.v1.HttpRouteRule value) {
      if (routeRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRouteRulesIsMutable();
        routeRules_.add(index, value);
        onChanged();
      } else {
        routeRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder addRouteRules(
        com.google.cloud.compute.v1.HttpRouteRule.Builder builderForValue) {
      if (routeRulesBuilder_ == null) {
        ensureRouteRulesIsMutable();
        routeRules_.add(builderForValue.build());
        onChanged();
      } else {
        routeRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder addRouteRules(
        int index, com.google.cloud.compute.v1.HttpRouteRule.Builder builderForValue) {
      if (routeRulesBuilder_ == null) {
        ensureRouteRulesIsMutable();
        routeRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        routeRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder addAllRouteRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpRouteRule> values) {
      if (routeRulesBuilder_ == null) {
        ensureRouteRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routeRules_);
        onChanged();
      } else {
        routeRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder clearRouteRules() {
      if (routeRulesBuilder_ == null) {
        routeRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        routeRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public Builder removeRouteRules(int index) {
      if (routeRulesBuilder_ == null) {
        ensureRouteRulesIsMutable();
        routeRules_.remove(index);
        onChanged();
      } else {
        routeRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRule.Builder getRouteRulesBuilder(int index) {
      return getRouteRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleOrBuilder getRouteRulesOrBuilder(int index) {
      if (routeRulesBuilder_ == null) {
        return routeRules_.get(index);
      } else {
        return routeRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpRouteRuleOrBuilder>
        getRouteRulesOrBuilderList() {
      if (routeRulesBuilder_ != null) {
        return routeRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routeRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRule.Builder addRouteRulesBuilder() {
      return getRouteRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpRouteRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRule.Builder addRouteRulesBuilder(int index) {
      return getRouteRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HttpRouteRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching and routing actions are desired. routeRules are evaluated in order of priority, from the lowest to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRule route_rules = 376292225;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpRouteRule.Builder>
        getRouteRulesBuilderList() {
      return getRouteRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteRule,
            com.google.cloud.compute.v1.HttpRouteRule.Builder,
            com.google.cloud.compute.v1.HttpRouteRuleOrBuilder>
        getRouteRulesFieldBuilder() {
      if (routeRulesBuilder_ == null) {
        routeRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteRule,
                com.google.cloud.compute.v1.HttpRouteRule.Builder,
                com.google.cloud.compute.v1.HttpRouteRuleOrBuilder>(
                routeRules_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        routeRules_ = null;
      }
      return routeRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PathMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PathMatcher)
  private static final com.google.cloud.compute.v1.PathMatcher DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PathMatcher();
  }

  public static com.google.cloud.compute.v1.PathMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PathMatcher> PARSER =
      new com.google.protobuf.AbstractParser<PathMatcher>() {
        @java.lang.Override
        public PathMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PathMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PathMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PathMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
