/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PathRule}
 */
public final class PathRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PathRule)
    PathRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PathRule.newBuilder() to construct.
  private PathRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PathRule() {
    paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
    service_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PathRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PathRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PathRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PathRule.class,
            com.google.cloud.compute.v1.PathRule.Builder.class);
  }

  private int bitField0_;
  public static final int PATHS_FIELD_NUMBER = 106438894;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList paths_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
   * </pre>
   *
   * <code>repeated string paths = 106438894;</code>
   *
   * @return A list containing the paths.
   */
  public com.google.protobuf.ProtocolStringList getPathsList() {
    return paths_;
  }
  /**
   *
   *
   * <pre>
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
   * </pre>
   *
   * <code>repeated string paths = 106438894;</code>
   *
   * @return The count of paths.
   */
  public int getPathsCount() {
    return paths_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
   * </pre>
   *
   * <code>repeated string paths = 106438894;</code>
   *
   * @param index The index of the element to return.
   * @return The paths at the given index.
   */
  public java.lang.String getPaths(int index) {
    return paths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
   * </pre>
   *
   * <code>repeated string paths = 106438894;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the paths at the given index.
   */
  public com.google.protobuf.ByteString getPathsBytes(int index) {
    return paths_.getByteString(index);
  }

  public static final int ROUTE_ACTION_FIELD_NUMBER = 424563948;
  private com.google.cloud.compute.v1.HttpRouteAction routeAction_;
  /**
   *
   *
   * <pre>
   * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   *
   * @return Whether the routeAction field is set.
   */
  @java.lang.Override
  public boolean hasRouteAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   *
   * @return The routeAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteAction getRouteAction() {
    return routeAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : routeAction_;
  }
  /**
   *
   *
   * <pre>
   * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getRouteActionOrBuilder() {
    return routeAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : routeAction_;
  }

  public static final int SERVICE_FIELD_NUMBER = 373540533;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return Whether the service field is set.
   */
  @java.lang.Override
  public boolean hasService() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URL_REDIRECT_FIELD_NUMBER = 405147820;
  private com.google.cloud.compute.v1.HttpRedirectAction urlRedirect_;
  /**
   *
   *
   * <pre>
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   *
   * @return Whether the urlRedirect field is set.
   */
  @java.lang.Override
  public boolean hasUrlRedirect() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   *
   * @return The urlRedirect.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectAction getUrlRedirect() {
    return urlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : urlRedirect_;
  }
  /**
   *
   *
   * <pre>
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getUrlRedirectOrBuilder() {
    return urlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : urlRedirect_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < paths_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 106438894, paths_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 373540533, service_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(405147820, getUrlRedirect());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(424563948, getRouteAction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < paths_.size(); i++) {
        dataSize += computeStringSizeNoTag(paths_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getPathsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(373540533, service_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(405147820, getUrlRedirect());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(424563948, getRouteAction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PathRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PathRule other = (com.google.cloud.compute.v1.PathRule) obj;

    if (!getPathsList().equals(other.getPathsList())) return false;
    if (hasRouteAction() != other.hasRouteAction()) return false;
    if (hasRouteAction()) {
      if (!getRouteAction().equals(other.getRouteAction())) return false;
    }
    if (hasService() != other.hasService()) return false;
    if (hasService()) {
      if (!getService().equals(other.getService())) return false;
    }
    if (hasUrlRedirect() != other.hasUrlRedirect()) return false;
    if (hasUrlRedirect()) {
      if (!getUrlRedirect().equals(other.getUrlRedirect())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPathsCount() > 0) {
      hash = (37 * hash) + PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getPathsList().hashCode();
    }
    if (hasRouteAction()) {
      hash = (37 * hash) + ROUTE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getRouteAction().hashCode();
    }
    if (hasService()) {
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
    }
    if (hasUrlRedirect()) {
      hash = (37 * hash) + URL_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getUrlRedirect().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PathRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PathRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PathRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PathRule)
      com.google.cloud.compute.v1.PathRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PathRule.class,
              com.google.cloud.compute.v1.PathRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PathRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRouteActionFieldBuilder();
        getUrlRedirectFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      routeAction_ = null;
      if (routeActionBuilder_ != null) {
        routeActionBuilder_.dispose();
        routeActionBuilder_ = null;
      }
      service_ = "";
      urlRedirect_ = null;
      if (urlRedirectBuilder_ != null) {
        urlRedirectBuilder_.dispose();
        urlRedirectBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PathRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PathRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathRule build() {
      com.google.cloud.compute.v1.PathRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PathRule buildPartial() {
      com.google.cloud.compute.v1.PathRule result = new com.google.cloud.compute.v1.PathRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.PathRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        paths_.makeImmutable();
        result.paths_ = paths_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.routeAction_ =
            routeActionBuilder_ == null ? routeAction_ : routeActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.service_ = service_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.urlRedirect_ =
            urlRedirectBuilder_ == null ? urlRedirect_ : urlRedirectBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PathRule) {
        return mergeFrom((com.google.cloud.compute.v1.PathRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PathRule other) {
      if (other == com.google.cloud.compute.v1.PathRule.getDefaultInstance()) return this;
      if (!other.paths_.isEmpty()) {
        if (paths_.isEmpty()) {
          paths_ = other.paths_;
          bitField0_ |= 0x00000001;
        } else {
          ensurePathsIsMutable();
          paths_.addAll(other.paths_);
        }
        onChanged();
      }
      if (other.hasRouteAction()) {
        mergeRouteAction(other.getRouteAction());
      }
      if (other.hasService()) {
        service_ = other.service_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasUrlRedirect()) {
        mergeUrlRedirect(other.getUrlRedirect());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 851511154:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePathsIsMutable();
                paths_.add(s);
                break;
              } // case 851511154
            case -1306643030:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1306643030
            case -1053784734:
              {
                input.readMessage(getUrlRedirectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -1053784734
            case -898455710:
              {
                input.readMessage(getRouteActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -898455710
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList paths_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePathsIsMutable() {
      if (!paths_.isModifiable()) {
        paths_ = new com.google.protobuf.LazyStringArrayList(paths_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @return A list containing the paths.
     */
    public com.google.protobuf.ProtocolStringList getPathsList() {
      paths_.makeImmutable();
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @return The count of paths.
     */
    public int getPathsCount() {
      return paths_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    public java.lang.String getPaths(int index) {
      return paths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    public com.google.protobuf.ByteString getPathsBytes(int index) {
      return paths_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param index The index to set the value at.
     * @param value The paths to set.
     * @return This builder for chaining.
     */
    public Builder setPaths(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePathsIsMutable();
      paths_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param value The paths to add.
     * @return This builder for chaining.
     */
    public Builder addPaths(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePathsIsMutable();
      paths_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param values The paths to add.
     * @return This builder for chaining.
     */
    public Builder addAllPaths(java.lang.Iterable<java.lang.String> values) {
      ensurePathsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paths_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPaths() {
      paths_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     * </pre>
     *
     * <code>repeated string paths = 106438894;</code>
     *
     * @param value The bytes of the paths to add.
     * @return This builder for chaining.
     */
    public Builder addPathsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePathsIsMutable();
      paths_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRouteAction routeAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        routeActionBuilder_;
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     *
     * @return Whether the routeAction field is set.
     */
    public boolean hasRouteAction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     *
     * @return The routeAction.
     */
    public com.google.cloud.compute.v1.HttpRouteAction getRouteAction() {
      if (routeActionBuilder_ == null) {
        return routeAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : routeAction_;
      } else {
        return routeActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder setRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (routeActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routeAction_ = value;
      } else {
        routeActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder setRouteAction(
        com.google.cloud.compute.v1.HttpRouteAction.Builder builderForValue) {
      if (routeActionBuilder_ == null) {
        routeAction_ = builderForValue.build();
      } else {
        routeActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder mergeRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (routeActionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && routeAction_ != null
            && routeAction_ != com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()) {
          getRouteActionBuilder().mergeFrom(value);
        } else {
          routeAction_ = value;
        }
      } else {
        routeActionBuilder_.mergeFrom(value);
      }
      if (routeAction_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder clearRouteAction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      routeAction_ = null;
      if (routeActionBuilder_ != null) {
        routeActionBuilder_.dispose();
        routeActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteAction.Builder getRouteActionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRouteActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getRouteActionOrBuilder() {
      if (routeActionBuilder_ != null) {
        return routeActionBuilder_.getMessageOrBuilder();
      } else {
        return routeAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : routeAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * In response to a matching path, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of routeAction or urlRedirect must be set. URL maps for classic Application Load Balancers only support the urlRewrite action within a path rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        getRouteActionFieldBuilder() {
      if (routeActionBuilder_ == null) {
        routeActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteAction,
                com.google.cloud.compute.v1.HttpRouteAction.Builder,
                com.google.cloud.compute.v1.HttpRouteActionOrBuilder>(
                getRouteAction(), getParentForChildren(), isClean());
        routeAction_ = null;
      }
      return routeActionBuilder_;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return Whether the service field is set.
     */
    public boolean hasService() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRedirectAction urlRedirect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        urlRedirectBuilder_;
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     *
     * @return Whether the urlRedirect field is set.
     */
    public boolean hasUrlRedirect() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     *
     * @return The urlRedirect.
     */
    public com.google.cloud.compute.v1.HttpRedirectAction getUrlRedirect() {
      if (urlRedirectBuilder_ == null) {
        return urlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : urlRedirect_;
      } else {
        return urlRedirectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder setUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (urlRedirectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        urlRedirect_ = value;
      } else {
        urlRedirectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder setUrlRedirect(
        com.google.cloud.compute.v1.HttpRedirectAction.Builder builderForValue) {
      if (urlRedirectBuilder_ == null) {
        urlRedirect_ = builderForValue.build();
      } else {
        urlRedirectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder mergeUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (urlRedirectBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && urlRedirect_ != null
            && urlRedirect_
                != com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()) {
          getUrlRedirectBuilder().mergeFrom(value);
        } else {
          urlRedirect_ = value;
        }
      } else {
        urlRedirectBuilder_.mergeFrom(value);
      }
      if (urlRedirect_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder clearUrlRedirect() {
      bitField0_ = (bitField0_ & ~0x00000008);
      urlRedirect_ = null;
      if (urlRedirectBuilder_ != null) {
        urlRedirectBuilder_.dispose();
        urlRedirectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public com.google.cloud.compute.v1.HttpRedirectAction.Builder getUrlRedirectBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUrlRedirectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getUrlRedirectOrBuilder() {
      if (urlRedirectBuilder_ != null) {
        return urlRedirectBuilder_.getMessageOrBuilder();
      } else {
        return urlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : urlRedirect_;
      }
    }
    /**
     *
     *
     * <pre>
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        getUrlRedirectFieldBuilder() {
      if (urlRedirectBuilder_ == null) {
        urlRedirectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRedirectAction,
                com.google.cloud.compute.v1.HttpRedirectAction.Builder,
                com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>(
                getUrlRedirect(), getParentForChildren(), isClean());
        urlRedirect_ = null;
      }
      return urlRedirectBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PathRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PathRule)
  private static final com.google.cloud.compute.v1.PathRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PathRule();
  }

  public static com.google.cloud.compute.v1.PathRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PathRule> PARSER =
      new com.google.protobuf.AbstractParser<PathRule>() {
        @java.lang.Override
        public PathRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PathRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PathRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PathRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
