/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** ``` { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike&#64;example.com", "group:admins&#64;example.com", "domain:google.com", "serviceAccount:my-project-id&#64;appspot.gserviceaccount.com" ] }, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve&#64;example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time &lt; timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag": "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: - members: - user:mike&#64;example.com - group:admins&#64;example.com - domain:google.com - serviceAccount:my-project-id&#64;appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve&#64;example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time &lt; timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Policy}
 */
public final class Policy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Policy)
    PolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Policy.newBuilder() to construct.
  private Policy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Policy() {
    auditConfigs_ = java.util.Collections.emptyList();
    bindings_ = java.util.Collections.emptyList();
    etag_ = "";
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Policy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Policy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Policy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Policy.class,
            com.google.cloud.compute.v1.Policy.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIT_CONFIGS_FIELD_NUMBER = 328080653;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AuditConfig> auditConfigs_;
  /**
   *
   *
   * <pre>
   * Specifies cloud audit logging configuration for this policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AuditConfig> getAuditConfigsList() {
    return auditConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Specifies cloud audit logging configuration for this policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AuditConfigOrBuilder>
      getAuditConfigsOrBuilderList() {
    return auditConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Specifies cloud audit logging configuration for this policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
   */
  @java.lang.Override
  public int getAuditConfigsCount() {
    return auditConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies cloud audit logging configuration for this policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AuditConfig getAuditConfigs(int index) {
    return auditConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies cloud audit logging configuration for this policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AuditConfigOrBuilder getAuditConfigsOrBuilder(int index) {
    return auditConfigs_.get(index);
  }

  public static final int BINDINGS_FIELD_NUMBER = 403251854;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Binding> bindings_;
  /**
   *
   *
   * <pre>
   * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Binding> getBindingsList() {
    return bindings_;
  }
  /**
   *
   *
   * <pre>
   * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.BindingOrBuilder>
      getBindingsOrBuilderList() {
    return bindings_;
  }
  /**
   *
   *
   * <pre>
   * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
   */
  @java.lang.Override
  public int getBindingsCount() {
    return bindings_.size();
  }
  /**
   *
   *
   * <pre>
   * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Binding getBindings(int index) {
    return bindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BindingOrBuilder getBindingsOrBuilder(int index) {
    return bindings_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 3123477;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return Whether the etag field is set.
   */
  @java.lang.Override
  public boolean hasEtag() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IAM_OWNED_FIELD_NUMBER = 450566203;
  private boolean iamOwned_ = false;
  /**
   * <code>optional bool iam_owned = 450566203;</code>
   *
   * @return Whether the iamOwned field is set.
   */
  @java.lang.Override
  public boolean hasIamOwned() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional bool iam_owned = 450566203;</code>
   *
   * @return The iamOwned.
   */
  @java.lang.Override
  public boolean getIamOwned() {
    return iamOwned_;
  }

  public static final int RULES_FIELD_NUMBER = 108873975;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Rule> rules_;
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Rule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Rule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This is deprecated and has no effect. Do not use.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int VERSION_FIELD_NUMBER = 351608024;
  private int version_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
   * </pre>
   *
   * <code>optional int32 version = 351608024;</code>
   *
   * @return Whether the version field is set.
   */
  @java.lang.Override
  public boolean hasVersion() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
   * </pre>
   *
   * <code>optional int32 version = 351608024;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public int getVersion() {
    return version_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3123477, etag_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(108873975, rules_.get(i));
    }
    for (int i = 0; i < auditConfigs_.size(); i++) {
      output.writeMessage(328080653, auditConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(351608024, version_);
    }
    for (int i = 0; i < bindings_.size(); i++) {
      output.writeMessage(403251854, bindings_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(450566203, iamOwned_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3123477, etag_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(108873975, rules_.get(i));
    }
    for (int i = 0; i < auditConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328080653, auditConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(351608024, version_);
    }
    for (int i = 0; i < bindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(403251854, bindings_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(450566203, iamOwned_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Policy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Policy other = (com.google.cloud.compute.v1.Policy) obj;

    if (!getAuditConfigsList().equals(other.getAuditConfigsList())) return false;
    if (!getBindingsList().equals(other.getBindingsList())) return false;
    if (hasEtag() != other.hasEtag()) return false;
    if (hasEtag()) {
      if (!getEtag().equals(other.getEtag())) return false;
    }
    if (hasIamOwned() != other.hasIamOwned()) return false;
    if (hasIamOwned()) {
      if (getIamOwned() != other.getIamOwned()) return false;
    }
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (hasVersion() != other.hasVersion()) return false;
    if (hasVersion()) {
      if (getVersion() != other.getVersion()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAuditConfigsCount() > 0) {
      hash = (37 * hash) + AUDIT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAuditConfigsList().hashCode();
    }
    if (getBindingsCount() > 0) {
      hash = (37 * hash) + BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getBindingsList().hashCode();
    }
    if (hasEtag()) {
      hash = (37 * hash) + ETAG_FIELD_NUMBER;
      hash = (53 * hash) + getEtag().hashCode();
    }
    if (hasIamOwned()) {
      hash = (37 * hash) + IAM_OWNED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIamOwned());
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    if (hasVersion()) {
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Policy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Policy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Policy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** ``` { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike&#64;example.com", "group:admins&#64;example.com", "domain:google.com", "serviceAccount:my-project-id&#64;appspot.gserviceaccount.com" ] }, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve&#64;example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time &lt; timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag": "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: - members: - user:mike&#64;example.com - group:admins&#64;example.com - domain:google.com - serviceAccount:my-project-id&#64;appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve&#64;example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time &lt; timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Policy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Policy)
      com.google.cloud.compute.v1.PolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Policy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Policy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Policy.class,
              com.google.cloud.compute.v1.Policy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Policy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (auditConfigsBuilder_ == null) {
        auditConfigs_ = java.util.Collections.emptyList();
      } else {
        auditConfigs_ = null;
        auditConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (bindingsBuilder_ == null) {
        bindings_ = java.util.Collections.emptyList();
      } else {
        bindings_ = null;
        bindingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      etag_ = "";
      iamOwned_ = false;
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      version_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Policy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Policy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Policy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Policy build() {
      com.google.cloud.compute.v1.Policy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Policy buildPartial() {
      com.google.cloud.compute.v1.Policy result = new com.google.cloud.compute.v1.Policy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Policy result) {
      if (auditConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          auditConfigs_ = java.util.Collections.unmodifiableList(auditConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.auditConfigs_ = auditConfigs_;
      } else {
        result.auditConfigs_ = auditConfigsBuilder_.build();
      }
      if (bindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bindings_ = java.util.Collections.unmodifiableList(bindings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bindings_ = bindings_;
      } else {
        result.bindings_ = bindingsBuilder_.build();
      }
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Policy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.iamOwned_ = iamOwned_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.version_ = version_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Policy) {
        return mergeFrom((com.google.cloud.compute.v1.Policy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Policy other) {
      if (other == com.google.cloud.compute.v1.Policy.getDefaultInstance()) return this;
      if (auditConfigsBuilder_ == null) {
        if (!other.auditConfigs_.isEmpty()) {
          if (auditConfigs_.isEmpty()) {
            auditConfigs_ = other.auditConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAuditConfigsIsMutable();
            auditConfigs_.addAll(other.auditConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.auditConfigs_.isEmpty()) {
          if (auditConfigsBuilder_.isEmpty()) {
            auditConfigsBuilder_.dispose();
            auditConfigsBuilder_ = null;
            auditConfigs_ = other.auditConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            auditConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAuditConfigsFieldBuilder()
                    : null;
          } else {
            auditConfigsBuilder_.addAllMessages(other.auditConfigs_);
          }
        }
      }
      if (bindingsBuilder_ == null) {
        if (!other.bindings_.isEmpty()) {
          if (bindings_.isEmpty()) {
            bindings_ = other.bindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBindingsIsMutable();
            bindings_.addAll(other.bindings_);
          }
          onChanged();
        }
      } else {
        if (!other.bindings_.isEmpty()) {
          if (bindingsBuilder_.isEmpty()) {
            bindingsBuilder_.dispose();
            bindingsBuilder_ = null;
            bindings_ = other.bindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bindingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBindingsFieldBuilder()
                    : null;
          } else {
            bindingsBuilder_.addAllMessages(other.bindings_);
          }
        }
      }
      if (other.hasEtag()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasIamOwned()) {
        setIamOwned(other.getIamOwned());
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000010);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (other.hasVersion()) {
        setVersion(other.getVersion());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 24987818:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 24987818
            case 870991802:
              {
                com.google.cloud.compute.v1.Rule m =
                    input.readMessage(com.google.cloud.compute.v1.Rule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 870991802
            case -1670322070:
              {
                com.google.cloud.compute.v1.AuditConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AuditConfig.parser(), extensionRegistry);
                if (auditConfigsBuilder_ == null) {
                  ensureAuditConfigsIsMutable();
                  auditConfigs_.add(m);
                } else {
                  auditConfigsBuilder_.addMessage(m);
                }
                break;
              } // case -1670322070
            case -1482103104:
              {
                version_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -1482103104
            case -1068952462:
              {
                com.google.cloud.compute.v1.Binding m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Binding.parser(), extensionRegistry);
                if (bindingsBuilder_ == null) {
                  ensureBindingsIsMutable();
                  bindings_.add(m);
                } else {
                  bindingsBuilder_.addMessage(m);
                }
                break;
              } // case -1068952462
            case -690437672:
              {
                iamOwned_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case -690437672
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.AuditConfig> auditConfigs_ =
        java.util.Collections.emptyList();

    private void ensureAuditConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        auditConfigs_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AuditConfig>(auditConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AuditConfig,
            com.google.cloud.compute.v1.AuditConfig.Builder,
            com.google.cloud.compute.v1.AuditConfigOrBuilder>
        auditConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AuditConfig> getAuditConfigsList() {
      if (auditConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(auditConfigs_);
      } else {
        return auditConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public int getAuditConfigsCount() {
      if (auditConfigsBuilder_ == null) {
        return auditConfigs_.size();
      } else {
        return auditConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public com.google.cloud.compute.v1.AuditConfig getAuditConfigs(int index) {
      if (auditConfigsBuilder_ == null) {
        return auditConfigs_.get(index);
      } else {
        return auditConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder setAuditConfigs(int index, com.google.cloud.compute.v1.AuditConfig value) {
      if (auditConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditConfigsIsMutable();
        auditConfigs_.set(index, value);
        onChanged();
      } else {
        auditConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder setAuditConfigs(
        int index, com.google.cloud.compute.v1.AuditConfig.Builder builderForValue) {
      if (auditConfigsBuilder_ == null) {
        ensureAuditConfigsIsMutable();
        auditConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        auditConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder addAuditConfigs(com.google.cloud.compute.v1.AuditConfig value) {
      if (auditConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditConfigsIsMutable();
        auditConfigs_.add(value);
        onChanged();
      } else {
        auditConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder addAuditConfigs(int index, com.google.cloud.compute.v1.AuditConfig value) {
      if (auditConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditConfigsIsMutable();
        auditConfigs_.add(index, value);
        onChanged();
      } else {
        auditConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder addAuditConfigs(
        com.google.cloud.compute.v1.AuditConfig.Builder builderForValue) {
      if (auditConfigsBuilder_ == null) {
        ensureAuditConfigsIsMutable();
        auditConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        auditConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder addAuditConfigs(
        int index, com.google.cloud.compute.v1.AuditConfig.Builder builderForValue) {
      if (auditConfigsBuilder_ == null) {
        ensureAuditConfigsIsMutable();
        auditConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        auditConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder addAllAuditConfigs(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AuditConfig> values) {
      if (auditConfigsBuilder_ == null) {
        ensureAuditConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, auditConfigs_);
        onChanged();
      } else {
        auditConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder clearAuditConfigs() {
      if (auditConfigsBuilder_ == null) {
        auditConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        auditConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public Builder removeAuditConfigs(int index) {
      if (auditConfigsBuilder_ == null) {
        ensureAuditConfigsIsMutable();
        auditConfigs_.remove(index);
        onChanged();
      } else {
        auditConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public com.google.cloud.compute.v1.AuditConfig.Builder getAuditConfigsBuilder(int index) {
      return getAuditConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public com.google.cloud.compute.v1.AuditConfigOrBuilder getAuditConfigsOrBuilder(int index) {
      if (auditConfigsBuilder_ == null) {
        return auditConfigs_.get(index);
      } else {
        return auditConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AuditConfigOrBuilder>
        getAuditConfigsOrBuilderList() {
      if (auditConfigsBuilder_ != null) {
        return auditConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(auditConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public com.google.cloud.compute.v1.AuditConfig.Builder addAuditConfigsBuilder() {
      return getAuditConfigsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AuditConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public com.google.cloud.compute.v1.AuditConfig.Builder addAuditConfigsBuilder(int index) {
      return getAuditConfigsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AuditConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies cloud audit logging configuration for this policy.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AuditConfig audit_configs = 328080653;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AuditConfig.Builder>
        getAuditConfigsBuilderList() {
      return getAuditConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AuditConfig,
            com.google.cloud.compute.v1.AuditConfig.Builder,
            com.google.cloud.compute.v1.AuditConfigOrBuilder>
        getAuditConfigsFieldBuilder() {
      if (auditConfigsBuilder_ == null) {
        auditConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AuditConfig,
                com.google.cloud.compute.v1.AuditConfig.Builder,
                com.google.cloud.compute.v1.AuditConfigOrBuilder>(
                auditConfigs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        auditConfigs_ = null;
      }
      return auditConfigsBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.Binding> bindings_ =
        java.util.Collections.emptyList();

    private void ensureBindingsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bindings_ = new java.util.ArrayList<com.google.cloud.compute.v1.Binding>(bindings_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Binding,
            com.google.cloud.compute.v1.Binding.Builder,
            com.google.cloud.compute.v1.BindingOrBuilder>
        bindingsBuilder_;

    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Binding> getBindingsList() {
      if (bindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bindings_);
      } else {
        return bindingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public int getBindingsCount() {
      if (bindingsBuilder_ == null) {
        return bindings_.size();
      } else {
        return bindingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public com.google.cloud.compute.v1.Binding getBindings(int index) {
      if (bindingsBuilder_ == null) {
        return bindings_.get(index);
      } else {
        return bindingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder setBindings(int index, com.google.cloud.compute.v1.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.set(index, value);
        onChanged();
      } else {
        bindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder setBindings(
        int index, com.google.cloud.compute.v1.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder addBindings(com.google.cloud.compute.v1.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.add(value);
        onChanged();
      } else {
        bindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder addBindings(int index, com.google.cloud.compute.v1.Binding value) {
      if (bindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingsIsMutable();
        bindings_.add(index, value);
        onChanged();
      } else {
        bindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder addBindings(com.google.cloud.compute.v1.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.add(builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder addBindings(
        int index, com.google.cloud.compute.v1.Binding.Builder builderForValue) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        bindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder addAllBindings(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Binding> values) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bindings_);
        onChanged();
      } else {
        bindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder clearBindings() {
      if (bindingsBuilder_ == null) {
        bindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public Builder removeBindings(int index) {
      if (bindingsBuilder_ == null) {
        ensureBindingsIsMutable();
        bindings_.remove(index);
        onChanged();
      } else {
        bindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public com.google.cloud.compute.v1.Binding.Builder getBindingsBuilder(int index) {
      return getBindingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public com.google.cloud.compute.v1.BindingOrBuilder getBindingsOrBuilder(int index) {
      if (bindingsBuilder_ == null) {
        return bindings_.get(index);
      } else {
        return bindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.BindingOrBuilder>
        getBindingsOrBuilderList() {
      if (bindingsBuilder_ != null) {
        return bindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bindings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public com.google.cloud.compute.v1.Binding.Builder addBindingsBuilder() {
      return getBindingsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Binding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public com.google.cloud.compute.v1.Binding.Builder addBindingsBuilder(int index) {
      return getBindingsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Binding.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice&#64;example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Binding bindings = 403251854;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Binding.Builder> getBindingsBuilderList() {
      return getBindingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Binding,
            com.google.cloud.compute.v1.Binding.Builder,
            com.google.cloud.compute.v1.BindingOrBuilder>
        getBindingsFieldBuilder() {
      if (bindingsBuilder_ == null) {
        bindingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Binding,
                com.google.cloud.compute.v1.Binding.Builder,
                com.google.cloud.compute.v1.BindingOrBuilder>(
                bindings_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        bindings_ = null;
      }
      return bindingsBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return Whether the etag field is set.
     */
    public boolean hasEtag() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean iamOwned_;
    /**
     * <code>optional bool iam_owned = 450566203;</code>
     *
     * @return Whether the iamOwned field is set.
     */
    @java.lang.Override
    public boolean hasIamOwned() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional bool iam_owned = 450566203;</code>
     *
     * @return The iamOwned.
     */
    @java.lang.Override
    public boolean getIamOwned() {
      return iamOwned_;
    }
    /**
     * <code>optional bool iam_owned = 450566203;</code>
     *
     * @param value The iamOwned to set.
     * @return This builder for chaining.
     */
    public Builder setIamOwned(boolean value) {

      iamOwned_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional bool iam_owned = 450566203;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIamOwned() {
      bitField0_ = (bitField0_ & ~0x00000008);
      iamOwned_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Rule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        rules_ = new java.util.ArrayList<com.google.cloud.compute.v1.Rule>(rules_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Rule,
            com.google.cloud.compute.v1.Rule.Builder,
            com.google.cloud.compute.v1.RuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Rule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.Rule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder setRules(int index, com.google.cloud.compute.v1.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder setRules(int index, com.google.cloud.compute.v1.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder addRules(com.google.cloud.compute.v1.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder addRules(int index, com.google.cloud.compute.v1.Rule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder addRules(com.google.cloud.compute.v1.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder addRules(int index, com.google.cloud.compute.v1.Rule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Rule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.Rule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.Rule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Rule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.Rule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Rule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * This is deprecated and has no effect. Do not use.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Rule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Rule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Rule,
            com.google.cloud.compute.v1.Rule.Builder,
            com.google.cloud.compute.v1.RuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Rule,
                com.google.cloud.compute.v1.Rule.Builder,
                com.google.cloud.compute.v1.RuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private int version_;
    /**
     *
     *
     * <pre>
     * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
     * </pre>
     *
     * <code>optional int32 version = 351608024;</code>
     *
     * @return Whether the version field is set.
     */
    @java.lang.Override
    public boolean hasVersion() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
     * </pre>
     *
     * <code>optional int32 version = 351608024;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
     * </pre>
     *
     * <code>optional int32 version = 351608024;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int value) {

      version_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
     * </pre>
     *
     * <code>optional int32 version = 351608024;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000020);
      version_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Policy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Policy)
  private static final com.google.cloud.compute.v1.Policy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Policy();
  }

  public static com.google.cloud.compute.v1.Policy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Policy> PARSER =
      new com.google.protobuf.AbstractParser<Policy>() {
        @java.lang.Override
        public Policy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Policy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Policy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Policy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
