/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A public advertised prefix represents an aggregated IP prefix or netblock which customers bring to cloud. The IP prefix is a single unit of route advertisement and is announced globally to the internet.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PublicAdvertisedPrefix}
 */
public final class PublicAdvertisedPrefix extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PublicAdvertisedPrefix)
    PublicAdvertisedPrefixOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PublicAdvertisedPrefix.newBuilder() to construct.
  private PublicAdvertisedPrefix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PublicAdvertisedPrefix() {
    byoipApiVersion_ = "";
    creationTimestamp_ = "";
    description_ = "";
    dnsVerificationIp_ = "";
    fingerprint_ = "";
    ipCidrRange_ = "";
    kind_ = "";
    name_ = "";
    pdpScope_ = "";
    publicDelegatedPrefixs_ = java.util.Collections.emptyList();
    selfLink_ = "";
    sharedSecret_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PublicAdvertisedPrefix();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PublicAdvertisedPrefix_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PublicAdvertisedPrefix_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PublicAdvertisedPrefix.class,
            com.google.cloud.compute.v1.PublicAdvertisedPrefix.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicAdvertisedPrefix.ByoipApiVersion}
   */
  public enum ByoipApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BYOIP_API_VERSION = 0;</code>
     */
    UNDEFINED_BYOIP_API_VERSION(0),
    /**
     *
     *
     * <pre>
     * This public advertised prefix can be used to create both regional and global public delegated prefixes. It usually takes 4 weeks to create or delete a public delegated prefix. The BGP status cannot be changed.
     * </pre>
     *
     * <code>V1 = 2715;</code>
     */
    V1(2715),
    /**
     *
     *
     * <pre>
     * This public advertised prefix can only be used to create regional public delegated prefixes. Public delegated prefix creation and deletion takes minutes and the BGP status can be modified.
     * </pre>
     *
     * <code>V2 = 2716;</code>
     */
    V2(2716),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BYOIP_API_VERSION = 0;</code>
     */
    public static final int UNDEFINED_BYOIP_API_VERSION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This public advertised prefix can be used to create both regional and global public delegated prefixes. It usually takes 4 weeks to create or delete a public delegated prefix. The BGP status cannot be changed.
     * </pre>
     *
     * <code>V1 = 2715;</code>
     */
    public static final int V1_VALUE = 2715;
    /**
     *
     *
     * <pre>
     * This public advertised prefix can only be used to create regional public delegated prefixes. Public delegated prefix creation and deletion takes minutes and the BGP status can be modified.
     * </pre>
     *
     * <code>V2 = 2716;</code>
     */
    public static final int V2_VALUE = 2716;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ByoipApiVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ByoipApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BYOIP_API_VERSION;
        case 2715:
          return V1;
        case 2716:
          return V2;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion>() {
              public ByoipApiVersion findValueByNumber(int number) {
                return ByoipApiVersion.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicAdvertisedPrefix.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ByoipApiVersion[] VALUES = values();

    public static ByoipApiVersion valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ByoipApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicAdvertisedPrefix.ByoipApiVersion)
  }

  /**
   *
   *
   * <pre>
   * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicAdvertisedPrefix.PdpScope}
   */
  public enum PdpScope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PDP_SCOPE = 0;</code>
     */
    UNDEFINED_PDP_SCOPE(0),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is global only. The provisioning will take ~4 weeks.
     * </pre>
     *
     * <code>GLOBAL = 494663587;</code>
     */
    GLOBAL(494663587),
    /**
     *
     *
     * <pre>
     * The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * </pre>
     *
     * <code>GLOBAL_AND_REGIONAL = 318053059;</code>
     */
    GLOBAL_AND_REGIONAL(318053059),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is regional only. The provisioning will take a few minutes.
     * </pre>
     *
     * <code>REGIONAL = 92288543;</code>
     */
    REGIONAL(92288543),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PDP_SCOPE = 0;</code>
     */
    public static final int UNDEFINED_PDP_SCOPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is global only. The provisioning will take ~4 weeks.
     * </pre>
     *
     * <code>GLOBAL = 494663587;</code>
     */
    public static final int GLOBAL_VALUE = 494663587;
    /**
     *
     *
     * <pre>
     * The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * </pre>
     *
     * <code>GLOBAL_AND_REGIONAL = 318053059;</code>
     */
    public static final int GLOBAL_AND_REGIONAL_VALUE = 318053059;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is regional only. The provisioning will take a few minutes.
     * </pre>
     *
     * <code>REGIONAL = 92288543;</code>
     */
    public static final int REGIONAL_VALUE = 92288543;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PdpScope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PdpScope forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PDP_SCOPE;
        case 494663587:
          return GLOBAL;
        case 318053059:
          return GLOBAL_AND_REGIONAL;
        case 92288543:
          return REGIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PdpScope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PdpScope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PdpScope>() {
          public PdpScope findValueByNumber(int number) {
            return PdpScope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicAdvertisedPrefix.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final PdpScope[] VALUES = values();

    public static PdpScope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PdpScope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicAdvertisedPrefix.PdpScope)
  }

  /**
   *
   *
   * <pre>
   * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicAdvertisedPrefix.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The prefix is announced to Internet.
     * </pre>
     *
     * <code>ANNOUNCED_TO_INTERNET = 177880897;</code>
     */
    ANNOUNCED_TO_INTERNET(177880897),
    /**
     *
     *
     * <pre>
     * RPKI validation is complete.
     * </pre>
     *
     * <code>INITIAL = 518841124;</code>
     */
    INITIAL(518841124),
    /**
     *
     *
     * <pre>
     * The prefix is fully configured.
     * </pre>
     *
     * <code>PREFIX_CONFIGURATION_COMPLETE = 480889551;</code>
     */
    PREFIX_CONFIGURATION_COMPLETE(480889551),
    /**
     *
     *
     * <pre>
     * The prefix is being configured.
     * </pre>
     *
     * <code>PREFIX_CONFIGURATION_IN_PROGRESS = 378550961;</code>
     */
    PREFIX_CONFIGURATION_IN_PROGRESS(378550961),
    /**
     *
     *
     * <pre>
     * The prefix is being removed.
     * </pre>
     *
     * <code>PREFIX_REMOVAL_IN_PROGRESS = 284375783;</code>
     */
    PREFIX_REMOVAL_IN_PROGRESS(284375783),
    /**
     *
     *
     * <pre>
     * User has configured the PTR.
     * </pre>
     *
     * <code>PTR_CONFIGURED = 513497167;</code>
     */
    PTR_CONFIGURED(513497167),
    /**
     *
     *
     * <pre>
     * The prefix is currently withdrawn but ready to be announced.
     * </pre>
     *
     * <code>READY_TO_ANNOUNCE = 64641265;</code>
     */
    READY_TO_ANNOUNCE(64641265),
    /**
     *
     *
     * <pre>
     * Reverse DNS lookup failed.
     * </pre>
     *
     * <code>REVERSE_DNS_LOOKUP_FAILED = 295755183;</code>
     */
    REVERSE_DNS_LOOKUP_FAILED(295755183),
    /**
     *
     *
     * <pre>
     * Reverse DNS lookup is successful.
     * </pre>
     *
     * <code>VALIDATED = 66197998;</code>
     */
    VALIDATED(66197998),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The prefix is announced to Internet.
     * </pre>
     *
     * <code>ANNOUNCED_TO_INTERNET = 177880897;</code>
     */
    public static final int ANNOUNCED_TO_INTERNET_VALUE = 177880897;
    /**
     *
     *
     * <pre>
     * RPKI validation is complete.
     * </pre>
     *
     * <code>INITIAL = 518841124;</code>
     */
    public static final int INITIAL_VALUE = 518841124;
    /**
     *
     *
     * <pre>
     * The prefix is fully configured.
     * </pre>
     *
     * <code>PREFIX_CONFIGURATION_COMPLETE = 480889551;</code>
     */
    public static final int PREFIX_CONFIGURATION_COMPLETE_VALUE = 480889551;
    /**
     *
     *
     * <pre>
     * The prefix is being configured.
     * </pre>
     *
     * <code>PREFIX_CONFIGURATION_IN_PROGRESS = 378550961;</code>
     */
    public static final int PREFIX_CONFIGURATION_IN_PROGRESS_VALUE = 378550961;
    /**
     *
     *
     * <pre>
     * The prefix is being removed.
     * </pre>
     *
     * <code>PREFIX_REMOVAL_IN_PROGRESS = 284375783;</code>
     */
    public static final int PREFIX_REMOVAL_IN_PROGRESS_VALUE = 284375783;
    /**
     *
     *
     * <pre>
     * User has configured the PTR.
     * </pre>
     *
     * <code>PTR_CONFIGURED = 513497167;</code>
     */
    public static final int PTR_CONFIGURED_VALUE = 513497167;
    /**
     *
     *
     * <pre>
     * The prefix is currently withdrawn but ready to be announced.
     * </pre>
     *
     * <code>READY_TO_ANNOUNCE = 64641265;</code>
     */
    public static final int READY_TO_ANNOUNCE_VALUE = 64641265;
    /**
     *
     *
     * <pre>
     * Reverse DNS lookup failed.
     * </pre>
     *
     * <code>REVERSE_DNS_LOOKUP_FAILED = 295755183;</code>
     */
    public static final int REVERSE_DNS_LOOKUP_FAILED_VALUE = 295755183;
    /**
     *
     *
     * <pre>
     * Reverse DNS lookup is successful.
     * </pre>
     *
     * <code>VALIDATED = 66197998;</code>
     */
    public static final int VALIDATED_VALUE = 66197998;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 177880897:
          return ANNOUNCED_TO_INTERNET;
        case 518841124:
          return INITIAL;
        case 480889551:
          return PREFIX_CONFIGURATION_COMPLETE;
        case 378550961:
          return PREFIX_CONFIGURATION_IN_PROGRESS;
        case 284375783:
          return PREFIX_REMOVAL_IN_PROGRESS;
        case 513497167:
          return PTR_CONFIGURED;
        case 64641265:
          return READY_TO_ANNOUNCE;
        case 295755183:
          return REVERSE_DNS_LOOKUP_FAILED;
        case 66197998:
          return VALIDATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicAdvertisedPrefix.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicAdvertisedPrefix.Status)
  }

  private int bitField0_;
  public static final int BYOIP_API_VERSION_FIELD_NUMBER = 162683283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object byoipApiVersion_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return Whether the byoipApiVersion field is set.
   */
  @java.lang.Override
  public boolean hasByoipApiVersion() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return The byoipApiVersion.
   */
  @java.lang.Override
  public java.lang.String getByoipApiVersion() {
    java.lang.Object ref = byoipApiVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      byoipApiVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return The bytes for byoipApiVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getByoipApiVersionBytes() {
    java.lang.Object ref = byoipApiVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      byoipApiVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DNS_VERIFICATION_IP_FIELD_NUMBER = 241011381;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dnsVerificationIp_ = "";
  /**
   *
   *
   * <pre>
   * The address to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string dns_verification_ip = 241011381;</code>
   *
   * @return Whether the dnsVerificationIp field is set.
   */
  @java.lang.Override
  public boolean hasDnsVerificationIp() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The address to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string dns_verification_ip = 241011381;</code>
   *
   * @return The dnsVerificationIp.
   */
  @java.lang.Override
  public java.lang.String getDnsVerificationIp() {
    java.lang.Object ref = dnsVerificationIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dnsVerificationIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The address to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string dns_verification_ip = 241011381;</code>
   *
   * @return The bytes for dnsVerificationIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDnsVerificationIpBytes() {
    java.lang.Object ref = dnsVerificationIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dnsVerificationIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IP_CIDR_RANGE_FIELD_NUMBER = 98117322;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipCidrRange_ = "";
  /**
   *
   *
   * <pre>
   * The address range, in CIDR format, represented by this public advertised prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return Whether the ipCidrRange field is set.
   */
  @java.lang.Override
  public boolean hasIpCidrRange() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The address range, in CIDR format, represented by this public advertised prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The ipCidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpCidrRange() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipCidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The address range, in CIDR format, represented by this public advertised prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpCidrRangeBytes() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipCidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PDP_SCOPE_FIELD_NUMBER = 524264785;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pdpScope_ = "";
  /**
   *
   *
   * <pre>
   * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
   * Check the PdpScope enum for the list of possible values.
   * </pre>
   *
   * <code>optional string pdp_scope = 524264785;</code>
   *
   * @return Whether the pdpScope field is set.
   */
  @java.lang.Override
  public boolean hasPdpScope() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
   * Check the PdpScope enum for the list of possible values.
   * </pre>
   *
   * <code>optional string pdp_scope = 524264785;</code>
   *
   * @return The pdpScope.
   */
  @java.lang.Override
  public java.lang.String getPdpScope() {
    java.lang.Object ref = pdpScope_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pdpScope_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
   * Check the PdpScope enum for the list of possible values.
   * </pre>
   *
   * <code>optional string pdp_scope = 524264785;</code>
   *
   * @return The bytes for pdpScope.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPdpScopeBytes() {
    java.lang.Object ref = pdpScope_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pdpScope_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_DELEGATED_PREFIXS_FIELD_NUMBER = 425811723;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>
      publicDelegatedPrefixs_;
  /**
   *
   *
   * <pre>
   * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>
      getPublicDelegatedPrefixsList() {
    return publicDelegatedPrefixs_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder>
      getPublicDelegatedPrefixsOrBuilderList() {
    return publicDelegatedPrefixs_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
   * </code>
   */
  @java.lang.Override
  public int getPublicDelegatedPrefixsCount() {
    return publicDelegatedPrefixs_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix
      getPublicDelegatedPrefixs(int index) {
    return publicDelegatedPrefixs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder
      getPublicDelegatedPrefixsOrBuilder(int index) {
    return publicDelegatedPrefixs_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHARED_SECRET_FIELD_NUMBER = 381932490;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sharedSecret_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The shared secret to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return Whether the sharedSecret field is set.
   */
  @java.lang.Override
  public boolean hasSharedSecret() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The shared secret to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return The sharedSecret.
   */
  @java.lang.Override
  public java.lang.String getSharedSecret() {
    java.lang.Object ref = sharedSecret_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sharedSecret_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The shared secret to be used for reverse DNS verification.
   * </pre>
   *
   * <code>optional string shared_secret = 381932490;</code>
   *
   * @return The bytes for sharedSecret.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSharedSecretBytes() {
    java.lang.Object ref = sharedSecret_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sharedSecret_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 162683283, byoipApiVersion_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 241011381, dnsVerificationIp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 381932490, sharedSecret_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < publicDelegatedPrefixs_.size(); i++) {
      output.writeMessage(425811723, publicDelegatedPrefixs_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 524264785, pdpScope_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(162683283, byoipApiVersion_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(241011381, dnsVerificationIp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(381932490, sharedSecret_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < publicDelegatedPrefixs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              425811723, publicDelegatedPrefixs_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(524264785, pdpScope_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PublicAdvertisedPrefix)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PublicAdvertisedPrefix other =
        (com.google.cloud.compute.v1.PublicAdvertisedPrefix) obj;

    if (hasByoipApiVersion() != other.hasByoipApiVersion()) return false;
    if (hasByoipApiVersion()) {
      if (!getByoipApiVersion().equals(other.getByoipApiVersion())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDnsVerificationIp() != other.hasDnsVerificationIp()) return false;
    if (hasDnsVerificationIp()) {
      if (!getDnsVerificationIp().equals(other.getDnsVerificationIp())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIpCidrRange() != other.hasIpCidrRange()) return false;
    if (hasIpCidrRange()) {
      if (!getIpCidrRange().equals(other.getIpCidrRange())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPdpScope() != other.hasPdpScope()) return false;
    if (hasPdpScope()) {
      if (!getPdpScope().equals(other.getPdpScope())) return false;
    }
    if (!getPublicDelegatedPrefixsList().equals(other.getPublicDelegatedPrefixsList()))
      return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSharedSecret() != other.hasSharedSecret()) return false;
    if (hasSharedSecret()) {
      if (!getSharedSecret().equals(other.getSharedSecret())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasByoipApiVersion()) {
      hash = (37 * hash) + BYOIP_API_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getByoipApiVersion().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDnsVerificationIp()) {
      hash = (37 * hash) + DNS_VERIFICATION_IP_FIELD_NUMBER;
      hash = (53 * hash) + getDnsVerificationIp().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIpCidrRange()) {
      hash = (37 * hash) + IP_CIDR_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIpCidrRange().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPdpScope()) {
      hash = (37 * hash) + PDP_SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getPdpScope().hashCode();
    }
    if (getPublicDelegatedPrefixsCount() > 0) {
      hash = (37 * hash) + PUBLIC_DELEGATED_PREFIXS_FIELD_NUMBER;
      hash = (53 * hash) + getPublicDelegatedPrefixsList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSharedSecret()) {
      hash = (37 * hash) + SHARED_SECRET_FIELD_NUMBER;
      hash = (53 * hash) + getSharedSecret().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PublicAdvertisedPrefix prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A public advertised prefix represents an aggregated IP prefix or netblock which customers bring to cloud. The IP prefix is a single unit of route advertisement and is announced globally to the internet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PublicAdvertisedPrefix}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PublicAdvertisedPrefix)
      com.google.cloud.compute.v1.PublicAdvertisedPrefixOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicAdvertisedPrefix_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicAdvertisedPrefix_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PublicAdvertisedPrefix.class,
              com.google.cloud.compute.v1.PublicAdvertisedPrefix.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PublicAdvertisedPrefix.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      byoipApiVersion_ = "";
      creationTimestamp_ = "";
      description_ = "";
      dnsVerificationIp_ = "";
      fingerprint_ = "";
      id_ = 0L;
      ipCidrRange_ = "";
      kind_ = "";
      name_ = "";
      pdpScope_ = "";
      if (publicDelegatedPrefixsBuilder_ == null) {
        publicDelegatedPrefixs_ = java.util.Collections.emptyList();
      } else {
        publicDelegatedPrefixs_ = null;
        publicDelegatedPrefixsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      selfLink_ = "";
      sharedSecret_ = "";
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicAdvertisedPrefix_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicAdvertisedPrefix getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PublicAdvertisedPrefix.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicAdvertisedPrefix build() {
      com.google.cloud.compute.v1.PublicAdvertisedPrefix result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicAdvertisedPrefix buildPartial() {
      com.google.cloud.compute.v1.PublicAdvertisedPrefix result =
          new com.google.cloud.compute.v1.PublicAdvertisedPrefix(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.PublicAdvertisedPrefix result) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          publicDelegatedPrefixs_ = java.util.Collections.unmodifiableList(publicDelegatedPrefixs_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.publicDelegatedPrefixs_ = publicDelegatedPrefixs_;
      } else {
        result.publicDelegatedPrefixs_ = publicDelegatedPrefixsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.PublicAdvertisedPrefix result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.byoipApiVersion_ = byoipApiVersion_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dnsVerificationIp_ = dnsVerificationIp_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ipCidrRange_ = ipCidrRange_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pdpScope_ = pdpScope_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.sharedSecret_ = sharedSecret_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PublicAdvertisedPrefix) {
        return mergeFrom((com.google.cloud.compute.v1.PublicAdvertisedPrefix) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PublicAdvertisedPrefix other) {
      if (other == com.google.cloud.compute.v1.PublicAdvertisedPrefix.getDefaultInstance())
        return this;
      if (other.hasByoipApiVersion()) {
        byoipApiVersion_ = other.byoipApiVersion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDnsVerificationIp()) {
        dnsVerificationIp_ = other.dnsVerificationIp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIpCidrRange()) {
        ipCidrRange_ = other.ipCidrRange_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPdpScope()) {
        pdpScope_ = other.pdpScope_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (publicDelegatedPrefixsBuilder_ == null) {
        if (!other.publicDelegatedPrefixs_.isEmpty()) {
          if (publicDelegatedPrefixs_.isEmpty()) {
            publicDelegatedPrefixs_ = other.publicDelegatedPrefixs_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensurePublicDelegatedPrefixsIsMutable();
            publicDelegatedPrefixs_.addAll(other.publicDelegatedPrefixs_);
          }
          onChanged();
        }
      } else {
        if (!other.publicDelegatedPrefixs_.isEmpty()) {
          if (publicDelegatedPrefixsBuilder_.isEmpty()) {
            publicDelegatedPrefixsBuilder_.dispose();
            publicDelegatedPrefixsBuilder_ = null;
            publicDelegatedPrefixs_ = other.publicDelegatedPrefixs_;
            bitField0_ = (bitField0_ & ~0x00000400);
            publicDelegatedPrefixsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPublicDelegatedPrefixsFieldBuilder()
                    : null;
          } else {
            publicDelegatedPrefixsBuilder_.addAllMessages(other.publicDelegatedPrefixs_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasSharedSecret()) {
        sharedSecret_ = other.sharedSecret_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 784938578:
              {
                ipCidrRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 784938578
            case 1301466266:
              {
                byoipApiVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1301466266
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1450082194
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1877428002
            case 1928091050:
              {
                dnsVerificationIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1928091050
            case -1239507374:
              {
                sharedSecret_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -1239507374
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -888473510:
              {
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix
                            .parser(),
                        extensionRegistry);
                if (publicDelegatedPrefixsBuilder_ == null) {
                  ensurePublicDelegatedPrefixsIsMutable();
                  publicDelegatedPrefixs_.add(m);
                } else {
                  publicDelegatedPrefixsBuilder_.addMessage(m);
                }
                break;
              } // case -888473510
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -645248918
            case -100849014:
              {
                pdpScope_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -100849014
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object byoipApiVersion_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return Whether the byoipApiVersion field is set.
     */
    public boolean hasByoipApiVersion() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return The byoipApiVersion.
     */
    public java.lang.String getByoipApiVersion() {
      java.lang.Object ref = byoipApiVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        byoipApiVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return The bytes for byoipApiVersion.
     */
    public com.google.protobuf.ByteString getByoipApiVersionBytes() {
      java.lang.Object ref = byoipApiVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        byoipApiVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @param value The byoipApiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setByoipApiVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      byoipApiVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearByoipApiVersion() {
      byoipApiVersion_ = getDefaultInstance().getByoipApiVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @param value The bytes for byoipApiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setByoipApiVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      byoipApiVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object dnsVerificationIp_ = "";
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @return Whether the dnsVerificationIp field is set.
     */
    public boolean hasDnsVerificationIp() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @return The dnsVerificationIp.
     */
    public java.lang.String getDnsVerificationIp() {
      java.lang.Object ref = dnsVerificationIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dnsVerificationIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @return The bytes for dnsVerificationIp.
     */
    public com.google.protobuf.ByteString getDnsVerificationIpBytes() {
      java.lang.Object ref = dnsVerificationIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dnsVerificationIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @param value The dnsVerificationIp to set.
     * @return This builder for chaining.
     */
    public Builder setDnsVerificationIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dnsVerificationIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDnsVerificationIp() {
      dnsVerificationIp_ = getDefaultInstance().getDnsVerificationIp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string dns_verification_ip = 241011381;</code>
     *
     * @param value The bytes for dnsVerificationIp to set.
     * @return This builder for chaining.
     */
    public Builder setDnsVerificationIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dnsVerificationIp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicAdvertisedPrefix. An up-to-date fingerprint must be provided in order to update the PublicAdvertisedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicAdvertisedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object ipCidrRange_ = "";
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return Whether the ipCidrRange field is set.
     */
    public boolean hasIpCidrRange() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The ipCidrRange.
     */
    public java.lang.String getIpCidrRange() {
      java.lang.Object ref = ipCidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipCidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The bytes for ipCidrRange.
     */
    public com.google.protobuf.ByteString getIpCidrRangeBytes() {
      java.lang.Object ref = ipCidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipCidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipCidrRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpCidrRange() {
      ipCidrRange_ = getDefaultInstance().getIpCidrRange();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address range, in CIDR format, represented by this public advertised prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The bytes for ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipCidrRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicAdvertisedPrefix for public advertised prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object pdpScope_ = "";
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @return Whether the pdpScope field is set.
     */
    public boolean hasPdpScope() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @return The pdpScope.
     */
    public java.lang.String getPdpScope() {
      java.lang.Object ref = pdpScope_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pdpScope_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @return The bytes for pdpScope.
     */
    public com.google.protobuf.ByteString getPdpScopeBytes() {
      java.lang.Object ref = pdpScope_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pdpScope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @param value The pdpScope to set.
     * @return This builder for chaining.
     */
    public Builder setPdpScope(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pdpScope_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPdpScope() {
      pdpScope_ = getDefaultInstance().getPdpScope();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
     * Check the PdpScope enum for the list of possible values.
     * </pre>
     *
     * <code>optional string pdp_scope = 524264785;</code>
     *
     * @param value The bytes for pdpScope to set.
     * @return This builder for chaining.
     */
    public Builder setPdpScopeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pdpScope_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>
        publicDelegatedPrefixs_ = java.util.Collections.emptyList();

    private void ensurePublicDelegatedPrefixsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        publicDelegatedPrefixs_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>(
                publicDelegatedPrefixs_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix,
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder,
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder>
        publicDelegatedPrefixsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>
        getPublicDelegatedPrefixsList() {
      if (publicDelegatedPrefixsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(publicDelegatedPrefixs_);
      } else {
        return publicDelegatedPrefixsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public int getPublicDelegatedPrefixsCount() {
      if (publicDelegatedPrefixsBuilder_ == null) {
        return publicDelegatedPrefixs_.size();
      } else {
        return publicDelegatedPrefixsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix
        getPublicDelegatedPrefixs(int index) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        return publicDelegatedPrefixs_.get(index);
      } else {
        return publicDelegatedPrefixsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder setPublicDelegatedPrefixs(
        int index, com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix value) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.set(index, value);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder setPublicDelegatedPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
            builderForValue) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.set(index, builderForValue.build());
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder addPublicDelegatedPrefixs(
        com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix value) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.add(value);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder addPublicDelegatedPrefixs(
        int index, com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix value) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.add(index, value);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder addPublicDelegatedPrefixs(
        com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
            builderForValue) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.add(builderForValue.build());
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder addPublicDelegatedPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
            builderForValue) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.add(index, builderForValue.build());
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder addAllPublicDelegatedPrefixs(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix>
            values) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        ensurePublicDelegatedPrefixsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, publicDelegatedPrefixs_);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder clearPublicDelegatedPrefixs() {
      if (publicDelegatedPrefixsBuilder_ == null) {
        publicDelegatedPrefixs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public Builder removePublicDelegatedPrefixs(int index) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        ensurePublicDelegatedPrefixsIsMutable();
        publicDelegatedPrefixs_.remove(index);
        onChanged();
      } else {
        publicDelegatedPrefixsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
        getPublicDelegatedPrefixsBuilder(int index) {
      return getPublicDelegatedPrefixsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder
        getPublicDelegatedPrefixsOrBuilder(int index) {
      if (publicDelegatedPrefixsBuilder_ == null) {
        return publicDelegatedPrefixs_.get(index);
      } else {
        return publicDelegatedPrefixsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder>
        getPublicDelegatedPrefixsOrBuilderList() {
      if (publicDelegatedPrefixsBuilder_ != null) {
        return publicDelegatedPrefixsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(publicDelegatedPrefixs_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
        addPublicDelegatedPrefixsBuilder() {
      return getPublicDelegatedPrefixsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder
        addPublicDelegatedPrefixsBuilder(int index) {
      return getPublicDelegatedPrefixsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of public delegated prefixes that exist for this public advertised prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix public_delegated_prefixs = 425811723;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder>
        getPublicDelegatedPrefixsBuilderList() {
      return getPublicDelegatedPrefixsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix,
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder,
            com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder>
        getPublicDelegatedPrefixsFieldBuilder() {
      if (publicDelegatedPrefixsBuilder_ == null) {
        publicDelegatedPrefixsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix,
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefix.Builder,
                com.google.cloud.compute.v1.PublicAdvertisedPrefixPublicDelegatedPrefixOrBuilder>(
                publicDelegatedPrefixs_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        publicDelegatedPrefixs_ = null;
      }
      return publicDelegatedPrefixsBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object sharedSecret_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return Whether the sharedSecret field is set.
     */
    public boolean hasSharedSecret() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return The sharedSecret.
     */
    public java.lang.String getSharedSecret() {
      java.lang.Object ref = sharedSecret_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sharedSecret_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return The bytes for sharedSecret.
     */
    public com.google.protobuf.ByteString getSharedSecretBytes() {
      java.lang.Object ref = sharedSecret_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sharedSecret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @param value The sharedSecret to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sharedSecret_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSharedSecret() {
      sharedSecret_ = getDefaultInstance().getSharedSecret();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The shared secret to be used for reverse DNS verification.
     * </pre>
     *
     * <code>optional string shared_secret = 381932490;</code>
     *
     * @param value The bytes for sharedSecret to set.
     * @return This builder for chaining.
     */
    public Builder setSharedSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sharedSecret_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PublicAdvertisedPrefix)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PublicAdvertisedPrefix)
  private static final com.google.cloud.compute.v1.PublicAdvertisedPrefix DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PublicAdvertisedPrefix();
  }

  public static com.google.cloud.compute.v1.PublicAdvertisedPrefix getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublicAdvertisedPrefix> PARSER =
      new com.google.protobuf.AbstractParser<PublicAdvertisedPrefix>() {
        @java.lang.Override
        public PublicAdvertisedPrefix parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PublicAdvertisedPrefix> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublicAdvertisedPrefix> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PublicAdvertisedPrefix getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
