/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A PublicDelegatedPrefix resource represents an IP block within a PublicAdvertisedPrefix that is configured within a single cloud scope (global or region). IPs in the block can be allocated to resources within that scope. Public delegated prefixes may be further broken up into smaller IP blocks in the same scope as the parent block.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PublicDelegatedPrefix}
 */
public final class PublicDelegatedPrefix extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PublicDelegatedPrefix)
    PublicDelegatedPrefixOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PublicDelegatedPrefix.newBuilder() to construct.
  private PublicDelegatedPrefix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PublicDelegatedPrefix() {
    byoipApiVersion_ = "";
    creationTimestamp_ = "";
    description_ = "";
    fingerprint_ = "";
    ipCidrRange_ = "";
    kind_ = "";
    mode_ = "";
    name_ = "";
    parentPrefix_ = "";
    publicDelegatedSubPrefixs_ = java.util.Collections.emptyList();
    region_ = "";
    selfLink_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PublicDelegatedPrefix();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PublicDelegatedPrefix_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PublicDelegatedPrefix_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PublicDelegatedPrefix.class,
            com.google.cloud.compute.v1.PublicDelegatedPrefix.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicDelegatedPrefix.ByoipApiVersion}
   */
  public enum ByoipApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BYOIP_API_VERSION = 0;</code>
     */
    UNDEFINED_BYOIP_API_VERSION(0),
    /**
     *
     *
     * <pre>
     * This public delegated prefix usually takes 4 weeks to delete, and the BGP status cannot be changed. Announce and Withdraw APIs can not be used on this prefix.
     * </pre>
     *
     * <code>V1 = 2715;</code>
     */
    V1(2715),
    /**
     *
     *
     * <pre>
     * This public delegated prefix takes minutes to delete. Announce and Withdraw APIs can be used on this prefix to change the BGP status.
     * </pre>
     *
     * <code>V2 = 2716;</code>
     */
    V2(2716),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BYOIP_API_VERSION = 0;</code>
     */
    public static final int UNDEFINED_BYOIP_API_VERSION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This public delegated prefix usually takes 4 weeks to delete, and the BGP status cannot be changed. Announce and Withdraw APIs can not be used on this prefix.
     * </pre>
     *
     * <code>V1 = 2715;</code>
     */
    public static final int V1_VALUE = 2715;
    /**
     *
     *
     * <pre>
     * This public delegated prefix takes minutes to delete. Announce and Withdraw APIs can be used on this prefix to change the BGP status.
     * </pre>
     *
     * <code>V2 = 2716;</code>
     */
    public static final int V2_VALUE = 2716;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ByoipApiVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ByoipApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BYOIP_API_VERSION;
        case 2715:
          return V1;
        case 2716:
          return V2;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ByoipApiVersion>() {
              public ByoipApiVersion findValueByNumber(int number) {
                return ByoipApiVersion.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicDelegatedPrefix.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ByoipApiVersion[] VALUES = values();

    public static ByoipApiVersion valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ByoipApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicDelegatedPrefix.ByoipApiVersion)
  }

  /**
   *
   *
   * <pre>
   * The public delegated prefix mode for IPv6 only.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicDelegatedPrefix.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MODE = 0;</code>
     */
    UNDEFINED_MODE(0),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is used for further sub-delegation only. Such prefixes cannot set allocatablePrefixLength.
     * </pre>
     *
     * <code>DELEGATION = 264149288;</code>
     */
    DELEGATION(264149288),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is used for creating forwarding rules only. Such prefixes cannot set publicDelegatedSubPrefixes.
     * </pre>
     *
     * <code>EXTERNAL_IPV6_FORWARDING_RULE_CREATION = 398684356;</code>
     */
    EXTERNAL_IPV6_FORWARDING_RULE_CREATION(398684356),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MODE = 0;</code>
     */
    public static final int UNDEFINED_MODE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is used for further sub-delegation only. Such prefixes cannot set allocatablePrefixLength.
     * </pre>
     *
     * <code>DELEGATION = 264149288;</code>
     */
    public static final int DELEGATION_VALUE = 264149288;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is used for creating forwarding rules only. Such prefixes cannot set publicDelegatedSubPrefixes.
     * </pre>
     *
     * <code>EXTERNAL_IPV6_FORWARDING_RULE_CREATION = 398684356;</code>
     */
    public static final int EXTERNAL_IPV6_FORWARDING_RULE_CREATION_VALUE = 398684356;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MODE;
        case 264149288:
          return DELEGATION;
        case 398684356:
          return EXTERNAL_IPV6_FORWARDING_RULE_CREATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicDelegatedPrefix.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicDelegatedPrefix.Mode)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PublicDelegatedPrefix.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is active.
     * </pre>
     *
     * <code>ANNOUNCED = 365103355;</code>
     */
    ANNOUNCED(365103355),
    /**
     *
     *
     * <pre>
     * The prefix is announced within Google network.
     * </pre>
     *
     * <code>ANNOUNCED_TO_GOOGLE = 454875705;</code>
     */
    ANNOUNCED_TO_GOOGLE(454875705),
    /**
     *
     *
     * <pre>
     * The prefix is announced to Internet and within Google.
     * </pre>
     *
     * <code>ANNOUNCED_TO_INTERNET = 177880897;</code>
     */
    ANNOUNCED_TO_INTERNET(177880897),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is being deprovsioned.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is being initialized and addresses cannot be created yet.
     * </pre>
     *
     * <code>INITIALIZING = 306588749;</code>
     */
    INITIALIZING(306588749),
    /**
     *
     *
     * <pre>
     * The public delegated prefix is currently withdrawn but ready to be announced.
     * </pre>
     *
     * <code>READY_TO_ANNOUNCE = 64641265;</code>
     */
    READY_TO_ANNOUNCE(64641265),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is active.
     * </pre>
     *
     * <code>ANNOUNCED = 365103355;</code>
     */
    public static final int ANNOUNCED_VALUE = 365103355;
    /**
     *
     *
     * <pre>
     * The prefix is announced within Google network.
     * </pre>
     *
     * <code>ANNOUNCED_TO_GOOGLE = 454875705;</code>
     */
    public static final int ANNOUNCED_TO_GOOGLE_VALUE = 454875705;
    /**
     *
     *
     * <pre>
     * The prefix is announced to Internet and within Google.
     * </pre>
     *
     * <code>ANNOUNCED_TO_INTERNET = 177880897;</code>
     */
    public static final int ANNOUNCED_TO_INTERNET_VALUE = 177880897;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is being deprovsioned.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is being initialized and addresses cannot be created yet.
     * </pre>
     *
     * <code>INITIALIZING = 306588749;</code>
     */
    public static final int INITIALIZING_VALUE = 306588749;
    /**
     *
     *
     * <pre>
     * The public delegated prefix is currently withdrawn but ready to be announced.
     * </pre>
     *
     * <code>READY_TO_ANNOUNCE = 64641265;</code>
     */
    public static final int READY_TO_ANNOUNCE_VALUE = 64641265;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 365103355:
          return ANNOUNCED;
        case 454875705:
          return ANNOUNCED_TO_GOOGLE;
        case 177880897:
          return ANNOUNCED_TO_INTERNET;
        case 528602024:
          return DELETING;
        case 306588749:
          return INITIALIZING;
        case 64641265:
          return READY_TO_ANNOUNCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PublicDelegatedPrefix.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PublicDelegatedPrefix.Status)
  }

  private int bitField0_;
  public static final int ALLOCATABLE_PREFIX_LENGTH_FIELD_NUMBER = 38427446;
  private int allocatablePrefixLength_ = 0;
  /**
   *
   *
   * <pre>
   * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
   * </pre>
   *
   * <code>optional int32 allocatable_prefix_length = 38427446;</code>
   *
   * @return Whether the allocatablePrefixLength field is set.
   */
  @java.lang.Override
  public boolean hasAllocatablePrefixLength() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
   * </pre>
   *
   * <code>optional int32 allocatable_prefix_length = 38427446;</code>
   *
   * @return The allocatablePrefixLength.
   */
  @java.lang.Override
  public int getAllocatablePrefixLength() {
    return allocatablePrefixLength_;
  }

  public static final int BYOIP_API_VERSION_FIELD_NUMBER = 162683283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object byoipApiVersion_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return Whether the byoipApiVersion field is set.
   */
  @java.lang.Override
  public boolean hasByoipApiVersion() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return The byoipApiVersion.
   */
  @java.lang.Override
  public java.lang.String getByoipApiVersion() {
    java.lang.Object ref = byoipApiVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      byoipApiVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The version of BYOIP API.
   * Check the ByoipApiVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string byoip_api_version = 162683283;</code>
   *
   * @return The bytes for byoipApiVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getByoipApiVersionBytes() {
    java.lang.Object ref = byoipApiVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      byoipApiVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IP_CIDR_RANGE_FIELD_NUMBER = 98117322;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipCidrRange_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return Whether the ipCidrRange field is set.
   */
  @java.lang.Override
  public boolean hasIpCidrRange() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The ipCidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpCidrRange() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipCidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range, in CIDR format, represented by this public delegated prefix.
   * </pre>
   *
   * <code>optional string ip_cidr_range = 98117322;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpCidrRangeBytes() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipCidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_LIVE_MIGRATION_FIELD_NUMBER = 511823856;
  private boolean isLiveMigration_ = false;
  /**
   *
   *
   * <pre>
   * If true, the prefix will be live migrated.
   * </pre>
   *
   * <code>optional bool is_live_migration = 511823856;</code>
   *
   * @return Whether the isLiveMigration field is set.
   */
  @java.lang.Override
  public boolean hasIsLiveMigration() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * If true, the prefix will be live migrated.
   * </pre>
   *
   * <code>optional bool is_live_migration = 511823856;</code>
   *
   * @return The isLiveMigration.
   */
  @java.lang.Override
  public boolean getIsLiveMigration() {
    return isLiveMigration_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODE_FIELD_NUMBER = 3357091;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mode_ = "";
  /**
   *
   *
   * <pre>
   * The public delegated prefix mode for IPv6 only.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return Whether the mode field is set.
   */
  @java.lang.Override
  public boolean hasMode() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The public delegated prefix mode for IPv6 only.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public java.lang.String getMode() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The public delegated prefix mode for IPv6 only.
   * Check the Mode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string mode = 3357091;</code>
   *
   * @return The bytes for mode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModeBytes() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_PREFIX_FIELD_NUMBER = 15233991;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentPrefix_ = "";
  /**
   *
   *
   * <pre>
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string parent_prefix = 15233991;</code>
   *
   * @return Whether the parentPrefix field is set.
   */
  @java.lang.Override
  public boolean hasParentPrefix() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string parent_prefix = 15233991;</code>
   *
   * @return The parentPrefix.
   */
  @java.lang.Override
  public java.lang.String getParentPrefix() {
    java.lang.Object ref = parentPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
   * </pre>
   *
   * <code>optional string parent_prefix = 15233991;</code>
   *
   * @return The bytes for parentPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentPrefixBytes() {
    java.lang.Object ref = parentPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_DELEGATED_SUB_PREFIXS_FIELD_NUMBER = 188940044;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>
      publicDelegatedSubPrefixs_;
  /**
   *
   *
   * <pre>
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>
      getPublicDelegatedSubPrefixsList() {
    return publicDelegatedSubPrefixs_;
  }
  /**
   *
   *
   * <pre>
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder>
      getPublicDelegatedSubPrefixsOrBuilderList() {
    return publicDelegatedSubPrefixs_;
  }
  /**
   *
   *
   * <pre>
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
   * </code>
   */
  @java.lang.Override
  public int getPublicDelegatedSubPrefixsCount() {
    return publicDelegatedSubPrefixs_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix
      getPublicDelegatedSubPrefixs(int index) {
    return publicDelegatedSubPrefixs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of sub public delegated prefixes that exist for this public delegated prefix.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder
      getPublicDelegatedSubPrefixsOrBuilder(int index) {
    return publicDelegatedSubPrefixs_.get(index);
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3357091, mode_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15233991, parentPrefix_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(38427446, allocatablePrefixLength_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 162683283, byoipApiVersion_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    for (int i = 0; i < publicDelegatedSubPrefixs_.size(); i++) {
      output.writeMessage(188940044, publicDelegatedSubPrefixs_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(511823856, isLiveMigration_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3357091, mode_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15233991, parentPrefix_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              38427446, allocatablePrefixLength_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(98117322, ipCidrRange_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(162683283, byoipApiVersion_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    for (int i = 0; i < publicDelegatedSubPrefixs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              188940044, publicDelegatedSubPrefixs_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(511823856, isLiveMigration_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PublicDelegatedPrefix)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PublicDelegatedPrefix other =
        (com.google.cloud.compute.v1.PublicDelegatedPrefix) obj;

    if (hasAllocatablePrefixLength() != other.hasAllocatablePrefixLength()) return false;
    if (hasAllocatablePrefixLength()) {
      if (getAllocatablePrefixLength() != other.getAllocatablePrefixLength()) return false;
    }
    if (hasByoipApiVersion() != other.hasByoipApiVersion()) return false;
    if (hasByoipApiVersion()) {
      if (!getByoipApiVersion().equals(other.getByoipApiVersion())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIpCidrRange() != other.hasIpCidrRange()) return false;
    if (hasIpCidrRange()) {
      if (!getIpCidrRange().equals(other.getIpCidrRange())) return false;
    }
    if (hasIsLiveMigration() != other.hasIsLiveMigration()) return false;
    if (hasIsLiveMigration()) {
      if (getIsLiveMigration() != other.getIsLiveMigration()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMode() != other.hasMode()) return false;
    if (hasMode()) {
      if (!getMode().equals(other.getMode())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasParentPrefix() != other.hasParentPrefix()) return false;
    if (hasParentPrefix()) {
      if (!getParentPrefix().equals(other.getParentPrefix())) return false;
    }
    if (!getPublicDelegatedSubPrefixsList().equals(other.getPublicDelegatedSubPrefixsList()))
      return false;
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAllocatablePrefixLength()) {
      hash = (37 * hash) + ALLOCATABLE_PREFIX_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getAllocatablePrefixLength();
    }
    if (hasByoipApiVersion()) {
      hash = (37 * hash) + BYOIP_API_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getByoipApiVersion().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIpCidrRange()) {
      hash = (37 * hash) + IP_CIDR_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIpCidrRange().hashCode();
    }
    if (hasIsLiveMigration()) {
      hash = (37 * hash) + IS_LIVE_MIGRATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLiveMigration());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMode()) {
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + getMode().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasParentPrefix()) {
      hash = (37 * hash) + PARENT_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getParentPrefix().hashCode();
    }
    if (getPublicDelegatedSubPrefixsCount() > 0) {
      hash = (37 * hash) + PUBLIC_DELEGATED_SUB_PREFIXS_FIELD_NUMBER;
      hash = (53 * hash) + getPublicDelegatedSubPrefixsList().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PublicDelegatedPrefix prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A PublicDelegatedPrefix resource represents an IP block within a PublicAdvertisedPrefix that is configured within a single cloud scope (global or region). IPs in the block can be allocated to resources within that scope. Public delegated prefixes may be further broken up into smaller IP blocks in the same scope as the parent block.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PublicDelegatedPrefix}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PublicDelegatedPrefix)
      com.google.cloud.compute.v1.PublicDelegatedPrefixOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicDelegatedPrefix_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicDelegatedPrefix_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PublicDelegatedPrefix.class,
              com.google.cloud.compute.v1.PublicDelegatedPrefix.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PublicDelegatedPrefix.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allocatablePrefixLength_ = 0;
      byoipApiVersion_ = "";
      creationTimestamp_ = "";
      description_ = "";
      fingerprint_ = "";
      id_ = 0L;
      ipCidrRange_ = "";
      isLiveMigration_ = false;
      kind_ = "";
      mode_ = "";
      name_ = "";
      parentPrefix_ = "";
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        publicDelegatedSubPrefixs_ = java.util.Collections.emptyList();
      } else {
        publicDelegatedSubPrefixs_ = null;
        publicDelegatedSubPrefixsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      region_ = "";
      selfLink_ = "";
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PublicDelegatedPrefix_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicDelegatedPrefix getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PublicDelegatedPrefix.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicDelegatedPrefix build() {
      com.google.cloud.compute.v1.PublicDelegatedPrefix result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PublicDelegatedPrefix buildPartial() {
      com.google.cloud.compute.v1.PublicDelegatedPrefix result =
          new com.google.cloud.compute.v1.PublicDelegatedPrefix(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.PublicDelegatedPrefix result) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          publicDelegatedSubPrefixs_ =
              java.util.Collections.unmodifiableList(publicDelegatedSubPrefixs_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.publicDelegatedSubPrefixs_ = publicDelegatedSubPrefixs_;
      } else {
        result.publicDelegatedSubPrefixs_ = publicDelegatedSubPrefixsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.PublicDelegatedPrefix result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allocatablePrefixLength_ = allocatablePrefixLength_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.byoipApiVersion_ = byoipApiVersion_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ipCidrRange_ = ipCidrRange_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.isLiveMigration_ = isLiveMigration_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.mode_ = mode_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.parentPrefix_ = parentPrefix_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PublicDelegatedPrefix) {
        return mergeFrom((com.google.cloud.compute.v1.PublicDelegatedPrefix) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PublicDelegatedPrefix other) {
      if (other == com.google.cloud.compute.v1.PublicDelegatedPrefix.getDefaultInstance())
        return this;
      if (other.hasAllocatablePrefixLength()) {
        setAllocatablePrefixLength(other.getAllocatablePrefixLength());
      }
      if (other.hasByoipApiVersion()) {
        byoipApiVersion_ = other.byoipApiVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIpCidrRange()) {
        ipCidrRange_ = other.ipCidrRange_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasIsLiveMigration()) {
        setIsLiveMigration(other.getIsLiveMigration());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasMode()) {
        mode_ = other.mode_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasParentPrefix()) {
        parentPrefix_ = other.parentPrefix_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        if (!other.publicDelegatedSubPrefixs_.isEmpty()) {
          if (publicDelegatedSubPrefixs_.isEmpty()) {
            publicDelegatedSubPrefixs_ = other.publicDelegatedSubPrefixs_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensurePublicDelegatedSubPrefixsIsMutable();
            publicDelegatedSubPrefixs_.addAll(other.publicDelegatedSubPrefixs_);
          }
          onChanged();
        }
      } else {
        if (!other.publicDelegatedSubPrefixs_.isEmpty()) {
          if (publicDelegatedSubPrefixsBuilder_.isEmpty()) {
            publicDelegatedSubPrefixsBuilder_.dispose();
            publicDelegatedSubPrefixsBuilder_ = null;
            publicDelegatedSubPrefixs_ = other.publicDelegatedSubPrefixs_;
            bitField0_ = (bitField0_ & ~0x00001000);
            publicDelegatedSubPrefixsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPublicDelegatedSubPrefixsFieldBuilder()
                    : null;
          } else {
            publicDelegatedSubPrefixsBuilder_.addAllMessages(other.publicDelegatedSubPrefixs_);
          }
        }
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26336418
            case 26856730:
              {
                mode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26856730
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 121871930:
              {
                parentPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 121871930
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 307419568:
              {
                allocatablePrefixLength_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 307419568
            case 784938578:
              {
                ipCidrRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 784938578
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1111570338
            case 1301466266:
              {
                byoipApiVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1301466266
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 1450082194
            case 1511520354:
              {
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix
                            .parser(),
                        extensionRegistry);
                if (publicDelegatedSubPrefixsBuilder_ == null) {
                  ensurePublicDelegatedSubPrefixsIsMutable();
                  publicDelegatedSubPrefixs_.add(m);
                } else {
                  publicDelegatedSubPrefixsBuilder_.addMessage(m);
                }
                break;
              } // case 1511520354
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1877428002
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            case -200376448:
              {
                isLiveMigration_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case -200376448
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int allocatablePrefixLength_;
    /**
     *
     *
     * <pre>
     * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
     * </pre>
     *
     * <code>optional int32 allocatable_prefix_length = 38427446;</code>
     *
     * @return Whether the allocatablePrefixLength field is set.
     */
    @java.lang.Override
    public boolean hasAllocatablePrefixLength() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
     * </pre>
     *
     * <code>optional int32 allocatable_prefix_length = 38427446;</code>
     *
     * @return The allocatablePrefixLength.
     */
    @java.lang.Override
    public int getAllocatablePrefixLength() {
      return allocatablePrefixLength_;
    }
    /**
     *
     *
     * <pre>
     * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
     * </pre>
     *
     * <code>optional int32 allocatable_prefix_length = 38427446;</code>
     *
     * @param value The allocatablePrefixLength to set.
     * @return This builder for chaining.
     */
    public Builder setAllocatablePrefixLength(int value) {

      allocatablePrefixLength_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
     * </pre>
     *
     * <code>optional int32 allocatable_prefix_length = 38427446;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllocatablePrefixLength() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allocatablePrefixLength_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object byoipApiVersion_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return Whether the byoipApiVersion field is set.
     */
    public boolean hasByoipApiVersion() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return The byoipApiVersion.
     */
    public java.lang.String getByoipApiVersion() {
      java.lang.Object ref = byoipApiVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        byoipApiVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return The bytes for byoipApiVersion.
     */
    public com.google.protobuf.ByteString getByoipApiVersionBytes() {
      java.lang.Object ref = byoipApiVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        byoipApiVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @param value The byoipApiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setByoipApiVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      byoipApiVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearByoipApiVersion() {
      byoipApiVersion_ = getDefaultInstance().getByoipApiVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The version of BYOIP API.
     * Check the ByoipApiVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string byoip_api_version = 162683283;</code>
     *
     * @param value The bytes for byoipApiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setByoipApiVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      byoipApiVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a new PublicDelegatedPrefix. An up-to-date fingerprint must be provided in order to update the PublicDelegatedPrefix, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object ipCidrRange_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return Whether the ipCidrRange field is set.
     */
    public boolean hasIpCidrRange() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The ipCidrRange.
     */
    public java.lang.String getIpCidrRange() {
      java.lang.Object ref = ipCidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipCidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return The bytes for ipCidrRange.
     */
    public com.google.protobuf.ByteString getIpCidrRangeBytes() {
      java.lang.Object ref = ipCidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipCidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipCidrRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpCidrRange() {
      ipCidrRange_ = getDefaultInstance().getIpCidrRange();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range, in CIDR format, represented by this public delegated prefix.
     * </pre>
     *
     * <code>optional string ip_cidr_range = 98117322;</code>
     *
     * @param value The bytes for ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipCidrRange_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean isLiveMigration_;
    /**
     *
     *
     * <pre>
     * If true, the prefix will be live migrated.
     * </pre>
     *
     * <code>optional bool is_live_migration = 511823856;</code>
     *
     * @return Whether the isLiveMigration field is set.
     */
    @java.lang.Override
    public boolean hasIsLiveMigration() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * If true, the prefix will be live migrated.
     * </pre>
     *
     * <code>optional bool is_live_migration = 511823856;</code>
     *
     * @return The isLiveMigration.
     */
    @java.lang.Override
    public boolean getIsLiveMigration() {
      return isLiveMigration_;
    }
    /**
     *
     *
     * <pre>
     * If true, the prefix will be live migrated.
     * </pre>
     *
     * <code>optional bool is_live_migration = 511823856;</code>
     *
     * @param value The isLiveMigration to set.
     * @return This builder for chaining.
     */
    public Builder setIsLiveMigration(boolean value) {

      isLiveMigration_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the prefix will be live migrated.
     * </pre>
     *
     * <code>optional bool is_live_migration = 511823856;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsLiveMigration() {
      bitField0_ = (bitField0_ & ~0x00000080);
      isLiveMigration_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#publicDelegatedPrefix for public delegated prefixes.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object mode_ = "";
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return Whether the mode field is set.
     */
    public boolean hasMode() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return The mode.
     */
    public java.lang.String getMode() {
      java.lang.Object ref = mode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return The bytes for mode.
     */
    public com.google.protobuf.ByteString getModeBytes() {
      java.lang.Object ref = mode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mode_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      mode_ = getDefaultInstance().getMode();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public delegated prefix mode for IPv6 only.
     * Check the Mode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string mode = 3357091;</code>
     *
     * @param value The bytes for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mode_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object parentPrefix_ = "";
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @return Whether the parentPrefix field is set.
     */
    public boolean hasParentPrefix() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @return The parentPrefix.
     */
    public java.lang.String getParentPrefix() {
      java.lang.Object ref = parentPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @return The bytes for parentPrefix.
     */
    public com.google.protobuf.ByteString getParentPrefixBytes() {
      java.lang.Object ref = parentPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @param value The parentPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setParentPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentPrefix_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentPrefix() {
      parentPrefix_ = getDefaultInstance().getParentPrefix();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
     * </pre>
     *
     * <code>optional string parent_prefix = 15233991;</code>
     *
     * @param value The bytes for parentPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setParentPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentPrefix_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>
        publicDelegatedSubPrefixs_ = java.util.Collections.emptyList();

    private void ensurePublicDelegatedSubPrefixsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        publicDelegatedSubPrefixs_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>(
                publicDelegatedSubPrefixs_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix,
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder,
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder>
        publicDelegatedSubPrefixsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>
        getPublicDelegatedSubPrefixsList() {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(publicDelegatedSubPrefixs_);
      } else {
        return publicDelegatedSubPrefixsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public int getPublicDelegatedSubPrefixsCount() {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        return publicDelegatedSubPrefixs_.size();
      } else {
        return publicDelegatedSubPrefixsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix
        getPublicDelegatedSubPrefixs(int index) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        return publicDelegatedSubPrefixs_.get(index);
      } else {
        return publicDelegatedSubPrefixsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder setPublicDelegatedSubPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix value) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.set(index, value);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder setPublicDelegatedSubPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
            builderForValue) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.set(index, builderForValue.build());
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder addPublicDelegatedSubPrefixs(
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix value) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.add(value);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder addPublicDelegatedSubPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix value) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.add(index, value);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder addPublicDelegatedSubPrefixs(
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
            builderForValue) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.add(builderForValue.build());
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder addPublicDelegatedSubPrefixs(
        int index,
        com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
            builderForValue) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.add(index, builderForValue.build());
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder addAllPublicDelegatedSubPrefixs(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix>
            values) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        ensurePublicDelegatedSubPrefixsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, publicDelegatedSubPrefixs_);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder clearPublicDelegatedSubPrefixs() {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        publicDelegatedSubPrefixs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public Builder removePublicDelegatedSubPrefixs(int index) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        ensurePublicDelegatedSubPrefixsIsMutable();
        publicDelegatedSubPrefixs_.remove(index);
        onChanged();
      } else {
        publicDelegatedSubPrefixsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
        getPublicDelegatedSubPrefixsBuilder(int index) {
      return getPublicDelegatedSubPrefixsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder
        getPublicDelegatedSubPrefixsOrBuilder(int index) {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        return publicDelegatedSubPrefixs_.get(index);
      } else {
        return publicDelegatedSubPrefixsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder>
        getPublicDelegatedSubPrefixsOrBuilderList() {
      if (publicDelegatedSubPrefixsBuilder_ != null) {
        return publicDelegatedSubPrefixsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(publicDelegatedSubPrefixs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
        addPublicDelegatedSubPrefixsBuilder() {
      return getPublicDelegatedSubPrefixsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder
        addPublicDelegatedSubPrefixsBuilder(int index) {
      return getPublicDelegatedSubPrefixsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of sub public delegated prefixes that exist for this public delegated prefix.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix public_delegated_sub_prefixs = 188940044;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder>
        getPublicDelegatedSubPrefixsBuilderList() {
      return getPublicDelegatedSubPrefixsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix,
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder,
            com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder>
        getPublicDelegatedSubPrefixsFieldBuilder() {
      if (publicDelegatedSubPrefixsBuilder_ == null) {
        publicDelegatedSubPrefixsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix,
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefix.Builder,
                com.google.cloud.compute.v1.PublicDelegatedPrefixPublicDelegatedSubPrefixOrBuilder>(
                publicDelegatedSubPrefixs_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        publicDelegatedSubPrefixs_ = null;
      }
      return publicDelegatedSubPrefixsBuilder_;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the public delegated prefix resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PublicDelegatedPrefix)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PublicDelegatedPrefix)
  private static final com.google.cloud.compute.v1.PublicDelegatedPrefix DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PublicDelegatedPrefix();
  }

  public static com.google.cloud.compute.v1.PublicDelegatedPrefix getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublicDelegatedPrefix> PARSER =
      new com.google.protobuf.AbstractParser<PublicDelegatedPrefix>() {
        @java.lang.Override
        public PublicDelegatedPrefix parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PublicDelegatedPrefix> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublicDelegatedPrefix> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PublicDelegatedPrefix getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
