/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * RegionInstanceGroupManagers.applyUpdatesToInstances
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest}
 */
public final class RegionInstanceGroupManagersApplyUpdatesRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest)
    RegionInstanceGroupManagersApplyUpdatesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RegionInstanceGroupManagersApplyUpdatesRequest.newBuilder() to construct.
  private RegionInstanceGroupManagersApplyUpdatesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RegionInstanceGroupManagersApplyUpdatesRequest() {
    instances_ = com.google.protobuf.LazyStringArrayList.emptyList();
    minimalAction_ = "";
    mostDisruptiveAllowedAction_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RegionInstanceGroupManagersApplyUpdatesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RegionInstanceGroupManagersApplyUpdatesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RegionInstanceGroupManagersApplyUpdatesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.class,
            com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * NONE
   * REFRESH
   * REPLACE
   * RESTART
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.MinimalAction}
   */
  public enum MinimalAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MINIMAL_ACTION = 0;</code>
     */
    UNDEFINED_MINIMAL_ACTION(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MINIMAL_ACTION = 0;</code>
     */
    public static final int UNDEFINED_MINIMAL_ACTION_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MinimalAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MinimalAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MINIMAL_ACTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MinimalAction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MinimalAction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MinimalAction>() {
          public MinimalAction findValueByNumber(int number) {
            return MinimalAction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MinimalAction[] VALUES = values();

    public static MinimalAction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MinimalAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.MinimalAction)
  }

  /**
   *
   *
   * <pre>
   * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
   * Additional supported values which may be not listed in the enum directly due to technical reasons:
   * NONE
   * REFRESH
   * REPLACE
   * RESTART
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.MostDisruptiveAllowedAction}
   */
  public enum MostDisruptiveAllowedAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION = 0;</code>
     */
    UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION(0),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION = 0;</code>
     */
    public static final int UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION_VALUE = 0;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MostDisruptiveAllowedAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MostDisruptiveAllowedAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MostDisruptiveAllowedAction>() {
              public MostDisruptiveAllowedAction findValueByNumber(int number) {
                return MostDisruptiveAllowedAction.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
          .getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final MostDisruptiveAllowedAction[] VALUES = values();

    public static MostDisruptiveAllowedAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MostDisruptiveAllowedAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.MostDisruptiveAllowedAction)
  }

  private int bitField0_;
  public static final int ALL_INSTANCES_FIELD_NUMBER = 403676512;
  private boolean allInstances_ = false;
  /**
   *
   *
   * <pre>
   * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
   * </pre>
   *
   * <code>optional bool all_instances = 403676512;</code>
   *
   * @return Whether the allInstances field is set.
   */
  @java.lang.Override
  public boolean hasAllInstances() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
   * </pre>
   *
   * <code>optional bool all_instances = 403676512;</code>
   *
   * @return The allInstances.
   */
  @java.lang.Override
  public boolean getAllInstances() {
    return allInstances_;
  }

  public static final int INSTANCES_FIELD_NUMBER = 29097598;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instances_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   * </pre>
   *
   * <code>repeated string instances = 29097598;</code>
   *
   * @return A list containing the instances.
   */
  public com.google.protobuf.ProtocolStringList getInstancesList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   * </pre>
   *
   * <code>repeated string instances = 29097598;</code>
   *
   * @return The count of instances.
   */
  public int getInstancesCount() {
    return instances_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   * </pre>
   *
   * <code>repeated string instances = 29097598;</code>
   *
   * @param index The index of the element to return.
   * @return The instances at the given index.
   */
  public java.lang.String getInstances(int index) {
    return instances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
   * </pre>
   *
   * <code>repeated string instances = 29097598;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instances at the given index.
   */
  public com.google.protobuf.ByteString getInstancesBytes(int index) {
    return instances_.getByteString(index);
  }

  public static final int MINIMAL_ACTION_FIELD_NUMBER = 270567060;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minimalAction_ = "";
  /**
   *
   *
   * <pre>
   * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return Whether the minimalAction field is set.
   */
  @java.lang.Override
  public boolean hasMinimalAction() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return The minimalAction.
   */
  @java.lang.Override
  public java.lang.String getMinimalAction() {
    java.lang.Object ref = minimalAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minimalAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
   * Check the MinimalAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string minimal_action = 270567060;</code>
   *
   * @return The bytes for minimalAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinimalActionBytes() {
    java.lang.Object ref = minimalAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minimalAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MOST_DISRUPTIVE_ALLOWED_ACTION_FIELD_NUMBER = 66103053;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mostDisruptiveAllowedAction_ = "";
  /**
   *
   *
   * <pre>
   * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return Whether the mostDisruptiveAllowedAction field is set.
   */
  @java.lang.Override
  public boolean hasMostDisruptiveAllowedAction() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return The mostDisruptiveAllowedAction.
   */
  @java.lang.Override
  public java.lang.String getMostDisruptiveAllowedAction() {
    java.lang.Object ref = mostDisruptiveAllowedAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mostDisruptiveAllowedAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
   * Check the MostDisruptiveAllowedAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string most_disruptive_allowed_action = 66103053;</code>
   *
   * @return The bytes for mostDisruptiveAllowedAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMostDisruptiveAllowedActionBytes() {
    java.lang.Object ref = mostDisruptiveAllowedAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mostDisruptiveAllowedAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < instances_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29097598, instances_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 66103053, mostDisruptiveAllowedAction_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 270567060, minimalAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(403676512, allInstances_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < instances_.size(); i++) {
        dataSize += computeStringSizeNoTag(instances_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getInstancesList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              66103053, mostDisruptiveAllowedAction_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(270567060, minimalAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(403676512, allInstances_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest other =
        (com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest) obj;

    if (hasAllInstances() != other.hasAllInstances()) return false;
    if (hasAllInstances()) {
      if (getAllInstances() != other.getAllInstances()) return false;
    }
    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (hasMinimalAction() != other.hasMinimalAction()) return false;
    if (hasMinimalAction()) {
      if (!getMinimalAction().equals(other.getMinimalAction())) return false;
    }
    if (hasMostDisruptiveAllowedAction() != other.hasMostDisruptiveAllowedAction()) return false;
    if (hasMostDisruptiveAllowedAction()) {
      if (!getMostDisruptiveAllowedAction().equals(other.getMostDisruptiveAllowedAction()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAllInstances()) {
      hash = (37 * hash) + ALL_INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllInstances());
    }
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (hasMinimalAction()) {
      hash = (37 * hash) + MINIMAL_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getMinimalAction().hashCode();
    }
    if (hasMostDisruptiveAllowedAction()) {
      hash = (37 * hash) + MOST_DISRUPTIVE_ALLOWED_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getMostDisruptiveAllowedAction().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * RegionInstanceGroupManagers.applyUpdatesToInstances
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest)
      com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RegionInstanceGroupManagersApplyUpdatesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RegionInstanceGroupManagersApplyUpdatesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.class,
              com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allInstances_ = false;
      instances_ = com.google.protobuf.LazyStringArrayList.emptyList();
      minimalAction_ = "";
      mostDisruptiveAllowedAction_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RegionInstanceGroupManagersApplyUpdatesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest build() {
      com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
        buildPartial() {
      com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest result =
          new com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allInstances_ = allInstances_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        instances_.makeImmutable();
        result.instances_ = instances_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.minimalAction_ = minimalAction_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mostDisruptiveAllowedAction_ = mostDisruptiveAllowedAction_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest) {
        return mergeFrom(
            (com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest other) {
      if (other
          == com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
              .getDefaultInstance()) return this;
      if (other.hasAllInstances()) {
        setAllInstances(other.getAllInstances());
      }
      if (!other.instances_.isEmpty()) {
        if (instances_.isEmpty()) {
          instances_ = other.instances_;
          bitField0_ |= 0x00000002;
        } else {
          ensureInstancesIsMutable();
          instances_.addAll(other.instances_);
        }
        onChanged();
      }
      if (other.hasMinimalAction()) {
        minimalAction_ = other.minimalAction_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasMostDisruptiveAllowedAction()) {
        mostDisruptiveAllowedAction_ = other.mostDisruptiveAllowedAction_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 232780786:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstancesIsMutable();
                instances_.add(s);
                break;
              } // case 232780786
            case 528824426:
              {
                mostDisruptiveAllowedAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 528824426
            case -2130430814:
              {
                minimalAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -2130430814
            case -1065555200:
              {
                allInstances_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -1065555200
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean allInstances_;
    /**
     *
     *
     * <pre>
     * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
     * </pre>
     *
     * <code>optional bool all_instances = 403676512;</code>
     *
     * @return Whether the allInstances field is set.
     */
    @java.lang.Override
    public boolean hasAllInstances() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
     * </pre>
     *
     * <code>optional bool all_instances = 403676512;</code>
     *
     * @return The allInstances.
     */
    @java.lang.Override
    public boolean getAllInstances() {
      return allInstances_;
    }
    /**
     *
     *
     * <pre>
     * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
     * </pre>
     *
     * <code>optional bool all_instances = 403676512;</code>
     *
     * @param value The allInstances to set.
     * @return This builder for chaining.
     */
    public Builder setAllInstances(boolean value) {

      allInstances_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flag to update all instances instead of specified list of “instances”. If the flag is set to true then the instances may not be specified in the request.
     * </pre>
     *
     * <code>optional bool all_instances = 403676512;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllInstances() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allInstances_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instances_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstancesIsMutable() {
      if (!instances_.isModifiable()) {
        instances_ = new com.google.protobuf.LazyStringArrayList(instances_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @return A list containing the instances.
     */
    public com.google.protobuf.ProtocolStringList getInstancesList() {
      instances_.makeImmutable();
      return instances_;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @return The count of instances.
     */
    public int getInstancesCount() {
      return instances_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param index The index of the element to return.
     * @return The instances at the given index.
     */
    public java.lang.String getInstances(int index) {
      return instances_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instances at the given index.
     */
    public com.google.protobuf.ByteString getInstancesBytes(int index) {
      return instances_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param index The index to set the value at.
     * @param value The instances to set.
     * @return This builder for chaining.
     */
    public Builder setInstances(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstancesIsMutable();
      instances_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param value The instances to add.
     * @return This builder for chaining.
     */
    public Builder addInstances(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstancesIsMutable();
      instances_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param values The instances to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstances(java.lang.Iterable<java.lang.String> values) {
      ensureInstancesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstances() {
      instances_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of URLs of one or more instances for which you want to apply updates. Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
     * </pre>
     *
     * <code>repeated string instances = 29097598;</code>
     *
     * @param value The bytes of the instances to add.
     * @return This builder for chaining.
     */
    public Builder addInstancesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstancesIsMutable();
      instances_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object minimalAction_ = "";
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return Whether the minimalAction field is set.
     */
    public boolean hasMinimalAction() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return The minimalAction.
     */
    public java.lang.String getMinimalAction() {
      java.lang.Object ref = minimalAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minimalAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return The bytes for minimalAction.
     */
    public com.google.protobuf.ByteString getMinimalActionBytes() {
      java.lang.Object ref = minimalAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minimalAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @param value The minimalAction to set.
     * @return This builder for chaining.
     */
    public Builder setMinimalAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minimalAction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinimalAction() {
      minimalAction_ = getDefaultInstance().getMinimalAction();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
     * Check the MinimalAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string minimal_action = 270567060;</code>
     *
     * @param value The bytes for minimalAction to set.
     * @return This builder for chaining.
     */
    public Builder setMinimalActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minimalAction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object mostDisruptiveAllowedAction_ = "";
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return Whether the mostDisruptiveAllowedAction field is set.
     */
    public boolean hasMostDisruptiveAllowedAction() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return The mostDisruptiveAllowedAction.
     */
    public java.lang.String getMostDisruptiveAllowedAction() {
      java.lang.Object ref = mostDisruptiveAllowedAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mostDisruptiveAllowedAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return The bytes for mostDisruptiveAllowedAction.
     */
    public com.google.protobuf.ByteString getMostDisruptiveAllowedActionBytes() {
      java.lang.Object ref = mostDisruptiveAllowedAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mostDisruptiveAllowedAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @param value The mostDisruptiveAllowedAction to set.
     * @return This builder for chaining.
     */
    public Builder setMostDisruptiveAllowedAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mostDisruptiveAllowedAction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMostDisruptiveAllowedAction() {
      mostDisruptiveAllowedAction_ = getDefaultInstance().getMostDisruptiveAllowedAction();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
     * Check the MostDisruptiveAllowedAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string most_disruptive_allowed_action = 66103053;</code>
     *
     * @param value The bytes for mostDisruptiveAllowedAction to set.
     * @return This builder for chaining.
     */
    public Builder setMostDisruptiveAllowedActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mostDisruptiveAllowedAction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest)
  private static final com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest();
  }

  public static com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RegionInstanceGroupManagersApplyUpdatesRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<RegionInstanceGroupManagersApplyUpdatesRequest>() {
            @java.lang.Override
            public RegionInstanceGroupManagersApplyUpdatesRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<RegionInstanceGroupManagersApplyUpdatesRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RegionInstanceGroupManagersApplyUpdatesRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RegionInstanceGroupManagersApplyUpdatesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
