/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Resource Policy resource. You can use resource policies to schedule actions for some Compute Engine resources. For example, you can use them to schedule persistent disk snapshots.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ResourcePolicy}
 */
public final class ResourcePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourcePolicy)
    ResourcePolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourcePolicy.newBuilder() to construct.
  private ResourcePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePolicy() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    region_ = "";
    selfLink_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourcePolicy.class,
            com.google.cloud.compute.v1.ResourcePolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of resource policy creation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ResourcePolicy.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Resource policy is being created.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * Resource policy is being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * Resource policy is expired and will not run again.
     * </pre>
     *
     * <code>EXPIRED = 482489093;</code>
     */
    EXPIRED(482489093),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /**
     *
     *
     * <pre>
     * Resource policy is ready to be used.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Resource policy is being created.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;
    /**
     *
     *
     * <pre>
     * Resource policy is being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * Resource policy is expired and will not run again.
     * </pre>
     *
     * <code>EXPIRED = 482489093;</code>
     */
    public static final int EXPIRED_VALUE = 482489093;
    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;
    /**
     *
     *
     * <pre>
     * Resource policy is ready to be used.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 482489093:
          return EXPIRED;
        case 530283991:
          return INVALID;
        case 77848963:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ResourcePolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ResourcePolicy.Status)
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_CONSISTENCY_GROUP_POLICY_FIELD_NUMBER = 473727515;
  private com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
      diskConsistencyGroupPolicy_;
  /**
   *
   *
   * <pre>
   * Resource policy for disk consistency groups.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
   * </code>
   *
   * @return Whether the diskConsistencyGroupPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDiskConsistencyGroupPolicy() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Resource policy for disk consistency groups.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
   * </code>
   *
   * @return The diskConsistencyGroupPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
      getDiskConsistencyGroupPolicy() {
    return diskConsistencyGroupPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.getDefaultInstance()
        : diskConsistencyGroupPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Resource policy for disk consistency groups.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicyOrBuilder
      getDiskConsistencyGroupPolicyOrBuilder() {
    return diskConsistencyGroupPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.getDefaultInstance()
        : diskConsistencyGroupPolicy_;
  }

  public static final int GROUP_PLACEMENT_POLICY_FIELD_NUMBER = 10931596;
  private com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy groupPlacementPolicy_;
  /**
   *
   *
   * <pre>
   * Resource policy for instances for placement configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
   * </code>
   *
   * @return Whether the groupPlacementPolicy field is set.
   */
  @java.lang.Override
  public boolean hasGroupPlacementPolicy() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Resource policy for instances for placement configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
   * </code>
   *
   * @return The groupPlacementPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy getGroupPlacementPolicy() {
    return groupPlacementPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.getDefaultInstance()
        : groupPlacementPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Resource policy for instances for placement configuration.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicyOrBuilder
      getGroupPlacementPolicyOrBuilder() {
    return groupPlacementPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.getDefaultInstance()
        : groupPlacementPolicy_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSTANCE_SCHEDULE_POLICY_FIELD_NUMBER = 344877104;
  private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instanceSchedulePolicy_;
  /**
   *
   *
   * <pre>
   * Resource policy for scheduling instance operations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
   * </code>
   *
   * @return Whether the instanceSchedulePolicy field is set.
   */
  @java.lang.Override
  public boolean hasInstanceSchedulePolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Resource policy for scheduling instance operations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
   * </code>
   *
   * @return The instanceSchedulePolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
      getInstanceSchedulePolicy() {
    return instanceSchedulePolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance()
        : instanceSchedulePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Resource policy for scheduling instance operations.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder
      getInstanceSchedulePolicyOrBuilder() {
    return instanceSchedulePolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance()
        : instanceSchedulePolicy_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_STATUS_FIELD_NUMBER = 249429315;
  private com.google.cloud.compute.v1.ResourcePolicyResourceStatus resourceStatus_;
  /**
   *
   *
   * <pre>
   * [Output Only] The system status of the resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return Whether the resourceStatus field is set.
   */
  @java.lang.Override
  public boolean hasResourceStatus() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The system status of the resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return The resourceStatus.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyResourceStatus getResourceStatus() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The system status of the resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicyResourceStatusOrBuilder
      getResourceStatusOrBuilder() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.ResourcePolicyResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_SCHEDULE_POLICY_FIELD_NUMBER = 218131295;
  private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshotSchedulePolicy_;
  /**
   *
   *
   * <pre>
   * Resource policy for persistent disks for creating snapshots.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
   * </code>
   *
   * @return Whether the snapshotSchedulePolicy field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotSchedulePolicy() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Resource policy for persistent disks for creating snapshots.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
   * </code>
   *
   * @return The snapshotSchedulePolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
      getSnapshotSchedulePolicy() {
    return snapshotSchedulePolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance()
        : snapshotSchedulePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Resource policy for persistent disks for creating snapshots.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder
      getSnapshotSchedulePolicyOrBuilder() {
    return snapshotSchedulePolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance()
        : snapshotSchedulePolicy_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The status of resource policy creation.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of resource policy creation.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of resource policy creation.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10931596, getGroupPlacementPolicy());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(218131295, getSnapshotSchedulePolicy());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(344877104, getInstanceSchedulePolicy());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(473727515, getDiskConsistencyGroupPolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10931596, getGroupPlacementPolicy());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              218131295, getSnapshotSchedulePolicy());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              344877104, getInstanceSchedulePolicy());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              473727515, getDiskConsistencyGroupPolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ResourcePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourcePolicy other =
        (com.google.cloud.compute.v1.ResourcePolicy) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDiskConsistencyGroupPolicy() != other.hasDiskConsistencyGroupPolicy()) return false;
    if (hasDiskConsistencyGroupPolicy()) {
      if (!getDiskConsistencyGroupPolicy().equals(other.getDiskConsistencyGroupPolicy()))
        return false;
    }
    if (hasGroupPlacementPolicy() != other.hasGroupPlacementPolicy()) return false;
    if (hasGroupPlacementPolicy()) {
      if (!getGroupPlacementPolicy().equals(other.getGroupPlacementPolicy())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInstanceSchedulePolicy() != other.hasInstanceSchedulePolicy()) return false;
    if (hasInstanceSchedulePolicy()) {
      if (!getInstanceSchedulePolicy().equals(other.getInstanceSchedulePolicy())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasResourceStatus() != other.hasResourceStatus()) return false;
    if (hasResourceStatus()) {
      if (!getResourceStatus().equals(other.getResourceStatus())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSnapshotSchedulePolicy() != other.hasSnapshotSchedulePolicy()) return false;
    if (hasSnapshotSchedulePolicy()) {
      if (!getSnapshotSchedulePolicy().equals(other.getSnapshotSchedulePolicy())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDiskConsistencyGroupPolicy()) {
      hash = (37 * hash) + DISK_CONSISTENCY_GROUP_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDiskConsistencyGroupPolicy().hashCode();
    }
    if (hasGroupPlacementPolicy()) {
      hash = (37 * hash) + GROUP_PLACEMENT_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getGroupPlacementPolicy().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInstanceSchedulePolicy()) {
      hash = (37 * hash) + INSTANCE_SCHEDULE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceSchedulePolicy().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasResourceStatus()) {
      hash = (37 * hash) + RESOURCE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceStatus().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSnapshotSchedulePolicy()) {
      hash = (37 * hash) + SNAPSHOT_SCHEDULE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotSchedulePolicy().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ResourcePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Resource Policy resource. You can use resource policies to schedule actions for some Compute Engine resources. For example, you can use them to schedule persistent disk snapshots.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ResourcePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourcePolicy)
      com.google.cloud.compute.v1.ResourcePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourcePolicy.class,
              com.google.cloud.compute.v1.ResourcePolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ResourcePolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDiskConsistencyGroupPolicyFieldBuilder();
        getGroupPlacementPolicyFieldBuilder();
        getInstanceSchedulePolicyFieldBuilder();
        getResourceStatusFieldBuilder();
        getSnapshotSchedulePolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      description_ = "";
      diskConsistencyGroupPolicy_ = null;
      if (diskConsistencyGroupPolicyBuilder_ != null) {
        diskConsistencyGroupPolicyBuilder_.dispose();
        diskConsistencyGroupPolicyBuilder_ = null;
      }
      groupPlacementPolicy_ = null;
      if (groupPlacementPolicyBuilder_ != null) {
        groupPlacementPolicyBuilder_.dispose();
        groupPlacementPolicyBuilder_ = null;
      }
      id_ = 0L;
      instanceSchedulePolicy_ = null;
      if (instanceSchedulePolicyBuilder_ != null) {
        instanceSchedulePolicyBuilder_.dispose();
        instanceSchedulePolicyBuilder_ = null;
      }
      kind_ = "";
      name_ = "";
      region_ = "";
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      selfLink_ = "";
      snapshotSchedulePolicy_ = null;
      if (snapshotSchedulePolicyBuilder_ != null) {
        snapshotSchedulePolicyBuilder_.dispose();
        snapshotSchedulePolicyBuilder_ = null;
      }
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourcePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicy build() {
      com.google.cloud.compute.v1.ResourcePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicy buildPartial() {
      com.google.cloud.compute.v1.ResourcePolicy result =
          new com.google.cloud.compute.v1.ResourcePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.ResourcePolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.diskConsistencyGroupPolicy_ =
            diskConsistencyGroupPolicyBuilder_ == null
                ? diskConsistencyGroupPolicy_
                : diskConsistencyGroupPolicyBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.groupPlacementPolicy_ =
            groupPlacementPolicyBuilder_ == null
                ? groupPlacementPolicy_
                : groupPlacementPolicyBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.instanceSchedulePolicy_ =
            instanceSchedulePolicyBuilder_ == null
                ? instanceSchedulePolicy_
                : instanceSchedulePolicyBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.resourceStatus_ =
            resourceStatusBuilder_ == null ? resourceStatus_ : resourceStatusBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.snapshotSchedulePolicy_ =
            snapshotSchedulePolicyBuilder_ == null
                ? snapshotSchedulePolicy_
                : snapshotSchedulePolicyBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ResourcePolicy) {
        return mergeFrom((com.google.cloud.compute.v1.ResourcePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ResourcePolicy other) {
      if (other == com.google.cloud.compute.v1.ResourcePolicy.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDiskConsistencyGroupPolicy()) {
        mergeDiskConsistencyGroupPolicy(other.getDiskConsistencyGroupPolicy());
      }
      if (other.hasGroupPlacementPolicy()) {
        mergeGroupPlacementPolicy(other.getGroupPlacementPolicy());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInstanceSchedulePolicy()) {
        mergeInstanceSchedulePolicy(other.getInstanceSchedulePolicy());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasResourceStatus()) {
        mergeResourceStatus(other.getResourceStatus());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasSnapshotSchedulePolicy()) {
        mergeSnapshotSchedulePolicy(other.getSnapshotSchedulePolicy());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26989658
            case 87452770:
              {
                input.readMessage(
                    getGroupPlacementPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 87452770
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 1111570338
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1450082194
            case 1745050362:
              {
                input.readMessage(
                    getSnapshotSchedulePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 1745050362
            case 1995434522:
              {
                input.readMessage(getResourceStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 1995434522
            case -1535950462:
              {
                input.readMessage(
                    getInstanceSchedulePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -1535950462
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -645248918
            case -505147174:
              {
                input.readMessage(
                    getDiskConsistencyGroupPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -505147174
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
        diskConsistencyGroupPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy,
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicyOrBuilder>
        diskConsistencyGroupPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     *
     * @return Whether the diskConsistencyGroupPolicy field is set.
     */
    public boolean hasDiskConsistencyGroupPolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     *
     * @return The diskConsistencyGroupPolicy.
     */
    public com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
        getDiskConsistencyGroupPolicy() {
      if (diskConsistencyGroupPolicyBuilder_ == null) {
        return diskConsistencyGroupPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
                .getDefaultInstance()
            : diskConsistencyGroupPolicy_;
      } else {
        return diskConsistencyGroupPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public Builder setDiskConsistencyGroupPolicy(
        com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy value) {
      if (diskConsistencyGroupPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskConsistencyGroupPolicy_ = value;
      } else {
        diskConsistencyGroupPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public Builder setDiskConsistencyGroupPolicy(
        com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.Builder
            builderForValue) {
      if (diskConsistencyGroupPolicyBuilder_ == null) {
        diskConsistencyGroupPolicy_ = builderForValue.build();
      } else {
        diskConsistencyGroupPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public Builder mergeDiskConsistencyGroupPolicy(
        com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy value) {
      if (diskConsistencyGroupPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && diskConsistencyGroupPolicy_ != null
            && diskConsistencyGroupPolicy_
                != com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
                    .getDefaultInstance()) {
          getDiskConsistencyGroupPolicyBuilder().mergeFrom(value);
        } else {
          diskConsistencyGroupPolicy_ = value;
        }
      } else {
        diskConsistencyGroupPolicyBuilder_.mergeFrom(value);
      }
      if (diskConsistencyGroupPolicy_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public Builder clearDiskConsistencyGroupPolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      diskConsistencyGroupPolicy_ = null;
      if (diskConsistencyGroupPolicyBuilder_ != null) {
        diskConsistencyGroupPolicyBuilder_.dispose();
        diskConsistencyGroupPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.Builder
        getDiskConsistencyGroupPolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDiskConsistencyGroupPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicyOrBuilder
        getDiskConsistencyGroupPolicyOrBuilder() {
      if (diskConsistencyGroupPolicyBuilder_ != null) {
        return diskConsistencyGroupPolicyBuilder_.getMessageOrBuilder();
      } else {
        return diskConsistencyGroupPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy
                .getDefaultInstance()
            : diskConsistencyGroupPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for disk consistency groups.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy disk_consistency_group_policy = 473727515;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy,
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicyOrBuilder>
        getDiskConsistencyGroupPolicyFieldBuilder() {
      if (diskConsistencyGroupPolicyBuilder_ == null) {
        diskConsistencyGroupPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy,
                com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicy.Builder,
                com.google.cloud.compute.v1.ResourcePolicyDiskConsistencyGroupPolicyOrBuilder>(
                getDiskConsistencyGroupPolicy(), getParentForChildren(), isClean());
        diskConsistencyGroupPolicy_ = null;
      }
      return diskConsistencyGroupPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy groupPlacementPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy,
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicyOrBuilder>
        groupPlacementPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     *
     * @return Whether the groupPlacementPolicy field is set.
     */
    public boolean hasGroupPlacementPolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     *
     * @return The groupPlacementPolicy.
     */
    public com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy
        getGroupPlacementPolicy() {
      if (groupPlacementPolicyBuilder_ == null) {
        return groupPlacementPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.getDefaultInstance()
            : groupPlacementPolicy_;
      } else {
        return groupPlacementPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public Builder setGroupPlacementPolicy(
        com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy value) {
      if (groupPlacementPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groupPlacementPolicy_ = value;
      } else {
        groupPlacementPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public Builder setGroupPlacementPolicy(
        com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.Builder builderForValue) {
      if (groupPlacementPolicyBuilder_ == null) {
        groupPlacementPolicy_ = builderForValue.build();
      } else {
        groupPlacementPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public Builder mergeGroupPlacementPolicy(
        com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy value) {
      if (groupPlacementPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && groupPlacementPolicy_ != null
            && groupPlacementPolicy_
                != com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy
                    .getDefaultInstance()) {
          getGroupPlacementPolicyBuilder().mergeFrom(value);
        } else {
          groupPlacementPolicy_ = value;
        }
      } else {
        groupPlacementPolicyBuilder_.mergeFrom(value);
      }
      if (groupPlacementPolicy_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public Builder clearGroupPlacementPolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      groupPlacementPolicy_ = null;
      if (groupPlacementPolicyBuilder_ != null) {
        groupPlacementPolicyBuilder_.dispose();
        groupPlacementPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.Builder
        getGroupPlacementPolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGroupPlacementPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicyOrBuilder
        getGroupPlacementPolicyOrBuilder() {
      if (groupPlacementPolicyBuilder_ != null) {
        return groupPlacementPolicyBuilder_.getMessageOrBuilder();
      } else {
        return groupPlacementPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.getDefaultInstance()
            : groupPlacementPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for instances for placement configuration.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy group_placement_policy = 10931596;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy,
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicyOrBuilder>
        getGroupPlacementPolicyFieldBuilder() {
      if (groupPlacementPolicyBuilder_ == null) {
        groupPlacementPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy,
                com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy.Builder,
                com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicyOrBuilder>(
                getGroupPlacementPolicy(), getParentForChildren(), isClean());
        groupPlacementPolicy_ = null;
      }
      return groupPlacementPolicyBuilder_;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
        instanceSchedulePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder>
        instanceSchedulePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     *
     * @return Whether the instanceSchedulePolicy field is set.
     */
    public boolean hasInstanceSchedulePolicy() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     *
     * @return The instanceSchedulePolicy.
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
        getInstanceSchedulePolicy() {
      if (instanceSchedulePolicyBuilder_ == null) {
        return instanceSchedulePolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance()
            : instanceSchedulePolicy_;
      } else {
        return instanceSchedulePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public Builder setInstanceSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy value) {
      if (instanceSchedulePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceSchedulePolicy_ = value;
      } else {
        instanceSchedulePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public Builder setInstanceSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder builderForValue) {
      if (instanceSchedulePolicyBuilder_ == null) {
        instanceSchedulePolicy_ = builderForValue.build();
      } else {
        instanceSchedulePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public Builder mergeInstanceSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy value) {
      if (instanceSchedulePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && instanceSchedulePolicy_ != null
            && instanceSchedulePolicy_
                != com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy
                    .getDefaultInstance()) {
          getInstanceSchedulePolicyBuilder().mergeFrom(value);
        } else {
          instanceSchedulePolicy_ = value;
        }
      } else {
        instanceSchedulePolicyBuilder_.mergeFrom(value);
      }
      if (instanceSchedulePolicy_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public Builder clearInstanceSchedulePolicy() {
      bitField0_ = (bitField0_ & ~0x00000020);
      instanceSchedulePolicy_ = null;
      if (instanceSchedulePolicyBuilder_ != null) {
        instanceSchedulePolicyBuilder_.dispose();
        instanceSchedulePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder
        getInstanceSchedulePolicyBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getInstanceSchedulePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder
        getInstanceSchedulePolicyOrBuilder() {
      if (instanceSchedulePolicyBuilder_ != null) {
        return instanceSchedulePolicyBuilder_.getMessageOrBuilder();
      } else {
        return instanceSchedulePolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.getDefaultInstance()
            : instanceSchedulePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for scheduling instance operations.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy instance_schedule_policy = 344877104;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder>
        getInstanceSchedulePolicyFieldBuilder() {
      if (instanceSchedulePolicyBuilder_ == null) {
        instanceSchedulePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicy.Builder,
                com.google.cloud.compute.v1.ResourcePolicyInstanceSchedulePolicyOrBuilder>(
                getInstanceSchedulePolicy(), getParentForChildren(), isClean());
        instanceSchedulePolicy_ = null;
      }
      return instanceSchedulePolicyBuilder_;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#resource_policies for resource policies.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourcePolicyResourceStatus resourceStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyResourceStatus,
            com.google.cloud.compute.v1.ResourcePolicyResourceStatus.Builder,
            com.google.cloud.compute.v1.ResourcePolicyResourceStatusOrBuilder>
        resourceStatusBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     *
     * @return Whether the resourceStatus field is set.
     */
    public boolean hasResourceStatus() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     *
     * @return The resourceStatus.
     */
    public com.google.cloud.compute.v1.ResourcePolicyResourceStatus getResourceStatus() {
      if (resourceStatusBuilder_ == null) {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyResourceStatus.getDefaultInstance()
            : resourceStatus_;
      } else {
        return resourceStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder setResourceStatus(
        com.google.cloud.compute.v1.ResourcePolicyResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceStatus_ = value;
      } else {
        resourceStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder setResourceStatus(
        com.google.cloud.compute.v1.ResourcePolicyResourceStatus.Builder builderForValue) {
      if (resourceStatusBuilder_ == null) {
        resourceStatus_ = builderForValue.build();
      } else {
        resourceStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder mergeResourceStatus(
        com.google.cloud.compute.v1.ResourcePolicyResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && resourceStatus_ != null
            && resourceStatus_
                != com.google.cloud.compute.v1.ResourcePolicyResourceStatus.getDefaultInstance()) {
          getResourceStatusBuilder().mergeFrom(value);
        } else {
          resourceStatus_ = value;
        }
      } else {
        resourceStatusBuilder_.mergeFrom(value);
      }
      if (resourceStatus_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public Builder clearResourceStatus() {
      bitField0_ = (bitField0_ & ~0x00000200);
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyResourceStatus.Builder
        getResourceStatusBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getResourceStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicyResourceStatusOrBuilder
        getResourceStatusOrBuilder() {
      if (resourceStatusBuilder_ != null) {
        return resourceStatusBuilder_.getMessageOrBuilder();
      } else {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.ResourcePolicyResourceStatus.getDefaultInstance()
            : resourceStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The system status of the resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicyResourceStatus resource_status = 249429315;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicyResourceStatus,
            com.google.cloud.compute.v1.ResourcePolicyResourceStatus.Builder,
            com.google.cloud.compute.v1.ResourcePolicyResourceStatusOrBuilder>
        getResourceStatusFieldBuilder() {
      if (resourceStatusBuilder_ == null) {
        resourceStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicyResourceStatus,
                com.google.cloud.compute.v1.ResourcePolicyResourceStatus.Builder,
                com.google.cloud.compute.v1.ResourcePolicyResourceStatusOrBuilder>(
                getResourceStatus(), getParentForChildren(), isClean());
        resourceStatus_ = null;
      }
      return resourceStatusBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
        snapshotSchedulePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder>
        snapshotSchedulePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     *
     * @return Whether the snapshotSchedulePolicy field is set.
     */
    public boolean hasSnapshotSchedulePolicy() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     *
     * @return The snapshotSchedulePolicy.
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
        getSnapshotSchedulePolicy() {
      if (snapshotSchedulePolicyBuilder_ == null) {
        return snapshotSchedulePolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance()
            : snapshotSchedulePolicy_;
      } else {
        return snapshotSchedulePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public Builder setSnapshotSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy value) {
      if (snapshotSchedulePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotSchedulePolicy_ = value;
      } else {
        snapshotSchedulePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public Builder setSnapshotSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder builderForValue) {
      if (snapshotSchedulePolicyBuilder_ == null) {
        snapshotSchedulePolicy_ = builderForValue.build();
      } else {
        snapshotSchedulePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public Builder mergeSnapshotSchedulePolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy value) {
      if (snapshotSchedulePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && snapshotSchedulePolicy_ != null
            && snapshotSchedulePolicy_
                != com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
                    .getDefaultInstance()) {
          getSnapshotSchedulePolicyBuilder().mergeFrom(value);
        } else {
          snapshotSchedulePolicy_ = value;
        }
      } else {
        snapshotSchedulePolicyBuilder_.mergeFrom(value);
      }
      if (snapshotSchedulePolicy_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public Builder clearSnapshotSchedulePolicy() {
      bitField0_ = (bitField0_ & ~0x00000800);
      snapshotSchedulePolicy_ = null;
      if (snapshotSchedulePolicyBuilder_ != null) {
        snapshotSchedulePolicyBuilder_.dispose();
        snapshotSchedulePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder
        getSnapshotSchedulePolicyBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSnapshotSchedulePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder
        getSnapshotSchedulePolicyOrBuilder() {
      if (snapshotSchedulePolicyBuilder_ != null) {
        return snapshotSchedulePolicyBuilder_.getMessageOrBuilder();
      } else {
        return snapshotSchedulePolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance()
            : snapshotSchedulePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policy for persistent disks for creating snapshots.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy snapshot_schedule_policy = 218131295;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder>
        getSnapshotSchedulePolicyFieldBuilder() {
      if (snapshotSchedulePolicyBuilder_ == null) {
        snapshotSchedulePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder>(
                getSnapshotSchedulePolicy(), getParentForChildren(), isClean());
        snapshotSchedulePolicy_ = null;
      }
      return snapshotSchedulePolicyBuilder_;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of resource policy creation.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourcePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourcePolicy)
  private static final com.google.cloud.compute.v1.ResourcePolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ResourcePolicy();
  }

  public static com.google.cloud.compute.v1.ResourcePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourcePolicy> PARSER =
      new com.google.protobuf.AbstractParser<ResourcePolicy>() {
        @java.lang.Override
        public ResourcePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourcePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
