/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy}
 */
public final class ResourcePolicySnapshotSchedulePolicy
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy)
    ResourcePolicySnapshotSchedulePolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourcePolicySnapshotSchedulePolicy.newBuilder() to construct.
  private ResourcePolicySnapshotSchedulePolicy(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourcePolicySnapshotSchedulePolicy() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourcePolicySnapshotSchedulePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.class,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder.class);
  }

  private int bitField0_;
  public static final int RETENTION_POLICY_FIELD_NUMBER = 68625779;
  private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
      retentionPolicy_;
  /**
   *
   *
   * <pre>
   * Retention policy applied to snapshots created by this resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
   * </code>
   *
   * @return Whether the retentionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetentionPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Retention policy applied to snapshots created by this resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
   * </code>
   *
   * @return The retentionPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
      getRetentionPolicy() {
    return retentionPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
            .getDefaultInstance()
        : retentionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Retention policy applied to snapshots created by this resource policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicyOrBuilder
      getRetentionPolicyOrBuilder() {
    return retentionPolicy_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
            .getDefaultInstance()
        : retentionPolicy_;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 375820951;
  private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule_;
  /**
   *
   *
   * <pre>
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
   * </code>
   *
   * @return Whether the schedule field is set.
   */
  @java.lang.Override
  public boolean hasSchedule() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
   * </code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule getSchedule() {
    return schedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule
            .getDefaultInstance()
        : schedule_;
  }
  /**
   *
   *
   * <pre>
   * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyScheduleOrBuilder
      getScheduleOrBuilder() {
    return schedule_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule
            .getDefaultInstance()
        : schedule_;
  }

  public static final int SNAPSHOT_PROPERTIES_FIELD_NUMBER = 185371278;
  private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      snapshotProperties_;
  /**
   *
   *
   * <pre>
   * Properties with which snapshots are created such as labels, encryption keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
   * </code>
   *
   * @return Whether the snapshotProperties field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotProperties() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Properties with which snapshots are created such as labels, encryption keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
   * </code>
   *
   * @return The snapshotProperties.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
      getSnapshotProperties() {
    return snapshotProperties_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
            .getDefaultInstance()
        : snapshotProperties_;
  }
  /**
   *
   *
   * <pre>
   * Properties with which snapshots are created such as labels, encryption keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder
      getSnapshotPropertiesOrBuilder() {
    return snapshotProperties_ == null
        ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
            .getDefaultInstance()
        : snapshotProperties_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(68625779, getRetentionPolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(185371278, getSnapshotProperties());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(375820951, getSchedule());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(68625779, getRetentionPolicy());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              185371278, getSnapshotProperties());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(375820951, getSchedule());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy other =
        (com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy) obj;

    if (hasRetentionPolicy() != other.hasRetentionPolicy()) return false;
    if (hasRetentionPolicy()) {
      if (!getRetentionPolicy().equals(other.getRetentionPolicy())) return false;
    }
    if (hasSchedule() != other.hasSchedule()) return false;
    if (hasSchedule()) {
      if (!getSchedule().equals(other.getSchedule())) return false;
    }
    if (hasSnapshotProperties() != other.hasSnapshotProperties()) return false;
    if (hasSnapshotProperties()) {
      if (!getSnapshotProperties().equals(other.getSnapshotProperties())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRetentionPolicy()) {
      hash = (37 * hash) + RETENTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionPolicy().hashCode();
    }
    if (hasSchedule()) {
      hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getSchedule().hashCode();
    }
    if (hasSnapshotProperties()) {
      hash = (37 * hash) + SNAPSHOT_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotProperties().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A snapshot schedule policy specifies when and how frequently snapshots are to be created for the target disk. Also specifies how many and how long these scheduled snapshots should be retained.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy)
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.class,
              com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRetentionPolicyFieldBuilder();
        getScheduleFieldBuilder();
        getSnapshotPropertiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      schedule_ = null;
      if (scheduleBuilder_ != null) {
        scheduleBuilder_.dispose();
        scheduleBuilder_ = null;
      }
      snapshotProperties_ = null;
      if (snapshotPropertiesBuilder_ != null) {
        snapshotPropertiesBuilder_.dispose();
        snapshotPropertiesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourcePolicySnapshotSchedulePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy build() {
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy buildPartial() {
      com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy result =
          new com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.retentionPolicy_ =
            retentionPolicyBuilder_ == null ? retentionPolicy_ : retentionPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.schedule_ = scheduleBuilder_ == null ? schedule_ : scheduleBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.snapshotProperties_ =
            snapshotPropertiesBuilder_ == null
                ? snapshotProperties_
                : snapshotPropertiesBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy) {
        return mergeFrom((com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy other) {
      if (other
          == com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy.getDefaultInstance())
        return this;
      if (other.hasRetentionPolicy()) {
        mergeRetentionPolicy(other.getRetentionPolicy());
      }
      if (other.hasSchedule()) {
        mergeSchedule(other.getSchedule());
      }
      if (other.hasSnapshotProperties()) {
        mergeSnapshotProperties(other.getSnapshotProperties());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 549006234:
              {
                input.readMessage(getRetentionPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 549006234
            case 1482970226:
              {
                input.readMessage(
                    getSnapshotPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1482970226
            case -1288399686:
              {
                input.readMessage(getScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1288399686
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
        retentionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.Builder,
            com.google.cloud.compute.v1
                .ResourcePolicySnapshotSchedulePolicyRetentionPolicyOrBuilder>
        retentionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     *
     * @return Whether the retentionPolicy field is set.
     */
    public boolean hasRetentionPolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     *
     * @return The retentionPolicy.
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
        getRetentionPolicy() {
      if (retentionPolicyBuilder_ == null) {
        return retentionPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
                .getDefaultInstance()
            : retentionPolicy_;
      } else {
        return retentionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public Builder setRetentionPolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionPolicy_ = value;
      } else {
        retentionPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public Builder setRetentionPolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.Builder
            builderForValue) {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = builderForValue.build();
      } else {
        retentionPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public Builder mergeRetentionPolicy(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && retentionPolicy_ != null
            && retentionPolicy_
                != com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
                    .getDefaultInstance()) {
          getRetentionPolicyBuilder().mergeFrom(value);
        } else {
          retentionPolicy_ = value;
        }
      } else {
        retentionPolicyBuilder_.mergeFrom(value);
      }
      if (retentionPolicy_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public Builder clearRetentionPolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      retentionPolicy_ = null;
      if (retentionPolicyBuilder_ != null) {
        retentionPolicyBuilder_.dispose();
        retentionPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.Builder
        getRetentionPolicyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getRetentionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicyOrBuilder
        getRetentionPolicyOrBuilder() {
      if (retentionPolicyBuilder_ != null) {
        return retentionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retentionPolicy_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
                .getDefaultInstance()
            : retentionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Retention policy applied to snapshots created by this resource policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy retention_policy = 68625779;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.Builder,
            com.google.cloud.compute.v1
                .ResourcePolicySnapshotSchedulePolicyRetentionPolicyOrBuilder>
        getRetentionPolicyFieldBuilder() {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
                    .Builder,
                com.google.cloud.compute.v1
                    .ResourcePolicySnapshotSchedulePolicyRetentionPolicyOrBuilder>(
                getRetentionPolicy(), getParentForChildren(), isClean());
        retentionPolicy_ = null;
      }
      return retentionPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyScheduleOrBuilder>
        scheduleBuilder_;
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     *
     * @return Whether the schedule field is set.
     */
    public boolean hasSchedule() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     *
     * @return The schedule.
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule getSchedule() {
      if (scheduleBuilder_ == null) {
        return schedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule
                .getDefaultInstance()
            : schedule_;
      } else {
        return scheduleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public Builder setSchedule(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule value) {
      if (scheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schedule_ = value;
      } else {
        scheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public Builder setSchedule(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule.Builder
            builderForValue) {
      if (scheduleBuilder_ == null) {
        schedule_ = builderForValue.build();
      } else {
        scheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public Builder mergeSchedule(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule value) {
      if (scheduleBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && schedule_ != null
            && schedule_
                != com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule
                    .getDefaultInstance()) {
          getScheduleBuilder().mergeFrom(value);
        } else {
          schedule_ = value;
        }
      } else {
        scheduleBuilder_.mergeFrom(value);
      }
      if (schedule_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public Builder clearSchedule() {
      bitField0_ = (bitField0_ & ~0x00000002);
      schedule_ = null;
      if (scheduleBuilder_ != null) {
        scheduleBuilder_.dispose();
        scheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule.Builder
        getScheduleBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyScheduleOrBuilder
        getScheduleOrBuilder() {
      if (scheduleBuilder_ != null) {
        return scheduleBuilder_.getMessageOrBuilder();
      } else {
        return schedule_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule
                .getDefaultInstance()
            : schedule_;
      }
    }
    /**
     *
     *
     * <pre>
     * A Vm Maintenance Policy specifies what kind of infrastructure maintenance we are allowed to perform on this VM and when. Schedule that is applied to disks covered by this policy.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule schedule = 375820951;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule.Builder,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyScheduleOrBuilder>
        getScheduleFieldBuilder() {
      if (scheduleBuilder_ == null) {
        scheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySchedule.Builder,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicyScheduleOrBuilder>(
                getSchedule(), getParentForChildren(), isClean());
        schedule_ = null;
      }
      return scheduleBuilder_;
    }

    private com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
        snapshotProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .Builder,
            com.google.cloud.compute.v1
                .ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder>
        snapshotPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     *
     * @return Whether the snapshotProperties field is set.
     */
    public boolean hasSnapshotProperties() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     *
     * @return The snapshotProperties.
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
        getSnapshotProperties() {
      if (snapshotPropertiesBuilder_ == null) {
        return snapshotProperties_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .getDefaultInstance()
            : snapshotProperties_;
      } else {
        return snapshotPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public Builder setSnapshotProperties(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties value) {
      if (snapshotPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotProperties_ = value;
      } else {
        snapshotPropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public Builder setSnapshotProperties(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties.Builder
            builderForValue) {
      if (snapshotPropertiesBuilder_ == null) {
        snapshotProperties_ = builderForValue.build();
      } else {
        snapshotPropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public Builder mergeSnapshotProperties(
        com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties value) {
      if (snapshotPropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && snapshotProperties_ != null
            && snapshotProperties_
                != com.google.cloud.compute.v1
                    .ResourcePolicySnapshotSchedulePolicySnapshotProperties.getDefaultInstance()) {
          getSnapshotPropertiesBuilder().mergeFrom(value);
        } else {
          snapshotProperties_ = value;
        }
      } else {
        snapshotPropertiesBuilder_.mergeFrom(value);
      }
      if (snapshotProperties_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public Builder clearSnapshotProperties() {
      bitField0_ = (bitField0_ & ~0x00000004);
      snapshotProperties_ = null;
      if (snapshotPropertiesBuilder_ != null) {
        snapshotPropertiesBuilder_.dispose();
        snapshotPropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
            .Builder
        getSnapshotPropertiesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSnapshotPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    public com.google.cloud.compute.v1
            .ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder
        getSnapshotPropertiesOrBuilder() {
      if (snapshotPropertiesBuilder_ != null) {
        return snapshotPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return snapshotProperties_ == null
            ? com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .getDefaultInstance()
            : snapshotProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Properties with which snapshots are created such as labels, encryption keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties snapshot_properties = 185371278;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties,
            com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                .Builder,
            com.google.cloud.compute.v1
                .ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder>
        getSnapshotPropertiesFieldBuilder() {
      if (snapshotPropertiesBuilder_ == null) {
        snapshotPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties,
                com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicySnapshotProperties
                    .Builder,
                com.google.cloud.compute.v1
                    .ResourcePolicySnapshotSchedulePolicySnapshotPropertiesOrBuilder>(
                getSnapshotProperties(), getParentForChildren(), isClean());
        snapshotProperties_ = null;
      }
      return snapshotPropertiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy)
  private static final com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy();
  }

  public static com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourcePolicySnapshotSchedulePolicy> PARSER =
      new com.google.protobuf.AbstractParser<ResourcePolicySnapshotSchedulePolicy>() {
        @java.lang.Override
        public ResourcePolicySnapshotSchedulePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourcePolicySnapshotSchedulePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourcePolicySnapshotSchedulePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
