/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Route resource. A route defines a path from VM instances in the VPC network to a specific destination. This destination can be inside or outside the VPC network. For more information, read the Routes overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Route}
 */
public final class Route extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Route)
    RouteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Route.newBuilder() to construct.
  private Route(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Route() {
    asPaths_ = java.util.Collections.emptyList();
    creationTimestamp_ = "";
    description_ = "";
    destRange_ = "";
    kind_ = "";
    name_ = "";
    network_ = "";
    nextHopGateway_ = "";
    nextHopHub_ = "";
    nextHopIlb_ = "";
    nextHopInstance_ = "";
    nextHopIp_ = "";
    nextHopNetwork_ = "";
    nextHopPeering_ = "";
    nextHopVpnTunnel_ = "";
    routeStatus_ = "";
    routeType_ = "";
    selfLink_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    warnings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Route();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Route_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Route_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Route.class,
            com.google.cloud.compute.v1.Route.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output only] The status of the route.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Route.RouteStatus}
   */
  public enum RouteStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTE_STATUS = 0;</code>
     */
    UNDEFINED_ROUTE_STATUS(0),
    /**
     *
     *
     * <pre>
     * This route is processed and active.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * The route is dropped due to the VPC exceeding the dynamic route limit. For dynamic route limit, please refer to the Learned route example
     * </pre>
     *
     * <code>DROPPED = 496235424;</code>
     */
    DROPPED(496235424),
    /**
     *
     *
     * <pre>
     * This route is processed but inactive due to failure from the backend. The backend may have rejected the route
     * </pre>
     *
     * <code>INACTIVE = 270421099;</code>
     */
    INACTIVE(270421099),
    /**
     *
     *
     * <pre>
     * This route is being processed internally. The status will change once processed.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    PENDING(35394935),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTE_STATUS = 0;</code>
     */
    public static final int UNDEFINED_ROUTE_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This route is processed and active.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * The route is dropped due to the VPC exceeding the dynamic route limit. For dynamic route limit, please refer to the Learned route example
     * </pre>
     *
     * <code>DROPPED = 496235424;</code>
     */
    public static final int DROPPED_VALUE = 496235424;
    /**
     *
     *
     * <pre>
     * This route is processed but inactive due to failure from the backend. The backend may have rejected the route
     * </pre>
     *
     * <code>INACTIVE = 270421099;</code>
     */
    public static final int INACTIVE_VALUE = 270421099;
    /**
     *
     *
     * <pre>
     * This route is being processed internally. The status will change once processed.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    public static final int PENDING_VALUE = 35394935;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RouteStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RouteStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ROUTE_STATUS;
        case 314733318:
          return ACTIVE;
        case 496235424:
          return DROPPED;
        case 270421099:
          return INACTIVE;
        case 35394935:
          return PENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RouteStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RouteStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RouteStatus>() {
          public RouteStatus findValueByNumber(int number) {
            return RouteStatus.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Route.getDescriptor().getEnumTypes().get(0);
    }

    private static final RouteStatus[] VALUES = values();

    public static RouteStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RouteStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Route.RouteStatus)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Route.RouteType}
   */
  public enum RouteType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTE_TYPE = 0;</code>
     */
    UNDEFINED_ROUTE_TYPE(0),
    /** <code>BGP = 65707;</code> */
    BGP(65707),
    /** <code>STATIC = 308331118;</code> */
    STATIC(308331118),
    /** <code>SUBNET = 309278557;</code> */
    SUBNET(309278557),
    /** <code>TRANSIT = 187793843;</code> */
    TRANSIT(187793843),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ROUTE_TYPE = 0;</code>
     */
    public static final int UNDEFINED_ROUTE_TYPE_VALUE = 0;
    /** <code>BGP = 65707;</code> */
    public static final int BGP_VALUE = 65707;
    /** <code>STATIC = 308331118;</code> */
    public static final int STATIC_VALUE = 308331118;
    /** <code>SUBNET = 309278557;</code> */
    public static final int SUBNET_VALUE = 309278557;
    /** <code>TRANSIT = 187793843;</code> */
    public static final int TRANSIT_VALUE = 187793843;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RouteType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RouteType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ROUTE_TYPE;
        case 65707:
          return BGP;
        case 308331118:
          return STATIC;
        case 309278557:
          return SUBNET;
        case 187793843:
          return TRANSIT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RouteType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RouteType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RouteType>() {
          public RouteType findValueByNumber(int number) {
            return RouteType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Route.getDescriptor().getEnumTypes().get(1);
    }

    private static final RouteType[] VALUES = values();

    public static RouteType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RouteType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Route.RouteType)
  }

  private int bitField0_;
  public static final int AS_PATHS_FIELD_NUMBER = 137568929;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouteAsPath> asPaths_;
  /**
   *
   *
   * <pre>
   * [Output Only] AS path.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouteAsPath> getAsPathsList() {
    return asPaths_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] AS path.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouteAsPathOrBuilder>
      getAsPathsOrBuilderList() {
    return asPaths_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] AS path.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public int getAsPathsCount() {
    return asPaths_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] AS path.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouteAsPath getAsPaths(int index) {
    return asPaths_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] AS path.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouteAsPathOrBuilder getAsPathsOrBuilder(int index) {
    return asPaths_.get(index);
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this field when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEST_RANGE_FIELD_NUMBER = 381327712;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destRange_ = "";
  /**
   *
   *
   * <pre>
   * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
   * </pre>
   *
   * <code>optional string dest_range = 381327712;</code>
   *
   * @return Whether the destRange field is set.
   */
  @java.lang.Override
  public boolean hasDestRange() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
   * </pre>
   *
   * <code>optional string dest_range = 381327712;</code>
   *
   * @return The destRange.
   */
  @java.lang.Override
  public java.lang.String getDestRange() {
    java.lang.Object ref = destRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
   * </pre>
   *
   * <code>optional string dest_range = 381327712;</code>
   *
   * @return The bytes for destRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestRangeBytes() {
    java.lang.Object ref = destRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of this resource. Always compute#routes for Route resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of this resource. Always compute#routes for Route resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of this resource. Always compute#routes for Route resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Fully-qualified URL of the network that this route applies to.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fully-qualified URL of the network that this route applies to.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fully-qualified URL of the network that this route applies to.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_GATEWAY_FIELD_NUMBER = 377175298;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopGateway_ = "";
  /**
   *
   *
   * <pre>
   * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
   * </pre>
   *
   * <code>optional string next_hop_gateway = 377175298;</code>
   *
   * @return Whether the nextHopGateway field is set.
   */
  @java.lang.Override
  public boolean hasNextHopGateway() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
   * </pre>
   *
   * <code>optional string next_hop_gateway = 377175298;</code>
   *
   * @return The nextHopGateway.
   */
  @java.lang.Override
  public java.lang.String getNextHopGateway() {
    java.lang.Object ref = nextHopGateway_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopGateway_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
   * </pre>
   *
   * <code>optional string next_hop_gateway = 377175298;</code>
   *
   * @return The bytes for nextHopGateway.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopGatewayBytes() {
    java.lang.Object ref = nextHopGateway_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopGateway_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_HUB_FIELD_NUMBER = 198679219;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopHub_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_hub = 198679219;</code>
   *
   * @return Whether the nextHopHub field is set.
   */
  @java.lang.Override
  public boolean hasNextHopHub() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_hub = 198679219;</code>
   *
   * @return The nextHopHub.
   */
  @java.lang.Override
  public java.lang.String getNextHopHub() {
    java.lang.Object ref = nextHopHub_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopHub_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_hub = 198679219;</code>
   *
   * @return The bytes for nextHopHub.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopHubBytes() {
    java.lang.Object ref = nextHopHub_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopHub_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_ILB_FIELD_NUMBER = 198679901;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopIlb_ = "";
  /**
   *
   *
   * <pre>
   * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
   * </pre>
   *
   * <code>optional string next_hop_ilb = 198679901;</code>
   *
   * @return Whether the nextHopIlb field is set.
   */
  @java.lang.Override
  public boolean hasNextHopIlb() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
   * </pre>
   *
   * <code>optional string next_hop_ilb = 198679901;</code>
   *
   * @return The nextHopIlb.
   */
  @java.lang.Override
  public java.lang.String getNextHopIlb() {
    java.lang.Object ref = nextHopIlb_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopIlb_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
   * </pre>
   *
   * <code>optional string next_hop_ilb = 198679901;</code>
   *
   * @return The bytes for nextHopIlb.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopIlbBytes() {
    java.lang.Object ref = nextHopIlb_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopIlb_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_INSTANCE_FIELD_NUMBER = 393508247;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopInstance_ = "";
  /**
   *
   *
   * <pre>
   * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
   * </pre>
   *
   * <code>optional string next_hop_instance = 393508247;</code>
   *
   * @return Whether the nextHopInstance field is set.
   */
  @java.lang.Override
  public boolean hasNextHopInstance() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
   * </pre>
   *
   * <code>optional string next_hop_instance = 393508247;</code>
   *
   * @return The nextHopInstance.
   */
  @java.lang.Override
  public java.lang.String getNextHopInstance() {
    java.lang.Object ref = nextHopInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopInstance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
   * </pre>
   *
   * <code>optional string next_hop_instance = 393508247;</code>
   *
   * @return The bytes for nextHopInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopInstanceBytes() {
    java.lang.Object ref = nextHopInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_IP_FIELD_NUMBER = 110319529;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopIp_ = "";
  /**
   *
   *
   * <pre>
   * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
   * </pre>
   *
   * <code>optional string next_hop_ip = 110319529;</code>
   *
   * @return Whether the nextHopIp field is set.
   */
  @java.lang.Override
  public boolean hasNextHopIp() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
   * </pre>
   *
   * <code>optional string next_hop_ip = 110319529;</code>
   *
   * @return The nextHopIp.
   */
  @java.lang.Override
  public java.lang.String getNextHopIp() {
    java.lang.Object ref = nextHopIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopIp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
   * </pre>
   *
   * <code>optional string next_hop_ip = 110319529;</code>
   *
   * @return The bytes for nextHopIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopIpBytes() {
    java.lang.Object ref = nextHopIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_NETWORK_FIELD_NUMBER = 262295788;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopNetwork_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the local network if it should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_network = 262295788;</code>
   *
   * @return Whether the nextHopNetwork field is set.
   */
  @java.lang.Override
  public boolean hasNextHopNetwork() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the local network if it should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_network = 262295788;</code>
   *
   * @return The nextHopNetwork.
   */
  @java.lang.Override
  public java.lang.String getNextHopNetwork() {
    java.lang.Object ref = nextHopNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the local network if it should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_network = 262295788;</code>
   *
   * @return The bytes for nextHopNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopNetworkBytes() {
    java.lang.Object ref = nextHopNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_PEERING_FIELD_NUMBER = 412682750;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopPeering_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
   * </pre>
   *
   * <code>optional string next_hop_peering = 412682750;</code>
   *
   * @return Whether the nextHopPeering field is set.
   */
  @java.lang.Override
  public boolean hasNextHopPeering() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
   * </pre>
   *
   * <code>optional string next_hop_peering = 412682750;</code>
   *
   * @return The nextHopPeering.
   */
  @java.lang.Override
  public java.lang.String getNextHopPeering() {
    java.lang.Object ref = nextHopPeering_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopPeering_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
   * </pre>
   *
   * <code>optional string next_hop_peering = 412682750;</code>
   *
   * @return The bytes for nextHopPeering.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopPeeringBytes() {
    java.lang.Object ref = nextHopPeering_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopPeering_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_VPN_TUNNEL_FIELD_NUMBER = 519844501;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextHopVpnTunnel_ = "";
  /**
   *
   *
   * <pre>
   * The URL to a VpnTunnel that should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
   *
   * @return Whether the nextHopVpnTunnel field is set.
   */
  @java.lang.Override
  public boolean hasNextHopVpnTunnel() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL to a VpnTunnel that should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
   *
   * @return The nextHopVpnTunnel.
   */
  @java.lang.Override
  public java.lang.String getNextHopVpnTunnel() {
    java.lang.Object ref = nextHopVpnTunnel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHopVpnTunnel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL to a VpnTunnel that should handle matching packets.
   * </pre>
   *
   * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
   *
   * @return The bytes for nextHopVpnTunnel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopVpnTunnelBytes() {
    java.lang.Object ref = nextHopVpnTunnel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHopVpnTunnel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORITY_FIELD_NUMBER = 445151652;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
   * </pre>
   *
   * <code>optional uint32 priority = 445151652;</code>
   *
   * @return Whether the priority field is set.
   */
  @java.lang.Override
  public boolean hasPriority() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
   * </pre>
   *
   * <code>optional uint32 priority = 445151652;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int ROUTE_STATUS_FIELD_NUMBER = 418162344;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routeStatus_ = "";
  /**
   *
   *
   * <pre>
   * [Output only] The status of the route.
   * Check the RouteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_status = 418162344;</code>
   *
   * @return Whether the routeStatus field is set.
   */
  @java.lang.Override
  public boolean hasRouteStatus() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output only] The status of the route.
   * Check the RouteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_status = 418162344;</code>
   *
   * @return The routeStatus.
   */
  @java.lang.Override
  public java.lang.String getRouteStatus() {
    java.lang.Object ref = routeStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routeStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output only] The status of the route.
   * Check the RouteStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_status = 418162344;</code>
   *
   * @return The bytes for routeStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouteStatusBytes() {
    java.lang.Object ref = routeStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routeStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTE_TYPE_FIELD_NUMBER = 375888752;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routeType_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
   * Check the RouteType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_type = 375888752;</code>
   *
   * @return Whether the routeType field is set.
   */
  @java.lang.Override
  public boolean hasRouteType() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
   * Check the RouteType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_type = 375888752;</code>
   *
   * @return The routeType.
   */
  @java.lang.Override
  public java.lang.String getRouteType() {
    java.lang.Object ref = routeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routeType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
   * Check the RouteType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string route_type = 375888752;</code>
   *
   * @return The bytes for routeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouteTypeBytes() {
    java.lang.Object ref = routeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 3552281;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of instance tags to which this route applies.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * A list of instance tags to which this route applies.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of instance tags to which this route applies.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of instance tags to which this route applies.
   * </pre>
   *
   * <code>repeated string tags = 3552281;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int WARNINGS_FIELD_NUMBER = 498091095;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Warnings> warnings_;
  /**
   *
   *
   * <pre>
   * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Warnings> getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.WarningsOrBuilder>
      getWarningsOrBuilderList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Warnings getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WarningsOrBuilder getWarningsOrBuilder(int index) {
    return warnings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3552281, tags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 110319529, nextHopIp_);
    }
    for (int i = 0; i < asPaths_.size(); i++) {
      output.writeMessage(137568929, asPaths_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 198679219, nextHopHub_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 198679901, nextHopIlb_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 262295788, nextHopNetwork_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 375888752, routeType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 377175298, nextHopGateway_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 381327712, destRange_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 393508247, nextHopInstance_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 412682750, nextHopPeering_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 418162344, routeStatus_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeUInt32(445151652, priority_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      output.writeMessage(498091095, warnings_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 519844501, nextHopVpnTunnel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getTagsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(110319529, nextHopIp_);
    }
    for (int i = 0; i < asPaths_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(137568929, asPaths_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(198679219, nextHopHub_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(198679901, nextHopIlb_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(262295788, nextHopNetwork_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(375888752, routeType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(377175298, nextHopGateway_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(381327712, destRange_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(393508247, nextHopInstance_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(412682750, nextHopPeering_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(418162344, routeStatus_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(445151652, priority_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(498091095, warnings_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(519844501, nextHopVpnTunnel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Route)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Route other = (com.google.cloud.compute.v1.Route) obj;

    if (!getAsPathsList().equals(other.getAsPathsList())) return false;
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDestRange() != other.hasDestRange()) return false;
    if (hasDestRange()) {
      if (!getDestRange().equals(other.getDestRange())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasNextHopGateway() != other.hasNextHopGateway()) return false;
    if (hasNextHopGateway()) {
      if (!getNextHopGateway().equals(other.getNextHopGateway())) return false;
    }
    if (hasNextHopHub() != other.hasNextHopHub()) return false;
    if (hasNextHopHub()) {
      if (!getNextHopHub().equals(other.getNextHopHub())) return false;
    }
    if (hasNextHopIlb() != other.hasNextHopIlb()) return false;
    if (hasNextHopIlb()) {
      if (!getNextHopIlb().equals(other.getNextHopIlb())) return false;
    }
    if (hasNextHopInstance() != other.hasNextHopInstance()) return false;
    if (hasNextHopInstance()) {
      if (!getNextHopInstance().equals(other.getNextHopInstance())) return false;
    }
    if (hasNextHopIp() != other.hasNextHopIp()) return false;
    if (hasNextHopIp()) {
      if (!getNextHopIp().equals(other.getNextHopIp())) return false;
    }
    if (hasNextHopNetwork() != other.hasNextHopNetwork()) return false;
    if (hasNextHopNetwork()) {
      if (!getNextHopNetwork().equals(other.getNextHopNetwork())) return false;
    }
    if (hasNextHopPeering() != other.hasNextHopPeering()) return false;
    if (hasNextHopPeering()) {
      if (!getNextHopPeering().equals(other.getNextHopPeering())) return false;
    }
    if (hasNextHopVpnTunnel() != other.hasNextHopVpnTunnel()) return false;
    if (hasNextHopVpnTunnel()) {
      if (!getNextHopVpnTunnel().equals(other.getNextHopVpnTunnel())) return false;
    }
    if (hasPriority() != other.hasPriority()) return false;
    if (hasPriority()) {
      if (getPriority() != other.getPriority()) return false;
    }
    if (hasRouteStatus() != other.hasRouteStatus()) return false;
    if (hasRouteStatus()) {
      if (!getRouteStatus().equals(other.getRouteStatus())) return false;
    }
    if (hasRouteType() != other.hasRouteType()) return false;
    if (hasRouteType()) {
      if (!getRouteType().equals(other.getRouteType())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAsPathsCount() > 0) {
      hash = (37 * hash) + AS_PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getAsPathsList().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDestRange()) {
      hash = (37 * hash) + DEST_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getDestRange().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasNextHopGateway()) {
      hash = (37 * hash) + NEXT_HOP_GATEWAY_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopGateway().hashCode();
    }
    if (hasNextHopHub()) {
      hash = (37 * hash) + NEXT_HOP_HUB_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopHub().hashCode();
    }
    if (hasNextHopIlb()) {
      hash = (37 * hash) + NEXT_HOP_ILB_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopIlb().hashCode();
    }
    if (hasNextHopInstance()) {
      hash = (37 * hash) + NEXT_HOP_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopInstance().hashCode();
    }
    if (hasNextHopIp()) {
      hash = (37 * hash) + NEXT_HOP_IP_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopIp().hashCode();
    }
    if (hasNextHopNetwork()) {
      hash = (37 * hash) + NEXT_HOP_NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopNetwork().hashCode();
    }
    if (hasNextHopPeering()) {
      hash = (37 * hash) + NEXT_HOP_PEERING_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopPeering().hashCode();
    }
    if (hasNextHopVpnTunnel()) {
      hash = (37 * hash) + NEXT_HOP_VPN_TUNNEL_FIELD_NUMBER;
      hash = (53 * hash) + getNextHopVpnTunnel().hashCode();
    }
    if (hasPriority()) {
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
    }
    if (hasRouteStatus()) {
      hash = (37 * hash) + ROUTE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getRouteStatus().hashCode();
    }
    if (hasRouteType()) {
      hash = (37 * hash) + ROUTE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getRouteType().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Route parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Route parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Route parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Route parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Route prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Route resource. A route defines a path from VM instances in the VPC network to a specific destination. This destination can be inside or outside the VPC network. For more information, read the Routes overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Route}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Route)
      com.google.cloud.compute.v1.RouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Route_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Route_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Route.class,
              com.google.cloud.compute.v1.Route.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Route.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (asPathsBuilder_ == null) {
        asPaths_ = java.util.Collections.emptyList();
      } else {
        asPaths_ = null;
        asPathsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      creationTimestamp_ = "";
      description_ = "";
      destRange_ = "";
      id_ = 0L;
      kind_ = "";
      name_ = "";
      network_ = "";
      nextHopGateway_ = "";
      nextHopHub_ = "";
      nextHopIlb_ = "";
      nextHopInstance_ = "";
      nextHopIp_ = "";
      nextHopNetwork_ = "";
      nextHopPeering_ = "";
      nextHopVpnTunnel_ = "";
      priority_ = 0;
      routeStatus_ = "";
      routeType_ = "";
      selfLink_ = "";
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
      } else {
        warnings_ = null;
        warningsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Route_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Route getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Route.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Route build() {
      com.google.cloud.compute.v1.Route result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Route buildPartial() {
      com.google.cloud.compute.v1.Route result = new com.google.cloud.compute.v1.Route(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Route result) {
      if (asPathsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          asPaths_ = java.util.Collections.unmodifiableList(asPaths_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.asPaths_ = asPaths_;
      } else {
        result.asPaths_ = asPathsBuilder_.build();
      }
      if (warningsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          warnings_ = java.util.Collections.unmodifiableList(warnings_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.warnings_ = warnings_;
      } else {
        result.warnings_ = warningsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Route result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.destRange_ = destRange_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.nextHopGateway_ = nextHopGateway_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.nextHopHub_ = nextHopHub_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.nextHopIlb_ = nextHopIlb_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.nextHopInstance_ = nextHopInstance_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.nextHopIp_ = nextHopIp_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.nextHopNetwork_ = nextHopNetwork_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.nextHopPeering_ = nextHopPeering_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.nextHopVpnTunnel_ = nextHopVpnTunnel_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.priority_ = priority_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.routeStatus_ = routeStatus_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.routeType_ = routeType_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Route) {
        return mergeFrom((com.google.cloud.compute.v1.Route) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Route other) {
      if (other == com.google.cloud.compute.v1.Route.getDefaultInstance()) return this;
      if (asPathsBuilder_ == null) {
        if (!other.asPaths_.isEmpty()) {
          if (asPaths_.isEmpty()) {
            asPaths_ = other.asPaths_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAsPathsIsMutable();
            asPaths_.addAll(other.asPaths_);
          }
          onChanged();
        }
      } else {
        if (!other.asPaths_.isEmpty()) {
          if (asPathsBuilder_.isEmpty()) {
            asPathsBuilder_.dispose();
            asPathsBuilder_ = null;
            asPaths_ = other.asPaths_;
            bitField0_ = (bitField0_ & ~0x00000001);
            asPathsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAsPathsFieldBuilder()
                    : null;
          } else {
            asPathsBuilder_.addAllMessages(other.asPaths_);
          }
        }
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDestRange()) {
        destRange_ = other.destRange_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasNextHopGateway()) {
        nextHopGateway_ = other.nextHopGateway_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasNextHopHub()) {
        nextHopHub_ = other.nextHopHub_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasNextHopIlb()) {
        nextHopIlb_ = other.nextHopIlb_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasNextHopInstance()) {
        nextHopInstance_ = other.nextHopInstance_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasNextHopIp()) {
        nextHopIp_ = other.nextHopIp_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasNextHopNetwork()) {
        nextHopNetwork_ = other.nextHopNetwork_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasNextHopPeering()) {
        nextHopPeering_ = other.nextHopPeering_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasNextHopVpnTunnel()) {
        nextHopVpnTunnel_ = other.nextHopVpnTunnel_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasPriority()) {
        setPriority(other.getPriority());
      }
      if (other.hasRouteStatus()) {
        routeStatus_ = other.routeStatus_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasRouteType()) {
        routeType_ = other.routeType_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00100000;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (warningsBuilder_ == null) {
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
      } else {
        if (!other.warnings_.isEmpty()) {
          if (warningsBuilder_.isEmpty()) {
            warningsBuilder_.dispose();
            warningsBuilder_ = null;
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00200000);
            warningsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningsFieldBuilder()
                    : null;
          } else {
            warningsBuilder_.addAllMessages(other.warnings_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26989658
            case 28418250:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 28418250
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 882556234:
              {
                nextHopIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 882556234
            case 1100551434:
              {
                com.google.cloud.compute.v1.RouteAsPath m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouteAsPath.parser(), extensionRegistry);
                if (asPathsBuilder_ == null) {
                  ensureAsPathsIsMutable();
                  asPaths_.add(m);
                } else {
                  asPathsBuilder_.addMessage(m);
                }
                break;
              } // case 1100551434
            case 1589433754:
              {
                nextHopHub_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 1589433754
            case 1589439210:
              {
                nextHopIlb_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 1589439210
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1862979954
            case 2098366306:
              {
                nextHopNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 2098366306
            case -1287857278:
              {
                routeType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -1287857278
            case -1277564910:
              {
                nextHopGateway_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -1277564910
            case -1244345598:
              {
                destRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1244345598
            case -1146901318:
              {
                nextHopInstance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -1146901318
            case -993505294:
              {
                nextHopPeering_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -993505294
            case -949668542:
              {
                routeStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -949668542
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -733754080:
              {
                priority_ = input.readUInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case -733754080
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case -645248918
            case -310238534:
              {
                com.google.cloud.compute.v1.Warnings m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Warnings.parser(), extensionRegistry);
                if (warningsBuilder_ == null) {
                  ensureWarningsIsMutable();
                  warnings_.add(m);
                } else {
                  warningsBuilder_.addMessage(m);
                }
                break;
              } // case -310238534
            case -136211286:
              {
                nextHopVpnTunnel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -136211286
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.RouteAsPath> asPaths_ =
        java.util.Collections.emptyList();

    private void ensureAsPathsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        asPaths_ = new java.util.ArrayList<com.google.cloud.compute.v1.RouteAsPath>(asPaths_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouteAsPath,
            com.google.cloud.compute.v1.RouteAsPath.Builder,
            com.google.cloud.compute.v1.RouteAsPathOrBuilder>
        asPathsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouteAsPath> getAsPathsList() {
      if (asPathsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(asPaths_);
      } else {
        return asPathsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public int getAsPathsCount() {
      if (asPathsBuilder_ == null) {
        return asPaths_.size();
      } else {
        return asPathsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.RouteAsPath getAsPaths(int index) {
      if (asPathsBuilder_ == null) {
        return asPaths_.get(index);
      } else {
        return asPathsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder setAsPaths(int index, com.google.cloud.compute.v1.RouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.set(index, value);
        onChanged();
      } else {
        asPathsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder setAsPaths(
        int index, com.google.cloud.compute.v1.RouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.set(index, builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(com.google.cloud.compute.v1.RouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.add(value);
        onChanged();
      } else {
        asPathsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(int index, com.google.cloud.compute.v1.RouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.add(index, value);
        onChanged();
      } else {
        asPathsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(com.google.cloud.compute.v1.RouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.add(builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(
        int index, com.google.cloud.compute.v1.RouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.add(index, builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAllAsPaths(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouteAsPath> values) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, asPaths_);
        onChanged();
      } else {
        asPathsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder clearAsPaths() {
      if (asPathsBuilder_ == null) {
        asPaths_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        asPathsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public Builder removeAsPaths(int index) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.remove(index);
        onChanged();
      } else {
        asPathsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.RouteAsPath.Builder getAsPathsBuilder(int index) {
      return getAsPathsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.RouteAsPathOrBuilder getAsPathsOrBuilder(int index) {
      if (asPathsBuilder_ == null) {
        return asPaths_.get(index);
      } else {
        return asPathsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouteAsPathOrBuilder>
        getAsPathsOrBuilderList() {
      if (asPathsBuilder_ != null) {
        return asPathsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(asPaths_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.RouteAsPath.Builder addAsPathsBuilder() {
      return getAsPathsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouteAsPath.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.RouteAsPath.Builder addAsPathsBuilder(int index) {
      return getAsPathsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.RouteAsPath.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] AS path.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouteAsPath.Builder> getAsPathsBuilderList() {
      return getAsPathsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouteAsPath,
            com.google.cloud.compute.v1.RouteAsPath.Builder,
            com.google.cloud.compute.v1.RouteAsPathOrBuilder>
        getAsPathsFieldBuilder() {
      if (asPathsBuilder_ == null) {
        asPathsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouteAsPath,
                com.google.cloud.compute.v1.RouteAsPath.Builder,
                com.google.cloud.compute.v1.RouteAsPathOrBuilder>(
                asPaths_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        asPaths_ = null;
      }
      return asPathsBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this field when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object destRange_ = "";
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @return Whether the destRange field is set.
     */
    public boolean hasDestRange() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @return The destRange.
     */
    public java.lang.String getDestRange() {
      java.lang.Object ref = destRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @return The bytes for destRange.
     */
    public com.google.protobuf.ByteString getDestRangeBytes() {
      java.lang.Object ref = destRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @param value The destRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destRange_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestRange() {
      destRange_ = getDefaultInstance().getDestRange();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The destination range of outgoing packets that this route applies to. Both IPv4 and IPv6 are supported. Must specify an IPv4 range (e.g. 192.0.2.0/24) or an IPv6 range in RFC 4291 format (e.g. 2001:db8::/32). IPv6 range will be displayed using RFC 5952 compressed format.
     * </pre>
     *
     * <code>optional string dest_range = 381327712;</code>
     *
     * @param value The bytes for destRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destRange_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of this resource. Always compute#routes for Route resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully-qualified URL of the network that this route applies to.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopGateway_ = "";
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @return Whether the nextHopGateway field is set.
     */
    public boolean hasNextHopGateway() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @return The nextHopGateway.
     */
    public java.lang.String getNextHopGateway() {
      java.lang.Object ref = nextHopGateway_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopGateway_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @return The bytes for nextHopGateway.
     */
    public com.google.protobuf.ByteString getNextHopGatewayBytes() {
      java.lang.Object ref = nextHopGateway_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopGateway_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @param value The nextHopGateway to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopGateway(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopGateway_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopGateway() {
      nextHopGateway_ = getDefaultInstance().getNextHopGateway();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a gateway that should handle matching packets. You can only specify the internet gateway using a full or partial valid URL: projects/ project/global/gateways/default-internet-gateway
     * </pre>
     *
     * <code>optional string next_hop_gateway = 377175298;</code>
     *
     * @param value The bytes for nextHopGateway to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopGatewayBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopGateway_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopHub_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @return Whether the nextHopHub field is set.
     */
    public boolean hasNextHopHub() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @return The nextHopHub.
     */
    public java.lang.String getNextHopHub() {
      java.lang.Object ref = nextHopHub_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopHub_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @return The bytes for nextHopHub.
     */
    public com.google.protobuf.ByteString getNextHopHubBytes() {
      java.lang.Object ref = nextHopHub_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopHub_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @param value The nextHopHub to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopHub(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopHub_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopHub() {
      nextHopHub_ = getDefaultInstance().getNextHopHub();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The full resource name of the Network Connectivity Center hub that will handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_hub = 198679219;</code>
     *
     * @param value The bytes for nextHopHub to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopHubBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopHub_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopIlb_ = "";
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @return Whether the nextHopIlb field is set.
     */
    public boolean hasNextHopIlb() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @return The nextHopIlb.
     */
    public java.lang.String getNextHopIlb() {
      java.lang.Object ref = nextHopIlb_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopIlb_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @return The bytes for nextHopIlb.
     */
    public com.google.protobuf.ByteString getNextHopIlbBytes() {
      java.lang.Object ref = nextHopIlb_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopIlb_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @param value The nextHopIlb to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIlb(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopIlb_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopIlb() {
      nextHopIlb_ = getDefaultInstance().getNextHopIlb();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets or the IP address of the forwarding Rule. For example, the following are all valid URLs: - 10.128.0.56 - https://www.googleapis.com/compute/v1/projects/project/regions/region /forwardingRules/forwardingRule - regions/region/forwardingRules/forwardingRule
     * </pre>
     *
     * <code>optional string next_hop_ilb = 198679901;</code>
     *
     * @param value The bytes for nextHopIlb to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIlbBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopIlb_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopInstance_ = "";
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @return Whether the nextHopInstance field is set.
     */
    public boolean hasNextHopInstance() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @return The nextHopInstance.
     */
    public java.lang.String getNextHopInstance() {
      java.lang.Object ref = nextHopInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @return The bytes for nextHopInstance.
     */
    public com.google.protobuf.ByteString getNextHopInstanceBytes() {
      java.lang.Object ref = nextHopInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @param value The nextHopInstance to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopInstance_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopInstance() {
      nextHopInstance_ = getDefaultInstance().getNextHopInstance();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to an instance that should handle matching packets. You can specify this as a full or partial URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
     * </pre>
     *
     * <code>optional string next_hop_instance = 393508247;</code>
     *
     * @param value The bytes for nextHopInstance to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopInstance_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopIp_ = "";
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @return Whether the nextHopIp field is set.
     */
    public boolean hasNextHopIp() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @return The nextHopIp.
     */
    public java.lang.String getNextHopIp() {
      java.lang.Object ref = nextHopIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @return The bytes for nextHopIp.
     */
    public com.google.protobuf.ByteString getNextHopIpBytes() {
      java.lang.Object ref = nextHopIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @param value The nextHopIp to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopIp_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopIp() {
      nextHopIp_ = getDefaultInstance().getNextHopIp();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network IP address of an instance that should handle matching packets. Both IPv6 address and IPv4 addresses are supported. Must specify an IPv4 address in dot-decimal notation (e.g. 192.0.2.99) or an IPv6 address in RFC 4291 format (e.g. 2001:db8::2d9:51:0:0 or 2001:db8:0:0:2d9:51:0:0). IPv6 addresses will be displayed using RFC 5952 compressed format (e.g. 2001:db8::2d9:51:0:0). Should never be an IPv4-mapped IPv6 address.
     * </pre>
     *
     * <code>optional string next_hop_ip = 110319529;</code>
     *
     * @param value The bytes for nextHopIp to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopIp_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopNetwork_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @return Whether the nextHopNetwork field is set.
     */
    public boolean hasNextHopNetwork() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @return The nextHopNetwork.
     */
    public java.lang.String getNextHopNetwork() {
      java.lang.Object ref = nextHopNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @return The bytes for nextHopNetwork.
     */
    public com.google.protobuf.ByteString getNextHopNetworkBytes() {
      java.lang.Object ref = nextHopNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @param value The nextHopNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopNetwork_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopNetwork() {
      nextHopNetwork_ = getDefaultInstance().getNextHopNetwork();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the local network if it should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_network = 262295788;</code>
     *
     * @param value The bytes for nextHopNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopNetwork_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopPeering_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @return Whether the nextHopPeering field is set.
     */
    public boolean hasNextHopPeering() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @return The nextHopPeering.
     */
    public java.lang.String getNextHopPeering() {
      java.lang.Object ref = nextHopPeering_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopPeering_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @return The bytes for nextHopPeering.
     */
    public com.google.protobuf.ByteString getNextHopPeeringBytes() {
      java.lang.Object ref = nextHopPeering_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopPeering_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @param value The nextHopPeering to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopPeering(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopPeering_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopPeering() {
      nextHopPeering_ = getDefaultInstance().getNextHopPeering();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The network peering name that should handle matching packets, which should conform to RFC1035.
     * </pre>
     *
     * <code>optional string next_hop_peering = 412682750;</code>
     *
     * @param value The bytes for nextHopPeering to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopPeeringBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopPeering_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object nextHopVpnTunnel_ = "";
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @return Whether the nextHopVpnTunnel field is set.
     */
    public boolean hasNextHopVpnTunnel() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @return The nextHopVpnTunnel.
     */
    public java.lang.String getNextHopVpnTunnel() {
      java.lang.Object ref = nextHopVpnTunnel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHopVpnTunnel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @return The bytes for nextHopVpnTunnel.
     */
    public com.google.protobuf.ByteString getNextHopVpnTunnelBytes() {
      java.lang.Object ref = nextHopVpnTunnel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHopVpnTunnel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @param value The nextHopVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopVpnTunnel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopVpnTunnel_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopVpnTunnel() {
      nextHopVpnTunnel_ = getDefaultInstance().getNextHopVpnTunnel();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to a VpnTunnel that should handle matching packets.
     * </pre>
     *
     * <code>optional string next_hop_vpn_tunnel = 519844501;</code>
     *
     * @param value The bytes for nextHopVpnTunnel to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopVpnTunnelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopVpnTunnel_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
     * </pre>
     *
     * <code>optional uint32 priority = 445151652;</code>
     *
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    public boolean hasPriority() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
     * </pre>
     *
     * <code>optional uint32 priority = 445151652;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
     * </pre>
     *
     * <code>optional uint32 priority = 445151652;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of this route. Priority is used to break ties in cases where there is more than one matching route of equal prefix length. In cases where multiple routes have equal prefix length, the one with the lowest-numbered priority value wins. The default value is `1000`. The priority value must be from `0` to `65535`, inclusive.
     * </pre>
     *
     * <code>optional uint32 priority = 445151652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00010000);
      priority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object routeStatus_ = "";
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @return Whether the routeStatus field is set.
     */
    public boolean hasRouteStatus() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @return The routeStatus.
     */
    public java.lang.String getRouteStatus() {
      java.lang.Object ref = routeStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routeStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @return The bytes for routeStatus.
     */
    public com.google.protobuf.ByteString getRouteStatusBytes() {
      java.lang.Object ref = routeStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routeStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @param value The routeStatus to set.
     * @return This builder for chaining.
     */
    public Builder setRouteStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routeStatus_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteStatus() {
      routeStatus_ = getDefaultInstance().getRouteStatus();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] The status of the route.
     * Check the RouteStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_status = 418162344;</code>
     *
     * @param value The bytes for routeStatus to set.
     * @return This builder for chaining.
     */
    public Builder setRouteStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routeStatus_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object routeType_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @return Whether the routeType field is set.
     */
    public boolean hasRouteType() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @return The routeType.
     */
    public java.lang.String getRouteType() {
      java.lang.Object ref = routeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @return The bytes for routeType.
     */
    public com.google.protobuf.ByteString getRouteTypeBytes() {
      java.lang.Object ref = routeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @param value The routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routeType_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteType() {
      routeType_ = getDefaultInstance().getRouteType();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
     * Check the RouteType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string route_type = 375888752;</code>
     *
     * @param value The bytes for routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routeType_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00100000;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00100000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of instance tags to which this route applies.
     * </pre>
     *
     * <code>repeated string tags = 3552281;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Warnings> warnings_ =
        java.util.Collections.emptyList();

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        warnings_ = new java.util.ArrayList<com.google.cloud.compute.v1.Warnings>(warnings_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Warnings,
            com.google.cloud.compute.v1.Warnings.Builder,
            com.google.cloud.compute.v1.WarningsOrBuilder>
        warningsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Warnings> getWarningsList() {
      if (warningsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warnings_);
      } else {
        return warningsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public int getWarningsCount() {
      if (warningsBuilder_ == null) {
        return warnings_.size();
      } else {
        return warningsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings getWarnings(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder setWarnings(int index, com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder setWarnings(
        int index, com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(int index, com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(index, value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(
        int index, com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addAllWarnings(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Warnings> values) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        onChanged();
      } else {
        warningsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder clearWarnings() {
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        warningsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder removeWarnings(int index) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.remove(index);
        onChanged();
      } else {
        warningsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder getWarningsBuilder(int index) {
      return getWarningsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.WarningsOrBuilder getWarningsOrBuilder(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.WarningsOrBuilder>
        getWarningsOrBuilderList() {
      if (warningsBuilder_ != null) {
        return warningsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warnings_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder addWarningsBuilder() {
      return getWarningsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Warnings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder addWarningsBuilder(int index) {
      return getWarningsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Warnings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If potential misconfigurations are detected for this route, this field will be populated with warning messages.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Warnings.Builder> getWarningsBuilderList() {
      return getWarningsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Warnings,
            com.google.cloud.compute.v1.Warnings.Builder,
            com.google.cloud.compute.v1.WarningsOrBuilder>
        getWarningsFieldBuilder() {
      if (warningsBuilder_ == null) {
        warningsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Warnings,
                com.google.cloud.compute.v1.Warnings.Builder,
                com.google.cloud.compute.v1.WarningsOrBuilder>(
                warnings_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        warnings_ = null;
      }
      return warningsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Route)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Route)
  private static final com.google.cloud.compute.v1.Route DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Route();
  }

  public static com.google.cloud.compute.v1.Route getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Route> PARSER =
      new com.google.protobuf.AbstractParser<Route>() {
        @java.lang.Override
        public Route parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Route> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Route> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Route getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
