/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterNatRuleAction}
 */
public final class RouterNatRuleAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterNatRuleAction)
    RouterNatRuleActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouterNatRuleAction.newBuilder() to construct.
  private RouterNatRuleAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterNatRuleAction() {
    sourceNatActiveIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceNatActiveRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceNatDrainIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceNatDrainRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterNatRuleAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatRuleAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatRuleAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterNatRuleAction.class,
            com.google.cloud.compute.v1.RouterNatRuleAction.Builder.class);
  }

  public static final int SOURCE_NAT_ACTIVE_IPS_FIELD_NUMBER = 210378229;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceNatActiveIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ips = 210378229;</code>
   *
   * @return A list containing the sourceNatActiveIps.
   */
  public com.google.protobuf.ProtocolStringList getSourceNatActiveIpsList() {
    return sourceNatActiveIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ips = 210378229;</code>
   *
   * @return The count of sourceNatActiveIps.
   */
  public int getSourceNatActiveIpsCount() {
    return sourceNatActiveIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ips = 210378229;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceNatActiveIps at the given index.
   */
  public java.lang.String getSourceNatActiveIps(int index) {
    return sourceNatActiveIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ips = 210378229;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceNatActiveIps at the given index.
   */
  public com.google.protobuf.ByteString getSourceNatActiveIpsBytes(int index) {
    return sourceNatActiveIps_.getByteString(index);
  }

  public static final int SOURCE_NAT_ACTIVE_RANGES_FIELD_NUMBER = 190556269;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceNatActiveRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ranges = 190556269;</code>
   *
   * @return A list containing the sourceNatActiveRanges.
   */
  public com.google.protobuf.ProtocolStringList getSourceNatActiveRangesList() {
    return sourceNatActiveRanges_;
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ranges = 190556269;</code>
   *
   * @return The count of sourceNatActiveRanges.
   */
  public int getSourceNatActiveRangesCount() {
    return sourceNatActiveRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ranges = 190556269;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceNatActiveRanges at the given index.
   */
  public java.lang.String getSourceNatActiveRanges(int index) {
    return sourceNatActiveRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_active_ranges = 190556269;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceNatActiveRanges at the given index.
   */
  public com.google.protobuf.ByteString getSourceNatActiveRangesBytes(int index) {
    return sourceNatActiveRanges_.getByteString(index);
  }

  public static final int SOURCE_NAT_DRAIN_IPS_FIELD_NUMBER = 340812451;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceNatDrainIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ips = 340812451;</code>
   *
   * @return A list containing the sourceNatDrainIps.
   */
  public com.google.protobuf.ProtocolStringList getSourceNatDrainIpsList() {
    return sourceNatDrainIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ips = 340812451;</code>
   *
   * @return The count of sourceNatDrainIps.
   */
  public int getSourceNatDrainIpsCount() {
    return sourceNatDrainIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ips = 340812451;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceNatDrainIps at the given index.
   */
  public java.lang.String getSourceNatDrainIps(int index) {
    return sourceNatDrainIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ips = 340812451;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceNatDrainIps at the given index.
   */
  public com.google.protobuf.ByteString getSourceNatDrainIpsBytes(int index) {
    return sourceNatDrainIps_.getByteString(index);
  }

  public static final int SOURCE_NAT_DRAIN_RANGES_FIELD_NUMBER = 84802815;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceNatDrainRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ranges = 84802815;</code>
   *
   * @return A list containing the sourceNatDrainRanges.
   */
  public com.google.protobuf.ProtocolStringList getSourceNatDrainRangesList() {
    return sourceNatDrainRanges_;
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ranges = 84802815;</code>
   *
   * @return The count of sourceNatDrainRanges.
   */
  public int getSourceNatDrainRangesCount() {
    return sourceNatDrainRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ranges = 84802815;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceNatDrainRanges at the given index.
   */
  public java.lang.String getSourceNatDrainRanges(int index) {
    return sourceNatDrainRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
   * </pre>
   *
   * <code>repeated string source_nat_drain_ranges = 84802815;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceNatDrainRanges at the given index.
   */
  public com.google.protobuf.ByteString getSourceNatDrainRangesBytes(int index) {
    return sourceNatDrainRanges_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < sourceNatDrainRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 84802815, sourceNatDrainRanges_.getRaw(i));
    }
    for (int i = 0; i < sourceNatActiveRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 190556269, sourceNatActiveRanges_.getRaw(i));
    }
    for (int i = 0; i < sourceNatActiveIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 210378229, sourceNatActiveIps_.getRaw(i));
    }
    for (int i = 0; i < sourceNatDrainIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 340812451, sourceNatDrainIps_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < sourceNatDrainRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceNatDrainRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceNatDrainRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceNatActiveRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceNatActiveRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceNatActiveRangesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceNatActiveIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceNatActiveIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceNatActiveIpsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceNatDrainIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceNatDrainIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceNatDrainIpsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterNatRuleAction)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterNatRuleAction other =
        (com.google.cloud.compute.v1.RouterNatRuleAction) obj;

    if (!getSourceNatActiveIpsList().equals(other.getSourceNatActiveIpsList())) return false;
    if (!getSourceNatActiveRangesList().equals(other.getSourceNatActiveRangesList())) return false;
    if (!getSourceNatDrainIpsList().equals(other.getSourceNatDrainIpsList())) return false;
    if (!getSourceNatDrainRangesList().equals(other.getSourceNatDrainRangesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSourceNatActiveIpsCount() > 0) {
      hash = (37 * hash) + SOURCE_NAT_ACTIVE_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNatActiveIpsList().hashCode();
    }
    if (getSourceNatActiveRangesCount() > 0) {
      hash = (37 * hash) + SOURCE_NAT_ACTIVE_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNatActiveRangesList().hashCode();
    }
    if (getSourceNatDrainIpsCount() > 0) {
      hash = (37 * hash) + SOURCE_NAT_DRAIN_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNatDrainIpsList().hashCode();
    }
    if (getSourceNatDrainRangesCount() > 0) {
      hash = (37 * hash) + SOURCE_NAT_DRAIN_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNatDrainRangesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterNatRuleAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterNatRuleAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterNatRuleAction)
      com.google.cloud.compute.v1.RouterNatRuleActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRuleAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRuleAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterNatRuleAction.class,
              com.google.cloud.compute.v1.RouterNatRuleAction.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterNatRuleAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceNatActiveIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceNatActiveRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceNatDrainIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceNatDrainRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatRuleAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRuleAction getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRuleAction build() {
      com.google.cloud.compute.v1.RouterNatRuleAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatRuleAction buildPartial() {
      com.google.cloud.compute.v1.RouterNatRuleAction result =
          new com.google.cloud.compute.v1.RouterNatRuleAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterNatRuleAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        sourceNatActiveIps_.makeImmutable();
        result.sourceNatActiveIps_ = sourceNatActiveIps_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        sourceNatActiveRanges_.makeImmutable();
        result.sourceNatActiveRanges_ = sourceNatActiveRanges_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        sourceNatDrainIps_.makeImmutable();
        result.sourceNatDrainIps_ = sourceNatDrainIps_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        sourceNatDrainRanges_.makeImmutable();
        result.sourceNatDrainRanges_ = sourceNatDrainRanges_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterNatRuleAction) {
        return mergeFrom((com.google.cloud.compute.v1.RouterNatRuleAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterNatRuleAction other) {
      if (other == com.google.cloud.compute.v1.RouterNatRuleAction.getDefaultInstance())
        return this;
      if (!other.sourceNatActiveIps_.isEmpty()) {
        if (sourceNatActiveIps_.isEmpty()) {
          sourceNatActiveIps_ = other.sourceNatActiveIps_;
          bitField0_ |= 0x00000001;
        } else {
          ensureSourceNatActiveIpsIsMutable();
          sourceNatActiveIps_.addAll(other.sourceNatActiveIps_);
        }
        onChanged();
      }
      if (!other.sourceNatActiveRanges_.isEmpty()) {
        if (sourceNatActiveRanges_.isEmpty()) {
          sourceNatActiveRanges_ = other.sourceNatActiveRanges_;
          bitField0_ |= 0x00000002;
        } else {
          ensureSourceNatActiveRangesIsMutable();
          sourceNatActiveRanges_.addAll(other.sourceNatActiveRanges_);
        }
        onChanged();
      }
      if (!other.sourceNatDrainIps_.isEmpty()) {
        if (sourceNatDrainIps_.isEmpty()) {
          sourceNatDrainIps_ = other.sourceNatDrainIps_;
          bitField0_ |= 0x00000004;
        } else {
          ensureSourceNatDrainIpsIsMutable();
          sourceNatDrainIps_.addAll(other.sourceNatDrainIps_);
        }
        onChanged();
      }
      if (!other.sourceNatDrainRanges_.isEmpty()) {
        if (sourceNatDrainRanges_.isEmpty()) {
          sourceNatDrainRanges_ = other.sourceNatDrainRanges_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSourceNatDrainRangesIsMutable();
          sourceNatDrainRanges_.addAll(other.sourceNatDrainRanges_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 678422522:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceNatDrainRangesIsMutable();
                sourceNatDrainRanges_.add(s);
                break;
              } // case 678422522
            case 1524450154:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceNatActiveRangesIsMutable();
                sourceNatActiveRanges_.add(s);
                break;
              } // case 1524450154
            case 1683025834:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceNatActiveIpsIsMutable();
                sourceNatActiveIps_.add(s);
                break;
              } // case 1683025834
            case -1568467686:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceNatDrainIpsIsMutable();
                sourceNatDrainIps_.add(s);
                break;
              } // case -1568467686
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList sourceNatActiveIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceNatActiveIpsIsMutable() {
      if (!sourceNatActiveIps_.isModifiable()) {
        sourceNatActiveIps_ = new com.google.protobuf.LazyStringArrayList(sourceNatActiveIps_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @return A list containing the sourceNatActiveIps.
     */
    public com.google.protobuf.ProtocolStringList getSourceNatActiveIpsList() {
      sourceNatActiveIps_.makeImmutable();
      return sourceNatActiveIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @return The count of sourceNatActiveIps.
     */
    public int getSourceNatActiveIpsCount() {
      return sourceNatActiveIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceNatActiveIps at the given index.
     */
    public java.lang.String getSourceNatActiveIps(int index) {
      return sourceNatActiveIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceNatActiveIps at the given index.
     */
    public com.google.protobuf.ByteString getSourceNatActiveIpsBytes(int index) {
      return sourceNatActiveIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceNatActiveIps to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNatActiveIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatActiveIpsIsMutable();
      sourceNatActiveIps_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param value The sourceNatActiveIps to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatActiveIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatActiveIpsIsMutable();
      sourceNatActiveIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param values The sourceNatActiveIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceNatActiveIps(java.lang.Iterable<java.lang.String> values) {
      ensureSourceNatActiveIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceNatActiveIps_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceNatActiveIps() {
      sourceNatActiveIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this NAT rule. These IP addresses must be valid static external IP addresses assigned to the project. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ips = 210378229;</code>
     *
     * @param value The bytes of the sourceNatActiveIps to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatActiveIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceNatActiveIpsIsMutable();
      sourceNatActiveIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceNatActiveRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceNatActiveRangesIsMutable() {
      if (!sourceNatActiveRanges_.isModifiable()) {
        sourceNatActiveRanges_ =
            new com.google.protobuf.LazyStringArrayList(sourceNatActiveRanges_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @return A list containing the sourceNatActiveRanges.
     */
    public com.google.protobuf.ProtocolStringList getSourceNatActiveRangesList() {
      sourceNatActiveRanges_.makeImmutable();
      return sourceNatActiveRanges_;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @return The count of sourceNatActiveRanges.
     */
    public int getSourceNatActiveRangesCount() {
      return sourceNatActiveRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceNatActiveRanges at the given index.
     */
    public java.lang.String getSourceNatActiveRanges(int index) {
      return sourceNatActiveRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceNatActiveRanges at the given index.
     */
    public com.google.protobuf.ByteString getSourceNatActiveRangesBytes(int index) {
      return sourceNatActiveRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceNatActiveRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNatActiveRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatActiveRangesIsMutable();
      sourceNatActiveRanges_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param value The sourceNatActiveRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatActiveRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatActiveRangesIsMutable();
      sourceNatActiveRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param values The sourceNatActiveRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceNatActiveRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSourceNatActiveRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceNatActiveRanges_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceNatActiveRanges() {
      sourceNatActiveRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the subnetworks used as source ranges for this NAT Rule. These subnetworks must have purpose set to PRIVATE_NAT. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_active_ranges = 190556269;</code>
     *
     * @param value The bytes of the sourceNatActiveRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatActiveRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceNatActiveRangesIsMutable();
      sourceNatActiveRanges_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceNatDrainIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceNatDrainIpsIsMutable() {
      if (!sourceNatDrainIps_.isModifiable()) {
        sourceNatDrainIps_ = new com.google.protobuf.LazyStringArrayList(sourceNatDrainIps_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @return A list containing the sourceNatDrainIps.
     */
    public com.google.protobuf.ProtocolStringList getSourceNatDrainIpsList() {
      sourceNatDrainIps_.makeImmutable();
      return sourceNatDrainIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @return The count of sourceNatDrainIps.
     */
    public int getSourceNatDrainIpsCount() {
      return sourceNatDrainIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceNatDrainIps at the given index.
     */
    public java.lang.String getSourceNatDrainIps(int index) {
      return sourceNatDrainIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceNatDrainIps at the given index.
     */
    public com.google.protobuf.ByteString getSourceNatDrainIpsBytes(int index) {
      return sourceNatDrainIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceNatDrainIps to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNatDrainIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatDrainIpsIsMutable();
      sourceNatDrainIps_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param value The sourceNatDrainIps to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatDrainIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatDrainIpsIsMutable();
      sourceNatDrainIps_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param values The sourceNatDrainIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceNatDrainIps(java.lang.Iterable<java.lang.String> values) {
      ensureSourceNatDrainIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceNatDrainIps_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceNatDrainIps() {
      sourceNatDrainIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT rule only. This field is used for public NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ips = 340812451;</code>
     *
     * @param value The bytes of the sourceNatDrainIps to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatDrainIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceNatDrainIpsIsMutable();
      sourceNatDrainIps_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceNatDrainRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceNatDrainRangesIsMutable() {
      if (!sourceNatDrainRanges_.isModifiable()) {
        sourceNatDrainRanges_ = new com.google.protobuf.LazyStringArrayList(sourceNatDrainRanges_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @return A list containing the sourceNatDrainRanges.
     */
    public com.google.protobuf.ProtocolStringList getSourceNatDrainRangesList() {
      sourceNatDrainRanges_.makeImmutable();
      return sourceNatDrainRanges_;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @return The count of sourceNatDrainRanges.
     */
    public int getSourceNatDrainRangesCount() {
      return sourceNatDrainRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceNatDrainRanges at the given index.
     */
    public java.lang.String getSourceNatDrainRanges(int index) {
      return sourceNatDrainRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceNatDrainRanges at the given index.
     */
    public com.google.protobuf.ByteString getSourceNatDrainRangesBytes(int index) {
      return sourceNatDrainRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceNatDrainRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSourceNatDrainRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatDrainRangesIsMutable();
      sourceNatDrainRanges_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param value The sourceNatDrainRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatDrainRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceNatDrainRangesIsMutable();
      sourceNatDrainRanges_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param values The sourceNatDrainRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceNatDrainRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSourceNatDrainRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceNatDrainRanges_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceNatDrainRanges() {
      sourceNatDrainRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of URLs of subnetworks representing source ranges to be drained. This is only supported on patch/update, and these subnetworks must have previously been used as active ranges in this NAT Rule. This field is used for private NAT.
     * </pre>
     *
     * <code>repeated string source_nat_drain_ranges = 84802815;</code>
     *
     * @param value The bytes of the sourceNatDrainRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSourceNatDrainRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceNatDrainRangesIsMutable();
      sourceNatDrainRanges_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterNatRuleAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterNatRuleAction)
  private static final com.google.cloud.compute.v1.RouterNatRuleAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterNatRuleAction();
  }

  public static com.google.cloud.compute.v1.RouterNatRuleAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterNatRuleAction> PARSER =
      new com.google.protobuf.AbstractParser<RouterNatRuleAction>() {
        @java.lang.Override
        public RouterNatRuleAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterNatRuleAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterNatRuleAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRuleAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
