/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Status of a NAT Rule contained in this NAT.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus}
 */
public final class RouterStatusNatStatusNatRuleStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus)
    RouterStatusNatStatusNatRuleStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouterStatusNatStatusNatRuleStatus.newBuilder() to construct.
  private RouterStatusNatStatusNatRuleStatus(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterStatusNatStatusNatRuleStatus() {
    activeNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterStatusNatStatusNatRuleStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusNatStatusNatRuleStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatusNatStatusNatRuleStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.class,
            com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder.class);
  }

  private int bitField0_;
  public static final int ACTIVE_NAT_IPS_FIELD_NUMBER = 208517077;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList activeNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string active_nat_ips = 208517077;</code>
   *
   * @return A list containing the activeNatIps.
   */
  public com.google.protobuf.ProtocolStringList getActiveNatIpsList() {
    return activeNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string active_nat_ips = 208517077;</code>
   *
   * @return The count of activeNatIps.
   */
  public int getActiveNatIpsCount() {
    return activeNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string active_nat_ips = 208517077;</code>
   *
   * @param index The index of the element to return.
   * @return The activeNatIps at the given index.
   */
  public java.lang.String getActiveNatIps(int index) {
    return activeNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string active_nat_ips = 208517077;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the activeNatIps at the given index.
   */
  public com.google.protobuf.ByteString getActiveNatIpsBytes(int index) {
    return activeNatIps_.getByteString(index);
  }

  public static final int DRAIN_NAT_IPS_FIELD_NUMBER = 504078535;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList drainNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @return A list containing the drainNatIps.
   */
  public com.google.protobuf.ProtocolStringList getDrainNatIpsList() {
    return drainNatIps_;
  }
  /**
   *
   *
   * <pre>
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @return The count of drainNatIps.
   */
  public int getDrainNatIpsCount() {
    return drainNatIps_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @param index The index of the element to return.
   * @return The drainNatIps at the given index.
   */
  public java.lang.String getDrainNatIps(int index) {
    return drainNatIps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the drainNatIps at the given index.
   */
  public com.google.protobuf.ByteString getDrainNatIpsBytes(int index) {
    return drainNatIps_.getByteString(index);
  }

  public static final int MIN_EXTRA_IPS_NEEDED_FIELD_NUMBER = 353002756;
  private int minExtraIpsNeeded_ = 0;
  /**
   *
   *
   * <pre>
   * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
   * </pre>
   *
   * <code>optional int32 min_extra_ips_needed = 353002756;</code>
   *
   * @return Whether the minExtraIpsNeeded field is set.
   */
  @java.lang.Override
  public boolean hasMinExtraIpsNeeded() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
   * </pre>
   *
   * <code>optional int32 min_extra_ips_needed = 353002756;</code>
   *
   * @return The minExtraIpsNeeded.
   */
  @java.lang.Override
  public int getMinExtraIpsNeeded() {
    return minExtraIpsNeeded_;
  }

  public static final int NUM_VM_ENDPOINTS_WITH_NAT_MAPPINGS_FIELD_NUMBER = 512367468;
  private int numVmEndpointsWithNatMappings_ = 0;
  /**
   *
   *
   * <pre>
   * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
   * </pre>
   *
   * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
   *
   * @return Whether the numVmEndpointsWithNatMappings field is set.
   */
  @java.lang.Override
  public boolean hasNumVmEndpointsWithNatMappings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
   * </pre>
   *
   * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
   *
   * @return The numVmEndpointsWithNatMappings.
   */
  @java.lang.Override
  public int getNumVmEndpointsWithNatMappings() {
    return numVmEndpointsWithNatMappings_;
  }

  public static final int RULE_NUMBER_FIELD_NUMBER = 535211500;
  private int ruleNumber_ = 0;
  /**
   *
   *
   * <pre>
   * Rule number of the rule.
   * </pre>
   *
   * <code>optional int32 rule_number = 535211500;</code>
   *
   * @return Whether the ruleNumber field is set.
   */
  @java.lang.Override
  public boolean hasRuleNumber() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Rule number of the rule.
   * </pre>
   *
   * <code>optional int32 rule_number = 535211500;</code>
   *
   * @return The ruleNumber.
   */
  @java.lang.Override
  public int getRuleNumber() {
    return ruleNumber_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < activeNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 208517077, activeNatIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(353002756, minExtraIpsNeeded_);
    }
    for (int i = 0; i < drainNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 504078535, drainNatIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(512367468, numVmEndpointsWithNatMappings_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(535211500, ruleNumber_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < activeNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(activeNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getActiveNatIpsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(353002756, minExtraIpsNeeded_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < drainNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(drainNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDrainNatIpsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              512367468, numVmEndpointsWithNatMappings_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(535211500, ruleNumber_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus other =
        (com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus) obj;

    if (!getActiveNatIpsList().equals(other.getActiveNatIpsList())) return false;
    if (!getDrainNatIpsList().equals(other.getDrainNatIpsList())) return false;
    if (hasMinExtraIpsNeeded() != other.hasMinExtraIpsNeeded()) return false;
    if (hasMinExtraIpsNeeded()) {
      if (getMinExtraIpsNeeded() != other.getMinExtraIpsNeeded()) return false;
    }
    if (hasNumVmEndpointsWithNatMappings() != other.hasNumVmEndpointsWithNatMappings())
      return false;
    if (hasNumVmEndpointsWithNatMappings()) {
      if (getNumVmEndpointsWithNatMappings() != other.getNumVmEndpointsWithNatMappings())
        return false;
    }
    if (hasRuleNumber() != other.hasRuleNumber()) return false;
    if (hasRuleNumber()) {
      if (getRuleNumber() != other.getRuleNumber()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getActiveNatIpsCount() > 0) {
      hash = (37 * hash) + ACTIVE_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getActiveNatIpsList().hashCode();
    }
    if (getDrainNatIpsCount() > 0) {
      hash = (37 * hash) + DRAIN_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getDrainNatIpsList().hashCode();
    }
    if (hasMinExtraIpsNeeded()) {
      hash = (37 * hash) + MIN_EXTRA_IPS_NEEDED_FIELD_NUMBER;
      hash = (53 * hash) + getMinExtraIpsNeeded();
    }
    if (hasNumVmEndpointsWithNatMappings()) {
      hash = (37 * hash) + NUM_VM_ENDPOINTS_WITH_NAT_MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + getNumVmEndpointsWithNatMappings();
    }
    if (hasRuleNumber()) {
      hash = (37 * hash) + RULE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getRuleNumber();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Status of a NAT Rule contained in this NAT.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus)
      com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatusNatRuleStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatusNatRuleStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.class,
              com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      activeNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      minExtraIpsNeeded_ = 0;
      numVmEndpointsWithNatMappings_ = 0;
      ruleNumber_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatusNatStatusNatRuleStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus build() {
      com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus buildPartial() {
      com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus result =
          new com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        activeNatIps_.makeImmutable();
        result.activeNatIps_ = activeNatIps_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        drainNatIps_.makeImmutable();
        result.drainNatIps_ = drainNatIps_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.minExtraIpsNeeded_ = minExtraIpsNeeded_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.numVmEndpointsWithNatMappings_ = numVmEndpointsWithNatMappings_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ruleNumber_ = ruleNumber_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus) {
        return mergeFrom((com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus other) {
      if (other
          == com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus.getDefaultInstance())
        return this;
      if (!other.activeNatIps_.isEmpty()) {
        if (activeNatIps_.isEmpty()) {
          activeNatIps_ = other.activeNatIps_;
          bitField0_ |= 0x00000001;
        } else {
          ensureActiveNatIpsIsMutable();
          activeNatIps_.addAll(other.activeNatIps_);
        }
        onChanged();
      }
      if (!other.drainNatIps_.isEmpty()) {
        if (drainNatIps_.isEmpty()) {
          drainNatIps_ = other.drainNatIps_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDrainNatIpsIsMutable();
          drainNatIps_.addAll(other.drainNatIps_);
        }
        onChanged();
      }
      if (other.hasMinExtraIpsNeeded()) {
        setMinExtraIpsNeeded(other.getMinExtraIpsNeeded());
      }
      if (other.hasNumVmEndpointsWithNatMappings()) {
        setNumVmEndpointsWithNatMappings(other.getNumVmEndpointsWithNatMappings());
      }
      if (other.hasRuleNumber()) {
        setRuleNumber(other.getRuleNumber());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1668136618:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureActiveNatIpsIsMutable();
                activeNatIps_.add(s);
                break;
              } // case 1668136618
            case -1470945248:
              {
                minExtraIpsNeeded_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case -1470945248
            case -262339014:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDrainNatIpsIsMutable();
                drainNatIps_.add(s);
                break;
              } // case -262339014
            case -196027552:
              {
                numVmEndpointsWithNatMappings_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -196027552
            case -13275296:
              {
                ruleNumber_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -13275296
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList activeNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureActiveNatIpsIsMutable() {
      if (!activeNatIps_.isModifiable()) {
        activeNatIps_ = new com.google.protobuf.LazyStringArrayList(activeNatIps_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @return A list containing the activeNatIps.
     */
    public com.google.protobuf.ProtocolStringList getActiveNatIpsList() {
      activeNatIps_.makeImmutable();
      return activeNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @return The count of activeNatIps.
     */
    public int getActiveNatIpsCount() {
      return activeNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param index The index of the element to return.
     * @return The activeNatIps at the given index.
     */
    public java.lang.String getActiveNatIps(int index) {
      return activeNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the activeNatIps at the given index.
     */
    public com.google.protobuf.ByteString getActiveNatIpsBytes(int index) {
      return activeNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param index The index to set the value at.
     * @param value The activeNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setActiveNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActiveNatIpsIsMutable();
      activeNatIps_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param value The activeNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addActiveNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActiveNatIpsIsMutable();
      activeNatIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param values The activeNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllActiveNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureActiveNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, activeNatIps_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActiveNatIps() {
      activeNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of active IPs for NAT. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string active_nat_ips = 208517077;</code>
     *
     * @param value The bytes of the activeNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addActiveNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureActiveNatIpsIsMutable();
      activeNatIps_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList drainNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDrainNatIpsIsMutable() {
      if (!drainNatIps_.isModifiable()) {
        drainNatIps_ = new com.google.protobuf.LazyStringArrayList(drainNatIps_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return A list containing the drainNatIps.
     */
    public com.google.protobuf.ProtocolStringList getDrainNatIpsList() {
      drainNatIps_.makeImmutable();
      return drainNatIps_;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return The count of drainNatIps.
     */
    public int getDrainNatIpsCount() {
      return drainNatIps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index of the element to return.
     * @return The drainNatIps at the given index.
     */
    public java.lang.String getDrainNatIps(int index) {
      return drainNatIps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the drainNatIps at the given index.
     */
    public com.google.protobuf.ByteString getDrainNatIpsBytes(int index) {
      return drainNatIps_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index to set the value at.
     * @param value The drainNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setDrainNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpsIsMutable();
      drainNatIps_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param value The drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpsIsMutable();
      drainNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param values The drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllDrainNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureDrainNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, drainNatIps_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDrainNatIps() {
      drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of IPs for NAT that are in drain mode. Example: ["1.1.1.1", "179.12.26.133"].
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param value The bytes of the drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDrainNatIpsIsMutable();
      drainNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int minExtraIpsNeeded_;
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
     * </pre>
     *
     * <code>optional int32 min_extra_ips_needed = 353002756;</code>
     *
     * @return Whether the minExtraIpsNeeded field is set.
     */
    @java.lang.Override
    public boolean hasMinExtraIpsNeeded() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
     * </pre>
     *
     * <code>optional int32 min_extra_ips_needed = 353002756;</code>
     *
     * @return The minExtraIpsNeeded.
     */
    @java.lang.Override
    public int getMinExtraIpsNeeded() {
      return minExtraIpsNeeded_;
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
     * </pre>
     *
     * <code>optional int32 min_extra_ips_needed = 353002756;</code>
     *
     * @param value The minExtraIpsNeeded to set.
     * @return This builder for chaining.
     */
    public Builder setMinExtraIpsNeeded(int value) {

      minExtraIpsNeeded_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of extra IPs to allocate. This will be greater than 0 only if the existing IPs in this NAT Rule are NOT enough to allow all configured VMs to use NAT.
     * </pre>
     *
     * <code>optional int32 min_extra_ips_needed = 353002756;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinExtraIpsNeeded() {
      bitField0_ = (bitField0_ & ~0x00000004);
      minExtraIpsNeeded_ = 0;
      onChanged();
      return this;
    }

    private int numVmEndpointsWithNatMappings_;
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return Whether the numVmEndpointsWithNatMappings field is set.
     */
    @java.lang.Override
    public boolean hasNumVmEndpointsWithNatMappings() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return The numVmEndpointsWithNatMappings.
     */
    @java.lang.Override
    public int getNumVmEndpointsWithNatMappings() {
      return numVmEndpointsWithNatMappings_;
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @param value The numVmEndpointsWithNatMappings to set.
     * @return This builder for chaining.
     */
    public Builder setNumVmEndpointsWithNatMappings(int value) {

      numVmEndpointsWithNatMappings_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of VM endpoints (i.e., NICs) that have NAT Mappings from this NAT Rule.
     * </pre>
     *
     * <code>optional int32 num_vm_endpoints_with_nat_mappings = 512367468;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumVmEndpointsWithNatMappings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      numVmEndpointsWithNatMappings_ = 0;
      onChanged();
      return this;
    }

    private int ruleNumber_;
    /**
     *
     *
     * <pre>
     * Rule number of the rule.
     * </pre>
     *
     * <code>optional int32 rule_number = 535211500;</code>
     *
     * @return Whether the ruleNumber field is set.
     */
    @java.lang.Override
    public boolean hasRuleNumber() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rule number of the rule.
     * </pre>
     *
     * <code>optional int32 rule_number = 535211500;</code>
     *
     * @return The ruleNumber.
     */
    @java.lang.Override
    public int getRuleNumber() {
      return ruleNumber_;
    }
    /**
     *
     *
     * <pre>
     * Rule number of the rule.
     * </pre>
     *
     * <code>optional int32 rule_number = 535211500;</code>
     *
     * @param value The ruleNumber to set.
     * @return This builder for chaining.
     */
    public Builder setRuleNumber(int value) {

      ruleNumber_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule number of the rule.
     * </pre>
     *
     * <code>optional int32 rule_number = 535211500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleNumber() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ruleNumber_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus)
  private static final com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus();
  }

  public static com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterStatusNatStatusNatRuleStatus> PARSER =
      new com.google.protobuf.AbstractParser<RouterStatusNatStatusNatRuleStatus>() {
        @java.lang.Override
        public RouterStatusNatStatusNatRuleStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterStatusNatStatusNatRuleStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterStatusNatStatusNatRuleStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatusNatRuleStatus
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
