/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Sets the scheduling options for an Instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Scheduling}
 */
public final class Scheduling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Scheduling)
    SchedulingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Scheduling.newBuilder() to construct.
  private Scheduling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Scheduling() {
    instanceTerminationAction_ = "";
    locationHint_ = "";
    nodeAffinities_ = java.util.Collections.emptyList();
    onHostMaintenance_ = "";
    provisioningModel_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Scheduling();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Scheduling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Scheduling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Scheduling.class,
            com.google.cloud.compute.v1.Scheduling.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Scheduling.InstanceTerminationAction}
   */
  public enum InstanceTerminationAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_TERMINATION_ACTION = 0;</code>
     */
    UNDEFINED_INSTANCE_TERMINATION_ACTION(0),
    /**
     *
     *
     * <pre>
     * Delete the VM.
     * </pre>
     *
     * <code>DELETE = 402225579;</code>
     */
    DELETE(402225579),
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>INSTANCE_TERMINATION_ACTION_UNSPECIFIED = 92954803;</code>
     */
    INSTANCE_TERMINATION_ACTION_UNSPECIFIED(92954803),
    /**
     *
     *
     * <pre>
     * Stop the VM without storing in-memory content. default action.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    STOP(2555906),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANCE_TERMINATION_ACTION = 0;</code>
     */
    public static final int UNDEFINED_INSTANCE_TERMINATION_ACTION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Delete the VM.
     * </pre>
     *
     * <code>DELETE = 402225579;</code>
     */
    public static final int DELETE_VALUE = 402225579;
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>INSTANCE_TERMINATION_ACTION_UNSPECIFIED = 92954803;</code>
     */
    public static final int INSTANCE_TERMINATION_ACTION_UNSPECIFIED_VALUE = 92954803;
    /**
     *
     *
     * <pre>
     * Stop the VM without storing in-memory content. default action.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    public static final int STOP_VALUE = 2555906;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstanceTerminationAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InstanceTerminationAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INSTANCE_TERMINATION_ACTION;
        case 402225579:
          return DELETE;
        case 92954803:
          return INSTANCE_TERMINATION_ACTION_UNSPECIFIED;
        case 2555906:
          return STOP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InstanceTerminationAction>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InstanceTerminationAction>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InstanceTerminationAction>() {
              public InstanceTerminationAction findValueByNumber(int number) {
                return InstanceTerminationAction.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Scheduling.getDescriptor().getEnumTypes().get(0);
    }

    private static final InstanceTerminationAction[] VALUES = values();

    public static InstanceTerminationAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InstanceTerminationAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Scheduling.InstanceTerminationAction)
  }

  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Scheduling.OnHostMaintenance}
   */
  public enum OnHostMaintenance implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ON_HOST_MAINTENANCE = 0;</code>
     */
    UNDEFINED_ON_HOST_MAINTENANCE(0),
    /**
     *
     *
     * <pre>
     * *[Default]* Allows Compute Engine to automatically migrate instances out of the way of maintenance events.
     * </pre>
     *
     * <code>MIGRATE = 165699979;</code>
     */
    MIGRATE(165699979),
    /**
     *
     *
     * <pre>
     * Tells Compute Engine to terminate and (optionally) restart the instance away from the maintenance activity. If you would like your instance to be restarted, set the automaticRestart flag to true. Your instance may be restarted more than once, and it may be restarted outside the window of maintenance events.
     * </pre>
     *
     * <code>TERMINATE = 527617601;</code>
     */
    TERMINATE(527617601),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ON_HOST_MAINTENANCE = 0;</code>
     */
    public static final int UNDEFINED_ON_HOST_MAINTENANCE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * *[Default]* Allows Compute Engine to automatically migrate instances out of the way of maintenance events.
     * </pre>
     *
     * <code>MIGRATE = 165699979;</code>
     */
    public static final int MIGRATE_VALUE = 165699979;
    /**
     *
     *
     * <pre>
     * Tells Compute Engine to terminate and (optionally) restart the instance away from the maintenance activity. If you would like your instance to be restarted, set the automaticRestart flag to true. Your instance may be restarted more than once, and it may be restarted outside the window of maintenance events.
     * </pre>
     *
     * <code>TERMINATE = 527617601;</code>
     */
    public static final int TERMINATE_VALUE = 527617601;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OnHostMaintenance valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OnHostMaintenance forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ON_HOST_MAINTENANCE;
        case 165699979:
          return MIGRATE;
        case 527617601:
          return TERMINATE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OnHostMaintenance>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OnHostMaintenance>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OnHostMaintenance>() {
              public OnHostMaintenance findValueByNumber(int number) {
                return OnHostMaintenance.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Scheduling.getDescriptor().getEnumTypes().get(1);
    }

    private static final OnHostMaintenance[] VALUES = values();

    public static OnHostMaintenance valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OnHostMaintenance(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Scheduling.OnHostMaintenance)
  }

  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Scheduling.ProvisioningModel}
   */
  public enum ProvisioningModel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PROVISIONING_MODEL = 0;</code>
     */
    UNDEFINED_PROVISIONING_MODEL(0),
    /**
     *
     *
     * <pre>
     * Heavily discounted, no guaranteed runtime.
     * </pre>
     *
     * <code>SPOT = 2552066;</code>
     */
    SPOT(2552066),
    /**
     *
     *
     * <pre>
     * Standard provisioning with user controlled runtime, no discounts.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    STANDARD(484642493),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PROVISIONING_MODEL = 0;</code>
     */
    public static final int UNDEFINED_PROVISIONING_MODEL_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Heavily discounted, no guaranteed runtime.
     * </pre>
     *
     * <code>SPOT = 2552066;</code>
     */
    public static final int SPOT_VALUE = 2552066;
    /**
     *
     *
     * <pre>
     * Standard provisioning with user controlled runtime, no discounts.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    public static final int STANDARD_VALUE = 484642493;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProvisioningModel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProvisioningModel forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PROVISIONING_MODEL;
        case 2552066:
          return SPOT;
        case 484642493:
          return STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>() {
              public ProvisioningModel findValueByNumber(int number) {
                return ProvisioningModel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Scheduling.getDescriptor().getEnumTypes().get(2);
    }

    private static final ProvisioningModel[] VALUES = values();

    public static ProvisioningModel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProvisioningModel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Scheduling.ProvisioningModel)
  }

  private int bitField0_;
  public static final int AUTOMATIC_RESTART_FIELD_NUMBER = 350821371;
  private boolean automaticRestart_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
   * </pre>
   *
   * <code>optional bool automatic_restart = 350821371;</code>
   *
   * @return Whether the automaticRestart field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticRestart() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
   * </pre>
   *
   * <code>optional bool automatic_restart = 350821371;</code>
   *
   * @return The automaticRestart.
   */
  @java.lang.Override
  public boolean getAutomaticRestart() {
    return automaticRestart_;
  }

  public static final int INSTANCE_TERMINATION_ACTION_FIELD_NUMBER = 107380667;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceTerminationAction_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return Whether the instanceTerminationAction field is set.
   */
  @java.lang.Override
  public boolean hasInstanceTerminationAction() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return The instanceTerminationAction.
   */
  @java.lang.Override
  public java.lang.String getInstanceTerminationAction() {
    java.lang.Object ref = instanceTerminationAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceTerminationAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the termination action for the instance.
   * Check the InstanceTerminationAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instance_termination_action = 107380667;</code>
   *
   * @return The bytes for instanceTerminationAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceTerminationActionBytes() {
    java.lang.Object ref = instanceTerminationAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceTerminationAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_SSD_RECOVERY_TIMEOUT_FIELD_NUMBER = 268015590;
  private com.google.cloud.compute.v1.Duration localSsdRecoveryTimeout_;
  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   *
   * @return Whether the localSsdRecoveryTimeout field is set.
   */
  @java.lang.Override
  public boolean hasLocalSsdRecoveryTimeout() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   *
   * @return The localSsdRecoveryTimeout.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getLocalSsdRecoveryTimeout() {
    return localSsdRecoveryTimeout_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : localSsdRecoveryTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getLocalSsdRecoveryTimeoutOrBuilder() {
    return localSsdRecoveryTimeout_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : localSsdRecoveryTimeout_;
  }

  public static final int LOCATION_HINT_FIELD_NUMBER = 350519505;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationHint_ = "";
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  @java.lang.Override
  public boolean hasLocationHint() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  @java.lang.Override
  public java.lang.String getLocationHint() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationHint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationHintBytes() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationHint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIN_NODE_CPUS_FIELD_NUMBER = 317231675;
  private int minNodeCpus_ = 0;
  /**
   *
   *
   * <pre>
   * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
   * </pre>
   *
   * <code>optional int32 min_node_cpus = 317231675;</code>
   *
   * @return Whether the minNodeCpus field is set.
   */
  @java.lang.Override
  public boolean hasMinNodeCpus() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
   * </pre>
   *
   * <code>optional int32 min_node_cpus = 317231675;</code>
   *
   * @return The minNodeCpus.
   */
  @java.lang.Override
  public int getMinNodeCpus() {
    return minNodeCpus_;
  }

  public static final int NODE_AFFINITIES_FIELD_NUMBER = 461799971;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity> nodeAffinities_;
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity>
      getNodeAffinitiesList() {
    return nodeAffinities_;
  }
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>
      getNodeAffinitiesOrBuilderList() {
    return nodeAffinities_;
  }
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  @java.lang.Override
  public int getNodeAffinitiesCount() {
    return nodeAffinities_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SchedulingNodeAffinity getNodeAffinities(int index) {
    return nodeAffinities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder getNodeAffinitiesOrBuilder(
      int index) {
    return nodeAffinities_.get(index);
  }

  public static final int ON_HOST_MAINTENANCE_FIELD_NUMBER = 64616796;

  @SuppressWarnings("serial")
  private volatile java.lang.Object onHostMaintenance_ = "";
  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return Whether the onHostMaintenance field is set.
   */
  @java.lang.Override
  public boolean hasOnHostMaintenance() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return The onHostMaintenance.
   */
  @java.lang.Override
  public java.lang.String getOnHostMaintenance() {
    java.lang.Object ref = onHostMaintenance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      onHostMaintenance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
   * Check the OnHostMaintenance enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_host_maintenance = 64616796;</code>
   *
   * @return The bytes for onHostMaintenance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOnHostMaintenanceBytes() {
    java.lang.Object ref = onHostMaintenance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      onHostMaintenance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREEMPTIBLE_FIELD_NUMBER = 324203169;
  private boolean preemptible_ = false;
  /**
   *
   *
   * <pre>
   * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
   * </pre>
   *
   * <code>optional bool preemptible = 324203169;</code>
   *
   * @return Whether the preemptible field is set.
   */
  @java.lang.Override
  public boolean hasPreemptible() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
   * </pre>
   *
   * <code>optional bool preemptible = 324203169;</code>
   *
   * @return The preemptible.
   */
  @java.lang.Override
  public boolean getPreemptible() {
    return preemptible_;
  }

  public static final int PROVISIONING_MODEL_FIELD_NUMBER = 494423;

  @SuppressWarnings("serial")
  private volatile java.lang.Object provisioningModel_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return Whether the provisioningModel field is set.
   */
  @java.lang.Override
  public boolean hasProvisioningModel() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return The provisioningModel.
   */
  @java.lang.Override
  public java.lang.String getProvisioningModel() {
    java.lang.Object ref = provisioningModel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      provisioningModel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the provisioning model of the instance.
   * Check the ProvisioningModel enum for the list of possible values.
   * </pre>
   *
   * <code>optional string provisioning_model = 494423;</code>
   *
   * @return The bytes for provisioningModel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProvisioningModelBytes() {
    java.lang.Object ref = provisioningModel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      provisioningModel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 494423, provisioningModel_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 64616796, onHostMaintenance_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 107380667, instanceTerminationAction_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(268015590, getLocalSsdRecoveryTimeout());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(317231675, minNodeCpus_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(324203169, preemptible_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 350519505, locationHint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(350821371, automaticRestart_);
    }
    for (int i = 0; i < nodeAffinities_.size(); i++) {
      output.writeMessage(461799971, nodeAffinities_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(494423, provisioningModel_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(64616796, onHostMaintenance_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              107380667, instanceTerminationAction_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              268015590, getLocalSsdRecoveryTimeout());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(317231675, minNodeCpus_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(324203169, preemptible_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(350519505, locationHint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(350821371, automaticRestart_);
    }
    for (int i = 0; i < nodeAffinities_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              461799971, nodeAffinities_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Scheduling)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Scheduling other = (com.google.cloud.compute.v1.Scheduling) obj;

    if (hasAutomaticRestart() != other.hasAutomaticRestart()) return false;
    if (hasAutomaticRestart()) {
      if (getAutomaticRestart() != other.getAutomaticRestart()) return false;
    }
    if (hasInstanceTerminationAction() != other.hasInstanceTerminationAction()) return false;
    if (hasInstanceTerminationAction()) {
      if (!getInstanceTerminationAction().equals(other.getInstanceTerminationAction()))
        return false;
    }
    if (hasLocalSsdRecoveryTimeout() != other.hasLocalSsdRecoveryTimeout()) return false;
    if (hasLocalSsdRecoveryTimeout()) {
      if (!getLocalSsdRecoveryTimeout().equals(other.getLocalSsdRecoveryTimeout())) return false;
    }
    if (hasLocationHint() != other.hasLocationHint()) return false;
    if (hasLocationHint()) {
      if (!getLocationHint().equals(other.getLocationHint())) return false;
    }
    if (hasMinNodeCpus() != other.hasMinNodeCpus()) return false;
    if (hasMinNodeCpus()) {
      if (getMinNodeCpus() != other.getMinNodeCpus()) return false;
    }
    if (!getNodeAffinitiesList().equals(other.getNodeAffinitiesList())) return false;
    if (hasOnHostMaintenance() != other.hasOnHostMaintenance()) return false;
    if (hasOnHostMaintenance()) {
      if (!getOnHostMaintenance().equals(other.getOnHostMaintenance())) return false;
    }
    if (hasPreemptible() != other.hasPreemptible()) return false;
    if (hasPreemptible()) {
      if (getPreemptible() != other.getPreemptible()) return false;
    }
    if (hasProvisioningModel() != other.hasProvisioningModel()) return false;
    if (hasProvisioningModel()) {
      if (!getProvisioningModel().equals(other.getProvisioningModel())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutomaticRestart()) {
      hash = (37 * hash) + AUTOMATIC_RESTART_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutomaticRestart());
    }
    if (hasInstanceTerminationAction()) {
      hash = (37 * hash) + INSTANCE_TERMINATION_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceTerminationAction().hashCode();
    }
    if (hasLocalSsdRecoveryTimeout()) {
      hash = (37 * hash) + LOCAL_SSD_RECOVERY_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getLocalSsdRecoveryTimeout().hashCode();
    }
    if (hasLocationHint()) {
      hash = (37 * hash) + LOCATION_HINT_FIELD_NUMBER;
      hash = (53 * hash) + getLocationHint().hashCode();
    }
    if (hasMinNodeCpus()) {
      hash = (37 * hash) + MIN_NODE_CPUS_FIELD_NUMBER;
      hash = (53 * hash) + getMinNodeCpus();
    }
    if (getNodeAffinitiesCount() > 0) {
      hash = (37 * hash) + NODE_AFFINITIES_FIELD_NUMBER;
      hash = (53 * hash) + getNodeAffinitiesList().hashCode();
    }
    if (hasOnHostMaintenance()) {
      hash = (37 * hash) + ON_HOST_MAINTENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getOnHostMaintenance().hashCode();
    }
    if (hasPreemptible()) {
      hash = (37 * hash) + PREEMPTIBLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreemptible());
    }
    if (hasProvisioningModel()) {
      hash = (37 * hash) + PROVISIONING_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getProvisioningModel().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Scheduling parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Scheduling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Scheduling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Scheduling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Sets the scheduling options for an Instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Scheduling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Scheduling)
      com.google.cloud.compute.v1.SchedulingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Scheduling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Scheduling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Scheduling.class,
              com.google.cloud.compute.v1.Scheduling.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Scheduling.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLocalSsdRecoveryTimeoutFieldBuilder();
        getNodeAffinitiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      automaticRestart_ = false;
      instanceTerminationAction_ = "";
      localSsdRecoveryTimeout_ = null;
      if (localSsdRecoveryTimeoutBuilder_ != null) {
        localSsdRecoveryTimeoutBuilder_.dispose();
        localSsdRecoveryTimeoutBuilder_ = null;
      }
      locationHint_ = "";
      minNodeCpus_ = 0;
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinities_ = java.util.Collections.emptyList();
      } else {
        nodeAffinities_ = null;
        nodeAffinitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      onHostMaintenance_ = "";
      preemptible_ = false;
      provisioningModel_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Scheduling_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Scheduling getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Scheduling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Scheduling build() {
      com.google.cloud.compute.v1.Scheduling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Scheduling buildPartial() {
      com.google.cloud.compute.v1.Scheduling result =
          new com.google.cloud.compute.v1.Scheduling(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Scheduling result) {
      if (nodeAffinitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          nodeAffinities_ = java.util.Collections.unmodifiableList(nodeAffinities_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.nodeAffinities_ = nodeAffinities_;
      } else {
        result.nodeAffinities_ = nodeAffinitiesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Scheduling result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.automaticRestart_ = automaticRestart_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceTerminationAction_ = instanceTerminationAction_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.localSsdRecoveryTimeout_ =
            localSsdRecoveryTimeoutBuilder_ == null
                ? localSsdRecoveryTimeout_
                : localSsdRecoveryTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.locationHint_ = locationHint_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.minNodeCpus_ = minNodeCpus_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.onHostMaintenance_ = onHostMaintenance_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.preemptible_ = preemptible_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.provisioningModel_ = provisioningModel_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Scheduling) {
        return mergeFrom((com.google.cloud.compute.v1.Scheduling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Scheduling other) {
      if (other == com.google.cloud.compute.v1.Scheduling.getDefaultInstance()) return this;
      if (other.hasAutomaticRestart()) {
        setAutomaticRestart(other.getAutomaticRestart());
      }
      if (other.hasInstanceTerminationAction()) {
        instanceTerminationAction_ = other.instanceTerminationAction_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasLocalSsdRecoveryTimeout()) {
        mergeLocalSsdRecoveryTimeout(other.getLocalSsdRecoveryTimeout());
      }
      if (other.hasLocationHint()) {
        locationHint_ = other.locationHint_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMinNodeCpus()) {
        setMinNodeCpus(other.getMinNodeCpus());
      }
      if (nodeAffinitiesBuilder_ == null) {
        if (!other.nodeAffinities_.isEmpty()) {
          if (nodeAffinities_.isEmpty()) {
            nodeAffinities_ = other.nodeAffinities_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureNodeAffinitiesIsMutable();
            nodeAffinities_.addAll(other.nodeAffinities_);
          }
          onChanged();
        }
      } else {
        if (!other.nodeAffinities_.isEmpty()) {
          if (nodeAffinitiesBuilder_.isEmpty()) {
            nodeAffinitiesBuilder_.dispose();
            nodeAffinitiesBuilder_ = null;
            nodeAffinities_ = other.nodeAffinities_;
            bitField0_ = (bitField0_ & ~0x00000020);
            nodeAffinitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodeAffinitiesFieldBuilder()
                    : null;
          } else {
            nodeAffinitiesBuilder_.addAllMessages(other.nodeAffinities_);
          }
        }
      }
      if (other.hasOnHostMaintenance()) {
        onHostMaintenance_ = other.onHostMaintenance_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasPreemptible()) {
        setPreemptible(other.getPreemptible());
      }
      if (other.hasProvisioningModel()) {
        provisioningModel_ = other.provisioningModel_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 3955386:
              {
                provisioningModel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 3955386
            case 516934370:
              {
                onHostMaintenance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 516934370
            case 859045338:
              {
                instanceTerminationAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 859045338
            case 2144124722:
              {
                input.readMessage(
                    getLocalSsdRecoveryTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 2144124722
            case -1757113896:
              {
                minNodeCpus_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -1757113896
            case -1701341944:
              {
                preemptible_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case -1701341944
            case -1490811254:
              {
                locationHint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1490811254
            case -1488396328:
              {
                automaticRestart_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -1488396328
            case -600567526:
              {
                com.google.cloud.compute.v1.SchedulingNodeAffinity m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SchedulingNodeAffinity.parser(),
                        extensionRegistry);
                if (nodeAffinitiesBuilder_ == null) {
                  ensureNodeAffinitiesIsMutable();
                  nodeAffinities_.add(m);
                } else {
                  nodeAffinitiesBuilder_.addMessage(m);
                }
                break;
              } // case -600567526
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean automaticRestart_;
    /**
     *
     *
     * <pre>
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     * </pre>
     *
     * <code>optional bool automatic_restart = 350821371;</code>
     *
     * @return Whether the automaticRestart field is set.
     */
    @java.lang.Override
    public boolean hasAutomaticRestart() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     * </pre>
     *
     * <code>optional bool automatic_restart = 350821371;</code>
     *
     * @return The automaticRestart.
     */
    @java.lang.Override
    public boolean getAutomaticRestart() {
      return automaticRestart_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     * </pre>
     *
     * <code>optional bool automatic_restart = 350821371;</code>
     *
     * @param value The automaticRestart to set.
     * @return This builder for chaining.
     */
    public Builder setAutomaticRestart(boolean value) {

      automaticRestart_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     * </pre>
     *
     * <code>optional bool automatic_restart = 350821371;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutomaticRestart() {
      bitField0_ = (bitField0_ & ~0x00000001);
      automaticRestart_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object instanceTerminationAction_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @return Whether the instanceTerminationAction field is set.
     */
    public boolean hasInstanceTerminationAction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @return The instanceTerminationAction.
     */
    public java.lang.String getInstanceTerminationAction() {
      java.lang.Object ref = instanceTerminationAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceTerminationAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @return The bytes for instanceTerminationAction.
     */
    public com.google.protobuf.ByteString getInstanceTerminationActionBytes() {
      java.lang.Object ref = instanceTerminationAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceTerminationAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @param value The instanceTerminationAction to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTerminationAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceTerminationAction_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceTerminationAction() {
      instanceTerminationAction_ = getDefaultInstance().getInstanceTerminationAction();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instance_termination_action = 107380667;</code>
     *
     * @param value The bytes for instanceTerminationAction to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTerminationActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceTerminationAction_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration localSsdRecoveryTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        localSsdRecoveryTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     *
     * @return Whether the localSsdRecoveryTimeout field is set.
     */
    public boolean hasLocalSsdRecoveryTimeout() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     *
     * @return The localSsdRecoveryTimeout.
     */
    public com.google.cloud.compute.v1.Duration getLocalSsdRecoveryTimeout() {
      if (localSsdRecoveryTimeoutBuilder_ == null) {
        return localSsdRecoveryTimeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : localSsdRecoveryTimeout_;
      } else {
        return localSsdRecoveryTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public Builder setLocalSsdRecoveryTimeout(com.google.cloud.compute.v1.Duration value) {
      if (localSsdRecoveryTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localSsdRecoveryTimeout_ = value;
      } else {
        localSsdRecoveryTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public Builder setLocalSsdRecoveryTimeout(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (localSsdRecoveryTimeoutBuilder_ == null) {
        localSsdRecoveryTimeout_ = builderForValue.build();
      } else {
        localSsdRecoveryTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public Builder mergeLocalSsdRecoveryTimeout(com.google.cloud.compute.v1.Duration value) {
      if (localSsdRecoveryTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && localSsdRecoveryTimeout_ != null
            && localSsdRecoveryTimeout_
                != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getLocalSsdRecoveryTimeoutBuilder().mergeFrom(value);
        } else {
          localSsdRecoveryTimeout_ = value;
        }
      } else {
        localSsdRecoveryTimeoutBuilder_.mergeFrom(value);
      }
      if (localSsdRecoveryTimeout_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public Builder clearLocalSsdRecoveryTimeout() {
      bitField0_ = (bitField0_ & ~0x00000004);
      localSsdRecoveryTimeout_ = null;
      if (localSsdRecoveryTimeoutBuilder_ != null) {
        localSsdRecoveryTimeoutBuilder_.dispose();
        localSsdRecoveryTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getLocalSsdRecoveryTimeoutBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLocalSsdRecoveryTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getLocalSsdRecoveryTimeoutOrBuilder() {
      if (localSsdRecoveryTimeoutBuilder_ != null) {
        return localSsdRecoveryTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return localSsdRecoveryTimeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : localSsdRecoveryTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getLocalSsdRecoveryTimeoutFieldBuilder() {
      if (localSsdRecoveryTimeoutBuilder_ == null) {
        localSsdRecoveryTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getLocalSsdRecoveryTimeout(), getParentForChildren(), isClean());
        localSsdRecoveryTimeout_ = null;
      }
      return localSsdRecoveryTimeoutBuilder_;
    }

    private java.lang.Object locationHint_ = "";
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return Whether the locationHint field is set.
     */
    public boolean hasLocationHint() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The locationHint.
     */
    public java.lang.String getLocationHint() {
      java.lang.Object ref = locationHint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationHint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The bytes for locationHint.
     */
    public com.google.protobuf.ByteString getLocationHintBytes() {
      java.lang.Object ref = locationHint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationHint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationHint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationHint() {
      locationHint_ = getDefaultInstance().getLocationHint();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The bytes for locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationHint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int minNodeCpus_;
    /**
     *
     *
     * <pre>
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     * </pre>
     *
     * <code>optional int32 min_node_cpus = 317231675;</code>
     *
     * @return Whether the minNodeCpus field is set.
     */
    @java.lang.Override
    public boolean hasMinNodeCpus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     * </pre>
     *
     * <code>optional int32 min_node_cpus = 317231675;</code>
     *
     * @return The minNodeCpus.
     */
    @java.lang.Override
    public int getMinNodeCpus() {
      return minNodeCpus_;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     * </pre>
     *
     * <code>optional int32 min_node_cpus = 317231675;</code>
     *
     * @param value The minNodeCpus to set.
     * @return This builder for chaining.
     */
    public Builder setMinNodeCpus(int value) {

      minNodeCpus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     * </pre>
     *
     * <code>optional int32 min_node_cpus = 317231675;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinNodeCpus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      minNodeCpus_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity> nodeAffinities_ =
        java.util.Collections.emptyList();

    private void ensureNodeAffinitiesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        nodeAffinities_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.SchedulingNodeAffinity>(
                nodeAffinities_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SchedulingNodeAffinity,
            com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder,
            com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>
        nodeAffinitiesBuilder_;

    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity>
        getNodeAffinitiesList() {
      if (nodeAffinitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodeAffinities_);
      } else {
        return nodeAffinitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public int getNodeAffinitiesCount() {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.size();
      } else {
        return nodeAffinitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public com.google.cloud.compute.v1.SchedulingNodeAffinity getNodeAffinities(int index) {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.get(index);
      } else {
        return nodeAffinitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder setNodeAffinities(
        int index, com.google.cloud.compute.v1.SchedulingNodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.set(index, value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder setNodeAffinities(
        int index, com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder addNodeAffinities(com.google.cloud.compute.v1.SchedulingNodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder addNodeAffinities(
        int index, com.google.cloud.compute.v1.SchedulingNodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(index, value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder addNodeAffinities(
        com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder addNodeAffinities(
        int index, com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder addAllNodeAffinities(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SchedulingNodeAffinity> values) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodeAffinities_);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder clearNodeAffinities() {
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public Builder removeNodeAffinities(int index) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.remove(index);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder getNodeAffinitiesBuilder(
        int index) {
      return getNodeAffinitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder getNodeAffinitiesOrBuilder(
        int index) {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.get(index);
      } else {
        return nodeAffinitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>
        getNodeAffinitiesOrBuilderList() {
      if (nodeAffinitiesBuilder_ != null) {
        return nodeAffinitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodeAffinities_);
      }
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder addNodeAffinitiesBuilder() {
      return getNodeAffinitiesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SchedulingNodeAffinity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder addNodeAffinitiesBuilder(
        int index) {
      return getNodeAffinitiesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.SchedulingNodeAffinity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder>
        getNodeAffinitiesBuilderList() {
      return getNodeAffinitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SchedulingNodeAffinity,
            com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder,
            com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>
        getNodeAffinitiesFieldBuilder() {
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SchedulingNodeAffinity,
                com.google.cloud.compute.v1.SchedulingNodeAffinity.Builder,
                com.google.cloud.compute.v1.SchedulingNodeAffinityOrBuilder>(
                nodeAffinities_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        nodeAffinities_ = null;
      }
      return nodeAffinitiesBuilder_;
    }

    private java.lang.Object onHostMaintenance_ = "";
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @return Whether the onHostMaintenance field is set.
     */
    public boolean hasOnHostMaintenance() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @return The onHostMaintenance.
     */
    public java.lang.String getOnHostMaintenance() {
      java.lang.Object ref = onHostMaintenance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        onHostMaintenance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @return The bytes for onHostMaintenance.
     */
    public com.google.protobuf.ByteString getOnHostMaintenanceBytes() {
      java.lang.Object ref = onHostMaintenance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        onHostMaintenance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @param value The onHostMaintenance to set.
     * @return This builder for chaining.
     */
    public Builder setOnHostMaintenance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      onHostMaintenance_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnHostMaintenance() {
      onHostMaintenance_ = getDefaultInstance().getOnHostMaintenance();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_host_maintenance = 64616796;</code>
     *
     * @param value The bytes for onHostMaintenance to set.
     * @return This builder for chaining.
     */
    public Builder setOnHostMaintenanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      onHostMaintenance_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean preemptible_;
    /**
     *
     *
     * <pre>
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     * </pre>
     *
     * <code>optional bool preemptible = 324203169;</code>
     *
     * @return Whether the preemptible field is set.
     */
    @java.lang.Override
    public boolean hasPreemptible() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     * </pre>
     *
     * <code>optional bool preemptible = 324203169;</code>
     *
     * @return The preemptible.
     */
    @java.lang.Override
    public boolean getPreemptible() {
      return preemptible_;
    }
    /**
     *
     *
     * <pre>
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     * </pre>
     *
     * <code>optional bool preemptible = 324203169;</code>
     *
     * @param value The preemptible to set.
     * @return This builder for chaining.
     */
    public Builder setPreemptible(boolean value) {

      preemptible_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     * </pre>
     *
     * <code>optional bool preemptible = 324203169;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreemptible() {
      bitField0_ = (bitField0_ & ~0x00000080);
      preemptible_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object provisioningModel_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @return Whether the provisioningModel field is set.
     */
    public boolean hasProvisioningModel() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @return The provisioningModel.
     */
    public java.lang.String getProvisioningModel() {
      java.lang.Object ref = provisioningModel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        provisioningModel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @return The bytes for provisioningModel.
     */
    public com.google.protobuf.ByteString getProvisioningModelBytes() {
      java.lang.Object ref = provisioningModel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        provisioningModel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @param value The provisioningModel to set.
     * @return This builder for chaining.
     */
    public Builder setProvisioningModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      provisioningModel_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvisioningModel() {
      provisioningModel_ = getDefaultInstance().getProvisioningModel();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     * </pre>
     *
     * <code>optional string provisioning_model = 494423;</code>
     *
     * @param value The bytes for provisioningModel to set.
     * @return This builder for chaining.
     */
    public Builder setProvisioningModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      provisioningModel_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Scheduling)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Scheduling)
  private static final com.google.cloud.compute.v1.Scheduling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Scheduling();
  }

  public static com.google.cloud.compute.v1.Scheduling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Scheduling> PARSER =
      new com.google.protobuf.AbstractParser<Scheduling>() {
        @java.lang.Override
        public Scheduling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Scheduling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Scheduling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Scheduling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
