/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Google Cloud Armor security policy resource. Only external backend services that use load balancers can reference a security policy. For more information, see Google Cloud Armor security policy overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SecurityPolicy}
 */
public final class SecurityPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicy)
    SecurityPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPolicy.newBuilder() to construct.
  private SecurityPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicy() {
    creationTimestamp_ = "";
    description_ = "";
    fingerprint_ = "";
    kind_ = "";
    labelFingerprint_ = "";
    name_ = "";
    region_ = "";
    rules_ = java.util.Collections.emptyList();
    selfLink_ = "";
    type_ = "";
    userDefinedFields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SecurityPolicy.class,
            com.google.cloud.compute.v1.SecurityPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SecurityPolicy.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /** <code>CLOUD_ARMOR = 260640373;</code> */
    CLOUD_ARMOR(260640373),
    /** <code>CLOUD_ARMOR_EDGE = 250728775;</code> */
    CLOUD_ARMOR_EDGE(250728775),
    /** <code>CLOUD_ARMOR_NETWORK = 488527428;</code> */
    CLOUD_ARMOR_NETWORK(488527428),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /** <code>CLOUD_ARMOR = 260640373;</code> */
    public static final int CLOUD_ARMOR_VALUE = 260640373;
    /** <code>CLOUD_ARMOR_EDGE = 250728775;</code> */
    public static final int CLOUD_ARMOR_EDGE_VALUE = 250728775;
    /** <code>CLOUD_ARMOR_NETWORK = 488527428;</code> */
    public static final int CLOUD_ARMOR_NETWORK_VALUE = 488527428;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 260640373:
          return CLOUD_ARMOR;
        case 250728775:
          return CLOUD_ARMOR_EDGE;
        case 488527428:
          return CLOUD_ARMOR_NETWORK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SecurityPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SecurityPolicy.Type)
  }

  private int bitField0_;
  public static final int ADAPTIVE_PROTECTION_CONFIG_FIELD_NUMBER = 150240735;
  private com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
      adaptiveProtectionConfig_;
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
   * </code>
   *
   * @return Whether the adaptiveProtectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasAdaptiveProtectionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
   * </code>
   *
   * @return The adaptiveProtectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
      getAdaptiveProtectionConfig() {
    return adaptiveProtectionConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.getDefaultInstance()
        : adaptiveProtectionConfig_;
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigOrBuilder
      getAdaptiveProtectionConfigOrBuilder() {
    return adaptiveProtectionConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.getDefaultInstance()
        : adaptiveProtectionConfig_;
  }

  public static final int ADVANCED_OPTIONS_CONFIG_FIELD_NUMBER = 449276352;
  private com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advancedOptionsConfig_;
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
   * </code>
   *
   * @return Whether the advancedOptionsConfig field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedOptionsConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
   * </code>
   *
   * @return The advancedOptionsConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig
      getAdvancedOptionsConfig() {
    return advancedOptionsConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.getDefaultInstance()
        : advancedOptionsConfig_;
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfigOrBuilder
      getAdvancedOptionsConfigOrBuilder() {
    return advancedOptionsConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.getDefaultInstance()
        : advancedOptionsConfig_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DDOS_PROTECTION_CONFIG_FIELD_NUMBER = 50315853;
  private com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddosProtectionConfig_;
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
   * </code>
   *
   * @return Whether the ddosProtectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasDdosProtectionConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
   * </code>
   *
   * @return The ddosProtectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig getDdosProtectionConfig() {
    return ddosProtectionConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.getDefaultInstance()
        : ddosProtectionConfig_;
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfigOrBuilder
      getDdosProtectionConfigOrBuilder() {
    return ddosProtectionConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.getDefaultInstance()
        : ddosProtectionConfig_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_SecurityPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECAPTCHA_OPTIONS_CONFIG_FIELD_NUMBER = 519006811;
  private com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptchaOptionsConfig_;
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
   * </code>
   *
   * @return Whether the recaptchaOptionsConfig field is set.
   */
  @java.lang.Override
  public boolean hasRecaptchaOptionsConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
   * </code>
   *
   * @return The recaptchaOptionsConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig
      getRecaptchaOptionsConfig() {
    return recaptchaOptionsConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.getDefaultInstance()
        : recaptchaOptionsConfig_;
  }
  /**
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfigOrBuilder
      getRecaptchaOptionsConfigOrBuilder() {
    return recaptchaOptionsConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.getDefaultInstance()
        : recaptchaOptionsConfig_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULES_FIELD_NUMBER = 108873975;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule> rules_;
  /**
   *
   *
   * <pre>
   * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_DEFINED_FIELDS_FIELD_NUMBER = 28312739;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>
      userDefinedFields_;
  /**
   *
   *
   * <pre>
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>
      getUserDefinedFieldsList() {
    return userDefinedFields_;
  }
  /**
   *
   *
   * <pre>
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder>
      getUserDefinedFieldsOrBuilderList() {
    return userDefinedFields_;
  }
  /**
   *
   *
   * <pre>
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public int getUserDefinedFieldsCount() {
    return userDefinedFields_.size();
  }
  /**
   *
   *
   * <pre>
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyUserDefinedField getUserDefinedFields(
      int index) {
    return userDefinedFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder
      getUserDefinedFieldsOrBuilder(int index) {
    return userDefinedFields_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    for (int i = 0; i < userDefinedFields_.size(); i++) {
      output.writeMessage(28312739, userDefinedFields_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(50315853, getDdosProtectionConfig());
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(108873975, rules_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(150240735, getAdaptiveProtectionConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(449276352, getAdvancedOptionsConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(519006811, getRecaptchaOptionsConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    for (int i = 0; i < userDefinedFields_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28312739, userDefinedFields_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              50315853, getDdosProtectionConfig());
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(108873975, rules_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              150240735, getAdaptiveProtectionConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              449276352, getAdvancedOptionsConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              519006811, getRecaptchaOptionsConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SecurityPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicy other =
        (com.google.cloud.compute.v1.SecurityPolicy) obj;

    if (hasAdaptiveProtectionConfig() != other.hasAdaptiveProtectionConfig()) return false;
    if (hasAdaptiveProtectionConfig()) {
      if (!getAdaptiveProtectionConfig().equals(other.getAdaptiveProtectionConfig())) return false;
    }
    if (hasAdvancedOptionsConfig() != other.hasAdvancedOptionsConfig()) return false;
    if (hasAdvancedOptionsConfig()) {
      if (!getAdvancedOptionsConfig().equals(other.getAdvancedOptionsConfig())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDdosProtectionConfig() != other.hasDdosProtectionConfig()) return false;
    if (hasDdosProtectionConfig()) {
      if (!getDdosProtectionConfig().equals(other.getDdosProtectionConfig())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasRecaptchaOptionsConfig() != other.hasRecaptchaOptionsConfig()) return false;
    if (hasRecaptchaOptionsConfig()) {
      if (!getRecaptchaOptionsConfig().equals(other.getRecaptchaOptionsConfig())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUserDefinedFieldsList().equals(other.getUserDefinedFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdaptiveProtectionConfig()) {
      hash = (37 * hash) + ADAPTIVE_PROTECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAdaptiveProtectionConfig().hashCode();
    }
    if (hasAdvancedOptionsConfig()) {
      hash = (37 * hash) + ADVANCED_OPTIONS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedOptionsConfig().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDdosProtectionConfig()) {
      hash = (37 * hash) + DDOS_PROTECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDdosProtectionConfig().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasRecaptchaOptionsConfig()) {
      hash = (37 * hash) + RECAPTCHA_OPTIONS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRecaptchaOptionsConfig().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    if (getUserDefinedFieldsCount() > 0) {
      hash = (37 * hash) + USER_DEFINED_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getUserDefinedFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SecurityPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Google Cloud Armor security policy resource. Only external backend services that use load balancers can reference a security policy. For more information, see Google Cloud Armor security policy overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SecurityPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicy)
      com.google.cloud.compute.v1.SecurityPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SecurityPolicy.class,
              com.google.cloud.compute.v1.SecurityPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SecurityPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdaptiveProtectionConfigFieldBuilder();
        getAdvancedOptionsConfigFieldBuilder();
        getDdosProtectionConfigFieldBuilder();
        getRecaptchaOptionsConfigFieldBuilder();
        getRulesFieldBuilder();
        getUserDefinedFieldsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      adaptiveProtectionConfig_ = null;
      if (adaptiveProtectionConfigBuilder_ != null) {
        adaptiveProtectionConfigBuilder_.dispose();
        adaptiveProtectionConfigBuilder_ = null;
      }
      advancedOptionsConfig_ = null;
      if (advancedOptionsConfigBuilder_ != null) {
        advancedOptionsConfigBuilder_.dispose();
        advancedOptionsConfigBuilder_ = null;
      }
      creationTimestamp_ = "";
      ddosProtectionConfig_ = null;
      if (ddosProtectionConfigBuilder_ != null) {
        ddosProtectionConfigBuilder_.dispose();
        ddosProtectionConfigBuilder_ = null;
      }
      description_ = "";
      fingerprint_ = "";
      id_ = 0L;
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      name_ = "";
      recaptchaOptionsConfig_ = null;
      if (recaptchaOptionsConfigBuilder_ != null) {
        recaptchaOptionsConfigBuilder_.dispose();
        recaptchaOptionsConfigBuilder_ = null;
      }
      region_ = "";
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      selfLink_ = "";
      type_ = "";
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFields_ = java.util.Collections.emptyList();
      } else {
        userDefinedFields_ = null;
        userDefinedFieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SecurityPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicy build() {
      com.google.cloud.compute.v1.SecurityPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicy buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicy result =
          new com.google.cloud.compute.v1.SecurityPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.SecurityPolicy result) {
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      if (userDefinedFieldsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          userDefinedFields_ = java.util.Collections.unmodifiableList(userDefinedFields_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.userDefinedFields_ = userDefinedFields_;
      } else {
        result.userDefinedFields_ = userDefinedFieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.SecurityPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adaptiveProtectionConfig_ =
            adaptiveProtectionConfigBuilder_ == null
                ? adaptiveProtectionConfig_
                : adaptiveProtectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.advancedOptionsConfig_ =
            advancedOptionsConfigBuilder_ == null
                ? advancedOptionsConfig_
                : advancedOptionsConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ddosProtectionConfig_ =
            ddosProtectionConfigBuilder_ == null
                ? ddosProtectionConfig_
                : ddosProtectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.recaptchaOptionsConfig_ =
            recaptchaOptionsConfigBuilder_ == null
                ? recaptchaOptionsConfig_
                : recaptchaOptionsConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00002000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SecurityPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.SecurityPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SecurityPolicy other) {
      if (other == com.google.cloud.compute.v1.SecurityPolicy.getDefaultInstance()) return this;
      if (other.hasAdaptiveProtectionConfig()) {
        mergeAdaptiveProtectionConfig(other.getAdaptiveProtectionConfig());
      }
      if (other.hasAdvancedOptionsConfig()) {
        mergeAdvancedOptionsConfig(other.getAdvancedOptionsConfig());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDdosProtectionConfig()) {
        mergeDdosProtectionConfig(other.getDdosProtectionConfig());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000200;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasRecaptchaOptionsConfig()) {
        mergeRecaptchaOptionsConfig(other.getRecaptchaOptionsConfig());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00002000);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (userDefinedFieldsBuilder_ == null) {
        if (!other.userDefinedFields_.isEmpty()) {
          if (userDefinedFields_.isEmpty()) {
            userDefinedFields_ = other.userDefinedFields_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureUserDefinedFieldsIsMutable();
            userDefinedFields_.addAll(other.userDefinedFields_);
          }
          onChanged();
        }
      } else {
        if (!other.userDefinedFields_.isEmpty()) {
          if (userDefinedFieldsBuilder_.isEmpty()) {
            userDefinedFieldsBuilder_.dispose();
            userDefinedFieldsBuilder_ = null;
            userDefinedFields_ = other.userDefinedFields_;
            bitField0_ = (bitField0_ & ~0x00010000);
            userDefinedFieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUserDefinedFieldsFieldBuilder()
                    : null;
          } else {
            userDefinedFieldsBuilder_.addAllMessages(other.userDefinedFields_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 28604882
            case 226501914:
              {
                com.google.cloud.compute.v1.SecurityPolicyUserDefinedField m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.parser(),
                        extensionRegistry);
                if (userDefinedFieldsBuilder_ == null) {
                  ensureUserDefinedFieldsIsMutable();
                  userDefinedFields_.add(m);
                } else {
                  userDefinedFieldsBuilder_.addMessage(m);
                }
                break;
              } // case 226501914
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 402526826:
              {
                input.readMessage(
                    getDdosProtectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 402526826
            case 870991802:
              {
                com.google.cloud.compute.v1.SecurityPolicyRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.SecurityPolicyRule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 870991802
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1111570338
            case 1201925882:
              {
                input.readMessage(
                    getAdaptiveProtectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 1201925882
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 1424998602
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1877428002
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -911466526
            case -700756478:
              {
                input.readMessage(
                    getAdvancedOptionsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -700756478
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case -293404678
            case -142912806:
              {
                input.readMessage(
                    getRecaptchaOptionsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case -142912806
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
        adaptiveProtectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig,
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigOrBuilder>
        adaptiveProtectionConfigBuilder_;
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     *
     * @return Whether the adaptiveProtectionConfig field is set.
     */
    public boolean hasAdaptiveProtectionConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     *
     * @return The adaptiveProtectionConfig.
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
        getAdaptiveProtectionConfig() {
      if (adaptiveProtectionConfigBuilder_ == null) {
        return adaptiveProtectionConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
                .getDefaultInstance()
            : adaptiveProtectionConfig_;
      } else {
        return adaptiveProtectionConfigBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public Builder setAdaptiveProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig value) {
      if (adaptiveProtectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adaptiveProtectionConfig_ = value;
      } else {
        adaptiveProtectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public Builder setAdaptiveProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.Builder
            builderForValue) {
      if (adaptiveProtectionConfigBuilder_ == null) {
        adaptiveProtectionConfig_ = builderForValue.build();
      } else {
        adaptiveProtectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public Builder mergeAdaptiveProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig value) {
      if (adaptiveProtectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && adaptiveProtectionConfig_ != null
            && adaptiveProtectionConfig_
                != com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
                    .getDefaultInstance()) {
          getAdaptiveProtectionConfigBuilder().mergeFrom(value);
        } else {
          adaptiveProtectionConfig_ = value;
        }
      } else {
        adaptiveProtectionConfigBuilder_.mergeFrom(value);
      }
      if (adaptiveProtectionConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public Builder clearAdaptiveProtectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adaptiveProtectionConfig_ = null;
      if (adaptiveProtectionConfigBuilder_ != null) {
        adaptiveProtectionConfigBuilder_.dispose();
        adaptiveProtectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.Builder
        getAdaptiveProtectionConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAdaptiveProtectionConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigOrBuilder
        getAdaptiveProtectionConfigOrBuilder() {
      if (adaptiveProtectionConfigBuilder_ != null) {
        return adaptiveProtectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return adaptiveProtectionConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig
                .getDefaultInstance()
            : adaptiveProtectionConfig_;
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig adaptive_protection_config = 150240735;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig,
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigOrBuilder>
        getAdaptiveProtectionConfigFieldBuilder() {
      if (adaptiveProtectionConfigBuilder_ == null) {
        adaptiveProtectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig,
                com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigOrBuilder>(
                getAdaptiveProtectionConfig(), getParentForChildren(), isClean());
        adaptiveProtectionConfig_ = null;
      }
      return adaptiveProtectionConfigBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advancedOptionsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig,
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfigOrBuilder>
        advancedOptionsConfigBuilder_;
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     *
     * @return Whether the advancedOptionsConfig field is set.
     */
    public boolean hasAdvancedOptionsConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     *
     * @return The advancedOptionsConfig.
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig
        getAdvancedOptionsConfig() {
      if (advancedOptionsConfigBuilder_ == null) {
        return advancedOptionsConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.getDefaultInstance()
            : advancedOptionsConfig_;
      } else {
        return advancedOptionsConfigBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public Builder setAdvancedOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig value) {
      if (advancedOptionsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedOptionsConfig_ = value;
      } else {
        advancedOptionsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public Builder setAdvancedOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.Builder builderForValue) {
      if (advancedOptionsConfigBuilder_ == null) {
        advancedOptionsConfig_ = builderForValue.build();
      } else {
        advancedOptionsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public Builder mergeAdvancedOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig value) {
      if (advancedOptionsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && advancedOptionsConfig_ != null
            && advancedOptionsConfig_
                != com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig
                    .getDefaultInstance()) {
          getAdvancedOptionsConfigBuilder().mergeFrom(value);
        } else {
          advancedOptionsConfig_ = value;
        }
      } else {
        advancedOptionsConfigBuilder_.mergeFrom(value);
      }
      if (advancedOptionsConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public Builder clearAdvancedOptionsConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      advancedOptionsConfig_ = null;
      if (advancedOptionsConfigBuilder_ != null) {
        advancedOptionsConfigBuilder_.dispose();
        advancedOptionsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.Builder
        getAdvancedOptionsConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAdvancedOptionsConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfigOrBuilder
        getAdvancedOptionsConfigOrBuilder() {
      if (advancedOptionsConfigBuilder_ != null) {
        return advancedOptionsConfigBuilder_.getMessageOrBuilder();
      } else {
        return advancedOptionsConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.getDefaultInstance()
            : advancedOptionsConfig_;
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig advanced_options_config = 449276352;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig,
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfigOrBuilder>
        getAdvancedOptionsConfigFieldBuilder() {
      if (advancedOptionsConfigBuilder_ == null) {
        advancedOptionsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig,
                com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyAdvancedOptionsConfigOrBuilder>(
                getAdvancedOptionsConfig(), getParentForChildren(), isClean());
        advancedOptionsConfig_ = null;
      }
      return advancedOptionsConfigBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddosProtectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig,
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfigOrBuilder>
        ddosProtectionConfigBuilder_;
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     *
     * @return Whether the ddosProtectionConfig field is set.
     */
    public boolean hasDdosProtectionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     *
     * @return The ddosProtectionConfig.
     */
    public com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig
        getDdosProtectionConfig() {
      if (ddosProtectionConfigBuilder_ == null) {
        return ddosProtectionConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.getDefaultInstance()
            : ddosProtectionConfig_;
      } else {
        return ddosProtectionConfigBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public Builder setDdosProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig value) {
      if (ddosProtectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ddosProtectionConfig_ = value;
      } else {
        ddosProtectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public Builder setDdosProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.Builder builderForValue) {
      if (ddosProtectionConfigBuilder_ == null) {
        ddosProtectionConfig_ = builderForValue.build();
      } else {
        ddosProtectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public Builder mergeDdosProtectionConfig(
        com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig value) {
      if (ddosProtectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ddosProtectionConfig_ != null
            && ddosProtectionConfig_
                != com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig
                    .getDefaultInstance()) {
          getDdosProtectionConfigBuilder().mergeFrom(value);
        } else {
          ddosProtectionConfig_ = value;
        }
      } else {
        ddosProtectionConfigBuilder_.mergeFrom(value);
      }
      if (ddosProtectionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public Builder clearDdosProtectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ddosProtectionConfig_ = null;
      if (ddosProtectionConfigBuilder_ != null) {
        ddosProtectionConfigBuilder_.dispose();
        ddosProtectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.Builder
        getDdosProtectionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDdosProtectionConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfigOrBuilder
        getDdosProtectionConfigOrBuilder() {
      if (ddosProtectionConfigBuilder_ != null) {
        return ddosProtectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return ddosProtectionConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.getDefaultInstance()
            : ddosProtectionConfig_;
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig ddos_protection_config = 50315853;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig,
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfigOrBuilder>
        getDdosProtectionConfigFieldBuilder() {
      if (ddosProtectionConfigBuilder_ == null) {
        ddosProtectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig,
                com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyDdosProtectionConfigOrBuilder>(
                getDdosProtectionConfig(), getParentForChildren(), isClean());
        ddosProtectionConfig_ = null;
      }
      return ddosProtectionConfigBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyfor security policies
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this security policy, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the security policy.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000200;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig
        recaptchaOptionsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig,
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfigOrBuilder>
        recaptchaOptionsConfigBuilder_;
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     *
     * @return Whether the recaptchaOptionsConfig field is set.
     */
    public boolean hasRecaptchaOptionsConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     *
     * @return The recaptchaOptionsConfig.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig
        getRecaptchaOptionsConfig() {
      if (recaptchaOptionsConfigBuilder_ == null) {
        return recaptchaOptionsConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.getDefaultInstance()
            : recaptchaOptionsConfig_;
      } else {
        return recaptchaOptionsConfigBuilder_.getMessage();
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public Builder setRecaptchaOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig value) {
      if (recaptchaOptionsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recaptchaOptionsConfig_ = value;
      } else {
        recaptchaOptionsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public Builder setRecaptchaOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.Builder builderForValue) {
      if (recaptchaOptionsConfigBuilder_ == null) {
        recaptchaOptionsConfig_ = builderForValue.build();
      } else {
        recaptchaOptionsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public Builder mergeRecaptchaOptionsConfig(
        com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig value) {
      if (recaptchaOptionsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && recaptchaOptionsConfig_ != null
            && recaptchaOptionsConfig_
                != com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig
                    .getDefaultInstance()) {
          getRecaptchaOptionsConfigBuilder().mergeFrom(value);
        } else {
          recaptchaOptionsConfig_ = value;
        }
      } else {
        recaptchaOptionsConfigBuilder_.mergeFrom(value);
      }
      if (recaptchaOptionsConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public Builder clearRecaptchaOptionsConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      recaptchaOptionsConfig_ = null;
      if (recaptchaOptionsConfigBuilder_ != null) {
        recaptchaOptionsConfigBuilder_.dispose();
        recaptchaOptionsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.Builder
        getRecaptchaOptionsConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRecaptchaOptionsConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfigOrBuilder
        getRecaptchaOptionsConfigOrBuilder() {
      if (recaptchaOptionsConfigBuilder_ != null) {
        return recaptchaOptionsConfigBuilder_.getMessageOrBuilder();
      } else {
        return recaptchaOptionsConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.getDefaultInstance()
            : recaptchaOptionsConfig_;
      }
    }
    /**
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig recaptcha_options_config = 519006811;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig,
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfigOrBuilder>
        getRecaptchaOptionsConfigFieldBuilder() {
      if (recaptchaOptionsConfigBuilder_ == null) {
        recaptchaOptionsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig,
                com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRecaptchaOptionsConfigOrBuilder>(
                getRecaptchaOptionsConfig(), getParentForChildren(), isClean());
        recaptchaOptionsConfig_ = null;
      }
      return recaptchaOptionsConfigBuilder_;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional security policy resides. This field is not applicable to global security policies.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        rules_ = new java.util.ArrayList<com.google.cloud.compute.v1.SecurityPolicyRule>(rules_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRule,
            com.google.cloud.compute.v1.SecurityPolicyRule.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder setRules(int index, com.google.cloud.compute.v1.SecurityPolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder setRules(
        int index, com.google.cloud.compute.v1.SecurityPolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder addRules(com.google.cloud.compute.v1.SecurityPolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder addRules(int index, com.google.cloud.compute.v1.SecurityPolicyRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder addRules(
        com.google.cloud.compute.v1.SecurityPolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder addRules(
        int index, com.google.cloud.compute.v1.SecurityPolicyRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SecurityPolicyRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.SecurityPolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.SecurityPolicyRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of rules that belong to this policy. There must always be a default rule which is a rule with priority 2147483647 and match all condition (for the match condition this means match "*" for srcIpRanges and for the networkMatch condition every field must be either match "*" or not set). If no rules are provided when creating a security policy, a default rule with action "allow" will be added.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.SecurityPolicyRule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.SecurityPolicyRule.Builder>
        getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRule,
            com.google.cloud.compute.v1.SecurityPolicyRule.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRule,
                com.google.cloud.compute.v1.SecurityPolicyRule.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>
        userDefinedFields_ = java.util.Collections.emptyList();

    private void ensureUserDefinedFieldsIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        userDefinedFields_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>(
                userDefinedFields_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedField,
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder,
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder>
        userDefinedFieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>
        getUserDefinedFieldsList() {
      if (userDefinedFieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(userDefinedFields_);
      } else {
        return userDefinedFieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public int getUserDefinedFieldsCount() {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.size();
      } else {
        return userDefinedFieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyUserDefinedField getUserDefinedFields(
        int index) {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.get(index);
      } else {
        return userDefinedFieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder setUserDefinedFields(
        int index, com.google.cloud.compute.v1.SecurityPolicyUserDefinedField value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.set(index, value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder setUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.set(index, builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        com.google.cloud.compute.v1.SecurityPolicyUserDefinedField value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        int index, com.google.cloud.compute.v1.SecurityPolicyUserDefinedField value) {
      if (userDefinedFieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(index, value);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder addUserDefinedFields(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder builderForValue) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.add(index, builderForValue.build());
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder addAllUserDefinedFields(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.SecurityPolicyUserDefinedField>
            values) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, userDefinedFields_);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder clearUserDefinedFields() {
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public Builder removeUserDefinedFields(int index) {
      if (userDefinedFieldsBuilder_ == null) {
        ensureUserDefinedFieldsIsMutable();
        userDefinedFields_.remove(index);
        onChanged();
      } else {
        userDefinedFieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder
        getUserDefinedFieldsBuilder(int index) {
      return getUserDefinedFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder
        getUserDefinedFieldsOrBuilder(int index) {
      if (userDefinedFieldsBuilder_ == null) {
        return userDefinedFields_.get(index);
      } else {
        return userDefinedFieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder>
        getUserDefinedFieldsOrBuilderList() {
      if (userDefinedFieldsBuilder_ != null) {
        return userDefinedFieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(userDefinedFields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder
        addUserDefinedFieldsBuilder() {
      return getUserDefinedFieldsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder
        addUserDefinedFieldsBuilder(int index) {
      return getUserDefinedFieldsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A user-defined field consists of up to 4 bytes extracted from a fixed offset in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an optional mask to select certain bits. Rules may then specify matching values for these fields. Example: userDefinedFields: - name: "ipv4_fragment_offset" base: IPV4 offset: 6 size: 2 mask: "0x1fff"
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyUserDefinedField user_defined_fields = 28312739;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder>
        getUserDefinedFieldsBuilderList() {
      return getUserDefinedFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedField,
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder,
            com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder>
        getUserDefinedFieldsFieldBuilder() {
      if (userDefinedFieldsBuilder_ == null) {
        userDefinedFieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyUserDefinedField,
                com.google.cloud.compute.v1.SecurityPolicyUserDefinedField.Builder,
                com.google.cloud.compute.v1.SecurityPolicyUserDefinedFieldOrBuilder>(
                userDefinedFields_,
                ((bitField0_ & 0x00010000) != 0),
                getParentForChildren(),
                isClean());
        userDefinedFields_ = null;
      }
      return userDefinedFieldsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicy)
  private static final com.google.cloud.compute.v1.SecurityPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SecurityPolicy();
  }

  public static com.google.cloud.compute.v1.SecurityPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPolicy> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPolicy>() {
        @java.lang.Override
        public SecurityPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
