/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Configuration options for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig}
 */
public final class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.newBuilder() to construct.
  private SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig() {
    ruleVisibility_ = "";
    thresholdConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.class,
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.RuleVisibility}
   */
  public enum RuleVisibility implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_RULE_VISIBILITY = 0;</code>
     */
    UNDEFINED_RULE_VISIBILITY(0),
    /** <code>PREMIUM = 399530551;</code> */
    PREMIUM(399530551),
    /** <code>STANDARD = 484642493;</code> */
    STANDARD(484642493),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_RULE_VISIBILITY = 0;</code>
     */
    public static final int UNDEFINED_RULE_VISIBILITY_VALUE = 0;
    /** <code>PREMIUM = 399530551;</code> */
    public static final int PREMIUM_VALUE = 399530551;
    /** <code>STANDARD = 484642493;</code> */
    public static final int STANDARD_VALUE = 484642493;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RuleVisibility valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RuleVisibility forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_RULE_VISIBILITY;
        case 399530551:
          return PREMIUM;
        case 484642493:
          return STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RuleVisibility> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RuleVisibility> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RuleVisibility>() {
          public RuleVisibility findValueByNumber(int number) {
            return RuleVisibility.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RuleVisibility[] VALUES = values();

    public static RuleVisibility valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RuleVisibility(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.RuleVisibility)
  }

  private int bitField0_;
  public static final int ENABLE_FIELD_NUMBER = 311764355;
  private boolean enable_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>optional bool enable = 311764355;</code>
   *
   * @return Whether the enable field is set.
   */
  @java.lang.Override
  public boolean hasEnable() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>optional bool enable = 311764355;</code>
   *
   * @return The enable.
   */
  @java.lang.Override
  public boolean getEnable() {
    return enable_;
  }

  public static final int RULE_VISIBILITY_FIELD_NUMBER = 453258293;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ruleVisibility_ = "";
  /**
   *
   *
   * <pre>
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * Check the RuleVisibility enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rule_visibility = 453258293;</code>
   *
   * @return Whether the ruleVisibility field is set.
   */
  @java.lang.Override
  public boolean hasRuleVisibility() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * Check the RuleVisibility enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rule_visibility = 453258293;</code>
   *
   * @return The ruleVisibility.
   */
  @java.lang.Override
  public java.lang.String getRuleVisibility() {
    java.lang.Object ref = ruleVisibility_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ruleVisibility_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * Check the RuleVisibility enum for the list of possible values.
   * </pre>
   *
   * <code>optional string rule_visibility = 453258293;</code>
   *
   * @return The bytes for ruleVisibility.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuleVisibilityBytes() {
    java.lang.Object ref = ruleVisibility_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ruleVisibility_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int THRESHOLD_CONFIGS_FIELD_NUMBER = 60347805;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1
              .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
      thresholdConfigs_;
  /**
   *
   *
   * <pre>
   * Configuration options for layer7 adaptive protection for various customizable thresholds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1
              .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
      getThresholdConfigsList() {
    return thresholdConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for layer7 adaptive protection for various customizable thresholds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder>
      getThresholdConfigsOrBuilderList() {
    return thresholdConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for layer7 adaptive protection for various customizable thresholds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
   * </code>
   */
  @java.lang.Override
  public int getThresholdConfigsCount() {
    return thresholdConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Configuration options for layer7 adaptive protection for various customizable thresholds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
      getThresholdConfigs(int index) {
    return thresholdConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Configuration options for layer7 adaptive protection for various customizable thresholds.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder
      getThresholdConfigsOrBuilder(int index) {
    return thresholdConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < thresholdConfigs_.size(); i++) {
      output.writeMessage(60347805, thresholdConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(311764355, enable_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 453258293, ruleVisibility_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < thresholdConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              60347805, thresholdConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(311764355, enable_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(453258293, ruleVisibility_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
        other =
            (com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
                obj;

    if (hasEnable() != other.hasEnable()) return false;
    if (hasEnable()) {
      if (getEnable() != other.getEnable()) return false;
    }
    if (hasRuleVisibility() != other.hasRuleVisibility()) return false;
    if (hasRuleVisibility()) {
      if (!getRuleVisibility().equals(other.getRuleVisibility())) return false;
    }
    if (!getThresholdConfigsList().equals(other.getThresholdConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEnable()) {
      hash = (37 * hash) + ENABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnable());
    }
    if (hasRuleVisibility()) {
      hash = (37 * hash) + RULE_VISIBILITY_FIELD_NUMBER;
      hash = (53 * hash) + getRuleVisibility().hashCode();
    }
    if (getThresholdConfigsCount() > 0) {
      hash = (37 * hash) + THRESHOLD_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getThresholdConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
      com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.class,
              com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enable_ = false;
      ruleVisibility_ = "";
      if (thresholdConfigsBuilder_ == null) {
        thresholdConfigs_ = java.util.Collections.emptyList();
      } else {
        thresholdConfigs_ = null;
        thresholdConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
        build() {
      com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
        buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
          result =
              new com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
            result) {
      if (thresholdConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          thresholdConfigs_ = java.util.Collections.unmodifiableList(thresholdConfigs_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.thresholdConfigs_ = thresholdConfigs_;
      } else {
        result.thresholdConfigs_ = thresholdConfigsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enable_ = enable_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ruleVisibility_ = ruleVisibility_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1
              .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig) {
        return mergeFrom(
            (com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
            other) {
      if (other
          == com.google.cloud.compute.v1
              .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig.getDefaultInstance())
        return this;
      if (other.hasEnable()) {
        setEnable(other.getEnable());
      }
      if (other.hasRuleVisibility()) {
        ruleVisibility_ = other.ruleVisibility_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (thresholdConfigsBuilder_ == null) {
        if (!other.thresholdConfigs_.isEmpty()) {
          if (thresholdConfigs_.isEmpty()) {
            thresholdConfigs_ = other.thresholdConfigs_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureThresholdConfigsIsMutable();
            thresholdConfigs_.addAll(other.thresholdConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.thresholdConfigs_.isEmpty()) {
          if (thresholdConfigsBuilder_.isEmpty()) {
            thresholdConfigsBuilder_.dispose();
            thresholdConfigsBuilder_ = null;
            thresholdConfigs_ = other.thresholdConfigs_;
            bitField0_ = (bitField0_ & ~0x00000004);
            thresholdConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getThresholdConfigsFieldBuilder()
                    : null;
          } else {
            thresholdConfigsBuilder_.addAllMessages(other.thresholdConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 482782442:
              {
                com.google.cloud.compute.v1
                        .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                                .parser(),
                            extensionRegistry);
                if (thresholdConfigsBuilder_ == null) {
                  ensureThresholdConfigsIsMutable();
                  thresholdConfigs_.add(m);
                } else {
                  thresholdConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 482782442
            case -1800852456:
              {
                enable_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -1800852456
            case -668900950:
              {
                ruleVisibility_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -668900950
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enable_;
    /**
     *
     *
     * <pre>
     * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return Whether the enable field is set.
     */
    @java.lang.Override
    public boolean hasEnable() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return The enable.
     */
    @java.lang.Override
    public boolean getEnable() {
      return enable_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @param value The enable to set.
     * @return This builder for chaining.
     */
    public Builder setEnable(boolean value) {

      enable_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, enables CAAP for L7 DDoS detection. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnable() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enable_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object ruleVisibility_ = "";
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @return Whether the ruleVisibility field is set.
     */
    public boolean hasRuleVisibility() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @return The ruleVisibility.
     */
    public java.lang.String getRuleVisibility() {
      java.lang.Object ref = ruleVisibility_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ruleVisibility_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @return The bytes for ruleVisibility.
     */
    public com.google.protobuf.ByteString getRuleVisibilityBytes() {
      java.lang.Object ref = ruleVisibility_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ruleVisibility_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @param value The ruleVisibility to set.
     * @return This builder for chaining.
     */
    public Builder setRuleVisibility(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ruleVisibility_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleVisibility() {
      ruleVisibility_ = getDefaultInstance().getRuleVisibility();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * Check the RuleVisibility enum for the list of possible values.
     * </pre>
     *
     * <code>optional string rule_visibility = 453258293;</code>
     *
     * @param value The bytes for ruleVisibility to set.
     * @return This builder for chaining.
     */
    public Builder setRuleVisibilityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ruleVisibility_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
        thresholdConfigs_ = java.util.Collections.emptyList();

    private void ensureThresholdConfigsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        thresholdConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>(
                thresholdConfigs_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig,
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder>
        thresholdConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
        getThresholdConfigsList() {
      if (thresholdConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(thresholdConfigs_);
      } else {
        return thresholdConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public int getThresholdConfigsCount() {
      if (thresholdConfigsBuilder_ == null) {
        return thresholdConfigs_.size();
      } else {
        return thresholdConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
        getThresholdConfigs(int index) {
      if (thresholdConfigsBuilder_ == null) {
        return thresholdConfigs_.get(index);
      } else {
        return thresholdConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder setThresholdConfigs(
        int index,
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
            value) {
      if (thresholdConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.set(index, value);
        onChanged();
      } else {
        thresholdConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder setThresholdConfigs(
        int index,
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder
            builderForValue) {
      if (thresholdConfigsBuilder_ == null) {
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        thresholdConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder addThresholdConfigs(
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
            value) {
      if (thresholdConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.add(value);
        onChanged();
      } else {
        thresholdConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder addThresholdConfigs(
        int index,
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
            value) {
      if (thresholdConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.add(index, value);
        onChanged();
      } else {
        thresholdConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder addThresholdConfigs(
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder
            builderForValue) {
      if (thresholdConfigsBuilder_ == null) {
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        thresholdConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder addThresholdConfigs(
        int index,
        com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder
            builderForValue) {
      if (thresholdConfigsBuilder_ == null) {
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        thresholdConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder addAllThresholdConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
            values) {
      if (thresholdConfigsBuilder_ == null) {
        ensureThresholdConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, thresholdConfigs_);
        onChanged();
      } else {
        thresholdConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder clearThresholdConfigs() {
      if (thresholdConfigsBuilder_ == null) {
        thresholdConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        thresholdConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public Builder removeThresholdConfigs(int index) {
      if (thresholdConfigsBuilder_ == null) {
        ensureThresholdConfigsIsMutable();
        thresholdConfigs_.remove(index);
        onChanged();
      } else {
        thresholdConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig.Builder
        getThresholdConfigsBuilder(int index) {
      return getThresholdConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder
        getThresholdConfigsOrBuilder(int index) {
      if (thresholdConfigsBuilder_ == null) {
        return thresholdConfigs_.get(index);
      } else {
        return thresholdConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder>
        getThresholdConfigsOrBuilderList() {
      if (thresholdConfigsBuilder_ != null) {
        return thresholdConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(thresholdConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig.Builder
        addThresholdConfigsBuilder() {
      return getThresholdConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig.Builder
        addThresholdConfigsBuilder(int index) {
      return getThresholdConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1
                  .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration options for layer7 adaptive protection for various customizable thresholds.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig threshold_configs = 60347805;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder>
        getThresholdConfigsBuilderList() {
      return getThresholdConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig,
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder>
        getThresholdConfigsFieldBuilder() {
      if (thresholdConfigsBuilder_ == null) {
        thresholdConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig,
                com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
                    .Builder,
                com.google.cloud.compute.v1
                    .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigOrBuilder>(
                thresholdConfigs_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        thresholdConfigs_ = null;
      }
      return thresholdConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig)
  private static final com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig();
  }

  public static com.google.cloud.compute.v1
          .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig>() {
            @java.lang.Override
            public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
