/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleMatcher}
 */
public final class SecurityPolicyRuleMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicyRuleMatcher)
    SecurityPolicyRuleMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPolicyRuleMatcher.newBuilder() to construct.
  private SecurityPolicyRuleMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicyRuleMatcher() {
    versionedExpr_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicyRuleMatcher();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.class,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SecurityPolicyRuleMatcher.VersionedExpr}
   */
  public enum VersionedExpr implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VERSIONED_EXPR = 0;</code>
     */
    UNDEFINED_VERSIONED_EXPR(0),
    /**
     *
     *
     * <pre>
     * Matches the source IP address of a request to the IP ranges supplied in config.
     * </pre>
     *
     * <code>SRC_IPS_V1 = 70925961;</code>
     */
    SRC_IPS_V1(70925961),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VERSIONED_EXPR = 0;</code>
     */
    public static final int UNDEFINED_VERSIONED_EXPR_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Matches the source IP address of a request to the IP ranges supplied in config.
     * </pre>
     *
     * <code>SRC_IPS_V1 = 70925961;</code>
     */
    public static final int SRC_IPS_V1_VALUE = 70925961;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VersionedExpr valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VersionedExpr forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_VERSIONED_EXPR;
        case 70925961:
          return SRC_IPS_V1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VersionedExpr> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VersionedExpr> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VersionedExpr>() {
          public VersionedExpr findValueByNumber(int number) {
            return VersionedExpr.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final VersionedExpr[] VALUES = values();

    public static VersionedExpr valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VersionedExpr(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SecurityPolicyRuleMatcher.VersionedExpr)
  }

  private int bitField0_;
  public static final int CONFIG_FIELD_NUMBER = 255820610;
  private com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config_;
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig getConfig() {
    return config_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.getDefaultInstance()
        : config_;
  }

  public static final int EXPR_FIELD_NUMBER = 3127797;
  private com.google.cloud.compute.v1.Expr expr_;
  /**
   *
   *
   * <pre>
   * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
   *
   * @return Whether the expr field is set.
   */
  @java.lang.Override
  public boolean hasExpr() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
   *
   * @return The expr.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Expr getExpr() {
    return expr_ == null ? com.google.cloud.compute.v1.Expr.getDefaultInstance() : expr_;
  }
  /**
   *
   *
   * <pre>
   * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ExprOrBuilder getExprOrBuilder() {
    return expr_ == null ? com.google.cloud.compute.v1.Expr.getDefaultInstance() : expr_;
  }

  public static final int EXPR_OPTIONS_FIELD_NUMBER = 486220372;
  private com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions exprOptions_;
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
   * </code>
   *
   * @return Whether the exprOptions field is set.
   */
  @java.lang.Override
  public boolean hasExprOptions() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
   * </code>
   *
   * @return The exprOptions.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions getExprOptions() {
    return exprOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.getDefaultInstance()
        : exprOptions_;
  }
  /**
   *
   *
   * <pre>
   * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptionsOrBuilder
      getExprOptionsOrBuilder() {
    return exprOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.getDefaultInstance()
        : exprOptions_;
  }

  public static final int VERSIONED_EXPR_FIELD_NUMBER = 322286013;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionedExpr_ = "";
  /**
   *
   *
   * <pre>
   * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
   * Check the VersionedExpr enum for the list of possible values.
   * </pre>
   *
   * <code>optional string versioned_expr = 322286013;</code>
   *
   * @return Whether the versionedExpr field is set.
   */
  @java.lang.Override
  public boolean hasVersionedExpr() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
   * Check the VersionedExpr enum for the list of possible values.
   * </pre>
   *
   * <code>optional string versioned_expr = 322286013;</code>
   *
   * @return The versionedExpr.
   */
  @java.lang.Override
  public java.lang.String getVersionedExpr() {
    java.lang.Object ref = versionedExpr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionedExpr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
   * Check the VersionedExpr enum for the list of possible values.
   * </pre>
   *
   * <code>optional string versioned_expr = 322286013;</code>
   *
   * @return The bytes for versionedExpr.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionedExprBytes() {
    java.lang.Object ref = versionedExpr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionedExpr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3127797, getExpr());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(255820610, getConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 322286013, versionedExpr_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(486220372, getExprOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3127797, getExpr());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(255820610, getConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(322286013, versionedExpr_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(486220372, getExprOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SecurityPolicyRuleMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicyRuleMatcher other =
        (com.google.cloud.compute.v1.SecurityPolicyRuleMatcher) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasExpr() != other.hasExpr()) return false;
    if (hasExpr()) {
      if (!getExpr().equals(other.getExpr())) return false;
    }
    if (hasExprOptions() != other.hasExprOptions()) return false;
    if (hasExprOptions()) {
      if (!getExprOptions().equals(other.getExprOptions())) return false;
    }
    if (hasVersionedExpr() != other.hasVersionedExpr()) return false;
    if (hasVersionedExpr()) {
      if (!getVersionedExpr().equals(other.getVersionedExpr())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasExpr()) {
      hash = (37 * hash) + EXPR_FIELD_NUMBER;
      hash = (53 * hash) + getExpr().hashCode();
    }
    if (hasExprOptions()) {
      hash = (37 * hash) + EXPR_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExprOptions().hashCode();
    }
    if (hasVersionedExpr()) {
      hash = (37 * hash) + VERSIONED_EXPR_FIELD_NUMBER;
      hash = (53 * hash) + getVersionedExpr().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SecurityPolicyRuleMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicyRuleMatcher)
      com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.class,
              com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getExprFieldBuilder();
        getExprOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      expr_ = null;
      if (exprBuilder_ != null) {
        exprBuilder_.dispose();
        exprBuilder_ = null;
      }
      exprOptions_ = null;
      if (exprOptionsBuilder_ != null) {
        exprOptionsBuilder_.dispose();
        exprOptionsBuilder_ = null;
      }
      versionedExpr_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher build() {
      com.google.cloud.compute.v1.SecurityPolicyRuleMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicyRuleMatcher result =
          new com.google.cloud.compute.v1.SecurityPolicyRuleMatcher(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.SecurityPolicyRuleMatcher result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.expr_ = exprBuilder_ == null ? expr_ : exprBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.exprOptions_ =
            exprOptionsBuilder_ == null ? exprOptions_ : exprOptionsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.versionedExpr_ = versionedExpr_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SecurityPolicyRuleMatcher) {
        return mergeFrom((com.google.cloud.compute.v1.SecurityPolicyRuleMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SecurityPolicyRuleMatcher other) {
      if (other == com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance())
        return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasExpr()) {
        mergeExpr(other.getExpr());
      }
      if (other.hasExprOptions()) {
        mergeExprOptions(other.getExprOptions());
      }
      if (other.hasVersionedExpr()) {
        versionedExpr_ = other.versionedExpr_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 25022378:
              {
                input.readMessage(getExprFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 25022378
            case 2046564882:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 2046564882
            case -1716679190:
              {
                versionedExpr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1716679190
            case -405204318:
              {
                input.readMessage(getExprOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -405204318
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public Builder setConfig(com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && config_ != null
            && config_
                != com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig
                    .getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfigOrBuilder
        getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying versioned_expr. This field must be specified if versioned_expr is specified and cannot be specified if versioned_expr is not specified.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig config = 255820610;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.cloud.compute.v1.Expr expr_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Expr,
            com.google.cloud.compute.v1.Expr.Builder,
            com.google.cloud.compute.v1.ExprOrBuilder>
        exprBuilder_;
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     *
     * @return Whether the expr field is set.
     */
    public boolean hasExpr() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     *
     * @return The expr.
     */
    public com.google.cloud.compute.v1.Expr getExpr() {
      if (exprBuilder_ == null) {
        return expr_ == null ? com.google.cloud.compute.v1.Expr.getDefaultInstance() : expr_;
      } else {
        return exprBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public Builder setExpr(com.google.cloud.compute.v1.Expr value) {
      if (exprBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expr_ = value;
      } else {
        exprBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public Builder setExpr(com.google.cloud.compute.v1.Expr.Builder builderForValue) {
      if (exprBuilder_ == null) {
        expr_ = builderForValue.build();
      } else {
        exprBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public Builder mergeExpr(com.google.cloud.compute.v1.Expr value) {
      if (exprBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && expr_ != null
            && expr_ != com.google.cloud.compute.v1.Expr.getDefaultInstance()) {
          getExprBuilder().mergeFrom(value);
        } else {
          expr_ = value;
        }
      } else {
        exprBuilder_.mergeFrom(value);
      }
      if (expr_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public Builder clearExpr() {
      bitField0_ = (bitField0_ & ~0x00000002);
      expr_ = null;
      if (exprBuilder_ != null) {
        exprBuilder_.dispose();
        exprBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public com.google.cloud.compute.v1.Expr.Builder getExprBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExprFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    public com.google.cloud.compute.v1.ExprOrBuilder getExprOrBuilder() {
      if (exprBuilder_ != null) {
        return exprBuilder_.getMessageOrBuilder();
      } else {
        return expr_ == null ? com.google.cloud.compute.v1.Expr.getDefaultInstance() : expr_;
      }
    }
    /**
     *
     *
     * <pre>
     * User defined CEVAL expression. A CEVAL expression is used to specify match criteria such as origin.ip, source.region_code and contents in the request header. Expressions containing `evaluateThreatIntelligence` require Cloud Armor Managed Protection Plus tier and are not supported in Edge Policies nor in Regional Policies. Expressions containing `evaluatePreconfiguredExpr('sourceiplist-*')` require Cloud Armor Managed Protection Plus tier and are only supported in Global Security Policies.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Expr expr = 3127797;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Expr,
            com.google.cloud.compute.v1.Expr.Builder,
            com.google.cloud.compute.v1.ExprOrBuilder>
        getExprFieldBuilder() {
      if (exprBuilder_ == null) {
        exprBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Expr,
                com.google.cloud.compute.v1.Expr.Builder,
                com.google.cloud.compute.v1.ExprOrBuilder>(
                getExpr(), getParentForChildren(), isClean());
        expr_ = null;
      }
      return exprBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions exprOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptionsOrBuilder>
        exprOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     *
     * @return Whether the exprOptions field is set.
     */
    public boolean hasExprOptions() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     *
     * @return The exprOptions.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions getExprOptions() {
      if (exprOptionsBuilder_ == null) {
        return exprOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.getDefaultInstance()
            : exprOptions_;
      } else {
        return exprOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public Builder setExprOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions value) {
      if (exprOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exprOptions_ = value;
      } else {
        exprOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public Builder setExprOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.Builder builderForValue) {
      if (exprOptionsBuilder_ == null) {
        exprOptions_ = builderForValue.build();
      } else {
        exprOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public Builder mergeExprOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions value) {
      if (exprOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && exprOptions_ != null
            && exprOptions_
                != com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions
                    .getDefaultInstance()) {
          getExprOptionsBuilder().mergeFrom(value);
        } else {
          exprOptions_ = value;
        }
      } else {
        exprOptionsBuilder_.mergeFrom(value);
      }
      if (exprOptions_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public Builder clearExprOptions() {
      bitField0_ = (bitField0_ & ~0x00000004);
      exprOptions_ = null;
      if (exprOptionsBuilder_ != null) {
        exprOptionsBuilder_.dispose();
        exprOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.Builder
        getExprOptionsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getExprOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptionsOrBuilder
        getExprOptionsOrBuilder() {
      if (exprOptionsBuilder_ != null) {
        return exprOptionsBuilder_.getMessageOrBuilder();
      } else {
        return exprOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.getDefaultInstance()
            : exprOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options available when specifying a user defined CEVAL expression (i.e., 'expr').
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions expr_options = 486220372;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptionsOrBuilder>
        getExprOptionsFieldBuilder() {
      if (exprOptionsBuilder_ == null) {
        exprOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptions.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherExprOptionsOrBuilder>(
                getExprOptions(), getParentForChildren(), isClean());
        exprOptions_ = null;
      }
      return exprOptionsBuilder_;
    }

    private java.lang.Object versionedExpr_ = "";
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @return Whether the versionedExpr field is set.
     */
    public boolean hasVersionedExpr() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @return The versionedExpr.
     */
    public java.lang.String getVersionedExpr() {
      java.lang.Object ref = versionedExpr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionedExpr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @return The bytes for versionedExpr.
     */
    public com.google.protobuf.ByteString getVersionedExprBytes() {
      java.lang.Object ref = versionedExpr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionedExpr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @param value The versionedExpr to set.
     * @return This builder for chaining.
     */
    public Builder setVersionedExpr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionedExpr_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionedExpr() {
      versionedExpr_ = getDefaultInstance().getVersionedExpr();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
     * Check the VersionedExpr enum for the list of possible values.
     * </pre>
     *
     * <code>optional string versioned_expr = 322286013;</code>
     *
     * @param value The bytes for versionedExpr to set.
     * @return This builder for chaining.
     */
    public Builder setVersionedExprBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionedExpr_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicyRuleMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicyRuleMatcher)
  private static final com.google.cloud.compute.v1.SecurityPolicyRuleMatcher DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SecurityPolicyRuleMatcher();
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPolicyRuleMatcher> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPolicyRuleMatcher>() {
        @java.lang.Override
        public SecurityPolicyRuleMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPolicyRuleMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicyRuleMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
