/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions}
 */
public final class SecurityPolicyRuleRateLimitOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions)
    SecurityPolicyRuleRateLimitOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPolicyRuleRateLimitOptions.newBuilder() to construct.
  private SecurityPolicyRuleRateLimitOptions(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicyRuleRateLimitOptions() {
    conformAction_ = "";
    enforceOnKey_ = "";
    enforceOnKeyConfigs_ = java.util.Collections.emptyList();
    enforceOnKeyName_ = "";
    exceedAction_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicyRuleRateLimitOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleRateLimitOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRuleRateLimitOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.class,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.EnforceOnKey}
   */
  public enum EnforceOnKey implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENFORCE_ON_KEY = 0;</code>
     */
    UNDEFINED_ENFORCE_ON_KEY(0),
    /** <code>ALL = 64897;</code> */
    ALL(64897),
    /** <code>HTTP_COOKIE = 494981627;</code> */
    HTTP_COOKIE(494981627),
    /** <code>HTTP_HEADER = 91597348;</code> */
    HTTP_HEADER(91597348),
    /** <code>HTTP_PATH = 311503228;</code> */
    HTTP_PATH(311503228),
    /** <code>IP = 2343;</code> */
    IP(2343),
    /** <code>REGION_CODE = 79559768;</code> */
    REGION_CODE(79559768),
    /** <code>SNI = 82254;</code> */
    SNI(82254),
    /** <code>TLS_JA3_FINGERPRINT = 327127933;</code> */
    TLS_JA3_FINGERPRINT(327127933),
    /** <code>USER_IP = 34009627;</code> */
    USER_IP(34009627),
    /** <code>XFF_IP = 438707118;</code> */
    XFF_IP(438707118),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENFORCE_ON_KEY = 0;</code>
     */
    public static final int UNDEFINED_ENFORCE_ON_KEY_VALUE = 0;
    /** <code>ALL = 64897;</code> */
    public static final int ALL_VALUE = 64897;
    /** <code>HTTP_COOKIE = 494981627;</code> */
    public static final int HTTP_COOKIE_VALUE = 494981627;
    /** <code>HTTP_HEADER = 91597348;</code> */
    public static final int HTTP_HEADER_VALUE = 91597348;
    /** <code>HTTP_PATH = 311503228;</code> */
    public static final int HTTP_PATH_VALUE = 311503228;
    /** <code>IP = 2343;</code> */
    public static final int IP_VALUE = 2343;
    /** <code>REGION_CODE = 79559768;</code> */
    public static final int REGION_CODE_VALUE = 79559768;
    /** <code>SNI = 82254;</code> */
    public static final int SNI_VALUE = 82254;
    /** <code>TLS_JA3_FINGERPRINT = 327127933;</code> */
    public static final int TLS_JA3_FINGERPRINT_VALUE = 327127933;
    /** <code>USER_IP = 34009627;</code> */
    public static final int USER_IP_VALUE = 34009627;
    /** <code>XFF_IP = 438707118;</code> */
    public static final int XFF_IP_VALUE = 438707118;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnforceOnKey valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EnforceOnKey forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ENFORCE_ON_KEY;
        case 64897:
          return ALL;
        case 494981627:
          return HTTP_COOKIE;
        case 91597348:
          return HTTP_HEADER;
        case 311503228:
          return HTTP_PATH;
        case 2343:
          return IP;
        case 79559768:
          return REGION_CODE;
        case 82254:
          return SNI;
        case 327127933:
          return TLS_JA3_FINGERPRINT;
        case 34009627:
          return USER_IP;
        case 438707118:
          return XFF_IP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EnforceOnKey> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EnforceOnKey> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EnforceOnKey>() {
          public EnforceOnKey findValueByNumber(int number) {
            return EnforceOnKey.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EnforceOnKey[] VALUES = values();

    public static EnforceOnKey valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EnforceOnKey(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.EnforceOnKey)
  }

  private int bitField0_;
  public static final int BAN_DURATION_SEC_FIELD_NUMBER = 42896726;
  private int banDurationSec_ = 0;
  /**
   *
   *
   * <pre>
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
   * </pre>
   *
   * <code>optional int32 ban_duration_sec = 42896726;</code>
   *
   * @return Whether the banDurationSec field is set.
   */
  @java.lang.Override
  public boolean hasBanDurationSec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
   * </pre>
   *
   * <code>optional int32 ban_duration_sec = 42896726;</code>
   *
   * @return The banDurationSec.
   */
  @java.lang.Override
  public int getBanDurationSec() {
    return banDurationSec_;
  }

  public static final int BAN_THRESHOLD_FIELD_NUMBER = 501208123;
  private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold banThreshold_;
  /**
   *
   *
   * <pre>
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
   * </code>
   *
   * @return Whether the banThreshold field is set.
   */
  @java.lang.Override
  public boolean hasBanThreshold() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
   * </code>
   *
   * @return The banThreshold.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold getBanThreshold() {
    return banThreshold_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
            .getDefaultInstance()
        : banThreshold_;
  }
  /**
   *
   *
   * <pre>
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder
      getBanThresholdOrBuilder() {
    return banThreshold_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
            .getDefaultInstance()
        : banThreshold_;
  }

  public static final int CONFORM_ACTION_FIELD_NUMBER = 517612367;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conformAction_ = "";
  /**
   *
   *
   * <pre>
   * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
   * </pre>
   *
   * <code>optional string conform_action = 517612367;</code>
   *
   * @return Whether the conformAction field is set.
   */
  @java.lang.Override
  public boolean hasConformAction() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
   * </pre>
   *
   * <code>optional string conform_action = 517612367;</code>
   *
   * @return The conformAction.
   */
  @java.lang.Override
  public java.lang.String getConformAction() {
    java.lang.Object ref = conformAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conformAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
   * </pre>
   *
   * <code>optional string conform_action = 517612367;</code>
   *
   * @return The bytes for conformAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConformActionBytes() {
    java.lang.Object ref = conformAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conformAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENFORCE_ON_KEY_FIELD_NUMBER = 416648956;

  @SuppressWarnings("serial")
  private volatile java.lang.Object enforceOnKey_ = "";
  /**
   *
   *
   * <pre>
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
   * Check the EnforceOnKey enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enforce_on_key = 416648956;</code>
   *
   * @return Whether the enforceOnKey field is set.
   */
  @java.lang.Override
  public boolean hasEnforceOnKey() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
   * Check the EnforceOnKey enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enforce_on_key = 416648956;</code>
   *
   * @return The enforceOnKey.
   */
  @java.lang.Override
  public java.lang.String getEnforceOnKey() {
    java.lang.Object ref = enforceOnKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      enforceOnKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
   * Check the EnforceOnKey enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enforce_on_key = 416648956;</code>
   *
   * @return The bytes for enforceOnKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnforceOnKeyBytes() {
    java.lang.Object ref = enforceOnKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      enforceOnKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENFORCE_ON_KEY_CONFIGS_FIELD_NUMBER = 33906478;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
      enforceOnKeyConfigs_;
  /**
   *
   *
   * <pre>
   * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
      getEnforceOnKeyConfigsList() {
    return enforceOnKeyConfigs_;
  }
  /**
   *
   *
   * <pre>
   * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder>
      getEnforceOnKeyConfigsOrBuilderList() {
    return enforceOnKeyConfigs_;
  }
  /**
   *
   *
   * <pre>
   * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
   * </code>
   */
  @java.lang.Override
  public int getEnforceOnKeyConfigsCount() {
    return enforceOnKeyConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
      getEnforceOnKeyConfigs(int index) {
    return enforceOnKeyConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder
      getEnforceOnKeyConfigsOrBuilder(int index) {
    return enforceOnKeyConfigs_.get(index);
  }

  public static final int ENFORCE_ON_KEY_NAME_FIELD_NUMBER = 132555246;

  @SuppressWarnings("serial")
  private volatile java.lang.Object enforceOnKeyName_ = "";
  /**
   *
   *
   * <pre>
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
   * </pre>
   *
   * <code>optional string enforce_on_key_name = 132555246;</code>
   *
   * @return Whether the enforceOnKeyName field is set.
   */
  @java.lang.Override
  public boolean hasEnforceOnKeyName() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
   * </pre>
   *
   * <code>optional string enforce_on_key_name = 132555246;</code>
   *
   * @return The enforceOnKeyName.
   */
  @java.lang.Override
  public java.lang.String getEnforceOnKeyName() {
    java.lang.Object ref = enforceOnKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      enforceOnKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
   * </pre>
   *
   * <code>optional string enforce_on_key_name = 132555246;</code>
   *
   * @return The bytes for enforceOnKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnforceOnKeyNameBytes() {
    java.lang.Object ref = enforceOnKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      enforceOnKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXCEED_ACTION_FIELD_NUMBER = 167159073;

  @SuppressWarnings("serial")
  private volatile java.lang.Object exceedAction_ = "";
  /**
   *
   *
   * <pre>
   * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>optional string exceed_action = 167159073;</code>
   *
   * @return Whether the exceedAction field is set.
   */
  @java.lang.Override
  public boolean hasExceedAction() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>optional string exceed_action = 167159073;</code>
   *
   * @return The exceedAction.
   */
  @java.lang.Override
  public java.lang.String getExceedAction() {
    java.lang.Object ref = exceedAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exceedAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>optional string exceed_action = 167159073;</code>
   *
   * @return The bytes for exceedAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExceedActionBytes() {
    java.lang.Object ref = exceedAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      exceedAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXCEED_REDIRECT_OPTIONS_FIELD_NUMBER = 473646694;
  private com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceedRedirectOptions_;
  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
   * </code>
   *
   * @return Whether the exceedRedirectOptions field is set.
   */
  @java.lang.Override
  public boolean hasExceedRedirectOptions() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
   * </code>
   *
   * @return The exceedRedirectOptions.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions getExceedRedirectOptions() {
    return exceedRedirectOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
        : exceedRedirectOptions_;
  }
  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder
      getExceedRedirectOptionsOrBuilder() {
    return exceedRedirectOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
        : exceedRedirectOptions_;
  }

  public static final int RATE_LIMIT_THRESHOLD_FIELD_NUMBER = 315875208;
  private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
      rateLimitThreshold_;
  /**
   *
   *
   * <pre>
   * Threshold at which to begin ratelimiting.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
   * </code>
   *
   * @return Whether the rateLimitThreshold field is set.
   */
  @java.lang.Override
  public boolean hasRateLimitThreshold() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Threshold at which to begin ratelimiting.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
   * </code>
   *
   * @return The rateLimitThreshold.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
      getRateLimitThreshold() {
    return rateLimitThreshold_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
            .getDefaultInstance()
        : rateLimitThreshold_;
  }
  /**
   *
   *
   * <pre>
   * Threshold at which to begin ratelimiting.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder
      getRateLimitThresholdOrBuilder() {
    return rateLimitThreshold_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
            .getDefaultInstance()
        : rateLimitThreshold_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < enforceOnKeyConfigs_.size(); i++) {
      output.writeMessage(33906478, enforceOnKeyConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(42896726, banDurationSec_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 132555246, enforceOnKeyName_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 167159073, exceedAction_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(315875208, getRateLimitThreshold());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 416648956, enforceOnKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(473646694, getExceedRedirectOptions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(501208123, getBanThreshold());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 517612367, conformAction_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < enforceOnKeyConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33906478, enforceOnKeyConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(42896726, banDurationSec_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(132555246, enforceOnKeyName_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(167159073, exceedAction_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              315875208, getRateLimitThreshold());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(416648956, enforceOnKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              473646694, getExceedRedirectOptions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(501208123, getBanThreshold());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(517612367, conformAction_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions other =
        (com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions) obj;

    if (hasBanDurationSec() != other.hasBanDurationSec()) return false;
    if (hasBanDurationSec()) {
      if (getBanDurationSec() != other.getBanDurationSec()) return false;
    }
    if (hasBanThreshold() != other.hasBanThreshold()) return false;
    if (hasBanThreshold()) {
      if (!getBanThreshold().equals(other.getBanThreshold())) return false;
    }
    if (hasConformAction() != other.hasConformAction()) return false;
    if (hasConformAction()) {
      if (!getConformAction().equals(other.getConformAction())) return false;
    }
    if (hasEnforceOnKey() != other.hasEnforceOnKey()) return false;
    if (hasEnforceOnKey()) {
      if (!getEnforceOnKey().equals(other.getEnforceOnKey())) return false;
    }
    if (!getEnforceOnKeyConfigsList().equals(other.getEnforceOnKeyConfigsList())) return false;
    if (hasEnforceOnKeyName() != other.hasEnforceOnKeyName()) return false;
    if (hasEnforceOnKeyName()) {
      if (!getEnforceOnKeyName().equals(other.getEnforceOnKeyName())) return false;
    }
    if (hasExceedAction() != other.hasExceedAction()) return false;
    if (hasExceedAction()) {
      if (!getExceedAction().equals(other.getExceedAction())) return false;
    }
    if (hasExceedRedirectOptions() != other.hasExceedRedirectOptions()) return false;
    if (hasExceedRedirectOptions()) {
      if (!getExceedRedirectOptions().equals(other.getExceedRedirectOptions())) return false;
    }
    if (hasRateLimitThreshold() != other.hasRateLimitThreshold()) return false;
    if (hasRateLimitThreshold()) {
      if (!getRateLimitThreshold().equals(other.getRateLimitThreshold())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBanDurationSec()) {
      hash = (37 * hash) + BAN_DURATION_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getBanDurationSec();
    }
    if (hasBanThreshold()) {
      hash = (37 * hash) + BAN_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getBanThreshold().hashCode();
    }
    if (hasConformAction()) {
      hash = (37 * hash) + CONFORM_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getConformAction().hashCode();
    }
    if (hasEnforceOnKey()) {
      hash = (37 * hash) + ENFORCE_ON_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getEnforceOnKey().hashCode();
    }
    if (getEnforceOnKeyConfigsCount() > 0) {
      hash = (37 * hash) + ENFORCE_ON_KEY_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getEnforceOnKeyConfigsList().hashCode();
    }
    if (hasEnforceOnKeyName()) {
      hash = (37 * hash) + ENFORCE_ON_KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getEnforceOnKeyName().hashCode();
    }
    if (hasExceedAction()) {
      hash = (37 * hash) + EXCEED_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getExceedAction().hashCode();
    }
    if (hasExceedRedirectOptions()) {
      hash = (37 * hash) + EXCEED_REDIRECT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExceedRedirectOptions().hashCode();
    }
    if (hasRateLimitThreshold()) {
      hash = (37 * hash) + RATE_LIMIT_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimitThreshold().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions)
      com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleRateLimitOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleRateLimitOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.class,
              com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBanThresholdFieldBuilder();
        getEnforceOnKeyConfigsFieldBuilder();
        getExceedRedirectOptionsFieldBuilder();
        getRateLimitThresholdFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      banDurationSec_ = 0;
      banThreshold_ = null;
      if (banThresholdBuilder_ != null) {
        banThresholdBuilder_.dispose();
        banThresholdBuilder_ = null;
      }
      conformAction_ = "";
      enforceOnKey_ = "";
      if (enforceOnKeyConfigsBuilder_ == null) {
        enforceOnKeyConfigs_ = java.util.Collections.emptyList();
      } else {
        enforceOnKeyConfigs_ = null;
        enforceOnKeyConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      enforceOnKeyName_ = "";
      exceedAction_ = "";
      exceedRedirectOptions_ = null;
      if (exceedRedirectOptionsBuilder_ != null) {
        exceedRedirectOptionsBuilder_.dispose();
        exceedRedirectOptionsBuilder_ = null;
      }
      rateLimitThreshold_ = null;
      if (rateLimitThresholdBuilder_ != null) {
        rateLimitThresholdBuilder_.dispose();
        rateLimitThresholdBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRuleRateLimitOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions build() {
      com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions result =
          new com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions result) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          enforceOnKeyConfigs_ = java.util.Collections.unmodifiableList(enforceOnKeyConfigs_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.enforceOnKeyConfigs_ = enforceOnKeyConfigs_;
      } else {
        result.enforceOnKeyConfigs_ = enforceOnKeyConfigsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.banDurationSec_ = banDurationSec_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.banThreshold_ =
            banThresholdBuilder_ == null ? banThreshold_ : banThresholdBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conformAction_ = conformAction_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enforceOnKey_ = enforceOnKey_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.enforceOnKeyName_ = enforceOnKeyName_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.exceedAction_ = exceedAction_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.exceedRedirectOptions_ =
            exceedRedirectOptionsBuilder_ == null
                ? exceedRedirectOptions_
                : exceedRedirectOptionsBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.rateLimitThreshold_ =
            rateLimitThresholdBuilder_ == null
                ? rateLimitThreshold_
                : rateLimitThresholdBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions) {
        return mergeFrom((com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions other) {
      if (other
          == com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance())
        return this;
      if (other.hasBanDurationSec()) {
        setBanDurationSec(other.getBanDurationSec());
      }
      if (other.hasBanThreshold()) {
        mergeBanThreshold(other.getBanThreshold());
      }
      if (other.hasConformAction()) {
        conformAction_ = other.conformAction_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasEnforceOnKey()) {
        enforceOnKey_ = other.enforceOnKey_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (enforceOnKeyConfigsBuilder_ == null) {
        if (!other.enforceOnKeyConfigs_.isEmpty()) {
          if (enforceOnKeyConfigs_.isEmpty()) {
            enforceOnKeyConfigs_ = other.enforceOnKeyConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureEnforceOnKeyConfigsIsMutable();
            enforceOnKeyConfigs_.addAll(other.enforceOnKeyConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.enforceOnKeyConfigs_.isEmpty()) {
          if (enforceOnKeyConfigsBuilder_.isEmpty()) {
            enforceOnKeyConfigsBuilder_.dispose();
            enforceOnKeyConfigsBuilder_ = null;
            enforceOnKeyConfigs_ = other.enforceOnKeyConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
            enforceOnKeyConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnforceOnKeyConfigsFieldBuilder()
                    : null;
          } else {
            enforceOnKeyConfigsBuilder_.addAllMessages(other.enforceOnKeyConfigs_);
          }
        }
      }
      if (other.hasEnforceOnKeyName()) {
        enforceOnKeyName_ = other.enforceOnKeyName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasExceedAction()) {
        exceedAction_ = other.exceedAction_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasExceedRedirectOptions()) {
        mergeExceedRedirectOptions(other.getExceedRedirectOptions());
      }
      if (other.hasRateLimitThreshold()) {
        mergeRateLimitThreshold(other.getRateLimitThreshold());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 271251826:
              {
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1
                            .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.parser(),
                        extensionRegistry);
                if (enforceOnKeyConfigsBuilder_ == null) {
                  ensureEnforceOnKeyConfigsIsMutable();
                  enforceOnKeyConfigs_.add(m);
                } else {
                  enforceOnKeyConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 271251826
            case 343173808:
              {
                banDurationSec_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 343173808
            case 1060441970:
              {
                enforceOnKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1060441970
            case 1337272586:
              {
                exceedAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1337272586
            case -1767965630:
              {
                input.readMessage(
                    getRateLimitThresholdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case -1767965630
            case -961775646:
              {
                enforceOnKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -961775646
            case -505793742:
              {
                input.readMessage(
                    getExceedRedirectOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -505793742
            case -285302310:
              {
                input.readMessage(getBanThresholdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -285302310
            case -154068358:
              {
                conformAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -154068358
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int banDurationSec_;
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
     * </pre>
     *
     * <code>optional int32 ban_duration_sec = 42896726;</code>
     *
     * @return Whether the banDurationSec field is set.
     */
    @java.lang.Override
    public boolean hasBanDurationSec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
     * </pre>
     *
     * <code>optional int32 ban_duration_sec = 42896726;</code>
     *
     * @return The banDurationSec.
     */
    @java.lang.Override
    public int getBanDurationSec() {
      return banDurationSec_;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
     * </pre>
     *
     * <code>optional int32 ban_duration_sec = 42896726;</code>
     *
     * @param value The banDurationSec to set.
     * @return This builder for chaining.
     */
    public Builder setBanDurationSec(int value) {

      banDurationSec_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
     * </pre>
     *
     * <code>optional int32 ban_duration_sec = 42896726;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBanDurationSec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      banDurationSec_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold banThreshold_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>
        banThresholdBuilder_;
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     *
     * @return Whether the banThreshold field is set.
     */
    public boolean hasBanThreshold() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     *
     * @return The banThreshold.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
        getBanThreshold() {
      if (banThresholdBuilder_ == null) {
        return banThreshold_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                .getDefaultInstance()
            : banThreshold_;
      } else {
        return banThresholdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public Builder setBanThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold value) {
      if (banThresholdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        banThreshold_ = value;
      } else {
        banThresholdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public Builder setBanThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder
            builderForValue) {
      if (banThresholdBuilder_ == null) {
        banThreshold_ = builderForValue.build();
      } else {
        banThresholdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public Builder mergeBanThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold value) {
      if (banThresholdBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && banThreshold_ != null
            && banThreshold_
                != com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                    .getDefaultInstance()) {
          getBanThresholdBuilder().mergeFrom(value);
        } else {
          banThreshold_ = value;
        }
      } else {
        banThresholdBuilder_.mergeFrom(value);
      }
      if (banThreshold_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public Builder clearBanThreshold() {
      bitField0_ = (bitField0_ & ~0x00000002);
      banThreshold_ = null;
      if (banThresholdBuilder_ != null) {
        banThresholdBuilder_.dispose();
        banThresholdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder
        getBanThresholdBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBanThresholdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder
        getBanThresholdOrBuilder() {
      if (banThresholdBuilder_ != null) {
        return banThresholdBuilder_.getMessageOrBuilder();
      } else {
        return banThreshold_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                .getDefaultInstance()
            : banThreshold_;
      }
    }
    /**
     *
     *
     * <pre>
     * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key will be banned for the configured 'ban_duration_sec' when the number of requests that exceed the 'rate_limit_threshold' also exceed this 'ban_threshold'.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold ban_threshold = 501208123;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>
        getBanThresholdFieldBuilder() {
      if (banThresholdBuilder_ == null) {
        banThresholdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>(
                getBanThreshold(), getParentForChildren(), isClean());
        banThreshold_ = null;
      }
      return banThresholdBuilder_;
    }

    private java.lang.Object conformAction_ = "";
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @return Whether the conformAction field is set.
     */
    public boolean hasConformAction() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @return The conformAction.
     */
    public java.lang.String getConformAction() {
      java.lang.Object ref = conformAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conformAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @return The bytes for conformAction.
     */
    public com.google.protobuf.ByteString getConformActionBytes() {
      java.lang.Object ref = conformAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conformAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @param value The conformAction to set.
     * @return This builder for chaining.
     */
    public Builder setConformAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conformAction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConformAction() {
      conformAction_ = getDefaultInstance().getConformAction();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
     * </pre>
     *
     * <code>optional string conform_action = 517612367;</code>
     *
     * @param value The bytes for conformAction to set.
     * @return This builder for chaining.
     */
    public Builder setConformActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conformAction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object enforceOnKey_ = "";
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @return Whether the enforceOnKey field is set.
     */
    public boolean hasEnforceOnKey() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @return The enforceOnKey.
     */
    public java.lang.String getEnforceOnKey() {
      java.lang.Object ref = enforceOnKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enforceOnKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @return The bytes for enforceOnKey.
     */
    public com.google.protobuf.ByteString getEnforceOnKeyBytes() {
      java.lang.Object ref = enforceOnKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        enforceOnKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @param value The enforceOnKey to set.
     * @return This builder for chaining.
     */
    public Builder setEnforceOnKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      enforceOnKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforceOnKey() {
      enforceOnKey_ = getDefaultInstance().getEnforceOnKey();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates. - TLS_JA3_FINGERPRINT: JA3 TLS/SSL fingerprint if the client connects using HTTPS, HTTP/2 or HTTP/3. If not available, the key type defaults to ALL. - USER_IP: The IP address of the originating client, which is resolved based on "userIpRequestHeaders" configured with the security policy. If there is no "userIpRequestHeaders" configuration or an IP address cannot be resolved from it, the key type defaults to IP.
     * Check the EnforceOnKey enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enforce_on_key = 416648956;</code>
     *
     * @param value The bytes for enforceOnKey to set.
     * @return This builder for chaining.
     */
    public Builder setEnforceOnKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      enforceOnKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
        enforceOnKeyConfigs_ = java.util.Collections.emptyList();

    private void ensureEnforceOnKeyConfigsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        enforceOnKeyConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>(
                enforceOnKeyConfigs_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder>
        enforceOnKeyConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
        getEnforceOnKeyConfigsList() {
      if (enforceOnKeyConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(enforceOnKeyConfigs_);
      } else {
        return enforceOnKeyConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public int getEnforceOnKeyConfigsCount() {
      if (enforceOnKeyConfigsBuilder_ == null) {
        return enforceOnKeyConfigs_.size();
      } else {
        return enforceOnKeyConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
        getEnforceOnKeyConfigs(int index) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        return enforceOnKeyConfigs_.get(index);
      } else {
        return enforceOnKeyConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder setEnforceOnKeyConfigs(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig value) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.set(index, value);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder setEnforceOnKeyConfigs(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
            builderForValue) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder addEnforceOnKeyConfigs(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig value) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.add(value);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder addEnforceOnKeyConfigs(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig value) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.add(index, value);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder addEnforceOnKeyConfigs(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
            builderForValue) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder addEnforceOnKeyConfigs(
        int index,
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
            builderForValue) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder addAllEnforceOnKeyConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
            values) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        ensureEnforceOnKeyConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enforceOnKeyConfigs_);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder clearEnforceOnKeyConfigs() {
      if (enforceOnKeyConfigsBuilder_ == null) {
        enforceOnKeyConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public Builder removeEnforceOnKeyConfigs(int index) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        ensureEnforceOnKeyConfigsIsMutable();
        enforceOnKeyConfigs_.remove(index);
        onChanged();
      } else {
        enforceOnKeyConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
        getEnforceOnKeyConfigsBuilder(int index) {
      return getEnforceOnKeyConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder
        getEnforceOnKeyConfigsOrBuilder(int index) {
      if (enforceOnKeyConfigsBuilder_ == null) {
        return enforceOnKeyConfigs_.get(index);
      } else {
        return enforceOnKeyConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder>
        getEnforceOnKeyConfigsOrBuilderList() {
      if (enforceOnKeyConfigsBuilder_ != null) {
        return enforceOnKeyConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(enforceOnKeyConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
        addEnforceOnKeyConfigsBuilder() {
      return getEnforceOnKeyConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig.Builder
        addEnforceOnKeyConfigsBuilder(int index) {
      return getEnforceOnKeyConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If specified, any combination of values of enforce_on_key_type/enforce_on_key_name is treated as the key on which ratelimit threshold/action is enforced. You can specify up to 3 enforce_on_key_configs. If enforce_on_key_configs is specified, enforce_on_key must not be specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig enforce_on_key_configs = 33906478;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                .Builder>
        getEnforceOnKeyConfigsBuilderList() {
      return getEnforceOnKeyConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                .Builder,
            com.google.cloud.compute.v1
                .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder>
        getEnforceOnKeyConfigsFieldBuilder() {
      if (enforceOnKeyConfigsBuilder_ == null) {
        enforceOnKeyConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
                    .Builder,
                com.google.cloud.compute.v1
                    .SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigOrBuilder>(
                enforceOnKeyConfigs_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        enforceOnKeyConfigs_ = null;
      }
      return enforceOnKeyConfigsBuilder_;
    }

    private java.lang.Object enforceOnKeyName_ = "";
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @return Whether the enforceOnKeyName field is set.
     */
    public boolean hasEnforceOnKeyName() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @return The enforceOnKeyName.
     */
    public java.lang.String getEnforceOnKeyName() {
      java.lang.Object ref = enforceOnKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enforceOnKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @return The bytes for enforceOnKeyName.
     */
    public com.google.protobuf.ByteString getEnforceOnKeyNameBytes() {
      java.lang.Object ref = enforceOnKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        enforceOnKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @param value The enforceOnKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setEnforceOnKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      enforceOnKeyName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforceOnKeyName() {
      enforceOnKeyName_ = getDefaultInstance().getEnforceOnKeyName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
     * </pre>
     *
     * <code>optional string enforce_on_key_name = 132555246;</code>
     *
     * @param value The bytes for enforceOnKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setEnforceOnKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      enforceOnKeyName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object exceedAction_ = "";
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @return Whether the exceedAction field is set.
     */
    public boolean hasExceedAction() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @return The exceedAction.
     */
    public java.lang.String getExceedAction() {
      java.lang.Object ref = exceedAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exceedAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @return The bytes for exceedAction.
     */
    public com.google.protobuf.ByteString getExceedActionBytes() {
      java.lang.Object ref = exceedAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exceedAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @param value The exceedAction to set.
     * @return This builder for chaining.
     */
    public Builder setExceedAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      exceedAction_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExceedAction() {
      exceedAction_ = getDefaultInstance().getExceedAction();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are `deny(STATUS)`, where valid values for `STATUS` are 403, 404, 429, and 502, and `redirect`, where the redirect parameters come from `exceedRedirectOptions` below. The `redirect` action is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>optional string exceed_action = 167159073;</code>
     *
     * @param value The bytes for exceedAction to set.
     * @return This builder for chaining.
     */
    public Builder setExceedActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      exceedAction_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceedRedirectOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>
        exceedRedirectOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     *
     * @return Whether the exceedRedirectOptions field is set.
     */
    public boolean hasExceedRedirectOptions() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     *
     * @return The exceedRedirectOptions.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions
        getExceedRedirectOptions() {
      if (exceedRedirectOptionsBuilder_ == null) {
        return exceedRedirectOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
            : exceedRedirectOptions_;
      } else {
        return exceedRedirectOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public Builder setExceedRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions value) {
      if (exceedRedirectOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exceedRedirectOptions_ = value;
      } else {
        exceedRedirectOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public Builder setExceedRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder builderForValue) {
      if (exceedRedirectOptionsBuilder_ == null) {
        exceedRedirectOptions_ = builderForValue.build();
      } else {
        exceedRedirectOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public Builder mergeExceedRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions value) {
      if (exceedRedirectOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && exceedRedirectOptions_ != null
            && exceedRedirectOptions_
                != com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions
                    .getDefaultInstance()) {
          getExceedRedirectOptionsBuilder().mergeFrom(value);
        } else {
          exceedRedirectOptions_ = value;
        }
      } else {
        exceedRedirectOptionsBuilder_.mergeFrom(value);
      }
      if (exceedRedirectOptions_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public Builder clearExceedRedirectOptions() {
      bitField0_ = (bitField0_ & ~0x00000080);
      exceedRedirectOptions_ = null;
      if (exceedRedirectOptionsBuilder_ != null) {
        exceedRedirectOptionsBuilder_.dispose();
        exceedRedirectOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder
        getExceedRedirectOptionsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getExceedRedirectOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder
        getExceedRedirectOptionsOrBuilder() {
      if (exceedRedirectOptionsBuilder_ != null) {
        return exceedRedirectOptionsBuilder_.getMessageOrBuilder();
      } else {
        return exceedRedirectOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
            : exceedRedirectOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action that is used as the exceed action. Cannot be specified if the exceed action is not redirect. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions exceed_redirect_options = 473646694;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>
        getExceedRedirectOptionsFieldBuilder() {
      if (exceedRedirectOptionsBuilder_ == null) {
        exceedRedirectOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>(
                getExceedRedirectOptions(), getParentForChildren(), isClean());
        exceedRedirectOptions_ = null;
      }
      return exceedRedirectOptionsBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
        rateLimitThreshold_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>
        rateLimitThresholdBuilder_;
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     *
     * @return Whether the rateLimitThreshold field is set.
     */
    public boolean hasRateLimitThreshold() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     *
     * @return The rateLimitThreshold.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
        getRateLimitThreshold() {
      if (rateLimitThresholdBuilder_ == null) {
        return rateLimitThreshold_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                .getDefaultInstance()
            : rateLimitThreshold_;
      } else {
        return rateLimitThresholdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public Builder setRateLimitThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold value) {
      if (rateLimitThresholdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rateLimitThreshold_ = value;
      } else {
        rateLimitThresholdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public Builder setRateLimitThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder
            builderForValue) {
      if (rateLimitThresholdBuilder_ == null) {
        rateLimitThreshold_ = builderForValue.build();
      } else {
        rateLimitThresholdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public Builder mergeRateLimitThreshold(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold value) {
      if (rateLimitThresholdBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && rateLimitThreshold_ != null
            && rateLimitThreshold_
                != com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                    .getDefaultInstance()) {
          getRateLimitThresholdBuilder().mergeFrom(value);
        } else {
          rateLimitThreshold_ = value;
        }
      } else {
        rateLimitThresholdBuilder_.mergeFrom(value);
      }
      if (rateLimitThreshold_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public Builder clearRateLimitThreshold() {
      bitField0_ = (bitField0_ & ~0x00000100);
      rateLimitThreshold_ = null;
      if (rateLimitThresholdBuilder_ != null) {
        rateLimitThresholdBuilder_.dispose();
        rateLimitThresholdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder
        getRateLimitThresholdBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getRateLimitThresholdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder
        getRateLimitThresholdOrBuilder() {
      if (rateLimitThresholdBuilder_ != null) {
        return rateLimitThresholdBuilder_.getMessageOrBuilder();
      } else {
        return rateLimitThreshold_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold
                .getDefaultInstance()
            : rateLimitThreshold_;
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold at which to begin ratelimiting.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold rate_limit_threshold = 315875208;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>
        getRateLimitThresholdFieldBuilder() {
      if (rateLimitThresholdBuilder_ == null) {
        rateLimitThresholdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThreshold.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsThresholdOrBuilder>(
                getRateLimitThreshold(), getParentForChildren(), isClean());
        rateLimitThreshold_ = null;
      }
      return rateLimitThresholdBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions)
  private static final com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions();
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPolicyRuleRateLimitOptions> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPolicyRuleRateLimitOptions>() {
        @java.lang.Override
        public SecurityPolicyRuleRateLimitOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPolicyRuleRateLimitOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicyRuleRateLimitOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
