/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A request message for RegionTargetHttpsProxies.SetSslCertificates. See the method description for details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest}
 */
public final class SetSslCertificatesRegionTargetHttpsProxyRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest)
    SetSslCertificatesRegionTargetHttpsProxyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetSslCertificatesRegionTargetHttpsProxyRequest.newBuilder() to construct.
  private SetSslCertificatesRegionTargetHttpsProxyRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetSslCertificatesRegionTargetHttpsProxyRequest() {
    project_ = "";
    region_ = "";
    requestId_ = "";
    targetHttpsProxy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetSslCertificatesRegionTargetHttpsProxyRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SetSslCertificatesRegionTargetHttpsProxyRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SetSslCertificatesRegionTargetHttpsProxyRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest.class,
            com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int PROJECT_FIELD_NUMBER = 227560217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * Name of the region scoping this request.
   * </pre>
   *
   * <code>
   * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
   * </code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the region scoping this request.
   * </pre>
   *
   * <code>
   * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
   * </code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int
      REGION_TARGET_HTTPS_PROXIES_SET_SSL_CERTIFICATES_REQUEST_RESOURCE_FIELD_NUMBER = 390693383;
  private com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
      regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the regionTargetHttpsProxiesSetSslCertificatesRequestResource field is set.
   */
  @java.lang.Override
  public boolean hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The regionTargetHttpsProxiesSetSslCertificatesRequestResource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
      getRegionTargetHttpsProxiesSetSslCertificatesRequestResource() {
    return regionTargetHttpsProxiesSetSslCertificatesRequestResource_ == null
        ? com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
            .getDefaultInstance()
        : regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequestOrBuilder
      getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceOrBuilder() {
    return regionTargetHttpsProxiesSetSslCertificatesRequestResource_ == null
        ? com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
            .getDefaultInstance()
        : regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 37109963;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return Whether the requestId field is set.
   */
  @java.lang.Override
  public boolean hasRequestId() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_HTTPS_PROXY_FIELD_NUMBER = 52336748;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetHttpsProxy_ = "";
  /**
   *
   *
   * <pre>
   * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
   * </pre>
   *
   * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetHttpsProxy.
   */
  @java.lang.Override
  public java.lang.String getTargetHttpsProxy() {
    java.lang.Object ref = targetHttpsProxy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetHttpsProxy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
   * </pre>
   *
   * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetHttpsProxy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetHttpsProxyBytes() {
    java.lang.Object ref = targetHttpsProxy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetHttpsProxy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetHttpsProxy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 52336748, targetHttpsProxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227560217, project_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(
          390693383, getRegionTargetHttpsProxiesSetSslCertificatesRequestResource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetHttpsProxy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(52336748, targetHttpsProxy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227560217, project_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              390693383, getRegionTargetHttpsProxiesSetSslCertificatesRequestResource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest other =
        (com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest) obj;

    if (!getProject().equals(other.getProject())) return false;
    if (!getRegion().equals(other.getRegion())) return false;
    if (hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource()
        != other.hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource()) return false;
    if (hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource()) {
      if (!getRegionTargetHttpsProxiesSetSslCertificatesRequestResource()
          .equals(other.getRegionTargetHttpsProxiesSetSslCertificatesRequestResource()))
        return false;
    }
    if (hasRequestId() != other.hasRequestId()) return false;
    if (hasRequestId()) {
      if (!getRequestId().equals(other.getRequestId())) return false;
    }
    if (!getTargetHttpsProxy().equals(other.getTargetHttpsProxy())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + REGION_FIELD_NUMBER;
    hash = (53 * hash) + getRegion().hashCode();
    if (hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource()) {
      hash =
          (37 * hash)
              + REGION_TARGET_HTTPS_PROXIES_SET_SSL_CERTIFICATES_REQUEST_RESOURCE_FIELD_NUMBER;
      hash =
          (53 * hash) + getRegionTargetHttpsProxiesSetSslCertificatesRequestResource().hashCode();
    }
    if (hasRequestId()) {
      hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRequestId().hashCode();
    }
    hash = (37 * hash) + TARGET_HTTPS_PROXY_FIELD_NUMBER;
    hash = (53 * hash) + getTargetHttpsProxy().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request message for RegionTargetHttpsProxies.SetSslCertificates. See the method description for details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest)
      com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SetSslCertificatesRegionTargetHttpsProxyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SetSslCertificatesRegionTargetHttpsProxyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest.class,
              com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      project_ = "";
      region_ = "";
      regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = null;
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ != null) {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.dispose();
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ = null;
      }
      requestId_ = "";
      targetHttpsProxy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SetSslCertificatesRegionTargetHttpsProxyRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest build() {
      com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
        buildPartial() {
      com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest result =
          new com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.region_ = region_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.regionTargetHttpsProxiesSetSslCertificatesRequestResource_ =
            regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null
                ? regionTargetHttpsProxiesSetSslCertificatesRequestResource_
                : regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetHttpsProxy_ = targetHttpsProxy_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest) {
        return mergeFrom(
            (com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest other) {
      if (other
          == com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
              .getDefaultInstance()) return this;
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRegion().isEmpty()) {
        region_ = other.region_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource()) {
        mergeRegionTargetHttpsProxiesSetSslCertificatesRequestResource(
            other.getRegionTargetHttpsProxiesSetSslCertificatesRequestResource());
      }
      if (other.hasRequestId()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getTargetHttpsProxy().isEmpty()) {
        targetHttpsProxy_ = other.targetHttpsProxy_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 296879706:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 296879706
            case 418693986:
              {
                targetHttpsProxy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 418693986
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1111570338
            case 1820481738:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1820481738
            case -1169420230:
              {
                input.readMessage(
                    getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceFieldBuilder()
                        .getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1169420230
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * Name of the region scoping this request.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the region scoping this request.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the region scoping this request.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the region scoping this request.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the region scoping this request.
     * </pre>
     *
     * <code>
     * string region = 138946292 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "region"];
     * </code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
        regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest,
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest.Builder,
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequestOrBuilder>
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the regionTargetHttpsProxiesSetSslCertificatesRequestResource field is set.
     */
    public boolean hasRegionTargetHttpsProxiesSetSslCertificatesRequestResource() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The regionTargetHttpsProxiesSetSslCertificatesRequestResource.
     */
    public com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
        getRegionTargetHttpsProxiesSetSslCertificatesRequestResource() {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null) {
        return regionTargetHttpsProxiesSetSslCertificatesRequestResource_ == null
            ? com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
                .getDefaultInstance()
            : regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
      } else {
        return regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegionTargetHttpsProxiesSetSslCertificatesRequestResource(
        com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest value) {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = value;
      } else {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegionTargetHttpsProxiesSetSslCertificatesRequestResource(
        com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest.Builder
            builderForValue) {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null) {
        regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = builderForValue.build();
      } else {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.setMessage(
            builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRegionTargetHttpsProxiesSetSslCertificatesRequestResource(
        com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest value) {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && regionTargetHttpsProxiesSetSslCertificatesRequestResource_ != null
            && regionTargetHttpsProxiesSetSslCertificatesRequestResource_
                != com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
                    .getDefaultInstance()) {
          getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder().mergeFrom(value);
        } else {
          regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = value;
        }
      } else {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.mergeFrom(value);
      }
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResource_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRegionTargetHttpsProxiesSetSslCertificatesRequestResource() {
      bitField0_ = (bitField0_ & ~0x00000004);
      regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = null;
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ != null) {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_.dispose();
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest.Builder
        getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceFieldBuilder()
          .getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequestOrBuilder
        getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceOrBuilder() {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ != null) {
        return regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_
            .getMessageOrBuilder();
      } else {
        return regionTargetHttpsProxiesSetSslCertificatesRequestResource_ == null
            ? com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
                .getDefaultInstance()
            : regionTargetHttpsProxiesSetSslCertificatesRequestResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest region_target_https_proxies_set_ssl_certificates_request_resource = 390693383 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest,
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest.Builder,
            com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequestOrBuilder>
        getRegionTargetHttpsProxiesSetSslCertificatesRequestResourceFieldBuilder() {
      if (regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ == null) {
        regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest,
                com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest
                    .Builder,
                com.google.cloud.compute.v1
                    .RegionTargetHttpsProxiesSetSslCertificatesRequestOrBuilder>(
                getRegionTargetHttpsProxiesSetSslCertificatesRequestResource(),
                getParentForChildren(),
                isClean());
        regionTargetHttpsProxiesSetSslCertificatesRequestResource_ = null;
      }
      return regionTargetHttpsProxiesSetSslCertificatesRequestResourceBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return Whether the requestId field is set.
     */
    public boolean hasRequestId() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object targetHttpsProxy_ = "";
    /**
     *
     *
     * <pre>
     * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
     * </pre>
     *
     * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetHttpsProxy.
     */
    public java.lang.String getTargetHttpsProxy() {
      java.lang.Object ref = targetHttpsProxy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetHttpsProxy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
     * </pre>
     *
     * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetHttpsProxy.
     */
    public com.google.protobuf.ByteString getTargetHttpsProxyBytes() {
      java.lang.Object ref = targetHttpsProxy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetHttpsProxy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
     * </pre>
     *
     * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetHttpsProxy to set.
     * @return This builder for chaining.
     */
    public Builder setTargetHttpsProxy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetHttpsProxy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
     * </pre>
     *
     * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetHttpsProxy() {
      targetHttpsProxy_ = getDefaultInstance().getTargetHttpsProxy();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the TargetHttpsProxy resource to set an SslCertificates resource for.
     * </pre>
     *
     * <code>string target_https_proxy = 52336748 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetHttpsProxy to set.
     * @return This builder for chaining.
     */
    public Builder setTargetHttpsProxyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetHttpsProxy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest)
  private static final com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest();
  }

  public static com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetSslCertificatesRegionTargetHttpsProxyRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SetSslCertificatesRegionTargetHttpsProxyRequest>() {
            @java.lang.Override
            public SetSslCertificatesRegionTargetHttpsProxyRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<SetSslCertificatesRegionTargetHttpsProxyRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetSslCertificatesRegionTargetHttpsProxyRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
