/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings}
 */
public final class SnapshotSettingsStorageLocationSettings
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings)
    SnapshotSettingsStorageLocationSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SnapshotSettingsStorageLocationSettings.newBuilder() to construct.
  private SnapshotSettingsStorageLocationSettings(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SnapshotSettingsStorageLocationSettings() {
    policy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SnapshotSettingsStorageLocationSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 413423454:
        return internalGetLocations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.class,
            com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The chosen location policy.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.Policy}
   */
  public enum Policy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_POLICY = 0;</code>
     */
    UNDEFINED_POLICY(0),
    /**
     *
     *
     * <pre>
     * Store snapshot in the same region as with the originating disk. No additional parameters are needed.
     * </pre>
     *
     * <code>LOCAL_REGION = 403535464;</code>
     */
    LOCAL_REGION(403535464),
    /**
     *
     *
     * <pre>
     * Store snapshot in the nearest multi region Cloud Storage bucket, relative to the originating disk. No additional parameters are needed.
     * </pre>
     *
     * <code>NEAREST_MULTI_REGION = 212467515;</code>
     */
    NEAREST_MULTI_REGION(212467515),
    /**
     *
     *
     * <pre>
     * Store snapshot in the specific locations, as specified by the user. The list of regions to store must be defined under the `locations` field.
     * </pre>
     *
     * <code>SPECIFIC_LOCATIONS = 280093809;</code>
     */
    SPECIFIC_LOCATIONS(280093809),
    /** <code>STORAGE_LOCATION_POLICY_UNSPECIFIED = 250644592;</code> */
    STORAGE_LOCATION_POLICY_UNSPECIFIED(250644592),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_POLICY = 0;</code>
     */
    public static final int UNDEFINED_POLICY_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Store snapshot in the same region as with the originating disk. No additional parameters are needed.
     * </pre>
     *
     * <code>LOCAL_REGION = 403535464;</code>
     */
    public static final int LOCAL_REGION_VALUE = 403535464;
    /**
     *
     *
     * <pre>
     * Store snapshot in the nearest multi region Cloud Storage bucket, relative to the originating disk. No additional parameters are needed.
     * </pre>
     *
     * <code>NEAREST_MULTI_REGION = 212467515;</code>
     */
    public static final int NEAREST_MULTI_REGION_VALUE = 212467515;
    /**
     *
     *
     * <pre>
     * Store snapshot in the specific locations, as specified by the user. The list of regions to store must be defined under the `locations` field.
     * </pre>
     *
     * <code>SPECIFIC_LOCATIONS = 280093809;</code>
     */
    public static final int SPECIFIC_LOCATIONS_VALUE = 280093809;
    /** <code>STORAGE_LOCATION_POLICY_UNSPECIFIED = 250644592;</code> */
    public static final int STORAGE_LOCATION_POLICY_UNSPECIFIED_VALUE = 250644592;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Policy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Policy forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_POLICY;
        case 403535464:
          return LOCAL_REGION;
        case 212467515:
          return NEAREST_MULTI_REGION;
        case 280093809:
          return SPECIFIC_LOCATIONS;
        case 250644592:
          return STORAGE_LOCATION_POLICY_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Policy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Policy> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Policy>() {
          public Policy findValueByNumber(int number) {
            return Policy.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Policy[] VALUES = values();

    public static Policy valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Policy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.Policy)
  }

  private int bitField0_;
  public static final int LOCATIONS_FIELD_NUMBER = 413423454;

  private static final class LocationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1
                        .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_LocationsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1
                            .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
      locations_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
      internalGetLocations() {
    if (locations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LocationsDefaultEntryHolder.defaultEntry);
    }
    return locations_;
  }

  public int getLocationsCount() {
    return internalGetLocations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public boolean containsLocations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLocations().getMap().containsKey(key);
  }
  /** Use {@link #getLocationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
      getLocations() {
    return getLocationsMap();
  }
  /**
   *
   *
   * <pre>
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
      getLocationsMap() {
    return internalGetLocations().getMap();
  }
  /**
   *
   *
   * <pre>
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1
          .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
      getLocationsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
              defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        map = internalGetLocations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
      getLocationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        map = internalGetLocations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int POLICY_FIELD_NUMBER = 91071794;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policy_ = "";
  /**
   *
   *
   * <pre>
   * The chosen location policy.
   * Check the Policy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string policy = 91071794;</code>
   *
   * @return Whether the policy field is set.
   */
  @java.lang.Override
  public boolean hasPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The chosen location policy.
   * Check the Policy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string policy = 91071794;</code>
   *
   * @return The policy.
   */
  @java.lang.Override
  public java.lang.String getPolicy() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The chosen location policy.
   * Check the Policy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string policy = 91071794;</code>
   *
   * @return The bytes for policy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicyBytes() {
    java.lang.Object ref = policy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 91071794, policy_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLocations(), LocationsDefaultEntryHolder.defaultEntry, 413423454);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(91071794, policy_);
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        entry : internalGetLocations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
          locations__ =
              LocationsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(413423454, locations__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings other =
        (com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings) obj;

    if (!internalGetLocations().equals(other.internalGetLocations())) return false;
    if (hasPolicy() != other.hasPolicy()) return false;
    if (hasPolicy()) {
      if (!getPolicy().equals(other.getPolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetLocations().getMap().isEmpty()) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLocations().hashCode();
    }
    if (hasPolicy()) {
      hash = (37 * hash) + POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getPolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings)
      com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 413423454:
          return internalGetLocations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 413423454:
          return internalGetMutableLocations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.class,
              com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableLocations().clear();
      policy_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SnapshotSettingsStorageLocationSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings build() {
      com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings buildPartial() {
      com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings result =
          new com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.locations_ = internalGetLocations().build(LocationsDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.policy_ = policy_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings) {
        return mergeFrom(
            (com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings other) {
      if (other
          == com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
              .getDefaultInstance()) return this;
      internalGetMutableLocations().mergeFrom(other.internalGetLocations());
      bitField0_ |= 0x00000001;
      if (other.hasPolicy()) {
        policy_ = other.policy_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 728574354:
              {
                policy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 728574354
            case -987579662:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1
                            .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
                    locations__ =
                        input.readMessage(
                            LocationsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLocations()
                    .ensureBuilderMap()
                    .put(locations__.getKey(), locations__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case -987579662
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private static final class LocationsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference> {
      @java.lang.Override
      public com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
          build(
              com.google.cloud.compute.v1
                      .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder
                  val) {
        if (val
            instanceof
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference) {
          return (com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreference)
              val;
        }
        return ((com.google.cloud.compute.v1
                    .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder)
                val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
          defaultEntry() {
        return LocationsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final LocationsConverter locationsConverter = new LocationsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder>
        locations_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder>
        internalGetLocations() {
      if (locations_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(locationsConverter);
      }
      return locations_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder>
        internalGetMutableLocations() {
      if (locations_ == null) {
        locations_ = new com.google.protobuf.MapFieldBuilder<>(locationsConverter);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return locations_;
    }

    public int getLocationsCount() {
      return internalGetLocations().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public boolean containsLocations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLocations().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getLocationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        getLocations() {
      return getLocationsMap();
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        getLocationsMap() {
      return internalGetLocations().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1
            .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
        getLocationsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1
                    .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder>
          map = internalGetMutableLocations().ensureBuilderMap();
      return map.containsKey(key) ? locationsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1
            .SnapshotSettingsStorageLocationSettingsStorageLocationPreference
        getLocationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder>
          map = internalGetMutableLocations().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return locationsConverter.build(map.get(key));
    }

    public Builder clearLocations() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableLocations().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    public Builder removeLocations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLocations().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
        getMutableLocations() {
      bitField0_ |= 0x00000001;
      return internalGetMutableLocations().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    public Builder putLocations(
        java.lang.String key,
        com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference
            value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLocations().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    public Builder putAllLocations(
        java.util.Map<
                java.lang.String,
                com.google.cloud.compute.v1
                    .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreference>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableLocations().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this field. Keys are Cloud Storage bucket locations. Only one location can be specified.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.SnapshotSettingsStorageLocationSettingsStorageLocationPreference&gt; locations = 413423454;
     * </code>
     */
    public com.google.cloud.compute.v1
            .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder
        putLocationsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1
                  .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder>
          builderMap = internalGetMutableLocations().ensureBuilderMap();
      com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreferenceOrBuilder
          entry = builderMap.get(key);
      if (entry == null) {
        entry =
            com.google.cloud.compute.v1
                .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry
          instanceof
          com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference) {
        entry =
            ((com.google.cloud.compute.v1
                        .SnapshotSettingsStorageLocationSettingsStorageLocationPreference)
                    entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1
              .SnapshotSettingsStorageLocationSettingsStorageLocationPreference.Builder)
          entry;
    }

    private java.lang.Object policy_ = "";
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @return Whether the policy field is set.
     */
    public boolean hasPolicy() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @return The policy.
     */
    public java.lang.String getPolicy() {
      java.lang.Object ref = policy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @return The bytes for policy.
     */
    public com.google.protobuf.ByteString getPolicyBytes() {
      java.lang.Object ref = policy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @param value The policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicy() {
      policy_ = getDefaultInstance().getPolicy();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The chosen location policy.
     * Check the Policy enum for the list of possible values.
     * </pre>
     *
     * <code>optional string policy = 91071794;</code>
     *
     * @param value The bytes for policy to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings)
  private static final com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings();
  }

  public static com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SnapshotSettingsStorageLocationSettings> PARSER =
      new com.google.protobuf.AbstractParser<SnapshotSettingsStorageLocationSettings>() {
        @java.lang.Override
        public SnapshotSettingsStorageLocationSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SnapshotSettingsStorageLocationSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SnapshotSettingsStorageLocationSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SnapshotSettingsStorageLocationSettings
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
