/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Message containing information of one individual backend.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Backend}
 */
public final class Backend extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Backend)
    BackendOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Backend.newBuilder() to construct.
  private Backend(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Backend() {
    balancingMode_ = "";
    customMetrics_ = java.util.Collections.emptyList();
    description_ = "";
    group_ = "";
    preference_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Backend();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Backend_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Backend_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Backend.class,
            com.google.cloud.compute.v1.Backend.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Backend.BalancingMode}
   */
  public enum BalancingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BALANCING_MODE = 0;</code>
     */
    UNDEFINED_BALANCING_MODE(0),
    /**
     *
     *
     * <pre>
     * Balance based on the number of simultaneous connections.
     * </pre>
     *
     * <code>CONNECTION = 246311646;</code>
     */
    CONNECTION(246311646),
    /**
     *
     *
     * <pre>
     * Based on custom defined and reported metrics.
     * </pre>
     *
     * <code>CUSTOM_METRICS = 331575765;</code>
     */
    CUSTOM_METRICS(331575765),
    /**
     *
     *
     * <pre>
     * Balance based on requests per second (RPS).
     * </pre>
     *
     * <code>RATE = 2508000;</code>
     */
    RATE(2508000),
    /**
     *
     *
     * <pre>
     * Balance based on the backend utilization.
     * </pre>
     *
     * <code>UTILIZATION = 157008386;</code>
     */
    UTILIZATION(157008386),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BALANCING_MODE = 0;</code>
     */
    public static final int UNDEFINED_BALANCING_MODE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Balance based on the number of simultaneous connections.
     * </pre>
     *
     * <code>CONNECTION = 246311646;</code>
     */
    public static final int CONNECTION_VALUE = 246311646;

    /**
     *
     *
     * <pre>
     * Based on custom defined and reported metrics.
     * </pre>
     *
     * <code>CUSTOM_METRICS = 331575765;</code>
     */
    public static final int CUSTOM_METRICS_VALUE = 331575765;

    /**
     *
     *
     * <pre>
     * Balance based on requests per second (RPS).
     * </pre>
     *
     * <code>RATE = 2508000;</code>
     */
    public static final int RATE_VALUE = 2508000;

    /**
     *
     *
     * <pre>
     * Balance based on the backend utilization.
     * </pre>
     *
     * <code>UTILIZATION = 157008386;</code>
     */
    public static final int UTILIZATION_VALUE = 157008386;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BalancingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BalancingMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BALANCING_MODE;
        case 246311646:
          return CONNECTION;
        case 331575765:
          return CUSTOM_METRICS;
        case 2508000:
          return RATE;
        case 157008386:
          return UTILIZATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BalancingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BalancingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BalancingMode>() {
          public BalancingMode findValueByNumber(int number) {
            return BalancingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Backend.getDescriptor().getEnumTypes().get(0);
    }

    private static final BalancingMode[] VALUES = values();

    public static BalancingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BalancingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Backend.BalancingMode)
  }

  /**
   *
   *
   * <pre>
   * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Backend.Preference}
   */
  public enum Preference implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PREFERENCE = 0;</code>
     */
    UNDEFINED_PREFERENCE(0),
    /**
     *
     *
     * <pre>
     * No preference.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    DEFAULT(115302945),
    /**
     *
     *
     * <pre>
     * If preference is unspecified, we set it to the DEFAULT value
     * </pre>
     *
     * <code>PREFERENCE_UNSPECIFIED = 496219571;</code>
     */
    PREFERENCE_UNSPECIFIED(496219571),
    /**
     *
     *
     * <pre>
     * Traffic will be sent to this backend first.
     * </pre>
     *
     * <code>PREFERRED = 418847841;</code>
     */
    PREFERRED(418847841),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PREFERENCE = 0;</code>
     */
    public static final int UNDEFINED_PREFERENCE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * No preference.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    public static final int DEFAULT_VALUE = 115302945;

    /**
     *
     *
     * <pre>
     * If preference is unspecified, we set it to the DEFAULT value
     * </pre>
     *
     * <code>PREFERENCE_UNSPECIFIED = 496219571;</code>
     */
    public static final int PREFERENCE_UNSPECIFIED_VALUE = 496219571;

    /**
     *
     *
     * <pre>
     * Traffic will be sent to this backend first.
     * </pre>
     *
     * <code>PREFERRED = 418847841;</code>
     */
    public static final int PREFERRED_VALUE = 418847841;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Preference valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Preference forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PREFERENCE;
        case 115302945:
          return DEFAULT;
        case 496219571:
          return PREFERENCE_UNSPECIFIED;
        case 418847841:
          return PREFERRED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Preference> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Preference> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Preference>() {
          public Preference findValueByNumber(int number) {
            return Preference.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Backend.getDescriptor().getEnumTypes().get(1);
    }

    private static final Preference[] VALUES = values();

    public static Preference valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Preference(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Backend.Preference)
  }

  private int bitField0_;
  public static final int BALANCING_MODE_FIELD_NUMBER = 430286217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object balancingMode_ = "";

  /**
   *
   *
   * <pre>
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
   * Check the BalancingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string balancing_mode = 430286217;</code>
   *
   * @return Whether the balancingMode field is set.
   */
  @java.lang.Override
  public boolean hasBalancingMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
   * Check the BalancingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string balancing_mode = 430286217;</code>
   *
   * @return The balancingMode.
   */
  @java.lang.Override
  public java.lang.String getBalancingMode() {
    java.lang.Object ref = balancingMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      balancingMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
   * Check the BalancingMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string balancing_mode = 430286217;</code>
   *
   * @return The bytes for balancingMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBalancingModeBytes() {
    java.lang.Object ref = balancingMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      balancingMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAPACITY_SCALER_FIELD_NUMBER = 315958157;
  private float capacityScaler_ = 0F;

  /**
   *
   *
   * <pre>
   * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
   * </pre>
   *
   * <code>optional float capacity_scaler = 315958157;</code>
   *
   * @return Whether the capacityScaler field is set.
   */
  @java.lang.Override
  public boolean hasCapacityScaler() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
   * </pre>
   *
   * <code>optional float capacity_scaler = 315958157;</code>
   *
   * @return The capacityScaler.
   */
  @java.lang.Override
  public float getCapacityScaler() {
    return capacityScaler_;
  }

  public static final int CUSTOM_METRICS_FIELD_NUMBER = 429453813;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.BackendCustomMetric> customMetrics_;

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.BackendCustomMetric> getCustomMetricsList() {
    return customMetrics_;
  }

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.BackendCustomMetricOrBuilder>
      getCustomMetricsOrBuilderList() {
    return customMetrics_;
  }

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;</code>
   */
  @java.lang.Override
  public int getCustomMetricsCount() {
    return customMetrics_.size();
  }

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendCustomMetric getCustomMetrics(int index) {
    return customMetrics_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BackendCustomMetricOrBuilder getCustomMetricsOrBuilder(
      int index) {
    return customMetrics_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAILOVER_FIELD_NUMBER = 138892530;
  private boolean failover_ = false;

  /**
   *
   *
   * <pre>
   * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
   * </pre>
   *
   * <code>optional bool failover = 138892530;</code>
   *
   * @return Whether the failover field is set.
   */
  @java.lang.Override
  public boolean hasFailover() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
   * </pre>
   *
   * <code>optional bool failover = 138892530;</code>
   *
   * @return The failover.
   */
  @java.lang.Override
  public boolean getFailover() {
    return failover_;
  }

  public static final int GROUP_FIELD_NUMBER = 98629247;

  @SuppressWarnings("serial")
  private volatile java.lang.Object group_ = "";

  /**
   *
   *
   * <pre>
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * </pre>
   *
   * <code>optional string group = 98629247;</code>
   *
   * @return Whether the group field is set.
   */
  @java.lang.Override
  public boolean hasGroup() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * </pre>
   *
   * <code>optional string group = 98629247;</code>
   *
   * @return The group.
   */
  @java.lang.Override
  public java.lang.String getGroup() {
    java.lang.Object ref = group_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      group_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
   * </pre>
   *
   * <code>optional string group = 98629247;</code>
   *
   * @return The bytes for group.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGroupBytes() {
    java.lang.Object ref = group_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      group_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_CONNECTIONS_FIELD_NUMBER = 110652154;
  private int maxConnections_ = 0;

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections = 110652154;</code>
   *
   * @return Whether the maxConnections field is set.
   */
  @java.lang.Override
  public boolean hasMaxConnections() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections = 110652154;</code>
   *
   * @return The maxConnections.
   */
  @java.lang.Override
  public int getMaxConnections() {
    return maxConnections_;
  }

  public static final int MAX_CONNECTIONS_PER_ENDPOINT_FIELD_NUMBER = 216904604;
  private int maxConnectionsPerEndpoint_ = 0;

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
   *
   * @return Whether the maxConnectionsPerEndpoint field is set.
   */
  @java.lang.Override
  public boolean hasMaxConnectionsPerEndpoint() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
   *
   * @return The maxConnectionsPerEndpoint.
   */
  @java.lang.Override
  public int getMaxConnectionsPerEndpoint() {
    return maxConnectionsPerEndpoint_;
  }

  public static final int MAX_CONNECTIONS_PER_INSTANCE_FIELD_NUMBER = 104671900;
  private int maxConnectionsPerInstance_ = 0;

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections_per_instance = 104671900;</code>
   *
   * @return Whether the maxConnectionsPerInstance field is set.
   */
  @java.lang.Override
  public boolean hasMaxConnectionsPerInstance() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
   * </pre>
   *
   * <code>optional int32 max_connections_per_instance = 104671900;</code>
   *
   * @return The maxConnectionsPerInstance.
   */
  @java.lang.Override
  public int getMaxConnectionsPerInstance() {
    return maxConnectionsPerInstance_;
  }

  public static final int MAX_RATE_FIELD_NUMBER = 408035035;
  private int maxRate_ = 0;

  /**
   *
   *
   * <pre>
   * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional int32 max_rate = 408035035;</code>
   *
   * @return Whether the maxRate field is set.
   */
  @java.lang.Override
  public boolean hasMaxRate() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional int32 max_rate = 408035035;</code>
   *
   * @return The maxRate.
   */
  @java.lang.Override
  public int getMaxRate() {
    return maxRate_;
  }

  public static final int MAX_RATE_PER_ENDPOINT_FIELD_NUMBER = 129832283;
  private float maxRatePerEndpoint_ = 0F;

  /**
   *
   *
   * <pre>
   * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional float max_rate_per_endpoint = 129832283;</code>
   *
   * @return Whether the maxRatePerEndpoint field is set.
   */
  @java.lang.Override
  public boolean hasMaxRatePerEndpoint() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional float max_rate_per_endpoint = 129832283;</code>
   *
   * @return The maxRatePerEndpoint.
   */
  @java.lang.Override
  public float getMaxRatePerEndpoint() {
    return maxRatePerEndpoint_;
  }

  public static final int MAX_RATE_PER_INSTANCE_FIELD_NUMBER = 17599579;
  private float maxRatePerInstance_ = 0F;

  /**
   *
   *
   * <pre>
   * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional float max_rate_per_instance = 17599579;</code>
   *
   * @return Whether the maxRatePerInstance field is set.
   */
  @java.lang.Override
  public boolean hasMaxRatePerInstance() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
   * </pre>
   *
   * <code>optional float max_rate_per_instance = 17599579;</code>
   *
   * @return The maxRatePerInstance.
   */
  @java.lang.Override
  public float getMaxRatePerInstance() {
    return maxRatePerInstance_;
  }

  public static final int MAX_UTILIZATION_FIELD_NUMBER = 148192199;
  private float maxUtilization_ = 0F;

  /**
   *
   *
   * <pre>
   * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
   * </pre>
   *
   * <code>optional float max_utilization = 148192199;</code>
   *
   * @return Whether the maxUtilization field is set.
   */
  @java.lang.Override
  public boolean hasMaxUtilization() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
   * </pre>
   *
   * <code>optional float max_utilization = 148192199;</code>
   *
   * @return The maxUtilization.
   */
  @java.lang.Override
  public float getMaxUtilization() {
    return maxUtilization_;
  }

  public static final int PREFERENCE_FIELD_NUMBER = 150781147;

  @SuppressWarnings("serial")
  private volatile java.lang.Object preference_ = "";

  /**
   *
   *
   * <pre>
   * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
   * Check the Preference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string preference = 150781147;</code>
   *
   * @return Whether the preference field is set.
   */
  @java.lang.Override
  public boolean hasPreference() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
   * Check the Preference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string preference = 150781147;</code>
   *
   * @return The preference.
   */
  @java.lang.Override
  public java.lang.String getPreference() {
    java.lang.Object ref = preference_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      preference_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
   * Check the Preference enum for the list of possible values.
   * </pre>
   *
   * <code>optional string preference = 150781147;</code>
   *
   * @return The bytes for preference.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreferenceBytes() {
    java.lang.Object ref = preference_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      preference_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeFloat(17599579, maxRatePerInstance_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 98629247, group_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt32(104671900, maxConnectionsPerInstance_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(110652154, maxConnections_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeFloat(129832283, maxRatePerEndpoint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(138892530, failover_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeFloat(148192199, maxUtilization_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 150781147, preference_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(216904604, maxConnectionsPerEndpoint_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeFloat(315958157, capacityScaler_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt32(408035035, maxRate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < customMetrics_.size(); i++) {
      output.writeMessage(429453813, customMetrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 430286217, balancingMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(17599579, maxRatePerInstance_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(98629247, group_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              104671900, maxConnectionsPerInstance_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(110652154, maxConnections_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeFloatSize(129832283, maxRatePerEndpoint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(138892530, failover_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(148192199, maxUtilization_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(150781147, preference_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              216904604, maxConnectionsPerEndpoint_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(315958157, capacityScaler_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(408035035, maxRate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < customMetrics_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              429453813, customMetrics_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(430286217, balancingMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Backend)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Backend other = (com.google.cloud.compute.v1.Backend) obj;

    if (hasBalancingMode() != other.hasBalancingMode()) return false;
    if (hasBalancingMode()) {
      if (!getBalancingMode().equals(other.getBalancingMode())) return false;
    }
    if (hasCapacityScaler() != other.hasCapacityScaler()) return false;
    if (hasCapacityScaler()) {
      if (java.lang.Float.floatToIntBits(getCapacityScaler())
          != java.lang.Float.floatToIntBits(other.getCapacityScaler())) return false;
    }
    if (!getCustomMetricsList().equals(other.getCustomMetricsList())) return false;
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFailover() != other.hasFailover()) return false;
    if (hasFailover()) {
      if (getFailover() != other.getFailover()) return false;
    }
    if (hasGroup() != other.hasGroup()) return false;
    if (hasGroup()) {
      if (!getGroup().equals(other.getGroup())) return false;
    }
    if (hasMaxConnections() != other.hasMaxConnections()) return false;
    if (hasMaxConnections()) {
      if (getMaxConnections() != other.getMaxConnections()) return false;
    }
    if (hasMaxConnectionsPerEndpoint() != other.hasMaxConnectionsPerEndpoint()) return false;
    if (hasMaxConnectionsPerEndpoint()) {
      if (getMaxConnectionsPerEndpoint() != other.getMaxConnectionsPerEndpoint()) return false;
    }
    if (hasMaxConnectionsPerInstance() != other.hasMaxConnectionsPerInstance()) return false;
    if (hasMaxConnectionsPerInstance()) {
      if (getMaxConnectionsPerInstance() != other.getMaxConnectionsPerInstance()) return false;
    }
    if (hasMaxRate() != other.hasMaxRate()) return false;
    if (hasMaxRate()) {
      if (getMaxRate() != other.getMaxRate()) return false;
    }
    if (hasMaxRatePerEndpoint() != other.hasMaxRatePerEndpoint()) return false;
    if (hasMaxRatePerEndpoint()) {
      if (java.lang.Float.floatToIntBits(getMaxRatePerEndpoint())
          != java.lang.Float.floatToIntBits(other.getMaxRatePerEndpoint())) return false;
    }
    if (hasMaxRatePerInstance() != other.hasMaxRatePerInstance()) return false;
    if (hasMaxRatePerInstance()) {
      if (java.lang.Float.floatToIntBits(getMaxRatePerInstance())
          != java.lang.Float.floatToIntBits(other.getMaxRatePerInstance())) return false;
    }
    if (hasMaxUtilization() != other.hasMaxUtilization()) return false;
    if (hasMaxUtilization()) {
      if (java.lang.Float.floatToIntBits(getMaxUtilization())
          != java.lang.Float.floatToIntBits(other.getMaxUtilization())) return false;
    }
    if (hasPreference() != other.hasPreference()) return false;
    if (hasPreference()) {
      if (!getPreference().equals(other.getPreference())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBalancingMode()) {
      hash = (37 * hash) + BALANCING_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getBalancingMode().hashCode();
    }
    if (hasCapacityScaler()) {
      hash = (37 * hash) + CAPACITY_SCALER_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCapacityScaler());
    }
    if (getCustomMetricsCount() > 0) {
      hash = (37 * hash) + CUSTOM_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomMetricsList().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFailover()) {
      hash = (37 * hash) + FAILOVER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFailover());
    }
    if (hasGroup()) {
      hash = (37 * hash) + GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getGroup().hashCode();
    }
    if (hasMaxConnections()) {
      hash = (37 * hash) + MAX_CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxConnections();
    }
    if (hasMaxConnectionsPerEndpoint()) {
      hash = (37 * hash) + MAX_CONNECTIONS_PER_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxConnectionsPerEndpoint();
    }
    if (hasMaxConnectionsPerInstance()) {
      hash = (37 * hash) + MAX_CONNECTIONS_PER_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxConnectionsPerInstance();
    }
    if (hasMaxRate()) {
      hash = (37 * hash) + MAX_RATE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxRate();
    }
    if (hasMaxRatePerEndpoint()) {
      hash = (37 * hash) + MAX_RATE_PER_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMaxRatePerEndpoint());
    }
    if (hasMaxRatePerInstance()) {
      hash = (37 * hash) + MAX_RATE_PER_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMaxRatePerInstance());
    }
    if (hasMaxUtilization()) {
      hash = (37 * hash) + MAX_UTILIZATION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMaxUtilization());
    }
    if (hasPreference()) {
      hash = (37 * hash) + PREFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getPreference().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Backend parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Backend parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Backend parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Backend prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Message containing information of one individual backend.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Backend}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Backend)
      com.google.cloud.compute.v1.BackendOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Backend_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Backend_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Backend.class,
              com.google.cloud.compute.v1.Backend.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Backend.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      balancingMode_ = "";
      capacityScaler_ = 0F;
      if (customMetricsBuilder_ == null) {
        customMetrics_ = java.util.Collections.emptyList();
      } else {
        customMetrics_ = null;
        customMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      description_ = "";
      failover_ = false;
      group_ = "";
      maxConnections_ = 0;
      maxConnectionsPerEndpoint_ = 0;
      maxConnectionsPerInstance_ = 0;
      maxRate_ = 0;
      maxRatePerEndpoint_ = 0F;
      maxRatePerInstance_ = 0F;
      maxUtilization_ = 0F;
      preference_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Backend_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Backend getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Backend.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Backend build() {
      com.google.cloud.compute.v1.Backend result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Backend buildPartial() {
      com.google.cloud.compute.v1.Backend result = new com.google.cloud.compute.v1.Backend(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Backend result) {
      if (customMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          customMetrics_ = java.util.Collections.unmodifiableList(customMetrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.customMetrics_ = customMetrics_;
      } else {
        result.customMetrics_ = customMetricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Backend result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.balancingMode_ = balancingMode_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.capacityScaler_ = capacityScaler_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.failover_ = failover_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.group_ = group_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxConnections_ = maxConnections_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxConnectionsPerEndpoint_ = maxConnectionsPerEndpoint_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.maxConnectionsPerInstance_ = maxConnectionsPerInstance_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.maxRate_ = maxRate_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.maxRatePerEndpoint_ = maxRatePerEndpoint_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.maxRatePerInstance_ = maxRatePerInstance_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.maxUtilization_ = maxUtilization_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.preference_ = preference_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Backend) {
        return mergeFrom((com.google.cloud.compute.v1.Backend) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Backend other) {
      if (other == com.google.cloud.compute.v1.Backend.getDefaultInstance()) return this;
      if (other.hasBalancingMode()) {
        balancingMode_ = other.balancingMode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCapacityScaler()) {
        setCapacityScaler(other.getCapacityScaler());
      }
      if (customMetricsBuilder_ == null) {
        if (!other.customMetrics_.isEmpty()) {
          if (customMetrics_.isEmpty()) {
            customMetrics_ = other.customMetrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureCustomMetricsIsMutable();
            customMetrics_.addAll(other.customMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.customMetrics_.isEmpty()) {
          if (customMetricsBuilder_.isEmpty()) {
            customMetricsBuilder_.dispose();
            customMetricsBuilder_ = null;
            customMetrics_ = other.customMetrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            customMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCustomMetricsFieldBuilder()
                    : null;
          } else {
            customMetricsBuilder_.addAllMessages(other.customMetrics_);
          }
        }
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasFailover()) {
        setFailover(other.getFailover());
      }
      if (other.hasGroup()) {
        group_ = other.group_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasMaxConnections()) {
        setMaxConnections(other.getMaxConnections());
      }
      if (other.hasMaxConnectionsPerEndpoint()) {
        setMaxConnectionsPerEndpoint(other.getMaxConnectionsPerEndpoint());
      }
      if (other.hasMaxConnectionsPerInstance()) {
        setMaxConnectionsPerInstance(other.getMaxConnectionsPerInstance());
      }
      if (other.hasMaxRate()) {
        setMaxRate(other.getMaxRate());
      }
      if (other.hasMaxRatePerEndpoint()) {
        setMaxRatePerEndpoint(other.getMaxRatePerEndpoint());
      }
      if (other.hasMaxRatePerInstance()) {
        setMaxRatePerInstance(other.getMaxRatePerInstance());
      }
      if (other.hasMaxUtilization()) {
        setMaxUtilization(other.getMaxUtilization());
      }
      if (other.hasPreference()) {
        preference_ = other.preference_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 140796637:
              {
                maxRatePerInstance_ = input.readFloat();
                bitField0_ |= 0x00000800;
                break;
              } // case 140796637
            case 789033978:
              {
                group_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 789033978
            case 837375200:
              {
                maxConnectionsPerInstance_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 837375200
            case 885217232:
              {
                maxConnections_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 885217232
            case 1038658269:
              {
                maxRatePerEndpoint_ = input.readFloat();
                bitField0_ |= 0x00000400;
                break;
              } // case 1038658269
            case 1111140240:
              {
                failover_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 1111140240
            case 1185537597:
              {
                maxUtilization_ = input.readFloat();
                bitField0_ |= 0x00001000;
                break;
              } // case 1185537597
            case 1206249178:
              {
                preference_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1206249178
            case 1735236832:
              {
                maxConnectionsPerEndpoint_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 1735236832
            case -1767302035:
              {
                capacityScaler_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case -1767302035
            case -1030687016:
              {
                maxRate_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case -1030687016
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -859336790:
              {
                com.google.cloud.compute.v1.BackendCustomMetric m =
                    input.readMessage(
                        com.google.cloud.compute.v1.BackendCustomMetric.parser(),
                        extensionRegistry);
                if (customMetricsBuilder_ == null) {
                  ensureCustomMetricsIsMutable();
                  customMetrics_.add(m);
                } else {
                  customMetricsBuilder_.addMessage(m);
                }
                break;
              } // case -859336790
            case -852677558:
              {
                balancingMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -852677558
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object balancingMode_ = "";

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @return Whether the balancingMode field is set.
     */
    public boolean hasBalancingMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @return The balancingMode.
     */
    public java.lang.String getBalancingMode() {
      java.lang.Object ref = balancingMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        balancingMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @return The bytes for balancingMode.
     */
    public com.google.protobuf.ByteString getBalancingModeBytes() {
      java.lang.Object ref = balancingMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        balancingMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @param value The balancingMode to set.
     * @return This builder for chaining.
     */
    public Builder setBalancingMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      balancingMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBalancingMode() {
      balancingMode_ = getDefaultInstance().getBalancingMode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
     * Check the BalancingMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string balancing_mode = 430286217;</code>
     *
     * @param value The bytes for balancingMode to set.
     * @return This builder for chaining.
     */
    public Builder setBalancingModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      balancingMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private float capacityScaler_;

    /**
     *
     *
     * <pre>
     * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
     * </pre>
     *
     * <code>optional float capacity_scaler = 315958157;</code>
     *
     * @return Whether the capacityScaler field is set.
     */
    @java.lang.Override
    public boolean hasCapacityScaler() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
     * </pre>
     *
     * <code>optional float capacity_scaler = 315958157;</code>
     *
     * @return The capacityScaler.
     */
    @java.lang.Override
    public float getCapacityScaler() {
      return capacityScaler_;
    }

    /**
     *
     *
     * <pre>
     * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
     * </pre>
     *
     * <code>optional float capacity_scaler = 315958157;</code>
     *
     * @param value The capacityScaler to set.
     * @return This builder for chaining.
     */
    public Builder setCapacityScaler(float value) {

      capacityScaler_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service. Not available with backends that don't support using a balancingMode. This includes backends such as global internet NEGs, regional serverless NEGs, and PSC NEGs.
     * </pre>
     *
     * <code>optional float capacity_scaler = 315958157;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCapacityScaler() {
      bitField0_ = (bitField0_ & ~0x00000002);
      capacityScaler_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.BackendCustomMetric> customMetrics_ =
        java.util.Collections.emptyList();

    private void ensureCustomMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        customMetrics_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.BackendCustomMetric>(
                customMetrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendCustomMetric,
            com.google.cloud.compute.v1.BackendCustomMetric.Builder,
            com.google.cloud.compute.v1.BackendCustomMetricOrBuilder>
        customMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.BackendCustomMetric> getCustomMetricsList() {
      if (customMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(customMetrics_);
      } else {
        return customMetricsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public int getCustomMetricsCount() {
      if (customMetricsBuilder_ == null) {
        return customMetrics_.size();
      } else {
        return customMetricsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendCustomMetric getCustomMetrics(int index) {
      if (customMetricsBuilder_ == null) {
        return customMetrics_.get(index);
      } else {
        return customMetricsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder setCustomMetrics(
        int index, com.google.cloud.compute.v1.BackendCustomMetric value) {
      if (customMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomMetricsIsMutable();
        customMetrics_.set(index, value);
        onChanged();
      } else {
        customMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder setCustomMetrics(
        int index, com.google.cloud.compute.v1.BackendCustomMetric.Builder builderForValue) {
      if (customMetricsBuilder_ == null) {
        ensureCustomMetricsIsMutable();
        customMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        customMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder addCustomMetrics(com.google.cloud.compute.v1.BackendCustomMetric value) {
      if (customMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomMetricsIsMutable();
        customMetrics_.add(value);
        onChanged();
      } else {
        customMetricsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder addCustomMetrics(
        int index, com.google.cloud.compute.v1.BackendCustomMetric value) {
      if (customMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomMetricsIsMutable();
        customMetrics_.add(index, value);
        onChanged();
      } else {
        customMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder addCustomMetrics(
        com.google.cloud.compute.v1.BackendCustomMetric.Builder builderForValue) {
      if (customMetricsBuilder_ == null) {
        ensureCustomMetricsIsMutable();
        customMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        customMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder addCustomMetrics(
        int index, com.google.cloud.compute.v1.BackendCustomMetric.Builder builderForValue) {
      if (customMetricsBuilder_ == null) {
        ensureCustomMetricsIsMutable();
        customMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        customMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder addAllCustomMetrics(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.BackendCustomMetric> values) {
      if (customMetricsBuilder_ == null) {
        ensureCustomMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customMetrics_);
        onChanged();
      } else {
        customMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder clearCustomMetrics() {
      if (customMetricsBuilder_ == null) {
        customMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        customMetricsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public Builder removeCustomMetrics(int index) {
      if (customMetricsBuilder_ == null) {
        ensureCustomMetricsIsMutable();
        customMetrics_.remove(index);
        onChanged();
      } else {
        customMetricsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendCustomMetric.Builder getCustomMetricsBuilder(
        int index) {
      return getCustomMetricsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendCustomMetricOrBuilder getCustomMetricsOrBuilder(
        int index) {
      if (customMetricsBuilder_ == null) {
        return customMetrics_.get(index);
      } else {
        return customMetricsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.BackendCustomMetricOrBuilder>
        getCustomMetricsOrBuilderList() {
      if (customMetricsBuilder_ != null) {
        return customMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(customMetrics_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendCustomMetric.Builder addCustomMetricsBuilder() {
      return getCustomMetricsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.BackendCustomMetric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public com.google.cloud.compute.v1.BackendCustomMetric.Builder addCustomMetricsBuilder(
        int index) {
      return getCustomMetricsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.BackendCustomMetric.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of custom metrics that are used for CUSTOM_METRICS BalancingMode.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BackendCustomMetric custom_metrics = 429453813;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.BackendCustomMetric.Builder>
        getCustomMetricsBuilderList() {
      return getCustomMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BackendCustomMetric,
            com.google.cloud.compute.v1.BackendCustomMetric.Builder,
            com.google.cloud.compute.v1.BackendCustomMetricOrBuilder>
        getCustomMetricsFieldBuilder() {
      if (customMetricsBuilder_ == null) {
        customMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.BackendCustomMetric,
                com.google.cloud.compute.v1.BackendCustomMetric.Builder,
                com.google.cloud.compute.v1.BackendCustomMetricOrBuilder>(
                customMetrics_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        customMetrics_ = null;
      }
      return customMetricsBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean failover_;

    /**
     *
     *
     * <pre>
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     * </pre>
     *
     * <code>optional bool failover = 138892530;</code>
     *
     * @return Whether the failover field is set.
     */
    @java.lang.Override
    public boolean hasFailover() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     * </pre>
     *
     * <code>optional bool failover = 138892530;</code>
     *
     * @return The failover.
     */
    @java.lang.Override
    public boolean getFailover() {
      return failover_;
    }

    /**
     *
     *
     * <pre>
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     * </pre>
     *
     * <code>optional bool failover = 138892530;</code>
     *
     * @param value The failover to set.
     * @return This builder for chaining.
     */
    public Builder setFailover(boolean value) {

      failover_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     * </pre>
     *
     * <code>optional bool failover = 138892530;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailover() {
      bitField0_ = (bitField0_ & ~0x00000010);
      failover_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object group_ = "";

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @return Whether the group field is set.
     */
    public boolean hasGroup() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @return The group.
     */
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @return The bytes for group.
     */
    public com.google.protobuf.ByteString getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @param value The group to set.
     * @return This builder for chaining.
     */
    public Builder setGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      group_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroup() {
      group_ = getDefaultInstance().getGroup();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. To determine what types of backends a load balancer supports, see the [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service#backends). You must use the *fully-qualified* URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported. If haPolicy is specified, backends must refer to NEG resources of type GCE_VM_IP.
     * </pre>
     *
     * <code>optional string group = 98629247;</code>
     *
     * @param value The bytes for group to set.
     * @return This builder for chaining.
     */
    public Builder setGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      group_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int maxConnections_;

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections = 110652154;</code>
     *
     * @return Whether the maxConnections field is set.
     */
    @java.lang.Override
    public boolean hasMaxConnections() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections = 110652154;</code>
     *
     * @return The maxConnections.
     */
    @java.lang.Override
    public int getMaxConnections() {
      return maxConnections_;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections = 110652154;</code>
     *
     * @param value The maxConnections to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConnections(int value) {

      maxConnections_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections = 110652154;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxConnections() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxConnections_ = 0;
      onChanged();
      return this;
    }

    private int maxConnectionsPerEndpoint_;

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
     *
     * @return Whether the maxConnectionsPerEndpoint field is set.
     */
    @java.lang.Override
    public boolean hasMaxConnectionsPerEndpoint() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
     *
     * @return The maxConnectionsPerEndpoint.
     */
    @java.lang.Override
    public int getMaxConnectionsPerEndpoint() {
      return maxConnectionsPerEndpoint_;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
     *
     * @param value The maxConnectionsPerEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConnectionsPerEndpoint(int value) {

      maxConnectionsPerEndpoint_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_endpoint = 216904604;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxConnectionsPerEndpoint() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxConnectionsPerEndpoint_ = 0;
      onChanged();
      return this;
    }

    private int maxConnectionsPerInstance_;

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_instance = 104671900;</code>
     *
     * @return Whether the maxConnectionsPerInstance field is set.
     */
    @java.lang.Override
    public boolean hasMaxConnectionsPerInstance() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_instance = 104671900;</code>
     *
     * @return The maxConnectionsPerInstance.
     */
    @java.lang.Override
    public int getMaxConnectionsPerInstance() {
      return maxConnectionsPerInstance_;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_instance = 104671900;</code>
     *
     * @param value The maxConnectionsPerInstance to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConnectionsPerInstance(int value) {

      maxConnectionsPerInstance_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE.
     * </pre>
     *
     * <code>optional int32 max_connections_per_instance = 104671900;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxConnectionsPerInstance() {
      bitField0_ = (bitField0_ & ~0x00000100);
      maxConnectionsPerInstance_ = 0;
      onChanged();
      return this;
    }

    private int maxRate_;

    /**
     *
     *
     * <pre>
     * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional int32 max_rate = 408035035;</code>
     *
     * @return Whether the maxRate field is set.
     */
    @java.lang.Override
    public boolean hasMaxRate() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional int32 max_rate = 408035035;</code>
     *
     * @return The maxRate.
     */
    @java.lang.Override
    public int getMaxRate() {
      return maxRate_;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional int32 max_rate = 408035035;</code>
     *
     * @param value The maxRate to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRate(int value) {

      maxRate_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional int32 max_rate = 408035035;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRate() {
      bitField0_ = (bitField0_ & ~0x00000200);
      maxRate_ = 0;
      onChanged();
      return this;
    }

    private float maxRatePerEndpoint_;

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_endpoint = 129832283;</code>
     *
     * @return Whether the maxRatePerEndpoint field is set.
     */
    @java.lang.Override
    public boolean hasMaxRatePerEndpoint() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_endpoint = 129832283;</code>
     *
     * @return The maxRatePerEndpoint.
     */
    @java.lang.Override
    public float getMaxRatePerEndpoint() {
      return maxRatePerEndpoint_;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_endpoint = 129832283;</code>
     *
     * @param value The maxRatePerEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRatePerEndpoint(float value) {

      maxRatePerEndpoint_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_endpoint = 129832283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRatePerEndpoint() {
      bitField0_ = (bitField0_ & ~0x00000400);
      maxRatePerEndpoint_ = 0F;
      onChanged();
      return this;
    }

    private float maxRatePerInstance_;

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_instance = 17599579;</code>
     *
     * @return Whether the maxRatePerInstance field is set.
     */
    @java.lang.Override
    public boolean hasMaxRatePerInstance() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_instance = 17599579;</code>
     *
     * @return The maxRatePerInstance.
     */
    @java.lang.Override
    public float getMaxRatePerInstance() {
      return maxRatePerInstance_;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_instance = 17599579;</code>
     *
     * @param value The maxRatePerInstance to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRatePerInstance(float value) {

      maxRatePerInstance_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is CONNECTION.
     * </pre>
     *
     * <code>optional float max_rate_per_instance = 17599579;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRatePerInstance() {
      bitField0_ = (bitField0_ & ~0x00000800);
      maxRatePerInstance_ = 0F;
      onChanged();
      return this;
    }

    private float maxUtilization_;

    /**
     *
     *
     * <pre>
     * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
     * </pre>
     *
     * <code>optional float max_utilization = 148192199;</code>
     *
     * @return Whether the maxUtilization field is set.
     */
    @java.lang.Override
    public boolean hasMaxUtilization() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
     * </pre>
     *
     * <code>optional float max_utilization = 148192199;</code>
     *
     * @return The maxUtilization.
     */
    @java.lang.Override
    public float getMaxUtilization() {
      return maxUtilization_;
    }

    /**
     *
     *
     * <pre>
     * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
     * </pre>
     *
     * <code>optional float max_utilization = 148192199;</code>
     *
     * @param value The maxUtilization to set.
     * @return This builder for chaining.
     */
    public Builder setMaxUtilization(float value) {

      maxUtilization_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional parameter to define a target capacity for the UTILIZATION balancing mode. The valid range is [0.0, 1.0]. For usage guidelines, see Utilization balancing mode.
     * </pre>
     *
     * <code>optional float max_utilization = 148192199;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxUtilization() {
      bitField0_ = (bitField0_ & ~0x00001000);
      maxUtilization_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object preference_ = "";

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @return Whether the preference field is set.
     */
    public boolean hasPreference() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @return The preference.
     */
    public java.lang.String getPreference() {
      java.lang.Object ref = preference_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preference_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @return The bytes for preference.
     */
    public com.google.protobuf.ByteString getPreferenceBytes() {
      java.lang.Object ref = preference_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preference_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @param value The preference to set.
     * @return This builder for chaining.
     */
    public Builder setPreference(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      preference_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreference() {
      preference_ = getDefaultInstance().getPreference();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
     * Check the Preference enum for the list of possible values.
     * </pre>
     *
     * <code>optional string preference = 150781147;</code>
     *
     * @param value The bytes for preference to set.
     * @return This builder for chaining.
     */
    public Builder setPreferenceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      preference_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Backend)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Backend)
  private static final com.google.cloud.compute.v1.Backend DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Backend();
  }

  public static com.google.cloud.compute.v1.Backend getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Backend> PARSER =
      new com.google.protobuf.AbstractParser<Backend>() {
        @java.lang.Override
        public Backend parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Backend> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Backend> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Backend getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
