/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BgpRoute}
 */
public final class BgpRoute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BgpRoute)
    BgpRouteOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BgpRoute.newBuilder() to construct.
  private BgpRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BgpRoute() {
    asPaths_ = java.util.Collections.emptyList();
    communities_ = com.google.protobuf.LazyStringArrayList.emptyList();
    origin_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BgpRoute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BgpRoute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BgpRoute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BgpRoute.class,
            com.google.cloud.compute.v1.BgpRoute.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.BgpRoute.Origin}
   */
  public enum Origin implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ORIGIN = 0;</code>
     */
    UNDEFINED_ORIGIN(0),
    /** <code>BGP_ORIGIN_EGP = 378906473;</code> */
    BGP_ORIGIN_EGP(378906473),
    /** <code>BGP_ORIGIN_IGP = 378910317;</code> */
    BGP_ORIGIN_IGP(378910317),
    /** <code>BGP_ORIGIN_INCOMPLETE = 452839811;</code> */
    BGP_ORIGIN_INCOMPLETE(452839811),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ORIGIN = 0;</code>
     */
    public static final int UNDEFINED_ORIGIN_VALUE = 0;

    /** <code>BGP_ORIGIN_EGP = 378906473;</code> */
    public static final int BGP_ORIGIN_EGP_VALUE = 378906473;

    /** <code>BGP_ORIGIN_IGP = 378910317;</code> */
    public static final int BGP_ORIGIN_IGP_VALUE = 378910317;

    /** <code>BGP_ORIGIN_INCOMPLETE = 452839811;</code> */
    public static final int BGP_ORIGIN_INCOMPLETE_VALUE = 452839811;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Origin valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Origin forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ORIGIN;
        case 378906473:
          return BGP_ORIGIN_EGP;
        case 378910317:
          return BGP_ORIGIN_IGP;
        case 452839811:
          return BGP_ORIGIN_INCOMPLETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Origin> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Origin> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Origin>() {
          public Origin findValueByNumber(int number) {
            return Origin.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.BgpRoute.getDescriptor().getEnumTypes().get(0);
    }

    private static final Origin[] VALUES = values();

    public static Origin valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Origin(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.BgpRoute.Origin)
  }

  private int bitField0_;
  public static final int AS_PATHS_FIELD_NUMBER = 137568929;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.BgpRouteAsPath> asPaths_;

  /**
   *
   *
   * <pre>
   * [Output only] AS-PATH for the route
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.BgpRouteAsPath> getAsPathsList() {
    return asPaths_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] AS-PATH for the route
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder>
      getAsPathsOrBuilderList() {
    return asPaths_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] AS-PATH for the route
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public int getAsPathsCount() {
    return asPaths_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output only] AS-PATH for the route
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BgpRouteAsPath getAsPaths(int index) {
    return asPaths_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output only] AS-PATH for the route
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder getAsPathsOrBuilder(int index) {
    return asPaths_.get(index);
  }

  public static final int COMMUNITIES_FIELD_NUMBER = 188262983;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList communities_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output only] BGP communities in human-readable A:B format.
   * </pre>
   *
   * <code>repeated string communities = 188262983;</code>
   *
   * @return A list containing the communities.
   */
  public com.google.protobuf.ProtocolStringList getCommunitiesList() {
    return communities_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP communities in human-readable A:B format.
   * </pre>
   *
   * <code>repeated string communities = 188262983;</code>
   *
   * @return The count of communities.
   */
  public int getCommunitiesCount() {
    return communities_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP communities in human-readable A:B format.
   * </pre>
   *
   * <code>repeated string communities = 188262983;</code>
   *
   * @param index The index of the element to return.
   * @return The communities at the given index.
   */
  public java.lang.String getCommunities(int index) {
    return communities_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP communities in human-readable A:B format.
   * </pre>
   *
   * <code>repeated string communities = 188262983;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the communities at the given index.
   */
  public com.google.protobuf.ByteString getCommunitiesBytes(int index) {
    return communities_.getByteString(index);
  }

  public static final int DESTINATION_FIELD_NUMBER = 180765710;
  private com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination_;

  /**
   *
   *
   * <pre>
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation getDestination() {
    return destination_ == null
        ? com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
            .getDefaultInstance()
        : destination_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] Destination IP range for the route, in human-readable CIDR format
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformationOrBuilder
      getDestinationOrBuilder() {
    return destination_ == null
        ? com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
            .getDefaultInstance()
        : destination_;
  }

  public static final int MED_FIELD_NUMBER = 107980;
  private int med_ = 0;

  /**
   *
   *
   * <pre>
   * [Output only] BGP multi-exit discriminator
   * </pre>
   *
   * <code>optional uint32 med = 107980;</code>
   *
   * @return Whether the med field is set.
   */
  @java.lang.Override
  public boolean hasMed() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP multi-exit discriminator
   * </pre>
   *
   * <code>optional uint32 med = 107980;</code>
   *
   * @return The med.
   */
  @java.lang.Override
  public int getMed() {
    return med_;
  }

  public static final int ORIGIN_FIELD_NUMBER = 65122086;

  @SuppressWarnings("serial")
  private volatile java.lang.Object origin_ = "";

  /**
   *
   *
   * <pre>
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * Check the Origin enum for the list of possible values.
   * </pre>
   *
   * <code>optional string origin = 65122086;</code>
   *
   * @return Whether the origin field is set.
   */
  @java.lang.Override
  public boolean hasOrigin() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * Check the Origin enum for the list of possible values.
   * </pre>
   *
   * <code>optional string origin = 65122086;</code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public java.lang.String getOrigin() {
    java.lang.Object ref = origin_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      origin_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
   * Check the Origin enum for the list of possible values.
   * </pre>
   *
   * <code>optional string origin = 65122086;</code>
   *
   * @return The bytes for origin.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOriginBytes() {
    java.lang.Object ref = origin_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      origin_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt32(107980, med_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 65122086, origin_);
    }
    for (int i = 0; i < asPaths_.size(); i++) {
      output.writeMessage(137568929, asPaths_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(180765710, getDestination());
    }
    for (int i = 0; i < communities_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 188262983, communities_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(107980, med_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(65122086, origin_);
    }
    for (int i = 0; i < asPaths_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(137568929, asPaths_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(180765710, getDestination());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < communities_.size(); i++) {
        dataSize += computeStringSizeNoTag(communities_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getCommunitiesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BgpRoute)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BgpRoute other = (com.google.cloud.compute.v1.BgpRoute) obj;

    if (!getAsPathsList().equals(other.getAsPathsList())) return false;
    if (!getCommunitiesList().equals(other.getCommunitiesList())) return false;
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (hasMed() != other.hasMed()) return false;
    if (hasMed()) {
      if (getMed() != other.getMed()) return false;
    }
    if (hasOrigin() != other.hasOrigin()) return false;
    if (hasOrigin()) {
      if (!getOrigin().equals(other.getOrigin())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAsPathsCount() > 0) {
      hash = (37 * hash) + AS_PATHS_FIELD_NUMBER;
      hash = (53 * hash) + getAsPathsList().hashCode();
    }
    if (getCommunitiesCount() > 0) {
      hash = (37 * hash) + COMMUNITIES_FIELD_NUMBER;
      hash = (53 * hash) + getCommunitiesList().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (hasMed()) {
      hash = (37 * hash) + MED_FIELD_NUMBER;
      hash = (53 * hash) + getMed();
    }
    if (hasOrigin()) {
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BgpRoute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.BgpRoute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BgpRoute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BgpRoute)
      com.google.cloud.compute.v1.BgpRouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BgpRoute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BgpRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BgpRoute.class,
              com.google.cloud.compute.v1.BgpRoute.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BgpRoute.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAsPathsFieldBuilder();
        getDestinationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (asPathsBuilder_ == null) {
        asPaths_ = java.util.Collections.emptyList();
      } else {
        asPaths_ = null;
        asPathsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      communities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      med_ = 0;
      origin_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BgpRoute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BgpRoute getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BgpRoute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BgpRoute build() {
      com.google.cloud.compute.v1.BgpRoute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BgpRoute buildPartial() {
      com.google.cloud.compute.v1.BgpRoute result = new com.google.cloud.compute.v1.BgpRoute(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.BgpRoute result) {
      if (asPathsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          asPaths_ = java.util.Collections.unmodifiableList(asPaths_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.asPaths_ = asPaths_;
      } else {
        result.asPaths_ = asPathsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.BgpRoute result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        communities_.makeImmutable();
        result.communities_ = communities_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.med_ = med_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.origin_ = origin_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BgpRoute) {
        return mergeFrom((com.google.cloud.compute.v1.BgpRoute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.BgpRoute other) {
      if (other == com.google.cloud.compute.v1.BgpRoute.getDefaultInstance()) return this;
      if (asPathsBuilder_ == null) {
        if (!other.asPaths_.isEmpty()) {
          if (asPaths_.isEmpty()) {
            asPaths_ = other.asPaths_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAsPathsIsMutable();
            asPaths_.addAll(other.asPaths_);
          }
          onChanged();
        }
      } else {
        if (!other.asPaths_.isEmpty()) {
          if (asPathsBuilder_.isEmpty()) {
            asPathsBuilder_.dispose();
            asPathsBuilder_ = null;
            asPaths_ = other.asPaths_;
            bitField0_ = (bitField0_ & ~0x00000001);
            asPathsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAsPathsFieldBuilder()
                    : null;
          } else {
            asPathsBuilder_.addAllMessages(other.asPaths_);
          }
        }
      }
      if (!other.communities_.isEmpty()) {
        if (communities_.isEmpty()) {
          communities_ = other.communities_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCommunitiesIsMutable();
          communities_.addAll(other.communities_);
        }
        onChanged();
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (other.hasMed()) {
        setMed(other.getMed());
      }
      if (other.hasOrigin()) {
        origin_ = other.origin_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 863840:
              {
                med_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 863840
            case 520976690:
              {
                origin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 520976690
            case 1100551434:
              {
                com.google.cloud.compute.v1.BgpRouteAsPath m =
                    input.readMessage(
                        com.google.cloud.compute.v1.BgpRouteAsPath.parser(), extensionRegistry);
                if (asPathsBuilder_ == null) {
                  ensureAsPathsIsMutable();
                  asPaths_.add(m);
                } else {
                  asPathsBuilder_.addMessage(m);
                }
                break;
              } // case 1100551434
            case 1446125682:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 1446125682
            case 1506103866:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCommunitiesIsMutable();
                communities_.add(s);
                break;
              } // case 1506103866
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.BgpRouteAsPath> asPaths_ =
        java.util.Collections.emptyList();

    private void ensureAsPathsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        asPaths_ = new java.util.ArrayList<com.google.cloud.compute.v1.BgpRouteAsPath>(asPaths_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BgpRouteAsPath,
            com.google.cloud.compute.v1.BgpRouteAsPath.Builder,
            com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder>
        asPathsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.BgpRouteAsPath> getAsPathsList() {
      if (asPathsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(asPaths_);
      } else {
        return asPathsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public int getAsPathsCount() {
      if (asPathsBuilder_ == null) {
        return asPaths_.size();
      } else {
        return asPathsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.BgpRouteAsPath getAsPaths(int index) {
      if (asPathsBuilder_ == null) {
        return asPaths_.get(index);
      } else {
        return asPathsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder setAsPaths(int index, com.google.cloud.compute.v1.BgpRouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.set(index, value);
        onChanged();
      } else {
        asPathsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder setAsPaths(
        int index, com.google.cloud.compute.v1.BgpRouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.set(index, builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(com.google.cloud.compute.v1.BgpRouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.add(value);
        onChanged();
      } else {
        asPathsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(int index, com.google.cloud.compute.v1.BgpRouteAsPath value) {
      if (asPathsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsPathsIsMutable();
        asPaths_.add(index, value);
        onChanged();
      } else {
        asPathsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(com.google.cloud.compute.v1.BgpRouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.add(builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAsPaths(
        int index, com.google.cloud.compute.v1.BgpRouteAsPath.Builder builderForValue) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.add(index, builderForValue.build());
        onChanged();
      } else {
        asPathsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder addAllAsPaths(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.BgpRouteAsPath> values) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, asPaths_);
        onChanged();
      } else {
        asPathsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder clearAsPaths() {
      if (asPathsBuilder_ == null) {
        asPaths_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        asPathsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public Builder removeAsPaths(int index) {
      if (asPathsBuilder_ == null) {
        ensureAsPathsIsMutable();
        asPaths_.remove(index);
        onChanged();
      } else {
        asPathsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.BgpRouteAsPath.Builder getAsPathsBuilder(int index) {
      return getAsPathsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder getAsPathsOrBuilder(int index) {
      if (asPathsBuilder_ == null) {
        return asPaths_.get(index);
      } else {
        return asPathsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder>
        getAsPathsOrBuilderList() {
      if (asPathsBuilder_ != null) {
        return asPathsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(asPaths_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.BgpRouteAsPath.Builder addAsPathsBuilder() {
      return getAsPathsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.BgpRouteAsPath.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public com.google.cloud.compute.v1.BgpRouteAsPath.Builder addAsPathsBuilder(int index) {
      return getAsPathsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.BgpRouteAsPath.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output only] AS-PATH for the route
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.BgpRouteAsPath as_paths = 137568929;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.BgpRouteAsPath.Builder>
        getAsPathsBuilderList() {
      return getAsPathsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.BgpRouteAsPath,
            com.google.cloud.compute.v1.BgpRouteAsPath.Builder,
            com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder>
        getAsPathsFieldBuilder() {
      if (asPathsBuilder_ == null) {
        asPathsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.BgpRouteAsPath,
                com.google.cloud.compute.v1.BgpRouteAsPath.Builder,
                com.google.cloud.compute.v1.BgpRouteAsPathOrBuilder>(
                asPaths_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        asPaths_ = null;
      }
      return asPathsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList communities_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCommunitiesIsMutable() {
      if (!communities_.isModifiable()) {
        communities_ = new com.google.protobuf.LazyStringArrayList(communities_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @return A list containing the communities.
     */
    public com.google.protobuf.ProtocolStringList getCommunitiesList() {
      communities_.makeImmutable();
      return communities_;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @return The count of communities.
     */
    public int getCommunitiesCount() {
      return communities_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param index The index of the element to return.
     * @return The communities at the given index.
     */
    public java.lang.String getCommunities(int index) {
      return communities_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the communities at the given index.
     */
    public com.google.protobuf.ByteString getCommunitiesBytes(int index) {
      return communities_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param index The index to set the value at.
     * @param value The communities to set.
     * @return This builder for chaining.
     */
    public Builder setCommunities(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommunitiesIsMutable();
      communities_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param value The communities to add.
     * @return This builder for chaining.
     */
    public Builder addCommunities(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommunitiesIsMutable();
      communities_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param values The communities to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommunities(java.lang.Iterable<java.lang.String> values) {
      ensureCommunitiesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, communities_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommunities() {
      communities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP communities in human-readable A:B format.
     * </pre>
     *
     * <code>repeated string communities = 188262983;</code>
     *
     * @param value The bytes of the communities to add.
     * @return This builder for chaining.
     */
    public Builder addCommunitiesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommunitiesIsMutable();
      communities_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation,
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation.Builder,
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformationOrBuilder>
        destinationBuilder_;

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     *
     * @return The destination.
     */
    public com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
        getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
                .getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public Builder setDestination(
        com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public Builder setDestination(
        com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation.Builder
            builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public Builder mergeDestination(
        com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && destination_ != null
            && destination_
                != com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
                    .getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      if (destination_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000004);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation.Builder
        getDestinationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    public com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformationOrBuilder
        getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation
                .getDefaultInstance()
            : destination_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Destination IP range for the route, in human-readable CIDR format
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation destination = 180765710;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation,
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation.Builder,
            com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformationOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation,
                com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformation.Builder,
                com.google.cloud.compute.v1.BgpRouteNetworkLayerReachabilityInformationOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private int med_;

    /**
     *
     *
     * <pre>
     * [Output only] BGP multi-exit discriminator
     * </pre>
     *
     * <code>optional uint32 med = 107980;</code>
     *
     * @return Whether the med field is set.
     */
    @java.lang.Override
    public boolean hasMed() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP multi-exit discriminator
     * </pre>
     *
     * <code>optional uint32 med = 107980;</code>
     *
     * @return The med.
     */
    @java.lang.Override
    public int getMed() {
      return med_;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP multi-exit discriminator
     * </pre>
     *
     * <code>optional uint32 med = 107980;</code>
     *
     * @param value The med to set.
     * @return This builder for chaining.
     */
    public Builder setMed(int value) {

      med_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP multi-exit discriminator
     * </pre>
     *
     * <code>optional uint32 med = 107980;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMed() {
      bitField0_ = (bitField0_ & ~0x00000008);
      med_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object origin_ = "";

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @return Whether the origin field is set.
     */
    public boolean hasOrigin() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @return The origin.
     */
    public java.lang.String getOrigin() {
      java.lang.Object ref = origin_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        origin_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @return The bytes for origin.
     */
    public com.google.protobuf.ByteString getOriginBytes() {
      java.lang.Object ref = origin_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        origin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @param value The origin to set.
     * @return This builder for chaining.
     */
    public Builder setOrigin(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      origin_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrigin() {
      origin_ = getDefaultInstance().getOrigin();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] BGP origin (EGP, IGP or INCOMPLETE)
     * Check the Origin enum for the list of possible values.
     * </pre>
     *
     * <code>optional string origin = 65122086;</code>
     *
     * @param value The bytes for origin to set.
     * @return This builder for chaining.
     */
    public Builder setOriginBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      origin_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BgpRoute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BgpRoute)
  private static final com.google.cloud.compute.v1.BgpRoute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BgpRoute();
  }

  public static com.google.cloud.compute.v1.BgpRoute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BgpRoute> PARSER =
      new com.google.protobuf.AbstractParser<BgpRoute>() {
        @java.lang.Override
        public BgpRoute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BgpRoute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BgpRoute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BgpRoute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
