/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

public interface CommitmentOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Commitment)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Specifies whether to automatically renew the commitment at the end of its current term. The default value is false. If you set the field to true, each time your commitment reaches the end of its term, Compute Engine automatically renews it for another term. You can update this field anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return Whether the autoRenew field is set.
   */
  boolean hasAutoRenew();

  /**
   *
   *
   * <pre>
   * Specifies whether to automatically renew the commitment at the end of its current term. The default value is false. If you set the field to true, each time your commitment reaches the end of its term, Compute Engine automatically renews it for another term. You can update this field anytime before the commitment expires. For example, if the commitment is set to expire at 12 AM UTC-8 on January 3, 2027, you can update this field until 11:59 PM UTC-8 on January 2, 2027.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return The autoRenew.
   */
  boolean getAutoRenew();

  /**
   *
   *
   * <pre>
   * The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return Whether the category field is set.
   */
  boolean hasCategory();

  /**
   *
   *
   * <pre>
   * The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The category.
   */
  java.lang.String getCategory();

  /**
   *
   *
   * <pre>
   * The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The bytes for category.
   */
  com.google.protobuf.ByteString getCategoryBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Input Only] Optional, specifies the requested commitment end time in RFC3339 text format. Use this option when the desired commitment's end date is later than the start date + term duration.
   * </pre>
   *
   * <code>optional string custom_end_timestamp = 181770852;</code>
   *
   * @return Whether the customEndTimestamp field is set.
   */
  boolean hasCustomEndTimestamp();

  /**
   *
   *
   * <pre>
   * [Input Only] Optional, specifies the requested commitment end time in RFC3339 text format. Use this option when the desired commitment's end date is later than the start date + term duration.
   * </pre>
   *
   * <code>optional string custom_end_timestamp = 181770852;</code>
   *
   * @return The customEndTimestamp.
   */
  java.lang.String getCustomEndTimestamp();

  /**
   *
   *
   * <pre>
   * [Input Only] Optional, specifies the requested commitment end time in RFC3339 text format. Use this option when the desired commitment's end date is later than the start date + term duration.
   * </pre>
   *
   * <code>optional string custom_end_timestamp = 181770852;</code>
   *
   * @return The bytes for customEndTimestamp.
   */
  com.google.protobuf.ByteString getCustomEndTimestampBytes();

  /**
   *
   *
   * <pre>
   * An optional description of the commitment. You can provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of the commitment. You can provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of the commitment. You can provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return Whether the endTimestamp field is set.
   */
  boolean hasEndTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The endTimestamp.
   */
  java.lang.String getEndTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The bytes for endTimestamp.
   */
  com.google.protobuf.ByteString getEndTimestampBytes();

  /**
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @return A list containing the existingReservations.
   */
  java.util.List<java.lang.String> getExistingReservationsList();

  /**
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @return The count of existingReservations.
   */
  int getExistingReservationsCount();

  /**
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @param index The index of the element to return.
   * @return The existingReservations at the given index.
   */
  java.lang.String getExistingReservations(int index);

  /**
   * <code>repeated string existing_reservations = 493028443;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the existingReservations at the given index.
   */
  com.google.protobuf.ByteString getExistingReservationsBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return Whether the licenseResource field is set.
   */
  boolean hasLicenseResource();

  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return The licenseResource.
   */
  com.google.cloud.compute.v1.LicenseResourceCommitment getLicenseResource();

  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   */
  com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder getLicenseResourceOrBuilder();

  /**
   *
   *
   * <pre>
   * The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return A list containing the mergeSourceCommitments.
   */
  java.util.List<java.lang.String> getMergeSourceCommitmentsList();

  /**
   *
   *
   * <pre>
   * The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return The count of mergeSourceCommitments.
   */
  int getMergeSourceCommitmentsCount();

  /**
   *
   *
   * <pre>
   * The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the element to return.
   * @return The mergeSourceCommitments at the given index.
   */
  java.lang.String getMergeSourceCommitments(int index);

  /**
   *
   *
   * <pre>
   * The list of source commitments that you are merging to create the new merged commitment. For more information, see Merging commitments.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the mergeSourceCommitments at the given index.
   */
  com.google.protobuf.ByteString getMergeSourceCommitmentsBytes(int index);

  /**
   *
   *
   * <pre>
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the commitment. You must specify a name when you purchase the commitment. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return Whether the plan field is set.
   */
  boolean hasPlan();

  /**
   *
   *
   * <pre>
   * The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The plan.
   */
  java.lang.String getPlan();

  /**
   *
   *
   * <pre>
   * The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The bytes for plan.
   */
  com.google.protobuf.ByteString getPlanBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  boolean hasRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the commitment and committed resources are located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  java.util.List<com.google.cloud.compute.v1.Reservation> getReservationsList();

  /**
   *
   *
   * <pre>
   * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  com.google.cloud.compute.v1.Reservation getReservations(int index);

  /**
   *
   *
   * <pre>
   * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  int getReservationsCount();

  /**
   *
   *
   * <pre>
   * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ReservationOrBuilder>
      getReservationsOrBuilderList();

  /**
   *
   *
   * <pre>
   * The list of new reservations that you want to create and attach to this commitment. You must attach reservations to your commitment if your commitment specifies any GPUs or Local SSD disks. For more information, see Attach reservations to resource-based commitments. Specify this property only if you want to create new reservations to attach. To attach existing reservations, specify the existingReservations property instead.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  com.google.cloud.compute.v1.ReservationOrBuilder getReservationsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Commitment resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CommitmentResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return Whether the resourceStatus field is set.
   */
  boolean hasResourceStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Commitment resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CommitmentResourceStatus resource_status = 249429315;
   * </code>
   *
   * @return The resourceStatus.
   */
  com.google.cloud.compute.v1.CommitmentResourceStatus getResourceStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for Commitment resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CommitmentResourceStatus resource_status = 249429315;
   * </code>
   */
  com.google.cloud.compute.v1.CommitmentResourceStatusOrBuilder getResourceStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  java.util.List<com.google.cloud.compute.v1.ResourceCommitment> getResourcesList();

  /**
   *
   *
   * <pre>
   * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  com.google.cloud.compute.v1.ResourceCommitment getResources(int index);

  /**
   *
   *
   * <pre>
   * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  int getResourcesCount();

  /**
   *
   *
   * <pre>
   * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
      getResourcesOrBuilderList();

  /**
   *
   *
   * <pre>
   * The list of all the hardware resources, with their types and amounts, that you want to commit to. Specify as a separate entry in the list for each individual resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  com.google.cloud.compute.v1.ResourceCommitmentOrBuilder getResourcesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * The source commitment from which you are transferring resources to create the new split commitment. For more information, see Split commitments.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return Whether the splitSourceCommitment field is set.
   */
  boolean hasSplitSourceCommitment();

  /**
   *
   *
   * <pre>
   * The source commitment from which you are transferring resources to create the new split commitment. For more information, see Split commitments.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The splitSourceCommitment.
   */
  java.lang.String getSplitSourceCommitment();

  /**
   *
   *
   * <pre>
   * The source commitment from which you are transferring resources to create the new split commitment. For more information, see Split commitments.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The bytes for splitSourceCommitment.
   */
  com.google.protobuf.ByteString getSplitSourceCommitmentBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return Whether the startTimestamp field is set.
   */
  boolean hasStartTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The startTimestamp.
   */
  java.lang.String getStartTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The bytes for startTimestamp.
   */
  com.google.protobuf.ByteString getStartTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  java.lang.String getStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  com.google.protobuf.ByteString getStatusBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  boolean hasStatusMessage();

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  java.lang.String getStatusMessage();

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  com.google.protobuf.ByteString getStatusMessageBytes();

  /**
   *
   *
   * <pre>
   * The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  boolean hasType();

  /**
   *
   *
   * <pre>
   * The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  java.lang.String getType();

  /**
   *
   *
   * <pre>
   * The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();
}
