/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Specifies the custom error response policy that must be applied when the backend service or backend bucket responds with an error.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.CustomErrorResponsePolicy}
 */
public final class CustomErrorResponsePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.CustomErrorResponsePolicy)
    CustomErrorResponsePolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CustomErrorResponsePolicy.newBuilder() to construct.
  private CustomErrorResponsePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomErrorResponsePolicy() {
    errorResponseRules_ = java.util.Collections.emptyList();
    errorService_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomErrorResponsePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CustomErrorResponsePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_CustomErrorResponsePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.CustomErrorResponsePolicy.class,
            com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder.class);
  }

  private int bitField0_;
  public static final int ERROR_RESPONSE_RULES_FIELD_NUMBER = 14620304;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>
      errorResponseRules_;

  /**
   *
   *
   * <pre>
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>
      getErrorResponseRulesList() {
    return errorResponseRules_;
  }

  /**
   *
   *
   * <pre>
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder>
      getErrorResponseRulesOrBuilderList() {
    return errorResponseRules_;
  }

  /**
   *
   *
   * <pre>
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
   * </code>
   */
  @java.lang.Override
  public int getErrorResponseRulesCount() {
    return errorResponseRules_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
      getErrorResponseRules(int index) {
    return errorResponseRules_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder
      getErrorResponseRulesOrBuilder(int index) {
    return errorResponseRules_.get(index);
  }

  public static final int ERROR_SERVICE_FIELD_NUMBER = 164214654;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorService_ = "";

  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
   * </pre>
   *
   * <code>optional string error_service = 164214654;</code>
   *
   * @return Whether the errorService field is set.
   */
  @java.lang.Override
  public boolean hasErrorService() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
   * </pre>
   *
   * <code>optional string error_service = 164214654;</code>
   *
   * @return The errorService.
   */
  @java.lang.Override
  public java.lang.String getErrorService() {
    java.lang.Object ref = errorService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
   * </pre>
   *
   * <code>optional string error_service = 164214654;</code>
   *
   * @return The bytes for errorService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorServiceBytes() {
    java.lang.Object ref = errorService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < errorResponseRules_.size(); i++) {
      output.writeMessage(14620304, errorResponseRules_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 164214654, errorService_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < errorResponseRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14620304, errorResponseRules_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(164214654, errorService_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.CustomErrorResponsePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.CustomErrorResponsePolicy other =
        (com.google.cloud.compute.v1.CustomErrorResponsePolicy) obj;

    if (!getErrorResponseRulesList().equals(other.getErrorResponseRulesList())) return false;
    if (hasErrorService() != other.hasErrorService()) return false;
    if (hasErrorService()) {
      if (!getErrorService().equals(other.getErrorService())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getErrorResponseRulesCount() > 0) {
      hash = (37 * hash) + ERROR_RESPONSE_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getErrorResponseRulesList().hashCode();
    }
    if (hasErrorService()) {
      hash = (37 * hash) + ERROR_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorService().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.CustomErrorResponsePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specifies the custom error response policy that must be applied when the backend service or backend bucket responds with an error.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.CustomErrorResponsePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.CustomErrorResponsePolicy)
      com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CustomErrorResponsePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CustomErrorResponsePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.CustomErrorResponsePolicy.class,
              com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.CustomErrorResponsePolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (errorResponseRulesBuilder_ == null) {
        errorResponseRules_ = java.util.Collections.emptyList();
      } else {
        errorResponseRules_ = null;
        errorResponseRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      errorService_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_CustomErrorResponsePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CustomErrorResponsePolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CustomErrorResponsePolicy build() {
      com.google.cloud.compute.v1.CustomErrorResponsePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.CustomErrorResponsePolicy buildPartial() {
      com.google.cloud.compute.v1.CustomErrorResponsePolicy result =
          new com.google.cloud.compute.v1.CustomErrorResponsePolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.CustomErrorResponsePolicy result) {
      if (errorResponseRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          errorResponseRules_ = java.util.Collections.unmodifiableList(errorResponseRules_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.errorResponseRules_ = errorResponseRules_;
      } else {
        result.errorResponseRules_ = errorResponseRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.CustomErrorResponsePolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorService_ = errorService_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.CustomErrorResponsePolicy) {
        return mergeFrom((com.google.cloud.compute.v1.CustomErrorResponsePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.CustomErrorResponsePolicy other) {
      if (other == com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance())
        return this;
      if (errorResponseRulesBuilder_ == null) {
        if (!other.errorResponseRules_.isEmpty()) {
          if (errorResponseRules_.isEmpty()) {
            errorResponseRules_ = other.errorResponseRules_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureErrorResponseRulesIsMutable();
            errorResponseRules_.addAll(other.errorResponseRules_);
          }
          onChanged();
        }
      } else {
        if (!other.errorResponseRules_.isEmpty()) {
          if (errorResponseRulesBuilder_.isEmpty()) {
            errorResponseRulesBuilder_.dispose();
            errorResponseRulesBuilder_ = null;
            errorResponseRules_ = other.errorResponseRules_;
            bitField0_ = (bitField0_ & ~0x00000001);
            errorResponseRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorResponseRulesFieldBuilder()
                    : null;
          } else {
            errorResponseRulesBuilder_.addAllMessages(other.errorResponseRules_);
          }
        }
      }
      if (other.hasErrorService()) {
        errorService_ = other.errorService_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 116962434:
              {
                com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
                            .parser(),
                        extensionRegistry);
                if (errorResponseRulesBuilder_ == null) {
                  ensureErrorResponseRulesIsMutable();
                  errorResponseRules_.add(m);
                } else {
                  errorResponseRulesBuilder_.addMessage(m);
                }
                break;
              } // case 116962434
            case 1313717234:
              {
                errorService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1313717234
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>
        errorResponseRules_ = java.util.Collections.emptyList();

    private void ensureErrorResponseRulesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        errorResponseRules_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>(
                errorResponseRules_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder>
        errorResponseRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>
        getErrorResponseRulesList() {
      if (errorResponseRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errorResponseRules_);
      } else {
        return errorResponseRulesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public int getErrorResponseRulesCount() {
      if (errorResponseRulesBuilder_ == null) {
        return errorResponseRules_.size();
      } else {
        return errorResponseRulesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
        getErrorResponseRules(int index) {
      if (errorResponseRulesBuilder_ == null) {
        return errorResponseRules_.get(index);
      } else {
        return errorResponseRulesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder setErrorResponseRules(
        int index,
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule value) {
      if (errorResponseRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.set(index, value);
        onChanged();
      } else {
        errorResponseRulesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder setErrorResponseRules(
        int index,
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
            builderForValue) {
      if (errorResponseRulesBuilder_ == null) {
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorResponseRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder addErrorResponseRules(
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule value) {
      if (errorResponseRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.add(value);
        onChanged();
      } else {
        errorResponseRulesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder addErrorResponseRules(
        int index,
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule value) {
      if (errorResponseRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.add(index, value);
        onChanged();
      } else {
        errorResponseRulesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder addErrorResponseRules(
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
            builderForValue) {
      if (errorResponseRulesBuilder_ == null) {
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.add(builderForValue.build());
        onChanged();
      } else {
        errorResponseRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder addErrorResponseRules(
        int index,
        com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
            builderForValue) {
      if (errorResponseRulesBuilder_ == null) {
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorResponseRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder addAllErrorResponseRules(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule>
            values) {
      if (errorResponseRulesBuilder_ == null) {
        ensureErrorResponseRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errorResponseRules_);
        onChanged();
      } else {
        errorResponseRulesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder clearErrorResponseRules() {
      if (errorResponseRulesBuilder_ == null) {
        errorResponseRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        errorResponseRulesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public Builder removeErrorResponseRules(int index) {
      if (errorResponseRulesBuilder_ == null) {
        ensureErrorResponseRulesIsMutable();
        errorResponseRules_.remove(index);
        onChanged();
      } else {
        errorResponseRulesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
        getErrorResponseRulesBuilder(int index) {
      return getErrorResponseRulesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder
        getErrorResponseRulesOrBuilder(int index) {
      if (errorResponseRulesBuilder_ == null) {
        return errorResponseRules_.get(index);
      } else {
        return errorResponseRulesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder>
        getErrorResponseRulesOrBuilderList() {
      if (errorResponseRulesBuilder_ != null) {
        return errorResponseRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errorResponseRules_);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
        addErrorResponseRulesBuilder() {
      return getErrorResponseRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder
        addErrorResponseRulesBuilder(int index) {
      return getErrorResponseRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Specifies rules for returning error responses. In a given policy, if you specify rules for both a range of error codes as well as rules for specific error codes then rules with specific error codes have a higher priority. For example, assume that you configure a rule for 401 (Un-authorized) code, and another for all 4 series error codes (4XX). If the backend service returns a 401, then the rule for 401 will be applied. However if the backend service returns a 403, the rule for 4xx takes effect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule error_response_rules = 14620304;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder>
        getErrorResponseRulesBuilderList() {
      return getErrorResponseRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule.Builder,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder>
        getErrorResponseRulesFieldBuilder() {
      if (errorResponseRulesBuilder_ == null) {
        errorResponseRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule,
                com.google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule
                    .Builder,
                com.google.cloud.compute.v1
                    .CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder>(
                errorResponseRules_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        errorResponseRules_ = null;
      }
      return errorResponseRulesBuilder_;
    }

    private java.lang.Object errorService_ = "";

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @return Whether the errorService field is set.
     */
    public boolean hasErrorService() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @return The errorService.
     */
    public java.lang.String getErrorService() {
      java.lang.Object ref = errorService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @return The bytes for errorService.
     */
    public com.google.protobuf.ByteString getErrorServiceBytes() {
      java.lang.Object ref = errorService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @param value The errorService to set.
     * @return This builder for chaining.
     */
    public Builder setErrorService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorService() {
      errorService_ = getDefaultInstance().getErrorService();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the BackendBucket resource that contains the custom error content. Examples are: - https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket - compute/v1/projects/project/global/backendBuckets/myBackendBucket - global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more errorResponseRules[], it must specify errorService. If load balancer cannot reach the backendBucket, a simple Not Found Error will be returned, with the original response code (or overrideResponseCode if configured). errorService is not supported for internal or regional HTTP/HTTPS load balancers.
     * </pre>
     *
     * <code>optional string error_service = 164214654;</code>
     *
     * @param value The bytes for errorService to set.
     * @return This builder for chaining.
     */
    public Builder setErrorServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.CustomErrorResponsePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.CustomErrorResponsePolicy)
  private static final com.google.cloud.compute.v1.CustomErrorResponsePolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.CustomErrorResponsePolicy();
  }

  public static com.google.cloud.compute.v1.CustomErrorResponsePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomErrorResponsePolicy> PARSER =
      new com.google.protobuf.AbstractParser<CustomErrorResponsePolicy>() {
        @java.lang.Override
        public CustomErrorResponsePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomErrorResponsePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomErrorResponsePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.CustomErrorResponsePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
