/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

public interface DiskOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.Disk)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
   * Check the AccessMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string access_mode = 41155486;</code>
   *
   * @return Whether the accessMode field is set.
   */
  boolean hasAccessMode();

  /**
   *
   *
   * <pre>
   * The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
   * Check the AccessMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string access_mode = 41155486;</code>
   *
   * @return The accessMode.
   */
  java.lang.String getAccessMode();

  /**
   *
   *
   * <pre>
   * The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
   * Check the AccessMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string access_mode = 41155486;</code>
   *
   * @return The bytes for accessMode.
   */
  com.google.protobuf.ByteString getAccessModeBytes();

  /**
   *
   *
   * <pre>
   * The architecture of the disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  boolean hasArchitecture();

  /**
   *
   *
   * <pre>
   * The architecture of the disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  java.lang.String getArchitecture();

  /**
   *
   *
   * <pre>
   * The architecture of the disk. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  com.google.protobuf.ByteString getArchitectureBytes();

  /**
   *
   *
   * <pre>
   * Disk asynchronously replicated into this disk.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;
   * </code>
   *
   * @return Whether the asyncPrimaryDisk field is set.
   */
  boolean hasAsyncPrimaryDisk();

  /**
   *
   *
   * <pre>
   * Disk asynchronously replicated into this disk.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;
   * </code>
   *
   * @return The asyncPrimaryDisk.
   */
  com.google.cloud.compute.v1.DiskAsyncReplication getAsyncPrimaryDisk();

  /**
   *
   *
   * <pre>
   * Disk asynchronously replicated into this disk.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;
   * </code>
   */
  com.google.cloud.compute.v1.DiskAsyncReplicationOrBuilder getAsyncPrimaryDiskOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] A list of disks this disk is asynchronously replicated to.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.DiskAsyncReplicationList&gt; async_secondary_disks = 322925608;
   * </code>
   */
  int getAsyncSecondaryDisksCount();

  /**
   *
   *
   * <pre>
   * [Output Only] A list of disks this disk is asynchronously replicated to.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.DiskAsyncReplicationList&gt; async_secondary_disks = 322925608;
   * </code>
   */
  boolean containsAsyncSecondaryDisks(java.lang.String key);

  /** Use {@link #getAsyncSecondaryDisksMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.compute.v1.DiskAsyncReplicationList>
      getAsyncSecondaryDisks();

  /**
   *
   *
   * <pre>
   * [Output Only] A list of disks this disk is asynchronously replicated to.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.DiskAsyncReplicationList&gt; async_secondary_disks = 322925608;
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.compute.v1.DiskAsyncReplicationList>
      getAsyncSecondaryDisksMap();

  /**
   *
   *
   * <pre>
   * [Output Only] A list of disks this disk is asynchronously replicated to.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.DiskAsyncReplicationList&gt; async_secondary_disks = 322925608;
   * </code>
   */
  /* nullable */
  com.google.cloud.compute.v1.DiskAsyncReplicationList getAsyncSecondaryDisksOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.compute.v1.DiskAsyncReplicationList defaultValue);

  /**
   *
   *
   * <pre>
   * [Output Only] A list of disks this disk is asynchronously replicated to.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.DiskAsyncReplicationList&gt; async_secondary_disks = 322925608;
   * </code>
   */
  com.google.cloud.compute.v1.DiskAsyncReplicationList getAsyncSecondaryDisksOrThrow(
      java.lang.String key);

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   *
   * @return Whether the diskEncryptionKey field is set.
   */
  boolean hasDiskEncryptionKey();

  /**
   *
   *
   * <pre>
   * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   *
   * @return The diskEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getDiskEncryptionKey();

  /**
   *
   *
   * <pre>
   * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder getDiskEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * Whether this disk is using confidential compute mode.
   * </pre>
   *
   * <code>optional bool enable_confidential_compute = 102135228;</code>
   *
   * @return Whether the enableConfidentialCompute field is set.
   */
  boolean hasEnableConfidentialCompute();

  /**
   *
   *
   * <pre>
   * Whether this disk is using confidential compute mode.
   * </pre>
   *
   * <code>optional bool enable_confidential_compute = 102135228;</code>
   *
   * @return The enableConfidentialCompute.
   */
  boolean getEnableConfidentialCompute();

  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  java.util.List<com.google.cloud.compute.v1.GuestOsFeature> getGuestOsFeaturesList();

  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  com.google.cloud.compute.v1.GuestOsFeature getGuestOsFeatures(int index);

  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  int getGuestOsFeaturesCount();

  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
      getGuestOsFeaturesOrBuilderList();

  /**
   *
   *
   * <pre>
   * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  com.google.cloud.compute.v1.GuestOsFeatureOrBuilder getGuestOsFeaturesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  boolean hasLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  java.lang.String getLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  com.google.protobuf.ByteString getLabelFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * [Output Only] Last attach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_attach_timestamp = 42159653;</code>
   *
   * @return Whether the lastAttachTimestamp field is set.
   */
  boolean hasLastAttachTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Last attach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_attach_timestamp = 42159653;</code>
   *
   * @return The lastAttachTimestamp.
   */
  java.lang.String getLastAttachTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Last attach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_attach_timestamp = 42159653;</code>
   *
   * @return The bytes for lastAttachTimestamp.
   */
  com.google.protobuf.ByteString getLastAttachTimestampBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Last detach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_detach_timestamp = 56471027;</code>
   *
   * @return Whether the lastDetachTimestamp field is set.
   */
  boolean hasLastDetachTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Last detach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_detach_timestamp = 56471027;</code>
   *
   * @return The lastDetachTimestamp.
   */
  java.lang.String getLastDetachTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Last detach timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_detach_timestamp = 56471027;</code>
   *
   * @return The bytes for lastDetachTimestamp.
   */
  com.google.protobuf.ByteString getLastDetachTimestampBytes();

  /**
   *
   *
   * <pre>
   * Integer license codes indicating which licenses are attached to this disk.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @return A list containing the licenseCodes.
   */
  java.util.List<java.lang.Long> getLicenseCodesList();

  /**
   *
   *
   * <pre>
   * Integer license codes indicating which licenses are attached to this disk.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @return The count of licenseCodes.
   */
  int getLicenseCodesCount();

  /**
   *
   *
   * <pre>
   * Integer license codes indicating which licenses are attached to this disk.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @param index The index of the element to return.
   * @return The licenseCodes at the given index.
   */
  long getLicenseCodes(int index);

  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return A list containing the licenses.
   */
  java.util.List<java.lang.String> getLicensesList();

  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return The count of licenses.
   */
  int getLicensesCount();

  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the element to return.
   * @return The licenses at the given index.
   */
  java.lang.String getLicenses(int index);

  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the licenses at the given index.
   */
  com.google.protobuf.ByteString getLicensesBytes(int index);

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  boolean hasLocationHint();

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  java.lang.String getLocationHint();

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  com.google.protobuf.ByteString getLocationHintBytes();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Internal use only.
   * </pre>
   *
   * <code>optional string options = 361137822;</code>
   *
   * @return Whether the options field is set.
   */
  boolean hasOptions();

  /**
   *
   *
   * <pre>
   * Internal use only.
   * </pre>
   *
   * <code>optional string options = 361137822;</code>
   *
   * @return The options.
   */
  java.lang.String getOptions();

  /**
   *
   *
   * <pre>
   * Internal use only.
   * </pre>
   *
   * <code>optional string options = 361137822;</code>
   *
   * @return The bytes for options.
   */
  com.google.protobuf.ByteString getOptionsBytes();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  boolean hasParams();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
   *
   * @return The params.
   */
  com.google.cloud.compute.v1.DiskParams getParams();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
   */
  com.google.cloud.compute.v1.DiskParamsOrBuilder getParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
   * </pre>
   *
   * <code>optional int64 physical_block_size_bytes = 420007943;</code>
   *
   * @return Whether the physicalBlockSizeBytes field is set.
   */
  boolean hasPhysicalBlockSizeBytes();

  /**
   *
   *
   * <pre>
   * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
   * </pre>
   *
   * <code>optional int64 physical_block_size_bytes = 420007943;</code>
   *
   * @return The physicalBlockSizeBytes.
   */
  long getPhysicalBlockSizeBytes();

  /**
   *
   *
   * <pre>
   * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
   * </pre>
   *
   * <code>optional int64 provisioned_iops = 186769108;</code>
   *
   * @return Whether the provisionedIops field is set.
   */
  boolean hasProvisionedIops();

  /**
   *
   *
   * <pre>
   * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
   * </pre>
   *
   * <code>optional int64 provisioned_iops = 186769108;</code>
   *
   * @return The provisionedIops.
   */
  long getProvisionedIops();

  /**
   *
   *
   * <pre>
   * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
   * </pre>
   *
   * <code>optional int64 provisioned_throughput = 526524181;</code>
   *
   * @return Whether the provisionedThroughput field is set.
   */
  boolean hasProvisionedThroughput();

  /**
   *
   *
   * <pre>
   * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
   * </pre>
   *
   * <code>optional int64 provisioned_throughput = 526524181;</code>
   *
   * @return The provisionedThroughput.
   */
  long getProvisionedThroughput();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  boolean hasRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
   * </pre>
   *
   * <code>repeated string replica_zones = 48438272;</code>
   *
   * @return A list containing the replicaZones.
   */
  java.util.List<java.lang.String> getReplicaZonesList();

  /**
   *
   *
   * <pre>
   * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
   * </pre>
   *
   * <code>repeated string replica_zones = 48438272;</code>
   *
   * @return The count of replicaZones.
   */
  int getReplicaZonesCount();

  /**
   *
   *
   * <pre>
   * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
   * </pre>
   *
   * <code>repeated string replica_zones = 48438272;</code>
   *
   * @param index The index of the element to return.
   * @return The replicaZones at the given index.
   */
  java.lang.String getReplicaZones(int index);

  /**
   *
   *
   * <pre>
   * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
   * </pre>
   *
   * <code>repeated string replica_zones = 48438272;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the replicaZones at the given index.
   */
  com.google.protobuf.ByteString getReplicaZonesBytes(int index);

  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return A list containing the resourcePolicies.
   */
  java.util.List<java.lang.String> getResourcePoliciesList();

  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return The count of resourcePolicies.
   */
  int getResourcePoliciesCount();

  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePolicies at the given index.
   */
  java.lang.String getResourcePolicies(int index);

  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePolicies at the given index.
   */
  com.google.protobuf.ByteString getResourcePoliciesBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for the disk resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
   *
   * @return Whether the resourceStatus field is set.
   */
  boolean hasResourceStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for the disk resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
   *
   * @return The resourceStatus.
   */
  com.google.cloud.compute.v1.DiskResourceStatus getResourceStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] Status information for the disk resource.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
   */
  com.google.cloud.compute.v1.DiskResourceStatusOrBuilder getResourceStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  boolean hasSatisfiesPzi();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return The satisfiesPzi.
   */
  boolean getSatisfiesPzi();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  boolean hasSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
   * </pre>
   *
   * <code>optional int64 size_gb = 494929369;</code>
   *
   * @return Whether the sizeGb field is set.
   */
  boolean hasSizeGb();

  /**
   *
   *
   * <pre>
   * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
   * </pre>
   *
   * <code>optional int64 size_gb = 494929369;</code>
   *
   * @return The sizeGb.
   */
  long getSizeGb();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy = 19616093;</code>
   *
   * @return Whether the sourceConsistencyGroupPolicy field is set.
   */
  boolean hasSourceConsistencyGroupPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy = 19616093;</code>
   *
   * @return The sourceConsistencyGroupPolicy.
   */
  java.lang.String getSourceConsistencyGroupPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy = 19616093;</code>
   *
   * @return The bytes for sourceConsistencyGroupPolicy.
   */
  com.google.protobuf.ByteString getSourceConsistencyGroupPolicyBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy_id = 267568957;</code>
   *
   * @return Whether the sourceConsistencyGroupPolicyId field is set.
   */
  boolean hasSourceConsistencyGroupPolicyId();

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy_id = 267568957;</code>
   *
   * @return The sourceConsistencyGroupPolicyId.
   */
  java.lang.String getSourceConsistencyGroupPolicyId();

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
   * </pre>
   *
   * <code>optional string source_consistency_group_policy_id = 267568957;</code>
   *
   * @return The bytes for sourceConsistencyGroupPolicyId.
   */
  com.google.protobuf.ByteString getSourceConsistencyGroupPolicyIdBytes();

  /**
   *
   *
   * <pre>
   * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return Whether the sourceDisk field is set.
   */
  boolean hasSourceDisk();

  /**
   *
   *
   * <pre>
   * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The sourceDisk.
   */
  java.lang.String getSourceDisk();

  /**
   *
   *
   * <pre>
   * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The bytes for sourceDisk.
   */
  com.google.protobuf.ByteString getSourceDiskBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return Whether the sourceDiskId field is set.
   */
  boolean hasSourceDiskId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return The sourceDiskId.
   */
  java.lang.String getSourceDiskId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return The bytes for sourceDiskId.
   */
  com.google.protobuf.ByteString getSourceDiskIdBytes();

  /**
   *
   *
   * <pre>
   * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return Whether the sourceImage field is set.
   */
  boolean hasSourceImage();

  /**
   *
   *
   * <pre>
   * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return The sourceImage.
   */
  java.lang.String getSourceImage();

  /**
   *
   *
   * <pre>
   * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return The bytes for sourceImage.
   */
  com.google.protobuf.ByteString getSourceImageBytes();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   *
   * @return Whether the sourceImageEncryptionKey field is set.
   */
  boolean hasSourceImageEncryptionKey();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   *
   * @return The sourceImageEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getSourceImageEncryptionKey();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder getSourceImageEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
   * </pre>
   *
   * <code>optional string source_image_id = 55328291;</code>
   *
   * @return Whether the sourceImageId field is set.
   */
  boolean hasSourceImageId();

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
   * </pre>
   *
   * <code>optional string source_image_id = 55328291;</code>
   *
   * @return The sourceImageId.
   */
  java.lang.String getSourceImageId();

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
   * </pre>
   *
   * <code>optional string source_image_id = 55328291;</code>
   *
   * @return The bytes for sourceImageId.
   */
  com.google.protobuf.ByteString getSourceImageIdBytes();

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return Whether the sourceInstantSnapshot field is set.
   */
  boolean hasSourceInstantSnapshot();

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return The sourceInstantSnapshot.
   */
  java.lang.String getSourceInstantSnapshot();

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return The bytes for sourceInstantSnapshot.
   */
  com.google.protobuf.ByteString getSourceInstantSnapshotBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return Whether the sourceInstantSnapshotId field is set.
   */
  boolean hasSourceInstantSnapshotId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return The sourceInstantSnapshotId.
   */
  java.lang.String getSourceInstantSnapshotId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return The bytes for sourceInstantSnapshotId.
   */
  com.google.protobuf.ByteString getSourceInstantSnapshotIdBytes();

  /**
   *
   *
   * <pre>
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return Whether the sourceSnapshot field is set.
   */
  boolean hasSourceSnapshot();

  /**
   *
   *
   * <pre>
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return The sourceSnapshot.
   */
  java.lang.String getSourceSnapshot();

  /**
   *
   *
   * <pre>
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return The bytes for sourceSnapshot.
   */
  com.google.protobuf.ByteString getSourceSnapshotBytes();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   *
   * @return Whether the sourceSnapshotEncryptionKey field is set.
   */
  boolean hasSourceSnapshotEncryptionKey();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   *
   * @return The sourceSnapshotEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getSourceSnapshotEncryptionKey();

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceSnapshotEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
   * </pre>
   *
   * <code>optional string source_snapshot_id = 98962258;</code>
   *
   * @return Whether the sourceSnapshotId field is set.
   */
  boolean hasSourceSnapshotId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
   * </pre>
   *
   * <code>optional string source_snapshot_id = 98962258;</code>
   *
   * @return The sourceSnapshotId.
   */
  java.lang.String getSourceSnapshotId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
   * </pre>
   *
   * <code>optional string source_snapshot_id = 98962258;</code>
   *
   * @return The bytes for sourceSnapshotId.
   */
  com.google.protobuf.ByteString getSourceSnapshotIdBytes();

  /**
   *
   *
   * <pre>
   * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
   * </pre>
   *
   * <code>optional string source_storage_object = 233052711;</code>
   *
   * @return Whether the sourceStorageObject field is set.
   */
  boolean hasSourceStorageObject();

  /**
   *
   *
   * <pre>
   * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
   * </pre>
   *
   * <code>optional string source_storage_object = 233052711;</code>
   *
   * @return The sourceStorageObject.
   */
  java.lang.String getSourceStorageObject();

  /**
   *
   *
   * <pre>
   * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
   * </pre>
   *
   * <code>optional string source_storage_object = 233052711;</code>
   *
   * @return The bytes for sourceStorageObject.
   */
  com.google.protobuf.ByteString getSourceStorageObjectBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  java.lang.String getStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  com.google.protobuf.ByteString getStatusBytes();

  /**
   *
   *
   * <pre>
   * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
   * </pre>
   *
   * <code>optional string storage_pool = 360473440;</code>
   *
   * @return Whether the storagePool field is set.
   */
  boolean hasStoragePool();

  /**
   *
   *
   * <pre>
   * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
   * </pre>
   *
   * <code>optional string storage_pool = 360473440;</code>
   *
   * @return The storagePool.
   */
  java.lang.String getStoragePool();

  /**
   *
   *
   * <pre>
   * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool
   * </pre>
   *
   * <code>optional string storage_pool = 360473440;</code>
   *
   * @return The bytes for storagePool.
   */
  com.google.protobuf.ByteString getStoragePoolBytes();

  /**
   *
   *
   * <pre>
   * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  boolean hasType();

  /**
   *
   *
   * <pre>
   * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  java.lang.String getType();

  /**
   *
   *
   * <pre>
   * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>repeated string users = 111578632;</code>
   *
   * @return A list containing the users.
   */
  java.util.List<java.lang.String> getUsersList();

  /**
   *
   *
   * <pre>
   * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>repeated string users = 111578632;</code>
   *
   * @return The count of users.
   */
  int getUsersCount();

  /**
   *
   *
   * <pre>
   * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>repeated string users = 111578632;</code>
   *
   * @param index The index of the element to return.
   * @return The users at the given index.
   */
  java.lang.String getUsers(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>repeated string users = 111578632;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the users at the given index.
   */
  com.google.protobuf.ByteString getUsersBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  boolean hasZone();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  java.lang.String getZone();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  com.google.protobuf.ByteString getZoneBytes();
}
