/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.DistributionPolicy}
 */
public final class DistributionPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.DistributionPolicy)
    DistributionPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DistributionPolicy.newBuilder() to construct.
  private DistributionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DistributionPolicy() {
    targetShape_ = "";
    zones_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DistributionPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DistributionPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DistributionPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.DistributionPolicy.class,
            com.google.cloud.compute.v1.DistributionPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.DistributionPolicy.TargetShape}
   */
  public enum TargetShape implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TARGET_SHAPE = 0;</code>
     */
    UNDEFINED_TARGET_SHAPE(0),
    /**
     *
     *
     * <pre>
     * The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
     * </pre>
     *
     * <code>ANY = 64972;</code>
     */
    ANY(64972),
    /**
     *
     *
     * <pre>
     * The group creates all VM instances within a single zone. The zone is selected based on the present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads with heavy interprocess communication.
     * </pre>
     *
     * <code>ANY_SINGLE_ZONE = 61100880;</code>
     */
    ANY_SINGLE_ZONE(61100880),
    /**
     *
     *
     * <pre>
     * The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>BALANCED = 468409608;</code>
     */
    BALANCED(468409608),
    /**
     *
     *
     * <pre>
     * The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>EVEN = 2140442;</code>
     */
    EVEN(2140442),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TARGET_SHAPE = 0;</code>
     */
    public static final int UNDEFINED_TARGET_SHAPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
     * </pre>
     *
     * <code>ANY = 64972;</code>
     */
    public static final int ANY_VALUE = 64972;

    /**
     *
     *
     * <pre>
     * The group creates all VM instances within a single zone. The zone is selected based on the present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads with heavy interprocess communication.
     * </pre>
     *
     * <code>ANY_SINGLE_ZONE = 61100880;</code>
     */
    public static final int ANY_SINGLE_ZONE_VALUE = 61100880;

    /**
     *
     *
     * <pre>
     * The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>BALANCED = 468409608;</code>
     */
    public static final int BALANCED_VALUE = 468409608;

    /**
     *
     *
     * <pre>
     * The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
     * </pre>
     *
     * <code>EVEN = 2140442;</code>
     */
    public static final int EVEN_VALUE = 2140442;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetShape valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TargetShape forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TARGET_SHAPE;
        case 64972:
          return ANY;
        case 61100880:
          return ANY_SINGLE_ZONE;
        case 468409608:
          return BALANCED;
        case 2140442:
          return EVEN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TargetShape> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TargetShape> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TargetShape>() {
          public TargetShape findValueByNumber(int number) {
            return TargetShape.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.DistributionPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final TargetShape[] VALUES = values();

    public static TargetShape valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TargetShape(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.DistributionPolicy.TargetShape)
  }

  private int bitField0_;
  public static final int TARGET_SHAPE_FIELD_NUMBER = 338621299;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetShape_ = "";

  /**
   *
   *
   * <pre>
   * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return Whether the targetShape field is set.
   */
  @java.lang.Override
  public boolean hasTargetShape() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return The targetShape.
   */
  @java.lang.Override
  public java.lang.String getTargetShape() {
    java.lang.Object ref = targetShape_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetShape_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
   * Check the TargetShape enum for the list of possible values.
   * </pre>
   *
   * <code>optional string target_shape = 338621299;</code>
   *
   * @return The bytes for targetShape.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetShapeBytes() {
    java.lang.Object ref = targetShape_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetShape_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONES_FIELD_NUMBER = 116085319;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration> zones_;

  /**
   *
   *
   * <pre>
   * Zones where the regional managed instance group will create and manage its instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration>
      getZonesList() {
    return zones_;
  }

  /**
   *
   *
   * <pre>
   * Zones where the regional managed instance group will create and manage its instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder>
      getZonesOrBuilderList() {
    return zones_;
  }

  /**
   *
   *
   * <pre>
   * Zones where the regional managed instance group will create and manage its instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
   * </code>
   */
  @java.lang.Override
  public int getZonesCount() {
    return zones_.size();
  }

  /**
   *
   *
   * <pre>
   * Zones where the regional managed instance group will create and manage its instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration getZones(int index) {
    return zones_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Zones where the regional managed instance group will create and manage its instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder getZonesOrBuilder(
      int index) {
    return zones_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < zones_.size(); i++) {
      output.writeMessage(116085319, zones_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 338621299, targetShape_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < zones_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(116085319, zones_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(338621299, targetShape_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.DistributionPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.DistributionPolicy other =
        (com.google.cloud.compute.v1.DistributionPolicy) obj;

    if (hasTargetShape() != other.hasTargetShape()) return false;
    if (hasTargetShape()) {
      if (!getTargetShape().equals(other.getTargetShape())) return false;
    }
    if (!getZonesList().equals(other.getZonesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTargetShape()) {
      hash = (37 * hash) + TARGET_SHAPE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetShape().hashCode();
    }
    if (getZonesCount() > 0) {
      hash = (37 * hash) + ZONES_FIELD_NUMBER;
      hash = (53 * hash) + getZonesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DistributionPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.DistributionPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.DistributionPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.DistributionPolicy)
      com.google.cloud.compute.v1.DistributionPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DistributionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DistributionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.DistributionPolicy.class,
              com.google.cloud.compute.v1.DistributionPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.DistributionPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      targetShape_ = "";
      if (zonesBuilder_ == null) {
        zones_ = java.util.Collections.emptyList();
      } else {
        zones_ = null;
        zonesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DistributionPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DistributionPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DistributionPolicy build() {
      com.google.cloud.compute.v1.DistributionPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DistributionPolicy buildPartial() {
      com.google.cloud.compute.v1.DistributionPolicy result =
          new com.google.cloud.compute.v1.DistributionPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.DistributionPolicy result) {
      if (zonesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          zones_ = java.util.Collections.unmodifiableList(zones_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.zones_ = zones_;
      } else {
        result.zones_ = zonesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.DistributionPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.targetShape_ = targetShape_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.DistributionPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.DistributionPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.DistributionPolicy other) {
      if (other == com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()) return this;
      if (other.hasTargetShape()) {
        targetShape_ = other.targetShape_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (zonesBuilder_ == null) {
        if (!other.zones_.isEmpty()) {
          if (zones_.isEmpty()) {
            zones_ = other.zones_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureZonesIsMutable();
            zones_.addAll(other.zones_);
          }
          onChanged();
        }
      } else {
        if (!other.zones_.isEmpty()) {
          if (zonesBuilder_.isEmpty()) {
            zonesBuilder_.dispose();
            zonesBuilder_ = null;
            zones_ = other.zones_;
            bitField0_ = (bitField0_ & ~0x00000002);
            zonesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getZonesFieldBuilder()
                    : null;
          } else {
            zonesBuilder_.addAllMessages(other.zones_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 928682554:
              {
                com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration m =
                    input.readMessage(
                        com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.parser(),
                        extensionRegistry);
                if (zonesBuilder_ == null) {
                  ensureZonesIsMutable();
                  zones_.add(m);
                } else {
                  zonesBuilder_.addMessage(m);
                }
                break;
              } // case 928682554
            case -1585996902:
              {
                targetShape_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1585996902
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object targetShape_ = "";

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return Whether the targetShape field is set.
     */
    public boolean hasTargetShape() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return The targetShape.
     */
    public java.lang.String getTargetShape() {
      java.lang.Object ref = targetShape_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetShape_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return The bytes for targetShape.
     */
    public com.google.protobuf.ByteString getTargetShapeBytes() {
      java.lang.Object ref = targetShape_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetShape_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @param value The targetShape to set.
     * @return This builder for chaining.
     */
    public Builder setTargetShape(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetShape_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetShape() {
      targetShape_ = getDefaultInstance().getTargetShape();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     * Check the TargetShape enum for the list of possible values.
     * </pre>
     *
     * <code>optional string target_shape = 338621299;</code>
     *
     * @param value The bytes for targetShape to set.
     * @return This builder for chaining.
     */
    public Builder setTargetShapeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetShape_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration> zones_ =
        java.util.Collections.emptyList();

    private void ensureZonesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        zones_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration>(zones_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration,
            com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder,
            com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder>
        zonesBuilder_;

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration>
        getZonesList() {
      if (zonesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(zones_);
      } else {
        return zonesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public int getZonesCount() {
      if (zonesBuilder_ == null) {
        return zones_.size();
      } else {
        return zonesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration getZones(int index) {
      if (zonesBuilder_ == null) {
        return zones_.get(index);
      } else {
        return zonesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder setZones(
        int index, com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration value) {
      if (zonesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureZonesIsMutable();
        zones_.set(index, value);
        onChanged();
      } else {
        zonesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder setZones(
        int index,
        com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder builderForValue) {
      if (zonesBuilder_ == null) {
        ensureZonesIsMutable();
        zones_.set(index, builderForValue.build());
        onChanged();
      } else {
        zonesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder addZones(com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration value) {
      if (zonesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureZonesIsMutable();
        zones_.add(value);
        onChanged();
      } else {
        zonesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder addZones(
        int index, com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration value) {
      if (zonesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureZonesIsMutable();
        zones_.add(index, value);
        onChanged();
      } else {
        zonesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder addZones(
        com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder builderForValue) {
      if (zonesBuilder_ == null) {
        ensureZonesIsMutable();
        zones_.add(builderForValue.build());
        onChanged();
      } else {
        zonesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder addZones(
        int index,
        com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder builderForValue) {
      if (zonesBuilder_ == null) {
        ensureZonesIsMutable();
        zones_.add(index, builderForValue.build());
        onChanged();
      } else {
        zonesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder addAllZones(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration>
            values) {
      if (zonesBuilder_ == null) {
        ensureZonesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, zones_);
        onChanged();
      } else {
        zonesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder clearZones() {
      if (zonesBuilder_ == null) {
        zones_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        zonesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public Builder removeZones(int index) {
      if (zonesBuilder_ == null) {
        ensureZonesIsMutable();
        zones_.remove(index);
        onChanged();
      } else {
        zonesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder getZonesBuilder(
        int index) {
      return getZonesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder
        getZonesOrBuilder(int index) {
      if (zonesBuilder_ == null) {
        return zones_.get(index);
      } else {
        return zonesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder>
        getZonesOrBuilderList() {
      if (zonesBuilder_ != null) {
        return zonesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(zones_);
      }
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder
        addZonesBuilder() {
      return getZonesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder addZonesBuilder(
        int index) {
      return getZonesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Zones where the regional managed instance group will create and manage its instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.DistributionPolicyZoneConfiguration zones = 116085319;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder>
        getZonesBuilderList() {
      return getZonesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration,
            com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder,
            com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder>
        getZonesFieldBuilder() {
      if (zonesBuilder_ == null) {
        zonesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration,
                com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration.Builder,
                com.google.cloud.compute.v1.DistributionPolicyZoneConfigurationOrBuilder>(
                zones_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        zones_ = null;
      }
      return zonesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.DistributionPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.DistributionPolicy)
  private static final com.google.cloud.compute.v1.DistributionPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.DistributionPolicy();
  }

  public static com.google.cloud.compute.v1.DistributionPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DistributionPolicy> PARSER =
      new com.google.protobuf.AbstractParser<DistributionPolicy>() {
        @java.lang.Override
        public DistributionPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DistributionPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DistributionPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.DistributionPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
