/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an external VPN gateway. External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway. For more information about using external VPN gateways, see Creating an HA VPN gateway and tunnel pair to a peer VPN.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ExternalVpnGateway}
 */
public final class ExternalVpnGateway extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ExternalVpnGateway)
    ExternalVpnGatewayOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ExternalVpnGateway.newBuilder() to construct.
  private ExternalVpnGateway(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExternalVpnGateway() {
    creationTimestamp_ = "";
    description_ = "";
    interfaces_ = java.util.Collections.emptyList();
    kind_ = "";
    labelFingerprint_ = "";
    name_ = "";
    redundancyType_ = "";
    selfLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExternalVpnGateway();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ExternalVpnGateway_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ExternalVpnGateway_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ExternalVpnGateway.class,
            com.google.cloud.compute.v1.ExternalVpnGateway.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ExternalVpnGateway.RedundancyType}
   */
  public enum RedundancyType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REDUNDANCY_TYPE = 0;</code>
     */
    UNDEFINED_REDUNDANCY_TYPE(0),
    /**
     *
     *
     * <pre>
     * The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
     * </pre>
     *
     * <code>FOUR_IPS_REDUNDANCY = 520087913;</code>
     */
    FOUR_IPS_REDUNDANCY(520087913),
    /**
     *
     *
     * <pre>
     * The external VPN gateway has only one public IP address which internally provide redundancy or failover.
     * </pre>
     *
     * <code>SINGLE_IP_INTERNALLY_REDUNDANT = 133914873;</code>
     */
    SINGLE_IP_INTERNALLY_REDUNDANT(133914873),
    /**
     *
     *
     * <pre>
     * The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
     * </pre>
     *
     * <code>TWO_IPS_REDUNDANCY = 367049635;</code>
     */
    TWO_IPS_REDUNDANCY(367049635),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_REDUNDANCY_TYPE = 0;</code>
     */
    public static final int UNDEFINED_REDUNDANCY_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
     * </pre>
     *
     * <code>FOUR_IPS_REDUNDANCY = 520087913;</code>
     */
    public static final int FOUR_IPS_REDUNDANCY_VALUE = 520087913;

    /**
     *
     *
     * <pre>
     * The external VPN gateway has only one public IP address which internally provide redundancy or failover.
     * </pre>
     *
     * <code>SINGLE_IP_INTERNALLY_REDUNDANT = 133914873;</code>
     */
    public static final int SINGLE_IP_INTERNALLY_REDUNDANT_VALUE = 133914873;

    /**
     *
     *
     * <pre>
     * The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
     * </pre>
     *
     * <code>TWO_IPS_REDUNDANCY = 367049635;</code>
     */
    public static final int TWO_IPS_REDUNDANCY_VALUE = 367049635;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RedundancyType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RedundancyType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_REDUNDANCY_TYPE;
        case 520087913:
          return FOUR_IPS_REDUNDANCY;
        case 133914873:
          return SINGLE_IP_INTERNALLY_REDUNDANT;
        case 367049635:
          return TWO_IPS_REDUNDANCY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RedundancyType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RedundancyType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RedundancyType>() {
          public RedundancyType findValueByNumber(int number) {
            return RedundancyType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ExternalVpnGateway.getDescriptor().getEnumTypes().get(0);
    }

    private static final RedundancyType[] VALUES = values();

    public static RedundancyType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RedundancyType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ExternalVpnGateway.RedundancyType)
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERFACES_FIELD_NUMBER = 12073562;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ExternalVpnGatewayInterface> interfaces_;

  /**
   *
   *
   * <pre>
   * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ExternalVpnGatewayInterface>
      getInterfacesList() {
    return interfaces_;
  }

  /**
   *
   *
   * <pre>
   * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder>
      getInterfacesOrBuilderList() {
    return interfaces_;
  }

  /**
   *
   *
   * <pre>
   * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
   * </code>
   */
  @java.lang.Override
  public int getInterfacesCount() {
    return interfaces_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ExternalVpnGatewayInterface getInterfaces(int index) {
    return interfaces_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder getInterfacesOrBuilder(
      int index) {
    return interfaces_.get(index);
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_ExternalVpnGateway_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDUNDANCY_TYPE_FIELD_NUMBER = 271443740;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redundancyType_ = "";

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   * Check the RedundancyType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redundancy_type = 271443740;</code>
   *
   * @return Whether the redundancyType field is set.
   */
  @java.lang.Override
  public boolean hasRedundancyType() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   * Check the RedundancyType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redundancy_type = 271443740;</code>
   *
   * @return The redundancyType.
   */
  @java.lang.Override
  public java.lang.String getRedundancyType() {
    java.lang.Object ref = redundancyType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redundancyType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Indicates the user-supplied redundancy type of this external VPN gateway.
   * Check the RedundancyType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string redundancy_type = 271443740;</code>
   *
   * @return The bytes for redundancyType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedundancyTypeBytes() {
    java.lang.Object ref = redundancyType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redundancyType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < interfaces_.size(); i++) {
      output.writeMessage(12073562, interfaces_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 271443740, redundancyType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    for (int i = 0; i < interfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12073562, interfaces_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(271443740, redundancyType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ExternalVpnGateway)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ExternalVpnGateway other =
        (com.google.cloud.compute.v1.ExternalVpnGateway) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (!getInterfacesList().equals(other.getInterfacesList())) return false;
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasRedundancyType() != other.hasRedundancyType()) return false;
    if (hasRedundancyType()) {
      if (!getRedundancyType().equals(other.getRedundancyType())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (getInterfacesCount() > 0) {
      hash = (37 * hash) + INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getInterfacesList().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasRedundancyType()) {
      hash = (37 * hash) + REDUNDANCY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getRedundancyType().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ExternalVpnGateway prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents an external VPN gateway. External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway. To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway. For more information about using external VPN gateways, see Creating an HA VPN gateway and tunnel pair to a peer VPN.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ExternalVpnGateway}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ExternalVpnGateway)
      com.google.cloud.compute.v1.ExternalVpnGatewayOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ExternalVpnGateway_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ExternalVpnGateway_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ExternalVpnGateway.class,
              com.google.cloud.compute.v1.ExternalVpnGateway.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ExternalVpnGateway.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      description_ = "";
      id_ = 0L;
      if (interfacesBuilder_ == null) {
        interfaces_ = java.util.Collections.emptyList();
      } else {
        interfaces_ = null;
        interfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      name_ = "";
      redundancyType_ = "";
      selfLink_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ExternalVpnGateway_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ExternalVpnGateway getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ExternalVpnGateway.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ExternalVpnGateway build() {
      com.google.cloud.compute.v1.ExternalVpnGateway result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ExternalVpnGateway buildPartial() {
      com.google.cloud.compute.v1.ExternalVpnGateway result =
          new com.google.cloud.compute.v1.ExternalVpnGateway(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.ExternalVpnGateway result) {
      if (interfacesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          interfaces_ = java.util.Collections.unmodifiableList(interfaces_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.interfaces_ = interfaces_;
      } else {
        result.interfaces_ = interfacesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.ExternalVpnGateway result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.redundancyType_ = redundancyType_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ExternalVpnGateway) {
        return mergeFrom((com.google.cloud.compute.v1.ExternalVpnGateway) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ExternalVpnGateway other) {
      if (other == com.google.cloud.compute.v1.ExternalVpnGateway.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (interfacesBuilder_ == null) {
        if (!other.interfaces_.isEmpty()) {
          if (interfaces_.isEmpty()) {
            interfaces_ = other.interfaces_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureInterfacesIsMutable();
            interfaces_.addAll(other.interfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.interfaces_.isEmpty()) {
          if (interfacesBuilder_.isEmpty()) {
            interfacesBuilder_.dispose();
            interfacesBuilder_ = null;
            interfaces_ = other.interfaces_;
            bitField0_ = (bitField0_ & ~0x00000008);
            interfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInterfacesFieldBuilder()
                    : null;
          } else {
            interfacesBuilder_.addAllMessages(other.interfaces_);
          }
        }
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasRedundancyType()) {
        redundancyType_ = other.redundancyType_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26989658
            case 96588498:
              {
                com.google.cloud.compute.v1.ExternalVpnGatewayInterface m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ExternalVpnGatewayInterface.parser(),
                        extensionRegistry);
                if (interfacesBuilder_ == null) {
                  ensureInterfacesIsMutable();
                  interfaces_.add(m);
                } else {
                  interfacesBuilder_.addMessage(m);
                }
                break;
              } // case 96588498
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1424998602
            case -2123417374:
              {
                redundancyType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -2123417374
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -645248918
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.ExternalVpnGatewayInterface> interfaces_ =
        java.util.Collections.emptyList();

    private void ensureInterfacesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        interfaces_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ExternalVpnGatewayInterface>(
                interfaces_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ExternalVpnGatewayInterface,
            com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder,
            com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder>
        interfacesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ExternalVpnGatewayInterface>
        getInterfacesList() {
      if (interfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(interfaces_);
      } else {
        return interfacesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public int getInterfacesCount() {
      if (interfacesBuilder_ == null) {
        return interfaces_.size();
      } else {
        return interfacesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public com.google.cloud.compute.v1.ExternalVpnGatewayInterface getInterfaces(int index) {
      if (interfacesBuilder_ == null) {
        return interfaces_.get(index);
      } else {
        return interfacesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder setInterfaces(
        int index, com.google.cloud.compute.v1.ExternalVpnGatewayInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.set(index, value);
        onChanged();
      } else {
        interfacesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder setInterfaces(
        int index,
        com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder addInterfaces(com.google.cloud.compute.v1.ExternalVpnGatewayInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.add(value);
        onChanged();
      } else {
        interfacesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder addInterfaces(
        int index, com.google.cloud.compute.v1.ExternalVpnGatewayInterface value) {
      if (interfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInterfacesIsMutable();
        interfaces_.add(index, value);
        onChanged();
      } else {
        interfacesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder addInterfaces(
        com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.add(builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder addInterfaces(
        int index,
        com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder builderForValue) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        interfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder addAllInterfaces(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ExternalVpnGatewayInterface>
            values) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, interfaces_);
        onChanged();
      } else {
        interfacesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder clearInterfaces() {
      if (interfacesBuilder_ == null) {
        interfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        interfacesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public Builder removeInterfaces(int index) {
      if (interfacesBuilder_ == null) {
        ensureInterfacesIsMutable();
        interfaces_.remove(index);
        onChanged();
      } else {
        interfacesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder getInterfacesBuilder(
        int index) {
      return getInterfacesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder getInterfacesOrBuilder(
        int index) {
      if (interfacesBuilder_ == null) {
        return interfaces_.get(index);
      } else {
        return interfacesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder>
        getInterfacesOrBuilderList() {
      if (interfacesBuilder_ != null) {
        return interfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(interfaces_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder addInterfacesBuilder() {
      return getInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.ExternalVpnGatewayInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder addInterfacesBuilder(
        int index) {
      return getInterfacesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.ExternalVpnGatewayInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of interfaces for this external VPN gateway. If your peer-side gateway is an on-premises gateway and non-AWS cloud providers' gateway, at most two interfaces can be provided for an external VPN gateway. If your peer side is an AWS virtual private gateway, four interfaces should be provided for an external VPN gateway.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ExternalVpnGatewayInterface interfaces = 12073562;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder>
        getInterfacesBuilderList() {
      return getInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ExternalVpnGatewayInterface,
            com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder,
            com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder>
        getInterfacesFieldBuilder() {
      if (interfacesBuilder_ == null) {
        interfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ExternalVpnGatewayInterface,
                com.google.cloud.compute.v1.ExternalVpnGatewayInterface.Builder,
                com.google.cloud.compute.v1.ExternalVpnGatewayInterfaceOrBuilder>(
                interfaces_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        interfaces_ = null;
      }
      return interfacesBuilder_;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object redundancyType_ = "";

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @return Whether the redundancyType field is set.
     */
    public boolean hasRedundancyType() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @return The redundancyType.
     */
    public java.lang.String getRedundancyType() {
      java.lang.Object ref = redundancyType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redundancyType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @return The bytes for redundancyType.
     */
    public com.google.protobuf.ByteString getRedundancyTypeBytes() {
      java.lang.Object ref = redundancyType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redundancyType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @param value The redundancyType to set.
     * @return This builder for chaining.
     */
    public Builder setRedundancyType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redundancyType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedundancyType() {
      redundancyType_ = getDefaultInstance().getRedundancyType();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the user-supplied redundancy type of this external VPN gateway.
     * Check the RedundancyType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string redundancy_type = 271443740;</code>
     *
     * @param value The bytes for redundancyType to set.
     * @return This builder for chaining.
     */
    public Builder setRedundancyTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redundancyType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ExternalVpnGateway)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ExternalVpnGateway)
  private static final com.google.cloud.compute.v1.ExternalVpnGateway DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ExternalVpnGateway();
  }

  public static com.google.cloud.compute.v1.ExternalVpnGateway getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExternalVpnGateway> PARSER =
      new com.google.protobuf.AbstractParser<ExternalVpnGateway>() {
        @java.lang.Override
        public ExternalVpnGateway parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExternalVpnGateway> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExternalVpnGateway> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ExternalVpnGateway getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
