/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.FirewallPolicyRule}
 */
public final class FirewallPolicyRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.FirewallPolicyRule)
    FirewallPolicyRuleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FirewallPolicyRule.newBuilder() to construct.
  private FirewallPolicyRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FirewallPolicyRule() {
    action_ = "";
    description_ = "";
    direction_ = "";
    kind_ = "";
    ruleName_ = "";
    securityProfileGroup_ = "";
    targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
    targetSecureTags_ = java.util.Collections.emptyList();
    targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FirewallPolicyRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_FirewallPolicyRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_FirewallPolicyRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.FirewallPolicyRule.class,
            com.google.cloud.compute.v1.FirewallPolicyRule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The direction in which this rule applies.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.FirewallPolicyRule.Direction}
   */
  public enum Direction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    UNDEFINED_DIRECTION(0),
    /** <code>EGRESS = 432880501;</code> */
    EGRESS(432880501),
    /** <code>INGRESS = 516931221;</code> */
    INGRESS(516931221),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DIRECTION = 0;</code>
     */
    public static final int UNDEFINED_DIRECTION_VALUE = 0;

    /** <code>EGRESS = 432880501;</code> */
    public static final int EGRESS_VALUE = 432880501;

    /** <code>INGRESS = 516931221;</code> */
    public static final int INGRESS_VALUE = 516931221;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Direction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Direction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DIRECTION;
        case 432880501:
          return EGRESS;
        case 516931221:
          return INGRESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Direction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Direction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
          public Direction findValueByNumber(int number) {
            return Direction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.FirewallPolicyRule.getDescriptor().getEnumTypes().get(0);
    }

    private static final Direction[] VALUES = values();

    public static Direction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Direction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.FirewallPolicyRule.Direction)
  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 187661878;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";

  /**
   *
   *
   * <pre>
   * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description for this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description for this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description for this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIRECTION_FIELD_NUMBER = 111150975;

  @SuppressWarnings("serial")
  private volatile java.lang.Object direction_ = "";

  /**
   *
   *
   * <pre>
   * The direction in which this rule applies.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return Whether the direction field is set.
   */
  @java.lang.Override
  public boolean hasDirection() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The direction in which this rule applies.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The direction.
   */
  @java.lang.Override
  public java.lang.String getDirection() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      direction_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The direction in which this rule applies.
   * Check the Direction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string direction = 111150975;</code>
   *
   * @return The bytes for direction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirectionBytes() {
    java.lang.Object ref = direction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      direction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 270940796;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int ENABLE_LOGGING_FIELD_NUMBER = 295396515;
  private boolean enableLogging_ = false;

  /**
   *
   *
   * <pre>
   * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
   * </pre>
   *
   * <code>optional bool enable_logging = 295396515;</code>
   *
   * @return Whether the enableLogging field is set.
   */
  @java.lang.Override
  public boolean hasEnableLogging() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
   * </pre>
   *
   * <code>optional bool enable_logging = 295396515;</code>
   *
   * @return The enableLogging.
   */
  @java.lang.Override
  public boolean getEnableLogging() {
    return enableLogging_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_FIELD_NUMBER = 103668165;
  private com.google.cloud.compute.v1.FirewallPolicyRuleMatcher match_;

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
   *
   * @return Whether the match field is set.
   */
  @java.lang.Override
  public boolean hasMatch() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
   *
   * @return The match.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher getMatch() {
    return match_ == null
        ? com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance()
        : match_;
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder getMatchOrBuilder() {
    return match_ == null
        ? com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance()
        : match_;
  }

  public static final int PRIORITY_FIELD_NUMBER = 445151652;
  private int priority_ = 0;

  /**
   *
   *
   * <pre>
   * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return Whether the priority field is set.
   */
  @java.lang.Override
  public boolean hasPriority() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int RULE_NAME_FIELD_NUMBER = 55286254;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ruleName_ = "";

  /**
   *
   *
   * <pre>
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * </pre>
   *
   * <code>optional string rule_name = 55286254;</code>
   *
   * @return Whether the ruleName field is set.
   */
  @java.lang.Override
  public boolean hasRuleName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * </pre>
   *
   * <code>optional string rule_name = 55286254;</code>
   *
   * @return The ruleName.
   */
  @java.lang.Override
  public java.lang.String getRuleName() {
    java.lang.Object ref = ruleName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ruleName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * </pre>
   *
   * <code>optional string rule_name = 55286254;</code>
   *
   * @return The bytes for ruleName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuleNameBytes() {
    java.lang.Object ref = ruleName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ruleName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULE_TUPLE_COUNT_FIELD_NUMBER = 388342037;
  private int ruleTupleCount_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] Calculation of the complexity of a single firewall policy rule.
   * </pre>
   *
   * <code>optional int32 rule_tuple_count = 388342037;</code>
   *
   * @return Whether the ruleTupleCount field is set.
   */
  @java.lang.Override
  public boolean hasRuleTupleCount() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Calculation of the complexity of a single firewall policy rule.
   * </pre>
   *
   * <code>optional int32 rule_tuple_count = 388342037;</code>
   *
   * @return The ruleTupleCount.
   */
  @java.lang.Override
  public int getRuleTupleCount() {
    return ruleTupleCount_;
  }

  public static final int SECURITY_PROFILE_GROUP_FIELD_NUMBER = 207411626;

  @SuppressWarnings("serial")
  private volatile java.lang.Object securityProfileGroup_ = "";

  /**
   *
   *
   * <pre>
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
   * </pre>
   *
   * <code>optional string security_profile_group = 207411626;</code>
   *
   * @return Whether the securityProfileGroup field is set.
   */
  @java.lang.Override
  public boolean hasSecurityProfileGroup() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
   * </pre>
   *
   * <code>optional string security_profile_group = 207411626;</code>
   *
   * @return The securityProfileGroup.
   */
  @java.lang.Override
  public java.lang.String getSecurityProfileGroup() {
    java.lang.Object ref = securityProfileGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securityProfileGroup_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
   * </pre>
   *
   * <code>optional string security_profile_group = 207411626;</code>
   *
   * @return The bytes for securityProfileGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecurityProfileGroupBytes() {
    java.lang.Object ref = securityProfileGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securityProfileGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_RESOURCES_FIELD_NUMBER = 528230647;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
   * </pre>
   *
   * <code>repeated string target_resources = 528230647;</code>
   *
   * @return A list containing the targetResources.
   */
  public com.google.protobuf.ProtocolStringList getTargetResourcesList() {
    return targetResources_;
  }

  /**
   *
   *
   * <pre>
   * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
   * </pre>
   *
   * <code>repeated string target_resources = 528230647;</code>
   *
   * @return The count of targetResources.
   */
  public int getTargetResourcesCount() {
    return targetResources_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
   * </pre>
   *
   * <code>repeated string target_resources = 528230647;</code>
   *
   * @param index The index of the element to return.
   * @return The targetResources at the given index.
   */
  public java.lang.String getTargetResources(int index) {
    return targetResources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
   * </pre>
   *
   * <code>repeated string target_resources = 528230647;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetResources at the given index.
   */
  public com.google.protobuf.ByteString getTargetResourcesBytes(int index) {
    return targetResources_.getByteString(index);
  }

  public static final int TARGET_SECURE_TAGS_FIELD_NUMBER = 468132403;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag> targetSecureTags_;

  /**
   *
   *
   * <pre>
   * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
      getTargetSecureTagsList() {
    return targetSecureTags_;
  }

  /**
   *
   *
   * <pre>
   * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
      getTargetSecureTagsOrBuilderList() {
    return targetSecureTags_;
  }

  /**
   *
   *
   * <pre>
   * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
   * </code>
   */
  @java.lang.Override
  public int getTargetSecureTagsCount() {
    return targetSecureTags_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag getTargetSecureTags(int index) {
    return targetSecureTags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder
      getTargetSecureTagsOrBuilder(int index) {
    return targetSecureTags_.get(index);
  }

  public static final int TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER = 457639710;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @return A list containing the targetServiceAccounts.
   */
  public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
    return targetServiceAccounts_;
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @return The count of targetServiceAccounts.
   */
  public int getTargetServiceAccountsCount() {
    return targetServiceAccounts_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @param index The index of the element to return.
   * @return The targetServiceAccounts at the given index.
   */
  public java.lang.String getTargetServiceAccounts(int index) {
    return targetServiceAccounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * </pre>
   *
   * <code>repeated string target_service_accounts = 457639710;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetServiceAccounts at the given index.
   */
  public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
    return targetServiceAccounts_.getByteString(index);
  }

  public static final int TLS_INSPECT_FIELD_NUMBER = 43425488;
  private boolean tlsInspect_ = false;

  /**
   *
   *
   * <pre>
   * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
   * </pre>
   *
   * <code>optional bool tls_inspect = 43425488;</code>
   *
   * @return Whether the tlsInspect field is set.
   */
  @java.lang.Override
  public boolean hasTlsInspect() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
   * </pre>
   *
   * <code>optional bool tls_inspect = 43425488;</code>
   *
   * @return The tlsInspect.
   */
  @java.lang.Override
  public boolean getTlsInspect() {
    return tlsInspect_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeBool(43425488, tlsInspect_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 55286254, ruleName_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(103668165, getMatch());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 111150975, direction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 187661878, action_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 207411626, securityProfileGroup_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(295396515, enableLogging_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt32(388342037, ruleTupleCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt32(445151652, priority_);
    }
    for (int i = 0; i < targetServiceAccounts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 457639710, targetServiceAccounts_.getRaw(i));
    }
    for (int i = 0; i < targetSecureTags_.size(); i++) {
      output.writeMessage(468132403, targetSecureTags_.get(i));
    }
    for (int i = 0; i < targetResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 528230647, targetResources_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(43425488, tlsInspect_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(55286254, ruleName_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(103668165, getMatch());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(111150975, direction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(187661878, action_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              207411626, securityProfileGroup_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(295396515, enableLogging_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(388342037, ruleTupleCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(445151652, priority_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetServiceAccounts_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetServiceAccounts_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getTargetServiceAccountsList().size();
    }
    for (int i = 0; i < targetSecureTags_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              468132403, targetSecureTags_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetResources_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getTargetResourcesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.FirewallPolicyRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.FirewallPolicyRule other =
        (com.google.cloud.compute.v1.FirewallPolicyRule) obj;

    if (hasAction() != other.hasAction()) return false;
    if (hasAction()) {
      if (!getAction().equals(other.getAction())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDirection() != other.hasDirection()) return false;
    if (hasDirection()) {
      if (!getDirection().equals(other.getDirection())) return false;
    }
    if (hasDisabled() != other.hasDisabled()) return false;
    if (hasDisabled()) {
      if (getDisabled() != other.getDisabled()) return false;
    }
    if (hasEnableLogging() != other.hasEnableLogging()) return false;
    if (hasEnableLogging()) {
      if (getEnableLogging() != other.getEnableLogging()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMatch() != other.hasMatch()) return false;
    if (hasMatch()) {
      if (!getMatch().equals(other.getMatch())) return false;
    }
    if (hasPriority() != other.hasPriority()) return false;
    if (hasPriority()) {
      if (getPriority() != other.getPriority()) return false;
    }
    if (hasRuleName() != other.hasRuleName()) return false;
    if (hasRuleName()) {
      if (!getRuleName().equals(other.getRuleName())) return false;
    }
    if (hasRuleTupleCount() != other.hasRuleTupleCount()) return false;
    if (hasRuleTupleCount()) {
      if (getRuleTupleCount() != other.getRuleTupleCount()) return false;
    }
    if (hasSecurityProfileGroup() != other.hasSecurityProfileGroup()) return false;
    if (hasSecurityProfileGroup()) {
      if (!getSecurityProfileGroup().equals(other.getSecurityProfileGroup())) return false;
    }
    if (!getTargetResourcesList().equals(other.getTargetResourcesList())) return false;
    if (!getTargetSecureTagsList().equals(other.getTargetSecureTagsList())) return false;
    if (!getTargetServiceAccountsList().equals(other.getTargetServiceAccountsList())) return false;
    if (hasTlsInspect() != other.hasTlsInspect()) return false;
    if (hasTlsInspect()) {
      if (getTlsInspect() != other.getTlsInspect()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAction()) {
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAction().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDirection()) {
      hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
      hash = (53 * hash) + getDirection().hashCode();
    }
    if (hasDisabled()) {
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    }
    if (hasEnableLogging()) {
      hash = (37 * hash) + ENABLE_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableLogging());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMatch()) {
      hash = (37 * hash) + MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getMatch().hashCode();
    }
    if (hasPriority()) {
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
    }
    if (hasRuleName()) {
      hash = (37 * hash) + RULE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getRuleName().hashCode();
    }
    if (hasRuleTupleCount()) {
      hash = (37 * hash) + RULE_TUPLE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRuleTupleCount();
    }
    if (hasSecurityProfileGroup()) {
      hash = (37 * hash) + SECURITY_PROFILE_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityProfileGroup().hashCode();
    }
    if (getTargetResourcesCount() > 0) {
      hash = (37 * hash) + TARGET_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getTargetResourcesList().hashCode();
    }
    if (getTargetSecureTagsCount() > 0) {
      hash = (37 * hash) + TARGET_SECURE_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetSecureTagsList().hashCode();
    }
    if (getTargetServiceAccountsCount() > 0) {
      hash = (37 * hash) + TARGET_SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetServiceAccountsList().hashCode();
    }
    if (hasTlsInspect()) {
      hash = (37 * hash) + TLS_INSPECT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTlsInspect());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.FirewallPolicyRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.FirewallPolicyRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.FirewallPolicyRule)
      com.google.cloud.compute.v1.FirewallPolicyRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.FirewallPolicyRule.class,
              com.google.cloud.compute.v1.FirewallPolicyRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.FirewallPolicyRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMatchFieldBuilder();
        getTargetSecureTagsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = "";
      description_ = "";
      direction_ = "";
      disabled_ = false;
      enableLogging_ = false;
      kind_ = "";
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      priority_ = 0;
      ruleName_ = "";
      ruleTupleCount_ = 0;
      securityProfileGroup_ = "";
      targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (targetSecureTagsBuilder_ == null) {
        targetSecureTags_ = java.util.Collections.emptyList();
      } else {
        targetSecureTags_ = null;
        targetSecureTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      tlsInspect_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.FirewallPolicyRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRule build() {
      com.google.cloud.compute.v1.FirewallPolicyRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRule buildPartial() {
      com.google.cloud.compute.v1.FirewallPolicyRule result =
          new com.google.cloud.compute.v1.FirewallPolicyRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.FirewallPolicyRule result) {
      if (targetSecureTagsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          targetSecureTags_ = java.util.Collections.unmodifiableList(targetSecureTags_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.targetSecureTags_ = targetSecureTags_;
      } else {
        result.targetSecureTags_ = targetSecureTagsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.FirewallPolicyRule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.direction_ = direction_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.disabled_ = disabled_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableLogging_ = enableLogging_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.match_ = matchBuilder_ == null ? match_ : matchBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.priority_ = priority_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.ruleName_ = ruleName_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ruleTupleCount_ = ruleTupleCount_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.securityProfileGroup_ = securityProfileGroup_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        targetResources_.makeImmutable();
        result.targetResources_ = targetResources_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        targetServiceAccounts_.makeImmutable();
        result.targetServiceAccounts_ = targetServiceAccounts_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.tlsInspect_ = tlsInspect_;
        to_bitField0_ |= 0x00000800;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.FirewallPolicyRule) {
        return mergeFrom((com.google.cloud.compute.v1.FirewallPolicyRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.FirewallPolicyRule other) {
      if (other == com.google.cloud.compute.v1.FirewallPolicyRule.getDefaultInstance()) return this;
      if (other.hasAction()) {
        action_ = other.action_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDirection()) {
        direction_ = other.direction_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDisabled()) {
        setDisabled(other.getDisabled());
      }
      if (other.hasEnableLogging()) {
        setEnableLogging(other.getEnableLogging());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasMatch()) {
        mergeMatch(other.getMatch());
      }
      if (other.hasPriority()) {
        setPriority(other.getPriority());
      }
      if (other.hasRuleName()) {
        ruleName_ = other.ruleName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasRuleTupleCount()) {
        setRuleTupleCount(other.getRuleTupleCount());
      }
      if (other.hasSecurityProfileGroup()) {
        securityProfileGroup_ = other.securityProfileGroup_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.targetResources_.isEmpty()) {
        if (targetResources_.isEmpty()) {
          targetResources_ = other.targetResources_;
          bitField0_ |= 0x00000800;
        } else {
          ensureTargetResourcesIsMutable();
          targetResources_.addAll(other.targetResources_);
        }
        onChanged();
      }
      if (targetSecureTagsBuilder_ == null) {
        if (!other.targetSecureTags_.isEmpty()) {
          if (targetSecureTags_.isEmpty()) {
            targetSecureTags_ = other.targetSecureTags_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureTargetSecureTagsIsMutable();
            targetSecureTags_.addAll(other.targetSecureTags_);
          }
          onChanged();
        }
      } else {
        if (!other.targetSecureTags_.isEmpty()) {
          if (targetSecureTagsBuilder_.isEmpty()) {
            targetSecureTagsBuilder_.dispose();
            targetSecureTagsBuilder_ = null;
            targetSecureTags_ = other.targetSecureTags_;
            bitField0_ = (bitField0_ & ~0x00001000);
            targetSecureTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTargetSecureTagsFieldBuilder()
                    : null;
          } else {
            targetSecureTagsBuilder_.addAllMessages(other.targetSecureTags_);
          }
        }
      }
      if (!other.targetServiceAccounts_.isEmpty()) {
        if (targetServiceAccounts_.isEmpty()) {
          targetServiceAccounts_ = other.targetServiceAccounts_;
          bitField0_ |= 0x00002000;
        } else {
          ensureTargetServiceAccountsIsMutable();
          targetServiceAccounts_.addAll(other.targetServiceAccounts_);
        }
        onChanged();
      }
      if (other.hasTlsInspect()) {
        setTlsInspect(other.getTlsInspect());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 26336418
            case 347403904:
              {
                tlsInspect_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 347403904
            case 442290034:
              {
                ruleName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 442290034
            case 829345322:
              {
                input.readMessage(getMatchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 829345322
            case 889207802:
              {
                direction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 889207802
            case 1501295026:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1501295026
            case 1659293010:
              {
                securityProfileGroup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 1659293010
            case -2127440928:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case -2127440928
            case -1931795176:
              {
                enableLogging_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case -1931795176
            case -1188231000:
              {
                ruleTupleCount_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case -1188231000
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -733754080:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case -733754080
            case -633849614:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetServiceAccountsIsMutable();
                targetServiceAccounts_.add(s);
                break;
              } // case -633849614
            case -549908070:
              {
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.parser(),
                        extensionRegistry);
                if (targetSecureTagsBuilder_ == null) {
                  ensureTargetSecureTagsIsMutable();
                  targetSecureTags_.add(m);
                } else {
                  targetSecureTagsBuilder_.addMessage(m);
                }
                break;
              } // case -549908070
            case -69122118:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetResourcesIsMutable();
                targetResources_.add(s);
                break;
              } // case -69122118
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object action_ = "";

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return Whether the action field is set.
     */
    public boolean hasAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the client connection triggers the rule. Valid actions for firewall rules are: "allow", "deny", "apply_security_profile_group" and "goto_next". Valid actions for packet mirroring rules are: "mirror", "do_not_mirror" and "goto_next".
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description for this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object direction_ = "";

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return Whether the direction field is set.
     */
    public boolean hasDirection() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The direction.
     */
    public java.lang.String getDirection() {
      java.lang.Object ref = direction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        direction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return The bytes for direction.
     */
    public com.google.protobuf.ByteString getDirectionBytes() {
      java.lang.Object ref = direction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        direction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirection(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirection() {
      direction_ = getDefaultInstance().getDirection();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The direction in which this rule applies.
     * Check the Direction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string direction = 111150975;</code>
     *
     * @param value The bytes for direction to set.
     * @return This builder for chaining.
     */
    public Builder setDirectionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      direction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000008);
      disabled_ = false;
      onChanged();
      return this;
    }

    private boolean enableLogging_;

    /**
     *
     *
     * <pre>
     * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     * </pre>
     *
     * <code>optional bool enable_logging = 295396515;</code>
     *
     * @return Whether the enableLogging field is set.
     */
    @java.lang.Override
    public boolean hasEnableLogging() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     * </pre>
     *
     * <code>optional bool enable_logging = 295396515;</code>
     *
     * @return The enableLogging.
     */
    @java.lang.Override
    public boolean getEnableLogging() {
      return enableLogging_;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     * </pre>
     *
     * <code>optional bool enable_logging = 295396515;</code>
     *
     * @param value The enableLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableLogging(boolean value) {

      enableLogging_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     * </pre>
     *
     * <code>optional bool enable_logging = 295396515;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableLogging() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableLogging_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Returns compute#firewallPolicyRule for firewall rules and compute#packetMirroringRule for packet mirroring rules.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.FirewallPolicyRuleMatcher match_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder>
        matchBuilder_;

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     *
     * @return Whether the match field is set.
     */
    public boolean hasMatch() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     *
     * @return The match.
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher getMatch() {
      if (matchBuilder_ == null) {
        return match_ == null
            ? com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance()
            : match_;
      } else {
        return matchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder setMatch(com.google.cloud.compute.v1.FirewallPolicyRuleMatcher value) {
      if (matchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        match_ = value;
      } else {
        matchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder setMatch(
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder builderForValue) {
      if (matchBuilder_ == null) {
        match_ = builderForValue.build();
      } else {
        matchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder mergeMatch(com.google.cloud.compute.v1.FirewallPolicyRuleMatcher value) {
      if (matchBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && match_ != null
            && match_
                != com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance()) {
          getMatchBuilder().mergeFrom(value);
        } else {
          match_ = value;
        }
      } else {
        matchBuilder_.mergeFrom(value);
      }
      if (match_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder clearMatch() {
      bitField0_ = (bitField0_ & ~0x00000040);
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder getMatchBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getMatchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder getMatchOrBuilder() {
      if (matchBuilder_ != null) {
        return matchBuilder_.getMessageOrBuilder();
      } else {
        return match_ == null
            ? com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance()
            : match_;
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.FirewallPolicyRuleMatcher match = 103668165;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder>
        getMatchFieldBuilder() {
      if (matchBuilder_ == null) {
        matchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcher,
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder,
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder>(
                getMatch(), getParentForChildren(), isClean());
        match_ = null;
      }
      return matchBuilder_;
    }

    private int priority_;

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    public boolean hasPriority() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000080);
      priority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object ruleName_ = "";

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @return Whether the ruleName field is set.
     */
    public boolean hasRuleName() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @return The ruleName.
     */
    public java.lang.String getRuleName() {
      java.lang.Object ref = ruleName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ruleName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @return The bytes for ruleName.
     */
    public com.google.protobuf.ByteString getRuleNameBytes() {
      java.lang.Object ref = ruleName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ruleName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @param value The ruleName to set.
     * @return This builder for chaining.
     */
    public Builder setRuleName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ruleName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleName() {
      ruleName_ = getDefaultInstance().getRuleName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional name for the rule. This field is not a unique identifier and can be updated.
     * </pre>
     *
     * <code>optional string rule_name = 55286254;</code>
     *
     * @param value The bytes for ruleName to set.
     * @return This builder for chaining.
     */
    public Builder setRuleNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ruleName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int ruleTupleCount_;

    /**
     *
     *
     * <pre>
     * [Output Only] Calculation of the complexity of a single firewall policy rule.
     * </pre>
     *
     * <code>optional int32 rule_tuple_count = 388342037;</code>
     *
     * @return Whether the ruleTupleCount field is set.
     */
    @java.lang.Override
    public boolean hasRuleTupleCount() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Calculation of the complexity of a single firewall policy rule.
     * </pre>
     *
     * <code>optional int32 rule_tuple_count = 388342037;</code>
     *
     * @return The ruleTupleCount.
     */
    @java.lang.Override
    public int getRuleTupleCount() {
      return ruleTupleCount_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Calculation of the complexity of a single firewall policy rule.
     * </pre>
     *
     * <code>optional int32 rule_tuple_count = 388342037;</code>
     *
     * @param value The ruleTupleCount to set.
     * @return This builder for chaining.
     */
    public Builder setRuleTupleCount(int value) {

      ruleTupleCount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Calculation of the complexity of a single firewall policy rule.
     * </pre>
     *
     * <code>optional int32 rule_tuple_count = 388342037;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleTupleCount() {
      bitField0_ = (bitField0_ & ~0x00000200);
      ruleTupleCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object securityProfileGroup_ = "";

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @return Whether the securityProfileGroup field is set.
     */
    public boolean hasSecurityProfileGroup() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @return The securityProfileGroup.
     */
    public java.lang.String getSecurityProfileGroup() {
      java.lang.Object ref = securityProfileGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securityProfileGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @return The bytes for securityProfileGroup.
     */
    public com.google.protobuf.ByteString getSecurityProfileGroupBytes() {
      java.lang.Object ref = securityProfileGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securityProfileGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @param value The securityProfileGroup to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityProfileGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      securityProfileGroup_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecurityProfileGroup() {
      securityProfileGroup_ = getDefaultInstance().getSecurityProfileGroup();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group Must be specified if action is one of 'apply_security_profile_group' or 'mirror'. Cannot be specified for other actions.
     * </pre>
     *
     * <code>optional string security_profile_group = 207411626;</code>
     *
     * @param value The bytes for securityProfileGroup to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityProfileGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      securityProfileGroup_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetResourcesIsMutable() {
      if (!targetResources_.isModifiable()) {
        targetResources_ = new com.google.protobuf.LazyStringArrayList(targetResources_);
      }
      bitField0_ |= 0x00000800;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @return A list containing the targetResources.
     */
    public com.google.protobuf.ProtocolStringList getTargetResourcesList() {
      targetResources_.makeImmutable();
      return targetResources_;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @return The count of targetResources.
     */
    public int getTargetResourcesCount() {
      return targetResources_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param index The index of the element to return.
     * @return The targetResources at the given index.
     */
    public java.lang.String getTargetResources(int index) {
      return targetResources_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetResources at the given index.
     */
    public com.google.protobuf.ByteString getTargetResourcesBytes(int index) {
      return targetResources_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetResources to set.
     * @return This builder for chaining.
     */
    public Builder setTargetResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetResourcesIsMutable();
      targetResources_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param value The targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addTargetResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetResourcesIsMutable();
      targetResources_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param values The targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetResources(java.lang.Iterable<java.lang.String> values) {
      ensureTargetResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetResources_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetResources() {
      targetResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     * </pre>
     *
     * <code>repeated string target_resources = 528230647;</code>
     *
     * @param value The bytes of the targetResources to add.
     * @return This builder for chaining.
     */
    public Builder addTargetResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetResourcesIsMutable();
      targetResources_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
        targetSecureTags_ = java.util.Collections.emptyList();

    private void ensureTargetSecureTagsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        targetSecureTags_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>(
                targetSecureTags_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        targetSecureTagsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
        getTargetSecureTagsList() {
      if (targetSecureTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(targetSecureTags_);
      } else {
        return targetSecureTagsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public int getTargetSecureTagsCount() {
      if (targetSecureTagsBuilder_ == null) {
        return targetSecureTags_.size();
      } else {
        return targetSecureTagsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag getTargetSecureTags(int index) {
      if (targetSecureTagsBuilder_ == null) {
        return targetSecureTags_.get(index);
      } else {
        return targetSecureTagsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder setTargetSecureTags(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (targetSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.set(index, value);
        onChanged();
      } else {
        targetSecureTagsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder setTargetSecureTags(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (targetSecureTagsBuilder_ == null) {
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        targetSecureTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder addTargetSecureTags(
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (targetSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.add(value);
        onChanged();
      } else {
        targetSecureTagsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder addTargetSecureTags(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (targetSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.add(index, value);
        onChanged();
      } else {
        targetSecureTagsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder addTargetSecureTags(
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (targetSecureTagsBuilder_ == null) {
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.add(builderForValue.build());
        onChanged();
      } else {
        targetSecureTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder addTargetSecureTags(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (targetSecureTagsBuilder_ == null) {
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        targetSecureTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder addAllTargetSecureTags(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
            values) {
      if (targetSecureTagsBuilder_ == null) {
        ensureTargetSecureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetSecureTags_);
        onChanged();
      } else {
        targetSecureTagsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder clearTargetSecureTags() {
      if (targetSecureTagsBuilder_ == null) {
        targetSecureTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        targetSecureTagsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public Builder removeTargetSecureTags(int index) {
      if (targetSecureTagsBuilder_ == null) {
        ensureTargetSecureTagsIsMutable();
        targetSecureTags_.remove(index);
        onChanged();
      } else {
        targetSecureTagsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder
        getTargetSecureTagsBuilder(int index) {
      return getTargetSecureTagsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder
        getTargetSecureTagsOrBuilder(int index) {
      if (targetSecureTagsBuilder_ == null) {
        return targetSecureTags_.get(index);
      } else {
        return targetSecureTagsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        getTargetSecureTagsOrBuilderList() {
      if (targetSecureTagsBuilder_ != null) {
        return targetSecureTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(targetSecureTags_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder
        addTargetSecureTagsBuilder() {
      return getTargetSecureTagsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder
        addTargetSecureTagsBuilder(int index) {
      return getTargetSecureTagsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of secure tags that controls which instances the firewall rule applies to. If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target label tags allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag target_secure_tags = 468132403;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder>
        getTargetSecureTagsBuilderList() {
      return getTargetSecureTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        getTargetSecureTagsFieldBuilder() {
      if (targetSecureTagsBuilder_ == null) {
        targetSecureTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>(
                targetSecureTags_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        targetSecureTags_ = null;
      }
      return targetSecureTagsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList targetServiceAccounts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetServiceAccountsIsMutable() {
      if (!targetServiceAccounts_.isModifiable()) {
        targetServiceAccounts_ =
            new com.google.protobuf.LazyStringArrayList(targetServiceAccounts_);
      }
      bitField0_ |= 0x00002000;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return A list containing the targetServiceAccounts.
     */
    public com.google.protobuf.ProtocolStringList getTargetServiceAccountsList() {
      targetServiceAccounts_.makeImmutable();
      return targetServiceAccounts_;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return The count of targetServiceAccounts.
     */
    public int getTargetServiceAccountsCount() {
      return targetServiceAccounts_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index of the element to return.
     * @return The targetServiceAccounts at the given index.
     */
    public java.lang.String getTargetServiceAccounts(int index) {
      return targetServiceAccounts_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetServiceAccounts at the given index.
     */
    public com.google.protobuf.ByteString getTargetServiceAccountsBytes(int index) {
      return targetServiceAccounts_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetServiceAccounts to set.
     * @return This builder for chaining.
     */
    public Builder setTargetServiceAccounts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param value The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccounts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param values The targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetServiceAccounts(java.lang.Iterable<java.lang.String> values) {
      ensureTargetServiceAccountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetServiceAccounts_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetServiceAccounts() {
      targetServiceAccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     * </pre>
     *
     * <code>repeated string target_service_accounts = 457639710;</code>
     *
     * @param value The bytes of the targetServiceAccounts to add.
     * @return This builder for chaining.
     */
    public Builder addTargetServiceAccountsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetServiceAccountsIsMutable();
      targetServiceAccounts_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean tlsInspect_;

    /**
     *
     *
     * <pre>
     * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
     * </pre>
     *
     * <code>optional bool tls_inspect = 43425488;</code>
     *
     * @return Whether the tlsInspect field is set.
     */
    @java.lang.Override
    public boolean hasTlsInspect() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
     * </pre>
     *
     * <code>optional bool tls_inspect = 43425488;</code>
     *
     * @return The tlsInspect.
     */
    @java.lang.Override
    public boolean getTlsInspect() {
      return tlsInspect_;
    }

    /**
     *
     *
     * <pre>
     * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
     * </pre>
     *
     * <code>optional bool tls_inspect = 43425488;</code>
     *
     * @param value The tlsInspect to set.
     * @return This builder for chaining.
     */
    public Builder setTlsInspect(boolean value) {

      tlsInspect_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Boolean flag indicating if the traffic should be TLS decrypted. Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
     * </pre>
     *
     * <code>optional bool tls_inspect = 43425488;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTlsInspect() {
      bitField0_ = (bitField0_ & ~0x00004000);
      tlsInspect_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.FirewallPolicyRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.FirewallPolicyRule)
  private static final com.google.cloud.compute.v1.FirewallPolicyRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.FirewallPolicyRule();
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FirewallPolicyRule> PARSER =
      new com.google.protobuf.AbstractParser<FirewallPolicyRule>() {
        @java.lang.Override
        public FirewallPolicyRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FirewallPolicyRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FirewallPolicyRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
