/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Maintenance Info for ReservationBlocks.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.GroupMaintenanceInfo}
 */
public final class GroupMaintenanceInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.GroupMaintenanceInfo)
    GroupMaintenanceInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GroupMaintenanceInfo.newBuilder() to construct.
  private GroupMaintenanceInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GroupMaintenanceInfo() {
    schedulingType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GroupMaintenanceInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GroupMaintenanceInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GroupMaintenanceInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.GroupMaintenanceInfo.class,
            com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.GroupMaintenanceInfo.SchedulingType}
   */
  public enum SchedulingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SCHEDULING_TYPE = 0;</code>
     */
    UNDEFINED_SCHEDULING_TYPE(0),
    /**
     *
     *
     * <pre>
     * Maintenance on all reserved instances in the reservation is synchronized.
     * </pre>
     *
     * <code>GROUPED = 474540862;</code>
     */
    GROUPED(474540862),
    /**
     *
     *
     * <pre>
     * Unknown maintenance type.
     * </pre>
     *
     * <code>GROUP_MAINTENANCE_TYPE_UNSPECIFIED = 447183678;</code>
     */
    GROUP_MAINTENANCE_TYPE_UNSPECIFIED(447183678),
    /**
     *
     *
     * <pre>
     * Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    INDEPENDENT(127011674),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SCHEDULING_TYPE = 0;</code>
     */
    public static final int UNDEFINED_SCHEDULING_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Maintenance on all reserved instances in the reservation is synchronized.
     * </pre>
     *
     * <code>GROUPED = 474540862;</code>
     */
    public static final int GROUPED_VALUE = 474540862;

    /**
     *
     *
     * <pre>
     * Unknown maintenance type.
     * </pre>
     *
     * <code>GROUP_MAINTENANCE_TYPE_UNSPECIFIED = 447183678;</code>
     */
    public static final int GROUP_MAINTENANCE_TYPE_UNSPECIFIED_VALUE = 447183678;

    /**
     *
     *
     * <pre>
     * Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
     * </pre>
     *
     * <code>INDEPENDENT = 127011674;</code>
     */
    public static final int INDEPENDENT_VALUE = 127011674;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchedulingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SchedulingType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SCHEDULING_TYPE;
        case 474540862:
          return GROUPED;
        case 447183678:
          return GROUP_MAINTENANCE_TYPE_UNSPECIFIED;
        case 127011674:
          return INDEPENDENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SchedulingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SchedulingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SchedulingType>() {
          public SchedulingType findValueByNumber(int number) {
            return SchedulingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.GroupMaintenanceInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final SchedulingType[] VALUES = values();

    public static SchedulingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SchedulingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.GroupMaintenanceInfo.SchedulingType)
  }

  private int bitField0_;
  public static final int MAINTENANCE_ONGOING_COUNT_FIELD_NUMBER = 219781919;
  private int maintenanceOngoingCount_ = 0;

  /**
   *
   *
   * <pre>
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
   * </pre>
   *
   * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
   *
   * @return Whether the maintenanceOngoingCount field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceOngoingCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
   * </pre>
   *
   * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
   *
   * @return The maintenanceOngoingCount.
   */
  @java.lang.Override
  public int getMaintenanceOngoingCount() {
    return maintenanceOngoingCount_;
  }

  public static final int MAINTENANCE_PENDING_COUNT_FIELD_NUMBER = 158783547;
  private int maintenancePendingCount_ = 0;

  /**
   *
   *
   * <pre>
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
   * </pre>
   *
   * <code>optional int32 maintenance_pending_count = 158783547;</code>
   *
   * @return Whether the maintenancePendingCount field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePendingCount() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
   * </pre>
   *
   * <code>optional int32 maintenance_pending_count = 158783547;</code>
   *
   * @return The maintenancePendingCount.
   */
  @java.lang.Override
  public int getMaintenancePendingCount() {
    return maintenancePendingCount_;
  }

  public static final int SCHEDULING_TYPE_FIELD_NUMBER = 199835397;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedulingType_ = "";

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return Whether the schedulingType field is set.
   */
  @java.lang.Override
  public boolean hasSchedulingType() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return The schedulingType.
   */
  @java.lang.Override
  public java.lang.String getSchedulingType() {
    java.lang.Object ref = schedulingType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedulingType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The type of maintenance for the reservation.
   * Check the SchedulingType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string scheduling_type = 199835397;</code>
   *
   * @return The bytes for schedulingType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchedulingTypeBytes() {
    java.lang.Object ref = schedulingType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedulingType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPCOMING_GROUP_MAINTENANCE_FIELD_NUMBER = 393438448;
  private com.google.cloud.compute.v1.UpcomingMaintenance upcomingGroupMaintenance_;

  /**
   *
   *
   * <pre>
   * Maintenance information on this group of VMs.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
   * </code>
   *
   * @return Whether the upcomingGroupMaintenance field is set.
   */
  @java.lang.Override
  public boolean hasUpcomingGroupMaintenance() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Maintenance information on this group of VMs.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
   * </code>
   *
   * @return The upcomingGroupMaintenance.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UpcomingMaintenance getUpcomingGroupMaintenance() {
    return upcomingGroupMaintenance_ == null
        ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
        : upcomingGroupMaintenance_;
  }

  /**
   *
   *
   * <pre>
   * Maintenance information on this group of VMs.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder
      getUpcomingGroupMaintenanceOrBuilder() {
    return upcomingGroupMaintenance_ == null
        ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
        : upcomingGroupMaintenance_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(158783547, maintenancePendingCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 199835397, schedulingType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(219781919, maintenanceOngoingCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(393438448, getUpcomingGroupMaintenance());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              158783547, maintenancePendingCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(199835397, schedulingType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              219781919, maintenanceOngoingCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              393438448, getUpcomingGroupMaintenance());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.GroupMaintenanceInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.GroupMaintenanceInfo other =
        (com.google.cloud.compute.v1.GroupMaintenanceInfo) obj;

    if (hasMaintenanceOngoingCount() != other.hasMaintenanceOngoingCount()) return false;
    if (hasMaintenanceOngoingCount()) {
      if (getMaintenanceOngoingCount() != other.getMaintenanceOngoingCount()) return false;
    }
    if (hasMaintenancePendingCount() != other.hasMaintenancePendingCount()) return false;
    if (hasMaintenancePendingCount()) {
      if (getMaintenancePendingCount() != other.getMaintenancePendingCount()) return false;
    }
    if (hasSchedulingType() != other.hasSchedulingType()) return false;
    if (hasSchedulingType()) {
      if (!getSchedulingType().equals(other.getSchedulingType())) return false;
    }
    if (hasUpcomingGroupMaintenance() != other.hasUpcomingGroupMaintenance()) return false;
    if (hasUpcomingGroupMaintenance()) {
      if (!getUpcomingGroupMaintenance().equals(other.getUpcomingGroupMaintenance())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMaintenanceOngoingCount()) {
      hash = (37 * hash) + MAINTENANCE_ONGOING_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceOngoingCount();
    }
    if (hasMaintenancePendingCount()) {
      hash = (37 * hash) + MAINTENANCE_PENDING_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePendingCount();
    }
    if (hasSchedulingType()) {
      hash = (37 * hash) + SCHEDULING_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getSchedulingType().hashCode();
    }
    if (hasUpcomingGroupMaintenance()) {
      hash = (37 * hash) + UPCOMING_GROUP_MAINTENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getUpcomingGroupMaintenance().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.GroupMaintenanceInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Maintenance Info for ReservationBlocks.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.GroupMaintenanceInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.GroupMaintenanceInfo)
      com.google.cloud.compute.v1.GroupMaintenanceInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GroupMaintenanceInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GroupMaintenanceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.GroupMaintenanceInfo.class,
              com.google.cloud.compute.v1.GroupMaintenanceInfo.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.GroupMaintenanceInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpcomingGroupMaintenanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      maintenanceOngoingCount_ = 0;
      maintenancePendingCount_ = 0;
      schedulingType_ = "";
      upcomingGroupMaintenance_ = null;
      if (upcomingGroupMaintenanceBuilder_ != null) {
        upcomingGroupMaintenanceBuilder_.dispose();
        upcomingGroupMaintenanceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GroupMaintenanceInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GroupMaintenanceInfo getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GroupMaintenanceInfo build() {
      com.google.cloud.compute.v1.GroupMaintenanceInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GroupMaintenanceInfo buildPartial() {
      com.google.cloud.compute.v1.GroupMaintenanceInfo result =
          new com.google.cloud.compute.v1.GroupMaintenanceInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.GroupMaintenanceInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.maintenanceOngoingCount_ = maintenanceOngoingCount_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maintenancePendingCount_ = maintenancePendingCount_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.schedulingType_ = schedulingType_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upcomingGroupMaintenance_ =
            upcomingGroupMaintenanceBuilder_ == null
                ? upcomingGroupMaintenance_
                : upcomingGroupMaintenanceBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.GroupMaintenanceInfo) {
        return mergeFrom((com.google.cloud.compute.v1.GroupMaintenanceInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.GroupMaintenanceInfo other) {
      if (other == com.google.cloud.compute.v1.GroupMaintenanceInfo.getDefaultInstance())
        return this;
      if (other.hasMaintenanceOngoingCount()) {
        setMaintenanceOngoingCount(other.getMaintenanceOngoingCount());
      }
      if (other.hasMaintenancePendingCount()) {
        setMaintenancePendingCount(other.getMaintenancePendingCount());
      }
      if (other.hasSchedulingType()) {
        schedulingType_ = other.schedulingType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasUpcomingGroupMaintenance()) {
        mergeUpcomingGroupMaintenance(other.getUpcomingGroupMaintenance());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1270268376:
              {
                maintenancePendingCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 1270268376
            case 1598683178:
              {
                schedulingType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1598683178
            case 1758255352:
              {
                maintenanceOngoingCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 1758255352
            case -1147459710:
              {
                input.readMessage(
                    getUpcomingGroupMaintenanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -1147459710
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int maintenanceOngoingCount_;

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
     *
     * @return Whether the maintenanceOngoingCount field is set.
     */
    @java.lang.Override
    public boolean hasMaintenanceOngoingCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
     *
     * @return The maintenanceOngoingCount.
     */
    @java.lang.Override
    public int getMaintenanceOngoingCount() {
      return maintenanceOngoingCount_;
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
     *
     * @param value The maintenanceOngoingCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenanceOngoingCount(int value) {

      maintenanceOngoingCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have ongoing maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_ongoing_count = 219781919;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenanceOngoingCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      maintenanceOngoingCount_ = 0;
      onChanged();
      return this;
    }

    private int maintenancePendingCount_;

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_pending_count = 158783547;</code>
     *
     * @return Whether the maintenancePendingCount field is set.
     */
    @java.lang.Override
    public boolean hasMaintenancePendingCount() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_pending_count = 158783547;</code>
     *
     * @return The maintenancePendingCount.
     */
    @java.lang.Override
    public int getMaintenancePendingCount() {
      return maintenancePendingCount_;
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_pending_count = 158783547;</code>
     *
     * @param value The maintenancePendingCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaintenancePendingCount(int value) {

      maintenancePendingCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Progress for ongoing maintenance for this group of VMs/hosts. Describes number of hosts in the block that have pending maintenance.
     * </pre>
     *
     * <code>optional int32 maintenance_pending_count = 158783547;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaintenancePendingCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maintenancePendingCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object schedulingType_ = "";

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return Whether the schedulingType field is set.
     */
    public boolean hasSchedulingType() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return The schedulingType.
     */
    public java.lang.String getSchedulingType() {
      java.lang.Object ref = schedulingType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedulingType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return The bytes for schedulingType.
     */
    public com.google.protobuf.ByteString getSchedulingTypeBytes() {
      java.lang.Object ref = schedulingType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedulingType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @param value The schedulingType to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedulingType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedulingType() {
      schedulingType_ = getDefaultInstance().getSchedulingType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of maintenance for the reservation.
     * Check the SchedulingType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string scheduling_type = 199835397;</code>
     *
     * @param value The bytes for schedulingType to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedulingType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.UpcomingMaintenance upcomingGroupMaintenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UpcomingMaintenance,
            com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
            com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>
        upcomingGroupMaintenanceBuilder_;

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     *
     * @return Whether the upcomingGroupMaintenance field is set.
     */
    public boolean hasUpcomingGroupMaintenance() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     *
     * @return The upcomingGroupMaintenance.
     */
    public com.google.cloud.compute.v1.UpcomingMaintenance getUpcomingGroupMaintenance() {
      if (upcomingGroupMaintenanceBuilder_ == null) {
        return upcomingGroupMaintenance_ == null
            ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
            : upcomingGroupMaintenance_;
      } else {
        return upcomingGroupMaintenanceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public Builder setUpcomingGroupMaintenance(
        com.google.cloud.compute.v1.UpcomingMaintenance value) {
      if (upcomingGroupMaintenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upcomingGroupMaintenance_ = value;
      } else {
        upcomingGroupMaintenanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public Builder setUpcomingGroupMaintenance(
        com.google.cloud.compute.v1.UpcomingMaintenance.Builder builderForValue) {
      if (upcomingGroupMaintenanceBuilder_ == null) {
        upcomingGroupMaintenance_ = builderForValue.build();
      } else {
        upcomingGroupMaintenanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public Builder mergeUpcomingGroupMaintenance(
        com.google.cloud.compute.v1.UpcomingMaintenance value) {
      if (upcomingGroupMaintenanceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && upcomingGroupMaintenance_ != null
            && upcomingGroupMaintenance_
                != com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()) {
          getUpcomingGroupMaintenanceBuilder().mergeFrom(value);
        } else {
          upcomingGroupMaintenance_ = value;
        }
      } else {
        upcomingGroupMaintenanceBuilder_.mergeFrom(value);
      }
      if (upcomingGroupMaintenance_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public Builder clearUpcomingGroupMaintenance() {
      bitField0_ = (bitField0_ & ~0x00000008);
      upcomingGroupMaintenance_ = null;
      if (upcomingGroupMaintenanceBuilder_ != null) {
        upcomingGroupMaintenanceBuilder_.dispose();
        upcomingGroupMaintenanceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public com.google.cloud.compute.v1.UpcomingMaintenance.Builder
        getUpcomingGroupMaintenanceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpcomingGroupMaintenanceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    public com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder
        getUpcomingGroupMaintenanceOrBuilder() {
      if (upcomingGroupMaintenanceBuilder_ != null) {
        return upcomingGroupMaintenanceBuilder_.getMessageOrBuilder();
      } else {
        return upcomingGroupMaintenance_ == null
            ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
            : upcomingGroupMaintenance_;
      }
    }

    /**
     *
     *
     * <pre>
     * Maintenance information on this group of VMs.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_group_maintenance = 393438448;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UpcomingMaintenance,
            com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
            com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>
        getUpcomingGroupMaintenanceFieldBuilder() {
      if (upcomingGroupMaintenanceBuilder_ == null) {
        upcomingGroupMaintenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.UpcomingMaintenance,
                com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
                com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>(
                getUpcomingGroupMaintenance(), getParentForChildren(), isClean());
        upcomingGroupMaintenance_ = null;
      }
      return upcomingGroupMaintenanceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.GroupMaintenanceInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.GroupMaintenanceInfo)
  private static final com.google.cloud.compute.v1.GroupMaintenanceInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.GroupMaintenanceInfo();
  }

  public static com.google.cloud.compute.v1.GroupMaintenanceInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GroupMaintenanceInfo> PARSER =
      new com.google.protobuf.AbstractParser<GroupMaintenanceInfo>() {
        @java.lang.Override
        public GroupMaintenanceInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GroupMaintenanceInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GroupMaintenanceInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.GroupMaintenanceInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
