/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a health check resource. Google Compute Engine has two health check resources: * [Regional](/compute/docs/reference/rest/v1/regionHealthChecks) * [Global](/compute/docs/reference/rest/v1/healthChecks) These health check resources can be used for load balancing and for autohealing VMs in a managed instance group (MIG). **Load balancing** Health check requirements vary depending on the type of load balancer. For details about the type of health check supported for each load balancer and corresponding backend type, see Health checks overview: Load balancer guide. **Autohealing in MIGs** The health checks that you use for autohealing VMs in a MIG can be either regional or global. For more information, see Set up an application health check and autohealing. For more information, see Health checks overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HealthCheck}
 */
public final class HealthCheck extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HealthCheck)
    HealthCheckOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use HealthCheck.newBuilder() to construct.
  private HealthCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HealthCheck() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    region_ = "";
    selfLink_ = "";
    sourceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HealthCheck();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthCheck_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HealthCheck_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HealthCheck.class,
            com.google.cloud.compute.v1.HealthCheck.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.HealthCheck.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /** <code>GRPC = 2196510;</code> */
    GRPC(2196510),
    /** <code>HTTP = 2228360;</code> */
    HTTP(2228360),
    /** <code>HTTP2 = 69079210;</code> */
    HTTP2(69079210),
    /** <code>HTTPS = 69079243;</code> */
    HTTPS(69079243),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /** <code>SSL = 82412;</code> */
    SSL(82412),
    /** <code>TCP = 82881;</code> */
    TCP(82881),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;

    /** <code>GRPC = 2196510;</code> */
    public static final int GRPC_VALUE = 2196510;

    /** <code>HTTP = 2228360;</code> */
    public static final int HTTP_VALUE = 2228360;

    /** <code>HTTP2 = 69079210;</code> */
    public static final int HTTP2_VALUE = 69079210;

    /** <code>HTTPS = 69079243;</code> */
    public static final int HTTPS_VALUE = 69079243;

    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;

    /** <code>SSL = 82412;</code> */
    public static final int SSL_VALUE = 82412;

    /** <code>TCP = 82881;</code> */
    public static final int TCP_VALUE = 82881;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 2196510:
          return GRPC;
        case 2228360:
          return HTTP;
        case 69079210:
          return HTTP2;
        case 69079243:
          return HTTPS;
        case 530283991:
          return INVALID;
        case 82412:
          return SSL;
        case 82881:
          return TCP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.HealthCheck.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.HealthCheck.Type)
  }

  private int bitField0_;
  public static final int CHECK_INTERVAL_SEC_FIELD_NUMBER = 345561006;
  private int checkIntervalSec_ = 0;

  /**
   *
   *
   * <pre>
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * </pre>
   *
   * <code>optional int32 check_interval_sec = 345561006;</code>
   *
   * @return Whether the checkIntervalSec field is set.
   */
  @java.lang.Override
  public boolean hasCheckIntervalSec() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * </pre>
   *
   * <code>optional int32 check_interval_sec = 345561006;</code>
   *
   * @return The checkIntervalSec.
   */
  @java.lang.Override
  public int getCheckIntervalSec() {
    return checkIntervalSec_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in 3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in 3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in 3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GRPC_HEALTH_CHECK_FIELD_NUMBER = 85529574;
  private com.google.cloud.compute.v1.GRPCHealthCheck grpcHealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
   *
   * @return Whether the grpcHealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasGrpcHealthCheck() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
   *
   * @return The grpcHealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GRPCHealthCheck getGrpcHealthCheck() {
    return grpcHealthCheck_ == null
        ? com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()
        : grpcHealthCheck_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder getGrpcHealthCheckOrBuilder() {
    return grpcHealthCheck_ == null
        ? com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()
        : grpcHealthCheck_;
  }

  public static final int HEALTHY_THRESHOLD_FIELD_NUMBER = 403212361;
  private int healthyThreshold_ = 0;

  /**
   *
   *
   * <pre>
   * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
   * </pre>
   *
   * <code>optional int32 healthy_threshold = 403212361;</code>
   *
   * @return Whether the healthyThreshold field is set.
   */
  @java.lang.Override
  public boolean hasHealthyThreshold() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
   * </pre>
   *
   * <code>optional int32 healthy_threshold = 403212361;</code>
   *
   * @return The healthyThreshold.
   */
  @java.lang.Override
  public int getHealthyThreshold() {
    return healthyThreshold_;
  }

  public static final int HTTP2_HEALTH_CHECK_FIELD_NUMBER = 11360986;
  private com.google.cloud.compute.v1.HTTP2HealthCheck http2HealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;</code>
   *
   * @return Whether the http2HealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasHttp2HealthCheck() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;</code>
   *
   * @return The http2HealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTP2HealthCheck getHttp2HealthCheck() {
    return http2HealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTP2HealthCheck.getDefaultInstance()
        : http2HealthCheck_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTP2HealthCheckOrBuilder getHttp2HealthCheckOrBuilder() {
    return http2HealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTP2HealthCheck.getDefaultInstance()
        : http2HealthCheck_;
  }

  public static final int HTTP_HEALTH_CHECK_FIELD_NUMBER = 412586940;
  private com.google.cloud.compute.v1.HTTPHealthCheck httpHealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
   *
   * @return Whether the httpHealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasHttpHealthCheck() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
   *
   * @return The httpHealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTPHealthCheck getHttpHealthCheck() {
    return httpHealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTPHealthCheck.getDefaultInstance()
        : httpHealthCheck_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTPHealthCheckOrBuilder getHttpHealthCheckOrBuilder() {
    return httpHealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTPHealthCheck.getDefaultInstance()
        : httpHealthCheck_;
  }

  public static final int HTTPS_HEALTH_CHECK_FIELD_NUMBER = 436046905;
  private com.google.cloud.compute.v1.HTTPSHealthCheck httpsHealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;</code>
   *
   * @return Whether the httpsHealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasHttpsHealthCheck() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;</code>
   *
   * @return The httpsHealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTPSHealthCheck getHttpsHealthCheck() {
    return httpsHealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTPSHealthCheck.getDefaultInstance()
        : httpsHealthCheck_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HTTPSHealthCheckOrBuilder getHttpsHealthCheckOrBuilder() {
    return httpsHealthCheck_ == null
        ? com.google.cloud.compute.v1.HTTPSHealthCheck.getDefaultInstance()
        : httpsHealthCheck_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Type of the resource.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOG_CONFIG_FIELD_NUMBER = 351299741;
  private com.google.cloud.compute.v1.HealthCheckLogConfig logConfig_;

  /**
   *
   *
   * <pre>
   * Configure logging on this health check.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  @java.lang.Override
  public boolean hasLogConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Configure logging on this health check.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckLogConfig getLogConfig() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.HealthCheckLogConfig.getDefaultInstance()
        : logConfig_;
  }

  /**
   *
   *
   * <pre>
   * Configure logging on this health check.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheckLogConfigOrBuilder getLogConfigOrBuilder() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.HealthCheckLogConfig.getDefaultInstance()
        : logConfig_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Region where the health check resides. Not applicable to global health checks.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Region where the health check resides. Not applicable to global health checks.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Region where the health check resides. Not applicable to global health checks.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_REGIONS_FIELD_NUMBER = 405568475;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceRegions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
   * </pre>
   *
   * <code>repeated string source_regions = 405568475;</code>
   *
   * @return A list containing the sourceRegions.
   */
  public com.google.protobuf.ProtocolStringList getSourceRegionsList() {
    return sourceRegions_;
  }

  /**
   *
   *
   * <pre>
   * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
   * </pre>
   *
   * <code>repeated string source_regions = 405568475;</code>
   *
   * @return The count of sourceRegions.
   */
  public int getSourceRegionsCount() {
    return sourceRegions_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
   * </pre>
   *
   * <code>repeated string source_regions = 405568475;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceRegions at the given index.
   */
  public java.lang.String getSourceRegions(int index) {
    return sourceRegions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
   * </pre>
   *
   * <code>repeated string source_regions = 405568475;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceRegions at the given index.
   */
  public com.google.protobuf.ByteString getSourceRegionsBytes(int index) {
    return sourceRegions_.getByteString(index);
  }

  public static final int SSL_HEALTH_CHECK_FIELD_NUMBER = 280032440;
  private com.google.cloud.compute.v1.SSLHealthCheck sslHealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
   *
   * @return Whether the sslHealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasSslHealthCheck() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
   *
   * @return The sslHealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SSLHealthCheck getSslHealthCheck() {
    return sslHealthCheck_ == null
        ? com.google.cloud.compute.v1.SSLHealthCheck.getDefaultInstance()
        : sslHealthCheck_;
  }

  /** <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.SSLHealthCheckOrBuilder getSslHealthCheckOrBuilder() {
    return sslHealthCheck_ == null
        ? com.google.cloud.compute.v1.SSLHealthCheck.getDefaultInstance()
        : sslHealthCheck_;
  }

  public static final int TCP_HEALTH_CHECK_FIELD_NUMBER = 469980419;
  private com.google.cloud.compute.v1.TCPHealthCheck tcpHealthCheck_;

  /**
   * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
   *
   * @return Whether the tcpHealthCheck field is set.
   */
  @java.lang.Override
  public boolean hasTcpHealthCheck() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
   *
   * @return The tcpHealthCheck.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.TCPHealthCheck getTcpHealthCheck() {
    return tcpHealthCheck_ == null
        ? com.google.cloud.compute.v1.TCPHealthCheck.getDefaultInstance()
        : tcpHealthCheck_;
  }

  /** <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.TCPHealthCheckOrBuilder getTcpHealthCheckOrBuilder() {
    return tcpHealthCheck_ == null
        ? com.google.cloud.compute.v1.TCPHealthCheck.getDefaultInstance()
        : tcpHealthCheck_;
  }

  public static final int TIMEOUT_SEC_FIELD_NUMBER = 79994995;
  private int timeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return Whether the timeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasTimeoutSec() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return The timeoutSec.
   */
  @java.lang.Override
  public int getTimeoutSec() {
    return timeoutSec_;
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNHEALTHY_THRESHOLD_FIELD_NUMBER = 227958480;
  private int unhealthyThreshold_ = 0;

  /**
   *
   *
   * <pre>
   * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
   * </pre>
   *
   * <code>optional int32 unhealthy_threshold = 227958480;</code>
   *
   * @return Whether the unhealthyThreshold field is set.
   */
  @java.lang.Override
  public boolean hasUnhealthyThreshold() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
   * </pre>
   *
   * <code>optional int32 unhealthy_threshold = 227958480;</code>
   *
   * @return The unhealthyThreshold.
   */
  @java.lang.Override
  public int getUnhealthyThreshold() {
    return unhealthyThreshold_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(11360986, getHttp2HealthCheck());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeInt32(79994995, timeoutSec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(85529574, getGrpcHealthCheck());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeInt32(227958480, unhealthyThreshold_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(280032440, getSslHealthCheck());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(345561006, checkIntervalSec_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(403212361, healthyThreshold_);
    }
    for (int i = 0; i < sourceRegions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 405568475, sourceRegions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(412586940, getHttpHealthCheck());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(436046905, getHttpsHealthCheck());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(469980419, getTcpHealthCheck());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11360986, getHttp2HealthCheck());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(79994995, timeoutSec_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(85529574, getGrpcHealthCheck());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(227958480, unhealthyThreshold_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(280032440, getSslHealthCheck());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(345561006, checkIntervalSec_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351299741, getLogConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(403212361, healthyThreshold_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceRegions_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceRegions_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceRegionsList().size();
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(412586940, getHttpHealthCheck());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              436046905, getHttpsHealthCheck());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(469980419, getTcpHealthCheck());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HealthCheck)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HealthCheck other = (com.google.cloud.compute.v1.HealthCheck) obj;

    if (hasCheckIntervalSec() != other.hasCheckIntervalSec()) return false;
    if (hasCheckIntervalSec()) {
      if (getCheckIntervalSec() != other.getCheckIntervalSec()) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasGrpcHealthCheck() != other.hasGrpcHealthCheck()) return false;
    if (hasGrpcHealthCheck()) {
      if (!getGrpcHealthCheck().equals(other.getGrpcHealthCheck())) return false;
    }
    if (hasHealthyThreshold() != other.hasHealthyThreshold()) return false;
    if (hasHealthyThreshold()) {
      if (getHealthyThreshold() != other.getHealthyThreshold()) return false;
    }
    if (hasHttp2HealthCheck() != other.hasHttp2HealthCheck()) return false;
    if (hasHttp2HealthCheck()) {
      if (!getHttp2HealthCheck().equals(other.getHttp2HealthCheck())) return false;
    }
    if (hasHttpHealthCheck() != other.hasHttpHealthCheck()) return false;
    if (hasHttpHealthCheck()) {
      if (!getHttpHealthCheck().equals(other.getHttpHealthCheck())) return false;
    }
    if (hasHttpsHealthCheck() != other.hasHttpsHealthCheck()) return false;
    if (hasHttpsHealthCheck()) {
      if (!getHttpsHealthCheck().equals(other.getHttpsHealthCheck())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLogConfig() != other.hasLogConfig()) return false;
    if (hasLogConfig()) {
      if (!getLogConfig().equals(other.getLogConfig())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getSourceRegionsList().equals(other.getSourceRegionsList())) return false;
    if (hasSslHealthCheck() != other.hasSslHealthCheck()) return false;
    if (hasSslHealthCheck()) {
      if (!getSslHealthCheck().equals(other.getSslHealthCheck())) return false;
    }
    if (hasTcpHealthCheck() != other.hasTcpHealthCheck()) return false;
    if (hasTcpHealthCheck()) {
      if (!getTcpHealthCheck().equals(other.getTcpHealthCheck())) return false;
    }
    if (hasTimeoutSec() != other.hasTimeoutSec()) return false;
    if (hasTimeoutSec()) {
      if (getTimeoutSec() != other.getTimeoutSec()) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (hasUnhealthyThreshold() != other.hasUnhealthyThreshold()) return false;
    if (hasUnhealthyThreshold()) {
      if (getUnhealthyThreshold() != other.getUnhealthyThreshold()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCheckIntervalSec()) {
      hash = (37 * hash) + CHECK_INTERVAL_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getCheckIntervalSec();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasGrpcHealthCheck()) {
      hash = (37 * hash) + GRPC_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getGrpcHealthCheck().hashCode();
    }
    if (hasHealthyThreshold()) {
      hash = (37 * hash) + HEALTHY_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getHealthyThreshold();
    }
    if (hasHttp2HealthCheck()) {
      hash = (37 * hash) + HTTP2_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getHttp2HealthCheck().hashCode();
    }
    if (hasHttpHealthCheck()) {
      hash = (37 * hash) + HTTP_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getHttpHealthCheck().hashCode();
    }
    if (hasHttpsHealthCheck()) {
      hash = (37 * hash) + HTTPS_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getHttpsHealthCheck().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLogConfig()) {
      hash = (37 * hash) + LOG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLogConfig().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getSourceRegionsCount() > 0) {
      hash = (37 * hash) + SOURCE_REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceRegionsList().hashCode();
    }
    if (hasSslHealthCheck()) {
      hash = (37 * hash) + SSL_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getSslHealthCheck().hashCode();
    }
    if (hasTcpHealthCheck()) {
      hash = (37 * hash) + TCP_HEALTH_CHECK_FIELD_NUMBER;
      hash = (53 * hash) + getTcpHealthCheck().hashCode();
    }
    if (hasTimeoutSec()) {
      hash = (37 * hash) + TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getTimeoutSec();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    if (hasUnhealthyThreshold()) {
      hash = (37 * hash) + UNHEALTHY_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getUnhealthyThreshold();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HealthCheck parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HealthCheck prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a health check resource. Google Compute Engine has two health check resources: * [Regional](/compute/docs/reference/rest/v1/regionHealthChecks) * [Global](/compute/docs/reference/rest/v1/healthChecks) These health check resources can be used for load balancing and for autohealing VMs in a managed instance group (MIG). **Load balancing** Health check requirements vary depending on the type of load balancer. For details about the type of health check supported for each load balancer and corresponding backend type, see Health checks overview: Load balancer guide. **Autohealing in MIGs** The health checks that you use for autohealing VMs in a MIG can be either regional or global. For more information, see Set up an application health check and autohealing. For more information, see Health checks overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HealthCheck}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HealthCheck)
      com.google.cloud.compute.v1.HealthCheckOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthCheck_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HealthCheck.class,
              com.google.cloud.compute.v1.HealthCheck.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HealthCheck.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGrpcHealthCheckFieldBuilder();
        getHttp2HealthCheckFieldBuilder();
        getHttpHealthCheckFieldBuilder();
        getHttpsHealthCheckFieldBuilder();
        getLogConfigFieldBuilder();
        getSslHealthCheckFieldBuilder();
        getTcpHealthCheckFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      checkIntervalSec_ = 0;
      creationTimestamp_ = "";
      description_ = "";
      grpcHealthCheck_ = null;
      if (grpcHealthCheckBuilder_ != null) {
        grpcHealthCheckBuilder_.dispose();
        grpcHealthCheckBuilder_ = null;
      }
      healthyThreshold_ = 0;
      http2HealthCheck_ = null;
      if (http2HealthCheckBuilder_ != null) {
        http2HealthCheckBuilder_.dispose();
        http2HealthCheckBuilder_ = null;
      }
      httpHealthCheck_ = null;
      if (httpHealthCheckBuilder_ != null) {
        httpHealthCheckBuilder_.dispose();
        httpHealthCheckBuilder_ = null;
      }
      httpsHealthCheck_ = null;
      if (httpsHealthCheckBuilder_ != null) {
        httpsHealthCheckBuilder_.dispose();
        httpsHealthCheckBuilder_ = null;
      }
      id_ = 0L;
      kind_ = "";
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      name_ = "";
      region_ = "";
      selfLink_ = "";
      sourceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sslHealthCheck_ = null;
      if (sslHealthCheckBuilder_ != null) {
        sslHealthCheckBuilder_.dispose();
        sslHealthCheckBuilder_ = null;
      }
      tcpHealthCheck_ = null;
      if (tcpHealthCheckBuilder_ != null) {
        tcpHealthCheckBuilder_.dispose();
        tcpHealthCheckBuilder_ = null;
      }
      timeoutSec_ = 0;
      type_ = "";
      unhealthyThreshold_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HealthCheck_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthCheck getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HealthCheck.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthCheck build() {
      com.google.cloud.compute.v1.HealthCheck result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HealthCheck buildPartial() {
      com.google.cloud.compute.v1.HealthCheck result =
          new com.google.cloud.compute.v1.HealthCheck(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HealthCheck result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.checkIntervalSec_ = checkIntervalSec_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.grpcHealthCheck_ =
            grpcHealthCheckBuilder_ == null ? grpcHealthCheck_ : grpcHealthCheckBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.healthyThreshold_ = healthyThreshold_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.http2HealthCheck_ =
            http2HealthCheckBuilder_ == null ? http2HealthCheck_ : http2HealthCheckBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.httpHealthCheck_ =
            httpHealthCheckBuilder_ == null ? httpHealthCheck_ : httpHealthCheckBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.httpsHealthCheck_ =
            httpsHealthCheckBuilder_ == null ? httpsHealthCheck_ : httpsHealthCheckBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.logConfig_ = logConfigBuilder_ == null ? logConfig_ : logConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        sourceRegions_.makeImmutable();
        result.sourceRegions_ = sourceRegions_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sslHealthCheck_ =
            sslHealthCheckBuilder_ == null ? sslHealthCheck_ : sslHealthCheckBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.tcpHealthCheck_ =
            tcpHealthCheckBuilder_ == null ? tcpHealthCheck_ : tcpHealthCheckBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.timeoutSec_ = timeoutSec_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.unhealthyThreshold_ = unhealthyThreshold_;
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HealthCheck) {
        return mergeFrom((com.google.cloud.compute.v1.HealthCheck) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HealthCheck other) {
      if (other == com.google.cloud.compute.v1.HealthCheck.getDefaultInstance()) return this;
      if (other.hasCheckIntervalSec()) {
        setCheckIntervalSec(other.getCheckIntervalSec());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasGrpcHealthCheck()) {
        mergeGrpcHealthCheck(other.getGrpcHealthCheck());
      }
      if (other.hasHealthyThreshold()) {
        setHealthyThreshold(other.getHealthyThreshold());
      }
      if (other.hasHttp2HealthCheck()) {
        mergeHttp2HealthCheck(other.getHttp2HealthCheck());
      }
      if (other.hasHttpHealthCheck()) {
        mergeHttpHealthCheck(other.getHttpHealthCheck());
      }
      if (other.hasHttpsHealthCheck()) {
        mergeHttpsHealthCheck(other.getHttpsHealthCheck());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasLogConfig()) {
        mergeLogConfig(other.getLogConfig());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.sourceRegions_.isEmpty()) {
        if (sourceRegions_.isEmpty()) {
          sourceRegions_ = other.sourceRegions_;
          bitField0_ |= 0x00004000;
        } else {
          ensureSourceRegionsIsMutable();
          sourceRegions_.addAll(other.sourceRegions_);
        }
        onChanged();
      }
      if (other.hasSslHealthCheck()) {
        mergeSslHealthCheck(other.getSslHealthCheck());
      }
      if (other.hasTcpHealthCheck()) {
        mergeTcpHealthCheck(other.getTcpHealthCheck());
      }
      if (other.hasTimeoutSec()) {
        setTimeoutSec(other.getTimeoutSec());
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasUnhealthyThreshold()) {
        setUnhealthyThreshold(other.getUnhealthyThreshold());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 28604882
            case 90887890:
              {
                input.readMessage(
                    getHttp2HealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 90887890
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 639959960:
              {
                timeoutSec_ = input.readInt32();
                bitField0_ |= 0x00020000;
                break;
              } // case 639959960
            case 684236594:
              {
                input.readMessage(getGrpcHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 684236594
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1111570338
            case 1823667840:
              {
                unhealthyThreshold_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 1823667840
            case -2054707774:
              {
                input.readMessage(getSslHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case -2054707774
            case -1530479248:
              {
                checkIntervalSec_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case -1530479248
            case -1484569366:
              {
                input.readMessage(getLogConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case -1484569366
            case -1069268408:
              {
                healthyThreshold_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case -1069268408
            case -1050419494:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceRegionsIsMutable();
                sourceRegions_.add(s);
                break;
              } // case -1050419494
            case -994271774:
              {
                input.readMessage(getHttpHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -994271774
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -806592054:
              {
                input.readMessage(
                    getHttpsHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -806592054
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -645248918
            case -535123942:
              {
                input.readMessage(getTcpHealthCheckFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case -535123942
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int checkIntervalSec_;

    /**
     *
     *
     * <pre>
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     * </pre>
     *
     * <code>optional int32 check_interval_sec = 345561006;</code>
     *
     * @return Whether the checkIntervalSec field is set.
     */
    @java.lang.Override
    public boolean hasCheckIntervalSec() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     * </pre>
     *
     * <code>optional int32 check_interval_sec = 345561006;</code>
     *
     * @return The checkIntervalSec.
     */
    @java.lang.Override
    public int getCheckIntervalSec() {
      return checkIntervalSec_;
    }

    /**
     *
     *
     * <pre>
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     * </pre>
     *
     * <code>optional int32 check_interval_sec = 345561006;</code>
     *
     * @param value The checkIntervalSec to set.
     * @return This builder for chaining.
     */
    public Builder setCheckIntervalSec(int value) {

      checkIntervalSec_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     * </pre>
     *
     * <code>optional int32 check_interval_sec = 345561006;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCheckIntervalSec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      checkIntervalSec_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in 3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.GRPCHealthCheck grpcHealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.GRPCHealthCheck,
            com.google.cloud.compute.v1.GRPCHealthCheck.Builder,
            com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder>
        grpcHealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     *
     * @return Whether the grpcHealthCheck field is set.
     */
    public boolean hasGrpcHealthCheck() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     *
     * @return The grpcHealthCheck.
     */
    public com.google.cloud.compute.v1.GRPCHealthCheck getGrpcHealthCheck() {
      if (grpcHealthCheckBuilder_ == null) {
        return grpcHealthCheck_ == null
            ? com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()
            : grpcHealthCheck_;
      } else {
        return grpcHealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public Builder setGrpcHealthCheck(com.google.cloud.compute.v1.GRPCHealthCheck value) {
      if (grpcHealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        grpcHealthCheck_ = value;
      } else {
        grpcHealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public Builder setGrpcHealthCheck(
        com.google.cloud.compute.v1.GRPCHealthCheck.Builder builderForValue) {
      if (grpcHealthCheckBuilder_ == null) {
        grpcHealthCheck_ = builderForValue.build();
      } else {
        grpcHealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public Builder mergeGrpcHealthCheck(com.google.cloud.compute.v1.GRPCHealthCheck value) {
      if (grpcHealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && grpcHealthCheck_ != null
            && grpcHealthCheck_
                != com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()) {
          getGrpcHealthCheckBuilder().mergeFrom(value);
        } else {
          grpcHealthCheck_ = value;
        }
      } else {
        grpcHealthCheckBuilder_.mergeFrom(value);
      }
      if (grpcHealthCheck_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public Builder clearGrpcHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00000008);
      grpcHealthCheck_ = null;
      if (grpcHealthCheckBuilder_ != null) {
        grpcHealthCheckBuilder_.dispose();
        grpcHealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public com.google.cloud.compute.v1.GRPCHealthCheck.Builder getGrpcHealthCheckBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGrpcHealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    public com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder getGrpcHealthCheckOrBuilder() {
      if (grpcHealthCheckBuilder_ != null) {
        return grpcHealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return grpcHealthCheck_ == null
            ? com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()
            : grpcHealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.GRPCHealthCheck grpc_health_check = 85529574;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.GRPCHealthCheck,
            com.google.cloud.compute.v1.GRPCHealthCheck.Builder,
            com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder>
        getGrpcHealthCheckFieldBuilder() {
      if (grpcHealthCheckBuilder_ == null) {
        grpcHealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.GRPCHealthCheck,
                com.google.cloud.compute.v1.GRPCHealthCheck.Builder,
                com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder>(
                getGrpcHealthCheck(), getParentForChildren(), isClean());
        grpcHealthCheck_ = null;
      }
      return grpcHealthCheckBuilder_;
    }

    private int healthyThreshold_;

    /**
     *
     *
     * <pre>
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     * </pre>
     *
     * <code>optional int32 healthy_threshold = 403212361;</code>
     *
     * @return Whether the healthyThreshold field is set.
     */
    @java.lang.Override
    public boolean hasHealthyThreshold() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     * </pre>
     *
     * <code>optional int32 healthy_threshold = 403212361;</code>
     *
     * @return The healthyThreshold.
     */
    @java.lang.Override
    public int getHealthyThreshold() {
      return healthyThreshold_;
    }

    /**
     *
     *
     * <pre>
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     * </pre>
     *
     * <code>optional int32 healthy_threshold = 403212361;</code>
     *
     * @param value The healthyThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setHealthyThreshold(int value) {

      healthyThreshold_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     * </pre>
     *
     * <code>optional int32 healthy_threshold = 403212361;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHealthyThreshold() {
      bitField0_ = (bitField0_ & ~0x00000010);
      healthyThreshold_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HTTP2HealthCheck http2HealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTP2HealthCheck,
            com.google.cloud.compute.v1.HTTP2HealthCheck.Builder,
            com.google.cloud.compute.v1.HTTP2HealthCheckOrBuilder>
        http2HealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     *
     * @return Whether the http2HealthCheck field is set.
     */
    public boolean hasHttp2HealthCheck() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     *
     * @return The http2HealthCheck.
     */
    public com.google.cloud.compute.v1.HTTP2HealthCheck getHttp2HealthCheck() {
      if (http2HealthCheckBuilder_ == null) {
        return http2HealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTP2HealthCheck.getDefaultInstance()
            : http2HealthCheck_;
      } else {
        return http2HealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public Builder setHttp2HealthCheck(com.google.cloud.compute.v1.HTTP2HealthCheck value) {
      if (http2HealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        http2HealthCheck_ = value;
      } else {
        http2HealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public Builder setHttp2HealthCheck(
        com.google.cloud.compute.v1.HTTP2HealthCheck.Builder builderForValue) {
      if (http2HealthCheckBuilder_ == null) {
        http2HealthCheck_ = builderForValue.build();
      } else {
        http2HealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public Builder mergeHttp2HealthCheck(com.google.cloud.compute.v1.HTTP2HealthCheck value) {
      if (http2HealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && http2HealthCheck_ != null
            && http2HealthCheck_
                != com.google.cloud.compute.v1.HTTP2HealthCheck.getDefaultInstance()) {
          getHttp2HealthCheckBuilder().mergeFrom(value);
        } else {
          http2HealthCheck_ = value;
        }
      } else {
        http2HealthCheckBuilder_.mergeFrom(value);
      }
      if (http2HealthCheck_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public Builder clearHttp2HealthCheck() {
      bitField0_ = (bitField0_ & ~0x00000020);
      http2HealthCheck_ = null;
      if (http2HealthCheckBuilder_ != null) {
        http2HealthCheckBuilder_.dispose();
        http2HealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public com.google.cloud.compute.v1.HTTP2HealthCheck.Builder getHttp2HealthCheckBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getHttp2HealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    public com.google.cloud.compute.v1.HTTP2HealthCheckOrBuilder getHttp2HealthCheckOrBuilder() {
      if (http2HealthCheckBuilder_ != null) {
        return http2HealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return http2HealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTP2HealthCheck.getDefaultInstance()
            : http2HealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTP2HealthCheck http2_health_check = 11360986;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTP2HealthCheck,
            com.google.cloud.compute.v1.HTTP2HealthCheck.Builder,
            com.google.cloud.compute.v1.HTTP2HealthCheckOrBuilder>
        getHttp2HealthCheckFieldBuilder() {
      if (http2HealthCheckBuilder_ == null) {
        http2HealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HTTP2HealthCheck,
                com.google.cloud.compute.v1.HTTP2HealthCheck.Builder,
                com.google.cloud.compute.v1.HTTP2HealthCheckOrBuilder>(
                getHttp2HealthCheck(), getParentForChildren(), isClean());
        http2HealthCheck_ = null;
      }
      return http2HealthCheckBuilder_;
    }

    private com.google.cloud.compute.v1.HTTPHealthCheck httpHealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTPHealthCheck,
            com.google.cloud.compute.v1.HTTPHealthCheck.Builder,
            com.google.cloud.compute.v1.HTTPHealthCheckOrBuilder>
        httpHealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     *
     * @return Whether the httpHealthCheck field is set.
     */
    public boolean hasHttpHealthCheck() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     *
     * @return The httpHealthCheck.
     */
    public com.google.cloud.compute.v1.HTTPHealthCheck getHttpHealthCheck() {
      if (httpHealthCheckBuilder_ == null) {
        return httpHealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTPHealthCheck.getDefaultInstance()
            : httpHealthCheck_;
      } else {
        return httpHealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public Builder setHttpHealthCheck(com.google.cloud.compute.v1.HTTPHealthCheck value) {
      if (httpHealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpHealthCheck_ = value;
      } else {
        httpHealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public Builder setHttpHealthCheck(
        com.google.cloud.compute.v1.HTTPHealthCheck.Builder builderForValue) {
      if (httpHealthCheckBuilder_ == null) {
        httpHealthCheck_ = builderForValue.build();
      } else {
        httpHealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public Builder mergeHttpHealthCheck(com.google.cloud.compute.v1.HTTPHealthCheck value) {
      if (httpHealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && httpHealthCheck_ != null
            && httpHealthCheck_
                != com.google.cloud.compute.v1.HTTPHealthCheck.getDefaultInstance()) {
          getHttpHealthCheckBuilder().mergeFrom(value);
        } else {
          httpHealthCheck_ = value;
        }
      } else {
        httpHealthCheckBuilder_.mergeFrom(value);
      }
      if (httpHealthCheck_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public Builder clearHttpHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00000040);
      httpHealthCheck_ = null;
      if (httpHealthCheckBuilder_ != null) {
        httpHealthCheckBuilder_.dispose();
        httpHealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public com.google.cloud.compute.v1.HTTPHealthCheck.Builder getHttpHealthCheckBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getHttpHealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    public com.google.cloud.compute.v1.HTTPHealthCheckOrBuilder getHttpHealthCheckOrBuilder() {
      if (httpHealthCheckBuilder_ != null) {
        return httpHealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return httpHealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTPHealthCheck.getDefaultInstance()
            : httpHealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPHealthCheck http_health_check = 412586940;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTPHealthCheck,
            com.google.cloud.compute.v1.HTTPHealthCheck.Builder,
            com.google.cloud.compute.v1.HTTPHealthCheckOrBuilder>
        getHttpHealthCheckFieldBuilder() {
      if (httpHealthCheckBuilder_ == null) {
        httpHealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HTTPHealthCheck,
                com.google.cloud.compute.v1.HTTPHealthCheck.Builder,
                com.google.cloud.compute.v1.HTTPHealthCheckOrBuilder>(
                getHttpHealthCheck(), getParentForChildren(), isClean());
        httpHealthCheck_ = null;
      }
      return httpHealthCheckBuilder_;
    }

    private com.google.cloud.compute.v1.HTTPSHealthCheck httpsHealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTPSHealthCheck,
            com.google.cloud.compute.v1.HTTPSHealthCheck.Builder,
            com.google.cloud.compute.v1.HTTPSHealthCheckOrBuilder>
        httpsHealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     *
     * @return Whether the httpsHealthCheck field is set.
     */
    public boolean hasHttpsHealthCheck() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     *
     * @return The httpsHealthCheck.
     */
    public com.google.cloud.compute.v1.HTTPSHealthCheck getHttpsHealthCheck() {
      if (httpsHealthCheckBuilder_ == null) {
        return httpsHealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTPSHealthCheck.getDefaultInstance()
            : httpsHealthCheck_;
      } else {
        return httpsHealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public Builder setHttpsHealthCheck(com.google.cloud.compute.v1.HTTPSHealthCheck value) {
      if (httpsHealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpsHealthCheck_ = value;
      } else {
        httpsHealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public Builder setHttpsHealthCheck(
        com.google.cloud.compute.v1.HTTPSHealthCheck.Builder builderForValue) {
      if (httpsHealthCheckBuilder_ == null) {
        httpsHealthCheck_ = builderForValue.build();
      } else {
        httpsHealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public Builder mergeHttpsHealthCheck(com.google.cloud.compute.v1.HTTPSHealthCheck value) {
      if (httpsHealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && httpsHealthCheck_ != null
            && httpsHealthCheck_
                != com.google.cloud.compute.v1.HTTPSHealthCheck.getDefaultInstance()) {
          getHttpsHealthCheckBuilder().mergeFrom(value);
        } else {
          httpsHealthCheck_ = value;
        }
      } else {
        httpsHealthCheckBuilder_.mergeFrom(value);
      }
      if (httpsHealthCheck_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public Builder clearHttpsHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00000080);
      httpsHealthCheck_ = null;
      if (httpsHealthCheckBuilder_ != null) {
        httpsHealthCheckBuilder_.dispose();
        httpsHealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public com.google.cloud.compute.v1.HTTPSHealthCheck.Builder getHttpsHealthCheckBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getHttpsHealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    public com.google.cloud.compute.v1.HTTPSHealthCheckOrBuilder getHttpsHealthCheckOrBuilder() {
      if (httpsHealthCheckBuilder_ != null) {
        return httpsHealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return httpsHealthCheck_ == null
            ? com.google.cloud.compute.v1.HTTPSHealthCheck.getDefaultInstance()
            : httpsHealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.HTTPSHealthCheck https_health_check = 436046905;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HTTPSHealthCheck,
            com.google.cloud.compute.v1.HTTPSHealthCheck.Builder,
            com.google.cloud.compute.v1.HTTPSHealthCheckOrBuilder>
        getHttpsHealthCheckFieldBuilder() {
      if (httpsHealthCheckBuilder_ == null) {
        httpsHealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HTTPSHealthCheck,
                com.google.cloud.compute.v1.HTTPSHealthCheck.Builder,
                com.google.cloud.compute.v1.HTTPSHealthCheckOrBuilder>(
                getHttpsHealthCheck(), getParentForChildren(), isClean());
        httpsHealthCheck_ = null;
      }
      return httpsHealthCheckBuilder_;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000100);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of the resource.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HealthCheckLogConfig logConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckLogConfig,
            com.google.cloud.compute.v1.HealthCheckLogConfig.Builder,
            com.google.cloud.compute.v1.HealthCheckLogConfigOrBuilder>
        logConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     *
     * @return Whether the logConfig field is set.
     */
    public boolean hasLogConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     *
     * @return The logConfig.
     */
    public com.google.cloud.compute.v1.HealthCheckLogConfig getLogConfig() {
      if (logConfigBuilder_ == null) {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.HealthCheckLogConfig.getDefaultInstance()
            : logConfig_;
      } else {
        return logConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(com.google.cloud.compute.v1.HealthCheckLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logConfig_ = value;
      } else {
        logConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(
        com.google.cloud.compute.v1.HealthCheckLogConfig.Builder builderForValue) {
      if (logConfigBuilder_ == null) {
        logConfig_ = builderForValue.build();
      } else {
        logConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public Builder mergeLogConfig(com.google.cloud.compute.v1.HealthCheckLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && logConfig_ != null
            && logConfig_
                != com.google.cloud.compute.v1.HealthCheckLogConfig.getDefaultInstance()) {
          getLogConfigBuilder().mergeFrom(value);
        } else {
          logConfig_ = value;
        }
      } else {
        logConfigBuilder_.mergeFrom(value);
      }
      if (logConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public Builder clearLogConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.HealthCheckLogConfig.Builder getLogConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLogConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.HealthCheckLogConfigOrBuilder getLogConfigOrBuilder() {
      if (logConfigBuilder_ != null) {
        return logConfigBuilder_.getMessageOrBuilder();
      } else {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.HealthCheckLogConfig.getDefaultInstance()
            : logConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this health check.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HealthCheckLogConfig log_config = 351299741;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HealthCheckLogConfig,
            com.google.cloud.compute.v1.HealthCheckLogConfig.Builder,
            com.google.cloud.compute.v1.HealthCheckLogConfigOrBuilder>
        getLogConfigFieldBuilder() {
      if (logConfigBuilder_ == null) {
        logConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HealthCheckLogConfig,
                com.google.cloud.compute.v1.HealthCheckLogConfig.Builder,
                com.google.cloud.compute.v1.HealthCheckLogConfigOrBuilder>(
                getLogConfig(), getParentForChildren(), isClean());
        logConfig_ = null;
      }
      return logConfigBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Region where the health check resides. Not applicable to global health checks.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceRegionsIsMutable() {
      if (!sourceRegions_.isModifiable()) {
        sourceRegions_ = new com.google.protobuf.LazyStringArrayList(sourceRegions_);
      }
      bitField0_ |= 0x00004000;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @return A list containing the sourceRegions.
     */
    public com.google.protobuf.ProtocolStringList getSourceRegionsList() {
      sourceRegions_.makeImmutable();
      return sourceRegions_;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @return The count of sourceRegions.
     */
    public int getSourceRegionsCount() {
      return sourceRegions_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceRegions at the given index.
     */
    public java.lang.String getSourceRegions(int index) {
      return sourceRegions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceRegions at the given index.
     */
    public com.google.protobuf.ByteString getSourceRegionsBytes(int index) {
      return sourceRegions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceRegions to set.
     * @return This builder for chaining.
     */
    public Builder setSourceRegions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceRegionsIsMutable();
      sourceRegions_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param value The sourceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSourceRegions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceRegionsIsMutable();
      sourceRegions_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param values The sourceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceRegions(java.lang.Iterable<java.lang.String> values) {
      ensureSourceRegionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceRegions_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceRegions() {
      sourceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of cloud regions from which health checks are performed. If any regions are specified, then exactly 3 regions should be specified. The region names must be valid names of Google Cloud regions. This can only be set for global health check. If this list is non-empty, then there are restrictions on what other health check fields are supported and what other resources can use this health check: - SSL, HTTP2, and GRPC protocols are not supported. - The TCP request field is not supported. - The proxyHeader field for HTTP, HTTPS, and TCP is not supported. - The checkIntervalSec field must be at least 30. - The health check cannot be used with BackendService nor with managed instance group auto-healing.
     * </pre>
     *
     * <code>repeated string source_regions = 405568475;</code>
     *
     * @param value The bytes of the sourceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSourceRegionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceRegionsIsMutable();
      sourceRegions_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SSLHealthCheck sslHealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SSLHealthCheck,
            com.google.cloud.compute.v1.SSLHealthCheck.Builder,
            com.google.cloud.compute.v1.SSLHealthCheckOrBuilder>
        sslHealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     *
     * @return Whether the sslHealthCheck field is set.
     */
    public boolean hasSslHealthCheck() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     *
     * @return The sslHealthCheck.
     */
    public com.google.cloud.compute.v1.SSLHealthCheck getSslHealthCheck() {
      if (sslHealthCheckBuilder_ == null) {
        return sslHealthCheck_ == null
            ? com.google.cloud.compute.v1.SSLHealthCheck.getDefaultInstance()
            : sslHealthCheck_;
      } else {
        return sslHealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public Builder setSslHealthCheck(com.google.cloud.compute.v1.SSLHealthCheck value) {
      if (sslHealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sslHealthCheck_ = value;
      } else {
        sslHealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public Builder setSslHealthCheck(
        com.google.cloud.compute.v1.SSLHealthCheck.Builder builderForValue) {
      if (sslHealthCheckBuilder_ == null) {
        sslHealthCheck_ = builderForValue.build();
      } else {
        sslHealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public Builder mergeSslHealthCheck(com.google.cloud.compute.v1.SSLHealthCheck value) {
      if (sslHealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && sslHealthCheck_ != null
            && sslHealthCheck_ != com.google.cloud.compute.v1.SSLHealthCheck.getDefaultInstance()) {
          getSslHealthCheckBuilder().mergeFrom(value);
        } else {
          sslHealthCheck_ = value;
        }
      } else {
        sslHealthCheckBuilder_.mergeFrom(value);
      }
      if (sslHealthCheck_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public Builder clearSslHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00008000);
      sslHealthCheck_ = null;
      if (sslHealthCheckBuilder_ != null) {
        sslHealthCheckBuilder_.dispose();
        sslHealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public com.google.cloud.compute.v1.SSLHealthCheck.Builder getSslHealthCheckBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getSslHealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    public com.google.cloud.compute.v1.SSLHealthCheckOrBuilder getSslHealthCheckOrBuilder() {
      if (sslHealthCheckBuilder_ != null) {
        return sslHealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return sslHealthCheck_ == null
            ? com.google.cloud.compute.v1.SSLHealthCheck.getDefaultInstance()
            : sslHealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.SSLHealthCheck ssl_health_check = 280032440;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SSLHealthCheck,
            com.google.cloud.compute.v1.SSLHealthCheck.Builder,
            com.google.cloud.compute.v1.SSLHealthCheckOrBuilder>
        getSslHealthCheckFieldBuilder() {
      if (sslHealthCheckBuilder_ == null) {
        sslHealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SSLHealthCheck,
                com.google.cloud.compute.v1.SSLHealthCheck.Builder,
                com.google.cloud.compute.v1.SSLHealthCheckOrBuilder>(
                getSslHealthCheck(), getParentForChildren(), isClean());
        sslHealthCheck_ = null;
      }
      return sslHealthCheckBuilder_;
    }

    private com.google.cloud.compute.v1.TCPHealthCheck tcpHealthCheck_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.TCPHealthCheck,
            com.google.cloud.compute.v1.TCPHealthCheck.Builder,
            com.google.cloud.compute.v1.TCPHealthCheckOrBuilder>
        tcpHealthCheckBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     *
     * @return Whether the tcpHealthCheck field is set.
     */
    public boolean hasTcpHealthCheck() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     *
     * @return The tcpHealthCheck.
     */
    public com.google.cloud.compute.v1.TCPHealthCheck getTcpHealthCheck() {
      if (tcpHealthCheckBuilder_ == null) {
        return tcpHealthCheck_ == null
            ? com.google.cloud.compute.v1.TCPHealthCheck.getDefaultInstance()
            : tcpHealthCheck_;
      } else {
        return tcpHealthCheckBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public Builder setTcpHealthCheck(com.google.cloud.compute.v1.TCPHealthCheck value) {
      if (tcpHealthCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tcpHealthCheck_ = value;
      } else {
        tcpHealthCheckBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public Builder setTcpHealthCheck(
        com.google.cloud.compute.v1.TCPHealthCheck.Builder builderForValue) {
      if (tcpHealthCheckBuilder_ == null) {
        tcpHealthCheck_ = builderForValue.build();
      } else {
        tcpHealthCheckBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public Builder mergeTcpHealthCheck(com.google.cloud.compute.v1.TCPHealthCheck value) {
      if (tcpHealthCheckBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && tcpHealthCheck_ != null
            && tcpHealthCheck_ != com.google.cloud.compute.v1.TCPHealthCheck.getDefaultInstance()) {
          getTcpHealthCheckBuilder().mergeFrom(value);
        } else {
          tcpHealthCheck_ = value;
        }
      } else {
        tcpHealthCheckBuilder_.mergeFrom(value);
      }
      if (tcpHealthCheck_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public Builder clearTcpHealthCheck() {
      bitField0_ = (bitField0_ & ~0x00010000);
      tcpHealthCheck_ = null;
      if (tcpHealthCheckBuilder_ != null) {
        tcpHealthCheckBuilder_.dispose();
        tcpHealthCheckBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public com.google.cloud.compute.v1.TCPHealthCheck.Builder getTcpHealthCheckBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getTcpHealthCheckFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    public com.google.cloud.compute.v1.TCPHealthCheckOrBuilder getTcpHealthCheckOrBuilder() {
      if (tcpHealthCheckBuilder_ != null) {
        return tcpHealthCheckBuilder_.getMessageOrBuilder();
      } else {
        return tcpHealthCheck_ == null
            ? com.google.cloud.compute.v1.TCPHealthCheck.getDefaultInstance()
            : tcpHealthCheck_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.TCPHealthCheck tcp_health_check = 469980419;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.TCPHealthCheck,
            com.google.cloud.compute.v1.TCPHealthCheck.Builder,
            com.google.cloud.compute.v1.TCPHealthCheckOrBuilder>
        getTcpHealthCheckFieldBuilder() {
      if (tcpHealthCheckBuilder_ == null) {
        tcpHealthCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.TCPHealthCheck,
                com.google.cloud.compute.v1.TCPHealthCheck.Builder,
                com.google.cloud.compute.v1.TCPHealthCheckOrBuilder>(
                getTcpHealthCheck(), getParentForChildren(), isClean());
        tcpHealthCheck_ = null;
      }
      return tcpHealthCheckBuilder_;
    }

    private int timeoutSec_;

    /**
     *
     *
     * <pre>
     * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return Whether the timeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasTimeoutSec() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return The timeoutSec.
     */
    @java.lang.Override
    public int getTimeoutSec() {
      return timeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @param value The timeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setTimeoutSec(int value) {

      timeoutSec_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
     * </pre>
     *
     * <code>optional int32 timeout_sec = 79994995;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00020000);
      timeoutSec_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int unhealthyThreshold_;

    /**
     *
     *
     * <pre>
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     * </pre>
     *
     * <code>optional int32 unhealthy_threshold = 227958480;</code>
     *
     * @return Whether the unhealthyThreshold field is set.
     */
    @java.lang.Override
    public boolean hasUnhealthyThreshold() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     * </pre>
     *
     * <code>optional int32 unhealthy_threshold = 227958480;</code>
     *
     * @return The unhealthyThreshold.
     */
    @java.lang.Override
    public int getUnhealthyThreshold() {
      return unhealthyThreshold_;
    }

    /**
     *
     *
     * <pre>
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     * </pre>
     *
     * <code>optional int32 unhealthy_threshold = 227958480;</code>
     *
     * @param value The unhealthyThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setUnhealthyThreshold(int value) {

      unhealthyThreshold_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     * </pre>
     *
     * <code>optional int32 unhealthy_threshold = 227958480;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnhealthyThreshold() {
      bitField0_ = (bitField0_ & ~0x00080000);
      unhealthyThreshold_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HealthCheck)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HealthCheck)
  private static final com.google.cloud.compute.v1.HealthCheck DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HealthCheck();
  }

  public static com.google.cloud.compute.v1.HealthCheck getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HealthCheck> PARSER =
      new com.google.protobuf.AbstractParser<HealthCheck>() {
        @java.lang.Override
        public HealthCheck parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HealthCheck> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HealthCheck> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HealthCheck getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
