/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The retry policy associates with HttpRouteRule
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpRetryPolicy}
 */
public final class HttpRetryPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpRetryPolicy)
    HttpRetryPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use HttpRetryPolicy.newBuilder() to construct.
  private HttpRetryPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRetryPolicy() {
    retryConditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRetryPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRetryPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRetryPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpRetryPolicy.class,
            com.google.cloud.compute.v1.HttpRetryPolicy.Builder.class);
  }

  private int bitField0_;
  public static final int NUM_RETRIES_FIELD_NUMBER = 251680141;
  private int numRetries_ = 0;

  /**
   *
   *
   * <pre>
   * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
   * </pre>
   *
   * <code>optional uint32 num_retries = 251680141;</code>
   *
   * @return Whether the numRetries field is set.
   */
  @java.lang.Override
  public boolean hasNumRetries() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
   * </pre>
   *
   * <code>optional uint32 num_retries = 251680141;</code>
   *
   * @return The numRetries.
   */
  @java.lang.Override
  public int getNumRetries() {
    return numRetries_;
  }

  public static final int PER_TRY_TIMEOUT_FIELD_NUMBER = 280041147;
  private com.google.cloud.compute.v1.Duration perTryTimeout_;

  /**
   *
   *
   * <pre>
   * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
   *
   * @return Whether the perTryTimeout field is set.
   */
  @java.lang.Override
  public boolean hasPerTryTimeout() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
   *
   * @return The perTryTimeout.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getPerTryTimeout() {
    return perTryTimeout_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : perTryTimeout_;
  }

  /**
   *
   *
   * <pre>
   * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getPerTryTimeoutOrBuilder() {
    return perTryTimeout_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : perTryTimeout_;
  }

  public static final int RETRY_CONDITIONS_FIELD_NUMBER = 28815535;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList retryConditions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
   * </pre>
   *
   * <code>repeated string retry_conditions = 28815535;</code>
   *
   * @return A list containing the retryConditions.
   */
  public com.google.protobuf.ProtocolStringList getRetryConditionsList() {
    return retryConditions_;
  }

  /**
   *
   *
   * <pre>
   * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
   * </pre>
   *
   * <code>repeated string retry_conditions = 28815535;</code>
   *
   * @return The count of retryConditions.
   */
  public int getRetryConditionsCount() {
    return retryConditions_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
   * </pre>
   *
   * <code>repeated string retry_conditions = 28815535;</code>
   *
   * @param index The index of the element to return.
   * @return The retryConditions at the given index.
   */
  public java.lang.String getRetryConditions(int index) {
    return retryConditions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
   * </pre>
   *
   * <code>repeated string retry_conditions = 28815535;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the retryConditions at the given index.
   */
  public com.google.protobuf.ByteString getRetryConditionsBytes(int index) {
    return retryConditions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < retryConditions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 28815535, retryConditions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeUInt32(251680141, numRetries_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(280041147, getPerTryTimeout());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < retryConditions_.size(); i++) {
        dataSize += computeStringSizeNoTag(retryConditions_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getRetryConditionsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(251680141, numRetries_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(280041147, getPerTryTimeout());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpRetryPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpRetryPolicy other =
        (com.google.cloud.compute.v1.HttpRetryPolicy) obj;

    if (hasNumRetries() != other.hasNumRetries()) return false;
    if (hasNumRetries()) {
      if (getNumRetries() != other.getNumRetries()) return false;
    }
    if (hasPerTryTimeout() != other.hasPerTryTimeout()) return false;
    if (hasPerTryTimeout()) {
      if (!getPerTryTimeout().equals(other.getPerTryTimeout())) return false;
    }
    if (!getRetryConditionsList().equals(other.getRetryConditionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNumRetries()) {
      hash = (37 * hash) + NUM_RETRIES_FIELD_NUMBER;
      hash = (53 * hash) + getNumRetries();
    }
    if (hasPerTryTimeout()) {
      hash = (37 * hash) + PER_TRY_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getPerTryTimeout().hashCode();
    }
    if (getRetryConditionsCount() > 0) {
      hash = (37 * hash) + RETRY_CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRetryConditionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpRetryPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The retry policy associates with HttpRouteRule
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpRetryPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpRetryPolicy)
      com.google.cloud.compute.v1.HttpRetryPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRetryPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRetryPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpRetryPolicy.class,
              com.google.cloud.compute.v1.HttpRetryPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpRetryPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPerTryTimeoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      numRetries_ = 0;
      perTryTimeout_ = null;
      if (perTryTimeoutBuilder_ != null) {
        perTryTimeoutBuilder_.dispose();
        perTryTimeoutBuilder_ = null;
      }
      retryConditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRetryPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRetryPolicy getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRetryPolicy build() {
      com.google.cloud.compute.v1.HttpRetryPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRetryPolicy buildPartial() {
      com.google.cloud.compute.v1.HttpRetryPolicy result =
          new com.google.cloud.compute.v1.HttpRetryPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpRetryPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.numRetries_ = numRetries_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.perTryTimeout_ =
            perTryTimeoutBuilder_ == null ? perTryTimeout_ : perTryTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        retryConditions_.makeImmutable();
        result.retryConditions_ = retryConditions_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpRetryPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.HttpRetryPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpRetryPolicy other) {
      if (other == com.google.cloud.compute.v1.HttpRetryPolicy.getDefaultInstance()) return this;
      if (other.hasNumRetries()) {
        setNumRetries(other.getNumRetries());
      }
      if (other.hasPerTryTimeout()) {
        mergePerTryTimeout(other.getPerTryTimeout());
      }
      if (!other.retryConditions_.isEmpty()) {
        if (retryConditions_.isEmpty()) {
          retryConditions_ = other.retryConditions_;
          bitField0_ |= 0x00000004;
        } else {
          ensureRetryConditionsIsMutable();
          retryConditions_.addAll(other.retryConditions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 230524282:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRetryConditionsIsMutable();
                retryConditions_.add(s);
                break;
              } // case 230524282
            case 2013441128:
              {
                numRetries_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 2013441128
            case -2054638118:
              {
                input.readMessage(getPerTryTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -2054638118
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int numRetries_;

    /**
     *
     *
     * <pre>
     * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
     * </pre>
     *
     * <code>optional uint32 num_retries = 251680141;</code>
     *
     * @return Whether the numRetries field is set.
     */
    @java.lang.Override
    public boolean hasNumRetries() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
     * </pre>
     *
     * <code>optional uint32 num_retries = 251680141;</code>
     *
     * @return The numRetries.
     */
    @java.lang.Override
    public int getNumRetries() {
      return numRetries_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
     * </pre>
     *
     * <code>optional uint32 num_retries = 251680141;</code>
     *
     * @param value The numRetries to set.
     * @return This builder for chaining.
     */
    public Builder setNumRetries(int value) {

      numRetries_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the allowed number retries. This number must be &gt; 0. If not specified, defaults to 1.
     * </pre>
     *
     * <code>optional uint32 num_retries = 251680141;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumRetries() {
      bitField0_ = (bitField0_ & ~0x00000001);
      numRetries_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration perTryTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        perTryTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     *
     * @return Whether the perTryTimeout field is set.
     */
    public boolean hasPerTryTimeout() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     *
     * @return The perTryTimeout.
     */
    public com.google.cloud.compute.v1.Duration getPerTryTimeout() {
      if (perTryTimeoutBuilder_ == null) {
        return perTryTimeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : perTryTimeout_;
      } else {
        return perTryTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public Builder setPerTryTimeout(com.google.cloud.compute.v1.Duration value) {
      if (perTryTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        perTryTimeout_ = value;
      } else {
        perTryTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public Builder setPerTryTimeout(com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (perTryTimeoutBuilder_ == null) {
        perTryTimeout_ = builderForValue.build();
      } else {
        perTryTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public Builder mergePerTryTimeout(com.google.cloud.compute.v1.Duration value) {
      if (perTryTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && perTryTimeout_ != null
            && perTryTimeout_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getPerTryTimeoutBuilder().mergeFrom(value);
        } else {
          perTryTimeout_ = value;
        }
      } else {
        perTryTimeoutBuilder_.mergeFrom(value);
      }
      if (perTryTimeout_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public Builder clearPerTryTimeout() {
      bitField0_ = (bitField0_ & ~0x00000002);
      perTryTimeout_ = null;
      if (perTryTimeoutBuilder_ != null) {
        perTryTimeoutBuilder_.dispose();
        perTryTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getPerTryTimeoutBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPerTryTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getPerTryTimeoutOrBuilder() {
      if (perTryTimeoutBuilder_ != null) {
        return perTryTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return perTryTimeout_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : perTryTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a non-zero timeout per retry attempt. If not specified, will use the timeout set in the HttpRouteAction field. If timeout in the HttpRouteAction field is not set, this field uses the largest timeout among all backend services associated with the route. Not supported when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration per_try_timeout = 280041147;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getPerTryTimeoutFieldBuilder() {
      if (perTryTimeoutBuilder_ == null) {
        perTryTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getPerTryTimeout(), getParentForChildren(), isClean());
        perTryTimeout_ = null;
      }
      return perTryTimeoutBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList retryConditions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRetryConditionsIsMutable() {
      if (!retryConditions_.isModifiable()) {
        retryConditions_ = new com.google.protobuf.LazyStringArrayList(retryConditions_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @return A list containing the retryConditions.
     */
    public com.google.protobuf.ProtocolStringList getRetryConditionsList() {
      retryConditions_.makeImmutable();
      return retryConditions_;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @return The count of retryConditions.
     */
    public int getRetryConditionsCount() {
      return retryConditions_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param index The index of the element to return.
     * @return The retryConditions at the given index.
     */
    public java.lang.String getRetryConditions(int index) {
      return retryConditions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the retryConditions at the given index.
     */
    public com.google.protobuf.ByteString getRetryConditionsBytes(int index) {
      return retryConditions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param index The index to set the value at.
     * @param value The retryConditions to set.
     * @return This builder for chaining.
     */
    public Builder setRetryConditions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRetryConditionsIsMutable();
      retryConditions_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param value The retryConditions to add.
     * @return This builder for chaining.
     */
    public Builder addRetryConditions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRetryConditionsIsMutable();
      retryConditions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param values The retryConditions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRetryConditions(java.lang.Iterable<java.lang.String> values) {
      ensureRetryConditionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, retryConditions_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetryConditions() {
      retryConditions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies one or more conditions when this retry policy applies. Valid values are: - 5xx: retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams. - gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504. - connect-failure: a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts. - retriable-4xx: a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409. - refused-stream: a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry. - cancelled: a retry is attempted if the gRPC status code in the response header is set to cancelled. - deadline-exceeded: a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded. - internal: a retry is attempted if the gRPC status code in the response header is set to internal. - resource-exhausted: a retry is attempted if the gRPC status code in the response header is set to resource-exhausted. - unavailable: a retry is attempted if the gRPC status code in the response header is set to unavailable. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true. - cancelled - deadline-exceeded - internal - resource-exhausted - unavailable
     * </pre>
     *
     * <code>repeated string retry_conditions = 28815535;</code>
     *
     * @param value The bytes of the retryConditions to add.
     * @return This builder for chaining.
     */
    public Builder addRetryConditionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRetryConditionsIsMutable();
      retryConditions_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpRetryPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpRetryPolicy)
  private static final com.google.cloud.compute.v1.HttpRetryPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpRetryPolicy();
  }

  public static com.google.cloud.compute.v1.HttpRetryPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRetryPolicy> PARSER =
      new com.google.protobuf.AbstractParser<HttpRetryPolicy>() {
        @java.lang.Override
        public HttpRetryPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpRetryPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRetryPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRetryPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
