/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Instance resource. An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    cpuPlatform_ = "";
    creationTimestamp_ = "";
    description_ = "";
    disks_ = java.util.Collections.emptyList();
    fingerprint_ = "";
    guestAccelerators_ = java.util.Collections.emptyList();
    hostname_ = "";
    keyRevocationActionType_ = "";
    kind_ = "";
    labelFingerprint_ = "";
    lastStartTimestamp_ = "";
    lastStopTimestamp_ = "";
    lastSuspendedTimestamp_ = "";
    machineType_ = "";
    minCpuPlatform_ = "";
    name_ = "";
    networkInterfaces_ = java.util.Collections.emptyList();
    privateIpv6GoogleAccess_ = "";
    resourcePolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    selfLink_ = "";
    serviceAccounts_ = java.util.Collections.emptyList();
    sourceMachineImage_ = "";
    status_ = "";
    statusMessage_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Instance.class,
            com.google.cloud.compute.v1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Instance.KeyRevocationActionType}
   */
  public enum KeyRevocationActionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    UNDEFINED_KEY_REVOCATION_ACTION_TYPE(0),
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED(467110106),
    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    STOP(2555906),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    public static final int UNDEFINED_KEY_REVOCATION_ACTION_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    public static final int KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED_VALUE = 467110106;

    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;

    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    public static final int STOP_VALUE = 2555906;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyRevocationActionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyRevocationActionType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_KEY_REVOCATION_ACTION_TYPE;
        case 467110106:
          return KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED;
        case 2402104:
          return NONE;
        case 2555906:
          return STOP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>() {
              public KeyRevocationActionType findValueByNumber(int number) {
                return KeyRevocationActionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final KeyRevocationActionType[] VALUES = values();

    public static KeyRevocationActionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyRevocationActionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Instance.KeyRevocationActionType)
  }

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Instance.PrivateIpv6GoogleAccess}
   */
  public enum PrivateIpv6GoogleAccess implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS(0),
    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE(427975994),
    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE(288210263),
    /**
     *
     *
     * <pre>
     * Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 530256959;</code>
     */
    INHERIT_FROM_SUBNETWORK(530256959),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    public static final int UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    public static final int ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE_VALUE = 427975994;

    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    public static final int ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE_VALUE = 288210263;

    /**
     *
     *
     * <pre>
     * Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 530256959;</code>
     */
    public static final int INHERIT_FROM_SUBNETWORK_VALUE = 530256959;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrivateIpv6GoogleAccess valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PrivateIpv6GoogleAccess forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS;
        case 427975994:
          return ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE;
        case 288210263:
          return ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE;
        case 530256959:
          return INHERIT_FROM_SUBNETWORK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>() {
              public PrivateIpv6GoogleAccess findValueByNumber(int number) {
                return PrivateIpv6GoogleAccess.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final PrivateIpv6GoogleAccess[] VALUES = values();

    public static PrivateIpv6GoogleAccess valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrivateIpv6GoogleAccess(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Instance.PrivateIpv6GoogleAccess)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Instance.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    DEPROVISIONING(428935662),
    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    PROVISIONING(290896621),
    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    REPAIRING(413483285),
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    RUNNING(121282975),
    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    STAGING(431072283),
    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    STOPPED(444276141),
    /**
     *
     *
     * <pre>
     * The instance is currently stopping (either being deleted or killed).
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    STOPPING(350791796),
    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    SUSPENDED(51223995),
    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    SUSPENDING(514206246),
    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    TERMINATED(250018339),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    public static final int DEPROVISIONING_VALUE = 428935662;

    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    public static final int PROVISIONING_VALUE = 290896621;

    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    public static final int REPAIRING_VALUE = 413483285;

    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    public static final int RUNNING_VALUE = 121282975;

    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    public static final int STAGING_VALUE = 431072283;

    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    public static final int STOPPED_VALUE = 444276141;

    /**
     *
     *
     * <pre>
     * The instance is currently stopping (either being deleted or killed).
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    public static final int STOPPING_VALUE = 350791796;

    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    public static final int SUSPENDED_VALUE = 51223995;

    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    public static final int SUSPENDING_VALUE = 514206246;

    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    public static final int TERMINATED_VALUE = 250018339;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 428935662:
          return DEPROVISIONING;
        case 290896621:
          return PROVISIONING;
        case 413483285:
          return REPAIRING;
        case 121282975:
          return RUNNING;
        case 431072283:
          return STAGING;
        case 444276141:
          return STOPPED;
        case 350791796:
          return STOPPING;
        case 51223995:
          return SUSPENDED;
        case 514206246:
          return SUSPENDING;
        case 250018339:
          return TERMINATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Instance.Status)
  }

  private int bitField0_;
  private int bitField1_;
  public static final int ADVANCED_MACHINE_FEATURES_FIELD_NUMBER = 409646002;
  private com.google.cloud.compute.v1.AdvancedMachineFeatures advancedMachineFeatures_;

  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return Whether the advancedMachineFeatures field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedMachineFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return The advancedMachineFeatures.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
    return advancedMachineFeatures_ == null
        ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }

  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder
      getAdvancedMachineFeaturesOrBuilder() {
    return advancedMachineFeatures_ == null
        ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }

  public static final int CAN_IP_FORWARD_FIELD_NUMBER = 467731324;
  private boolean canIpForward_ = false;

  /**
   *
   *
   * <pre>
   * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return Whether the canIpForward field is set.
   */
  @java.lang.Override
  public boolean hasCanIpForward() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return The canIpForward.
   */
  @java.lang.Override
  public boolean getCanIpForward() {
    return canIpForward_;
  }

  public static final int CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER = 490637685;
  private com.google.cloud.compute.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return Whether the confidentialInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialInstanceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return The confidentialInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder
      getConfidentialInstanceConfigOrBuilder() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }

  public static final int CPU_PLATFORM_FIELD_NUMBER = 410285354;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuPlatform_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return Whether the cpuPlatform field is set.
   */
  @java.lang.Override
  public boolean hasCpuPlatform() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return The cpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getCpuPlatform() {
    java.lang.Object ref = cpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuPlatform_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The CPU platform used by this instance.
   * </pre>
   *
   * <code>optional string cpu_platform = 410285354;</code>
   *
   * @return The bytes for cpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuPlatformBytes() {
    java.lang.Object ref = cpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETION_PROTECTION_FIELD_NUMBER = 458014698;
  private boolean deletionProtection_ = false;

  /**
   *
   *
   * <pre>
   * Whether the resource should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return Whether the deletionProtection field is set.
   */
  @java.lang.Override
  public boolean hasDeletionProtection() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether the resource should be protected against deletion.
   * </pre>
   *
   * <code>optional bool deletion_protection = 458014698;</code>
   *
   * @return The deletionProtection.
   */
  @java.lang.Override
  public boolean getDeletionProtection() {
    return deletionProtection_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISKS_FIELD_NUMBER = 95594102;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AttachedDisk> disks_;

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AttachedDisk> getDisksList() {
    return disks_;
  }

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AttachedDiskOrBuilder>
      getDisksOrBuilderList() {
    return disks_;
  }

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public int getDisksCount() {
    return disks_.size();
  }

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDisk getDisks(int index) {
    return disks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDiskOrBuilder getDisksOrBuilder(int index) {
    return disks_.get(index);
  }

  public static final int DISPLAY_DEVICE_FIELD_NUMBER = 258933875;
  private com.google.cloud.compute.v1.DisplayDevice displayDevice_;

  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   *
   * @return Whether the displayDevice field is set.
   */
  @java.lang.Override
  public boolean hasDisplayDevice() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   *
   * @return The displayDevice.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DisplayDevice getDisplayDevice() {
    return displayDevice_ == null
        ? com.google.cloud.compute.v1.DisplayDevice.getDefaultInstance()
        : displayDevice_;
  }

  /**
   *
   *
   * <pre>
   * Enables display device for the instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DisplayDeviceOrBuilder getDisplayDeviceOrBuilder() {
    return displayDevice_ == null
        ? com.google.cloud.compute.v1.DisplayDevice.getDefaultInstance()
        : displayDevice_;
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";

  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUEST_ACCELERATORS_FIELD_NUMBER = 463595119;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_;

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getGuestAcceleratorsList() {
    return guestAccelerators_;
  }

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getGuestAcceleratorsOrBuilderList() {
    return guestAccelerators_;
  }

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public int getGuestAcceleratorsCount() {
    return guestAccelerators_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
    return guestAccelerators_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of the type and count of accelerator cards attached to the instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
      int index) {
    return guestAccelerators_.get(index);
  }

  public static final int HOSTNAME_FIELD_NUMBER = 237067315;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostname_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return Whether the hostname field is set.
   */
  @java.lang.Override
  public boolean hasHostname() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return The hostname.
   */
  @java.lang.Override
  public java.lang.String getHostname() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostname_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
   * </pre>
   *
   * <code>optional string hostname = 237067315;</code>
   *
   * @return The bytes for hostname.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostnameBytes() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostname_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSTANCE_ENCRYPTION_KEY_FIELD_NUMBER = 64741517;
  private com.google.cloud.compute.v1.CustomerEncryptionKey instanceEncryptionKey_;

  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   *
   * @return Whether the instanceEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasInstanceEncryptionKey() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   *
   * @return The instanceEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getInstanceEncryptionKey() {
    return instanceEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : instanceEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getInstanceEncryptionKeyOrBuilder() {
    return instanceEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : instanceEncryptionKey_;
  }

  public static final int KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER = 235941474;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyRevocationActionType_ = "";

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return Whether the keyRevocationActionType field is set.
   */
  @java.lang.Override
  public boolean hasKeyRevocationActionType() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The keyRevocationActionType.
   */
  @java.lang.Override
  public java.lang.String getKeyRevocationActionType() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyRevocationActionType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The bytes for keyRevocationActionType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyRevocationActionType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";

  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this instance. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LAST_START_TIMESTAMP_FIELD_NUMBER = 443830736;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastStartTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return Whether the lastStartTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasLastStartTimestamp() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return The lastStartTimestamp.
   */
  @java.lang.Override
  public java.lang.String getLastStartTimestamp() {
    java.lang.Object ref = lastStartTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastStartTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last start timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_start_timestamp = 443830736;</code>
   *
   * @return The bytes for lastStartTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastStartTimestampBytes() {
    java.lang.Object ref = lastStartTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastStartTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_STOP_TIMESTAMP_FIELD_NUMBER = 412823010;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastStopTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return Whether the lastStopTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasLastStopTimestamp() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return The lastStopTimestamp.
   */
  @java.lang.Override
  public java.lang.String getLastStopTimestamp() {
    java.lang.Object ref = lastStopTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastStopTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last stop timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_stop_timestamp = 412823010;</code>
   *
   * @return The bytes for lastStopTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastStopTimestampBytes() {
    java.lang.Object ref = lastStopTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastStopTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_SUSPENDED_TIMESTAMP_FIELD_NUMBER = 356275337;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastSuspendedTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return Whether the lastSuspendedTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasLastSuspendedTimestamp() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return The lastSuspendedTimestamp.
   */
  @java.lang.Override
  public java.lang.String getLastSuspendedTimestamp() {
    java.lang.Object ref = lastSuspendedTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastSuspendedTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last suspended timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_suspended_timestamp = 356275337;</code>
   *
   * @return The bytes for lastSuspendedTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastSuspendedTimestampBytes() {
    java.lang.Object ref = lastSuspendedTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastSuspendedTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 227711026;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";

  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return Whether the machineType field is set.
   */
  @java.lang.Override
  public boolean hasMachineType() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 86866735;
  private com.google.cloud.compute.v1.Metadata metadata_;

  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00080000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }

  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 242912759;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";

  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return Whether the minCpuPlatform field is set.
   */
  @java.lang.Override
  public boolean hasMinCpuPlatform() {
    return ((bitField0_ & 0x00100000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00200000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_INTERFACES_FIELD_NUMBER = 52735243;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_;

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
    return networkInterfaces_;
  }

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList() {
    return networkInterfaces_;
  }

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public int getNetworkInterfacesCount() {
    return networkInterfaces_.size();
  }

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
    return networkInterfaces_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
      int index) {
    return networkInterfaces_.get(index);
  }

  public static final int NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER = 398330850;
  private com.google.cloud.compute.v1.NetworkPerformanceConfig networkPerformanceConfig_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return Whether the networkPerformanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPerformanceConfig() {
    return ((bitField0_ & 0x00400000) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return The networkPerformanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPerformanceConfig getNetworkPerformanceConfig() {
    return networkPerformanceConfig_ == null
        ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
        : networkPerformanceConfig_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder
      getNetworkPerformanceConfigOrBuilder() {
    return networkPerformanceConfig_ == null
        ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
        : networkPerformanceConfig_;
  }

  public static final int PARAMS_FIELD_NUMBER = 78313862;
  private com.google.cloud.compute.v1.InstanceParams params_;

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  @java.lang.Override
  public boolean hasParams() {
    return ((bitField0_ & 0x00800000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   *
   * @return The params.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceParams getParams() {
    return params_ == null
        ? com.google.cloud.compute.v1.InstanceParams.getDefaultInstance()
        : params_;
  }

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceParamsOrBuilder getParamsOrBuilder() {
    return params_ == null
        ? com.google.cloud.compute.v1.InstanceParams.getDefaultInstance()
        : params_;
  }

  public static final int PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 48277006;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateIpv6GoogleAccess_ = "";

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return Whether the privateIpv6GoogleAccess field is set.
   */
  @java.lang.Override
  public boolean hasPrivateIpv6GoogleAccess() {
    return ((bitField0_ & 0x01000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public java.lang.String getPrivateIpv6GoogleAccess() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateIpv6GoogleAccess_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The bytes for privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateIpv6GoogleAccess_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_AFFINITY_FIELD_NUMBER = 157850683;
  private com.google.cloud.compute.v1.ReservationAffinity reservationAffinity_;

  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  @java.lang.Override
  public boolean hasReservationAffinity() {
    return ((bitField0_ & 0x02000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return The reservationAffinity.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAffinity getReservationAffinity() {
    return reservationAffinity_ == null
        ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the reservations that this instance can consume from.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAffinityOrBuilder
      getReservationAffinityOrBuilder() {
    return reservationAffinity_ == null
        ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  public static final int RESOURCE_POLICIES_FIELD_NUMBER = 22220385;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resourcePolicies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return A list containing the resourcePolicies.
   */
  public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
    return resourcePolicies_;
  }

  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return The count of resourcePolicies.
   */
  public int getResourcePoliciesCount() {
    return resourcePolicies_.size();
  }

  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePolicies at the given index.
   */
  public java.lang.String getResourcePolicies(int index) {
    return resourcePolicies_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Resource policies applied to this instance.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePolicies at the given index.
   */
  public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
    return resourcePolicies_.getByteString(index);
  }

  public static final int RESOURCE_STATUS_FIELD_NUMBER = 249429315;
  private com.google.cloud.compute.v1.ResourceStatus resourceStatus_;

  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   *
   * @return Whether the resourceStatus field is set.
   */
  @java.lang.Override
  public boolean hasResourceStatus() {
    return ((bitField0_ & 0x04000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   *
   * @return The resourceStatus.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatus getResourceStatus() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatusOrBuilder getResourceStatusOrBuilder() {
    return resourceStatus_ == null
        ? com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()
        : resourceStatus_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 480964257;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzi() {
    return ((bitField0_ & 0x08000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x10000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SCHEDULING_FIELD_NUMBER = 386688404;
  private com.google.cloud.compute.v1.Scheduling scheduling_;

  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x20000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Scheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }

  /**
   *
   *
   * <pre>
   * Sets the scheduling options for this instance.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x40000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNTS_FIELD_NUMBER = 277537328;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_;

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
    return serviceAccounts_;
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList() {
    return serviceAccounts_;
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public int getServiceAccountsCount() {
    return serviceAccounts_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
    return serviceAccounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
      int index) {
    return serviceAccounts_.get(index);
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 12862901;
  private com.google.cloud.compute.v1.ShieldedInstanceConfig shieldedInstanceConfig_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return ((bitField0_ & 0x80000000) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int SHIELDED_INSTANCE_INTEGRITY_POLICY_FIELD_NUMBER = 163696919;
  private com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy
      shieldedInstanceIntegrityPolicy_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   *
   * @return Whether the shieldedInstanceIntegrityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceIntegrityPolicy() {
    return ((bitField1_ & 0x00000001) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   *
   * @return The shieldedInstanceIntegrityPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy
      getShieldedInstanceIntegrityPolicy() {
    return shieldedInstanceIntegrityPolicy_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.getDefaultInstance()
        : shieldedInstanceIntegrityPolicy_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder
      getShieldedInstanceIntegrityPolicyOrBuilder() {
    return shieldedInstanceIntegrityPolicy_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.getDefaultInstance()
        : shieldedInstanceIntegrityPolicy_;
  }

  public static final int SOURCE_MACHINE_IMAGE_FIELD_NUMBER = 21769791;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceMachineImage_ = "";

  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return Whether the sourceMachineImage field is set.
   */
  @java.lang.Override
  public boolean hasSourceMachineImage() {
    return ((bitField1_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return The sourceMachineImage.
   */
  @java.lang.Override
  public java.lang.String getSourceMachineImage() {
    java.lang.Object ref = sourceMachineImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceMachineImage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Source machine image
   * </pre>
   *
   * <code>optional string source_machine_image = 21769791;</code>
   *
   * @return The bytes for sourceMachineImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceMachineImageBytes() {
    java.lang.Object ref = sourceMachineImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceMachineImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_MACHINE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER = 192839075;
  private com.google.cloud.compute.v1.CustomerEncryptionKey sourceMachineImageEncryptionKey_;

  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   *
   * @return Whether the sourceMachineImageEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSourceMachineImageEncryptionKey() {
    return ((bitField1_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   *
   * @return The sourceMachineImageEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceMachineImageEncryptionKey() {
    return sourceMachineImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceMachineImageEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Source machine image encryption key when creating an instance from a machine image.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceMachineImageEncryptionKeyOrBuilder() {
    return sourceMachineImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceMachineImageEncryptionKey_;
  }

  public static final int START_RESTRICTED_FIELD_NUMBER = 123693144;
  private boolean startRestricted_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
   * </pre>
   *
   * <code>optional bool start_restricted = 123693144;</code>
   *
   * @return Whether the startRestricted field is set.
   */
  @java.lang.Override
  public boolean hasStartRestricted() {
    return ((bitField1_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
   * </pre>
   *
   * <code>optional bool start_restricted = 123693144;</code>
   *
   * @return The startRestricted.
   */
  @java.lang.Override
  public boolean getStartRestricted() {
    return startRestricted_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField1_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 297428154;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  @java.lang.Override
  public boolean hasStatusMessage() {
    return ((bitField1_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 3552281;
  private com.google.cloud.compute.v1.Tags tags_;

  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return Whether the tags field is set.
   */
  @java.lang.Override
  public boolean hasTags() {
    return ((bitField1_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return The tags.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Tags getTags() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }

  /**
   *
   *
   * <pre>
   * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField1_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      output.writeMessage(3552281, getTags());
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeMessage(12862901, getShieldedInstanceConfig());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21769791, sourceMachineImage_);
    }
    for (int i = 0; i < resourcePolicies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 22220385, resourcePolicies_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 48277006, privateIpv6GoogleAccess_);
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      output.writeMessage(52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(64741517, getInstanceEncryptionKey());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeMessage(78313862, getParams());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeMessage(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      output.writeMessage(95594102, disks_.get(i));
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeBool(123693144, startRestricted_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeMessage(157850683, getReservationAffinity());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeMessage(163696919, getShieldedInstanceIntegrityPolicy());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeMessage(192839075, getSourceMachineImageEncryptionKey());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227711026, machineType_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 237067315, hostname_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 242912759, minCpuPlatform_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeMessage(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(258933875, getDisplayDevice());
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      output.writeMessage(277537328, serviceAccounts_.get(i));
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 356275337, lastSuspendedTimestamp_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeMessage(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeMessage(398330850, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(409646002, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 410285354, cpuPlatform_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 412823010, lastStopTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 443830736, lastStartTimestamp_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(458014698, deletionProtection_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      output.writeMessage(463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(467731324, canIpForward_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeBool(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(490637685, getConfidentialInstanceConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3552281, getTags());
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12862901, getShieldedInstanceConfig());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(21769791, sourceMachineImage_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourcePolicies_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourcePolicies_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getResourcePoliciesList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              48277006, privateIpv6GoogleAccess_);
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              64741517, getInstanceEncryptionKey());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(78313862, getParams());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(95594102, disks_.get(i));
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(123693144, startRestricted_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              157850683, getReservationAffinity());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              163696919, getShieldedInstanceIntegrityPolicy());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              192839075, getSourceMachineImageEncryptionKey());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227711026, machineType_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(237067315, hostname_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(242912759, minCpuPlatform_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(249429315, getResourceStatus());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(258933875, getDisplayDevice());
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              277537328, serviceAccounts_.get(i));
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              356275337, lastSuspendedTimestamp_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              398330850, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              409646002, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(410285354, cpuPlatform_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(412823010, lastStopTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(443830736, lastStartTimestamp_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(458014698, deletionProtection_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(467731324, canIpForward_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              490637685, getConfidentialInstanceConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Instance other = (com.google.cloud.compute.v1.Instance) obj;

    if (hasAdvancedMachineFeatures() != other.hasAdvancedMachineFeatures()) return false;
    if (hasAdvancedMachineFeatures()) {
      if (!getAdvancedMachineFeatures().equals(other.getAdvancedMachineFeatures())) return false;
    }
    if (hasCanIpForward() != other.hasCanIpForward()) return false;
    if (hasCanIpForward()) {
      if (getCanIpForward() != other.getCanIpForward()) return false;
    }
    if (hasConfidentialInstanceConfig() != other.hasConfidentialInstanceConfig()) return false;
    if (hasConfidentialInstanceConfig()) {
      if (!getConfidentialInstanceConfig().equals(other.getConfidentialInstanceConfig()))
        return false;
    }
    if (hasCpuPlatform() != other.hasCpuPlatform()) return false;
    if (hasCpuPlatform()) {
      if (!getCpuPlatform().equals(other.getCpuPlatform())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDeletionProtection() != other.hasDeletionProtection()) return false;
    if (hasDeletionProtection()) {
      if (getDeletionProtection() != other.getDeletionProtection()) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDisksList().equals(other.getDisksList())) return false;
    if (hasDisplayDevice() != other.hasDisplayDevice()) return false;
    if (hasDisplayDevice()) {
      if (!getDisplayDevice().equals(other.getDisplayDevice())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (!getGuestAcceleratorsList().equals(other.getGuestAcceleratorsList())) return false;
    if (hasHostname() != other.hasHostname()) return false;
    if (hasHostname()) {
      if (!getHostname().equals(other.getHostname())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInstanceEncryptionKey() != other.hasInstanceEncryptionKey()) return false;
    if (hasInstanceEncryptionKey()) {
      if (!getInstanceEncryptionKey().equals(other.getInstanceEncryptionKey())) return false;
    }
    if (hasKeyRevocationActionType() != other.hasKeyRevocationActionType()) return false;
    if (hasKeyRevocationActionType()) {
      if (!getKeyRevocationActionType().equals(other.getKeyRevocationActionType())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasLastStartTimestamp() != other.hasLastStartTimestamp()) return false;
    if (hasLastStartTimestamp()) {
      if (!getLastStartTimestamp().equals(other.getLastStartTimestamp())) return false;
    }
    if (hasLastStopTimestamp() != other.hasLastStopTimestamp()) return false;
    if (hasLastStopTimestamp()) {
      if (!getLastStopTimestamp().equals(other.getLastStopTimestamp())) return false;
    }
    if (hasLastSuspendedTimestamp() != other.hasLastSuspendedTimestamp()) return false;
    if (hasLastSuspendedTimestamp()) {
      if (!getLastSuspendedTimestamp().equals(other.getLastSuspendedTimestamp())) return false;
    }
    if (hasMachineType() != other.hasMachineType()) return false;
    if (hasMachineType()) {
      if (!getMachineType().equals(other.getMachineType())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasMinCpuPlatform() != other.hasMinCpuPlatform()) return false;
    if (hasMinCpuPlatform()) {
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getNetworkInterfacesList().equals(other.getNetworkInterfacesList())) return false;
    if (hasNetworkPerformanceConfig() != other.hasNetworkPerformanceConfig()) return false;
    if (hasNetworkPerformanceConfig()) {
      if (!getNetworkPerformanceConfig().equals(other.getNetworkPerformanceConfig())) return false;
    }
    if (hasParams() != other.hasParams()) return false;
    if (hasParams()) {
      if (!getParams().equals(other.getParams())) return false;
    }
    if (hasPrivateIpv6GoogleAccess() != other.hasPrivateIpv6GoogleAccess()) return false;
    if (hasPrivateIpv6GoogleAccess()) {
      if (!getPrivateIpv6GoogleAccess().equals(other.getPrivateIpv6GoogleAccess())) return false;
    }
    if (hasReservationAffinity() != other.hasReservationAffinity()) return false;
    if (hasReservationAffinity()) {
      if (!getReservationAffinity().equals(other.getReservationAffinity())) return false;
    }
    if (!getResourcePoliciesList().equals(other.getResourcePoliciesList())) return false;
    if (hasResourceStatus() != other.hasResourceStatus()) return false;
    if (hasResourceStatus()) {
      if (!getResourceStatus().equals(other.getResourceStatus())) return false;
    }
    if (hasSatisfiesPzi() != other.hasSatisfiesPzi()) return false;
    if (hasSatisfiesPzi()) {
      if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getServiceAccountsList().equals(other.getServiceAccountsList())) return false;
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (hasShieldedInstanceIntegrityPolicy() != other.hasShieldedInstanceIntegrityPolicy())
      return false;
    if (hasShieldedInstanceIntegrityPolicy()) {
      if (!getShieldedInstanceIntegrityPolicy().equals(other.getShieldedInstanceIntegrityPolicy()))
        return false;
    }
    if (hasSourceMachineImage() != other.hasSourceMachineImage()) return false;
    if (hasSourceMachineImage()) {
      if (!getSourceMachineImage().equals(other.getSourceMachineImage())) return false;
    }
    if (hasSourceMachineImageEncryptionKey() != other.hasSourceMachineImageEncryptionKey())
      return false;
    if (hasSourceMachineImageEncryptionKey()) {
      if (!getSourceMachineImageEncryptionKey().equals(other.getSourceMachineImageEncryptionKey()))
        return false;
    }
    if (hasStartRestricted() != other.hasStartRestricted()) return false;
    if (hasStartRestricted()) {
      if (getStartRestricted() != other.getStartRestricted()) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasStatusMessage() != other.hasStatusMessage()) return false;
    if (hasStatusMessage()) {
      if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    }
    if (hasTags() != other.hasTags()) return false;
    if (hasTags()) {
      if (!getTags().equals(other.getTags())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdvancedMachineFeatures()) {
      hash = (37 * hash) + ADVANCED_MACHINE_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedMachineFeatures().hashCode();
    }
    if (hasCanIpForward()) {
      hash = (37 * hash) + CAN_IP_FORWARD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCanIpForward());
    }
    if (hasConfidentialInstanceConfig()) {
      hash = (37 * hash) + CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialInstanceConfig().hashCode();
    }
    if (hasCpuPlatform()) {
      hash = (37 * hash) + CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getCpuPlatform().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDeletionProtection()) {
      hash = (37 * hash) + DELETION_PROTECTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeletionProtection());
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDisksCount() > 0) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisksList().hashCode();
    }
    if (hasDisplayDevice()) {
      hash = (37 * hash) + DISPLAY_DEVICE_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayDevice().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (getGuestAcceleratorsCount() > 0) {
      hash = (37 * hash) + GUEST_ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestAcceleratorsList().hashCode();
    }
    if (hasHostname()) {
      hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getHostname().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInstanceEncryptionKey()) {
      hash = (37 * hash) + INSTANCE_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceEncryptionKey().hashCode();
    }
    if (hasKeyRevocationActionType()) {
      hash = (37 * hash) + KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getKeyRevocationActionType().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasLastStartTimestamp()) {
      hash = (37 * hash) + LAST_START_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getLastStartTimestamp().hashCode();
    }
    if (hasLastStopTimestamp()) {
      hash = (37 * hash) + LAST_STOP_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getLastStopTimestamp().hashCode();
    }
    if (hasLastSuspendedTimestamp()) {
      hash = (37 * hash) + LAST_SUSPENDED_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getLastSuspendedTimestamp().hashCode();
    }
    if (hasMachineType()) {
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasMinCpuPlatform()) {
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getNetworkInterfacesCount() > 0) {
      hash = (37 * hash) + NETWORK_INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkInterfacesList().hashCode();
    }
    if (hasNetworkPerformanceConfig()) {
      hash = (37 * hash) + NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPerformanceConfig().hashCode();
    }
    if (hasParams()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getParams().hashCode();
    }
    if (hasPrivateIpv6GoogleAccess()) {
      hash = (37 * hash) + PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateIpv6GoogleAccess().hashCode();
    }
    if (hasReservationAffinity()) {
      hash = (37 * hash) + RESERVATION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationAffinity().hashCode();
    }
    if (getResourcePoliciesCount() > 0) {
      hash = (37 * hash) + RESOURCE_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcePoliciesList().hashCode();
    }
    if (hasResourceStatus()) {
      hash = (37 * hash) + RESOURCE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceStatus().hashCode();
    }
    if (hasSatisfiesPzi()) {
      hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getServiceAccountsCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountsList().hashCode();
    }
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    if (hasShieldedInstanceIntegrityPolicy()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_INTEGRITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceIntegrityPolicy().hashCode();
    }
    if (hasSourceMachineImage()) {
      hash = (37 * hash) + SOURCE_MACHINE_IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceMachineImage().hashCode();
    }
    if (hasSourceMachineImageEncryptionKey()) {
      hash = (37 * hash) + SOURCE_MACHINE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceMachineImageEncryptionKey().hashCode();
    }
    if (hasStartRestricted()) {
      hash = (37 * hash) + START_RESTRICTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStartRestricted());
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasStatusMessage()) {
      hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStatusMessage().hashCode();
    }
    if (hasTags()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTags().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Instance parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents an Instance resource. An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Instance)
      com.google.cloud.compute.v1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Instance.class,
              com.google.cloud.compute.v1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvancedMachineFeaturesFieldBuilder();
        getConfidentialInstanceConfigFieldBuilder();
        getDisksFieldBuilder();
        getDisplayDeviceFieldBuilder();
        getGuestAcceleratorsFieldBuilder();
        getInstanceEncryptionKeyFieldBuilder();
        getMetadataFieldBuilder();
        getNetworkInterfacesFieldBuilder();
        getNetworkPerformanceConfigFieldBuilder();
        getParamsFieldBuilder();
        getReservationAffinityFieldBuilder();
        getResourceStatusFieldBuilder();
        getSchedulingFieldBuilder();
        getServiceAccountsFieldBuilder();
        getShieldedInstanceConfigFieldBuilder();
        getShieldedInstanceIntegrityPolicyFieldBuilder();
        getSourceMachineImageEncryptionKeyFieldBuilder();
        getTagsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      canIpForward_ = false;
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      cpuPlatform_ = "";
      creationTimestamp_ = "";
      deletionProtection_ = false;
      description_ = "";
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
      } else {
        disks_ = null;
        disksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      displayDevice_ = null;
      if (displayDeviceBuilder_ != null) {
        displayDeviceBuilder_.dispose();
        displayDeviceBuilder_ = null;
      }
      fingerprint_ = "";
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
      } else {
        guestAccelerators_ = null;
        guestAcceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      hostname_ = "";
      id_ = 0L;
      instanceEncryptionKey_ = null;
      if (instanceEncryptionKeyBuilder_ != null) {
        instanceEncryptionKeyBuilder_.dispose();
        instanceEncryptionKeyBuilder_ = null;
      }
      keyRevocationActionType_ = "";
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      lastStartTimestamp_ = "";
      lastStopTimestamp_ = "";
      lastSuspendedTimestamp_ = "";
      machineType_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      minCpuPlatform_ = "";
      name_ = "";
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
      } else {
        networkInterfaces_ = null;
        networkInterfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x02000000);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      privateIpv6GoogleAccess_ = "";
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      satisfiesPzi_ = false;
      satisfiesPzs_ = false;
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      selfLink_ = "";
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
      } else {
        serviceAccounts_ = null;
        serviceAccountsBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000010);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      shieldedInstanceIntegrityPolicy_ = null;
      if (shieldedInstanceIntegrityPolicyBuilder_ != null) {
        shieldedInstanceIntegrityPolicyBuilder_.dispose();
        shieldedInstanceIntegrityPolicyBuilder_ = null;
      }
      sourceMachineImage_ = "";
      sourceMachineImageEncryptionKey_ = null;
      if (sourceMachineImageEncryptionKeyBuilder_ != null) {
        sourceMachineImageEncryptionKeyBuilder_.dispose();
        sourceMachineImageEncryptionKeyBuilder_ = null;
      }
      startRestricted_ = false;
      status_ = "";
      statusMessage_ = "";
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Instance getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Instance build() {
      com.google.cloud.compute.v1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Instance buildPartial() {
      com.google.cloud.compute.v1.Instance result = new com.google.cloud.compute.v1.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Instance result) {
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          disks_ = java.util.Collections.unmodifiableList(disks_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.disks_ = disks_;
      } else {
        result.disks_ = disksBuilder_.build();
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          guestAccelerators_ = java.util.Collections.unmodifiableList(guestAccelerators_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.guestAccelerators_ = guestAccelerators_;
      } else {
        result.guestAccelerators_ = guestAcceleratorsBuilder_.build();
      }
      if (networkInterfacesBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)) {
          networkInterfaces_ = java.util.Collections.unmodifiableList(networkInterfaces_);
          bitField0_ = (bitField0_ & ~0x02000000);
        }
        result.networkInterfaces_ = networkInterfaces_;
      } else {
        result.networkInterfaces_ = networkInterfacesBuilder_.build();
      }
      if (serviceAccountsBuilder_ == null) {
        if (((bitField1_ & 0x00000010) != 0)) {
          serviceAccounts_ = java.util.Collections.unmodifiableList(serviceAccounts_);
          bitField1_ = (bitField1_ & ~0x00000010);
        }
        result.serviceAccounts_ = serviceAccounts_;
      } else {
        result.serviceAccounts_ = serviceAccountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Instance result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.advancedMachineFeatures_ =
            advancedMachineFeaturesBuilder_ == null
                ? advancedMachineFeatures_
                : advancedMachineFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.canIpForward_ = canIpForward_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.confidentialInstanceConfig_ =
            confidentialInstanceConfigBuilder_ == null
                ? confidentialInstanceConfig_
                : confidentialInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cpuPlatform_ = cpuPlatform_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.deletionProtection_ = deletionProtection_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.displayDevice_ =
            displayDeviceBuilder_ == null ? displayDevice_ : displayDeviceBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.hostname_ = hostname_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.instanceEncryptionKey_ =
            instanceEncryptionKeyBuilder_ == null
                ? instanceEncryptionKey_
                : instanceEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.keyRevocationActionType_ = keyRevocationActionType_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.lastStartTimestamp_ = lastStartTimestamp_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.lastStopTimestamp_ = lastStopTimestamp_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.lastSuspendedTimestamp_ = lastSuspendedTimestamp_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.machineType_ = machineType_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.networkPerformanceConfig_ =
            networkPerformanceConfigBuilder_ == null
                ? networkPerformanceConfig_
                : networkPerformanceConfigBuilder_.build();
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.params_ = paramsBuilder_ == null ? params_ : paramsBuilder_.build();
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.privateIpv6GoogleAccess_ = privateIpv6GoogleAccess_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.reservationAffinity_ =
            reservationAffinityBuilder_ == null
                ? reservationAffinity_
                : reservationAffinityBuilder_.build();
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        resourcePolicies_.makeImmutable();
        result.resourcePolicies_ = resourcePolicies_;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.resourceStatus_ =
            resourceStatusBuilder_ == null ? resourceStatus_ : resourceStatusBuilder_.build();
        to_bitField0_ |= 0x04000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.compute.v1.Instance result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x40000000;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.shieldedInstanceIntegrityPolicy_ =
            shieldedInstanceIntegrityPolicyBuilder_ == null
                ? shieldedInstanceIntegrityPolicy_
                : shieldedInstanceIntegrityPolicyBuilder_.build();
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.sourceMachineImage_ = sourceMachineImage_;
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.sourceMachineImageEncryptionKey_ =
            sourceMachineImageEncryptionKeyBuilder_ == null
                ? sourceMachineImageEncryptionKey_
                : sourceMachineImageEncryptionKeyBuilder_.build();
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField1_ & 0x00000200) != 0)) {
        result.startRestricted_ = startRestricted_;
        to_bitField1_ |= 0x00000008;
      }
      if (((from_bitField1_ & 0x00000400) != 0)) {
        result.status_ = status_;
        to_bitField1_ |= 0x00000010;
      }
      if (((from_bitField1_ & 0x00000800) != 0)) {
        result.statusMessage_ = statusMessage_;
        to_bitField1_ |= 0x00000020;
      }
      if (((from_bitField1_ & 0x00001000) != 0)) {
        result.tags_ = tagsBuilder_ == null ? tags_ : tagsBuilder_.build();
        to_bitField1_ |= 0x00000040;
      }
      if (((from_bitField1_ & 0x00002000) != 0)) {
        result.zone_ = zone_;
        to_bitField1_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Instance) {
        return mergeFrom((com.google.cloud.compute.v1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Instance other) {
      if (other == com.google.cloud.compute.v1.Instance.getDefaultInstance()) return this;
      if (other.hasAdvancedMachineFeatures()) {
        mergeAdvancedMachineFeatures(other.getAdvancedMachineFeatures());
      }
      if (other.hasCanIpForward()) {
        setCanIpForward(other.getCanIpForward());
      }
      if (other.hasConfidentialInstanceConfig()) {
        mergeConfidentialInstanceConfig(other.getConfidentialInstanceConfig());
      }
      if (other.hasCpuPlatform()) {
        cpuPlatform_ = other.cpuPlatform_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDeletionProtection()) {
        setDeletionProtection(other.getDeletionProtection());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (disksBuilder_ == null) {
        if (!other.disks_.isEmpty()) {
          if (disks_.isEmpty()) {
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureDisksIsMutable();
            disks_.addAll(other.disks_);
          }
          onChanged();
        }
      } else {
        if (!other.disks_.isEmpty()) {
          if (disksBuilder_.isEmpty()) {
            disksBuilder_.dispose();
            disksBuilder_ = null;
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000080);
            disksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDisksFieldBuilder()
                    : null;
          } else {
            disksBuilder_.addAllMessages(other.disks_);
          }
        }
      }
      if (other.hasDisplayDevice()) {
        mergeDisplayDevice(other.getDisplayDevice());
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAccelerators_.isEmpty()) {
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureGuestAcceleratorsIsMutable();
            guestAccelerators_.addAll(other.guestAccelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAcceleratorsBuilder_.isEmpty()) {
            guestAcceleratorsBuilder_.dispose();
            guestAcceleratorsBuilder_ = null;
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000400);
            guestAcceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestAcceleratorsFieldBuilder()
                    : null;
          } else {
            guestAcceleratorsBuilder_.addAllMessages(other.guestAccelerators_);
          }
        }
      }
      if (other.hasHostname()) {
        hostname_ = other.hostname_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInstanceEncryptionKey()) {
        mergeInstanceEncryptionKey(other.getInstanceEncryptionKey());
      }
      if (other.hasKeyRevocationActionType()) {
        keyRevocationActionType_ = other.keyRevocationActionType_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00020000;
      if (other.hasLastStartTimestamp()) {
        lastStartTimestamp_ = other.lastStartTimestamp_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasLastStopTimestamp()) {
        lastStopTimestamp_ = other.lastStopTimestamp_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasLastSuspendedTimestamp()) {
        lastSuspendedTimestamp_ = other.lastSuspendedTimestamp_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasMachineType()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasMinCpuPlatform()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (networkInterfacesBuilder_ == null) {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfaces_.isEmpty()) {
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x02000000);
          } else {
            ensureNetworkInterfacesIsMutable();
            networkInterfaces_.addAll(other.networkInterfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfacesBuilder_.isEmpty()) {
            networkInterfacesBuilder_.dispose();
            networkInterfacesBuilder_ = null;
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x02000000);
            networkInterfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNetworkInterfacesFieldBuilder()
                    : null;
          } else {
            networkInterfacesBuilder_.addAllMessages(other.networkInterfaces_);
          }
        }
      }
      if (other.hasNetworkPerformanceConfig()) {
        mergeNetworkPerformanceConfig(other.getNetworkPerformanceConfig());
      }
      if (other.hasParams()) {
        mergeParams(other.getParams());
      }
      if (other.hasPrivateIpv6GoogleAccess()) {
        privateIpv6GoogleAccess_ = other.privateIpv6GoogleAccess_;
        bitField0_ |= 0x10000000;
        onChanged();
      }
      if (other.hasReservationAffinity()) {
        mergeReservationAffinity(other.getReservationAffinity());
      }
      if (!other.resourcePolicies_.isEmpty()) {
        if (resourcePolicies_.isEmpty()) {
          resourcePolicies_ = other.resourcePolicies_;
          bitField0_ |= 0x40000000;
        } else {
          ensureResourcePoliciesIsMutable();
          resourcePolicies_.addAll(other.resourcePolicies_);
        }
        onChanged();
      }
      if (other.hasResourceStatus()) {
        mergeResourceStatus(other.getResourceStatus());
      }
      if (other.hasSatisfiesPzi()) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField1_ |= 0x00000008;
        onChanged();
      }
      if (serviceAccountsBuilder_ == null) {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccounts_.isEmpty()) {
            serviceAccounts_ = other.serviceAccounts_;
            bitField1_ = (bitField1_ & ~0x00000010);
          } else {
            ensureServiceAccountsIsMutable();
            serviceAccounts_.addAll(other.serviceAccounts_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccountsBuilder_.isEmpty()) {
            serviceAccountsBuilder_.dispose();
            serviceAccountsBuilder_ = null;
            serviceAccounts_ = other.serviceAccounts_;
            bitField1_ = (bitField1_ & ~0x00000010);
            serviceAccountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountsFieldBuilder()
                    : null;
          } else {
            serviceAccountsBuilder_.addAllMessages(other.serviceAccounts_);
          }
        }
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (other.hasShieldedInstanceIntegrityPolicy()) {
        mergeShieldedInstanceIntegrityPolicy(other.getShieldedInstanceIntegrityPolicy());
      }
      if (other.hasSourceMachineImage()) {
        sourceMachineImage_ = other.sourceMachineImage_;
        bitField1_ |= 0x00000080;
        onChanged();
      }
      if (other.hasSourceMachineImageEncryptionKey()) {
        mergeSourceMachineImageEncryptionKey(other.getSourceMachineImageEncryptionKey());
      }
      if (other.hasStartRestricted()) {
        setStartRestricted(other.getStartRestricted());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField1_ |= 0x00000400;
        onChanged();
      }
      if (other.hasStatusMessage()) {
        statusMessage_ = other.statusMessage_;
        bitField1_ |= 0x00000800;
        onChanged();
      }
      if (other.hasTags()) {
        mergeTags(other.getTags());
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField1_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00001000;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 26989658
            case 28418250:
              {
                input.readMessage(getTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00001000;
                break;
              } // case 28418250
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00002000;
                break;
              } // case 29957474
            case 102903210:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000020;
                break;
              } // case 102903210
            case 174158330:
              {
                sourceMachineImage_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000080;
                break;
              } // case 174158330
            case 177763082:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourcePoliciesIsMutable();
                resourcePolicies_.add(s);
                break;
              } // case 177763082
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 244202930
            case 386216050:
              {
                privateIpv6GoogleAccess_ = input.readStringRequireUtf8();
                bitField0_ |= 0x10000000;
                break;
              } // case 386216050
            case 421881946:
              {
                com.google.cloud.compute.v1.NetworkInterface m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NetworkInterface.parser(), extensionRegistry);
                if (networkInterfacesBuilder_ == null) {
                  ensureNetworkInterfacesIsMutable();
                  networkInterfaces_.add(m);
                } else {
                  networkInterfacesBuilder_.addMessage(m);
                }
                break;
              } // case 421881946
            case 517932138:
              {
                input.readMessage(
                    getInstanceEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 517932138
            case 626510898:
              {
                input.readMessage(getParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 626510898
            case 694933882:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 694933882
            case 764752818:
              {
                com.google.cloud.compute.v1.AttachedDisk m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AttachedDisk.parser(), extensionRegistry);
                if (disksBuilder_ == null) {
                  ensureDisksIsMutable();
                  disks_.add(m);
                } else {
                  disksBuilder_.addMessage(m);
                }
                break;
              } // case 764752818
            case 989545152:
              {
                startRestricted_ = input.readBool();
                bitField1_ |= 0x00000200;
                break;
              } // case 989545152
            case 1262805466:
              {
                input.readMessage(
                    getReservationAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 1262805466
            case 1309575354:
              {
                input.readMessage(
                    getShieldedInstanceIntegrityPolicyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000040;
                break;
              } // case 1309575354
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1424998602
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000400;
                break;
              } // case 1450082194
            case 1542712602:
              {
                input.readMessage(
                    getSourceMachineImageEncryptionKeyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000100;
                break;
              } // case 1542712602
            case 1821688210:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 1821688210
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 1877428002
            case 1887531794:
              {
                keyRevocationActionType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1887531794
            case 1896538522:
              {
                hostname_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1896538522
            case 1943302074:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 1943302074
            case 1995434522:
              {
                input.readMessage(getResourceStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 1995434522
            case 2071471002:
              {
                input.readMessage(getDisplayDeviceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 2071471002
            case -2074668670:
              {
                com.google.cloud.compute.v1.ServiceAccount m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ServiceAccount.parser(), extensionRegistry);
                if (serviceAccountsBuilder_ == null) {
                  ensureServiceAccountsIsMutable();
                  serviceAccounts_.add(m);
                } else {
                  serviceAccountsBuilder_.addMessage(m);
                }
                break;
              } // case -2074668670
            case -1915542062:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000800;
                break;
              } // case -1915542062
            case -1444764598:
              {
                lastSuspendedTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case -1444764598
            case -1201460062:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000004;
                break;
              } // case -1201460062
            case -1108320494:
              {
                input.readMessage(
                    getNetworkPerformanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case -1108320494
            case -1017799278:
              {
                input.readMessage(
                    getAdvancedMachineFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1017799278
            case -1012684462:
              {
                cpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1012684462
            case -992383214:
              {
                lastStopTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case -992383214
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -911466526
            case -744321406:
              {
                lastStartTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -744321406
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000008;
                break;
              } // case -645248918
            case -630849712:
              {
                deletionProtection_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case -630849712
            case -586206342:
              {
                com.google.cloud.compute.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (guestAcceleratorsBuilder_ == null) {
                  ensureGuestAcceleratorsIsMutable();
                  guestAccelerators_.add(m);
                } else {
                  guestAcceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -586206342
            case -553116704:
              {
                canIpForward_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -553116704
            case -447253240:
              {
                satisfiesPzi_ = input.readBool();
                bitField1_ |= 0x00000001;
                break;
              } // case -447253240
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField1_ |= 0x00000002;
                break;
              } // case -447253160
            case -369865814:
              {
                input.readMessage(
                    getConfidentialInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -369865814
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private com.google.cloud.compute.v1.AdvancedMachineFeatures advancedMachineFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AdvancedMachineFeatures,
            com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
            com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>
        advancedMachineFeaturesBuilder_;

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     *
     * @return Whether the advancedMachineFeatures field is set.
     */
    public boolean hasAdvancedMachineFeatures() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     *
     * @return The advancedMachineFeatures.
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
      if (advancedMachineFeaturesBuilder_ == null) {
        return advancedMachineFeatures_ == null
            ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      } else {
        return advancedMachineFeaturesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedMachineFeatures_ = value;
      } else {
        advancedMachineFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder builderForValue) {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeatures_ = builderForValue.build();
      } else {
        advancedMachineFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder mergeAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && advancedMachineFeatures_ != null
            && advancedMachineFeatures_
                != com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()) {
          getAdvancedMachineFeaturesBuilder().mergeFrom(value);
        } else {
          advancedMachineFeatures_ = value;
        }
      } else {
        advancedMachineFeaturesBuilder_.mergeFrom(value);
      }
      if (advancedMachineFeatures_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder clearAdvancedMachineFeatures() {
      bitField0_ = (bitField0_ & ~0x00000001);
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder
        getAdvancedMachineFeaturesBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAdvancedMachineFeaturesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder
        getAdvancedMachineFeaturesOrBuilder() {
      if (advancedMachineFeaturesBuilder_ != null) {
        return advancedMachineFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return advancedMachineFeatures_ == null
            ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      }
    }

    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AdvancedMachineFeatures,
            com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
            com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>
        getAdvancedMachineFeaturesFieldBuilder() {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AdvancedMachineFeatures,
                com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
                com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>(
                getAdvancedMachineFeatures(), getParentForChildren(), isClean());
        advancedMachineFeatures_ = null;
      }
      return advancedMachineFeaturesBuilder_;
    }

    private boolean canIpForward_;

    /**
     *
     *
     * <pre>
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return Whether the canIpForward field is set.
     */
    @java.lang.Override
    public boolean hasCanIpForward() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return The canIpForward.
     */
    @java.lang.Override
    public boolean getCanIpForward() {
      return canIpForward_;
    }

    /**
     *
     *
     * <pre>
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @param value The canIpForward to set.
     * @return This builder for chaining.
     */
    public Builder setCanIpForward(boolean value) {

      canIpForward_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding .
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanIpForward() {
      bitField0_ = (bitField0_ & ~0x00000002);
      canIpForward_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConfidentialInstanceConfig,
            com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>
        confidentialInstanceConfigBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     *
     * @return Whether the confidentialInstanceConfig field is set.
     */
    public boolean hasConfidentialInstanceConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     *
     * @return The confidentialInstanceConfig.
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
      if (confidentialInstanceConfigBuilder_ == null) {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      } else {
        return confidentialInstanceConfigBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialInstanceConfig_ = value;
      } else {
        confidentialInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder builderForValue) {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfig_ = builderForValue.build();
      } else {
        confidentialInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder mergeConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && confidentialInstanceConfig_ != null
            && confidentialInstanceConfig_
                != com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()) {
          getConfidentialInstanceConfigBuilder().mergeFrom(value);
        } else {
          confidentialInstanceConfig_ = value;
        }
      } else {
        confidentialInstanceConfigBuilder_.mergeFrom(value);
      }
      if (confidentialInstanceConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder clearConfidentialInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder
        getConfidentialInstanceConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfidentialInstanceConfigFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder
        getConfidentialInstanceConfigOrBuilder() {
      if (confidentialInstanceConfigBuilder_ != null) {
        return confidentialInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConfidentialInstanceConfig,
            com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>
        getConfidentialInstanceConfigFieldBuilder() {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ConfidentialInstanceConfig,
                com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
                com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>(
                getConfidentialInstanceConfig(), getParentForChildren(), isClean());
        confidentialInstanceConfig_ = null;
      }
      return confidentialInstanceConfigBuilder_;
    }

    private java.lang.Object cpuPlatform_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @return Whether the cpuPlatform field is set.
     */
    public boolean hasCpuPlatform() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @return The cpuPlatform.
     */
    public java.lang.String getCpuPlatform() {
      java.lang.Object ref = cpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @return The bytes for cpuPlatform.
     */
    public com.google.protobuf.ByteString getCpuPlatformBytes() {
      java.lang.Object ref = cpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @param value The cpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuPlatform_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuPlatform() {
      cpuPlatform_ = getDefaultInstance().getCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The CPU platform used by this instance.
     * </pre>
     *
     * <code>optional string cpu_platform = 410285354;</code>
     *
     * @param value The bytes for cpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuPlatform_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean deletionProtection_;

    /**
     *
     *
     * <pre>
     * Whether the resource should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return Whether the deletionProtection field is set.
     */
    @java.lang.Override
    public boolean hasDeletionProtection() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether the resource should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return The deletionProtection.
     */
    @java.lang.Override
    public boolean getDeletionProtection() {
      return deletionProtection_;
    }

    /**
     *
     *
     * <pre>
     * Whether the resource should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @param value The deletionProtection to set.
     * @return This builder for chaining.
     */
    public Builder setDeletionProtection(boolean value) {

      deletionProtection_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the resource should be protected against deletion.
     * </pre>
     *
     * <code>optional bool deletion_protection = 458014698;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeletionProtection() {
      bitField0_ = (bitField0_ & ~0x00000020);
      deletionProtection_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.AttachedDisk> disks_ =
        java.util.Collections.emptyList();

    private void ensureDisksIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        disks_ = new java.util.ArrayList<com.google.cloud.compute.v1.AttachedDisk>(disks_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDisk,
            com.google.cloud.compute.v1.AttachedDisk.Builder,
            com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        disksBuilder_;

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AttachedDisk> getDisksList() {
      if (disksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(disks_);
      } else {
        return disksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public int getDisksCount() {
      if (disksBuilder_ == null) {
        return disks_.size();
      } else {
        return disksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk getDisks(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(int index, com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.set(index, value);
        onChanged();
      } else {
        disksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(
        int index, com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.set(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(value);
        onChanged();
      } else {
        disksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(int index, com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(index, value);
        onChanged();
      } else {
        disksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(
        int index, com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addAllDisks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AttachedDisk> values) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
        onChanged();
      } else {
        disksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder clearDisks() {
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        disksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder removeDisks(int index) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.remove(index);
        onChanged();
      } else {
        disksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder getDisksBuilder(int index) {
      return getDisksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDiskOrBuilder getDisksOrBuilder(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        getDisksOrBuilderList() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(disks_);
      }
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder addDisksBuilder() {
      return getDisksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder addDisksBuilder(int index) {
      return getDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AttachedDisk.Builder> getDisksBuilderList() {
      return getDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDisk,
            com.google.cloud.compute.v1.AttachedDisk.Builder,
            com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AttachedDisk,
                com.google.cloud.compute.v1.AttachedDisk.Builder,
                com.google.cloud.compute.v1.AttachedDiskOrBuilder>(
                disks_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private com.google.cloud.compute.v1.DisplayDevice displayDevice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DisplayDevice,
            com.google.cloud.compute.v1.DisplayDevice.Builder,
            com.google.cloud.compute.v1.DisplayDeviceOrBuilder>
        displayDeviceBuilder_;

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     *
     * @return Whether the displayDevice field is set.
     */
    public boolean hasDisplayDevice() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     *
     * @return The displayDevice.
     */
    public com.google.cloud.compute.v1.DisplayDevice getDisplayDevice() {
      if (displayDeviceBuilder_ == null) {
        return displayDevice_ == null
            ? com.google.cloud.compute.v1.DisplayDevice.getDefaultInstance()
            : displayDevice_;
      } else {
        return displayDeviceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public Builder setDisplayDevice(com.google.cloud.compute.v1.DisplayDevice value) {
      if (displayDeviceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayDevice_ = value;
      } else {
        displayDeviceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public Builder setDisplayDevice(
        com.google.cloud.compute.v1.DisplayDevice.Builder builderForValue) {
      if (displayDeviceBuilder_ == null) {
        displayDevice_ = builderForValue.build();
      } else {
        displayDeviceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public Builder mergeDisplayDevice(com.google.cloud.compute.v1.DisplayDevice value) {
      if (displayDeviceBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && displayDevice_ != null
            && displayDevice_ != com.google.cloud.compute.v1.DisplayDevice.getDefaultInstance()) {
          getDisplayDeviceBuilder().mergeFrom(value);
        } else {
          displayDevice_ = value;
        }
      } else {
        displayDeviceBuilder_.mergeFrom(value);
      }
      if (displayDevice_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public Builder clearDisplayDevice() {
      bitField0_ = (bitField0_ & ~0x00000100);
      displayDevice_ = null;
      if (displayDeviceBuilder_ != null) {
        displayDeviceBuilder_.dispose();
        displayDeviceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public com.google.cloud.compute.v1.DisplayDevice.Builder getDisplayDeviceBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDisplayDeviceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    public com.google.cloud.compute.v1.DisplayDeviceOrBuilder getDisplayDeviceOrBuilder() {
      if (displayDeviceBuilder_ != null) {
        return displayDeviceBuilder_.getMessageOrBuilder();
      } else {
        return displayDevice_ == null
            ? com.google.cloud.compute.v1.DisplayDevice.getDefaultInstance()
            : displayDevice_;
      }
    }

    /**
     *
     *
     * <pre>
     * Enables display device for the instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DisplayDevice,
            com.google.cloud.compute.v1.DisplayDevice.Builder,
            com.google.cloud.compute.v1.DisplayDeviceOrBuilder>
        getDisplayDeviceFieldBuilder() {
      if (displayDeviceBuilder_ == null) {
        displayDeviceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.DisplayDevice,
                com.google.cloud.compute.v1.DisplayDevice.Builder,
                com.google.cloud.compute.v1.DisplayDeviceOrBuilder>(
                getDisplayDevice(), getParentForChildren(), isClean());
        displayDevice_ = null;
      }
      return displayDeviceBuilder_;
    }

    private java.lang.Object fingerprint_ = "";

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_ =
        java.util.Collections.emptyList();

    private void ensureGuestAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        guestAccelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AcceleratorConfig>(
                guestAccelerators_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        guestAcceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig>
        getGuestAcceleratorsList() {
      if (guestAcceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      } else {
        return guestAcceleratorsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public int getGuestAcceleratorsCount() {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.size();
      } else {
        return guestAcceleratorsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addAllGuestAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AcceleratorConfig> values) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestAccelerators_);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder clearGuestAccelerators() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder removeGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.remove(index);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder getGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
        int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsOrBuilderList() {
      if (guestAcceleratorsBuilder_ != null) {
        return guestAcceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder() {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the type and count of accelerator cards attached to the instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig.Builder>
        getGuestAcceleratorsBuilderList() {
      return getGuestAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsFieldBuilder() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAcceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AcceleratorConfig,
                com.google.cloud.compute.v1.AcceleratorConfig.Builder,
                com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>(
                guestAccelerators_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        guestAccelerators_ = null;
      }
      return guestAcceleratorsBuilder_;
    }

    private java.lang.Object hostname_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @return Whether the hostname field is set.
     */
    public boolean hasHostname() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @return The hostname.
     */
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @return The bytes for hostname.
     */
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @param value The hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostname_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostname() {
      hostname_ = getDefaultInstance().getHostname();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     * </pre>
     *
     * <code>optional string hostname = 237067315;</code>
     *
     * @param value The bytes for hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostname_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00001000);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey instanceEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        instanceEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     *
     * @return Whether the instanceEncryptionKey field is set.
     */
    public boolean hasInstanceEncryptionKey() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     *
     * @return The instanceEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getInstanceEncryptionKey() {
      if (instanceEncryptionKeyBuilder_ == null) {
        return instanceEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : instanceEncryptionKey_;
      } else {
        return instanceEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public Builder setInstanceEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (instanceEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceEncryptionKey_ = value;
      } else {
        instanceEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public Builder setInstanceEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (instanceEncryptionKeyBuilder_ == null) {
        instanceEncryptionKey_ = builderForValue.build();
      } else {
        instanceEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public Builder mergeInstanceEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (instanceEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && instanceEncryptionKey_ != null
            && instanceEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getInstanceEncryptionKeyBuilder().mergeFrom(value);
        } else {
          instanceEncryptionKey_ = value;
        }
      } else {
        instanceEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (instanceEncryptionKey_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public Builder clearInstanceEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00002000);
      instanceEncryptionKey_ = null;
      if (instanceEncryptionKeyBuilder_ != null) {
        instanceEncryptionKeyBuilder_.dispose();
        instanceEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getInstanceEncryptionKeyBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getInstanceEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getInstanceEncryptionKeyOrBuilder() {
      if (instanceEncryptionKeyBuilder_ != null) {
        return instanceEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return instanceEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : instanceEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts suspended data for an instance with a customer-managed encryption key. If you are creating a new instance, this field will encrypt the local SSD and in-memory contents of the instance during the suspend operation. If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key during the suspend operation.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey instance_encryption_key = 64741517;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getInstanceEncryptionKeyFieldBuilder() {
      if (instanceEncryptionKeyBuilder_ == null) {
        instanceEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getInstanceEncryptionKey(), getParentForChildren(), isClean());
        instanceEncryptionKey_ = null;
      }
      return instanceEncryptionKeyBuilder_;
    }

    private java.lang.Object keyRevocationActionType_ = "";

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return Whether the keyRevocationActionType field is set.
     */
    public boolean hasKeyRevocationActionType() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The keyRevocationActionType.
     */
    public java.lang.String getKeyRevocationActionType() {
      java.lang.Object ref = keyRevocationActionType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyRevocationActionType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The bytes for keyRevocationActionType.
     */
    public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
      java.lang.Object ref = keyRevocationActionType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyRevocationActionType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyRevocationActionType() {
      keyRevocationActionType_ = getDefaultInstance().getKeyRevocationActionType();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The bytes for keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#instance for instances.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the instance.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00020000;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private java.lang.Object lastStartTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @return Whether the lastStartTimestamp field is set.
     */
    public boolean hasLastStartTimestamp() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @return The lastStartTimestamp.
     */
    public java.lang.String getLastStartTimestamp() {
      java.lang.Object ref = lastStartTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastStartTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @return The bytes for lastStartTimestamp.
     */
    public com.google.protobuf.ByteString getLastStartTimestampBytes() {
      java.lang.Object ref = lastStartTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastStartTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @param value The lastStartTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastStartTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastStartTimestamp_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastStartTimestamp() {
      lastStartTimestamp_ = getDefaultInstance().getLastStartTimestamp();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last start timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_start_timestamp = 443830736;</code>
     *
     * @param value The bytes for lastStartTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastStartTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastStartTimestamp_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object lastStopTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @return Whether the lastStopTimestamp field is set.
     */
    public boolean hasLastStopTimestamp() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @return The lastStopTimestamp.
     */
    public java.lang.String getLastStopTimestamp() {
      java.lang.Object ref = lastStopTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastStopTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @return The bytes for lastStopTimestamp.
     */
    public com.google.protobuf.ByteString getLastStopTimestampBytes() {
      java.lang.Object ref = lastStopTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastStopTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @param value The lastStopTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastStopTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastStopTimestamp_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastStopTimestamp() {
      lastStopTimestamp_ = getDefaultInstance().getLastStopTimestamp();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last stop timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_stop_timestamp = 412823010;</code>
     *
     * @param value The bytes for lastStopTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastStopTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastStopTimestamp_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object lastSuspendedTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @return Whether the lastSuspendedTimestamp field is set.
     */
    public boolean hasLastSuspendedTimestamp() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @return The lastSuspendedTimestamp.
     */
    public java.lang.String getLastSuspendedTimestamp() {
      java.lang.Object ref = lastSuspendedTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastSuspendedTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @return The bytes for lastSuspendedTimestamp.
     */
    public com.google.protobuf.ByteString getLastSuspendedTimestampBytes() {
      java.lang.Object ref = lastSuspendedTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastSuspendedTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @param value The lastSuspendedTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastSuspendedTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastSuspendedTimestamp_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastSuspendedTimestamp() {
      lastSuspendedTimestamp_ = getDefaultInstance().getLastSuspendedTimestamp();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_suspended_timestamp = 356275337;</code>
     *
     * @param value The bytes for lastSuspendedTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastSuspendedTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastSuspendedTimestamp_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object machineType_ = "";

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return Whether the machineType field is set.
     */
    public boolean hasMachineType() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type: zones/us-central1-f/machineTypes/n1-standard-1 To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB): zones/zone/machineTypes/custom-CPUS-MEMORY For example: zones/us-central1-f/machineTypes/custom-4-5120 For a full list of restrictions, read the Specifications for custom machine types.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        metadataBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.compute.v1.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder mergeMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.compute.v1.Metadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00400000);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.Metadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Metadata,
                com.google.cloud.compute.v1.Metadata.Builder,
                com.google.cloud.compute.v1.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.lang.Object minCpuPlatform_ = "";

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return Whether the minCpuPlatform field is set.
     */
    public boolean hasMinCpuPlatform() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x01000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_ =
        java.util.Collections.emptyList();

    private void ensureNetworkInterfacesIsMutable() {
      if (!((bitField0_ & 0x02000000) != 0)) {
        networkInterfaces_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.NetworkInterface>(
                networkInterfaces_);
        bitField0_ |= 0x02000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        networkInterfacesBuilder_;

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
      if (networkInterfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      } else {
        return networkInterfacesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public int getNetworkInterfacesCount() {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.size();
      } else {
        return networkInterfacesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addAllNetworkInterfaces(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NetworkInterface> values) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkInterfaces_);
        onChanged();
      } else {
        networkInterfacesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder clearNetworkInterfaces() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x02000000);
        onChanged();
      } else {
        networkInterfacesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder removeNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.remove(index);
        onChanged();
      } else {
        networkInterfacesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder getNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
        int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList() {
      if (networkInterfacesBuilder_ != null) {
        return networkInterfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder() {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface.Builder>
        getNetworkInterfacesBuilderList() {
      return getNetworkInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesFieldBuilder() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkInterface,
                com.google.cloud.compute.v1.NetworkInterface.Builder,
                com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>(
                networkInterfaces_,
                ((bitField0_ & 0x02000000) != 0),
                getParentForChildren(),
                isClean());
        networkInterfaces_ = null;
      }
      return networkInterfacesBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkPerformanceConfig networkPerformanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPerformanceConfig,
            com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
            com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>
        networkPerformanceConfigBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     *
     * @return Whether the networkPerformanceConfig field is set.
     */
    public boolean hasNetworkPerformanceConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     *
     * @return The networkPerformanceConfig.
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfig getNetworkPerformanceConfig() {
      if (networkPerformanceConfigBuilder_ == null) {
        return networkPerformanceConfig_ == null
            ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
            : networkPerformanceConfig_;
      } else {
        return networkPerformanceConfigBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPerformanceConfig_ = value;
      } else {
        networkPerformanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder builderForValue) {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfig_ = builderForValue.build();
      } else {
        networkPerformanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder mergeNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && networkPerformanceConfig_ != null
            && networkPerformanceConfig_
                != com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()) {
          getNetworkPerformanceConfigBuilder().mergeFrom(value);
        } else {
          networkPerformanceConfig_ = value;
        }
      } else {
        networkPerformanceConfigBuilder_.mergeFrom(value);
      }
      if (networkPerformanceConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder clearNetworkPerformanceConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder
        getNetworkPerformanceConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getNetworkPerformanceConfigFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder
        getNetworkPerformanceConfigOrBuilder() {
      if (networkPerformanceConfigBuilder_ != null) {
        return networkPerformanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkPerformanceConfig_ == null
            ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
            : networkPerformanceConfig_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPerformanceConfig,
            com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
            com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>
        getNetworkPerformanceConfigFieldBuilder() {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkPerformanceConfig,
                com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
                com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>(
                getNetworkPerformanceConfig(), getParentForChildren(), isClean());
        networkPerformanceConfig_ = null;
      }
      return networkPerformanceConfigBuilder_;
    }

    private com.google.cloud.compute.v1.InstanceParams params_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceParams,
            com.google.cloud.compute.v1.InstanceParams.Builder,
            com.google.cloud.compute.v1.InstanceParamsOrBuilder>
        paramsBuilder_;

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     *
     * @return Whether the params field is set.
     */
    public boolean hasParams() {
      return ((bitField0_ & 0x08000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     *
     * @return The params.
     */
    public com.google.cloud.compute.v1.InstanceParams getParams() {
      if (paramsBuilder_ == null) {
        return params_ == null
            ? com.google.cloud.compute.v1.InstanceParams.getDefaultInstance()
            : params_;
      } else {
        return paramsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.InstanceParams value) {
      if (paramsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        params_ = value;
      } else {
        paramsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public Builder setParams(com.google.cloud.compute.v1.InstanceParams.Builder builderForValue) {
      if (paramsBuilder_ == null) {
        params_ = builderForValue.build();
      } else {
        paramsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public Builder mergeParams(com.google.cloud.compute.v1.InstanceParams value) {
      if (paramsBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && params_ != null
            && params_ != com.google.cloud.compute.v1.InstanceParams.getDefaultInstance()) {
          getParamsBuilder().mergeFrom(value);
        } else {
          params_ = value;
        }
      } else {
        paramsBuilder_.mergeFrom(value);
      }
      if (params_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x08000000);
      params_ = null;
      if (paramsBuilder_ != null) {
        paramsBuilder_.dispose();
        paramsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.InstanceParams.Builder getParamsBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    public com.google.cloud.compute.v1.InstanceParamsOrBuilder getParamsOrBuilder() {
      if (paramsBuilder_ != null) {
        return paramsBuilder_.getMessageOrBuilder();
      } else {
        return params_ == null
            ? com.google.cloud.compute.v1.InstanceParams.getDefaultInstance()
            : params_;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceParams params = 78313862;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceParams,
            com.google.cloud.compute.v1.InstanceParams.Builder,
            com.google.cloud.compute.v1.InstanceParamsOrBuilder>
        getParamsFieldBuilder() {
      if (paramsBuilder_ == null) {
        paramsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceParams,
                com.google.cloud.compute.v1.InstanceParams.Builder,
                com.google.cloud.compute.v1.InstanceParamsOrBuilder>(
                getParams(), getParentForChildren(), isClean());
        params_ = null;
      }
      return paramsBuilder_;
    }

    private java.lang.Object privateIpv6GoogleAccess_ = "";

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return Whether the privateIpv6GoogleAccess field is set.
     */
    public boolean hasPrivateIpv6GoogleAccess() {
      return ((bitField0_ & 0x10000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The privateIpv6GoogleAccess.
     */
    public java.lang.String getPrivateIpv6GoogleAccess() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIpv6GoogleAccess_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The bytes for privateIpv6GoogleAccess.
     */
    public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIpv6GoogleAccess_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccess(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpv6GoogleAccess() {
      privateIpv6GoogleAccess_ = getDefaultInstance().getPrivateIpv6GoogleAccess();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The bytes for privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccessBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ReservationAffinity reservationAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAffinity,
            com.google.cloud.compute.v1.ReservationAffinity.Builder,
            com.google.cloud.compute.v1.ReservationAffinityOrBuilder>
        reservationAffinityBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     *
     * @return Whether the reservationAffinity field is set.
     */
    public boolean hasReservationAffinity() {
      return ((bitField0_ & 0x20000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     *
     * @return The reservationAffinity.
     */
    public com.google.cloud.compute.v1.ReservationAffinity getReservationAffinity() {
      if (reservationAffinityBuilder_ == null) {
        return reservationAffinity_ == null
            ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      } else {
        return reservationAffinityBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder setReservationAffinity(com.google.cloud.compute.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationAffinity_ = value;
      } else {
        reservationAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder setReservationAffinity(
        com.google.cloud.compute.v1.ReservationAffinity.Builder builderForValue) {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinity_ = builderForValue.build();
      } else {
        reservationAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder mergeReservationAffinity(com.google.cloud.compute.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && reservationAffinity_ != null
            && reservationAffinity_
                != com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()) {
          getReservationAffinityBuilder().mergeFrom(value);
        } else {
          reservationAffinity_ = value;
        }
      } else {
        reservationAffinityBuilder_.mergeFrom(value);
      }
      if (reservationAffinity_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder clearReservationAffinity() {
      bitField0_ = (bitField0_ & ~0x20000000);
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAffinity.Builder getReservationAffinityBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getReservationAffinityFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAffinityOrBuilder
        getReservationAffinityOrBuilder() {
      if (reservationAffinityBuilder_ != null) {
        return reservationAffinityBuilder_.getMessageOrBuilder();
      } else {
        return reservationAffinity_ == null
            ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the reservations that this instance can consume from.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAffinity,
            com.google.cloud.compute.v1.ReservationAffinity.Builder,
            com.google.cloud.compute.v1.ReservationAffinityOrBuilder>
        getReservationAffinityFieldBuilder() {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ReservationAffinity,
                com.google.cloud.compute.v1.ReservationAffinity.Builder,
                com.google.cloud.compute.v1.ReservationAffinityOrBuilder>(
                getReservationAffinity(), getParentForChildren(), isClean());
        reservationAffinity_ = null;
      }
      return reservationAffinityBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList resourcePolicies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourcePoliciesIsMutable() {
      if (!resourcePolicies_.isModifiable()) {
        resourcePolicies_ = new com.google.protobuf.LazyStringArrayList(resourcePolicies_);
      }
      bitField0_ |= 0x40000000;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return A list containing the resourcePolicies.
     */
    public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
      resourcePolicies_.makeImmutable();
      return resourcePolicies_;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return The count of resourcePolicies.
     */
    public int getResourcePoliciesCount() {
      return resourcePolicies_.size();
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the element to return.
     * @return The resourcePolicies at the given index.
     */
    public java.lang.String getResourcePolicies(int index) {
      return resourcePolicies_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourcePolicies at the given index.
     */
    public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
      return resourcePolicies_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index to set the value at.
     * @param value The resourcePolicies to set.
     * @return This builder for chaining.
     */
    public Builder setResourcePolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.set(index, value);
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param values The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourcePolicies(java.lang.Iterable<java.lang.String> values) {
      ensureResourcePoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourcePolicies_);
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourcePolicies() {
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x40000000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource policies applied to this instance.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The bytes of the resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourceStatus resourceStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatus,
            com.google.cloud.compute.v1.ResourceStatus.Builder,
            com.google.cloud.compute.v1.ResourceStatusOrBuilder>
        resourceStatusBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     *
     * @return Whether the resourceStatus field is set.
     */
    public boolean hasResourceStatus() {
      return ((bitField0_ & 0x80000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     *
     * @return The resourceStatus.
     */
    public com.google.cloud.compute.v1.ResourceStatus getResourceStatus() {
      if (resourceStatusBuilder_ == null) {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()
            : resourceStatus_;
      } else {
        return resourceStatusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public Builder setResourceStatus(com.google.cloud.compute.v1.ResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceStatus_ = value;
      } else {
        resourceStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public Builder setResourceStatus(
        com.google.cloud.compute.v1.ResourceStatus.Builder builderForValue) {
      if (resourceStatusBuilder_ == null) {
        resourceStatus_ = builderForValue.build();
      } else {
        resourceStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public Builder mergeResourceStatus(com.google.cloud.compute.v1.ResourceStatus value) {
      if (resourceStatusBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && resourceStatus_ != null
            && resourceStatus_ != com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()) {
          getResourceStatusBuilder().mergeFrom(value);
        } else {
          resourceStatus_ = value;
        }
      } else {
        resourceStatusBuilder_.mergeFrom(value);
      }
      if (resourceStatus_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public Builder clearResourceStatus() {
      bitField0_ = (bitField0_ & ~0x80000000);
      resourceStatus_ = null;
      if (resourceStatusBuilder_ != null) {
        resourceStatusBuilder_.dispose();
        resourceStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public com.google.cloud.compute.v1.ResourceStatus.Builder getResourceStatusBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getResourceStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    public com.google.cloud.compute.v1.ResourceStatusOrBuilder getResourceStatusOrBuilder() {
      if (resourceStatusBuilder_ != null) {
        return resourceStatusBuilder_.getMessageOrBuilder();
      } else {
        return resourceStatus_ == null
            ? com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()
            : resourceStatus_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ResourceStatus resource_status = 249429315;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatus,
            com.google.cloud.compute.v1.ResourceStatus.Builder,
            com.google.cloud.compute.v1.ResourceStatusOrBuilder>
        getResourceStatusFieldBuilder() {
      if (resourceStatusBuilder_ == null) {
        resourceStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourceStatus,
                com.google.cloud.compute.v1.ResourceStatus.Builder,
                com.google.cloud.compute.v1.ResourceStatusOrBuilder>(
                getResourceStatus(), getParentForChildren(), isClean());
        resourceStatus_ = null;
      }
      return resourceStatusBuilder_;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return Whether the satisfiesPzi field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzi() {
      return ((bitField1_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField1_ = (bitField1_ & ~0x00000001);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField1_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField1_ = (bitField1_ & ~0x00000002);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Scheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        schedulingBuilder_;

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField1_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.compute.v1.Scheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder mergeScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)
            && scheduling_ != null
            && scheduling_ != com.google.cloud.compute.v1.Scheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      if (scheduling_ != null) {
        bitField1_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder clearScheduling() {
      bitField1_ = (bitField1_ & ~0x00000004);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.Scheduling.Builder getSchedulingBuilder() {
      bitField1_ |= 0x00000004;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      }
    }

    /**
     *
     *
     * <pre>
     * Sets the scheduling options for this instance.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Scheduling,
                com.google.cloud.compute.v1.Scheduling.Builder,
                com.google.cloud.compute.v1.SchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField1_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField1_ = (bitField1_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_ =
        java.util.Collections.emptyList();

    private void ensureServiceAccountsIsMutable() {
      if (!((bitField1_ & 0x00000010) != 0)) {
        serviceAccounts_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ServiceAccount>(serviceAccounts_);
        bitField1_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        serviceAccountsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
      if (serviceAccountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      } else {
        return serviceAccountsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public int getServiceAccountsCount() {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.size();
      } else {
        return serviceAccountsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addAllServiceAccounts(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ServiceAccount> values) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccounts_);
        onChanged();
      } else {
        serviceAccountsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder clearServiceAccounts() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000010);
        onChanged();
      } else {
        serviceAccountsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder removeServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.remove(index);
        onChanged();
      } else {
        serviceAccountsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder getServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
        int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsOrBuilderList() {
      if (serviceAccountsBuilder_ != null) {
        return serviceAccountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder() {
      return getServiceAccountsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported. Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount.Builder>
        getServiceAccountsBuilderList() {
      return getServiceAccountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsFieldBuilder() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ServiceAccount,
                com.google.cloud.compute.v1.ServiceAccount.Builder,
                com.google.cloud.compute.v1.ServiceAccountOrBuilder>(
                serviceAccounts_,
                ((bitField1_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        serviceAccounts_ = null;
      }
      return serviceAccountsBuilder_;
    }

    private com.google.cloud.compute.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceConfig,
            com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField1_ & 0x00000020) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000020) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      if (shieldedInstanceConfig_ != null) {
        bitField1_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField1_ = (bitField1_ & ~0x00000020);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField1_ |= 0x00000020;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceConfig,
            com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ShieldedInstanceConfig,
                com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
                com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy
        shieldedInstanceIntegrityPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy,
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder>
        shieldedInstanceIntegrityPolicyBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     *
     * @return Whether the shieldedInstanceIntegrityPolicy field is set.
     */
    public boolean hasShieldedInstanceIntegrityPolicy() {
      return ((bitField1_ & 0x00000040) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     *
     * @return The shieldedInstanceIntegrityPolicy.
     */
    public com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy
        getShieldedInstanceIntegrityPolicy() {
      if (shieldedInstanceIntegrityPolicyBuilder_ == null) {
        return shieldedInstanceIntegrityPolicy_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.getDefaultInstance()
            : shieldedInstanceIntegrityPolicy_;
      } else {
        return shieldedInstanceIntegrityPolicyBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public Builder setShieldedInstanceIntegrityPolicy(
        com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy value) {
      if (shieldedInstanceIntegrityPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceIntegrityPolicy_ = value;
      } else {
        shieldedInstanceIntegrityPolicyBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public Builder setShieldedInstanceIntegrityPolicy(
        com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.Builder builderForValue) {
      if (shieldedInstanceIntegrityPolicyBuilder_ == null) {
        shieldedInstanceIntegrityPolicy_ = builderForValue.build();
      } else {
        shieldedInstanceIntegrityPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public Builder mergeShieldedInstanceIntegrityPolicy(
        com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy value) {
      if (shieldedInstanceIntegrityPolicyBuilder_ == null) {
        if (((bitField1_ & 0x00000040) != 0)
            && shieldedInstanceIntegrityPolicy_ != null
            && shieldedInstanceIntegrityPolicy_
                != com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy
                    .getDefaultInstance()) {
          getShieldedInstanceIntegrityPolicyBuilder().mergeFrom(value);
        } else {
          shieldedInstanceIntegrityPolicy_ = value;
        }
      } else {
        shieldedInstanceIntegrityPolicyBuilder_.mergeFrom(value);
      }
      if (shieldedInstanceIntegrityPolicy_ != null) {
        bitField1_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public Builder clearShieldedInstanceIntegrityPolicy() {
      bitField1_ = (bitField1_ & ~0x00000040);
      shieldedInstanceIntegrityPolicy_ = null;
      if (shieldedInstanceIntegrityPolicyBuilder_ != null) {
        shieldedInstanceIntegrityPolicyBuilder_.dispose();
        shieldedInstanceIntegrityPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.Builder
        getShieldedInstanceIntegrityPolicyBuilder() {
      bitField1_ |= 0x00000040;
      onChanged();
      return getShieldedInstanceIntegrityPolicyFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder
        getShieldedInstanceIntegrityPolicyOrBuilder() {
      if (shieldedInstanceIntegrityPolicyBuilder_ != null) {
        return shieldedInstanceIntegrityPolicyBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceIntegrityPolicy_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.getDefaultInstance()
            : shieldedInstanceIntegrityPolicy_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy,
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder>
        getShieldedInstanceIntegrityPolicyFieldBuilder() {
      if (shieldedInstanceIntegrityPolicyBuilder_ == null) {
        shieldedInstanceIntegrityPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy,
                com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy.Builder,
                com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicyOrBuilder>(
                getShieldedInstanceIntegrityPolicy(), getParentForChildren(), isClean());
        shieldedInstanceIntegrityPolicy_ = null;
      }
      return shieldedInstanceIntegrityPolicyBuilder_;
    }

    private java.lang.Object sourceMachineImage_ = "";

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @return Whether the sourceMachineImage field is set.
     */
    public boolean hasSourceMachineImage() {
      return ((bitField1_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @return The sourceMachineImage.
     */
    public java.lang.String getSourceMachineImage() {
      java.lang.Object ref = sourceMachineImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceMachineImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @return The bytes for sourceMachineImage.
     */
    public com.google.protobuf.ByteString getSourceMachineImageBytes() {
      java.lang.Object ref = sourceMachineImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceMachineImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @param value The sourceMachineImage to set.
     * @return This builder for chaining.
     */
    public Builder setSourceMachineImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceMachineImage_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceMachineImage() {
      sourceMachineImage_ = getDefaultInstance().getSourceMachineImage();
      bitField1_ = (bitField1_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image
     * </pre>
     *
     * <code>optional string source_machine_image = 21769791;</code>
     *
     * @param value The bytes for sourceMachineImage to set.
     * @return This builder for chaining.
     */
    public Builder setSourceMachineImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceMachineImage_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey sourceMachineImageEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        sourceMachineImageEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     *
     * @return Whether the sourceMachineImageEncryptionKey field is set.
     */
    public boolean hasSourceMachineImageEncryptionKey() {
      return ((bitField1_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     *
     * @return The sourceMachineImageEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceMachineImageEncryptionKey() {
      if (sourceMachineImageEncryptionKeyBuilder_ == null) {
        return sourceMachineImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceMachineImageEncryptionKey_;
      } else {
        return sourceMachineImageEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public Builder setSourceMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceMachineImageEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceMachineImageEncryptionKey_ = value;
      } else {
        sourceMachineImageEncryptionKeyBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public Builder setSourceMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (sourceMachineImageEncryptionKeyBuilder_ == null) {
        sourceMachineImageEncryptionKey_ = builderForValue.build();
      } else {
        sourceMachineImageEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public Builder mergeSourceMachineImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceMachineImageEncryptionKeyBuilder_ == null) {
        if (((bitField1_ & 0x00000100) != 0)
            && sourceMachineImageEncryptionKey_ != null
            && sourceMachineImageEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSourceMachineImageEncryptionKeyBuilder().mergeFrom(value);
        } else {
          sourceMachineImageEncryptionKey_ = value;
        }
      } else {
        sourceMachineImageEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (sourceMachineImageEncryptionKey_ != null) {
        bitField1_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public Builder clearSourceMachineImageEncryptionKey() {
      bitField1_ = (bitField1_ & ~0x00000100);
      sourceMachineImageEncryptionKey_ = null;
      if (sourceMachineImageEncryptionKeyBuilder_ != null) {
        sourceMachineImageEncryptionKeyBuilder_.dispose();
        sourceMachineImageEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSourceMachineImageEncryptionKeyBuilder() {
      bitField1_ |= 0x00000100;
      onChanged();
      return getSourceMachineImageEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSourceMachineImageEncryptionKeyOrBuilder() {
      if (sourceMachineImageEncryptionKeyBuilder_ != null) {
        return sourceMachineImageEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return sourceMachineImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceMachineImageEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Source machine image encryption key when creating an instance from a machine image.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_machine_image_encryption_key = 192839075;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSourceMachineImageEncryptionKeyFieldBuilder() {
      if (sourceMachineImageEncryptionKeyBuilder_ == null) {
        sourceMachineImageEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSourceMachineImageEncryptionKey(), getParentForChildren(), isClean());
        sourceMachineImageEncryptionKey_ = null;
      }
      return sourceMachineImageEncryptionKeyBuilder_;
    }

    private boolean startRestricted_;

    /**
     *
     *
     * <pre>
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     * </pre>
     *
     * <code>optional bool start_restricted = 123693144;</code>
     *
     * @return Whether the startRestricted field is set.
     */
    @java.lang.Override
    public boolean hasStartRestricted() {
      return ((bitField1_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     * </pre>
     *
     * <code>optional bool start_restricted = 123693144;</code>
     *
     * @return The startRestricted.
     */
    @java.lang.Override
    public boolean getStartRestricted() {
      return startRestricted_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     * </pre>
     *
     * <code>optional bool start_restricted = 123693144;</code>
     *
     * @param value The startRestricted to set.
     * @return This builder for chaining.
     */
    public Builder setStartRestricted(boolean value) {

      startRestricted_ = value;
      bitField1_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     * </pre>
     *
     * <code>optional bool start_restricted = 123693144;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartRestricted() {
      bitField1_ = (bitField1_ & ~0x00000200);
      startRestricted_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField1_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField1_ = (bitField1_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return Whether the statusMessage field is set.
     */
    public boolean hasStatusMessage() {
      return ((bitField1_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField1_ = (bitField1_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Tags tags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        tagsBuilder_;

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return Whether the tags field is set.
     */
    public boolean hasTags() {
      return ((bitField1_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return The tags.
     */
    public com.google.cloud.compute.v1.Tags getTags() {
      if (tagsBuilder_ == null) {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      } else {
        return tagsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tags_ = value;
      } else {
        tagsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        tags_ = builderForValue.build();
      } else {
        tagsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder mergeTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (((bitField1_ & 0x00001000) != 0)
            && tags_ != null
            && tags_ != com.google.cloud.compute.v1.Tags.getDefaultInstance()) {
          getTagsBuilder().mergeFrom(value);
        } else {
          tags_ = value;
        }
      } else {
        tagsBuilder_.mergeFrom(value);
      }
      if (tags_ != null) {
        bitField1_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder clearTags() {
      bitField1_ = (bitField1_ & ~0x00001000);
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.Tags.Builder getTagsBuilder() {
      bitField1_ |= 0x00001000;
      onChanged();
      return getTagsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilder();
      } else {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      }
    }

    /**
     *
     *
     * <pre>
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Tags,
                com.google.cloud.compute.v1.Tags.Builder,
                com.google.cloud.compute.v1.TagsOrBuilder>(
                getTags(), getParentForChildren(), isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField1_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField1_ = (bitField1_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Instance)
  private static final com.google.cloud.compute.v1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Instance();
  }

  public static com.google.cloud.compute.v1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
