/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails}
 */
public final class InstanceManagedByIgmErrorInstanceActionDetails
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails)
    InstanceManagedByIgmErrorInstanceActionDetailsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InstanceManagedByIgmErrorInstanceActionDetails.newBuilder() to construct.
  private InstanceManagedByIgmErrorInstanceActionDetails(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceManagedByIgmErrorInstanceActionDetails() {
    action_ = "";
    instance_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceManagedByIgmErrorInstanceActionDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceManagedByIgmErrorInstanceActionDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceManagedByIgmErrorInstanceActionDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.class,
            com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ACTION = 0;</code>
     */
    UNDEFINED_ACTION(0),
    /**
     *
     *
     * <pre>
     * The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
     * </pre>
     *
     * <code>ABANDONING = 388244813;</code>
     */
    ABANDONING(388244813),
    /**
     *
     *
     * <pre>
     * The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
     * </pre>
     *
     * <code>CREATING_WITHOUT_RETRIES = 428843785;</code>
     */
    CREATING_WITHOUT_RETRIES(428843785),
    /**
     *
     *
     * <pre>
     * The managed instance group is permanently deleting this instance.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * The managed instance group has not scheduled any actions for this instance.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * The managed instance group is recreating this instance.
     * </pre>
     *
     * <code>RECREATING = 287278572;</code>
     */
    RECREATING(287278572),
    /**
     *
     *
     * <pre>
     * The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
     * </pre>
     *
     * <code>REFRESHING = 163266343;</code>
     */
    REFRESHING(163266343),
    /**
     *
     *
     * <pre>
     * The managed instance group is restarting this instance.
     * </pre>
     *
     * <code>RESTARTING = 320534387;</code>
     */
    RESTARTING(320534387),
    /**
     *
     *
     * <pre>
     * The managed instance group is resuming this instance.
     * </pre>
     *
     * <code>RESUMING = 446856618;</code>
     */
    RESUMING(446856618),
    /**
     *
     *
     * <pre>
     * The managed instance group is starting this instance.
     * </pre>
     *
     * <code>STARTING = 488820800;</code>
     */
    STARTING(488820800),
    /**
     *
     *
     * <pre>
     * The managed instance group is stopping this instance.
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    STOPPING(350791796),
    /**
     *
     *
     * <pre>
     * The managed instance group is suspending this instance.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    SUSPENDING(514206246),
    /**
     *
     *
     * <pre>
     * The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
     * </pre>
     *
     * <code>VERIFYING = 16982185;</code>
     */
    VERIFYING(16982185),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ACTION = 0;</code>
     */
    public static final int UNDEFINED_ACTION_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
     * </pre>
     *
     * <code>ABANDONING = 388244813;</code>
     */
    public static final int ABANDONING_VALUE = 388244813;

    /**
     *
     *
     * <pre>
     * The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;

    /**
     *
     *
     * <pre>
     * The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
     * </pre>
     *
     * <code>CREATING_WITHOUT_RETRIES = 428843785;</code>
     */
    public static final int CREATING_WITHOUT_RETRIES_VALUE = 428843785;

    /**
     *
     *
     * <pre>
     * The managed instance group is permanently deleting this instance.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;

    /**
     *
     *
     * <pre>
     * The managed instance group has not scheduled any actions for this instance.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;

    /**
     *
     *
     * <pre>
     * The managed instance group is recreating this instance.
     * </pre>
     *
     * <code>RECREATING = 287278572;</code>
     */
    public static final int RECREATING_VALUE = 287278572;

    /**
     *
     *
     * <pre>
     * The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
     * </pre>
     *
     * <code>REFRESHING = 163266343;</code>
     */
    public static final int REFRESHING_VALUE = 163266343;

    /**
     *
     *
     * <pre>
     * The managed instance group is restarting this instance.
     * </pre>
     *
     * <code>RESTARTING = 320534387;</code>
     */
    public static final int RESTARTING_VALUE = 320534387;

    /**
     *
     *
     * <pre>
     * The managed instance group is resuming this instance.
     * </pre>
     *
     * <code>RESUMING = 446856618;</code>
     */
    public static final int RESUMING_VALUE = 446856618;

    /**
     *
     *
     * <pre>
     * The managed instance group is starting this instance.
     * </pre>
     *
     * <code>STARTING = 488820800;</code>
     */
    public static final int STARTING_VALUE = 488820800;

    /**
     *
     *
     * <pre>
     * The managed instance group is stopping this instance.
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    public static final int STOPPING_VALUE = 350791796;

    /**
     *
     *
     * <pre>
     * The managed instance group is suspending this instance.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    public static final int SUSPENDING_VALUE = 514206246;

    /**
     *
     *
     * <pre>
     * The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
     * </pre>
     *
     * <code>VERIFYING = 16982185;</code>
     */
    public static final int VERIFYING_VALUE = 16982185;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ACTION;
        case 388244813:
          return ABANDONING;
        case 455564985:
          return CREATING;
        case 428843785:
          return CREATING_WITHOUT_RETRIES;
        case 528602024:
          return DELETING;
        case 2402104:
          return NONE;
        case 287278572:
          return RECREATING;
        case 163266343:
          return REFRESHING;
        case 320534387:
          return RESTARTING;
        case 446856618:
          return RESUMING;
        case 488820800:
          return STARTING;
        case 350791796:
          return STOPPING;
        case 514206246:
          return SUSPENDING;
        case 16982185:
          return VERIFYING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.Action)
  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 187661878;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
   * Check the Action enum for the list of possible values.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
   * Check the Action enum for the list of possible values.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
   * Check the Action enum for the list of possible values.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 18257045;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 351608024;
  private com.google.cloud.compute.v1.ManagedInstanceVersion version_;

  /**
   *
   *
   * <pre>
   * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   *
   * @return Whether the version field is set.
   */
  @java.lang.Override
  public boolean hasVersion() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceVersion getVersion() {
    return version_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
        : version_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder getVersionOrBuilder() {
    return version_ == null
        ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
        : version_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18257045, instance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 187661878, action_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(351608024, getVersion());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18257045, instance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(187661878, action_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351608024, getVersion());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails other =
        (com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails) obj;

    if (hasAction() != other.hasAction()) return false;
    if (hasAction()) {
      if (!getAction().equals(other.getAction())) return false;
    }
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (hasVersion() != other.hasVersion()) return false;
    if (hasVersion()) {
      if (!getVersion().equals(other.getVersion())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAction()) {
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAction().hashCode();
    }
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (hasVersion()) {
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails)
      com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceManagedByIgmErrorInstanceActionDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceManagedByIgmErrorInstanceActionDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.class,
              com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = "";
      instance_ = "";
      version_ = null;
      if (versionBuilder_ != null) {
        versionBuilder_.dispose();
        versionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceManagedByIgmErrorInstanceActionDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails build() {
      com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
        buildPartial() {
      com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails result =
          new com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instance_ = instance_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.version_ = versionBuilder_ == null ? version_ : versionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails) {
        return mergeFrom(
            (com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails other) {
      if (other
          == com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
              .getDefaultInstance()) return this;
      if (other.hasAction()) {
        action_ = other.action_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasInstance()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasVersion()) {
        mergeVersion(other.getVersion());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 146056362:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 146056362
            case 1501295026:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1501295026
            case -1482103102:
              {
                input.readMessage(getVersionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1482103102
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object action_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return Whether the action field is set.
     */
    public boolean hasAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
     * Check the Action enum for the list of possible values.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance. The URL can be set even if the instance has not yet been created.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ManagedInstanceVersion version_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceVersion,
            com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
            com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>
        versionBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     *
     * @return Whether the version field is set.
     */
    public boolean hasVersion() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     *
     * @return The version.
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersion getVersion() {
      if (versionBuilder_ == null) {
        return version_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
            : version_;
      } else {
        return versionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder setVersion(com.google.cloud.compute.v1.ManagedInstanceVersion value) {
      if (versionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
      } else {
        versionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder setVersion(
        com.google.cloud.compute.v1.ManagedInstanceVersion.Builder builderForValue) {
      if (versionBuilder_ == null) {
        version_ = builderForValue.build();
      } else {
        versionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder mergeVersion(com.google.cloud.compute.v1.ManagedInstanceVersion value) {
      if (versionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && version_ != null
            && version_
                != com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()) {
          getVersionBuilder().mergeFrom(value);
        } else {
          version_ = value;
        }
      } else {
        versionBuilder_.mergeFrom(value);
      }
      if (version_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000004);
      version_ = null;
      if (versionBuilder_ != null) {
        versionBuilder_.dispose();
        versionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersion.Builder getVersionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getVersionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    public com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder getVersionOrBuilder() {
      if (versionBuilder_ != null) {
        return versionBuilder_.getMessageOrBuilder();
      } else {
        return version_ == null
            ? com.google.cloud.compute.v1.ManagedInstanceVersion.getDefaultInstance()
            : version_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Version this instance was created from, or was being created from, but the creation failed. Corresponds to one of the versions that were set on the Instance Group Manager resource at the time this instance was being created.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ManagedInstanceVersion version = 351608024;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ManagedInstanceVersion,
            com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
            com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>
        getVersionFieldBuilder() {
      if (versionBuilder_ == null) {
        versionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ManagedInstanceVersion,
                com.google.cloud.compute.v1.ManagedInstanceVersion.Builder,
                com.google.cloud.compute.v1.ManagedInstanceVersionOrBuilder>(
                getVersion(), getParentForChildren(), isClean());
        version_ = null;
      }
      return versionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails)
  private static final com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails();
  }

  public static com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceManagedByIgmErrorInstanceActionDetails>
      PARSER =
          new com.google.protobuf.AbstractParser<InstanceManagedByIgmErrorInstanceActionDetails>() {
            @java.lang.Override
            public InstanceManagedByIgmErrorInstanceActionDetails parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<InstanceManagedByIgmErrorInstanceActionDetails>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceManagedByIgmErrorInstanceActionDetails>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceManagedByIgmErrorInstanceActionDetails
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
