/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InstanceWithNamedPorts}
 */
public final class InstanceWithNamedPorts extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InstanceWithNamedPorts)
    InstanceWithNamedPortsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InstanceWithNamedPorts.newBuilder() to construct.
  private InstanceWithNamedPorts(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceWithNamedPorts() {
    instance_ = "";
    namedPorts_ = java.util.Collections.emptyList();
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceWithNamedPorts();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceWithNamedPorts_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceWithNamedPorts_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InstanceWithNamedPorts.class,
            com.google.cloud.compute.v1.InstanceWithNamedPorts.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceWithNamedPorts.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    DEPROVISIONING(428935662),
    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    PROVISIONING(290896621),
    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    REPAIRING(413483285),
    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    RUNNING(121282975),
    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    STAGING(431072283),
    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    STOPPED(444276141),
    /**
     *
     *
     * <pre>
     * The instance is currently stopping (either being deleted or killed).
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    STOPPING(350791796),
    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    SUSPENDED(51223995),
    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    SUSPENDING(514206246),
    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    TERMINATED(250018339),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
     * </pre>
     *
     * <code>DEPROVISIONING = 428935662;</code>
     */
    public static final int DEPROVISIONING_VALUE = 428935662;

    /**
     *
     *
     * <pre>
     * Resources are being allocated for the instance.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    public static final int PROVISIONING_VALUE = 290896621;

    /**
     *
     *
     * <pre>
     * The instance is in repair.
     * </pre>
     *
     * <code>REPAIRING = 413483285;</code>
     */
    public static final int REPAIRING_VALUE = 413483285;

    /**
     *
     *
     * <pre>
     * The instance is running.
     * </pre>
     *
     * <code>RUNNING = 121282975;</code>
     */
    public static final int RUNNING_VALUE = 121282975;

    /**
     *
     *
     * <pre>
     * All required resources have been allocated and the instance is being started.
     * </pre>
     *
     * <code>STAGING = 431072283;</code>
     */
    public static final int STAGING_VALUE = 431072283;

    /**
     *
     *
     * <pre>
     * The instance has stopped successfully.
     * </pre>
     *
     * <code>STOPPED = 444276141;</code>
     */
    public static final int STOPPED_VALUE = 444276141;

    /**
     *
     *
     * <pre>
     * The instance is currently stopping (either being deleted or killed).
     * </pre>
     *
     * <code>STOPPING = 350791796;</code>
     */
    public static final int STOPPING_VALUE = 350791796;

    /**
     *
     *
     * <pre>
     * The instance has suspended.
     * </pre>
     *
     * <code>SUSPENDED = 51223995;</code>
     */
    public static final int SUSPENDED_VALUE = 51223995;

    /**
     *
     *
     * <pre>
     * The instance is suspending.
     * </pre>
     *
     * <code>SUSPENDING = 514206246;</code>
     */
    public static final int SUSPENDING_VALUE = 514206246;

    /**
     *
     *
     * <pre>
     * The instance has stopped (either by explicit action or underlying failure).
     * </pre>
     *
     * <code>TERMINATED = 250018339;</code>
     */
    public static final int TERMINATED_VALUE = 250018339;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 428935662:
          return DEPROVISIONING;
        case 290896621:
          return PROVISIONING;
        case 413483285:
          return REPAIRING;
        case 121282975:
          return RUNNING;
        case 431072283:
          return STAGING;
        case 444276141:
          return STOPPED;
        case 350791796:
          return STOPPING;
        case 51223995:
          return SUSPENDED;
        case 514206246:
          return SUSPENDING;
        case 250018339:
          return TERMINATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceWithNamedPorts.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceWithNamedPorts.Status)
  }

  private int bitField0_;
  public static final int INSTANCE_FIELD_NUMBER = 18257045;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the instance.
   * </pre>
   *
   * <code>optional string instance = 18257045;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMED_PORTS_FIELD_NUMBER = 427598732;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NamedPort> namedPorts_;

  /**
   *
   *
   * <pre>
   * [Output Only] The named ports that belong to this instance group.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NamedPort> getNamedPortsList() {
    return namedPorts_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The named ports that belong to this instance group.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NamedPortOrBuilder>
      getNamedPortsOrBuilderList() {
    return namedPorts_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The named ports that belong to this instance group.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public int getNamedPortsCount() {
    return namedPorts_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The named ports that belong to this instance group.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NamedPort getNamedPorts(int index) {
    return namedPorts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The named ports that belong to this instance group.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NamedPortOrBuilder getNamedPortsOrBuilder(int index) {
    return namedPorts_.get(index);
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18257045, instance_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    for (int i = 0; i < namedPorts_.size(); i++) {
      output.writeMessage(427598732, namedPorts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18257045, instance_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    for (int i = 0; i < namedPorts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(427598732, namedPorts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InstanceWithNamedPorts)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InstanceWithNamedPorts other =
        (com.google.cloud.compute.v1.InstanceWithNamedPorts) obj;

    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (!getNamedPortsList().equals(other.getNamedPortsList())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (getNamedPortsCount() > 0) {
      hash = (37 * hash) + NAMED_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getNamedPortsList().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InstanceWithNamedPorts prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InstanceWithNamedPorts}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InstanceWithNamedPorts)
      com.google.cloud.compute.v1.InstanceWithNamedPortsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceWithNamedPorts_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceWithNamedPorts_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InstanceWithNamedPorts.class,
              com.google.cloud.compute.v1.InstanceWithNamedPorts.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InstanceWithNamedPorts.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instance_ = "";
      if (namedPortsBuilder_ == null) {
        namedPorts_ = java.util.Collections.emptyList();
      } else {
        namedPorts_ = null;
        namedPortsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceWithNamedPorts_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceWithNamedPorts getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InstanceWithNamedPorts.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceWithNamedPorts build() {
      com.google.cloud.compute.v1.InstanceWithNamedPorts result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceWithNamedPorts buildPartial() {
      com.google.cloud.compute.v1.InstanceWithNamedPorts result =
          new com.google.cloud.compute.v1.InstanceWithNamedPorts(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InstanceWithNamedPorts result) {
      if (namedPortsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          namedPorts_ = java.util.Collections.unmodifiableList(namedPorts_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.namedPorts_ = namedPorts_;
      } else {
        result.namedPorts_ = namedPortsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InstanceWithNamedPorts result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instance_ = instance_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InstanceWithNamedPorts) {
        return mergeFrom((com.google.cloud.compute.v1.InstanceWithNamedPorts) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InstanceWithNamedPorts other) {
      if (other == com.google.cloud.compute.v1.InstanceWithNamedPorts.getDefaultInstance())
        return this;
      if (other.hasInstance()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (namedPortsBuilder_ == null) {
        if (!other.namedPorts_.isEmpty()) {
          if (namedPorts_.isEmpty()) {
            namedPorts_ = other.namedPorts_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureNamedPortsIsMutable();
            namedPorts_.addAll(other.namedPorts_);
          }
          onChanged();
        }
      } else {
        if (!other.namedPorts_.isEmpty()) {
          if (namedPortsBuilder_.isEmpty()) {
            namedPortsBuilder_.dispose();
            namedPortsBuilder_ = null;
            namedPorts_ = other.namedPorts_;
            bitField0_ = (bitField0_ & ~0x00000002);
            namedPortsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNamedPortsFieldBuilder()
                    : null;
          } else {
            namedPortsBuilder_.addAllMessages(other.namedPorts_);
          }
        }
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 146056362:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 146056362
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1450082194
            case -874177438:
              {
                com.google.cloud.compute.v1.NamedPort m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NamedPort.parser(), extensionRegistry);
                if (namedPortsBuilder_ == null) {
                  ensureNamedPortsIsMutable();
                  namedPorts_.add(m);
                } else {
                  namedPortsBuilder_.addMessage(m);
                }
                break;
              } // case -874177438
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instance_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return Whether the instance field is set.
     */
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the instance.
     * </pre>
     *
     * <code>optional string instance = 18257045;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NamedPort> namedPorts_ =
        java.util.Collections.emptyList();

    private void ensureNamedPortsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        namedPorts_ = new java.util.ArrayList<com.google.cloud.compute.v1.NamedPort>(namedPorts_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NamedPort,
            com.google.cloud.compute.v1.NamedPort.Builder,
            com.google.cloud.compute.v1.NamedPortOrBuilder>
        namedPortsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NamedPort> getNamedPortsList() {
      if (namedPortsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(namedPorts_);
      } else {
        return namedPortsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public int getNamedPortsCount() {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.size();
      } else {
        return namedPortsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort getNamedPorts(int index) {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.get(index);
      } else {
        return namedPortsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder setNamedPorts(int index, com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.set(index, value);
        onChanged();
      } else {
        namedPortsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder setNamedPorts(
        int index, com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.set(index, builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.add(value);
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(int index, com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.add(index, value);
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.add(builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(
        int index, com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.add(index, builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addAllNamedPorts(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NamedPort> values) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namedPorts_);
        onChanged();
      } else {
        namedPortsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder clearNamedPorts() {
      if (namedPortsBuilder_ == null) {
        namedPorts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        namedPortsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder removeNamedPorts(int index) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.remove(index);
        onChanged();
      } else {
        namedPortsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder getNamedPortsBuilder(int index) {
      return getNamedPortsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPortOrBuilder getNamedPortsOrBuilder(int index) {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.get(index);
      } else {
        return namedPortsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NamedPortOrBuilder>
        getNamedPortsOrBuilderList() {
      if (namedPortsBuilder_ != null) {
        return namedPortsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(namedPorts_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder addNamedPortsBuilder() {
      return getNamedPortsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NamedPort.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder addNamedPortsBuilder(int index) {
      return getNamedPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NamedPort.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The named ports that belong to this instance group.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NamedPort.Builder>
        getNamedPortsBuilderList() {
      return getNamedPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NamedPort,
            com.google.cloud.compute.v1.NamedPort.Builder,
            com.google.cloud.compute.v1.NamedPortOrBuilder>
        getNamedPortsFieldBuilder() {
      if (namedPortsBuilder_ == null) {
        namedPortsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NamedPort,
                com.google.cloud.compute.v1.NamedPort.Builder,
                com.google.cloud.compute.v1.NamedPortOrBuilder>(
                namedPorts_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        namedPorts_ = null;
      }
      return namedPortsBuilder_;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InstanceWithNamedPorts)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InstanceWithNamedPorts)
  private static final com.google.cloud.compute.v1.InstanceWithNamedPorts DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InstanceWithNamedPorts();
  }

  public static com.google.cloud.compute.v1.InstanceWithNamedPorts getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceWithNamedPorts> PARSER =
      new com.google.protobuf.AbstractParser<InstanceWithNamedPorts>() {
        @java.lang.Override
        public InstanceWithNamedPorts parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceWithNamedPorts> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceWithNamedPorts> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceWithNamedPorts getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
