/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus}
 */
public final class InterconnectDiagnosticsLinkStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus)
    InterconnectDiagnosticsLinkStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectDiagnosticsLinkStatus.newBuilder() to construct.
  private InterconnectDiagnosticsLinkStatus(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectDiagnosticsLinkStatus() {
    arpCaches_ = java.util.Collections.emptyList();
    circuitId_ = "";
    googleDemarc_ = "";
    operationalStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectDiagnosticsLinkStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectDiagnosticsLinkStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectDiagnosticsLinkStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.class,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The operational status of the link.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.OperationalStatus}
   */
  public enum OperationalStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    UNDEFINED_OPERATIONAL_STATUS(0),
    /**
     *
     *
     * <pre>
     * The interface is unable to communicate with the remote end.
     * </pre>
     *
     * <code>LINK_OPERATIONAL_STATUS_DOWN = 281653885;</code>
     */
    LINK_OPERATIONAL_STATUS_DOWN(281653885),
    /**
     *
     *
     * <pre>
     * The interface has low level communication with the remote end.
     * </pre>
     *
     * <code>LINK_OPERATIONAL_STATUS_UP = 305879862;</code>
     */
    LINK_OPERATIONAL_STATUS_UP(305879862),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    public static final int UNDEFINED_OPERATIONAL_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The interface is unable to communicate with the remote end.
     * </pre>
     *
     * <code>LINK_OPERATIONAL_STATUS_DOWN = 281653885;</code>
     */
    public static final int LINK_OPERATIONAL_STATUS_DOWN_VALUE = 281653885;

    /**
     *
     *
     * <pre>
     * The interface has low level communication with the remote end.
     * </pre>
     *
     * <code>LINK_OPERATIONAL_STATUS_UP = 305879862;</code>
     */
    public static final int LINK_OPERATIONAL_STATUS_UP_VALUE = 305879862;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationalStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OperationalStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_OPERATIONAL_STATUS;
        case 281653885:
          return LINK_OPERATIONAL_STATUS_DOWN;
        case 305879862:
          return LINK_OPERATIONAL_STATUS_UP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>() {
              public OperationalStatus findValueByNumber(int number) {
                return OperationalStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final OperationalStatus[] VALUES = values();

    public static OperationalStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OperationalStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.OperationalStatus)
  }

  private int bitField0_;
  public static final int ARP_CACHES_FIELD_NUMBER = 414591761;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry> arpCaches_;

  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
      getArpCachesList() {
    return arpCaches_;
  }

  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
      getArpCachesOrBuilderList() {
    return arpCaches_;
  }

  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public int getArpCachesCount() {
    return arpCaches_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry getArpCaches(int index) {
    return arpCaches_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder getArpCachesOrBuilder(
      int index) {
    return arpCaches_.get(index);
  }

  public static final int CIRCUIT_ID_FIELD_NUMBER = 225180977;

  @SuppressWarnings("serial")
  private volatile java.lang.Object circuitId_ = "";

  /**
   *
   *
   * <pre>
   * The unique ID for this link assigned during turn up by Google.
   * </pre>
   *
   * <code>optional string circuit_id = 225180977;</code>
   *
   * @return Whether the circuitId field is set.
   */
  @java.lang.Override
  public boolean hasCircuitId() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The unique ID for this link assigned during turn up by Google.
   * </pre>
   *
   * <code>optional string circuit_id = 225180977;</code>
   *
   * @return The circuitId.
   */
  @java.lang.Override
  public java.lang.String getCircuitId() {
    java.lang.Object ref = circuitId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      circuitId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The unique ID for this link assigned during turn up by Google.
   * </pre>
   *
   * <code>optional string circuit_id = 225180977;</code>
   *
   * @return The bytes for circuitId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCircuitIdBytes() {
    java.lang.Object ref = circuitId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      circuitId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOOGLE_DEMARC_FIELD_NUMBER = 51084;

  @SuppressWarnings("serial")
  private volatile java.lang.Object googleDemarc_ = "";

  /**
   *
   *
   * <pre>
   * The Demarc address assigned by Google and provided in the LoA.
   * </pre>
   *
   * <code>optional string google_demarc = 51084;</code>
   *
   * @return Whether the googleDemarc field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDemarc() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The Demarc address assigned by Google and provided in the LoA.
   * </pre>
   *
   * <code>optional string google_demarc = 51084;</code>
   *
   * @return The googleDemarc.
   */
  @java.lang.Override
  public java.lang.String getGoogleDemarc() {
    java.lang.Object ref = googleDemarc_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      googleDemarc_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Demarc address assigned by Google and provided in the LoA.
   * </pre>
   *
   * <code>optional string google_demarc = 51084;</code>
   *
   * @return The bytes for googleDemarc.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGoogleDemarcBytes() {
    java.lang.Object ref = googleDemarc_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      googleDemarc_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LACP_STATUS_FIELD_NUMBER = 361210415;
  private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacpStatus_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
   * </code>
   *
   * @return Whether the lacpStatus field is set.
   */
  @java.lang.Override
  public boolean hasLacpStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
   * </code>
   *
   * @return The lacpStatus.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus getLacpStatus() {
    return lacpStatus_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.getDefaultInstance()
        : lacpStatus_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatusOrBuilder
      getLacpStatusOrBuilder() {
    return lacpStatus_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.getDefaultInstance()
        : lacpStatus_;
  }

  public static final int MACSEC_FIELD_NUMBER = 528867490;
  private com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec_;

  /**
   *
   *
   * <pre>
   * Describes the status of MACsec encryption on this link.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
   * </code>
   *
   * @return Whether the macsec field is set.
   */
  @java.lang.Override
  public boolean hasMacsec() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Describes the status of MACsec encryption on this link.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
   * </code>
   *
   * @return The macsec.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus getMacsec() {
    return macsec_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.getDefaultInstance()
        : macsec_;
  }

  /**
   *
   *
   * <pre>
   * Describes the status of MACsec encryption on this link.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatusOrBuilder
      getMacsecOrBuilder() {
    return macsec_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.getDefaultInstance()
        : macsec_;
  }

  public static final int OPERATIONAL_STATUS_FIELD_NUMBER = 201070847;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationalStatus_ = "";

  /**
   *
   *
   * <pre>
   * The operational status of the link.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return Whether the operationalStatus field is set.
   */
  @java.lang.Override
  public boolean hasOperationalStatus() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The operational status of the link.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The operationalStatus.
   */
  @java.lang.Override
  public java.lang.String getOperationalStatus() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationalStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The operational status of the link.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The bytes for operationalStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationalStatusBytes() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationalStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECEIVING_OPTICAL_POWER_FIELD_NUMBER = 244717279;
  private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
      receivingOpticalPower_;

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
   * </code>
   *
   * @return Whether the receivingOpticalPower field is set.
   */
  @java.lang.Override
  public boolean hasReceivingOpticalPower() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
   * </code>
   *
   * @return The receivingOpticalPower.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
      getReceivingOpticalPower() {
    return receivingOpticalPower_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.getDefaultInstance()
        : receivingOpticalPower_;
  }

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder
      getReceivingOpticalPowerOrBuilder() {
    return receivingOpticalPower_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.getDefaultInstance()
        : receivingOpticalPower_;
  }

  public static final int TRANSMITTING_OPTICAL_POWER_FIELD_NUMBER = 459431197;
  private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
      transmittingOpticalPower_;

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
   * </code>
   *
   * @return Whether the transmittingOpticalPower field is set.
   */
  @java.lang.Override
  public boolean hasTransmittingOpticalPower() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
   * </code>
   *
   * @return The transmittingOpticalPower.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
      getTransmittingOpticalPower() {
    return transmittingOpticalPower_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.getDefaultInstance()
        : transmittingOpticalPower_;
  }

  /**
   *
   *
   * <pre>
   * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder
      getTransmittingOpticalPowerOrBuilder() {
    return transmittingOpticalPower_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.getDefaultInstance()
        : transmittingOpticalPower_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 51084, googleDemarc_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 225180977, circuitId_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(244717279, getReceivingOpticalPower());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(361210415, getLacpStatus());
    }
    for (int i = 0; i < arpCaches_.size(); i++) {
      output.writeMessage(414591761, arpCaches_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(459431197, getTransmittingOpticalPower());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(528867490, getMacsec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(51084, googleDemarc_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(225180977, circuitId_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              244717279, getReceivingOpticalPower());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(361210415, getLacpStatus());
    }
    for (int i = 0; i < arpCaches_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(414591761, arpCaches_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              459431197, getTransmittingOpticalPower());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(528867490, getMacsec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus other =
        (com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus) obj;

    if (!getArpCachesList().equals(other.getArpCachesList())) return false;
    if (hasCircuitId() != other.hasCircuitId()) return false;
    if (hasCircuitId()) {
      if (!getCircuitId().equals(other.getCircuitId())) return false;
    }
    if (hasGoogleDemarc() != other.hasGoogleDemarc()) return false;
    if (hasGoogleDemarc()) {
      if (!getGoogleDemarc().equals(other.getGoogleDemarc())) return false;
    }
    if (hasLacpStatus() != other.hasLacpStatus()) return false;
    if (hasLacpStatus()) {
      if (!getLacpStatus().equals(other.getLacpStatus())) return false;
    }
    if (hasMacsec() != other.hasMacsec()) return false;
    if (hasMacsec()) {
      if (!getMacsec().equals(other.getMacsec())) return false;
    }
    if (hasOperationalStatus() != other.hasOperationalStatus()) return false;
    if (hasOperationalStatus()) {
      if (!getOperationalStatus().equals(other.getOperationalStatus())) return false;
    }
    if (hasReceivingOpticalPower() != other.hasReceivingOpticalPower()) return false;
    if (hasReceivingOpticalPower()) {
      if (!getReceivingOpticalPower().equals(other.getReceivingOpticalPower())) return false;
    }
    if (hasTransmittingOpticalPower() != other.hasTransmittingOpticalPower()) return false;
    if (hasTransmittingOpticalPower()) {
      if (!getTransmittingOpticalPower().equals(other.getTransmittingOpticalPower())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getArpCachesCount() > 0) {
      hash = (37 * hash) + ARP_CACHES_FIELD_NUMBER;
      hash = (53 * hash) + getArpCachesList().hashCode();
    }
    if (hasCircuitId()) {
      hash = (37 * hash) + CIRCUIT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCircuitId().hashCode();
    }
    if (hasGoogleDemarc()) {
      hash = (37 * hash) + GOOGLE_DEMARC_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleDemarc().hashCode();
    }
    if (hasLacpStatus()) {
      hash = (37 * hash) + LACP_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getLacpStatus().hashCode();
    }
    if (hasMacsec()) {
      hash = (37 * hash) + MACSEC_FIELD_NUMBER;
      hash = (53 * hash) + getMacsec().hashCode();
    }
    if (hasOperationalStatus()) {
      hash = (37 * hash) + OPERATIONAL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getOperationalStatus().hashCode();
    }
    if (hasReceivingOpticalPower()) {
      hash = (37 * hash) + RECEIVING_OPTICAL_POWER_FIELD_NUMBER;
      hash = (53 * hash) + getReceivingOpticalPower().hashCode();
    }
    if (hasTransmittingOpticalPower()) {
      hash = (37 * hash) + TRANSMITTING_OPTICAL_POWER_FIELD_NUMBER;
      hash = (53 * hash) + getTransmittingOpticalPower().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus)
      com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnosticsLinkStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnosticsLinkStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.class,
              com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getArpCachesFieldBuilder();
        getLacpStatusFieldBuilder();
        getMacsecFieldBuilder();
        getReceivingOpticalPowerFieldBuilder();
        getTransmittingOpticalPowerFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (arpCachesBuilder_ == null) {
        arpCaches_ = java.util.Collections.emptyList();
      } else {
        arpCaches_ = null;
        arpCachesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      circuitId_ = "";
      googleDemarc_ = "";
      lacpStatus_ = null;
      if (lacpStatusBuilder_ != null) {
        lacpStatusBuilder_.dispose();
        lacpStatusBuilder_ = null;
      }
      macsec_ = null;
      if (macsecBuilder_ != null) {
        macsecBuilder_.dispose();
        macsecBuilder_ = null;
      }
      operationalStatus_ = "";
      receivingOpticalPower_ = null;
      if (receivingOpticalPowerBuilder_ != null) {
        receivingOpticalPowerBuilder_.dispose();
        receivingOpticalPowerBuilder_ = null;
      }
      transmittingOpticalPower_ = null;
      if (transmittingOpticalPowerBuilder_ != null) {
        transmittingOpticalPowerBuilder_.dispose();
        transmittingOpticalPowerBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectDiagnosticsLinkStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus build() {
      com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus buildPartial() {
      com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus result =
          new com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus result) {
      if (arpCachesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          arpCaches_ = java.util.Collections.unmodifiableList(arpCaches_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.arpCaches_ = arpCaches_;
      } else {
        result.arpCaches_ = arpCachesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.circuitId_ = circuitId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.googleDemarc_ = googleDemarc_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lacpStatus_ = lacpStatusBuilder_ == null ? lacpStatus_ : lacpStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.macsec_ = macsecBuilder_ == null ? macsec_ : macsecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.operationalStatus_ = operationalStatus_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.receivingOpticalPower_ =
            receivingOpticalPowerBuilder_ == null
                ? receivingOpticalPower_
                : receivingOpticalPowerBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.transmittingOpticalPower_ =
            transmittingOpticalPowerBuilder_ == null
                ? transmittingOpticalPower_
                : transmittingOpticalPowerBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus.getDefaultInstance())
        return this;
      if (arpCachesBuilder_ == null) {
        if (!other.arpCaches_.isEmpty()) {
          if (arpCaches_.isEmpty()) {
            arpCaches_ = other.arpCaches_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureArpCachesIsMutable();
            arpCaches_.addAll(other.arpCaches_);
          }
          onChanged();
        }
      } else {
        if (!other.arpCaches_.isEmpty()) {
          if (arpCachesBuilder_.isEmpty()) {
            arpCachesBuilder_.dispose();
            arpCachesBuilder_ = null;
            arpCaches_ = other.arpCaches_;
            bitField0_ = (bitField0_ & ~0x00000001);
            arpCachesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getArpCachesFieldBuilder()
                    : null;
          } else {
            arpCachesBuilder_.addAllMessages(other.arpCaches_);
          }
        }
      }
      if (other.hasCircuitId()) {
        circuitId_ = other.circuitId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasGoogleDemarc()) {
        googleDemarc_ = other.googleDemarc_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasLacpStatus()) {
        mergeLacpStatus(other.getLacpStatus());
      }
      if (other.hasMacsec()) {
        mergeMacsec(other.getMacsec());
      }
      if (other.hasOperationalStatus()) {
        operationalStatus_ = other.operationalStatus_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasReceivingOpticalPower()) {
        mergeReceivingOpticalPower(other.getReceivingOpticalPower());
      }
      if (other.hasTransmittingOpticalPower()) {
        mergeTransmittingOpticalPower(other.getTransmittingOpticalPower());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 408674:
              {
                googleDemarc_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 408674
            case 1608566778:
              {
                operationalStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1608566778
            case 1801447818:
              {
                circuitId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1801447818
            case 1957738234:
              {
                input.readMessage(
                    getReceivingOpticalPowerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 1957738234
            case -1405283974:
              {
                input.readMessage(getLacpStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -1405283974
            case -978233206:
              {
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.parser(),
                        extensionRegistry);
                if (arpCachesBuilder_ == null) {
                  ensureArpCachesIsMutable();
                  arpCaches_.add(m);
                } else {
                  arpCachesBuilder_.addMessage(m);
                }
                break;
              } // case -978233206
            case -619517718:
              {
                input.readMessage(
                    getTransmittingOpticalPowerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -619517718
            case -64027374:
              {
                input.readMessage(getMacsecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -64027374
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry> arpCaches_ =
        java.util.Collections.emptyList();

    private void ensureArpCachesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        arpCaches_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>(
                arpCaches_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        arpCachesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
        getArpCachesList() {
      if (arpCachesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(arpCaches_);
      } else {
        return arpCachesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public int getArpCachesCount() {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.size();
      } else {
        return arpCachesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry getArpCaches(int index) {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.get(index);
      } else {
        return arpCachesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder setArpCaches(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.set(index, value);
        onChanged();
      } else {
        arpCachesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder setArpCaches(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.set(index, builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.add(value);
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        int index, com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry value) {
      if (arpCachesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArpCachesIsMutable();
        arpCaches_.add(index, value);
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.add(builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addArpCaches(
        int index,
        com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder builderForValue) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.add(index, builderForValue.build());
        onChanged();
      } else {
        arpCachesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder addAllArpCaches(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry>
            values) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, arpCaches_);
        onChanged();
      } else {
        arpCachesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder clearArpCaches() {
      if (arpCachesBuilder_ == null) {
        arpCaches_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        arpCachesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public Builder removeArpCaches(int index) {
      if (arpCachesBuilder_ == null) {
        ensureArpCachesIsMutable();
        arpCaches_.remove(index);
        onChanged();
      } else {
        arpCachesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder getArpCachesBuilder(
        int index) {
      return getArpCachesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder
        getArpCachesOrBuilder(int index) {
      if (arpCachesBuilder_ == null) {
        return arpCaches_.get(index);
      } else {
        return arpCachesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        getArpCachesOrBuilderList() {
      if (arpCachesBuilder_ != null) {
        return arpCachesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(arpCaches_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder
        addArpCachesBuilder() {
      return getArpCachesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder addArpCachesBuilder(
        int index) {
      return getArpCachesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP neighbor entries seen on this link. This will be empty if the link is bundled
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectDiagnosticsARPEntry arp_caches = 414591761;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder>
        getArpCachesBuilderList() {
      return getArpCachesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>
        getArpCachesFieldBuilder() {
      if (arpCachesBuilder_ == null) {
        arpCachesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry,
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntryOrBuilder>(
                arpCaches_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        arpCaches_ = null;
      }
      return arpCachesBuilder_;
    }

    private java.lang.Object circuitId_ = "";

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @return Whether the circuitId field is set.
     */
    public boolean hasCircuitId() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @return The circuitId.
     */
    public java.lang.String getCircuitId() {
      java.lang.Object ref = circuitId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        circuitId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @return The bytes for circuitId.
     */
    public com.google.protobuf.ByteString getCircuitIdBytes() {
      java.lang.Object ref = circuitId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        circuitId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @param value The circuitId to set.
     * @return This builder for chaining.
     */
    public Builder setCircuitId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      circuitId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCircuitId() {
      circuitId_ = getDefaultInstance().getCircuitId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique ID for this link assigned during turn up by Google.
     * </pre>
     *
     * <code>optional string circuit_id = 225180977;</code>
     *
     * @param value The bytes for circuitId to set.
     * @return This builder for chaining.
     */
    public Builder setCircuitIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      circuitId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object googleDemarc_ = "";

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @return Whether the googleDemarc field is set.
     */
    public boolean hasGoogleDemarc() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @return The googleDemarc.
     */
    public java.lang.String getGoogleDemarc() {
      java.lang.Object ref = googleDemarc_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        googleDemarc_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @return The bytes for googleDemarc.
     */
    public com.google.protobuf.ByteString getGoogleDemarcBytes() {
      java.lang.Object ref = googleDemarc_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        googleDemarc_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @param value The googleDemarc to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleDemarc(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      googleDemarc_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleDemarc() {
      googleDemarc_ = getDefaultInstance().getGoogleDemarc();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Demarc address assigned by Google and provided in the LoA.
     * </pre>
     *
     * <code>optional string google_demarc = 51084;</code>
     *
     * @param value The bytes for googleDemarc to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleDemarcBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      googleDemarc_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacpStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatusOrBuilder>
        lacpStatusBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     *
     * @return Whether the lacpStatus field is set.
     */
    public boolean hasLacpStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     *
     * @return The lacpStatus.
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus getLacpStatus() {
      if (lacpStatusBuilder_ == null) {
        return lacpStatus_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.getDefaultInstance()
            : lacpStatus_;
      } else {
        return lacpStatusBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public Builder setLacpStatus(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus value) {
      if (lacpStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lacpStatus_ = value;
      } else {
        lacpStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public Builder setLacpStatus(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.Builder builderForValue) {
      if (lacpStatusBuilder_ == null) {
        lacpStatus_ = builderForValue.build();
      } else {
        lacpStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public Builder mergeLacpStatus(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus value) {
      if (lacpStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lacpStatus_ != null
            && lacpStatus_
                != com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus
                    .getDefaultInstance()) {
          getLacpStatusBuilder().mergeFrom(value);
        } else {
          lacpStatus_ = value;
        }
      } else {
        lacpStatusBuilder_.mergeFrom(value);
      }
      if (lacpStatus_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public Builder clearLacpStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lacpStatus_ = null;
      if (lacpStatusBuilder_ != null) {
        lacpStatusBuilder_.dispose();
        lacpStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.Builder
        getLacpStatusBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLacpStatusFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatusOrBuilder
        getLacpStatusOrBuilder() {
      if (lacpStatusBuilder_ != null) {
        return lacpStatusBuilder_.getMessageOrBuilder();
      } else {
        return lacpStatus_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.getDefaultInstance()
            : lacpStatus_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus lacp_status = 361210415;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatusOrBuilder>
        getLacpStatusFieldBuilder() {
      if (lacpStatusBuilder_ == null) {
        lacpStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatusOrBuilder>(
                getLacpStatus(), getParentForChildren(), isClean());
        lacpStatus_ = null;
      }
      return lacpStatusBuilder_;
    }

    private com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatusOrBuilder>
        macsecBuilder_;

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     *
     * @return Whether the macsec field is set.
     */
    public boolean hasMacsec() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     *
     * @return The macsec.
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus getMacsec() {
      if (macsecBuilder_ == null) {
        return macsec_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.getDefaultInstance()
            : macsec_;
      } else {
        return macsecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public Builder setMacsec(
        com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus value) {
      if (macsecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        macsec_ = value;
      } else {
        macsecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public Builder setMacsec(
        com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.Builder builderForValue) {
      if (macsecBuilder_ == null) {
        macsec_ = builderForValue.build();
      } else {
        macsecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public Builder mergeMacsec(
        com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus value) {
      if (macsecBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && macsec_ != null
            && macsec_
                != com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus
                    .getDefaultInstance()) {
          getMacsecBuilder().mergeFrom(value);
        } else {
          macsec_ = value;
        }
      } else {
        macsecBuilder_.mergeFrom(value);
      }
      if (macsec_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public Builder clearMacsec() {
      bitField0_ = (bitField0_ & ~0x00000010);
      macsec_ = null;
      if (macsecBuilder_ != null) {
        macsecBuilder_.dispose();
        macsecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.Builder
        getMacsecBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMacsecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatusOrBuilder
        getMacsecOrBuilder() {
      if (macsecBuilder_ != null) {
        return macsecBuilder_.getMessageOrBuilder();
      } else {
        return macsec_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.getDefaultInstance()
            : macsec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Describes the status of MACsec encryption on this link.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus macsec = 528867490;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus,
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatusOrBuilder>
        getMacsecFieldBuilder() {
      if (macsecBuilder_ == null) {
        macsecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus,
                com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatus.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsMacsecStatusOrBuilder>(
                getMacsec(), getParentForChildren(), isClean());
        macsec_ = null;
      }
      return macsecBuilder_;
    }

    private java.lang.Object operationalStatus_ = "";

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return Whether the operationalStatus field is set.
     */
    public boolean hasOperationalStatus() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The operationalStatus.
     */
    public java.lang.String getOperationalStatus() {
      java.lang.Object ref = operationalStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationalStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The bytes for operationalStatus.
     */
    public com.google.protobuf.ByteString getOperationalStatusBytes() {
      java.lang.Object ref = operationalStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationalStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationalStatus_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationalStatus() {
      operationalStatus_ = getDefaultInstance().getOperationalStatus();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The operational status of the link.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The bytes for operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationalStatus_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
        receivingOpticalPower_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>
        receivingOpticalPowerBuilder_;

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     *
     * @return Whether the receivingOpticalPower field is set.
     */
    public boolean hasReceivingOpticalPower() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     *
     * @return The receivingOpticalPower.
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
        getReceivingOpticalPower() {
      if (receivingOpticalPowerBuilder_ == null) {
        return receivingOpticalPower_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                .getDefaultInstance()
            : receivingOpticalPower_;
      } else {
        return receivingOpticalPowerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public Builder setReceivingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower value) {
      if (receivingOpticalPowerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        receivingOpticalPower_ = value;
      } else {
        receivingOpticalPowerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public Builder setReceivingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder
            builderForValue) {
      if (receivingOpticalPowerBuilder_ == null) {
        receivingOpticalPower_ = builderForValue.build();
      } else {
        receivingOpticalPowerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public Builder mergeReceivingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower value) {
      if (receivingOpticalPowerBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && receivingOpticalPower_ != null
            && receivingOpticalPower_
                != com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                    .getDefaultInstance()) {
          getReceivingOpticalPowerBuilder().mergeFrom(value);
        } else {
          receivingOpticalPower_ = value;
        }
      } else {
        receivingOpticalPowerBuilder_.mergeFrom(value);
      }
      if (receivingOpticalPower_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public Builder clearReceivingOpticalPower() {
      bitField0_ = (bitField0_ & ~0x00000040);
      receivingOpticalPower_ = null;
      if (receivingOpticalPowerBuilder_ != null) {
        receivingOpticalPowerBuilder_.dispose();
        receivingOpticalPowerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder
        getReceivingOpticalPowerBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getReceivingOpticalPowerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder
        getReceivingOpticalPowerOrBuilder() {
      if (receivingOpticalPowerBuilder_ != null) {
        return receivingOpticalPowerBuilder_.getMessageOrBuilder();
      } else {
        return receivingOpticalPower_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                .getDefaultInstance()
            : receivingOpticalPower_;
      }
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the received light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower receiving_optical_power = 244717279;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>
        getReceivingOpticalPowerFieldBuilder() {
      if (receivingOpticalPowerBuilder_ == null) {
        receivingOpticalPowerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>(
                getReceivingOpticalPower(), getParentForChildren(), isClean());
        receivingOpticalPower_ = null;
      }
      return receivingOpticalPowerBuilder_;
    }

    private com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
        transmittingOpticalPower_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>
        transmittingOpticalPowerBuilder_;

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     *
     * @return Whether the transmittingOpticalPower field is set.
     */
    public boolean hasTransmittingOpticalPower() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     *
     * @return The transmittingOpticalPower.
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
        getTransmittingOpticalPower() {
      if (transmittingOpticalPowerBuilder_ == null) {
        return transmittingOpticalPower_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                .getDefaultInstance()
            : transmittingOpticalPower_;
      } else {
        return transmittingOpticalPowerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public Builder setTransmittingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower value) {
      if (transmittingOpticalPowerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transmittingOpticalPower_ = value;
      } else {
        transmittingOpticalPowerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public Builder setTransmittingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder
            builderForValue) {
      if (transmittingOpticalPowerBuilder_ == null) {
        transmittingOpticalPower_ = builderForValue.build();
      } else {
        transmittingOpticalPowerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public Builder mergeTransmittingOpticalPower(
        com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower value) {
      if (transmittingOpticalPowerBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && transmittingOpticalPower_ != null
            && transmittingOpticalPower_
                != com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                    .getDefaultInstance()) {
          getTransmittingOpticalPowerBuilder().mergeFrom(value);
        } else {
          transmittingOpticalPower_ = value;
        }
      } else {
        transmittingOpticalPowerBuilder_.mergeFrom(value);
      }
      if (transmittingOpticalPower_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public Builder clearTransmittingOpticalPower() {
      bitField0_ = (bitField0_ & ~0x00000080);
      transmittingOpticalPower_ = null;
      if (transmittingOpticalPowerBuilder_ != null) {
        transmittingOpticalPowerBuilder_.dispose();
        transmittingOpticalPowerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder
        getTransmittingOpticalPowerBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getTransmittingOpticalPowerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder
        getTransmittingOpticalPowerOrBuilder() {
      if (transmittingOpticalPowerBuilder_ != null) {
        return transmittingOpticalPowerBuilder_.getMessageOrBuilder();
      } else {
        return transmittingOpticalPower_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower
                .getDefaultInstance()
            : transmittingOpticalPower_;
      }
    }

    /**
     *
     *
     * <pre>
     * An InterconnectDiagnostics.LinkOpticalPower object, describing the current value and status of the transmitted light level.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower transmitting_optical_power = 459431197;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>
        getTransmittingOpticalPowerFieldBuilder() {
      if (transmittingOpticalPowerBuilder_ == null) {
        transmittingOpticalPowerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPowerOrBuilder>(
                getTransmittingOpticalPower(), getParentForChildren(), isClean());
        transmittingOpticalPower_ = null;
      }
      return transmittingOpticalPowerBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus)
  private static final com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus();
  }

  public static com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectDiagnosticsLinkStatus> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectDiagnosticsLinkStatus>() {
        @java.lang.Override
        public InterconnectDiagnosticsLinkStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectDiagnosticsLinkStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectDiagnosticsLinkStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsLinkStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
