/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Cross-Cloud Interconnect Remote Location resource. You can use this resource to find remote location details about an Interconnect attachment (VLAN).
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectRemoteLocation}
 */
public final class InterconnectRemoteLocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectRemoteLocation)
    InterconnectRemoteLocationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectRemoteLocation.newBuilder() to construct.
  private InterconnectRemoteLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectRemoteLocation() {
    address_ = "";
    city_ = "";
    continent_ = "";
    creationTimestamp_ = "";
    description_ = "";
    facilityProvider_ = "";
    facilityProviderFacilityId_ = "";
    kind_ = "";
    lacp_ = "";
    name_ = "";
    peeringdbFacilityId_ = "";
    permittedConnections_ = java.util.Collections.emptyList();
    remoteService_ = "";
    selfLink_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectRemoteLocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectRemoteLocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectRemoteLocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectRemoteLocation.class,
            com.google.cloud.compute.v1.InterconnectRemoteLocation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectRemoteLocation.Continent}
   */
  public enum Continent implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONTINENT = 0;</code>
     */
    UNDEFINED_CONTINENT(0),
    /** <code>AFRICA = 317443706;</code> */
    AFRICA(317443706),
    /** <code>ASIA_PAC = 119782269;</code> */
    ASIA_PAC(119782269),
    /** <code>EUROPE = 445819298;</code> */
    EUROPE(445819298),
    /** <code>NORTH_AMERICA = 448015508;</code> */
    NORTH_AMERICA(448015508),
    /** <code>SOUTH_AMERICA = 32597340;</code> */
    SOUTH_AMERICA(32597340),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CONTINENT = 0;</code>
     */
    public static final int UNDEFINED_CONTINENT_VALUE = 0;

    /** <code>AFRICA = 317443706;</code> */
    public static final int AFRICA_VALUE = 317443706;

    /** <code>ASIA_PAC = 119782269;</code> */
    public static final int ASIA_PAC_VALUE = 119782269;

    /** <code>EUROPE = 445819298;</code> */
    public static final int EUROPE_VALUE = 445819298;

    /** <code>NORTH_AMERICA = 448015508;</code> */
    public static final int NORTH_AMERICA_VALUE = 448015508;

    /** <code>SOUTH_AMERICA = 32597340;</code> */
    public static final int SOUTH_AMERICA_VALUE = 32597340;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Continent valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Continent forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CONTINENT;
        case 317443706:
          return AFRICA;
        case 119782269:
          return ASIA_PAC;
        case 445819298:
          return EUROPE;
        case 448015508:
          return NORTH_AMERICA;
        case 32597340:
          return SOUTH_AMERICA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Continent> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Continent> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Continent>() {
          public Continent findValueByNumber(int number) {
            return Continent.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Continent[] VALUES = values();

    public static Continent valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Continent(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectRemoteLocation.Continent)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectRemoteLocation.Lacp}
   */
  public enum Lacp implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LACP = 0;</code>
     */
    UNDEFINED_LACP(0),
    /**
     *
     *
     * <pre>
     * LACP_SUPPORTED: LACP is supported, and enabled by default on the Cross-Cloud Interconnect.
     * </pre>
     *
     * <code>LACP_SUPPORTED = 339576113;</code>
     */
    LACP_SUPPORTED(339576113),
    /**
     *
     *
     * <pre>
     * LACP_UNSUPPORTED: LACP is not supported and is not be enabled on this port. GetDiagnostics shows bundleAggregationType as "static". GCP does not support LAGs without LACP, so requestedLinkCount must be 1.
     * </pre>
     *
     * <code>LACP_UNSUPPORTED = 203930104;</code>
     */
    LACP_UNSUPPORTED(203930104),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LACP = 0;</code>
     */
    public static final int UNDEFINED_LACP_VALUE = 0;

    /**
     *
     *
     * <pre>
     * LACP_SUPPORTED: LACP is supported, and enabled by default on the Cross-Cloud Interconnect.
     * </pre>
     *
     * <code>LACP_SUPPORTED = 339576113;</code>
     */
    public static final int LACP_SUPPORTED_VALUE = 339576113;

    /**
     *
     *
     * <pre>
     * LACP_UNSUPPORTED: LACP is not supported and is not be enabled on this port. GetDiagnostics shows bundleAggregationType as "static". GCP does not support LAGs without LACP, so requestedLinkCount must be 1.
     * </pre>
     *
     * <code>LACP_UNSUPPORTED = 203930104;</code>
     */
    public static final int LACP_UNSUPPORTED_VALUE = 203930104;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Lacp valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Lacp forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LACP;
        case 339576113:
          return LACP_SUPPORTED;
        case 203930104:
          return LACP_UNSUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Lacp> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Lacp> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Lacp>() {
          public Lacp findValueByNumber(int number) {
            return Lacp.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocation.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Lacp[] VALUES = values();

    public static Lacp valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Lacp(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectRemoteLocation.Lacp)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InterconnectRemoteLocation.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * </pre>
     *
     * <code>AVAILABLE = 442079913;</code>
     */
    AVAILABLE(442079913),
    /**
     *
     *
     * <pre>
     * The InterconnectRemoteLocation is closed for provisioning new Cross-Cloud Interconnects.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    CLOSED(380163436),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * </pre>
     *
     * <code>AVAILABLE = 442079913;</code>
     */
    public static final int AVAILABLE_VALUE = 442079913;

    /**
     *
     *
     * <pre>
     * The InterconnectRemoteLocation is closed for provisioning new Cross-Cloud Interconnects.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    public static final int CLOSED_VALUE = 380163436;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 442079913:
          return AVAILABLE;
        case 380163436:
          return CLOSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocation.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectRemoteLocation.Status)
  }

  private int bitField0_;
  public static final int ADDRESS_FIELD_NUMBER = 462920692;

  @SuppressWarnings("serial")
  private volatile java.lang.Object address_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return Whether the address field is set.
   */
  @java.lang.Override
  public boolean hasAddress() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public java.lang.String getAddress() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      address_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
   * </pre>
   *
   * <code>optional string address = 462920692;</code>
   *
   * @return The bytes for address.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAddressBytes() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      address_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTACHMENT_CONFIGURATION_CONSTRAINTS_FIELD_NUMBER = 326825041;
  private com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      attachmentConfigurationConstraints_;

  /**
   *
   *
   * <pre>
   * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
   * </code>
   *
   * @return Whether the attachmentConfigurationConstraints field is set.
   */
  @java.lang.Override
  public boolean hasAttachmentConfigurationConstraints() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
   * </code>
   *
   * @return The attachmentConfigurationConstraints.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
      getAttachmentConfigurationConstraints() {
    return attachmentConfigurationConstraints_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
            .getDefaultInstance()
        : attachmentConfigurationConstraints_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder
      getAttachmentConfigurationConstraintsOrBuilder() {
    return attachmentConfigurationConstraints_ == null
        ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
            .getDefaultInstance()
        : attachmentConfigurationConstraints_;
  }

  public static final int CITY_FIELD_NUMBER = 3053931;

  @SuppressWarnings("serial")
  private volatile java.lang.Object city_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return Whether the city field is set.
   */
  @java.lang.Override
  public boolean hasCity() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return The city.
   */
  @java.lang.Override
  public java.lang.String getCity() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      city_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
   * </pre>
   *
   * <code>optional string city = 3053931;</code>
   *
   * @return The bytes for city.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCityBytes() {
    java.lang.Object ref = city_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      city_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSTRAINTS_FIELD_NUMBER = 3909174;
  private com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints_;

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
   * </code>
   *
   * @return Whether the constraints field is set.
   */
  @java.lang.Override
  public boolean hasConstraints() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
   * </code>
   *
   * @return The constraints.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints getConstraints() {
    return constraints_ == null
        ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance()
        : constraints_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder
      getConstraintsOrBuilder() {
    return constraints_ == null
        ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance()
        : constraints_;
  }

  public static final int CONTINENT_FIELD_NUMBER = 133442996;

  @SuppressWarnings("serial")
  private volatile java.lang.Object continent_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return Whether the continent field is set.
   */
  @java.lang.Override
  public boolean hasContinent() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return The continent.
   */
  @java.lang.Override
  public java.lang.String getContinent() {
    java.lang.Object ref = continent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      continent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
   * Check the Continent enum for the list of possible values.
   * </pre>
   *
   * <code>optional string continent = 133442996;</code>
   *
   * @return The bytes for continent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContinentBytes() {
    java.lang.Object ref = continent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      continent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITY_PROVIDER_FIELD_NUMBER = 533303309;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facilityProvider_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return Whether the facilityProvider field is set.
   */
  @java.lang.Override
  public boolean hasFacilityProvider() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return The facilityProvider.
   */
  @java.lang.Override
  public java.lang.String getFacilityProvider() {
    java.lang.Object ref = facilityProvider_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facilityProvider_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
   * </pre>
   *
   * <code>optional string facility_provider = 533303309;</code>
   *
   * @return The bytes for facilityProvider.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacilityProviderBytes() {
    java.lang.Object ref = facilityProvider_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facilityProvider_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACILITY_PROVIDER_FACILITY_ID_FIELD_NUMBER = 87269125;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facilityProviderFacilityId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return Whether the facilityProviderFacilityId field is set.
   */
  @java.lang.Override
  public boolean hasFacilityProviderFacilityId() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return The facilityProviderFacilityId.
   */
  @java.lang.Override
  public java.lang.String getFacilityProviderFacilityId() {
    java.lang.Object ref = facilityProviderFacilityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facilityProviderFacilityId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
   * </pre>
   *
   * <code>optional string facility_provider_facility_id = 87269125;</code>
   *
   * @return The bytes for facilityProviderFacilityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacilityProviderFacilityIdBytes() {
    java.lang.Object ref = facilityProviderFacilityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facilityProviderFacilityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LACP_FIELD_NUMBER = 3313826;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lacp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
   * Check the Lacp enum for the list of possible values.
   * </pre>
   *
   * <code>optional string lacp = 3313826;</code>
   *
   * @return Whether the lacp field is set.
   */
  @java.lang.Override
  public boolean hasLacp() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
   * Check the Lacp enum for the list of possible values.
   * </pre>
   *
   * <code>optional string lacp = 3313826;</code>
   *
   * @return The lacp.
   */
  @java.lang.Override
  public java.lang.String getLacp() {
    java.lang.Object ref = lacp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lacp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
   * Check the Lacp enum for the list of possible values.
   * </pre>
   *
   * <code>optional string lacp = 3313826;</code>
   *
   * @return The bytes for lacp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLacpBytes() {
    java.lang.Object ref = lacp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lacp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_LAG_SIZE100_GBPS_FIELD_NUMBER = 245219253;
  private int maxLagSize100Gbps_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
   * </pre>
   *
   * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
   *
   * @return Whether the maxLagSize100Gbps field is set.
   */
  @java.lang.Override
  public boolean hasMaxLagSize100Gbps() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
   * </pre>
   *
   * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
   *
   * @return The maxLagSize100Gbps.
   */
  @java.lang.Override
  public int getMaxLagSize100Gbps() {
    return maxLagSize100Gbps_;
  }

  public static final int MAX_LAG_SIZE10_GBPS_FIELD_NUMBER = 294007573;
  private int maxLagSize10Gbps_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
   * </pre>
   *
   * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
   *
   * @return Whether the maxLagSize10Gbps field is set.
   */
  @java.lang.Override
  public boolean hasMaxLagSize10Gbps() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
   * </pre>
   *
   * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
   *
   * @return The maxLagSize10Gbps.
   */
  @java.lang.Override
  public int getMaxLagSize10Gbps() {
    return maxLagSize10Gbps_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEERINGDB_FACILITY_ID_FIELD_NUMBER = 536567094;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peeringdbFacilityId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return Whether the peeringdbFacilityId field is set.
   */
  @java.lang.Override
  public boolean hasPeeringdbFacilityId() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return The peeringdbFacilityId.
   */
  @java.lang.Override
  public java.lang.String getPeeringdbFacilityId() {
    java.lang.Object ref = peeringdbFacilityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peeringdbFacilityId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
   * </pre>
   *
   * <code>optional string peeringdb_facility_id = 536567094;</code>
   *
   * @return The bytes for peeringdbFacilityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeeringdbFacilityIdBytes() {
    java.lang.Object ref = peeringdbFacilityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peeringdbFacilityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERMITTED_CONNECTIONS_FIELD_NUMBER = 442063278;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>
      permittedConnections_;

  /**
   *
   *
   * <pre>
   * [Output Only] Permitted connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>
      getPermittedConnectionsList() {
    return permittedConnections_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Permitted connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder>
      getPermittedConnectionsOrBuilderList() {
    return permittedConnections_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Permitted connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
   * </code>
   */
  @java.lang.Override
  public int getPermittedConnectionsCount() {
    return permittedConnections_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Permitted connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections
      getPermittedConnections(int index) {
    return permittedConnections_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Permitted connections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder
      getPermittedConnectionsOrBuilder(int index) {
    return permittedConnections_.get(index);
  }

  public static final int REMOTE_SERVICE_FIELD_NUMBER = 391954364;

  @SuppressWarnings("serial")
  private volatile java.lang.Object remoteService_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return Whether the remoteService field is set.
   */
  @java.lang.Override
  public boolean hasRemoteService() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The remoteService.
   */
  @java.lang.Override
  public java.lang.String getRemoteService() {
    java.lang.Object ref = remoteService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      remoteService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
   * </pre>
   *
   * <code>optional string remote_service = 391954364;</code>
   *
   * @return The bytes for remoteService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRemoteServiceBytes() {
    java.lang.Object ref = remoteService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      remoteService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3053931, city_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3313826, lacp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(3909174, getConstraints());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 87269125, facilityProviderFacilityId_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 133442996, continent_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeInt32(245219253, maxLagSize100Gbps_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(294007573, maxLagSize10Gbps_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(326825041, getAttachmentConfigurationConstraints());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 391954364, remoteService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < permittedConnections_.size(); i++) {
      output.writeMessage(442063278, permittedConnections_.get(i));
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 462920692, address_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 533303309, facilityProvider_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 536567094, peeringdbFacilityId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3053931, city_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3313826, lacp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3909174, getConstraints());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              87269125, facilityProviderFacilityId_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(133442996, continent_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(245219253, maxLagSize100Gbps_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(294007573, maxLagSize10Gbps_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              326825041, getAttachmentConfigurationConstraints());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(391954364, remoteService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < permittedConnections_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              442063278, permittedConnections_.get(i));
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(462920692, address_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(533303309, facilityProvider_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(536567094, peeringdbFacilityId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectRemoteLocation)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectRemoteLocation other =
        (com.google.cloud.compute.v1.InterconnectRemoteLocation) obj;

    if (hasAddress() != other.hasAddress()) return false;
    if (hasAddress()) {
      if (!getAddress().equals(other.getAddress())) return false;
    }
    if (hasAttachmentConfigurationConstraints() != other.hasAttachmentConfigurationConstraints())
      return false;
    if (hasAttachmentConfigurationConstraints()) {
      if (!getAttachmentConfigurationConstraints()
          .equals(other.getAttachmentConfigurationConstraints())) return false;
    }
    if (hasCity() != other.hasCity()) return false;
    if (hasCity()) {
      if (!getCity().equals(other.getCity())) return false;
    }
    if (hasConstraints() != other.hasConstraints()) return false;
    if (hasConstraints()) {
      if (!getConstraints().equals(other.getConstraints())) return false;
    }
    if (hasContinent() != other.hasContinent()) return false;
    if (hasContinent()) {
      if (!getContinent().equals(other.getContinent())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFacilityProvider() != other.hasFacilityProvider()) return false;
    if (hasFacilityProvider()) {
      if (!getFacilityProvider().equals(other.getFacilityProvider())) return false;
    }
    if (hasFacilityProviderFacilityId() != other.hasFacilityProviderFacilityId()) return false;
    if (hasFacilityProviderFacilityId()) {
      if (!getFacilityProviderFacilityId().equals(other.getFacilityProviderFacilityId()))
        return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLacp() != other.hasLacp()) return false;
    if (hasLacp()) {
      if (!getLacp().equals(other.getLacp())) return false;
    }
    if (hasMaxLagSize100Gbps() != other.hasMaxLagSize100Gbps()) return false;
    if (hasMaxLagSize100Gbps()) {
      if (getMaxLagSize100Gbps() != other.getMaxLagSize100Gbps()) return false;
    }
    if (hasMaxLagSize10Gbps() != other.hasMaxLagSize10Gbps()) return false;
    if (hasMaxLagSize10Gbps()) {
      if (getMaxLagSize10Gbps() != other.getMaxLagSize10Gbps()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPeeringdbFacilityId() != other.hasPeeringdbFacilityId()) return false;
    if (hasPeeringdbFacilityId()) {
      if (!getPeeringdbFacilityId().equals(other.getPeeringdbFacilityId())) return false;
    }
    if (!getPermittedConnectionsList().equals(other.getPermittedConnectionsList())) return false;
    if (hasRemoteService() != other.hasRemoteService()) return false;
    if (hasRemoteService()) {
      if (!getRemoteService().equals(other.getRemoteService())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAddress()) {
      hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getAddress().hashCode();
    }
    if (hasAttachmentConfigurationConstraints()) {
      hash = (37 * hash) + ATTACHMENT_CONFIGURATION_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getAttachmentConfigurationConstraints().hashCode();
    }
    if (hasCity()) {
      hash = (37 * hash) + CITY_FIELD_NUMBER;
      hash = (53 * hash) + getCity().hashCode();
    }
    if (hasConstraints()) {
      hash = (37 * hash) + CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraints().hashCode();
    }
    if (hasContinent()) {
      hash = (37 * hash) + CONTINENT_FIELD_NUMBER;
      hash = (53 * hash) + getContinent().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFacilityProvider()) {
      hash = (37 * hash) + FACILITY_PROVIDER_FIELD_NUMBER;
      hash = (53 * hash) + getFacilityProvider().hashCode();
    }
    if (hasFacilityProviderFacilityId()) {
      hash = (37 * hash) + FACILITY_PROVIDER_FACILITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getFacilityProviderFacilityId().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLacp()) {
      hash = (37 * hash) + LACP_FIELD_NUMBER;
      hash = (53 * hash) + getLacp().hashCode();
    }
    if (hasMaxLagSize100Gbps()) {
      hash = (37 * hash) + MAX_LAG_SIZE100_GBPS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxLagSize100Gbps();
    }
    if (hasMaxLagSize10Gbps()) {
      hash = (37 * hash) + MAX_LAG_SIZE10_GBPS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxLagSize10Gbps();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPeeringdbFacilityId()) {
      hash = (37 * hash) + PEERINGDB_FACILITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPeeringdbFacilityId().hashCode();
    }
    if (getPermittedConnectionsCount() > 0) {
      hash = (37 * hash) + PERMITTED_CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPermittedConnectionsList().hashCode();
    }
    if (hasRemoteService()) {
      hash = (37 * hash) + REMOTE_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getRemoteService().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectRemoteLocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Cross-Cloud Interconnect Remote Location resource. You can use this resource to find remote location details about an Interconnect attachment (VLAN).
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectRemoteLocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectRemoteLocation)
      com.google.cloud.compute.v1.InterconnectRemoteLocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectRemoteLocation.class,
              com.google.cloud.compute.v1.InterconnectRemoteLocation.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectRemoteLocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAttachmentConfigurationConstraintsFieldBuilder();
        getConstraintsFieldBuilder();
        getPermittedConnectionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      address_ = "";
      attachmentConfigurationConstraints_ = null;
      if (attachmentConfigurationConstraintsBuilder_ != null) {
        attachmentConfigurationConstraintsBuilder_.dispose();
        attachmentConfigurationConstraintsBuilder_ = null;
      }
      city_ = "";
      constraints_ = null;
      if (constraintsBuilder_ != null) {
        constraintsBuilder_.dispose();
        constraintsBuilder_ = null;
      }
      continent_ = "";
      creationTimestamp_ = "";
      description_ = "";
      facilityProvider_ = "";
      facilityProviderFacilityId_ = "";
      id_ = 0L;
      kind_ = "";
      lacp_ = "";
      maxLagSize100Gbps_ = 0;
      maxLagSize10Gbps_ = 0;
      name_ = "";
      peeringdbFacilityId_ = "";
      if (permittedConnectionsBuilder_ == null) {
        permittedConnections_ = java.util.Collections.emptyList();
      } else {
        permittedConnections_ = null;
        permittedConnectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      remoteService_ = "";
      selfLink_ = "";
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectRemoteLocation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocation getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectRemoteLocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocation build() {
      com.google.cloud.compute.v1.InterconnectRemoteLocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectRemoteLocation buildPartial() {
      com.google.cloud.compute.v1.InterconnectRemoteLocation result =
          new com.google.cloud.compute.v1.InterconnectRemoteLocation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectRemoteLocation result) {
      if (permittedConnectionsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          permittedConnections_ = java.util.Collections.unmodifiableList(permittedConnections_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.permittedConnections_ = permittedConnections_;
      } else {
        result.permittedConnections_ = permittedConnectionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectRemoteLocation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.address_ = address_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attachmentConfigurationConstraints_ =
            attachmentConfigurationConstraintsBuilder_ == null
                ? attachmentConfigurationConstraints_
                : attachmentConfigurationConstraintsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.city_ = city_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.constraints_ =
            constraintsBuilder_ == null ? constraints_ : constraintsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.continent_ = continent_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.facilityProvider_ = facilityProvider_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.facilityProviderFacilityId_ = facilityProviderFacilityId_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.lacp_ = lacp_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.maxLagSize100Gbps_ = maxLagSize100Gbps_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.maxLagSize10Gbps_ = maxLagSize10Gbps_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.peeringdbFacilityId_ = peeringdbFacilityId_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.remoteService_ = remoteService_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectRemoteLocation) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectRemoteLocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectRemoteLocation other) {
      if (other == com.google.cloud.compute.v1.InterconnectRemoteLocation.getDefaultInstance())
        return this;
      if (other.hasAddress()) {
        address_ = other.address_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAttachmentConfigurationConstraints()) {
        mergeAttachmentConfigurationConstraints(other.getAttachmentConfigurationConstraints());
      }
      if (other.hasCity()) {
        city_ = other.city_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasConstraints()) {
        mergeConstraints(other.getConstraints());
      }
      if (other.hasContinent()) {
        continent_ = other.continent_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasFacilityProvider()) {
        facilityProvider_ = other.facilityProvider_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasFacilityProviderFacilityId()) {
        facilityProviderFacilityId_ = other.facilityProviderFacilityId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasLacp()) {
        lacp_ = other.lacp_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasMaxLagSize100Gbps()) {
        setMaxLagSize100Gbps(other.getMaxLagSize100Gbps());
      }
      if (other.hasMaxLagSize10Gbps()) {
        setMaxLagSize10Gbps(other.getMaxLagSize10Gbps());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasPeeringdbFacilityId()) {
        peeringdbFacilityId_ = other.peeringdbFacilityId_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (permittedConnectionsBuilder_ == null) {
        if (!other.permittedConnections_.isEmpty()) {
          if (permittedConnections_.isEmpty()) {
            permittedConnections_ = other.permittedConnections_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensurePermittedConnectionsIsMutable();
            permittedConnections_.addAll(other.permittedConnections_);
          }
          onChanged();
        }
      } else {
        if (!other.permittedConnections_.isEmpty()) {
          if (permittedConnectionsBuilder_.isEmpty()) {
            permittedConnectionsBuilder_.dispose();
            permittedConnectionsBuilder_ = null;
            permittedConnections_ = other.permittedConnections_;
            bitField0_ = (bitField0_ & ~0x00010000);
            permittedConnectionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPermittedConnectionsFieldBuilder()
                    : null;
          } else {
            permittedConnectionsBuilder_.addAllMessages(other.permittedConnections_);
          }
        }
      }
      if (other.hasRemoteService()) {
        remoteService_ = other.remoteService_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 26840
            case 24431450:
              {
                city_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 24431450
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26336418
            case 26510610:
              {
                lacp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26510610
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 26989658
            case 31273394:
              {
                input.readMessage(getConstraintsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 31273394
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 244202930
            case 698153002:
              {
                facilityProviderFacilityId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 698153002
            case 1067543970:
              {
                continent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1067543970
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 1450082194
            case 1961754024:
              {
                maxLagSize100Gbps_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 1961754024
            case -1942906712:
              {
                maxLagSize10Gbps_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case -1942906712
            case -1680366966:
              {
                input.readMessage(
                    getAttachmentConfigurationConstraintsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1680366966
            case -1159332382:
              {
                remoteService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -1159332382
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -911466526
            case -758461070:
              {
                com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections
                            .parser(),
                        extensionRegistry);
                if (permittedConnectionsBuilder_ == null) {
                  ensurePermittedConnectionsIsMutable();
                  permittedConnections_.add(m);
                } else {
                  permittedConnectionsBuilder_.addMessage(m);
                }
                break;
              } // case -758461070
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -645248918
            case -591601758:
              {
                address_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -591601758
            case -28540822:
              {
                facilityProvider_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -28540822
            case -2430542:
              {
                peeringdbFacilityId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -2430542
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object address_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return Whether the address field is set.
     */
    public boolean hasAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return The address.
     */
    public java.lang.String getAddress() {
      java.lang.Object ref = address_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return The bytes for address.
     */
    public com.google.protobuf.ByteString getAddressBytes() {
      java.lang.Object ref = address_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        address_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @param value The address to set.
     * @return This builder for chaining.
     */
    public Builder setAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddress() {
      address_ = getDefaultInstance().getAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The postal address of the Point of Presence, each line in the address is separated by a newline character.
     * </pre>
     *
     * <code>optional string address = 462920692;</code>
     *
     * @param value The bytes for address to set.
     * @return This builder for chaining.
     */
    public Builder setAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        attachmentConfigurationConstraints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder>
        attachmentConfigurationConstraintsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     *
     * @return Whether the attachmentConfigurationConstraints field is set.
     */
    public boolean hasAttachmentConfigurationConstraints() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     *
     * @return The attachmentConfigurationConstraints.
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
        getAttachmentConfigurationConstraints() {
      if (attachmentConfigurationConstraintsBuilder_ == null) {
        return attachmentConfigurationConstraints_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                .getDefaultInstance()
            : attachmentConfigurationConstraints_;
      } else {
        return attachmentConfigurationConstraintsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public Builder setAttachmentConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints value) {
      if (attachmentConfigurationConstraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attachmentConfigurationConstraints_ = value;
      } else {
        attachmentConfigurationConstraintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public Builder setAttachmentConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
            builderForValue) {
      if (attachmentConfigurationConstraintsBuilder_ == null) {
        attachmentConfigurationConstraints_ = builderForValue.build();
      } else {
        attachmentConfigurationConstraintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public Builder mergeAttachmentConfigurationConstraints(
        com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints value) {
      if (attachmentConfigurationConstraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && attachmentConfigurationConstraints_ != null
            && attachmentConfigurationConstraints_
                != com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                    .getDefaultInstance()) {
          getAttachmentConfigurationConstraintsBuilder().mergeFrom(value);
        } else {
          attachmentConfigurationConstraints_ = value;
        }
      } else {
        attachmentConfigurationConstraintsBuilder_.mergeFrom(value);
      }
      if (attachmentConfigurationConstraints_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public Builder clearAttachmentConfigurationConstraints() {
      bitField0_ = (bitField0_ & ~0x00000002);
      attachmentConfigurationConstraints_ = null;
      if (attachmentConfigurationConstraintsBuilder_ != null) {
        attachmentConfigurationConstraintsBuilder_.dispose();
        attachmentConfigurationConstraintsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder
        getAttachmentConfigurationConstraintsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAttachmentConfigurationConstraintsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder
        getAttachmentConfigurationConstraintsOrBuilder() {
      if (attachmentConfigurationConstraintsBuilder_ != null) {
        return attachmentConfigurationConstraintsBuilder_.getMessageOrBuilder();
      } else {
        return attachmentConfigurationConstraints_ == null
            ? com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints
                .getDefaultInstance()
            : attachmentConfigurationConstraints_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Subset of fields from InterconnectAttachment's |configurationConstraints| field that apply to all attachments for this remote location.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints attachment_configuration_constraints = 326825041;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraintsOrBuilder>
        getAttachmentConfigurationConstraintsFieldBuilder() {
      if (attachmentConfigurationConstraintsBuilder_ == null) {
        attachmentConfigurationConstraintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints,
                com.google.cloud.compute.v1.InterconnectAttachmentConfigurationConstraints.Builder,
                com.google.cloud.compute.v1
                    .InterconnectAttachmentConfigurationConstraintsOrBuilder>(
                getAttachmentConfigurationConstraints(), getParentForChildren(), isClean());
        attachmentConfigurationConstraints_ = null;
      }
      return attachmentConfigurationConstraintsBuilder_;
    }

    private java.lang.Object city_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return Whether the city field is set.
     */
    public boolean hasCity() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return The city.
     */
    public java.lang.String getCity() {
      java.lang.Object ref = city_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        city_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return The bytes for city.
     */
    public com.google.protobuf.ByteString getCityBytes() {
      java.lang.Object ref = city_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        city_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @param value The city to set.
     * @return This builder for chaining.
     */
    public Builder setCity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      city_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCity() {
      city_ = getDefaultInstance().getCity();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metropolitan area designator that indicates which city an interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
     * </pre>
     *
     * <code>optional string city = 3053931;</code>
     *
     * @param value The bytes for city to set.
     * @return This builder for chaining.
     */
    public Builder setCityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      city_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder>
        constraintsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     *
     * @return Whether the constraints field is set.
     */
    public boolean hasConstraints() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     *
     * @return The constraints.
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints getConstraints() {
      if (constraintsBuilder_ == null) {
        return constraints_ == null
            ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance()
            : constraints_;
      } else {
        return constraintsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public Builder setConstraints(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        constraints_ = value;
      } else {
        constraintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public Builder setConstraints(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        constraints_ = builderForValue.build();
      } else {
        constraintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public Builder mergeConstraints(
        com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints value) {
      if (constraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && constraints_ != null
            && constraints_
                != com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints
                    .getDefaultInstance()) {
          getConstraintsBuilder().mergeFrom(value);
        } else {
          constraints_ = value;
        }
      } else {
        constraintsBuilder_.mergeFrom(value);
      }
      if (constraints_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public Builder clearConstraints() {
      bitField0_ = (bitField0_ & ~0x00000008);
      constraints_ = null;
      if (constraintsBuilder_ != null) {
        constraintsBuilder_.dispose();
        constraintsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder
        getConstraintsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConstraintsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder
        getConstraintsOrBuilder() {
      if (constraintsBuilder_ != null) {
        return constraintsBuilder_.getMessageOrBuilder();
      } else {
        return constraints_ == null
            ? com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.getDefaultInstance()
            : constraints_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Constraints on the parameters for creating Cross-Cloud Interconnect and associated InterconnectAttachments.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InterconnectRemoteLocationConstraints constraints = 3909174;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder,
            com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder>
        getConstraintsFieldBuilder() {
      if (constraintsBuilder_ == null) {
        constraintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints,
                com.google.cloud.compute.v1.InterconnectRemoteLocationConstraints.Builder,
                com.google.cloud.compute.v1.InterconnectRemoteLocationConstraintsOrBuilder>(
                getConstraints(), getParentForChildren(), isClean());
        constraints_ = null;
      }
      return constraintsBuilder_;
    }

    private java.lang.Object continent_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return Whether the continent field is set.
     */
    public boolean hasContinent() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return The continent.
     */
    public java.lang.String getContinent() {
      java.lang.Object ref = continent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        continent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return The bytes for continent.
     */
    public com.google.protobuf.ByteString getContinentBytes() {
      java.lang.Object ref = continent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        continent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @param value The continent to set.
     * @return This builder for chaining.
     */
    public Builder setContinent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      continent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContinent() {
      continent_ = getDefaultInstance().getContinent();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
     * Check the Continent enum for the list of possible values.
     * </pre>
     *
     * <code>optional string continent = 133442996;</code>
     *
     * @param value The bytes for continent to set.
     * @return This builder for chaining.
     */
    public Builder setContinentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      continent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object facilityProvider_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return Whether the facilityProvider field is set.
     */
    public boolean hasFacilityProvider() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return The facilityProvider.
     */
    public java.lang.String getFacilityProvider() {
      java.lang.Object ref = facilityProvider_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facilityProvider_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return The bytes for facilityProvider.
     */
    public com.google.protobuf.ByteString getFacilityProviderBytes() {
      java.lang.Object ref = facilityProvider_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facilityProvider_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @param value The facilityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProvider(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facilityProvider_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacilityProvider() {
      facilityProvider_ = getDefaultInstance().getFacilityProvider();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the provider for this facility (e.g., EQUINIX).
     * </pre>
     *
     * <code>optional string facility_provider = 533303309;</code>
     *
     * @param value The bytes for facilityProvider to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facilityProvider_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object facilityProviderFacilityId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return Whether the facilityProviderFacilityId field is set.
     */
    public boolean hasFacilityProviderFacilityId() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return The facilityProviderFacilityId.
     */
    public java.lang.String getFacilityProviderFacilityId() {
      java.lang.Object ref = facilityProviderFacilityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facilityProviderFacilityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return The bytes for facilityProviderFacilityId.
     */
    public com.google.protobuf.ByteString getFacilityProviderFacilityIdBytes() {
      java.lang.Object ref = facilityProviderFacilityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facilityProviderFacilityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @param value The facilityProviderFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderFacilityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facilityProviderFacilityId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacilityProviderFacilityId() {
      facilityProviderFacilityId_ = getDefaultInstance().getFacilityProviderFacilityId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-DC1).
     * </pre>
     *
     * <code>optional string facility_provider_facility_id = 87269125;</code>
     *
     * @param value The bytes for facilityProviderFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setFacilityProviderFacilityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facilityProviderFacilityId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000200);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnectRemoteLocation for interconnect remote locations.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object lacp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @return Whether the lacp field is set.
     */
    public boolean hasLacp() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @return The lacp.
     */
    public java.lang.String getLacp() {
      java.lang.Object ref = lacp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lacp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @return The bytes for lacp.
     */
    public com.google.protobuf.ByteString getLacpBytes() {
      java.lang.Object ref = lacp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lacp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @param value The lacp to set.
     * @return This builder for chaining.
     */
    public Builder setLacp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lacp_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLacp() {
      lacp_ = getDefaultInstance().getLacp();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
     * Check the Lacp enum for the list of possible values.
     * </pre>
     *
     * <code>optional string lacp = 3313826;</code>
     *
     * @param value The bytes for lacp to set.
     * @return This builder for chaining.
     */
    public Builder setLacpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lacp_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int maxLagSize100Gbps_;

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
     *
     * @return Whether the maxLagSize100Gbps field is set.
     */
    @java.lang.Override
    public boolean hasMaxLagSize100Gbps() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
     *
     * @return The maxLagSize100Gbps.
     */
    @java.lang.Override
    public int getMaxLagSize100Gbps() {
      return maxLagSize100Gbps_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
     *
     * @param value The maxLagSize100Gbps to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLagSize100Gbps(int value) {

      maxLagSize100Gbps_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 100 Gbps ports supported in a link aggregation group (LAG). When linkType is 100 Gbps, requestedLinkCount cannot exceed max_lag_size_100_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size100_gbps = 245219253;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLagSize100Gbps() {
      bitField0_ = (bitField0_ & ~0x00001000);
      maxLagSize100Gbps_ = 0;
      onChanged();
      return this;
    }

    private int maxLagSize10Gbps_;

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
     *
     * @return Whether the maxLagSize10Gbps field is set.
     */
    @java.lang.Override
    public boolean hasMaxLagSize10Gbps() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
     *
     * @return The maxLagSize10Gbps.
     */
    @java.lang.Override
    public int getMaxLagSize10Gbps() {
      return maxLagSize10Gbps_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
     *
     * @param value The maxLagSize10Gbps to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLagSize10Gbps(int value) {

      maxLagSize10Gbps_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The maximum number of 10 Gbps ports supported in a link aggregation group (LAG). When linkType is 10 Gbps, requestedLinkCount cannot exceed max_lag_size_10_gbps.
     * </pre>
     *
     * <code>optional int32 max_lag_size10_gbps = 294007573;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLagSize10Gbps() {
      bitField0_ = (bitField0_ & ~0x00002000);
      maxLagSize10Gbps_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object peeringdbFacilityId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return Whether the peeringdbFacilityId field is set.
     */
    public boolean hasPeeringdbFacilityId() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return The peeringdbFacilityId.
     */
    public java.lang.String getPeeringdbFacilityId() {
      java.lang.Object ref = peeringdbFacilityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeringdbFacilityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return The bytes for peeringdbFacilityId.
     */
    public com.google.protobuf.ByteString getPeeringdbFacilityIdBytes() {
      java.lang.Object ref = peeringdbFacilityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeringdbFacilityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @param value The peeringdbFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringdbFacilityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peeringdbFacilityId_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeeringdbFacilityId() {
      peeringdbFacilityId_ = getDefaultInstance().getPeeringdbFacilityId();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The peeringdb identifier for this facility (corresponding with a netfac type in peeringdb).
     * </pre>
     *
     * <code>optional string peeringdb_facility_id = 536567094;</code>
     *
     * @param value The bytes for peeringdbFacilityId to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringdbFacilityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peeringdbFacilityId_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>
        permittedConnections_ = java.util.Collections.emptyList();

    private void ensurePermittedConnectionsIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        permittedConnections_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>(
                permittedConnections_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections,
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder,
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder>
        permittedConnectionsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>
        getPermittedConnectionsList() {
      if (permittedConnectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(permittedConnections_);
      } else {
        return permittedConnectionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public int getPermittedConnectionsCount() {
      if (permittedConnectionsBuilder_ == null) {
        return permittedConnections_.size();
      } else {
        return permittedConnectionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections
        getPermittedConnections(int index) {
      if (permittedConnectionsBuilder_ == null) {
        return permittedConnections_.get(index);
      } else {
        return permittedConnectionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder setPermittedConnections(
        int index,
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections value) {
      if (permittedConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.set(index, value);
        onChanged();
      } else {
        permittedConnectionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder setPermittedConnections(
        int index,
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
            builderForValue) {
      if (permittedConnectionsBuilder_ == null) {
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.set(index, builderForValue.build());
        onChanged();
      } else {
        permittedConnectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder addPermittedConnections(
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections value) {
      if (permittedConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.add(value);
        onChanged();
      } else {
        permittedConnectionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder addPermittedConnections(
        int index,
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections value) {
      if (permittedConnectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.add(index, value);
        onChanged();
      } else {
        permittedConnectionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder addPermittedConnections(
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
            builderForValue) {
      if (permittedConnectionsBuilder_ == null) {
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.add(builderForValue.build());
        onChanged();
      } else {
        permittedConnectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder addPermittedConnections(
        int index,
        com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
            builderForValue) {
      if (permittedConnectionsBuilder_ == null) {
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.add(index, builderForValue.build());
        onChanged();
      } else {
        permittedConnectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder addAllPermittedConnections(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections>
            values) {
      if (permittedConnectionsBuilder_ == null) {
        ensurePermittedConnectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, permittedConnections_);
        onChanged();
      } else {
        permittedConnectionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder clearPermittedConnections() {
      if (permittedConnectionsBuilder_ == null) {
        permittedConnections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        permittedConnectionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public Builder removePermittedConnections(int index) {
      if (permittedConnectionsBuilder_ == null) {
        ensurePermittedConnectionsIsMutable();
        permittedConnections_.remove(index);
        onChanged();
      } else {
        permittedConnectionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
        getPermittedConnectionsBuilder(int index) {
      return getPermittedConnectionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder
        getPermittedConnectionsOrBuilder(int index) {
      if (permittedConnectionsBuilder_ == null) {
        return permittedConnections_.get(index);
      } else {
        return permittedConnectionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder>
        getPermittedConnectionsOrBuilderList() {
      if (permittedConnectionsBuilder_ != null) {
        return permittedConnectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(permittedConnections_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
        addPermittedConnectionsBuilder() {
      return getPermittedConnectionsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder
        addPermittedConnectionsBuilder(int index) {
      return getPermittedConnectionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Permitted connections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections permitted_connections = 442063278;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder>
        getPermittedConnectionsBuilderList() {
      return getPermittedConnectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections,
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder,
            com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnectionsOrBuilder>
        getPermittedConnectionsFieldBuilder() {
      if (permittedConnectionsBuilder_ == null) {
        permittedConnectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections,
                com.google.cloud.compute.v1.InterconnectRemoteLocationPermittedConnections.Builder,
                com.google.cloud.compute.v1
                    .InterconnectRemoteLocationPermittedConnectionsOrBuilder>(
                permittedConnections_,
                ((bitField0_ & 0x00010000) != 0),
                getParentForChildren(),
                isClean());
        permittedConnections_ = null;
      }
      return permittedConnectionsBuilder_;
    }

    private java.lang.Object remoteService_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return Whether the remoteService field is set.
     */
    public boolean hasRemoteService() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return The remoteService.
     */
    public java.lang.String getRemoteService() {
      java.lang.Object ref = remoteService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        remoteService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return The bytes for remoteService.
     */
    public com.google.protobuf.ByteString getRemoteServiceBytes() {
      java.lang.Object ref = remoteService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        remoteService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @param value The remoteService to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      remoteService_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoteService() {
      remoteService_ = getDefaultInstance().getRemoteService();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Indicates the service provider present at the remote location. Example values: "Amazon Web Services", "Microsoft Azure".
     * </pre>
     *
     * <code>optional string remote_service = 391954364;</code>
     *
     * @param value The bytes for remoteService to set.
     * @return This builder for chaining.
     */
    public Builder setRemoteServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      remoteService_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectRemoteLocation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectRemoteLocation)
  private static final com.google.cloud.compute.v1.InterconnectRemoteLocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectRemoteLocation();
  }

  public static com.google.cloud.compute.v1.InterconnectRemoteLocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectRemoteLocation> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectRemoteLocation>() {
        @java.lang.Override
        public InterconnectRemoteLocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectRemoteLocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectRemoteLocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectRemoteLocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
