/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Project resource. A project is used to organize resources in a Google Cloud Platform environment. For more information, read about the Resource Hierarchy.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Project}
 */
public final class Project extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Project)
    ProjectOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Project.newBuilder() to construct.
  private Project(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Project() {
    cloudArmorTier_ = "";
    creationTimestamp_ = "";
    defaultNetworkTier_ = "";
    defaultServiceAccount_ = "";
    description_ = "";
    enabledFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
    kind_ = "";
    name_ = "";
    quotas_ = java.util.Collections.emptyList();
    selfLink_ = "";
    vmDnsSetting_ = "";
    xpnProjectStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Project();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Project_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Project_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Project.class,
            com.google.cloud.compute.v1.Project.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Project.CloudArmorTier}
   */
  public enum CloudArmorTier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CLOUD_ARMOR_TIER = 0;</code>
     */
    UNDEFINED_CLOUD_ARMOR_TIER(0),
    /**
     *
     *
     * <pre>
     * Enterprise tier protection billed annually.
     * </pre>
     *
     * <code>CA_ENTERPRISE_ANNUAL = 219921116;</code>
     */
    CA_ENTERPRISE_ANNUAL(219921116),
    /**
     *
     *
     * <pre>
     * Enterprise tier protection billed monthly.
     * </pre>
     *
     * <code>CA_ENTERPRISE_PAYGO = 453530323;</code>
     */
    CA_ENTERPRISE_PAYGO(453530323),
    /**
     *
     *
     * <pre>
     * Standard protection.
     * </pre>
     *
     * <code>CA_STANDARD = 13156734;</code>
     */
    CA_STANDARD(13156734),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CLOUD_ARMOR_TIER = 0;</code>
     */
    public static final int UNDEFINED_CLOUD_ARMOR_TIER_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Enterprise tier protection billed annually.
     * </pre>
     *
     * <code>CA_ENTERPRISE_ANNUAL = 219921116;</code>
     */
    public static final int CA_ENTERPRISE_ANNUAL_VALUE = 219921116;

    /**
     *
     *
     * <pre>
     * Enterprise tier protection billed monthly.
     * </pre>
     *
     * <code>CA_ENTERPRISE_PAYGO = 453530323;</code>
     */
    public static final int CA_ENTERPRISE_PAYGO_VALUE = 453530323;

    /**
     *
     *
     * <pre>
     * Standard protection.
     * </pre>
     *
     * <code>CA_STANDARD = 13156734;</code>
     */
    public static final int CA_STANDARD_VALUE = 13156734;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CloudArmorTier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CloudArmorTier forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CLOUD_ARMOR_TIER;
        case 219921116:
          return CA_ENTERPRISE_ANNUAL;
        case 453530323:
          return CA_ENTERPRISE_PAYGO;
        case 13156734:
          return CA_STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CloudArmorTier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CloudArmorTier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CloudArmorTier>() {
          public CloudArmorTier findValueByNumber(int number) {
            return CloudArmorTier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Project.getDescriptor().getEnumTypes().get(0);
    }

    private static final CloudArmorTier[] VALUES = values();

    public static CloudArmorTier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CloudArmorTier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Project.CloudArmorTier)
  }

  /**
   *
   *
   * <pre>
   * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Project.DefaultNetworkTier}
   */
  public enum DefaultNetworkTier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DEFAULT_NETWORK_TIER = 0;</code>
     */
    UNDEFINED_DEFAULT_NETWORK_TIER(0),
    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    FIXED_STANDARD(310464328),
    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    PREMIUM(399530551),
    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    STANDARD(484642493),
    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    STANDARD_OVERRIDES_FIXED_STANDARD(465847234),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DEFAULT_NETWORK_TIER = 0;</code>
     */
    public static final int UNDEFINED_DEFAULT_NETWORK_TIER_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    public static final int FIXED_STANDARD_VALUE = 310464328;

    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    public static final int PREMIUM_VALUE = 399530551;

    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    public static final int STANDARD_VALUE = 484642493;

    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    public static final int STANDARD_OVERRIDES_FIXED_STANDARD_VALUE = 465847234;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DefaultNetworkTier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DefaultNetworkTier forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DEFAULT_NETWORK_TIER;
        case 310464328:
          return FIXED_STANDARD;
        case 399530551:
          return PREMIUM;
        case 484642493:
          return STANDARD;
        case 465847234:
          return STANDARD_OVERRIDES_FIXED_STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DefaultNetworkTier>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DefaultNetworkTier>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DefaultNetworkTier>() {
              public DefaultNetworkTier findValueByNumber(int number) {
                return DefaultNetworkTier.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Project.getDescriptor().getEnumTypes().get(1);
    }

    private static final DefaultNetworkTier[] VALUES = values();

    public static DefaultNetworkTier valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DefaultNetworkTier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Project.DefaultNetworkTier)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Default internal DNS setting used by VMs running in this project.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Project.VmDnsSetting}
   */
  public enum VmDnsSetting implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VM_DNS_SETTING = 0;</code>
     */
    UNDEFINED_VM_DNS_SETTING(0),
    /** <code>GLOBAL_DEFAULT = 345419141;</code> */
    GLOBAL_DEFAULT(345419141),
    /** <code>UNSPECIFIED_VM_DNS_SETTING = 35691930;</code> */
    UNSPECIFIED_VM_DNS_SETTING(35691930),
    /** <code>ZONAL_DEFAULT = 368475782;</code> */
    ZONAL_DEFAULT(368475782),
    /** <code>ZONAL_ONLY = 521198951;</code> */
    ZONAL_ONLY(521198951),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VM_DNS_SETTING = 0;</code>
     */
    public static final int UNDEFINED_VM_DNS_SETTING_VALUE = 0;

    /** <code>GLOBAL_DEFAULT = 345419141;</code> */
    public static final int GLOBAL_DEFAULT_VALUE = 345419141;

    /** <code>UNSPECIFIED_VM_DNS_SETTING = 35691930;</code> */
    public static final int UNSPECIFIED_VM_DNS_SETTING_VALUE = 35691930;

    /** <code>ZONAL_DEFAULT = 368475782;</code> */
    public static final int ZONAL_DEFAULT_VALUE = 368475782;

    /** <code>ZONAL_ONLY = 521198951;</code> */
    public static final int ZONAL_ONLY_VALUE = 521198951;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VmDnsSetting valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VmDnsSetting forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_VM_DNS_SETTING;
        case 345419141:
          return GLOBAL_DEFAULT;
        case 35691930:
          return UNSPECIFIED_VM_DNS_SETTING;
        case 368475782:
          return ZONAL_DEFAULT;
        case 521198951:
          return ZONAL_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VmDnsSetting> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VmDnsSetting> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VmDnsSetting>() {
          public VmDnsSetting findValueByNumber(int number) {
            return VmDnsSetting.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Project.getDescriptor().getEnumTypes().get(2);
    }

    private static final VmDnsSetting[] VALUES = values();

    public static VmDnsSetting valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VmDnsSetting(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Project.VmDnsSetting)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Project.XpnProjectStatus}
   */
  public enum XpnProjectStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_XPN_PROJECT_STATUS = 0;</code>
     */
    UNDEFINED_XPN_PROJECT_STATUS(0),
    /** <code>HOST = 2223528;</code> */
    HOST(2223528),
    /** <code>UNSPECIFIED_XPN_PROJECT_STATUS = 340393257;</code> */
    UNSPECIFIED_XPN_PROJECT_STATUS(340393257),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_XPN_PROJECT_STATUS = 0;</code>
     */
    public static final int UNDEFINED_XPN_PROJECT_STATUS_VALUE = 0;

    /** <code>HOST = 2223528;</code> */
    public static final int HOST_VALUE = 2223528;

    /** <code>UNSPECIFIED_XPN_PROJECT_STATUS = 340393257;</code> */
    public static final int UNSPECIFIED_XPN_PROJECT_STATUS_VALUE = 340393257;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static XpnProjectStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static XpnProjectStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_XPN_PROJECT_STATUS;
        case 2223528:
          return HOST;
        case 340393257:
          return UNSPECIFIED_XPN_PROJECT_STATUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<XpnProjectStatus> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<XpnProjectStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<XpnProjectStatus>() {
              public XpnProjectStatus findValueByNumber(int number) {
                return XpnProjectStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Project.getDescriptor().getEnumTypes().get(3);
    }

    private static final XpnProjectStatus[] VALUES = values();

    public static XpnProjectStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private XpnProjectStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Project.XpnProjectStatus)
  }

  private int bitField0_;
  public static final int CLOUD_ARMOR_TIER_FIELD_NUMBER = 4427052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudArmorTier_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
   * Check the CloudArmorTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cloud_armor_tier = 4427052;</code>
   *
   * @return Whether the cloudArmorTier field is set.
   */
  @java.lang.Override
  public boolean hasCloudArmorTier() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
   * Check the CloudArmorTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cloud_armor_tier = 4427052;</code>
   *
   * @return The cloudArmorTier.
   */
  @java.lang.Override
  public java.lang.String getCloudArmorTier() {
    java.lang.Object ref = cloudArmorTier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudArmorTier_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
   * Check the CloudArmorTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string cloud_armor_tier = 4427052;</code>
   *
   * @return The bytes for cloudArmorTier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudArmorTierBytes() {
    java.lang.Object ref = cloudArmorTier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudArmorTier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMON_INSTANCE_METADATA_FIELD_NUMBER = 185794117;
  private com.google.cloud.compute.v1.Metadata commonInstanceMetadata_;

  /**
   *
   *
   * <pre>
   * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
   *
   * @return Whether the commonInstanceMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCommonInstanceMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
   *
   * @return The commonInstanceMetadata.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Metadata getCommonInstanceMetadata() {
    return commonInstanceMetadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : commonInstanceMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataOrBuilder getCommonInstanceMetadataOrBuilder() {
    return commonInstanceMetadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : commonInstanceMetadata_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_NETWORK_TIER_FIELD_NUMBER = 471753361;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultNetworkTier_ = "";

  /**
   *
   *
   * <pre>
   * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
   * Check the DefaultNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string default_network_tier = 471753361;</code>
   *
   * @return Whether the defaultNetworkTier field is set.
   */
  @java.lang.Override
  public boolean hasDefaultNetworkTier() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
   * Check the DefaultNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string default_network_tier = 471753361;</code>
   *
   * @return The defaultNetworkTier.
   */
  @java.lang.Override
  public java.lang.String getDefaultNetworkTier() {
    java.lang.Object ref = defaultNetworkTier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultNetworkTier_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
   * Check the DefaultNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string default_network_tier = 471753361;</code>
   *
   * @return The bytes for defaultNetworkTier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultNetworkTierBytes() {
    java.lang.Object ref = defaultNetworkTier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultNetworkTier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_SERVICE_ACCOUNT_FIELD_NUMBER = 298712229;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultServiceAccount_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Default service account used by VMs running in this project.
   * </pre>
   *
   * <code>optional string default_service_account = 298712229;</code>
   *
   * @return Whether the defaultServiceAccount field is set.
   */
  @java.lang.Override
  public boolean hasDefaultServiceAccount() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Default service account used by VMs running in this project.
   * </pre>
   *
   * <code>optional string default_service_account = 298712229;</code>
   *
   * @return The defaultServiceAccount.
   */
  @java.lang.Override
  public java.lang.String getDefaultServiceAccount() {
    java.lang.Object ref = defaultServiceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultServiceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Default service account used by VMs running in this project.
   * </pre>
   *
   * <code>optional string default_service_account = 298712229;</code>
   *
   * @return The bytes for defaultServiceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultServiceAccountBytes() {
    java.lang.Object ref = defaultServiceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultServiceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLED_FEATURES_FIELD_NUMBER = 469017467;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList enabledFeatures_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * An optional list of restricted features enabled for use on this project.
   * </pre>
   *
   * <code>repeated string enabled_features = 469017467;</code>
   *
   * @return A list containing the enabledFeatures.
   */
  public com.google.protobuf.ProtocolStringList getEnabledFeaturesList() {
    return enabledFeatures_;
  }

  /**
   *
   *
   * <pre>
   * An optional list of restricted features enabled for use on this project.
   * </pre>
   *
   * <code>repeated string enabled_features = 469017467;</code>
   *
   * @return The count of enabledFeatures.
   */
  public int getEnabledFeaturesCount() {
    return enabledFeatures_.size();
  }

  /**
   *
   *
   * <pre>
   * An optional list of restricted features enabled for use on this project.
   * </pre>
   *
   * <code>repeated string enabled_features = 469017467;</code>
   *
   * @param index The index of the element to return.
   * @return The enabledFeatures at the given index.
   */
  public java.lang.String getEnabledFeatures(int index) {
    return enabledFeatures_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An optional list of restricted features enabled for use on this project.
   * </pre>
   *
   * <code>repeated string enabled_features = 469017467;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the enabledFeatures at the given index.
   */
  public com.google.protobuf.ByteString getEnabledFeaturesBytes(int index) {
    return enabledFeatures_.getByteString(index);
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#project for projects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#project for projects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#project for projects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTAS_FIELD_NUMBER = 125341947;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Quota> quotas_;

  /**
   *
   *
   * <pre>
   * [Output Only] Quotas assigned to this project.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Quota> getQuotasList() {
    return quotas_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Quotas assigned to this project.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.QuotaOrBuilder>
      getQuotasOrBuilderList() {
    return quotas_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Quotas assigned to this project.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
   */
  @java.lang.Override
  public int getQuotasCount() {
    return quotas_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Quotas assigned to this project.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Quota getQuotas(int index) {
    return quotas_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Quotas assigned to this project.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.QuotaOrBuilder getQuotasOrBuilder(int index) {
    return quotas_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USAGE_EXPORT_LOCATION_FIELD_NUMBER = 347543874;
  private com.google.cloud.compute.v1.UsageExportLocation usageExportLocation_;

  /**
   *
   *
   * <pre>
   * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
   * </code>
   *
   * @return Whether the usageExportLocation field is set.
   */
  @java.lang.Override
  public boolean hasUsageExportLocation() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
   * </code>
   *
   * @return The usageExportLocation.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UsageExportLocation getUsageExportLocation() {
    return usageExportLocation_ == null
        ? com.google.cloud.compute.v1.UsageExportLocation.getDefaultInstance()
        : usageExportLocation_;
  }

  /**
   *
   *
   * <pre>
   * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UsageExportLocationOrBuilder
      getUsageExportLocationOrBuilder() {
    return usageExportLocation_ == null
        ? com.google.cloud.compute.v1.UsageExportLocation.getDefaultInstance()
        : usageExportLocation_;
  }

  public static final int VM_DNS_SETTING_FIELD_NUMBER = 58856370;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vmDnsSetting_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Default internal DNS setting used by VMs running in this project.
   * Check the VmDnsSetting enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_dns_setting = 58856370;</code>
   *
   * @return Whether the vmDnsSetting field is set.
   */
  @java.lang.Override
  public boolean hasVmDnsSetting() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Default internal DNS setting used by VMs running in this project.
   * Check the VmDnsSetting enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_dns_setting = 58856370;</code>
   *
   * @return The vmDnsSetting.
   */
  @java.lang.Override
  public java.lang.String getVmDnsSetting() {
    java.lang.Object ref = vmDnsSetting_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vmDnsSetting_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Default internal DNS setting used by VMs running in this project.
   * Check the VmDnsSetting enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_dns_setting = 58856370;</code>
   *
   * @return The bytes for vmDnsSetting.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmDnsSettingBytes() {
    java.lang.Object ref = vmDnsSetting_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vmDnsSetting_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int XPN_PROJECT_STATUS_FIELD_NUMBER = 228419265;

  @SuppressWarnings("serial")
  private volatile java.lang.Object xpnProjectStatus_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
   * Check the XpnProjectStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string xpn_project_status = 228419265;</code>
   *
   * @return Whether the xpnProjectStatus field is set.
   */
  @java.lang.Override
  public boolean hasXpnProjectStatus() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
   * Check the XpnProjectStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string xpn_project_status = 228419265;</code>
   *
   * @return The xpnProjectStatus.
   */
  @java.lang.Override
  public java.lang.String getXpnProjectStatus() {
    java.lang.Object ref = xpnProjectStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      xpnProjectStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
   * Check the XpnProjectStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string xpn_project_status = 228419265;</code>
   *
   * @return The bytes for xpnProjectStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getXpnProjectStatusBytes() {
    java.lang.Object ref = xpnProjectStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      xpnProjectStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4427052, cloudArmorTier_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 58856370, vmDnsSetting_);
    }
    for (int i = 0; i < quotas_.size(); i++) {
      output.writeMessage(125341947, quotas_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(185794117, getCommonInstanceMetadata());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 228419265, xpnProjectStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 298712229, defaultServiceAccount_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(347543874, getUsageExportLocation());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < enabledFeatures_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 469017467, enabledFeatures_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 471753361, defaultNetworkTier_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4427052, cloudArmorTier_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(58856370, vmDnsSetting_);
    }
    for (int i = 0; i < quotas_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(125341947, quotas_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              185794117, getCommonInstanceMetadata());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(228419265, xpnProjectStatus_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              298712229, defaultServiceAccount_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              347543874, getUsageExportLocation());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < enabledFeatures_.size(); i++) {
        dataSize += computeStringSizeNoTag(enabledFeatures_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getEnabledFeaturesList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(471753361, defaultNetworkTier_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Project)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Project other = (com.google.cloud.compute.v1.Project) obj;

    if (hasCloudArmorTier() != other.hasCloudArmorTier()) return false;
    if (hasCloudArmorTier()) {
      if (!getCloudArmorTier().equals(other.getCloudArmorTier())) return false;
    }
    if (hasCommonInstanceMetadata() != other.hasCommonInstanceMetadata()) return false;
    if (hasCommonInstanceMetadata()) {
      if (!getCommonInstanceMetadata().equals(other.getCommonInstanceMetadata())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDefaultNetworkTier() != other.hasDefaultNetworkTier()) return false;
    if (hasDefaultNetworkTier()) {
      if (!getDefaultNetworkTier().equals(other.getDefaultNetworkTier())) return false;
    }
    if (hasDefaultServiceAccount() != other.hasDefaultServiceAccount()) return false;
    if (hasDefaultServiceAccount()) {
      if (!getDefaultServiceAccount().equals(other.getDefaultServiceAccount())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getEnabledFeaturesList().equals(other.getEnabledFeaturesList())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getQuotasList().equals(other.getQuotasList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasUsageExportLocation() != other.hasUsageExportLocation()) return false;
    if (hasUsageExportLocation()) {
      if (!getUsageExportLocation().equals(other.getUsageExportLocation())) return false;
    }
    if (hasVmDnsSetting() != other.hasVmDnsSetting()) return false;
    if (hasVmDnsSetting()) {
      if (!getVmDnsSetting().equals(other.getVmDnsSetting())) return false;
    }
    if (hasXpnProjectStatus() != other.hasXpnProjectStatus()) return false;
    if (hasXpnProjectStatus()) {
      if (!getXpnProjectStatus().equals(other.getXpnProjectStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCloudArmorTier()) {
      hash = (37 * hash) + CLOUD_ARMOR_TIER_FIELD_NUMBER;
      hash = (53 * hash) + getCloudArmorTier().hashCode();
    }
    if (hasCommonInstanceMetadata()) {
      hash = (37 * hash) + COMMON_INSTANCE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getCommonInstanceMetadata().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDefaultNetworkTier()) {
      hash = (37 * hash) + DEFAULT_NETWORK_TIER_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultNetworkTier().hashCode();
    }
    if (hasDefaultServiceAccount()) {
      hash = (37 * hash) + DEFAULT_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultServiceAccount().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getEnabledFeaturesCount() > 0) {
      hash = (37 * hash) + ENABLED_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getEnabledFeaturesList().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getQuotasCount() > 0) {
      hash = (37 * hash) + QUOTAS_FIELD_NUMBER;
      hash = (53 * hash) + getQuotasList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasUsageExportLocation()) {
      hash = (37 * hash) + USAGE_EXPORT_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getUsageExportLocation().hashCode();
    }
    if (hasVmDnsSetting()) {
      hash = (37 * hash) + VM_DNS_SETTING_FIELD_NUMBER;
      hash = (53 * hash) + getVmDnsSetting().hashCode();
    }
    if (hasXpnProjectStatus()) {
      hash = (37 * hash) + XPN_PROJECT_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getXpnProjectStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Project parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Project parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Project parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Project parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Project prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Project resource. A project is used to organize resources in a Google Cloud Platform environment. For more information, read about the Resource Hierarchy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Project}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Project)
      com.google.cloud.compute.v1.ProjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Project_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Project_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Project.class,
              com.google.cloud.compute.v1.Project.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Project.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommonInstanceMetadataFieldBuilder();
        getQuotasFieldBuilder();
        getUsageExportLocationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cloudArmorTier_ = "";
      commonInstanceMetadata_ = null;
      if (commonInstanceMetadataBuilder_ != null) {
        commonInstanceMetadataBuilder_.dispose();
        commonInstanceMetadataBuilder_ = null;
      }
      creationTimestamp_ = "";
      defaultNetworkTier_ = "";
      defaultServiceAccount_ = "";
      description_ = "";
      enabledFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      id_ = 0L;
      kind_ = "";
      name_ = "";
      if (quotasBuilder_ == null) {
        quotas_ = java.util.Collections.emptyList();
      } else {
        quotas_ = null;
        quotasBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      selfLink_ = "";
      usageExportLocation_ = null;
      if (usageExportLocationBuilder_ != null) {
        usageExportLocationBuilder_.dispose();
        usageExportLocationBuilder_ = null;
      }
      vmDnsSetting_ = "";
      xpnProjectStatus_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Project_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Project getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Project.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Project build() {
      com.google.cloud.compute.v1.Project result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Project buildPartial() {
      com.google.cloud.compute.v1.Project result = new com.google.cloud.compute.v1.Project(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Project result) {
      if (quotasBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          quotas_ = java.util.Collections.unmodifiableList(quotas_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.quotas_ = quotas_;
      } else {
        result.quotas_ = quotasBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Project result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cloudArmorTier_ = cloudArmorTier_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.commonInstanceMetadata_ =
            commonInstanceMetadataBuilder_ == null
                ? commonInstanceMetadata_
                : commonInstanceMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.defaultNetworkTier_ = defaultNetworkTier_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.defaultServiceAccount_ = defaultServiceAccount_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        enabledFeatures_.makeImmutable();
        result.enabledFeatures_ = enabledFeatures_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.usageExportLocation_ =
            usageExportLocationBuilder_ == null
                ? usageExportLocation_
                : usageExportLocationBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.vmDnsSetting_ = vmDnsSetting_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.xpnProjectStatus_ = xpnProjectStatus_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Project) {
        return mergeFrom((com.google.cloud.compute.v1.Project) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Project other) {
      if (other == com.google.cloud.compute.v1.Project.getDefaultInstance()) return this;
      if (other.hasCloudArmorTier()) {
        cloudArmorTier_ = other.cloudArmorTier_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCommonInstanceMetadata()) {
        mergeCommonInstanceMetadata(other.getCommonInstanceMetadata());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDefaultNetworkTier()) {
        defaultNetworkTier_ = other.defaultNetworkTier_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDefaultServiceAccount()) {
        defaultServiceAccount_ = other.defaultServiceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.enabledFeatures_.isEmpty()) {
        if (enabledFeatures_.isEmpty()) {
          enabledFeatures_ = other.enabledFeatures_;
          bitField0_ |= 0x00000040;
        } else {
          ensureEnabledFeaturesIsMutable();
          enabledFeatures_.addAll(other.enabledFeatures_);
        }
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (quotasBuilder_ == null) {
        if (!other.quotas_.isEmpty()) {
          if (quotas_.isEmpty()) {
            quotas_ = other.quotas_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureQuotasIsMutable();
            quotas_.addAll(other.quotas_);
          }
          onChanged();
        }
      } else {
        if (!other.quotas_.isEmpty()) {
          if (quotasBuilder_.isEmpty()) {
            quotasBuilder_.dispose();
            quotasBuilder_ = null;
            quotas_ = other.quotas_;
            bitField0_ = (bitField0_ & ~0x00000400);
            quotasBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQuotasFieldBuilder()
                    : null;
          } else {
            quotasBuilder_.addAllMessages(other.quotas_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasUsageExportLocation()) {
        mergeUsageExportLocation(other.getUsageExportLocation());
      }
      if (other.hasVmDnsSetting()) {
        vmDnsSetting_ = other.vmDnsSetting_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasXpnProjectStatus()) {
        xpnProjectStatus_ = other.xpnProjectStatus_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 35416418:
              {
                cloudArmorTier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 35416418
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 470850962:
              {
                vmDnsSetting_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 470850962
            case 1002735578:
              {
                com.google.cloud.compute.v1.Quota m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Quota.parser(), extensionRegistry);
                if (quotasBuilder_ == null) {
                  ensureQuotasIsMutable();
                  quotas_.add(m);
                } else {
                  quotasBuilder_.addMessage(m);
                }
                break;
              } // case 1002735578
            case 1486352938:
              {
                input.readMessage(
                    getCommonInstanceMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1486352938
            case 1827354122:
              {
                xpnProjectStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1827354122
            case -1905269462:
              {
                defaultServiceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1905269462
            case -1514616302:
              {
                input.readMessage(
                    getUsageExportLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case -1514616302
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -645248918
            case -542827558:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEnabledFeaturesIsMutable();
                enabledFeatures_.add(s);
                break;
              } // case -542827558
            case -520940406:
              {
                defaultNetworkTier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -520940406
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object cloudArmorTier_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @return Whether the cloudArmorTier field is set.
     */
    public boolean hasCloudArmorTier() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @return The cloudArmorTier.
     */
    public java.lang.String getCloudArmorTier() {
      java.lang.Object ref = cloudArmorTier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudArmorTier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @return The bytes for cloudArmorTier.
     */
    public com.google.protobuf.ByteString getCloudArmorTierBytes() {
      java.lang.Object ref = cloudArmorTier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudArmorTier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @param value The cloudArmorTier to set.
     * @return This builder for chaining.
     */
    public Builder setCloudArmorTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudArmorTier_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudArmorTier() {
      cloudArmorTier_ = getDefaultInstance().getCloudArmorTier();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
     * Check the CloudArmorTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string cloud_armor_tier = 4427052;</code>
     *
     * @param value The bytes for cloudArmorTier to set.
     * @return This builder for chaining.
     */
    public Builder setCloudArmorTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudArmorTier_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Metadata commonInstanceMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        commonInstanceMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     *
     * @return Whether the commonInstanceMetadata field is set.
     */
    public boolean hasCommonInstanceMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     *
     * @return The commonInstanceMetadata.
     */
    public com.google.cloud.compute.v1.Metadata getCommonInstanceMetadata() {
      if (commonInstanceMetadataBuilder_ == null) {
        return commonInstanceMetadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : commonInstanceMetadata_;
      } else {
        return commonInstanceMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public Builder setCommonInstanceMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (commonInstanceMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonInstanceMetadata_ = value;
      } else {
        commonInstanceMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public Builder setCommonInstanceMetadata(
        com.google.cloud.compute.v1.Metadata.Builder builderForValue) {
      if (commonInstanceMetadataBuilder_ == null) {
        commonInstanceMetadata_ = builderForValue.build();
      } else {
        commonInstanceMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public Builder mergeCommonInstanceMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (commonInstanceMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && commonInstanceMetadata_ != null
            && commonInstanceMetadata_
                != com.google.cloud.compute.v1.Metadata.getDefaultInstance()) {
          getCommonInstanceMetadataBuilder().mergeFrom(value);
        } else {
          commonInstanceMetadata_ = value;
        }
      } else {
        commonInstanceMetadataBuilder_.mergeFrom(value);
      }
      if (commonInstanceMetadata_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public Builder clearCommonInstanceMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      commonInstanceMetadata_ = null;
      if (commonInstanceMetadataBuilder_ != null) {
        commonInstanceMetadataBuilder_.dispose();
        commonInstanceMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public com.google.cloud.compute.v1.Metadata.Builder getCommonInstanceMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCommonInstanceMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    public com.google.cloud.compute.v1.MetadataOrBuilder getCommonInstanceMetadataOrBuilder() {
      if (commonInstanceMetadataBuilder_ != null) {
        return commonInstanceMetadataBuilder_.getMessageOrBuilder();
      } else {
        return commonInstanceMetadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : commonInstanceMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata key/value pairs available to all instances contained in this project. See Custom metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata common_instance_metadata = 185794117;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        getCommonInstanceMetadataFieldBuilder() {
      if (commonInstanceMetadataBuilder_ == null) {
        commonInstanceMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Metadata,
                com.google.cloud.compute.v1.Metadata.Builder,
                com.google.cloud.compute.v1.MetadataOrBuilder>(
                getCommonInstanceMetadata(), getParentForChildren(), isClean());
        commonInstanceMetadata_ = null;
      }
      return commonInstanceMetadataBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object defaultNetworkTier_ = "";

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @return Whether the defaultNetworkTier field is set.
     */
    public boolean hasDefaultNetworkTier() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @return The defaultNetworkTier.
     */
    public java.lang.String getDefaultNetworkTier() {
      java.lang.Object ref = defaultNetworkTier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultNetworkTier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @return The bytes for defaultNetworkTier.
     */
    public com.google.protobuf.ByteString getDefaultNetworkTierBytes() {
      java.lang.Object ref = defaultNetworkTier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultNetworkTier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @param value The defaultNetworkTier to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultNetworkTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultNetworkTier_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultNetworkTier() {
      defaultNetworkTier_ = getDefaultInstance().getDefaultNetworkTier();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
     * Check the DefaultNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string default_network_tier = 471753361;</code>
     *
     * @param value The bytes for defaultNetworkTier to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultNetworkTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultNetworkTier_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object defaultServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @return Whether the defaultServiceAccount field is set.
     */
    public boolean hasDefaultServiceAccount() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @return The defaultServiceAccount.
     */
    public java.lang.String getDefaultServiceAccount() {
      java.lang.Object ref = defaultServiceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultServiceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @return The bytes for defaultServiceAccount.
     */
    public com.google.protobuf.ByteString getDefaultServiceAccountBytes() {
      java.lang.Object ref = defaultServiceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @param value The defaultServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultServiceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultServiceAccount() {
      defaultServiceAccount_ = getDefaultInstance().getDefaultServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default service account used by VMs running in this project.
     * </pre>
     *
     * <code>optional string default_service_account = 298712229;</code>
     *
     * @param value The bytes for defaultServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultServiceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList enabledFeatures_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEnabledFeaturesIsMutable() {
      if (!enabledFeatures_.isModifiable()) {
        enabledFeatures_ = new com.google.protobuf.LazyStringArrayList(enabledFeatures_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @return A list containing the enabledFeatures.
     */
    public com.google.protobuf.ProtocolStringList getEnabledFeaturesList() {
      enabledFeatures_.makeImmutable();
      return enabledFeatures_;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @return The count of enabledFeatures.
     */
    public int getEnabledFeaturesCount() {
      return enabledFeatures_.size();
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param index The index of the element to return.
     * @return The enabledFeatures at the given index.
     */
    public java.lang.String getEnabledFeatures(int index) {
      return enabledFeatures_.get(index);
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the enabledFeatures at the given index.
     */
    public com.google.protobuf.ByteString getEnabledFeaturesBytes(int index) {
      return enabledFeatures_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param index The index to set the value at.
     * @param value The enabledFeatures to set.
     * @return This builder for chaining.
     */
    public Builder setEnabledFeatures(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnabledFeaturesIsMutable();
      enabledFeatures_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param value The enabledFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addEnabledFeatures(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnabledFeaturesIsMutable();
      enabledFeatures_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param values The enabledFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnabledFeatures(java.lang.Iterable<java.lang.String> values) {
      ensureEnabledFeaturesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enabledFeatures_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabledFeatures() {
      enabledFeatures_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional list of restricted features enabled for use on this project.
     * </pre>
     *
     * <code>repeated string enabled_features = 469017467;</code>
     *
     * @param value The bytes of the enabledFeatures to add.
     * @return This builder for chaining.
     */
    public Builder addEnabledFeaturesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnabledFeaturesIsMutable();
      enabledFeatures_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server. This is *not* the project ID, and is just a unique ID used by Compute Engine to identify resources.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#project for projects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The project ID. For example: my-example-project. Use the project ID to make requests to Compute Engine.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Quota> quotas_ =
        java.util.Collections.emptyList();

    private void ensureQuotasIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        quotas_ = new java.util.ArrayList<com.google.cloud.compute.v1.Quota>(quotas_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Quota,
            com.google.cloud.compute.v1.Quota.Builder,
            com.google.cloud.compute.v1.QuotaOrBuilder>
        quotasBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Quota> getQuotasList() {
      if (quotasBuilder_ == null) {
        return java.util.Collections.unmodifiableList(quotas_);
      } else {
        return quotasBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public int getQuotasCount() {
      if (quotasBuilder_ == null) {
        return quotas_.size();
      } else {
        return quotasBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public com.google.cloud.compute.v1.Quota getQuotas(int index) {
      if (quotasBuilder_ == null) {
        return quotas_.get(index);
      } else {
        return quotasBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder setQuotas(int index, com.google.cloud.compute.v1.Quota value) {
      if (quotasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotasIsMutable();
        quotas_.set(index, value);
        onChanged();
      } else {
        quotasBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder setQuotas(int index, com.google.cloud.compute.v1.Quota.Builder builderForValue) {
      if (quotasBuilder_ == null) {
        ensureQuotasIsMutable();
        quotas_.set(index, builderForValue.build());
        onChanged();
      } else {
        quotasBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder addQuotas(com.google.cloud.compute.v1.Quota value) {
      if (quotasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotasIsMutable();
        quotas_.add(value);
        onChanged();
      } else {
        quotasBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder addQuotas(int index, com.google.cloud.compute.v1.Quota value) {
      if (quotasBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotasIsMutable();
        quotas_.add(index, value);
        onChanged();
      } else {
        quotasBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder addQuotas(com.google.cloud.compute.v1.Quota.Builder builderForValue) {
      if (quotasBuilder_ == null) {
        ensureQuotasIsMutable();
        quotas_.add(builderForValue.build());
        onChanged();
      } else {
        quotasBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder addQuotas(int index, com.google.cloud.compute.v1.Quota.Builder builderForValue) {
      if (quotasBuilder_ == null) {
        ensureQuotasIsMutable();
        quotas_.add(index, builderForValue.build());
        onChanged();
      } else {
        quotasBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder addAllQuotas(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Quota> values) {
      if (quotasBuilder_ == null) {
        ensureQuotasIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, quotas_);
        onChanged();
      } else {
        quotasBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder clearQuotas() {
      if (quotasBuilder_ == null) {
        quotas_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        quotasBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public Builder removeQuotas(int index) {
      if (quotasBuilder_ == null) {
        ensureQuotasIsMutable();
        quotas_.remove(index);
        onChanged();
      } else {
        quotasBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public com.google.cloud.compute.v1.Quota.Builder getQuotasBuilder(int index) {
      return getQuotasFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public com.google.cloud.compute.v1.QuotaOrBuilder getQuotasOrBuilder(int index) {
      if (quotasBuilder_ == null) {
        return quotas_.get(index);
      } else {
        return quotasBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.QuotaOrBuilder>
        getQuotasOrBuilderList() {
      if (quotasBuilder_ != null) {
        return quotasBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(quotas_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public com.google.cloud.compute.v1.Quota.Builder addQuotasBuilder() {
      return getQuotasFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Quota.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public com.google.cloud.compute.v1.Quota.Builder addQuotasBuilder(int index) {
      return getQuotasFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Quota.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Quotas assigned to this project.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Quota quotas = 125341947;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Quota.Builder> getQuotasBuilderList() {
      return getQuotasFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Quota,
            com.google.cloud.compute.v1.Quota.Builder,
            com.google.cloud.compute.v1.QuotaOrBuilder>
        getQuotasFieldBuilder() {
      if (quotasBuilder_ == null) {
        quotasBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Quota,
                com.google.cloud.compute.v1.Quota.Builder,
                com.google.cloud.compute.v1.QuotaOrBuilder>(
                quotas_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        quotas_ = null;
      }
      return quotasBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.UsageExportLocation usageExportLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UsageExportLocation,
            com.google.cloud.compute.v1.UsageExportLocation.Builder,
            com.google.cloud.compute.v1.UsageExportLocationOrBuilder>
        usageExportLocationBuilder_;

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     *
     * @return Whether the usageExportLocation field is set.
     */
    public boolean hasUsageExportLocation() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     *
     * @return The usageExportLocation.
     */
    public com.google.cloud.compute.v1.UsageExportLocation getUsageExportLocation() {
      if (usageExportLocationBuilder_ == null) {
        return usageExportLocation_ == null
            ? com.google.cloud.compute.v1.UsageExportLocation.getDefaultInstance()
            : usageExportLocation_;
      } else {
        return usageExportLocationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public Builder setUsageExportLocation(com.google.cloud.compute.v1.UsageExportLocation value) {
      if (usageExportLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usageExportLocation_ = value;
      } else {
        usageExportLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public Builder setUsageExportLocation(
        com.google.cloud.compute.v1.UsageExportLocation.Builder builderForValue) {
      if (usageExportLocationBuilder_ == null) {
        usageExportLocation_ = builderForValue.build();
      } else {
        usageExportLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public Builder mergeUsageExportLocation(com.google.cloud.compute.v1.UsageExportLocation value) {
      if (usageExportLocationBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && usageExportLocation_ != null
            && usageExportLocation_
                != com.google.cloud.compute.v1.UsageExportLocation.getDefaultInstance()) {
          getUsageExportLocationBuilder().mergeFrom(value);
        } else {
          usageExportLocation_ = value;
        }
      } else {
        usageExportLocationBuilder_.mergeFrom(value);
      }
      if (usageExportLocation_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public Builder clearUsageExportLocation() {
      bitField0_ = (bitField0_ & ~0x00001000);
      usageExportLocation_ = null;
      if (usageExportLocationBuilder_ != null) {
        usageExportLocationBuilder_.dispose();
        usageExportLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public com.google.cloud.compute.v1.UsageExportLocation.Builder getUsageExportLocationBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getUsageExportLocationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    public com.google.cloud.compute.v1.UsageExportLocationOrBuilder
        getUsageExportLocationOrBuilder() {
      if (usageExportLocationBuilder_ != null) {
        return usageExportLocationBuilder_.getMessageOrBuilder();
      } else {
        return usageExportLocation_ == null
            ? com.google.cloud.compute.v1.UsageExportLocation.getDefaultInstance()
            : usageExportLocation_;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional naming prefix for daily usage reports and the Google Cloud Storage bucket where they are stored.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.UsageExportLocation usage_export_location = 347543874;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UsageExportLocation,
            com.google.cloud.compute.v1.UsageExportLocation.Builder,
            com.google.cloud.compute.v1.UsageExportLocationOrBuilder>
        getUsageExportLocationFieldBuilder() {
      if (usageExportLocationBuilder_ == null) {
        usageExportLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.UsageExportLocation,
                com.google.cloud.compute.v1.UsageExportLocation.Builder,
                com.google.cloud.compute.v1.UsageExportLocationOrBuilder>(
                getUsageExportLocation(), getParentForChildren(), isClean());
        usageExportLocation_ = null;
      }
      return usageExportLocationBuilder_;
    }

    private java.lang.Object vmDnsSetting_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @return Whether the vmDnsSetting field is set.
     */
    public boolean hasVmDnsSetting() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @return The vmDnsSetting.
     */
    public java.lang.String getVmDnsSetting() {
      java.lang.Object ref = vmDnsSetting_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vmDnsSetting_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @return The bytes for vmDnsSetting.
     */
    public com.google.protobuf.ByteString getVmDnsSettingBytes() {
      java.lang.Object ref = vmDnsSetting_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vmDnsSetting_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @param value The vmDnsSetting to set.
     * @return This builder for chaining.
     */
    public Builder setVmDnsSetting(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vmDnsSetting_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmDnsSetting() {
      vmDnsSetting_ = getDefaultInstance().getVmDnsSetting();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Default internal DNS setting used by VMs running in this project.
     * Check the VmDnsSetting enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_dns_setting = 58856370;</code>
     *
     * @param value The bytes for vmDnsSetting to set.
     * @return This builder for chaining.
     */
    public Builder setVmDnsSettingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vmDnsSetting_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object xpnProjectStatus_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @return Whether the xpnProjectStatus field is set.
     */
    public boolean hasXpnProjectStatus() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @return The xpnProjectStatus.
     */
    public java.lang.String getXpnProjectStatus() {
      java.lang.Object ref = xpnProjectStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        xpnProjectStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @return The bytes for xpnProjectStatus.
     */
    public com.google.protobuf.ByteString getXpnProjectStatusBytes() {
      java.lang.Object ref = xpnProjectStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        xpnProjectStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @param value The xpnProjectStatus to set.
     * @return This builder for chaining.
     */
    public Builder setXpnProjectStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      xpnProjectStatus_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearXpnProjectStatus() {
      xpnProjectStatus_ = getDefaultInstance().getXpnProjectStatus();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
     * Check the XpnProjectStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string xpn_project_status = 228419265;</code>
     *
     * @param value The bytes for xpnProjectStatus to set.
     * @return This builder for chaining.
     */
    public Builder setXpnProjectStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      xpnProjectStatus_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Project)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Project)
  private static final com.google.cloud.compute.v1.Project DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Project();
  }

  public static com.google.cloud.compute.v1.Project getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Project> PARSER =
      new com.google.protobuf.AbstractParser<Project>() {
        @java.lang.Override
        public Project parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Project> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Project> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Project getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
