/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Contains output only fields. Use this sub-message for actual values set on Instance attributes as compared to the value requested by the user (intent) in their instance CRUD calls.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ResourceStatus}
 */
public final class ResourceStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ResourceStatus)
    ResourceStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ResourceStatus.newBuilder() to construct.
  private ResourceStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourceStatus() {
    physicalHost_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourceStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourceStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ResourceStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ResourceStatus.class,
            com.google.cloud.compute.v1.ResourceStatus.Builder.class);
  }

  private int bitField0_;
  public static final int PHYSICAL_HOST_FIELD_NUMBER = 464370704;

  @SuppressWarnings("serial")
  private volatile java.lang.Object physicalHost_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * </pre>
   *
   * <code>optional string physical_host = 464370704;</code>
   *
   * @return Whether the physicalHost field is set.
   */
  @java.lang.Override
  public boolean hasPhysicalHost() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * </pre>
   *
   * <code>optional string physical_host = 464370704;</code>
   *
   * @return The physicalHost.
   */
  @java.lang.Override
  public java.lang.String getPhysicalHost() {
    java.lang.Object ref = physicalHost_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      physicalHost_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * </pre>
   *
   * <code>optional string physical_host = 464370704;</code>
   *
   * @return The bytes for physicalHost.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhysicalHostBytes() {
    java.lang.Object ref = physicalHost_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      physicalHost_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHYSICAL_HOST_TOPOLOGY_FIELD_NUMBER = 390842814;
  private com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physicalHostTopology_;

  /**
   *
   *
   * <pre>
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
   * </code>
   *
   * @return Whether the physicalHostTopology field is set.
   */
  @java.lang.Override
  public boolean hasPhysicalHostTopology() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
   * </code>
   *
   * @return The physicalHostTopology.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology getPhysicalHostTopology() {
    return physicalHostTopology_ == null
        ? com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.getDefaultInstance()
        : physicalHostTopology_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopologyOrBuilder
      getPhysicalHostTopologyOrBuilder() {
    return physicalHostTopology_ == null
        ? com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.getDefaultInstance()
        : physicalHostTopology_;
  }

  public static final int SCHEDULING_FIELD_NUMBER = 386688404;
  private com.google.cloud.compute.v1.ResourceStatusScheduling scheduling_;

  /**
   * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatusScheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.ResourceStatusScheduling.getDefaultInstance()
        : scheduling_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatusSchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.ResourceStatusScheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int UPCOMING_MAINTENANCE_FIELD_NUMBER = 227348592;
  private com.google.cloud.compute.v1.UpcomingMaintenance upcomingMaintenance_;

  /**
   * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
   * </code>
   *
   * @return Whether the upcomingMaintenance field is set.
   */
  @java.lang.Override
  public boolean hasUpcomingMaintenance() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
   * </code>
   *
   * @return The upcomingMaintenance.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UpcomingMaintenance getUpcomingMaintenance() {
    return upcomingMaintenance_ == null
        ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
        : upcomingMaintenance_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder
      getUpcomingMaintenanceOrBuilder() {
    return upcomingMaintenance_ == null
        ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
        : upcomingMaintenance_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(227348592, getUpcomingMaintenance());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(390842814, getPhysicalHostTopology());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 464370704, physicalHost_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              227348592, getUpcomingMaintenance());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              390842814, getPhysicalHostTopology());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(464370704, physicalHost_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ResourceStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ResourceStatus other =
        (com.google.cloud.compute.v1.ResourceStatus) obj;

    if (hasPhysicalHost() != other.hasPhysicalHost()) return false;
    if (hasPhysicalHost()) {
      if (!getPhysicalHost().equals(other.getPhysicalHost())) return false;
    }
    if (hasPhysicalHostTopology() != other.hasPhysicalHostTopology()) return false;
    if (hasPhysicalHostTopology()) {
      if (!getPhysicalHostTopology().equals(other.getPhysicalHostTopology())) return false;
    }
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (hasUpcomingMaintenance() != other.hasUpcomingMaintenance()) return false;
    if (hasUpcomingMaintenance()) {
      if (!getUpcomingMaintenance().equals(other.getUpcomingMaintenance())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPhysicalHost()) {
      hash = (37 * hash) + PHYSICAL_HOST_FIELD_NUMBER;
      hash = (53 * hash) + getPhysicalHost().hashCode();
    }
    if (hasPhysicalHostTopology()) {
      hash = (37 * hash) + PHYSICAL_HOST_TOPOLOGY_FIELD_NUMBER;
      hash = (53 * hash) + getPhysicalHostTopology().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    if (hasUpcomingMaintenance()) {
      hash = (37 * hash) + UPCOMING_MAINTENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getUpcomingMaintenance().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ResourceStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ResourceStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Contains output only fields. Use this sub-message for actual values set on Instance attributes as compared to the value requested by the user (intent) in their instance CRUD calls.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ResourceStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ResourceStatus)
      com.google.cloud.compute.v1.ResourceStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourceStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourceStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ResourceStatus.class,
              com.google.cloud.compute.v1.ResourceStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ResourceStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPhysicalHostTopologyFieldBuilder();
        getSchedulingFieldBuilder();
        getUpcomingMaintenanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      physicalHost_ = "";
      physicalHostTopology_ = null;
      if (physicalHostTopologyBuilder_ != null) {
        physicalHostTopologyBuilder_.dispose();
        physicalHostTopologyBuilder_ = null;
      }
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      upcomingMaintenance_ = null;
      if (upcomingMaintenanceBuilder_ != null) {
        upcomingMaintenanceBuilder_.dispose();
        upcomingMaintenanceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ResourceStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourceStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourceStatus build() {
      com.google.cloud.compute.v1.ResourceStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ResourceStatus buildPartial() {
      com.google.cloud.compute.v1.ResourceStatus result =
          new com.google.cloud.compute.v1.ResourceStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.ResourceStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.physicalHost_ = physicalHost_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.physicalHostTopology_ =
            physicalHostTopologyBuilder_ == null
                ? physicalHostTopology_
                : physicalHostTopologyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upcomingMaintenance_ =
            upcomingMaintenanceBuilder_ == null
                ? upcomingMaintenance_
                : upcomingMaintenanceBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ResourceStatus) {
        return mergeFrom((com.google.cloud.compute.v1.ResourceStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ResourceStatus other) {
      if (other == com.google.cloud.compute.v1.ResourceStatus.getDefaultInstance()) return this;
      if (other.hasPhysicalHost()) {
        physicalHost_ = other.physicalHost_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPhysicalHostTopology()) {
        mergePhysicalHostTopology(other.getPhysicalHostTopology());
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (other.hasUpcomingMaintenance()) {
        mergeUpcomingMaintenance(other.getUpcomingMaintenance());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1818788738:
              {
                input.readMessage(
                    getUpcomingMaintenanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 1818788738
            case -1201460062:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1201460062
            case -1168224782:
              {
                input.readMessage(
                    getPhysicalHostTopologyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1168224782
            case -580001662:
              {
                physicalHost_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -580001662
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object physicalHost_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @return Whether the physicalHost field is set.
     */
    public boolean hasPhysicalHost() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @return The physicalHost.
     */
    public java.lang.String getPhysicalHost() {
      java.lang.Object ref = physicalHost_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        physicalHost_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @return The bytes for physicalHost.
     */
    public com.google.protobuf.ByteString getPhysicalHostBytes() {
      java.lang.Object ref = physicalHost_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        physicalHost_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @param value The physicalHost to set.
     * @return This builder for chaining.
     */
    public Builder setPhysicalHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      physicalHost_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhysicalHost() {
      physicalHost_ = getDefaultInstance().getPhysicalHost();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The precise location of your instance within the zone's data center, including the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
     * </pre>
     *
     * <code>optional string physical_host = 464370704;</code>
     *
     * @param value The bytes for physicalHost to set.
     * @return This builder for chaining.
     */
    public Builder setPhysicalHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      physicalHost_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physicalHostTopology_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology,
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.Builder,
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopologyOrBuilder>
        physicalHostTopologyBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     *
     * @return Whether the physicalHostTopology field is set.
     */
    public boolean hasPhysicalHostTopology() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     *
     * @return The physicalHostTopology.
     */
    public com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology
        getPhysicalHostTopology() {
      if (physicalHostTopologyBuilder_ == null) {
        return physicalHostTopology_ == null
            ? com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.getDefaultInstance()
            : physicalHostTopology_;
      } else {
        return physicalHostTopologyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public Builder setPhysicalHostTopology(
        com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology value) {
      if (physicalHostTopologyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        physicalHostTopology_ = value;
      } else {
        physicalHostTopologyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public Builder setPhysicalHostTopology(
        com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.Builder builderForValue) {
      if (physicalHostTopologyBuilder_ == null) {
        physicalHostTopology_ = builderForValue.build();
      } else {
        physicalHostTopologyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public Builder mergePhysicalHostTopology(
        com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology value) {
      if (physicalHostTopologyBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && physicalHostTopology_ != null
            && physicalHostTopology_
                != com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology
                    .getDefaultInstance()) {
          getPhysicalHostTopologyBuilder().mergeFrom(value);
        } else {
          physicalHostTopology_ = value;
        }
      } else {
        physicalHostTopologyBuilder_.mergeFrom(value);
      }
      if (physicalHostTopology_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public Builder clearPhysicalHostTopology() {
      bitField0_ = (bitField0_ & ~0x00000002);
      physicalHostTopology_ = null;
      if (physicalHostTopologyBuilder_ != null) {
        physicalHostTopologyBuilder_.dispose();
        physicalHostTopologyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.Builder
        getPhysicalHostTopologyBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPhysicalHostTopologyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopologyOrBuilder
        getPhysicalHostTopologyOrBuilder() {
      if (physicalHostTopologyBuilder_ != null) {
        return physicalHostTopologyBuilder_.getMessageOrBuilder();
      } else {
        return physicalHostTopology_ == null
            ? com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.getDefaultInstance()
            : physicalHostTopology_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as well as the ID of the block, sub-block, and host on which the running instance is located.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ResourceStatusPhysicalHostTopology physical_host_topology = 390842814;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology,
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.Builder,
            com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopologyOrBuilder>
        getPhysicalHostTopologyFieldBuilder() {
      if (physicalHostTopologyBuilder_ == null) {
        physicalHostTopologyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology,
                com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopology.Builder,
                com.google.cloud.compute.v1.ResourceStatusPhysicalHostTopologyOrBuilder>(
                getPhysicalHostTopology(), getParentForChildren(), isClean());
        physicalHostTopology_ = null;
      }
      return physicalHostTopologyBuilder_;
    }

    private com.google.cloud.compute.v1.ResourceStatusScheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatusScheduling,
            com.google.cloud.compute.v1.ResourceStatusScheduling.Builder,
            com.google.cloud.compute.v1.ResourceStatusSchedulingOrBuilder>
        schedulingBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.compute.v1.ResourceStatusScheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.ResourceStatusScheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.ResourceStatusScheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public Builder setScheduling(
        com.google.cloud.compute.v1.ResourceStatusScheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public Builder mergeScheduling(com.google.cloud.compute.v1.ResourceStatusScheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && scheduling_ != null
            && scheduling_
                != com.google.cloud.compute.v1.ResourceStatusScheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      if (scheduling_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public Builder clearScheduling() {
      bitField0_ = (bitField0_ & ~0x00000004);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourceStatusScheduling.Builder getSchedulingBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    public com.google.cloud.compute.v1.ResourceStatusSchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.ResourceStatusScheduling.getDefaultInstance()
            : scheduling_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.ResourceStatusScheduling scheduling = 386688404;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceStatusScheduling,
            com.google.cloud.compute.v1.ResourceStatusScheduling.Builder,
            com.google.cloud.compute.v1.ResourceStatusSchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ResourceStatusScheduling,
                com.google.cloud.compute.v1.ResourceStatusScheduling.Builder,
                com.google.cloud.compute.v1.ResourceStatusSchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private com.google.cloud.compute.v1.UpcomingMaintenance upcomingMaintenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UpcomingMaintenance,
            com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
            com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>
        upcomingMaintenanceBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     *
     * @return Whether the upcomingMaintenance field is set.
     */
    public boolean hasUpcomingMaintenance() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     *
     * @return The upcomingMaintenance.
     */
    public com.google.cloud.compute.v1.UpcomingMaintenance getUpcomingMaintenance() {
      if (upcomingMaintenanceBuilder_ == null) {
        return upcomingMaintenance_ == null
            ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
            : upcomingMaintenance_;
      } else {
        return upcomingMaintenanceBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public Builder setUpcomingMaintenance(com.google.cloud.compute.v1.UpcomingMaintenance value) {
      if (upcomingMaintenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upcomingMaintenance_ = value;
      } else {
        upcomingMaintenanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public Builder setUpcomingMaintenance(
        com.google.cloud.compute.v1.UpcomingMaintenance.Builder builderForValue) {
      if (upcomingMaintenanceBuilder_ == null) {
        upcomingMaintenance_ = builderForValue.build();
      } else {
        upcomingMaintenanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public Builder mergeUpcomingMaintenance(com.google.cloud.compute.v1.UpcomingMaintenance value) {
      if (upcomingMaintenanceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && upcomingMaintenance_ != null
            && upcomingMaintenance_
                != com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()) {
          getUpcomingMaintenanceBuilder().mergeFrom(value);
        } else {
          upcomingMaintenance_ = value;
        }
      } else {
        upcomingMaintenanceBuilder_.mergeFrom(value);
      }
      if (upcomingMaintenance_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public Builder clearUpcomingMaintenance() {
      bitField0_ = (bitField0_ & ~0x00000008);
      upcomingMaintenance_ = null;
      if (upcomingMaintenanceBuilder_ != null) {
        upcomingMaintenanceBuilder_.dispose();
        upcomingMaintenanceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public com.google.cloud.compute.v1.UpcomingMaintenance.Builder getUpcomingMaintenanceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpcomingMaintenanceFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    public com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder
        getUpcomingMaintenanceOrBuilder() {
      if (upcomingMaintenanceBuilder_ != null) {
        return upcomingMaintenanceBuilder_.getMessageOrBuilder();
      } else {
        return upcomingMaintenance_ == null
            ? com.google.cloud.compute.v1.UpcomingMaintenance.getDefaultInstance()
            : upcomingMaintenance_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.UpcomingMaintenance upcoming_maintenance = 227348592;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UpcomingMaintenance,
            com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
            com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>
        getUpcomingMaintenanceFieldBuilder() {
      if (upcomingMaintenanceBuilder_ == null) {
        upcomingMaintenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.UpcomingMaintenance,
                com.google.cloud.compute.v1.UpcomingMaintenance.Builder,
                com.google.cloud.compute.v1.UpcomingMaintenanceOrBuilder>(
                getUpcomingMaintenance(), getParentForChildren(), isClean());
        upcomingMaintenance_ = null;
      }
      return upcomingMaintenanceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ResourceStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ResourceStatus)
  private static final com.google.cloud.compute.v1.ResourceStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ResourceStatus();
  }

  public static com.google.cloud.compute.v1.ResourceStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceStatus> PARSER =
      new com.google.protobuf.AbstractParser<ResourceStatus>() {
        @java.lang.Override
        public ResourceStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourceStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
