/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterBgp}
 */
public final class RouterBgp extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterBgp)
    RouterBgpOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterBgp.newBuilder() to construct.
  private RouterBgp(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterBgp() {
    advertiseMode_ = "";
    advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
    advertisedIpRanges_ = java.util.Collections.emptyList();
    identifierRange_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterBgp();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgp_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgp_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterBgp.class,
            com.google.cloud.compute.v1.RouterBgp.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgp.AdvertiseMode}
   */
  public enum AdvertiseMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISE_MODE = 0;</code>
     */
    UNDEFINED_ADVERTISE_MODE(0),
    /** <code>CUSTOM = 388595569;</code> */
    CUSTOM(388595569),
    /** <code>DEFAULT = 115302945;</code> */
    DEFAULT(115302945),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISE_MODE = 0;</code>
     */
    public static final int UNDEFINED_ADVERTISE_MODE_VALUE = 0;

    /** <code>CUSTOM = 388595569;</code> */
    public static final int CUSTOM_VALUE = 388595569;

    /** <code>DEFAULT = 115302945;</code> */
    public static final int DEFAULT_VALUE = 115302945;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdvertiseMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AdvertiseMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ADVERTISE_MODE;
        case 388595569:
          return CUSTOM;
        case 115302945:
          return DEFAULT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode>() {
          public AdvertiseMode findValueByNumber(int number) {
            return AdvertiseMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgp.getDescriptor().getEnumTypes().get(0);
    }

    private static final AdvertiseMode[] VALUES = values();

    public static AdvertiseMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AdvertiseMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgp.AdvertiseMode)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgp.AdvertisedGroups}
   */
  public enum AdvertisedGroups implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISED_GROUPS = 0;</code>
     */
    UNDEFINED_ADVERTISED_GROUPS(0),
    /**
     *
     *
     * <pre>
     * Advertise all available subnets (including peer VPC subnets).
     * </pre>
     *
     * <code>ALL_SUBNETS = 3622872;</code>
     */
    ALL_SUBNETS(3622872),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISED_GROUPS = 0;</code>
     */
    public static final int UNDEFINED_ADVERTISED_GROUPS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Advertise all available subnets (including peer VPC subnets).
     * </pre>
     *
     * <code>ALL_SUBNETS = 3622872;</code>
     */
    public static final int ALL_SUBNETS_VALUE = 3622872;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdvertisedGroups valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AdvertisedGroups forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ADVERTISED_GROUPS;
        case 3622872:
          return ALL_SUBNETS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups>() {
              public AdvertisedGroups findValueByNumber(int number) {
                return AdvertisedGroups.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgp.getDescriptor().getEnumTypes().get(1);
    }

    private static final AdvertisedGroups[] VALUES = values();

    public static AdvertisedGroups valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AdvertisedGroups(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgp.AdvertisedGroups)
  }

  private int bitField0_;
  public static final int ADVERTISE_MODE_FIELD_NUMBER = 312134331;

  @SuppressWarnings("serial")
  private volatile java.lang.Object advertiseMode_ = "";

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return Whether the advertiseMode field is set.
   */
  @java.lang.Override
  public boolean hasAdvertiseMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return The advertiseMode.
   */
  @java.lang.Override
  public java.lang.String getAdvertiseMode() {
    java.lang.Object ref = advertiseMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      advertiseMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return The bytes for advertiseMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdvertiseModeBytes() {
    java.lang.Object ref = advertiseMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      advertiseMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADVERTISED_GROUPS_FIELD_NUMBER = 21065526;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList advertisedGroups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @return A list containing the advertisedGroups.
   */
  public com.google.protobuf.ProtocolStringList getAdvertisedGroupsList() {
    return advertisedGroups_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @return The count of advertisedGroups.
   */
  public int getAdvertisedGroupsCount() {
    return advertisedGroups_.size();
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @param index The index of the element to return.
   * @return The advertisedGroups at the given index.
   */
  public java.lang.String getAdvertisedGroups(int index) {
    return advertisedGroups_.get(index);
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the advertisedGroups at the given index.
   */
  public com.google.protobuf.ByteString getAdvertisedGroupsBytes(int index) {
    return advertisedGroups_.getByteString(index);
  }

  public static final int ADVERTISED_IP_RANGES_FIELD_NUMBER = 35449932;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange> advertisedIpRanges_;

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
      getAdvertisedIpRangesList() {
    return advertisedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
      getAdvertisedIpRangesOrBuilderList() {
    return advertisedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public int getAdvertisedIpRangesCount() {
    return advertisedIpRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
    return advertisedIpRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder
      getAdvertisedIpRangesOrBuilder(int index) {
    return advertisedIpRanges_.get(index);
  }

  public static final int ASN_FIELD_NUMBER = 96892;
  private int asn_ = 0;

  /**
   *
   *
   * <pre>
   * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
   * </pre>
   *
   * <code>optional uint32 asn = 96892;</code>
   *
   * @return Whether the asn field is set.
   */
  @java.lang.Override
  public boolean hasAsn() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
   * </pre>
   *
   * <code>optional uint32 asn = 96892;</code>
   *
   * @return The asn.
   */
  @java.lang.Override
  public int getAsn() {
    return asn_;
  }

  public static final int IDENTIFIER_RANGE_FIELD_NUMBER = 501573159;

  @SuppressWarnings("serial")
  private volatile java.lang.Object identifierRange_ = "";

  /**
   *
   *
   * <pre>
   * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
   * </pre>
   *
   * <code>optional string identifier_range = 501573159;</code>
   *
   * @return Whether the identifierRange field is set.
   */
  @java.lang.Override
  public boolean hasIdentifierRange() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
   * </pre>
   *
   * <code>optional string identifier_range = 501573159;</code>
   *
   * @return The identifierRange.
   */
  @java.lang.Override
  public java.lang.String getIdentifierRange() {
    java.lang.Object ref = identifierRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      identifierRange_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
   * </pre>
   *
   * <code>optional string identifier_range = 501573159;</code>
   *
   * @return The bytes for identifierRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdentifierRangeBytes() {
    java.lang.Object ref = identifierRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      identifierRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEEPALIVE_INTERVAL_FIELD_NUMBER = 276771516;
  private int keepaliveInterval_ = 0;

  /**
   *
   *
   * <pre>
   * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
   * </pre>
   *
   * <code>optional uint32 keepalive_interval = 276771516;</code>
   *
   * @return Whether the keepaliveInterval field is set.
   */
  @java.lang.Override
  public boolean hasKeepaliveInterval() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
   * </pre>
   *
   * <code>optional uint32 keepalive_interval = 276771516;</code>
   *
   * @return The keepaliveInterval.
   */
  @java.lang.Override
  public int getKeepaliveInterval() {
    return keepaliveInterval_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt32(96892, asn_);
    }
    for (int i = 0; i < advertisedGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 21065526, advertisedGroups_.getRaw(i));
    }
    for (int i = 0; i < advertisedIpRanges_.size(); i++) {
      output.writeMessage(35449932, advertisedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt32(276771516, keepaliveInterval_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 312134331, advertiseMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 501573159, identifierRange_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(96892, asn_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advertisedGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(advertisedGroups_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getAdvertisedGroupsList().size();
    }
    for (int i = 0; i < advertisedIpRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              35449932, advertisedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(276771516, keepaliveInterval_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(312134331, advertiseMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(501573159, identifierRange_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterBgp)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterBgp other = (com.google.cloud.compute.v1.RouterBgp) obj;

    if (hasAdvertiseMode() != other.hasAdvertiseMode()) return false;
    if (hasAdvertiseMode()) {
      if (!getAdvertiseMode().equals(other.getAdvertiseMode())) return false;
    }
    if (!getAdvertisedGroupsList().equals(other.getAdvertisedGroupsList())) return false;
    if (!getAdvertisedIpRangesList().equals(other.getAdvertisedIpRangesList())) return false;
    if (hasAsn() != other.hasAsn()) return false;
    if (hasAsn()) {
      if (getAsn() != other.getAsn()) return false;
    }
    if (hasIdentifierRange() != other.hasIdentifierRange()) return false;
    if (hasIdentifierRange()) {
      if (!getIdentifierRange().equals(other.getIdentifierRange())) return false;
    }
    if (hasKeepaliveInterval() != other.hasKeepaliveInterval()) return false;
    if (hasKeepaliveInterval()) {
      if (getKeepaliveInterval() != other.getKeepaliveInterval()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdvertiseMode()) {
      hash = (37 * hash) + ADVERTISE_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertiseMode().hashCode();
    }
    if (getAdvertisedGroupsCount() > 0) {
      hash = (37 * hash) + ADVERTISED_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedGroupsList().hashCode();
    }
    if (getAdvertisedIpRangesCount() > 0) {
      hash = (37 * hash) + ADVERTISED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedIpRangesList().hashCode();
    }
    if (hasAsn()) {
      hash = (37 * hash) + ASN_FIELD_NUMBER;
      hash = (53 * hash) + getAsn();
    }
    if (hasIdentifierRange()) {
      hash = (37 * hash) + IDENTIFIER_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getIdentifierRange().hashCode();
    }
    if (hasKeepaliveInterval()) {
      hash = (37 * hash) + KEEPALIVE_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getKeepaliveInterval();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgp parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterBgp prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterBgp}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterBgp)
      com.google.cloud.compute.v1.RouterBgpOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterBgp.class,
              com.google.cloud.compute.v1.RouterBgp.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterBgp.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      advertiseMode_ = "";
      advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRanges_ = java.util.Collections.emptyList();
      } else {
        advertisedIpRanges_ = null;
        advertisedIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      asn_ = 0;
      identifierRange_ = "";
      keepaliveInterval_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgp_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgp getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterBgp.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgp build() {
      com.google.cloud.compute.v1.RouterBgp result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgp buildPartial() {
      com.google.cloud.compute.v1.RouterBgp result =
          new com.google.cloud.compute.v1.RouterBgp(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.RouterBgp result) {
      if (advertisedIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          advertisedIpRanges_ = java.util.Collections.unmodifiableList(advertisedIpRanges_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.advertisedIpRanges_ = advertisedIpRanges_;
      } else {
        result.advertisedIpRanges_ = advertisedIpRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterBgp result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.advertiseMode_ = advertiseMode_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        advertisedGroups_.makeImmutable();
        result.advertisedGroups_ = advertisedGroups_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.asn_ = asn_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.identifierRange_ = identifierRange_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.keepaliveInterval_ = keepaliveInterval_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterBgp) {
        return mergeFrom((com.google.cloud.compute.v1.RouterBgp) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterBgp other) {
      if (other == com.google.cloud.compute.v1.RouterBgp.getDefaultInstance()) return this;
      if (other.hasAdvertiseMode()) {
        advertiseMode_ = other.advertiseMode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.advertisedGroups_.isEmpty()) {
        if (advertisedGroups_.isEmpty()) {
          advertisedGroups_ = other.advertisedGroups_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAdvertisedGroupsIsMutable();
          advertisedGroups_.addAll(other.advertisedGroups_);
        }
        onChanged();
      }
      if (advertisedIpRangesBuilder_ == null) {
        if (!other.advertisedIpRanges_.isEmpty()) {
          if (advertisedIpRanges_.isEmpty()) {
            advertisedIpRanges_ = other.advertisedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAdvertisedIpRangesIsMutable();
            advertisedIpRanges_.addAll(other.advertisedIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.advertisedIpRanges_.isEmpty()) {
          if (advertisedIpRangesBuilder_.isEmpty()) {
            advertisedIpRangesBuilder_.dispose();
            advertisedIpRangesBuilder_ = null;
            advertisedIpRanges_ = other.advertisedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000004);
            advertisedIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdvertisedIpRangesFieldBuilder()
                    : null;
          } else {
            advertisedIpRangesBuilder_.addAllMessages(other.advertisedIpRanges_);
          }
        }
      }
      if (other.hasAsn()) {
        setAsn(other.getAsn());
      }
      if (other.hasIdentifierRange()) {
        identifierRange_ = other.identifierRange_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasKeepaliveInterval()) {
        setKeepaliveInterval(other.getKeepaliveInterval());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 775136:
              {
                asn_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 775136
            case 168524210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAdvertisedGroupsIsMutable();
                advertisedGroups_.add(s);
                break;
              } // case 168524210
            case 283599458:
              {
                com.google.cloud.compute.v1.RouterAdvertisedIpRange m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterAdvertisedIpRange.parser(),
                        extensionRegistry);
                if (advertisedIpRangesBuilder_ == null) {
                  ensureAdvertisedIpRangesIsMutable();
                  advertisedIpRanges_.add(m);
                } else {
                  advertisedIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case 283599458
            case -2080795168:
              {
                keepaliveInterval_ = input.readUInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -2080795168
            case -1797892646:
              {
                advertiseMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1797892646
            case -282382022:
              {
                identifierRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -282382022
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object advertiseMode_ = "";

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return Whether the advertiseMode field is set.
     */
    public boolean hasAdvertiseMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return The advertiseMode.
     */
    public java.lang.String getAdvertiseMode() {
      java.lang.Object ref = advertiseMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        advertiseMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return The bytes for advertiseMode.
     */
    public com.google.protobuf.ByteString getAdvertiseModeBytes() {
      java.lang.Object ref = advertiseMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        advertiseMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @param value The advertiseMode to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertiseMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      advertiseMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvertiseMode() {
      advertiseMode_ = getDefaultInstance().getAdvertiseMode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @param value The bytes for advertiseMode to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertiseModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      advertiseMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList advertisedGroups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAdvertisedGroupsIsMutable() {
      if (!advertisedGroups_.isModifiable()) {
        advertisedGroups_ = new com.google.protobuf.LazyStringArrayList(advertisedGroups_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return A list containing the advertisedGroups.
     */
    public com.google.protobuf.ProtocolStringList getAdvertisedGroupsList() {
      advertisedGroups_.makeImmutable();
      return advertisedGroups_;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return The count of advertisedGroups.
     */
    public int getAdvertisedGroupsCount() {
      return advertisedGroups_.size();
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index of the element to return.
     * @return The advertisedGroups at the given index.
     */
    public java.lang.String getAdvertisedGroups(int index) {
      return advertisedGroups_.get(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the advertisedGroups at the given index.
     */
    public com.google.protobuf.ByteString getAdvertisedGroupsBytes(int index) {
      return advertisedGroups_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index to set the value at.
     * @param value The advertisedGroups to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertisedGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param value The advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisedGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param values The advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvertisedGroups(java.lang.Iterable<java.lang.String> values) {
      ensureAdvertisedGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advertisedGroups_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvertisedGroups() {
      advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These groups will be advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param value The bytes of the advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisedGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
        advertisedIpRanges_ = java.util.Collections.emptyList();

    private void ensureAdvertisedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        advertisedIpRanges_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterAdvertisedIpRange>(
                advertisedIpRanges_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterAdvertisedIpRange,
            com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
            com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        advertisedIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
        getAdvertisedIpRangesList() {
      if (advertisedIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(advertisedIpRanges_);
      } else {
        return advertisedIpRangesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public int getAdvertisedIpRangesCount() {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.size();
      } else {
        return advertisedIpRangesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.get(index);
      } else {
        return advertisedIpRangesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder setAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.set(index, value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder setAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(index, value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAllAdvertisedIpRanges(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRange> values) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advertisedIpRanges_);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder clearAdvertisedIpRanges() {
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder removeAdvertisedIpRanges(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.remove(index);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder getAdvertisedIpRangesBuilder(
        int index) {
      return getAdvertisedIpRangesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder
        getAdvertisedIpRangesOrBuilder(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.get(index);
      } else {
        return advertisedIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        getAdvertisedIpRangesOrBuilderList() {
      if (advertisedIpRangesBuilder_ != null) {
        return advertisedIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(advertisedIpRanges_);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder
        addAdvertisedIpRangesBuilder() {
      return getAdvertisedIpRangesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterAdvertisedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder addAdvertisedIpRangesBuilder(
        int index) {
      return getAdvertisedIpRangesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and is advertised to all peers of the router. These IP ranges will be advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder>
        getAdvertisedIpRangesBuilderList() {
      return getAdvertisedIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterAdvertisedIpRange,
            com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
            com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        getAdvertisedIpRangesFieldBuilder() {
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterAdvertisedIpRange,
                com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
                com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>(
                advertisedIpRanges_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        advertisedIpRanges_ = null;
      }
      return advertisedIpRangesBuilder_;
    }

    private int asn_;

    /**
     *
     *
     * <pre>
     * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
     * </pre>
     *
     * <code>optional uint32 asn = 96892;</code>
     *
     * @return Whether the asn field is set.
     */
    @java.lang.Override
    public boolean hasAsn() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
     * </pre>
     *
     * <code>optional uint32 asn = 96892;</code>
     *
     * @return The asn.
     */
    @java.lang.Override
    public int getAsn() {
      return asn_;
    }

    /**
     *
     *
     * <pre>
     * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
     * </pre>
     *
     * <code>optional uint32 asn = 96892;</code>
     *
     * @param value The asn to set.
     * @return This builder for chaining.
     */
    public Builder setAsn(int value) {

      asn_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this router will have the same local ASN.
     * </pre>
     *
     * <code>optional uint32 asn = 96892;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAsn() {
      bitField0_ = (bitField0_ & ~0x00000008);
      asn_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object identifierRange_ = "";

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @return Whether the identifierRange field is set.
     */
    public boolean hasIdentifierRange() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @return The identifierRange.
     */
    public java.lang.String getIdentifierRange() {
      java.lang.Object ref = identifierRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identifierRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @return The bytes for identifierRange.
     */
    public com.google.protobuf.ByteString getIdentifierRangeBytes() {
      java.lang.Object ref = identifierRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        identifierRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @param value The identifierRange to set.
     * @return This builder for chaining.
     */
    public Builder setIdentifierRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identifierRange_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdentifierRange() {
      identifierRange_ = getDefaultInstance().getIdentifierRange();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicitly specifies a range of valid BGP Identifiers for this Router. It is provided as a link-local IPv4 range (from 169.254.0.0/16), of size at least /30, even if the BGP sessions are over IPv6. It must not overlap with any IPv4 BGP session ranges. Other vendors commonly call this "router ID".
     * </pre>
     *
     * <code>optional string identifier_range = 501573159;</code>
     *
     * @param value The bytes for identifierRange to set.
     * @return This builder for chaining.
     */
    public Builder setIdentifierRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identifierRange_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int keepaliveInterval_;

    /**
     *
     *
     * <pre>
     * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
     * </pre>
     *
     * <code>optional uint32 keepalive_interval = 276771516;</code>
     *
     * @return Whether the keepaliveInterval field is set.
     */
    @java.lang.Override
    public boolean hasKeepaliveInterval() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
     * </pre>
     *
     * <code>optional uint32 keepalive_interval = 276771516;</code>
     *
     * @return The keepaliveInterval.
     */
    @java.lang.Override
    public int getKeepaliveInterval() {
      return keepaliveInterval_;
    }

    /**
     *
     *
     * <pre>
     * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
     * </pre>
     *
     * <code>optional uint32 keepalive_interval = 276771516;</code>
     *
     * @param value The keepaliveInterval to set.
     * @return This builder for chaining.
     */
    public Builder setKeepaliveInterval(int value) {

      keepaliveInterval_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The interval in seconds between BGP keepalive messages that are sent to the peer. Hold time is three times the interval at which keepalive messages are sent, and the hold time is the maximum number of seconds allowed to elapse between successive keepalive messages that BGP receives from a peer. BGP will use the smaller of either the local hold time value or the peer's hold time value as the hold time for the BGP connection between the two peers. If set, this value must be between 20 and 60. The default is 20.
     * </pre>
     *
     * <code>optional uint32 keepalive_interval = 276771516;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeepaliveInterval() {
      bitField0_ = (bitField0_ & ~0x00000020);
      keepaliveInterval_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterBgp)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterBgp)
  private static final com.google.cloud.compute.v1.RouterBgp DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterBgp();
  }

  public static com.google.cloud.compute.v1.RouterBgp getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterBgp> PARSER =
      new com.google.protobuf.AbstractParser<RouterBgp>() {
        @java.lang.Override
        public RouterBgp parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterBgp> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterBgp> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgp getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
