/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterBgpPeer}
 */
public final class RouterBgpPeer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterBgpPeer)
    RouterBgpPeerOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterBgpPeer.newBuilder() to construct.
  private RouterBgpPeer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterBgpPeer() {
    advertiseMode_ = "";
    advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
    advertisedIpRanges_ = java.util.Collections.emptyList();
    customLearnedIpRanges_ = java.util.Collections.emptyList();
    enable_ = "";
    exportPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    importPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    interfaceName_ = "";
    ipAddress_ = "";
    ipv4NexthopAddress_ = "";
    ipv6NexthopAddress_ = "";
    managementType_ = "";
    md5AuthenticationKeyName_ = "";
    name_ = "";
    peerIpAddress_ = "";
    peerIpv4NexthopAddress_ = "";
    peerIpv6NexthopAddress_ = "";
    routerApplianceInstance_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterBgpPeer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterBgpPeer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterBgpPeer.class,
            com.google.cloud.compute.v1.RouterBgpPeer.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgpPeer.AdvertiseMode}
   */
  public enum AdvertiseMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISE_MODE = 0;</code>
     */
    UNDEFINED_ADVERTISE_MODE(0),
    /** <code>CUSTOM = 388595569;</code> */
    CUSTOM(388595569),
    /** <code>DEFAULT = 115302945;</code> */
    DEFAULT(115302945),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISE_MODE = 0;</code>
     */
    public static final int UNDEFINED_ADVERTISE_MODE_VALUE = 0;

    /** <code>CUSTOM = 388595569;</code> */
    public static final int CUSTOM_VALUE = 388595569;

    /** <code>DEFAULT = 115302945;</code> */
    public static final int DEFAULT_VALUE = 115302945;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdvertiseMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AdvertiseMode forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ADVERTISE_MODE;
        case 388595569:
          return CUSTOM;
        case 115302945:
          return DEFAULT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AdvertiseMode>() {
          public AdvertiseMode findValueByNumber(int number) {
            return AdvertiseMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgpPeer.getDescriptor().getEnumTypes().get(0);
    }

    private static final AdvertiseMode[] VALUES = values();

    public static AdvertiseMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AdvertiseMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgpPeer.AdvertiseMode)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgpPeer.AdvertisedGroups}
   */
  public enum AdvertisedGroups implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISED_GROUPS = 0;</code>
     */
    UNDEFINED_ADVERTISED_GROUPS(0),
    /**
     *
     *
     * <pre>
     * Advertise all available subnets (including peer VPC subnets).
     * </pre>
     *
     * <code>ALL_SUBNETS = 3622872;</code>
     */
    ALL_SUBNETS(3622872),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ADVERTISED_GROUPS = 0;</code>
     */
    public static final int UNDEFINED_ADVERTISED_GROUPS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Advertise all available subnets (including peer VPC subnets).
     * </pre>
     *
     * <code>ALL_SUBNETS = 3622872;</code>
     */
    public static final int ALL_SUBNETS_VALUE = 3622872;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdvertisedGroups valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AdvertisedGroups forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ADVERTISED_GROUPS;
        case 3622872:
          return ALL_SUBNETS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AdvertisedGroups>() {
              public AdvertisedGroups findValueByNumber(int number) {
                return AdvertisedGroups.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgpPeer.getDescriptor().getEnumTypes().get(1);
    }

    private static final AdvertisedGroups[] VALUES = values();

    public static AdvertisedGroups valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AdvertisedGroups(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgpPeer.AdvertisedGroups)
  }

  /**
   *
   *
   * <pre>
   * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgpPeer.Enable}
   */
  public enum Enable implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENABLE = 0;</code>
     */
    UNDEFINED_ENABLE(0),
    /** <code>FALSE = 66658563;</code> */
    FALSE(66658563),
    /** <code>TRUE = 2583950;</code> */
    TRUE(2583950),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENABLE = 0;</code>
     */
    public static final int UNDEFINED_ENABLE_VALUE = 0;

    /** <code>FALSE = 66658563;</code> */
    public static final int FALSE_VALUE = 66658563;

    /** <code>TRUE = 2583950;</code> */
    public static final int TRUE_VALUE = 2583950;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Enable valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Enable forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ENABLE;
        case 66658563:
          return FALSE;
        case 2583950:
          return TRUE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Enable> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Enable> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Enable>() {
          public Enable findValueByNumber(int number) {
            return Enable.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgpPeer.getDescriptor().getEnumTypes().get(2);
    }

    private static final Enable[] VALUES = values();

    public static Enable valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Enable(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgpPeer.Enable)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterBgpPeer.ManagementType}
   */
  public enum ManagementType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MANAGEMENT_TYPE = 0;</code>
     */
    UNDEFINED_MANAGEMENT_TYPE(0),
    /**
     *
     *
     * <pre>
     * The BGP peer is automatically created for PARTNER type InterconnectAttachment; Google will automatically create/delete this BGP peer when the PARTNER InterconnectAttachment is created/deleted, and Google will update the ipAddress and peerIpAddress when the PARTNER InterconnectAttachment is provisioned. This type of BGP peer cannot be created or deleted, but can be modified for all fields except for name, ipAddress and peerIpAddress.
     * </pre>
     *
     * <code>MANAGED_BY_ATTACHMENT = 458926411;</code>
     */
    MANAGED_BY_ATTACHMENT(458926411),
    /**
     *
     *
     * <pre>
     * Default value, the BGP peer is manually created and managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_USER = 317294067;</code>
     */
    MANAGED_BY_USER(317294067),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_MANAGEMENT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_MANAGEMENT_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The BGP peer is automatically created for PARTNER type InterconnectAttachment; Google will automatically create/delete this BGP peer when the PARTNER InterconnectAttachment is created/deleted, and Google will update the ipAddress and peerIpAddress when the PARTNER InterconnectAttachment is provisioned. This type of BGP peer cannot be created or deleted, but can be modified for all fields except for name, ipAddress and peerIpAddress.
     * </pre>
     *
     * <code>MANAGED_BY_ATTACHMENT = 458926411;</code>
     */
    public static final int MANAGED_BY_ATTACHMENT_VALUE = 458926411;

    /**
     *
     *
     * <pre>
     * Default value, the BGP peer is manually created and managed by user.
     * </pre>
     *
     * <code>MANAGED_BY_USER = 317294067;</code>
     */
    public static final int MANAGED_BY_USER_VALUE = 317294067;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ManagementType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ManagementType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_MANAGEMENT_TYPE;
        case 458926411:
          return MANAGED_BY_ATTACHMENT;
        case 317294067:
          return MANAGED_BY_USER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ManagementType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ManagementType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ManagementType>() {
          public ManagementType findValueByNumber(int number) {
            return ManagementType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterBgpPeer.getDescriptor().getEnumTypes().get(3);
    }

    private static final ManagementType[] VALUES = values();

    public static ManagementType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ManagementType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterBgpPeer.ManagementType)
  }

  private int bitField0_;
  public static final int ADVERTISE_MODE_FIELD_NUMBER = 312134331;

  @SuppressWarnings("serial")
  private volatile java.lang.Object advertiseMode_ = "";

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return Whether the advertiseMode field is set.
   */
  @java.lang.Override
  public boolean hasAdvertiseMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return The advertiseMode.
   */
  @java.lang.Override
  public java.lang.String getAdvertiseMode() {
    java.lang.Object ref = advertiseMode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      advertiseMode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * User-specified flag to indicate which mode to use for advertisement.
   * Check the AdvertiseMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string advertise_mode = 312134331;</code>
   *
   * @return The bytes for advertiseMode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdvertiseModeBytes() {
    java.lang.Object ref = advertiseMode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      advertiseMode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADVERTISED_GROUPS_FIELD_NUMBER = 21065526;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList advertisedGroups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @return A list containing the advertisedGroups.
   */
  public com.google.protobuf.ProtocolStringList getAdvertisedGroupsList() {
    return advertisedGroups_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @return The count of advertisedGroups.
   */
  public int getAdvertisedGroupsCount() {
    return advertisedGroups_.size();
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @param index The index of the element to return.
   * @return The advertisedGroups at the given index.
   */
  public java.lang.String getAdvertisedGroups(int index) {
    return advertisedGroups_.get(index);
  }

  /**
   *
   *
   * <pre>
   * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
   * Check the AdvertisedGroups enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string advertised_groups = 21065526;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the advertisedGroups at the given index.
   */
  public com.google.protobuf.ByteString getAdvertisedGroupsBytes(int index) {
    return advertisedGroups_.getByteString(index);
  }

  public static final int ADVERTISED_IP_RANGES_FIELD_NUMBER = 35449932;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange> advertisedIpRanges_;

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
      getAdvertisedIpRangesList() {
    return advertisedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
      getAdvertisedIpRangesOrBuilderList() {
    return advertisedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public int getAdvertisedIpRangesCount() {
    return advertisedIpRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
    return advertisedIpRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder
      getAdvertisedIpRangesOrBuilder(int index) {
    return advertisedIpRanges_.get(index);
  }

  public static final int ADVERTISED_ROUTE_PRIORITY_FIELD_NUMBER = 186486332;
  private int advertisedRoutePriority_ = 0;

  /**
   *
   *
   * <pre>
   * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
   * </pre>
   *
   * <code>optional uint32 advertised_route_priority = 186486332;</code>
   *
   * @return Whether the advertisedRoutePriority field is set.
   */
  @java.lang.Override
  public boolean hasAdvertisedRoutePriority() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
   * </pre>
   *
   * <code>optional uint32 advertised_route_priority = 186486332;</code>
   *
   * @return The advertisedRoutePriority.
   */
  @java.lang.Override
  public int getAdvertisedRoutePriority() {
    return advertisedRoutePriority_;
  }

  public static final int BFD_FIELD_NUMBER = 97440;
  private com.google.cloud.compute.v1.RouterBgpPeerBfd bfd_;

  /**
   *
   *
   * <pre>
   * BFD configuration for the BGP peering.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
   *
   * @return Whether the bfd field is set.
   */
  @java.lang.Override
  public boolean hasBfd() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * BFD configuration for the BGP peering.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
   *
   * @return The bfd.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerBfd getBfd() {
    return bfd_ == null ? com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance() : bfd_;
  }

  /**
   *
   *
   * <pre>
   * BFD configuration for the BGP peering.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder getBfdOrBuilder() {
    return bfd_ == null ? com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance() : bfd_;
  }

  public static final int CUSTOM_LEARNED_IP_RANGES_FIELD_NUMBER = 481363012;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>
      customLearnedIpRanges_;

  /**
   *
   *
   * <pre>
   * A list of user-defined custom learned route IP address ranges for a BGP session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>
      getCustomLearnedIpRangesList() {
    return customLearnedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * A list of user-defined custom learned route IP address ranges for a BGP session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder>
      getCustomLearnedIpRangesOrBuilderList() {
    return customLearnedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * A list of user-defined custom learned route IP address ranges for a BGP session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
   * </code>
   */
  @java.lang.Override
  public int getCustomLearnedIpRangesCount() {
    return customLearnedIpRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of user-defined custom learned route IP address ranges for a BGP session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange getCustomLearnedIpRanges(
      int index) {
    return customLearnedIpRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of user-defined custom learned route IP address ranges for a BGP session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder
      getCustomLearnedIpRangesOrBuilder(int index) {
    return customLearnedIpRanges_.get(index);
  }

  public static final int CUSTOM_LEARNED_ROUTE_PRIORITY_FIELD_NUMBER = 330412356;
  private int customLearnedRoutePriority_ = 0;

  /**
   *
   *
   * <pre>
   * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
   * </pre>
   *
   * <code>optional int32 custom_learned_route_priority = 330412356;</code>
   *
   * @return Whether the customLearnedRoutePriority field is set.
   */
  @java.lang.Override
  public boolean hasCustomLearnedRoutePriority() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
   * </pre>
   *
   * <code>optional int32 custom_learned_route_priority = 330412356;</code>
   *
   * @return The customLearnedRoutePriority.
   */
  @java.lang.Override
  public int getCustomLearnedRoutePriority() {
    return customLearnedRoutePriority_;
  }

  public static final int ENABLE_FIELD_NUMBER = 311764355;

  @SuppressWarnings("serial")
  private volatile java.lang.Object enable_ = "";

  /**
   *
   *
   * <pre>
   * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
   * Check the Enable enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enable = 311764355;</code>
   *
   * @return Whether the enable field is set.
   */
  @java.lang.Override
  public boolean hasEnable() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
   * Check the Enable enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enable = 311764355;</code>
   *
   * @return The enable.
   */
  @java.lang.Override
  public java.lang.String getEnable() {
    java.lang.Object ref = enable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      enable_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
   * Check the Enable enum for the list of possible values.
   * </pre>
   *
   * <code>optional string enable = 311764355;</code>
   *
   * @return The bytes for enable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnableBytes() {
    java.lang.Object ref = enable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      enable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_IPV4_FIELD_NUMBER = 181467937;
  private boolean enableIpv4_ = false;

  /**
   *
   *
   * <pre>
   * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
   * </pre>
   *
   * <code>optional bool enable_ipv4 = 181467937;</code>
   *
   * @return Whether the enableIpv4 field is set.
   */
  @java.lang.Override
  public boolean hasEnableIpv4() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
   * </pre>
   *
   * <code>optional bool enable_ipv4 = 181467937;</code>
   *
   * @return The enableIpv4.
   */
  @java.lang.Override
  public boolean getEnableIpv4() {
    return enableIpv4_;
  }

  public static final int ENABLE_IPV6_FIELD_NUMBER = 181467939;
  private boolean enableIpv6_ = false;

  /**
   *
   *
   * <pre>
   * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
   * </pre>
   *
   * <code>optional bool enable_ipv6 = 181467939;</code>
   *
   * @return Whether the enableIpv6 field is set.
   */
  @java.lang.Override
  public boolean hasEnableIpv6() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
   * </pre>
   *
   * <code>optional bool enable_ipv6 = 181467939;</code>
   *
   * @return The enableIpv6.
   */
  @java.lang.Override
  public boolean getEnableIpv6() {
    return enableIpv6_;
  }

  public static final int EXPORT_POLICIES_FIELD_NUMBER = 134084987;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList exportPolicies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
   * </pre>
   *
   * <code>repeated string export_policies = 134084987;</code>
   *
   * @return A list containing the exportPolicies.
   */
  public com.google.protobuf.ProtocolStringList getExportPoliciesList() {
    return exportPolicies_;
  }

  /**
   *
   *
   * <pre>
   * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
   * </pre>
   *
   * <code>repeated string export_policies = 134084987;</code>
   *
   * @return The count of exportPolicies.
   */
  public int getExportPoliciesCount() {
    return exportPolicies_.size();
  }

  /**
   *
   *
   * <pre>
   * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
   * </pre>
   *
   * <code>repeated string export_policies = 134084987;</code>
   *
   * @param index The index of the element to return.
   * @return The exportPolicies at the given index.
   */
  public java.lang.String getExportPolicies(int index) {
    return exportPolicies_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
   * </pre>
   *
   * <code>repeated string export_policies = 134084987;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the exportPolicies at the given index.
   */
  public com.google.protobuf.ByteString getExportPoliciesBytes(int index) {
    return exportPolicies_.getByteString(index);
  }

  public static final int IMPORT_POLICIES_FIELD_NUMBER = 451147946;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList importPolicies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
   * </pre>
   *
   * <code>repeated string import_policies = 451147946;</code>
   *
   * @return A list containing the importPolicies.
   */
  public com.google.protobuf.ProtocolStringList getImportPoliciesList() {
    return importPolicies_;
  }

  /**
   *
   *
   * <pre>
   * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
   * </pre>
   *
   * <code>repeated string import_policies = 451147946;</code>
   *
   * @return The count of importPolicies.
   */
  public int getImportPoliciesCount() {
    return importPolicies_.size();
  }

  /**
   *
   *
   * <pre>
   * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
   * </pre>
   *
   * <code>repeated string import_policies = 451147946;</code>
   *
   * @param index The index of the element to return.
   * @return The importPolicies at the given index.
   */
  public java.lang.String getImportPolicies(int index) {
    return importPolicies_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
   * </pre>
   *
   * <code>repeated string import_policies = 451147946;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the importPolicies at the given index.
   */
  public com.google.protobuf.ByteString getImportPoliciesBytes(int index) {
    return importPolicies_.getByteString(index);
  }

  public static final int INTERFACE_NAME_FIELD_NUMBER = 437854673;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interfaceName_ = "";

  /**
   *
   *
   * <pre>
   * Name of the interface the BGP peer is associated with.
   * </pre>
   *
   * <code>optional string interface_name = 437854673;</code>
   *
   * @return Whether the interfaceName field is set.
   */
  @java.lang.Override
  public boolean hasInterfaceName() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the interface the BGP peer is associated with.
   * </pre>
   *
   * <code>optional string interface_name = 437854673;</code>
   *
   * @return The interfaceName.
   */
  @java.lang.Override
  public java.lang.String getInterfaceName() {
    java.lang.Object ref = interfaceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interfaceName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the interface the BGP peer is associated with.
   * </pre>
   *
   * <code>optional string interface_name = 437854673;</code>
   *
   * @return The bytes for interfaceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterfaceNameBytes() {
    java.lang.Object ref = interfaceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interfaceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 406272220;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipAddress_ = "";

  /**
   *
   *
   * <pre>
   * IP address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return Whether the ipAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpAddress() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * IP address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IP address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ip_address = 406272220;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER = 5703377;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv4NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv4 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return Whether the ipv4NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpv4NexthopAddress() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return The ipv4NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getIpv4NexthopAddress() {
    java.lang.Object ref = ipv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv4NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv4_nexthop_address = 5703377;</code>
   *
   * @return The bytes for ipv4NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv4NexthopAddressBytes() {
    java.lang.Object ref = ipv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv4NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER = 27968211;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipv6NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv6 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return Whether the ipv6NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasIpv6NexthopAddress() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return The ipv6NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getIpv6NexthopAddress() {
    java.lang.Object ref = ipv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipv6NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the interface inside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string ipv6_nexthop_address = 27968211;</code>
   *
   * @return The bytes for ipv6NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpv6NexthopAddressBytes() {
    java.lang.Object ref = ipv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipv6NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANAGEMENT_TYPE_FIELD_NUMBER = 173703606;

  @SuppressWarnings("serial")
  private volatile java.lang.Object managementType_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return Whether the managementType field is set.
   */
  @java.lang.Override
  public boolean hasManagementType() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return The managementType.
   */
  @java.lang.Override
  public java.lang.String getManagementType() {
    java.lang.Object ref = managementType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      managementType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
   * Check the ManagementType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string management_type = 173703606;</code>
   *
   * @return The bytes for managementType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getManagementTypeBytes() {
    java.lang.Object ref = managementType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      managementType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MD5_AUTHENTICATION_KEY_NAME_FIELD_NUMBER = 281075345;

  @SuppressWarnings("serial")
  private volatile java.lang.Object md5AuthenticationKeyName_ = "";

  /**
   *
   *
   * <pre>
   * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
   * </pre>
   *
   * <code>optional string md5_authentication_key_name = 281075345;</code>
   *
   * @return Whether the md5AuthenticationKeyName field is set.
   */
  @java.lang.Override
  public boolean hasMd5AuthenticationKeyName() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
   * </pre>
   *
   * <code>optional string md5_authentication_key_name = 281075345;</code>
   *
   * @return The md5AuthenticationKeyName.
   */
  @java.lang.Override
  public java.lang.String getMd5AuthenticationKeyName() {
    java.lang.Object ref = md5AuthenticationKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      md5AuthenticationKeyName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
   * </pre>
   *
   * <code>optional string md5_authentication_key_name = 281075345;</code>
   *
   * @return The bytes for md5AuthenticationKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMd5AuthenticationKeyNameBytes() {
    java.lang.Object ref = md5AuthenticationKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      md5AuthenticationKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_ASN_FIELD_NUMBER = 69573151;
  private int peerAsn_ = 0;

  /**
   *
   *
   * <pre>
   * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
   * </pre>
   *
   * <code>optional uint32 peer_asn = 69573151;</code>
   *
   * @return Whether the peerAsn field is set.
   */
  @java.lang.Override
  public boolean hasPeerAsn() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
   * </pre>
   *
   * <code>optional uint32 peer_asn = 69573151;</code>
   *
   * @return The peerAsn.
   */
  @java.lang.Override
  public int getPeerAsn() {
    return peerAsn_;
  }

  public static final int PEER_IP_ADDRESS_FIELD_NUMBER = 207735769;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpAddress_ = "";

  /**
   *
   *
   * <pre>
   * IP address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return Whether the peerIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpAddress() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * IP address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The peerIpAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpAddress() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IP address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The bytes for peerIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpAddressBytes() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER = 469221774;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpv4NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv4 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return Whether the peerIpv4NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpv4NexthopAddress() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return The peerIpv4NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpv4NexthopAddress() {
    java.lang.Object ref = peerIpv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpv4NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv4 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
   *
   * @return The bytes for peerIpv4NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpv4NexthopAddressBytes() {
    java.lang.Object ref = peerIpv4NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpv4NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER = 491486608;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpv6NexthopAddress_ = "";

  /**
   *
   *
   * <pre>
   * IPv6 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return Whether the peerIpv6NexthopAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpv6NexthopAddress() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return The peerIpv6NexthopAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpv6NexthopAddress() {
    java.lang.Object ref = peerIpv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpv6NexthopAddress_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * IPv6 address of the BGP interface outside Google Cloud Platform.
   * </pre>
   *
   * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
   *
   * @return The bytes for peerIpv6NexthopAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpv6NexthopAddressBytes() {
    java.lang.Object ref = peerIpv6NexthopAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpv6NexthopAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTER_APPLIANCE_INSTANCE_FIELD_NUMBER = 468312989;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routerApplianceInstance_ = "";

  /**
   *
   *
   * <pre>
   * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return Whether the routerApplianceInstance field is set.
   */
  @java.lang.Override
  public boolean hasRouterApplianceInstance() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return The routerApplianceInstance.
   */
  @java.lang.Override
  public java.lang.String getRouterApplianceInstance() {
    java.lang.Object ref = routerApplianceInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routerApplianceInstance_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
   * </pre>
   *
   * <code>optional string router_appliance_instance = 468312989;</code>
   *
   * @return The bytes for routerApplianceInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouterApplianceInstanceBytes() {
    java.lang.Object ref = routerApplianceInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routerApplianceInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(97440, getBfd());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5703377, ipv4NexthopAddress_);
    }
    for (int i = 0; i < advertisedGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 21065526, advertisedGroups_.getRaw(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27968211, ipv6NexthopAddress_);
    }
    for (int i = 0; i < advertisedIpRanges_.size(); i++) {
      output.writeMessage(35449932, advertisedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeUInt32(69573151, peerAsn_);
    }
    for (int i = 0; i < exportPolicies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 134084987, exportPolicies_.getRaw(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 173703606, managementType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(181467937, enableIpv4_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(181467939, enableIpv6_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt32(186486332, advertisedRoutePriority_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 207735769, peerIpAddress_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 281075345, md5AuthenticationKeyName_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 311764355, enable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 312134331, advertiseMode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(330412356, customLearnedRoutePriority_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 437854673, interfaceName_);
    }
    for (int i = 0; i < importPolicies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 451147946, importPolicies_.getRaw(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 468312989, routerApplianceInstance_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 469221774, peerIpv4NexthopAddress_);
    }
    for (int i = 0; i < customLearnedIpRanges_.size(); i++) {
      output.writeMessage(481363012, customLearnedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 491486608, peerIpv6NexthopAddress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(97440, getBfd());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5703377, ipv4NexthopAddress_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advertisedGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(advertisedGroups_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getAdvertisedGroupsList().size();
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(27968211, ipv6NexthopAddress_);
    }
    for (int i = 0; i < advertisedIpRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              35449932, advertisedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(69573151, peerAsn_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < exportPolicies_.size(); i++) {
        dataSize += computeStringSizeNoTag(exportPolicies_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getExportPoliciesList().size();
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(173703606, managementType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(181467937, enableIpv4_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(181467939, enableIpv6_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeUInt32Size(
              186486332, advertisedRoutePriority_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(207735769, peerIpAddress_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              281075345, md5AuthenticationKeyName_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(311764355, enable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(312134331, advertiseMode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              330412356, customLearnedRoutePriority_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(406272220, ipAddress_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(437854673, interfaceName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < importPolicies_.size(); i++) {
        dataSize += computeStringSizeNoTag(importPolicies_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getImportPoliciesList().size();
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              468312989, routerApplianceInstance_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              469221774, peerIpv4NexthopAddress_);
    }
    for (int i = 0; i < customLearnedIpRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              481363012, customLearnedIpRanges_.get(i));
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              491486608, peerIpv6NexthopAddress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterBgpPeer)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterBgpPeer other =
        (com.google.cloud.compute.v1.RouterBgpPeer) obj;

    if (hasAdvertiseMode() != other.hasAdvertiseMode()) return false;
    if (hasAdvertiseMode()) {
      if (!getAdvertiseMode().equals(other.getAdvertiseMode())) return false;
    }
    if (!getAdvertisedGroupsList().equals(other.getAdvertisedGroupsList())) return false;
    if (!getAdvertisedIpRangesList().equals(other.getAdvertisedIpRangesList())) return false;
    if (hasAdvertisedRoutePriority() != other.hasAdvertisedRoutePriority()) return false;
    if (hasAdvertisedRoutePriority()) {
      if (getAdvertisedRoutePriority() != other.getAdvertisedRoutePriority()) return false;
    }
    if (hasBfd() != other.hasBfd()) return false;
    if (hasBfd()) {
      if (!getBfd().equals(other.getBfd())) return false;
    }
    if (!getCustomLearnedIpRangesList().equals(other.getCustomLearnedIpRangesList())) return false;
    if (hasCustomLearnedRoutePriority() != other.hasCustomLearnedRoutePriority()) return false;
    if (hasCustomLearnedRoutePriority()) {
      if (getCustomLearnedRoutePriority() != other.getCustomLearnedRoutePriority()) return false;
    }
    if (hasEnable() != other.hasEnable()) return false;
    if (hasEnable()) {
      if (!getEnable().equals(other.getEnable())) return false;
    }
    if (hasEnableIpv4() != other.hasEnableIpv4()) return false;
    if (hasEnableIpv4()) {
      if (getEnableIpv4() != other.getEnableIpv4()) return false;
    }
    if (hasEnableIpv6() != other.hasEnableIpv6()) return false;
    if (hasEnableIpv6()) {
      if (getEnableIpv6() != other.getEnableIpv6()) return false;
    }
    if (!getExportPoliciesList().equals(other.getExportPoliciesList())) return false;
    if (!getImportPoliciesList().equals(other.getImportPoliciesList())) return false;
    if (hasInterfaceName() != other.hasInterfaceName()) return false;
    if (hasInterfaceName()) {
      if (!getInterfaceName().equals(other.getInterfaceName())) return false;
    }
    if (hasIpAddress() != other.hasIpAddress()) return false;
    if (hasIpAddress()) {
      if (!getIpAddress().equals(other.getIpAddress())) return false;
    }
    if (hasIpv4NexthopAddress() != other.hasIpv4NexthopAddress()) return false;
    if (hasIpv4NexthopAddress()) {
      if (!getIpv4NexthopAddress().equals(other.getIpv4NexthopAddress())) return false;
    }
    if (hasIpv6NexthopAddress() != other.hasIpv6NexthopAddress()) return false;
    if (hasIpv6NexthopAddress()) {
      if (!getIpv6NexthopAddress().equals(other.getIpv6NexthopAddress())) return false;
    }
    if (hasManagementType() != other.hasManagementType()) return false;
    if (hasManagementType()) {
      if (!getManagementType().equals(other.getManagementType())) return false;
    }
    if (hasMd5AuthenticationKeyName() != other.hasMd5AuthenticationKeyName()) return false;
    if (hasMd5AuthenticationKeyName()) {
      if (!getMd5AuthenticationKeyName().equals(other.getMd5AuthenticationKeyName())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPeerAsn() != other.hasPeerAsn()) return false;
    if (hasPeerAsn()) {
      if (getPeerAsn() != other.getPeerAsn()) return false;
    }
    if (hasPeerIpAddress() != other.hasPeerIpAddress()) return false;
    if (hasPeerIpAddress()) {
      if (!getPeerIpAddress().equals(other.getPeerIpAddress())) return false;
    }
    if (hasPeerIpv4NexthopAddress() != other.hasPeerIpv4NexthopAddress()) return false;
    if (hasPeerIpv4NexthopAddress()) {
      if (!getPeerIpv4NexthopAddress().equals(other.getPeerIpv4NexthopAddress())) return false;
    }
    if (hasPeerIpv6NexthopAddress() != other.hasPeerIpv6NexthopAddress()) return false;
    if (hasPeerIpv6NexthopAddress()) {
      if (!getPeerIpv6NexthopAddress().equals(other.getPeerIpv6NexthopAddress())) return false;
    }
    if (hasRouterApplianceInstance() != other.hasRouterApplianceInstance()) return false;
    if (hasRouterApplianceInstance()) {
      if (!getRouterApplianceInstance().equals(other.getRouterApplianceInstance())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdvertiseMode()) {
      hash = (37 * hash) + ADVERTISE_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertiseMode().hashCode();
    }
    if (getAdvertisedGroupsCount() > 0) {
      hash = (37 * hash) + ADVERTISED_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedGroupsList().hashCode();
    }
    if (getAdvertisedIpRangesCount() > 0) {
      hash = (37 * hash) + ADVERTISED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedIpRangesList().hashCode();
    }
    if (hasAdvertisedRoutePriority()) {
      hash = (37 * hash) + ADVERTISED_ROUTE_PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getAdvertisedRoutePriority();
    }
    if (hasBfd()) {
      hash = (37 * hash) + BFD_FIELD_NUMBER;
      hash = (53 * hash) + getBfd().hashCode();
    }
    if (getCustomLearnedIpRangesCount() > 0) {
      hash = (37 * hash) + CUSTOM_LEARNED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomLearnedIpRangesList().hashCode();
    }
    if (hasCustomLearnedRoutePriority()) {
      hash = (37 * hash) + CUSTOM_LEARNED_ROUTE_PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getCustomLearnedRoutePriority();
    }
    if (hasEnable()) {
      hash = (37 * hash) + ENABLE_FIELD_NUMBER;
      hash = (53 * hash) + getEnable().hashCode();
    }
    if (hasEnableIpv4()) {
      hash = (37 * hash) + ENABLE_IPV4_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpv4());
    }
    if (hasEnableIpv6()) {
      hash = (37 * hash) + ENABLE_IPV6_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIpv6());
    }
    if (getExportPoliciesCount() > 0) {
      hash = (37 * hash) + EXPORT_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getExportPoliciesList().hashCode();
    }
    if (getImportPoliciesCount() > 0) {
      hash = (37 * hash) + IMPORT_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getImportPoliciesList().hashCode();
    }
    if (hasInterfaceName()) {
      hash = (37 * hash) + INTERFACE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getInterfaceName().hashCode();
    }
    if (hasIpAddress()) {
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
    }
    if (hasIpv4NexthopAddress()) {
      hash = (37 * hash) + IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpv4NexthopAddress().hashCode();
    }
    if (hasIpv6NexthopAddress()) {
      hash = (37 * hash) + IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpv6NexthopAddress().hashCode();
    }
    if (hasManagementType()) {
      hash = (37 * hash) + MANAGEMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getManagementType().hashCode();
    }
    if (hasMd5AuthenticationKeyName()) {
      hash = (37 * hash) + MD5_AUTHENTICATION_KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getMd5AuthenticationKeyName().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPeerAsn()) {
      hash = (37 * hash) + PEER_ASN_FIELD_NUMBER;
      hash = (53 * hash) + getPeerAsn();
    }
    if (hasPeerIpAddress()) {
      hash = (37 * hash) + PEER_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpAddress().hashCode();
    }
    if (hasPeerIpv4NexthopAddress()) {
      hash = (37 * hash) + PEER_IPV4_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpv4NexthopAddress().hashCode();
    }
    if (hasPeerIpv6NexthopAddress()) {
      hash = (37 * hash) + PEER_IPV6_NEXTHOP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpv6NexthopAddress().hashCode();
    }
    if (hasRouterApplianceInstance()) {
      hash = (37 * hash) + ROUTER_APPLIANCE_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getRouterApplianceInstance().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterBgpPeer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterBgpPeer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterBgpPeer)
      com.google.cloud.compute.v1.RouterBgpPeerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterBgpPeer.class,
              com.google.cloud.compute.v1.RouterBgpPeer.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterBgpPeer.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvertisedIpRangesFieldBuilder();
        getBfdFieldBuilder();
        getCustomLearnedIpRangesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      advertiseMode_ = "";
      advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRanges_ = java.util.Collections.emptyList();
      } else {
        advertisedIpRanges_ = null;
        advertisedIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      advertisedRoutePriority_ = 0;
      bfd_ = null;
      if (bfdBuilder_ != null) {
        bfdBuilder_.dispose();
        bfdBuilder_ = null;
      }
      if (customLearnedIpRangesBuilder_ == null) {
        customLearnedIpRanges_ = java.util.Collections.emptyList();
      } else {
        customLearnedIpRanges_ = null;
        customLearnedIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      customLearnedRoutePriority_ = 0;
      enable_ = "";
      enableIpv4_ = false;
      enableIpv6_ = false;
      exportPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      importPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      interfaceName_ = "";
      ipAddress_ = "";
      ipv4NexthopAddress_ = "";
      ipv6NexthopAddress_ = "";
      managementType_ = "";
      md5AuthenticationKeyName_ = "";
      name_ = "";
      peerAsn_ = 0;
      peerIpAddress_ = "";
      peerIpv4NexthopAddress_ = "";
      peerIpv6NexthopAddress_ = "";
      routerApplianceInstance_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeer getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterBgpPeer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeer build() {
      com.google.cloud.compute.v1.RouterBgpPeer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterBgpPeer buildPartial() {
      com.google.cloud.compute.v1.RouterBgpPeer result =
          new com.google.cloud.compute.v1.RouterBgpPeer(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.RouterBgpPeer result) {
      if (advertisedIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          advertisedIpRanges_ = java.util.Collections.unmodifiableList(advertisedIpRanges_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.advertisedIpRanges_ = advertisedIpRanges_;
      } else {
        result.advertisedIpRanges_ = advertisedIpRangesBuilder_.build();
      }
      if (customLearnedIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          customLearnedIpRanges_ = java.util.Collections.unmodifiableList(customLearnedIpRanges_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.customLearnedIpRanges_ = customLearnedIpRanges_;
      } else {
        result.customLearnedIpRanges_ = customLearnedIpRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterBgpPeer result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.advertiseMode_ = advertiseMode_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        advertisedGroups_.makeImmutable();
        result.advertisedGroups_ = advertisedGroups_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.advertisedRoutePriority_ = advertisedRoutePriority_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.bfd_ = bfdBuilder_ == null ? bfd_ : bfdBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.customLearnedRoutePriority_ = customLearnedRoutePriority_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enable_ = enable_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.enableIpv4_ = enableIpv4_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.enableIpv6_ = enableIpv6_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        exportPolicies_.makeImmutable();
        result.exportPolicies_ = exportPolicies_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        importPolicies_.makeImmutable();
        result.importPolicies_ = importPolicies_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.interfaceName_ = interfaceName_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.ipAddress_ = ipAddress_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.ipv4NexthopAddress_ = ipv4NexthopAddress_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.ipv6NexthopAddress_ = ipv6NexthopAddress_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.managementType_ = managementType_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.md5AuthenticationKeyName_ = md5AuthenticationKeyName_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.peerAsn_ = peerAsn_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.peerIpAddress_ = peerIpAddress_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.peerIpv4NexthopAddress_ = peerIpv4NexthopAddress_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.peerIpv6NexthopAddress_ = peerIpv6NexthopAddress_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.routerApplianceInstance_ = routerApplianceInstance_;
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterBgpPeer) {
        return mergeFrom((com.google.cloud.compute.v1.RouterBgpPeer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterBgpPeer other) {
      if (other == com.google.cloud.compute.v1.RouterBgpPeer.getDefaultInstance()) return this;
      if (other.hasAdvertiseMode()) {
        advertiseMode_ = other.advertiseMode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.advertisedGroups_.isEmpty()) {
        if (advertisedGroups_.isEmpty()) {
          advertisedGroups_ = other.advertisedGroups_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAdvertisedGroupsIsMutable();
          advertisedGroups_.addAll(other.advertisedGroups_);
        }
        onChanged();
      }
      if (advertisedIpRangesBuilder_ == null) {
        if (!other.advertisedIpRanges_.isEmpty()) {
          if (advertisedIpRanges_.isEmpty()) {
            advertisedIpRanges_ = other.advertisedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAdvertisedIpRangesIsMutable();
            advertisedIpRanges_.addAll(other.advertisedIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.advertisedIpRanges_.isEmpty()) {
          if (advertisedIpRangesBuilder_.isEmpty()) {
            advertisedIpRangesBuilder_.dispose();
            advertisedIpRangesBuilder_ = null;
            advertisedIpRanges_ = other.advertisedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000004);
            advertisedIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdvertisedIpRangesFieldBuilder()
                    : null;
          } else {
            advertisedIpRangesBuilder_.addAllMessages(other.advertisedIpRanges_);
          }
        }
      }
      if (other.hasAdvertisedRoutePriority()) {
        setAdvertisedRoutePriority(other.getAdvertisedRoutePriority());
      }
      if (other.hasBfd()) {
        mergeBfd(other.getBfd());
      }
      if (customLearnedIpRangesBuilder_ == null) {
        if (!other.customLearnedIpRanges_.isEmpty()) {
          if (customLearnedIpRanges_.isEmpty()) {
            customLearnedIpRanges_ = other.customLearnedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureCustomLearnedIpRangesIsMutable();
            customLearnedIpRanges_.addAll(other.customLearnedIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.customLearnedIpRanges_.isEmpty()) {
          if (customLearnedIpRangesBuilder_.isEmpty()) {
            customLearnedIpRangesBuilder_.dispose();
            customLearnedIpRangesBuilder_ = null;
            customLearnedIpRanges_ = other.customLearnedIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000020);
            customLearnedIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCustomLearnedIpRangesFieldBuilder()
                    : null;
          } else {
            customLearnedIpRangesBuilder_.addAllMessages(other.customLearnedIpRanges_);
          }
        }
      }
      if (other.hasCustomLearnedRoutePriority()) {
        setCustomLearnedRoutePriority(other.getCustomLearnedRoutePriority());
      }
      if (other.hasEnable()) {
        enable_ = other.enable_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasEnableIpv4()) {
        setEnableIpv4(other.getEnableIpv4());
      }
      if (other.hasEnableIpv6()) {
        setEnableIpv6(other.getEnableIpv6());
      }
      if (!other.exportPolicies_.isEmpty()) {
        if (exportPolicies_.isEmpty()) {
          exportPolicies_ = other.exportPolicies_;
          bitField0_ |= 0x00000400;
        } else {
          ensureExportPoliciesIsMutable();
          exportPolicies_.addAll(other.exportPolicies_);
        }
        onChanged();
      }
      if (!other.importPolicies_.isEmpty()) {
        if (importPolicies_.isEmpty()) {
          importPolicies_ = other.importPolicies_;
          bitField0_ |= 0x00000800;
        } else {
          ensureImportPoliciesIsMutable();
          importPolicies_.addAll(other.importPolicies_);
        }
        onChanged();
      }
      if (other.hasInterfaceName()) {
        interfaceName_ = other.interfaceName_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasIpAddress()) {
        ipAddress_ = other.ipAddress_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasIpv4NexthopAddress()) {
        ipv4NexthopAddress_ = other.ipv4NexthopAddress_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasIpv6NexthopAddress()) {
        ipv6NexthopAddress_ = other.ipv6NexthopAddress_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasManagementType()) {
        managementType_ = other.managementType_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasMd5AuthenticationKeyName()) {
        md5AuthenticationKeyName_ = other.md5AuthenticationKeyName_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasPeerAsn()) {
        setPeerAsn(other.getPeerAsn());
      }
      if (other.hasPeerIpAddress()) {
        peerIpAddress_ = other.peerIpAddress_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasPeerIpv4NexthopAddress()) {
        peerIpv4NexthopAddress_ = other.peerIpv4NexthopAddress_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasPeerIpv6NexthopAddress()) {
        peerIpv6NexthopAddress_ = other.peerIpv6NexthopAddress_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasRouterApplianceInstance()) {
        routerApplianceInstance_ = other.routerApplianceInstance_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 779522:
              {
                input.readMessage(getBfdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 779522
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 26989658
            case 45627018:
              {
                ipv4NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 45627018
            case 168524210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAdvertisedGroupsIsMutable();
                advertisedGroups_.add(s);
                break;
              } // case 168524210
            case 223745690:
              {
                ipv6NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 223745690
            case 283599458:
              {
                com.google.cloud.compute.v1.RouterAdvertisedIpRange m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterAdvertisedIpRange.parser(),
                        extensionRegistry);
                if (advertisedIpRangesBuilder_ == null) {
                  ensureAdvertisedIpRangesIsMutable();
                  advertisedIpRanges_.add(m);
                } else {
                  advertisedIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case 283599458
            case 556585208:
              {
                peerAsn_ = input.readUInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 556585208
            case 1072679898:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExportPoliciesIsMutable();
                exportPolicies_.add(s);
                break;
              } // case 1072679898
            case 1389628850:
              {
                managementType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1389628850
            case 1451743496:
              {
                enableIpv4_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 1451743496
            case 1451743512:
              {
                enableIpv6_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 1451743512
            case 1491890656:
              {
                advertisedRoutePriority_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 1491890656
            case 1661886154:
              {
                peerIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 1661886154
            case -2046364534:
              {
                md5AuthenticationKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -2046364534
            case -1800852454:
              {
                enable_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -1800852454
            case -1797892646:
              {
                advertiseMode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1797892646
            case -1651668448:
              {
                customLearnedRoutePriority_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case -1651668448
            case -1044789534:
              {
                ipAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -1044789534
            case -792129910:
              {
                interfaceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -792129910
            case -685783726:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureImportPoliciesIsMutable();
                importPolicies_.add(s);
                break;
              } // case -685783726
            case -548463382:
              {
                routerApplianceInstance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case -548463382
            case -541193102:
              {
                peerIpv4NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case -541193102
            case -444063198:
              {
                com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.parser(),
                        extensionRegistry);
                if (customLearnedIpRangesBuilder_ == null) {
                  ensureCustomLearnedIpRangesIsMutable();
                  customLearnedIpRanges_.add(m);
                } else {
                  customLearnedIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case -444063198
            case -363074430:
              {
                peerIpv6NexthopAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case -363074430
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object advertiseMode_ = "";

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return Whether the advertiseMode field is set.
     */
    public boolean hasAdvertiseMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return The advertiseMode.
     */
    public java.lang.String getAdvertiseMode() {
      java.lang.Object ref = advertiseMode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        advertiseMode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return The bytes for advertiseMode.
     */
    public com.google.protobuf.ByteString getAdvertiseModeBytes() {
      java.lang.Object ref = advertiseMode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        advertiseMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @param value The advertiseMode to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertiseMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      advertiseMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvertiseMode() {
      advertiseMode_ = getDefaultInstance().getAdvertiseMode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified flag to indicate which mode to use for advertisement.
     * Check the AdvertiseMode enum for the list of possible values.
     * </pre>
     *
     * <code>optional string advertise_mode = 312134331;</code>
     *
     * @param value The bytes for advertiseMode to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertiseModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      advertiseMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList advertisedGroups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAdvertisedGroupsIsMutable() {
      if (!advertisedGroups_.isModifiable()) {
        advertisedGroups_ = new com.google.protobuf.LazyStringArrayList(advertisedGroups_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return A list containing the advertisedGroups.
     */
    public com.google.protobuf.ProtocolStringList getAdvertisedGroupsList() {
      advertisedGroups_.makeImmutable();
      return advertisedGroups_;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return The count of advertisedGroups.
     */
    public int getAdvertisedGroupsCount() {
      return advertisedGroups_.size();
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index of the element to return.
     * @return The advertisedGroups at the given index.
     */
    public java.lang.String getAdvertisedGroups(int index) {
      return advertisedGroups_.get(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the advertisedGroups at the given index.
     */
    public com.google.protobuf.ByteString getAdvertisedGroupsBytes(int index) {
      return advertisedGroups_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param index The index to set the value at.
     * @param value The advertisedGroups to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertisedGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param value The advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisedGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param values The advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvertisedGroups(java.lang.Iterable<java.lang.String> values) {
      ensureAdvertisedGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advertisedGroups_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvertisedGroups() {
      advertisedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of prefix groups to advertise in custom mode, which currently supports the following option: - ALL_SUBNETS: Advertises all of the router's own VPC subnets. This excludes any routes learned for subnets that use VPC Network Peering. Note that this field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These groups are advertised in addition to any specified prefixes. Leave this field blank to advertise no custom groups.
     * Check the AdvertisedGroups enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string advertised_groups = 21065526;</code>
     *
     * @param value The bytes of the advertisedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAdvertisedGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAdvertisedGroupsIsMutable();
      advertisedGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
        advertisedIpRanges_ = java.util.Collections.emptyList();

    private void ensureAdvertisedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        advertisedIpRanges_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterAdvertisedIpRange>(
                advertisedIpRanges_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterAdvertisedIpRange,
            com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
            com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        advertisedIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange>
        getAdvertisedIpRangesList() {
      if (advertisedIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(advertisedIpRanges_);
      } else {
        return advertisedIpRangesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public int getAdvertisedIpRangesCount() {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.size();
      } else {
        return advertisedIpRangesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.get(index);
      } else {
        return advertisedIpRangesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder setAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.set(index, value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder setAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange value) {
      if (advertisedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(index, value);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAdvertisedIpRanges(
        int index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder builderForValue) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder addAllAdvertisedIpRanges(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRange> values) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advertisedIpRanges_);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder clearAdvertisedIpRanges() {
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public Builder removeAdvertisedIpRanges(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        ensureAdvertisedIpRangesIsMutable();
        advertisedIpRanges_.remove(index);
        onChanged();
      } else {
        advertisedIpRangesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder getAdvertisedIpRangesBuilder(
        int index) {
      return getAdvertisedIpRangesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder
        getAdvertisedIpRangesOrBuilder(int index) {
      if (advertisedIpRangesBuilder_ == null) {
        return advertisedIpRanges_.get(index);
      } else {
        return advertisedIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        getAdvertisedIpRangesOrBuilderList() {
      if (advertisedIpRangesBuilder_ != null) {
        return advertisedIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(advertisedIpRanges_);
      }
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder
        addAdvertisedIpRangesBuilder() {
      return getAdvertisedIpRangesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterAdvertisedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder addAdvertisedIpRangesBuilder(
        int index) {
      return getAdvertisedIpRangesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterAdvertisedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * User-specified list of individual IP ranges to advertise in custom mode. This field can only be populated if advertise_mode is CUSTOM and overrides the list defined for the router (in the "bgp" message). These IP ranges are advertised in addition to any specified groups. Leave this field blank to advertise no custom IP ranges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterAdvertisedIpRange advertised_ip_ranges = 35449932;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder>
        getAdvertisedIpRangesBuilderList() {
      return getAdvertisedIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterAdvertisedIpRange,
            com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
            com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>
        getAdvertisedIpRangesFieldBuilder() {
      if (advertisedIpRangesBuilder_ == null) {
        advertisedIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterAdvertisedIpRange,
                com.google.cloud.compute.v1.RouterAdvertisedIpRange.Builder,
                com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder>(
                advertisedIpRanges_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        advertisedIpRanges_ = null;
      }
      return advertisedIpRangesBuilder_;
    }

    private int advertisedRoutePriority_;

    /**
     *
     *
     * <pre>
     * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
     * </pre>
     *
     * <code>optional uint32 advertised_route_priority = 186486332;</code>
     *
     * @return Whether the advertisedRoutePriority field is set.
     */
    @java.lang.Override
    public boolean hasAdvertisedRoutePriority() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
     * </pre>
     *
     * <code>optional uint32 advertised_route_priority = 186486332;</code>
     *
     * @return The advertisedRoutePriority.
     */
    @java.lang.Override
    public int getAdvertisedRoutePriority() {
      return advertisedRoutePriority_;
    }

    /**
     *
     *
     * <pre>
     * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
     * </pre>
     *
     * <code>optional uint32 advertised_route_priority = 186486332;</code>
     *
     * @param value The advertisedRoutePriority to set.
     * @return This builder for chaining.
     */
    public Builder setAdvertisedRoutePriority(int value) {

      advertisedRoutePriority_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The priority of routes advertised to this BGP peer. Where there is more than one matching route of maximum length, the routes with the lowest priority value win.
     * </pre>
     *
     * <code>optional uint32 advertised_route_priority = 186486332;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvertisedRoutePriority() {
      bitField0_ = (bitField0_ & ~0x00000008);
      advertisedRoutePriority_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.RouterBgpPeerBfd bfd_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeerBfd,
            com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder>
        bfdBuilder_;

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     *
     * @return Whether the bfd field is set.
     */
    public boolean hasBfd() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     *
     * @return The bfd.
     */
    public com.google.cloud.compute.v1.RouterBgpPeerBfd getBfd() {
      if (bfdBuilder_ == null) {
        return bfd_ == null
            ? com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance()
            : bfd_;
      } else {
        return bfdBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public Builder setBfd(com.google.cloud.compute.v1.RouterBgpPeerBfd value) {
      if (bfdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bfd_ = value;
      } else {
        bfdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public Builder setBfd(com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder builderForValue) {
      if (bfdBuilder_ == null) {
        bfd_ = builderForValue.build();
      } else {
        bfdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public Builder mergeBfd(com.google.cloud.compute.v1.RouterBgpPeerBfd value) {
      if (bfdBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && bfd_ != null
            && bfd_ != com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance()) {
          getBfdBuilder().mergeFrom(value);
        } else {
          bfd_ = value;
        }
      } else {
        bfdBuilder_.mergeFrom(value);
      }
      if (bfd_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public Builder clearBfd() {
      bitField0_ = (bitField0_ & ~0x00000010);
      bfd_ = null;
      if (bfdBuilder_ != null) {
        bfdBuilder_.dispose();
        bfdBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder getBfdBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getBfdFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder getBfdOrBuilder() {
      if (bfdBuilder_ != null) {
        return bfdBuilder_.getMessageOrBuilder();
      } else {
        return bfd_ == null
            ? com.google.cloud.compute.v1.RouterBgpPeerBfd.getDefaultInstance()
            : bfd_;
      }
    }

    /**
     *
     *
     * <pre>
     * BFD configuration for the BGP peering.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterBgpPeerBfd bfd = 97440;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeerBfd,
            com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder>
        getBfdFieldBuilder() {
      if (bfdBuilder_ == null) {
        bfdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RouterBgpPeerBfd,
                com.google.cloud.compute.v1.RouterBgpPeerBfd.Builder,
                com.google.cloud.compute.v1.RouterBgpPeerBfdOrBuilder>(
                getBfd(), getParentForChildren(), isClean());
        bfd_ = null;
      }
      return bfdBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>
        customLearnedIpRanges_ = java.util.Collections.emptyList();

    private void ensureCustomLearnedIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        customLearnedIpRanges_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>(
                customLearnedIpRanges_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange,
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder>
        customLearnedIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>
        getCustomLearnedIpRangesList() {
      if (customLearnedIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(customLearnedIpRanges_);
      } else {
        return customLearnedIpRangesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public int getCustomLearnedIpRangesCount() {
      if (customLearnedIpRangesBuilder_ == null) {
        return customLearnedIpRanges_.size();
      } else {
        return customLearnedIpRangesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange getCustomLearnedIpRanges(
        int index) {
      if (customLearnedIpRangesBuilder_ == null) {
        return customLearnedIpRanges_.get(index);
      } else {
        return customLearnedIpRangesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder setCustomLearnedIpRanges(
        int index, com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange value) {
      if (customLearnedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.set(index, value);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder setCustomLearnedIpRanges(
        int index,
        com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder builderForValue) {
      if (customLearnedIpRangesBuilder_ == null) {
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder addCustomLearnedIpRanges(
        com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange value) {
      if (customLearnedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.add(value);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder addCustomLearnedIpRanges(
        int index, com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange value) {
      if (customLearnedIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.add(index, value);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder addCustomLearnedIpRanges(
        com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder builderForValue) {
      if (customLearnedIpRangesBuilder_ == null) {
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder addCustomLearnedIpRanges(
        int index,
        com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder builderForValue) {
      if (customLearnedIpRangesBuilder_ == null) {
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder addAllCustomLearnedIpRanges(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange>
            values) {
      if (customLearnedIpRangesBuilder_ == null) {
        ensureCustomLearnedIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customLearnedIpRanges_);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder clearCustomLearnedIpRanges() {
      if (customLearnedIpRangesBuilder_ == null) {
        customLearnedIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public Builder removeCustomLearnedIpRanges(int index) {
      if (customLearnedIpRangesBuilder_ == null) {
        ensureCustomLearnedIpRangesIsMutable();
        customLearnedIpRanges_.remove(index);
        onChanged();
      } else {
        customLearnedIpRangesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder
        getCustomLearnedIpRangesBuilder(int index) {
      return getCustomLearnedIpRangesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder
        getCustomLearnedIpRangesOrBuilder(int index) {
      if (customLearnedIpRangesBuilder_ == null) {
        return customLearnedIpRanges_.get(index);
      } else {
        return customLearnedIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder>
        getCustomLearnedIpRangesOrBuilderList() {
      if (customLearnedIpRangesBuilder_ != null) {
        return customLearnedIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(customLearnedIpRanges_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder
        addCustomLearnedIpRangesBuilder() {
      return getCustomLearnedIpRangesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder
        addCustomLearnedIpRangesBuilder(int index) {
      return getCustomLearnedIpRangesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of user-defined custom learned route IP address ranges for a BGP session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange custom_learned_ip_ranges = 481363012;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder>
        getCustomLearnedIpRangesBuilderList() {
      return getCustomLearnedIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange,
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder,
            com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder>
        getCustomLearnedIpRangesFieldBuilder() {
      if (customLearnedIpRangesBuilder_ == null) {
        customLearnedIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange,
                com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRange.Builder,
                com.google.cloud.compute.v1.RouterBgpPeerCustomLearnedIpRangeOrBuilder>(
                customLearnedIpRanges_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        customLearnedIpRanges_ = null;
      }
      return customLearnedIpRangesBuilder_;
    }

    private int customLearnedRoutePriority_;

    /**
     *
     *
     * <pre>
     * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
     * </pre>
     *
     * <code>optional int32 custom_learned_route_priority = 330412356;</code>
     *
     * @return Whether the customLearnedRoutePriority field is set.
     */
    @java.lang.Override
    public boolean hasCustomLearnedRoutePriority() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
     * </pre>
     *
     * <code>optional int32 custom_learned_route_priority = 330412356;</code>
     *
     * @return The customLearnedRoutePriority.
     */
    @java.lang.Override
    public int getCustomLearnedRoutePriority() {
      return customLearnedRoutePriority_;
    }

    /**
     *
     *
     * <pre>
     * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
     * </pre>
     *
     * <code>optional int32 custom_learned_route_priority = 330412356;</code>
     *
     * @param value The customLearnedRoutePriority to set.
     * @return This builder for chaining.
     */
    public Builder setCustomLearnedRoutePriority(int value) {

      customLearnedRoutePriority_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The user-defined custom learned route priority for a BGP session. This value is applied to all custom learned route ranges for the session. You can choose a value from `0` to `65335`. If you don't provide a value, Google Cloud assigns a priority of `100` to the ranges.
     * </pre>
     *
     * <code>optional int32 custom_learned_route_priority = 330412356;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomLearnedRoutePriority() {
      bitField0_ = (bitField0_ & ~0x00000040);
      customLearnedRoutePriority_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object enable_ = "";

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @return Whether the enable field is set.
     */
    public boolean hasEnable() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @return The enable.
     */
    public java.lang.String getEnable() {
      java.lang.Object ref = enable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @return The bytes for enable.
     */
    public com.google.protobuf.ByteString getEnableBytes() {
      java.lang.Object ref = enable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        enable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @param value The enable to set.
     * @return This builder for chaining.
     */
    public Builder setEnable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      enable_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnable() {
      enable_ = getDefaultInstance().getEnable();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
     * Check the Enable enum for the list of possible values.
     * </pre>
     *
     * <code>optional string enable = 311764355;</code>
     *
     * @param value The bytes for enable to set.
     * @return This builder for chaining.
     */
    public Builder setEnableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      enable_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean enableIpv4_;

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return Whether the enableIpv4 field is set.
     */
    @java.lang.Override
    public boolean hasEnableIpv4() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return The enableIpv4.
     */
    @java.lang.Override
    public boolean getEnableIpv4() {
      return enableIpv4_;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @param value The enableIpv4 to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpv4(boolean value) {

      enableIpv4_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv4 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 4.
     * </pre>
     *
     * <code>optional bool enable_ipv4 = 181467937;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpv4() {
      bitField0_ = (bitField0_ & ~0x00000100);
      enableIpv4_ = false;
      onChanged();
      return this;
    }

    private boolean enableIpv6_;

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return Whether the enableIpv6 field is set.
     */
    @java.lang.Override
    public boolean hasEnableIpv6() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return The enableIpv6.
     */
    @java.lang.Override
    public boolean getEnableIpv6() {
      return enableIpv6_;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @param value The enableIpv6 to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIpv6(boolean value) {

      enableIpv6_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable IPv6 traffic over BGP Peer. It is enabled by default if the peerIpAddress is version 6.
     * </pre>
     *
     * <code>optional bool enable_ipv6 = 181467939;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIpv6() {
      bitField0_ = (bitField0_ & ~0x00000200);
      enableIpv6_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList exportPolicies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExportPoliciesIsMutable() {
      if (!exportPolicies_.isModifiable()) {
        exportPolicies_ = new com.google.protobuf.LazyStringArrayList(exportPolicies_);
      }
      bitField0_ |= 0x00000400;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @return A list containing the exportPolicies.
     */
    public com.google.protobuf.ProtocolStringList getExportPoliciesList() {
      exportPolicies_.makeImmutable();
      return exportPolicies_;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @return The count of exportPolicies.
     */
    public int getExportPoliciesCount() {
      return exportPolicies_.size();
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param index The index of the element to return.
     * @return The exportPolicies at the given index.
     */
    public java.lang.String getExportPolicies(int index) {
      return exportPolicies_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exportPolicies at the given index.
     */
    public com.google.protobuf.ByteString getExportPoliciesBytes(int index) {
      return exportPolicies_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param index The index to set the value at.
     * @param value The exportPolicies to set.
     * @return This builder for chaining.
     */
    public Builder setExportPolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExportPoliciesIsMutable();
      exportPolicies_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param value The exportPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addExportPolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExportPoliciesIsMutable();
      exportPolicies_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param values The exportPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addAllExportPolicies(java.lang.Iterable<java.lang.String> values) {
      ensureExportPoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exportPolicies_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExportPolicies() {
      exportPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of export policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_EXPORT type.
     * </pre>
     *
     * <code>repeated string export_policies = 134084987;</code>
     *
     * @param value The bytes of the exportPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addExportPoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExportPoliciesIsMutable();
      exportPolicies_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList importPolicies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureImportPoliciesIsMutable() {
      if (!importPolicies_.isModifiable()) {
        importPolicies_ = new com.google.protobuf.LazyStringArrayList(importPolicies_);
      }
      bitField0_ |= 0x00000800;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @return A list containing the importPolicies.
     */
    public com.google.protobuf.ProtocolStringList getImportPoliciesList() {
      importPolicies_.makeImmutable();
      return importPolicies_;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @return The count of importPolicies.
     */
    public int getImportPoliciesCount() {
      return importPolicies_.size();
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param index The index of the element to return.
     * @return The importPolicies at the given index.
     */
    public java.lang.String getImportPolicies(int index) {
      return importPolicies_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the importPolicies at the given index.
     */
    public com.google.protobuf.ByteString getImportPoliciesBytes(int index) {
      return importPolicies_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param index The index to set the value at.
     * @param value The importPolicies to set.
     * @return This builder for chaining.
     */
    public Builder setImportPolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImportPoliciesIsMutable();
      importPolicies_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param value The importPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addImportPolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImportPoliciesIsMutable();
      importPolicies_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param values The importPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addAllImportPolicies(java.lang.Iterable<java.lang.String> values) {
      ensureImportPoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, importPolicies_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportPolicies() {
      importPolicies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of import policies applied to this peer, in the order they must be evaluated. The name must correspond to an existing policy that has ROUTE_POLICY_TYPE_IMPORT type.
     * </pre>
     *
     * <code>repeated string import_policies = 451147946;</code>
     *
     * @param value The bytes of the importPolicies to add.
     * @return This builder for chaining.
     */
    public Builder addImportPoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureImportPoliciesIsMutable();
      importPolicies_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object interfaceName_ = "";

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @return Whether the interfaceName field is set.
     */
    public boolean hasInterfaceName() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @return The interfaceName.
     */
    public java.lang.String getInterfaceName() {
      java.lang.Object ref = interfaceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interfaceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @return The bytes for interfaceName.
     */
    public com.google.protobuf.ByteString getInterfaceNameBytes() {
      java.lang.Object ref = interfaceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interfaceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @param value The interfaceName to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interfaceName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterfaceName() {
      interfaceName_ = getDefaultInstance().getInterfaceName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the interface the BGP peer is associated with.
     * </pre>
     *
     * <code>optional string interface_name = 437854673;</code>
     *
     * @param value The bytes for interfaceName to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interfaceName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object ipAddress_ = "";

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return Whether the ipAddress field is set.
     */
    public boolean hasIpAddress() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipAddress_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {
      ipAddress_ = getDefaultInstance().getIpAddress();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ip_address = 406272220;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipAddress_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object ipv4NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return Whether the ipv4NexthopAddress field is set.
     */
    public boolean hasIpv4NexthopAddress() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return The ipv4NexthopAddress.
     */
    public java.lang.String getIpv4NexthopAddress() {
      java.lang.Object ref = ipv4NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv4NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return The bytes for ipv4NexthopAddress.
     */
    public com.google.protobuf.ByteString getIpv4NexthopAddressBytes() {
      java.lang.Object ref = ipv4NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv4NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @param value The ipv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv4NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv4NexthopAddress_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv4NexthopAddress() {
      ipv4NexthopAddress_ = getDefaultInstance().getIpv4NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv4_nexthop_address = 5703377;</code>
     *
     * @param value The bytes for ipv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv4NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv4NexthopAddress_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object ipv6NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return Whether the ipv6NexthopAddress field is set.
     */
    public boolean hasIpv6NexthopAddress() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return The ipv6NexthopAddress.
     */
    public java.lang.String getIpv6NexthopAddress() {
      java.lang.Object ref = ipv6NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipv6NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return The bytes for ipv6NexthopAddress.
     */
    public com.google.protobuf.ByteString getIpv6NexthopAddressBytes() {
      java.lang.Object ref = ipv6NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipv6NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @param value The ipv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipv6NexthopAddress_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv6NexthopAddress() {
      ipv6NexthopAddress_ = getDefaultInstance().getIpv6NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the interface inside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string ipv6_nexthop_address = 27968211;</code>
     *
     * @param value The bytes for ipv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipv6NexthopAddress_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object managementType_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return Whether the managementType field is set.
     */
    public boolean hasManagementType() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return The managementType.
     */
    public java.lang.String getManagementType() {
      java.lang.Object ref = managementType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        managementType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return The bytes for managementType.
     */
    public com.google.protobuf.ByteString getManagementTypeBytes() {
      java.lang.Object ref = managementType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        managementType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @param value The managementType to set.
     * @return This builder for chaining.
     */
    public Builder setManagementType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      managementType_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearManagementType() {
      managementType_ = getDefaultInstance().getManagementType();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
     * Check the ManagementType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string management_type = 173703606;</code>
     *
     * @param value The bytes for managementType to set.
     * @return This builder for chaining.
     */
    public Builder setManagementTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      managementType_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object md5AuthenticationKeyName_ = "";

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @return Whether the md5AuthenticationKeyName field is set.
     */
    public boolean hasMd5AuthenticationKeyName() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @return The md5AuthenticationKeyName.
     */
    public java.lang.String getMd5AuthenticationKeyName() {
      java.lang.Object ref = md5AuthenticationKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        md5AuthenticationKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @return The bytes for md5AuthenticationKeyName.
     */
    public com.google.protobuf.ByteString getMd5AuthenticationKeyNameBytes() {
      java.lang.Object ref = md5AuthenticationKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        md5AuthenticationKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @param value The md5AuthenticationKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setMd5AuthenticationKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      md5AuthenticationKeyName_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMd5AuthenticationKeyName() {
      md5AuthenticationKeyName_ = getDefaultInstance().getMd5AuthenticationKeyName();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Present if MD5 authentication is enabled for the peering. Must be the name of one of the entries in the Router.md5_authentication_keys. The field must comply with RFC1035.
     * </pre>
     *
     * <code>optional string md5_authentication_key_name = 281075345;</code>
     *
     * @param value The bytes for md5AuthenticationKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setMd5AuthenticationKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      md5AuthenticationKeyName_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of this BGP peer. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int peerAsn_;

    /**
     *
     *
     * <pre>
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     * </pre>
     *
     * <code>optional uint32 peer_asn = 69573151;</code>
     *
     * @return Whether the peerAsn field is set.
     */
    @java.lang.Override
    public boolean hasPeerAsn() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     * </pre>
     *
     * <code>optional uint32 peer_asn = 69573151;</code>
     *
     * @return The peerAsn.
     */
    @java.lang.Override
    public int getPeerAsn() {
      return peerAsn_;
    }

    /**
     *
     *
     * <pre>
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     * </pre>
     *
     * <code>optional uint32 peer_asn = 69573151;</code>
     *
     * @param value The peerAsn to set.
     * @return This builder for chaining.
     */
    public Builder setPeerAsn(int value) {

      peerAsn_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Peer BGP Autonomous System Number (ASN). Each BGP interface may use a different value.
     * </pre>
     *
     * <code>optional uint32 peer_asn = 69573151;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerAsn() {
      bitField0_ = (bitField0_ & ~0x00080000);
      peerAsn_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpAddress_ = "";

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return Whether the peerIpAddress field is set.
     */
    public boolean hasPeerIpAddress() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The peerIpAddress.
     */
    public java.lang.String getPeerIpAddress() {
      java.lang.Object ref = peerIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The bytes for peerIpAddress.
     */
    public com.google.protobuf.ByteString getPeerIpAddressBytes() {
      java.lang.Object ref = peerIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpAddress_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpAddress() {
      peerIpAddress_ = getDefaultInstance().getPeerIpAddress();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IP address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The bytes for peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpAddress_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpv4NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return Whether the peerIpv4NexthopAddress field is set.
     */
    public boolean hasPeerIpv4NexthopAddress() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return The peerIpv4NexthopAddress.
     */
    public java.lang.String getPeerIpv4NexthopAddress() {
      java.lang.Object ref = peerIpv4NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpv4NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return The bytes for peerIpv4NexthopAddress.
     */
    public com.google.protobuf.ByteString getPeerIpv4NexthopAddressBytes() {
      java.lang.Object ref = peerIpv4NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpv4NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @param value The peerIpv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv4NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpv4NexthopAddress_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpv4NexthopAddress() {
      peerIpv4NexthopAddress_ = getDefaultInstance().getPeerIpv4NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv4 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv4_nexthop_address = 469221774;</code>
     *
     * @param value The bytes for peerIpv4NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv4NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpv4NexthopAddress_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpv6NexthopAddress_ = "";

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return Whether the peerIpv6NexthopAddress field is set.
     */
    public boolean hasPeerIpv6NexthopAddress() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return The peerIpv6NexthopAddress.
     */
    public java.lang.String getPeerIpv6NexthopAddress() {
      java.lang.Object ref = peerIpv6NexthopAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpv6NexthopAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return The bytes for peerIpv6NexthopAddress.
     */
    public com.google.protobuf.ByteString getPeerIpv6NexthopAddressBytes() {
      java.lang.Object ref = peerIpv6NexthopAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpv6NexthopAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @param value The peerIpv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv6NexthopAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpv6NexthopAddress_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpv6NexthopAddress() {
      peerIpv6NexthopAddress_ = getDefaultInstance().getPeerIpv6NexthopAddress();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * IPv6 address of the BGP interface outside Google Cloud Platform.
     * </pre>
     *
     * <code>optional string peer_ipv6_nexthop_address = 491486608;</code>
     *
     * @param value The bytes for peerIpv6NexthopAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpv6NexthopAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpv6NexthopAddress_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object routerApplianceInstance_ = "";

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return Whether the routerApplianceInstance field is set.
     */
    public boolean hasRouterApplianceInstance() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return The routerApplianceInstance.
     */
    public java.lang.String getRouterApplianceInstance() {
      java.lang.Object ref = routerApplianceInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routerApplianceInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return The bytes for routerApplianceInstance.
     */
    public com.google.protobuf.ByteString getRouterApplianceInstanceBytes() {
      java.lang.Object ref = routerApplianceInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routerApplianceInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @param value The routerApplianceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setRouterApplianceInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routerApplianceInstance_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouterApplianceInstance() {
      routerApplianceInstance_ = getDefaultInstance().getRouterApplianceInstance();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the VM instance that is used as third-party router appliances such as Next Gen Firewalls, Virtual Routers, or Router Appliances. The VM instance must be located in zones contained in the same region as this Cloud Router. The VM instance is the peer side of the BGP session.
     * </pre>
     *
     * <code>optional string router_appliance_instance = 468312989;</code>
     *
     * @param value The bytes for routerApplianceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setRouterApplianceInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routerApplianceInstance_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterBgpPeer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterBgpPeer)
  private static final com.google.cloud.compute.v1.RouterBgpPeer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterBgpPeer();
  }

  public static com.google.cloud.compute.v1.RouterBgpPeer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterBgpPeer> PARSER =
      new com.google.protobuf.AbstractParser<RouterBgpPeer>() {
        @java.lang.Override
        public RouterBgpPeer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterBgpPeer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterBgpPeer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterBgpPeer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
