/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterNat}
 */
public final class RouterNat extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterNat)
    RouterNatOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterNat.newBuilder() to construct.
  private RouterNat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterNat() {
    autoNetworkTier_ = "";
    drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    endpointTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    name_ = "";
    nat64Subnetworks_ = java.util.Collections.emptyList();
    natIpAllocateOption_ = "";
    natIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
    rules_ = java.util.Collections.emptyList();
    sourceSubnetworkIpRangesToNat_ = "";
    sourceSubnetworkIpRangesToNat64_ = "";
    subnetworks_ = java.util.Collections.emptyList();
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterNat();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNat_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNat_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterNat.class,
            com.google.cloud.compute.v1.RouterNat.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.AutoNetworkTier}
   */
  public enum AutoNetworkTier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AUTO_NETWORK_TIER = 0;</code>
     */
    UNDEFINED_AUTO_NETWORK_TIER(0),
    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    FIXED_STANDARD(310464328),
    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    PREMIUM(399530551),
    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    STANDARD(484642493),
    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    STANDARD_OVERRIDES_FIXED_STANDARD(465847234),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AUTO_NETWORK_TIER = 0;</code>
     */
    public static final int UNDEFINED_AUTO_NETWORK_TIER_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    public static final int FIXED_STANDARD_VALUE = 310464328;

    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    public static final int PREMIUM_VALUE = 399530551;

    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    public static final int STANDARD_VALUE = 484642493;

    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    public static final int STANDARD_OVERRIDES_FIXED_STANDARD_VALUE = 465847234;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutoNetworkTier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AutoNetworkTier forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_AUTO_NETWORK_TIER;
        case 310464328:
          return FIXED_STANDARD;
        case 399530551:
          return PREMIUM;
        case 484642493:
          return STANDARD;
        case 465847234:
          return STANDARD_OVERRIDES_FIXED_STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AutoNetworkTier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AutoNetworkTier>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AutoNetworkTier>() {
              public AutoNetworkTier findValueByNumber(int number) {
                return AutoNetworkTier.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(0);
    }

    private static final AutoNetworkTier[] VALUES = values();

    public static AutoNetworkTier valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AutoNetworkTier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.AutoNetworkTier)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.EndpointTypes}
   */
  public enum EndpointTypes implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENDPOINT_TYPES = 0;</code>
     */
    UNDEFINED_ENDPOINT_TYPES(0),
    /**
     *
     *
     * <pre>
     * This is used for regional Application Load Balancers (internal and external) and regional proxy Network Load Balancers (internal and external) endpoints.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_MANAGED_PROXY_LB = 439196930;</code>
     */
    ENDPOINT_TYPE_MANAGED_PROXY_LB(439196930),
    /**
     *
     *
     * <pre>
     * This is used for Secure Web Gateway endpoints.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_SWG = 159344456;</code>
     */
    ENDPOINT_TYPE_SWG(159344456),
    /**
     *
     *
     * <pre>
     * This is the default.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_VM = 57095474;</code>
     */
    ENDPOINT_TYPE_VM(57095474),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ENDPOINT_TYPES = 0;</code>
     */
    public static final int UNDEFINED_ENDPOINT_TYPES_VALUE = 0;

    /**
     *
     *
     * <pre>
     * This is used for regional Application Load Balancers (internal and external) and regional proxy Network Load Balancers (internal and external) endpoints.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_MANAGED_PROXY_LB = 439196930;</code>
     */
    public static final int ENDPOINT_TYPE_MANAGED_PROXY_LB_VALUE = 439196930;

    /**
     *
     *
     * <pre>
     * This is used for Secure Web Gateway endpoints.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_SWG = 159344456;</code>
     */
    public static final int ENDPOINT_TYPE_SWG_VALUE = 159344456;

    /**
     *
     *
     * <pre>
     * This is the default.
     * </pre>
     *
     * <code>ENDPOINT_TYPE_VM = 57095474;</code>
     */
    public static final int ENDPOINT_TYPE_VM_VALUE = 57095474;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EndpointTypes valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EndpointTypes forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ENDPOINT_TYPES;
        case 439196930:
          return ENDPOINT_TYPE_MANAGED_PROXY_LB;
        case 159344456:
          return ENDPOINT_TYPE_SWG;
        case 57095474:
          return ENDPOINT_TYPE_VM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EndpointTypes> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EndpointTypes> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EndpointTypes>() {
          public EndpointTypes findValueByNumber(int number) {
            return EndpointTypes.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(1);
    }

    private static final EndpointTypes[] VALUES = values();

    public static EndpointTypes valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EndpointTypes(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.EndpointTypes)
  }

  /**
   *
   *
   * <pre>
   * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.NatIpAllocateOption}
   */
  public enum NatIpAllocateOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NAT_IP_ALLOCATE_OPTION = 0;</code>
     */
    UNDEFINED_NAT_IP_ALLOCATE_OPTION(0),
    /**
     *
     *
     * <pre>
     * Nat IPs are allocated by GCP; customers can not specify any Nat IPs.
     * </pre>
     *
     * <code>AUTO_ONLY = 182333500;</code>
     */
    AUTO_ONLY(182333500),
    /**
     *
     *
     * <pre>
     * Only use Nat IPs provided by customers. When specified Nat IPs are not enough then the Nat service fails for new VMs.
     * </pre>
     *
     * <code>MANUAL_ONLY = 261251205;</code>
     */
    MANUAL_ONLY(261251205),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NAT_IP_ALLOCATE_OPTION = 0;</code>
     */
    public static final int UNDEFINED_NAT_IP_ALLOCATE_OPTION_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Nat IPs are allocated by GCP; customers can not specify any Nat IPs.
     * </pre>
     *
     * <code>AUTO_ONLY = 182333500;</code>
     */
    public static final int AUTO_ONLY_VALUE = 182333500;

    /**
     *
     *
     * <pre>
     * Only use Nat IPs provided by customers. When specified Nat IPs are not enough then the Nat service fails for new VMs.
     * </pre>
     *
     * <code>MANUAL_ONLY = 261251205;</code>
     */
    public static final int MANUAL_ONLY_VALUE = 261251205;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NatIpAllocateOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NatIpAllocateOption forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_NAT_IP_ALLOCATE_OPTION;
        case 182333500:
          return AUTO_ONLY;
        case 261251205:
          return MANUAL_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NatIpAllocateOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NatIpAllocateOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NatIpAllocateOption>() {
              public NatIpAllocateOption findValueByNumber(int number) {
                return NatIpAllocateOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(2);
    }

    private static final NatIpAllocateOption[] VALUES = values();

    public static NatIpAllocateOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NatIpAllocateOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.NatIpAllocateOption)
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat}
   */
  public enum SourceSubnetworkIpRangesToNat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT = 0;</code>
     */
    UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT(0),
    /**
     *
     *
     * <pre>
     * All the IP ranges in every Subnetwork are allowed to Nat.
     * </pre>
     *
     * <code>ALL_SUBNETWORKS_ALL_IP_RANGES = 179964376;</code>
     */
    ALL_SUBNETWORKS_ALL_IP_RANGES(179964376),
    /**
     *
     *
     * <pre>
     * All the primary IP ranges in every Subnetwork are allowed to Nat.
     * </pre>
     *
     * <code>ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES = 185573819;</code>
     */
    ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES(185573819),
    /**
     *
     *
     * <pre>
     * A list of Subnetworks are allowed to Nat (specified in the field subnetwork below)
     * </pre>
     *
     * <code>LIST_OF_SUBNETWORKS = 517542270;</code>
     */
    LIST_OF_SUBNETWORKS(517542270),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT = 0;</code>
     */
    public static final int UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT_VALUE = 0;

    /**
     *
     *
     * <pre>
     * All the IP ranges in every Subnetwork are allowed to Nat.
     * </pre>
     *
     * <code>ALL_SUBNETWORKS_ALL_IP_RANGES = 179964376;</code>
     */
    public static final int ALL_SUBNETWORKS_ALL_IP_RANGES_VALUE = 179964376;

    /**
     *
     *
     * <pre>
     * All the primary IP ranges in every Subnetwork are allowed to Nat.
     * </pre>
     *
     * <code>ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES = 185573819;</code>
     */
    public static final int ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES_VALUE = 185573819;

    /**
     *
     *
     * <pre>
     * A list of Subnetworks are allowed to Nat (specified in the field subnetwork below)
     * </pre>
     *
     * <code>LIST_OF_SUBNETWORKS = 517542270;</code>
     */
    public static final int LIST_OF_SUBNETWORKS_VALUE = 517542270;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceSubnetworkIpRangesToNat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SourceSubnetworkIpRangesToNat forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT;
        case 179964376:
          return ALL_SUBNETWORKS_ALL_IP_RANGES;
        case 185573819:
          return ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES;
        case 517542270:
          return LIST_OF_SUBNETWORKS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat>() {
              public SourceSubnetworkIpRangesToNat findValueByNumber(int number) {
                return SourceSubnetworkIpRangesToNat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(3);
    }

    private static final SourceSubnetworkIpRangesToNat[] VALUES = values();

    public static SourceSubnetworkIpRangesToNat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SourceSubnetworkIpRangesToNat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat)
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat64}
   */
  public enum SourceSubnetworkIpRangesToNat64 implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64 = 0;</code>
     */
    UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64(0),
    /**
     *
     *
     * <pre>
     * NAT64 is enabled for all the IPv6 subnet ranges. In dual stack subnets, NAT64 will only be enabled for IPv6-only VMs.
     * </pre>
     *
     * <code>ALL_IPV6_SUBNETWORKS = 341632747;</code>
     */
    ALL_IPV6_SUBNETWORKS(341632747),
    /**
     *
     *
     * <pre>
     * NAT64 is enabled for a list of IPv6 subnet ranges. In dual stack subnets, NAT64 will only be enabled for IPv6-only VMs. If this option is used, the nat64_subnetworks field must be specified.
     * </pre>
     *
     * <code>LIST_OF_IPV6_SUBNETWORKS = 521079860;</code>
     */
    LIST_OF_IPV6_SUBNETWORKS(521079860),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64 = 0;</code>
     */
    public static final int UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64_VALUE = 0;

    /**
     *
     *
     * <pre>
     * NAT64 is enabled for all the IPv6 subnet ranges. In dual stack subnets, NAT64 will only be enabled for IPv6-only VMs.
     * </pre>
     *
     * <code>ALL_IPV6_SUBNETWORKS = 341632747;</code>
     */
    public static final int ALL_IPV6_SUBNETWORKS_VALUE = 341632747;

    /**
     *
     *
     * <pre>
     * NAT64 is enabled for a list of IPv6 subnet ranges. In dual stack subnets, NAT64 will only be enabled for IPv6-only VMs. If this option is used, the nat64_subnetworks field must be specified.
     * </pre>
     *
     * <code>LIST_OF_IPV6_SUBNETWORKS = 521079860;</code>
     */
    public static final int LIST_OF_IPV6_SUBNETWORKS_VALUE = 521079860;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceSubnetworkIpRangesToNat64 valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SourceSubnetworkIpRangesToNat64 forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64;
        case 341632747:
          return ALL_IPV6_SUBNETWORKS;
        case 521079860:
          return LIST_OF_IPV6_SUBNETWORKS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat64>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat64>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SourceSubnetworkIpRangesToNat64>() {
              public SourceSubnetworkIpRangesToNat64 findValueByNumber(int number) {
                return SourceSubnetworkIpRangesToNat64.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(4);
    }

    private static final SourceSubnetworkIpRangesToNat64[] VALUES = values();

    public static SourceSubnetworkIpRangesToNat64 valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SourceSubnetworkIpRangesToNat64(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat64)
  }

  /**
   *
   *
   * <pre>
   * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNat.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * NAT used for private IP translation.
     * </pre>
     *
     * <code>PRIVATE = 403485027;</code>
     */
    PRIVATE(403485027),
    /**
     *
     *
     * <pre>
     * NAT used for public IP translation. This is the default.
     * </pre>
     *
     * <code>PUBLIC = 223389289;</code>
     */
    PUBLIC(223389289),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * NAT used for private IP translation.
     * </pre>
     *
     * <code>PRIVATE = 403485027;</code>
     */
    public static final int PRIVATE_VALUE = 403485027;

    /**
     *
     *
     * <pre>
     * NAT used for public IP translation. This is the default.
     * </pre>
     *
     * <code>PUBLIC = 223389289;</code>
     */
    public static final int PUBLIC_VALUE = 223389289;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 403485027:
          return PRIVATE;
        case 223389289:
          return PUBLIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNat.getDescriptor().getEnumTypes().get(5);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNat.Type)
  }

  private int bitField0_;
  public static final int AUTO_NETWORK_TIER_FIELD_NUMBER = 269770211;

  @SuppressWarnings("serial")
  private volatile java.lang.Object autoNetworkTier_ = "";

  /**
   *
   *
   * <pre>
   * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
   * Check the AutoNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string auto_network_tier = 269770211;</code>
   *
   * @return Whether the autoNetworkTier field is set.
   */
  @java.lang.Override
  public boolean hasAutoNetworkTier() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
   * Check the AutoNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string auto_network_tier = 269770211;</code>
   *
   * @return The autoNetworkTier.
   */
  @java.lang.Override
  public java.lang.String getAutoNetworkTier() {
    java.lang.Object ref = autoNetworkTier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      autoNetworkTier_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
   * Check the AutoNetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string auto_network_tier = 269770211;</code>
   *
   * @return The bytes for autoNetworkTier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAutoNetworkTierBytes() {
    java.lang.Object ref = autoNetworkTier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      autoNetworkTier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DRAIN_NAT_IPS_FIELD_NUMBER = 504078535;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList drainNatIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @return A list containing the drainNatIps.
   */
  public com.google.protobuf.ProtocolStringList getDrainNatIpsList() {
    return drainNatIps_;
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @return The count of drainNatIps.
   */
  public int getDrainNatIpsCount() {
    return drainNatIps_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @param index The index of the element to return.
   * @return The drainNatIps at the given index.
   */
  public java.lang.String getDrainNatIps(int index) {
    return drainNatIps_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
   * </pre>
   *
   * <code>repeated string drain_nat_ips = 504078535;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the drainNatIps at the given index.
   */
  public com.google.protobuf.ByteString getDrainNatIpsBytes(int index) {
    return drainNatIps_.getByteString(index);
  }

  public static final int ENABLE_DYNAMIC_PORT_ALLOCATION_FIELD_NUMBER = 532106402;
  private boolean enableDynamicPortAllocation_ = false;

  /**
   *
   *
   * <pre>
   * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
   * </pre>
   *
   * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
   *
   * @return Whether the enableDynamicPortAllocation field is set.
   */
  @java.lang.Override
  public boolean hasEnableDynamicPortAllocation() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
   * </pre>
   *
   * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
   *
   * @return The enableDynamicPortAllocation.
   */
  @java.lang.Override
  public boolean getEnableDynamicPortAllocation() {
    return enableDynamicPortAllocation_;
  }

  public static final int ENABLE_ENDPOINT_INDEPENDENT_MAPPING_FIELD_NUMBER = 259441819;
  private boolean enableEndpointIndependentMapping_ = false;

  /**
   * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
   *
   * @return Whether the enableEndpointIndependentMapping field is set.
   */
  @java.lang.Override
  public boolean hasEnableEndpointIndependentMapping() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
   *
   * @return The enableEndpointIndependentMapping.
   */
  @java.lang.Override
  public boolean getEnableEndpointIndependentMapping() {
    return enableEndpointIndependentMapping_;
  }

  public static final int ENDPOINT_TYPES_FIELD_NUMBER = 502633807;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList endpointTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
   * Check the EndpointTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string endpoint_types = 502633807;</code>
   *
   * @return A list containing the endpointTypes.
   */
  public com.google.protobuf.ProtocolStringList getEndpointTypesList() {
    return endpointTypes_;
  }

  /**
   *
   *
   * <pre>
   * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
   * Check the EndpointTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string endpoint_types = 502633807;</code>
   *
   * @return The count of endpointTypes.
   */
  public int getEndpointTypesCount() {
    return endpointTypes_.size();
  }

  /**
   *
   *
   * <pre>
   * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
   * Check the EndpointTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string endpoint_types = 502633807;</code>
   *
   * @param index The index of the element to return.
   * @return The endpointTypes at the given index.
   */
  public java.lang.String getEndpointTypes(int index) {
    return endpointTypes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
   * Check the EndpointTypes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string endpoint_types = 502633807;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the endpointTypes at the given index.
   */
  public com.google.protobuf.ByteString getEndpointTypesBytes(int index) {
    return endpointTypes_.getByteString(index);
  }

  public static final int ICMP_IDLE_TIMEOUT_SEC_FIELD_NUMBER = 3647562;
  private int icmpIdleTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
   *
   * @return Whether the icmpIdleTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasIcmpIdleTimeoutSec() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
   *
   * @return The icmpIdleTimeoutSec.
   */
  @java.lang.Override
  public int getIcmpIdleTimeoutSec() {
    return icmpIdleTimeoutSec_;
  }

  public static final int LOG_CONFIG_FIELD_NUMBER = 351299741;
  private com.google.cloud.compute.v1.RouterNatLogConfig logConfig_;

  /**
   *
   *
   * <pre>
   * Configure logging on this NAT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  @java.lang.Override
  public boolean hasLogConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Configure logging on this NAT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatLogConfig getLogConfig() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.RouterNatLogConfig.getDefaultInstance()
        : logConfig_;
  }

  /**
   *
   *
   * <pre>
   * Configure logging on this NAT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatLogConfigOrBuilder getLogConfigOrBuilder() {
    return logConfig_ == null
        ? com.google.cloud.compute.v1.RouterNatLogConfig.getDefaultInstance()
        : logConfig_;
  }

  public static final int MAX_PORTS_PER_VM_FIELD_NUMBER = 250062049;
  private int maxPortsPerVm_ = 0;

  /**
   *
   *
   * <pre>
   * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
   * </pre>
   *
   * <code>optional int32 max_ports_per_vm = 250062049;</code>
   *
   * @return Whether the maxPortsPerVm field is set.
   */
  @java.lang.Override
  public boolean hasMaxPortsPerVm() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
   * </pre>
   *
   * <code>optional int32 max_ports_per_vm = 250062049;</code>
   *
   * @return The maxPortsPerVm.
   */
  @java.lang.Override
  public int getMaxPortsPerVm() {
    return maxPortsPerVm_;
  }

  public static final int MIN_PORTS_PER_VM_FIELD_NUMBER = 186193587;
  private int minPortsPerVm_ = 0;

  /**
   *
   *
   * <pre>
   * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
   * </pre>
   *
   * <code>optional int32 min_ports_per_vm = 186193587;</code>
   *
   * @return Whether the minPortsPerVm field is set.
   */
  @java.lang.Override
  public boolean hasMinPortsPerVm() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
   * </pre>
   *
   * <code>optional int32 min_ports_per_vm = 186193587;</code>
   *
   * @return The minPortsPerVm.
   */
  @java.lang.Override
  public int getMinPortsPerVm() {
    return minPortsPerVm_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAT64_SUBNETWORKS_FIELD_NUMBER = 63585701;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64> nat64Subnetworks_;

  /**
   *
   *
   * <pre>
   * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64>
      getNat64SubnetworksList() {
    return nat64Subnetworks_;
  }

  /**
   *
   *
   * <pre>
   * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder>
      getNat64SubnetworksOrBuilderList() {
    return nat64Subnetworks_;
  }

  /**
   *
   *
   * <pre>
   * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
   * </code>
   */
  @java.lang.Override
  public int getNat64SubnetworksCount() {
    return nat64Subnetworks_.size();
  }

  /**
   *
   *
   * <pre>
   * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 getNat64Subnetworks(int index) {
    return nat64Subnetworks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder
      getNat64SubnetworksOrBuilder(int index) {
    return nat64Subnetworks_.get(index);
  }

  public static final int NAT_IP_ALLOCATE_OPTION_FIELD_NUMBER = 429726845;

  @SuppressWarnings("serial")
  private volatile java.lang.Object natIpAllocateOption_ = "";

  /**
   *
   *
   * <pre>
   * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
   * Check the NatIpAllocateOption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string nat_ip_allocate_option = 429726845;</code>
   *
   * @return Whether the natIpAllocateOption field is set.
   */
  @java.lang.Override
  public boolean hasNatIpAllocateOption() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
   * Check the NatIpAllocateOption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string nat_ip_allocate_option = 429726845;</code>
   *
   * @return The natIpAllocateOption.
   */
  @java.lang.Override
  public java.lang.String getNatIpAllocateOption() {
    java.lang.Object ref = natIpAllocateOption_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      natIpAllocateOption_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
   * Check the NatIpAllocateOption enum for the list of possible values.
   * </pre>
   *
   * <code>optional string nat_ip_allocate_option = 429726845;</code>
   *
   * @return The bytes for natIpAllocateOption.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNatIpAllocateOptionBytes() {
    java.lang.Object ref = natIpAllocateOption_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      natIpAllocateOption_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAT_IPS_FIELD_NUMBER = 117635086;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList natIps_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
   * </pre>
   *
   * <code>repeated string nat_ips = 117635086;</code>
   *
   * @return A list containing the natIps.
   */
  public com.google.protobuf.ProtocolStringList getNatIpsList() {
    return natIps_;
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
   * </pre>
   *
   * <code>repeated string nat_ips = 117635086;</code>
   *
   * @return The count of natIps.
   */
  public int getNatIpsCount() {
    return natIps_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
   * </pre>
   *
   * <code>repeated string nat_ips = 117635086;</code>
   *
   * @param index The index of the element to return.
   * @return The natIps at the given index.
   */
  public java.lang.String getNatIps(int index) {
    return natIps_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
   * </pre>
   *
   * <code>repeated string nat_ips = 117635086;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the natIps at the given index.
   */
  public com.google.protobuf.ByteString getNatIpsBytes(int index) {
    return natIps_.getByteString(index);
  }

  public static final int RULES_FIELD_NUMBER = 108873975;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterNatRule> rules_;

  /**
   *
   *
   * <pre>
   * A list of rules associated with this NAT.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterNatRule> getRulesList() {
    return rules_;
  }

  /**
   *
   *
   * <pre>
   * A list of rules associated with this NAT.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterNatRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }

  /**
   *
   *
   * <pre>
   * A list of rules associated with this NAT.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of rules associated with this NAT.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRule getRules(int index) {
    return rules_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of rules associated with this NAT.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int SOURCE_SUBNETWORK_IP_RANGES_TO_NAT_FIELD_NUMBER = 252213211;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceSubnetworkIpRangesToNat_ = "";

  /**
   *
   *
   * <pre>
   * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
   * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
   *
   * @return Whether the sourceSubnetworkIpRangesToNat field is set.
   */
  @java.lang.Override
  public boolean hasSourceSubnetworkIpRangesToNat() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
   * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
   *
   * @return The sourceSubnetworkIpRangesToNat.
   */
  @java.lang.Override
  public java.lang.String getSourceSubnetworkIpRangesToNat() {
    java.lang.Object ref = sourceSubnetworkIpRangesToNat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceSubnetworkIpRangesToNat_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
   * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
   *
   * @return The bytes for sourceSubnetworkIpRangesToNat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceSubnetworkIpRangesToNatBytes() {
    java.lang.Object ref = sourceSubnetworkIpRangesToNat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceSubnetworkIpRangesToNat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64_FIELD_NUMBER = 248116185;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceSubnetworkIpRangesToNat64_ = "";

  /**
   *
   *
   * <pre>
   * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
   * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
   *
   * @return Whether the sourceSubnetworkIpRangesToNat64 field is set.
   */
  @java.lang.Override
  public boolean hasSourceSubnetworkIpRangesToNat64() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
   * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
   *
   * @return The sourceSubnetworkIpRangesToNat64.
   */
  @java.lang.Override
  public java.lang.String getSourceSubnetworkIpRangesToNat64() {
    java.lang.Object ref = sourceSubnetworkIpRangesToNat64_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceSubnetworkIpRangesToNat64_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
   * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
   *
   * @return The bytes for sourceSubnetworkIpRangesToNat64.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceSubnetworkIpRangesToNat64Bytes() {
    java.lang.Object ref = sourceSubnetworkIpRangesToNat64_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceSubnetworkIpRangesToNat64_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORKS_FIELD_NUMBER = 415853125;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat> subnetworks_;

  /**
   *
   *
   * <pre>
   * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat> getSubnetworksList() {
    return subnetworks_;
  }

  /**
   *
   *
   * <pre>
   * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder>
      getSubnetworksOrBuilderList() {
    return subnetworks_;
  }

  /**
   *
   *
   * <pre>
   * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public int getSubnetworksCount() {
    return subnetworks_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatSubnetworkToNat getSubnetworks(int index) {
    return subnetworks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder getSubnetworksOrBuilder(
      int index) {
    return subnetworks_.get(index);
  }

  public static final int TCP_ESTABLISHED_IDLE_TIMEOUT_SEC_FIELD_NUMBER = 223098349;
  private int tcpEstablishedIdleTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
   *
   * @return Whether the tcpEstablishedIdleTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasTcpEstablishedIdleTimeoutSec() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
   *
   * @return The tcpEstablishedIdleTimeoutSec.
   */
  @java.lang.Override
  public int getTcpEstablishedIdleTimeoutSec() {
    return tcpEstablishedIdleTimeoutSec_;
  }

  public static final int TCP_TIME_WAIT_TIMEOUT_SEC_FIELD_NUMBER = 513596925;
  private int tcpTimeWaitTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
   *
   * @return Whether the tcpTimeWaitTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasTcpTimeWaitTimeoutSec() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
   *
   * @return The tcpTimeWaitTimeoutSec.
   */
  @java.lang.Override
  public int getTcpTimeWaitTimeoutSec() {
    return tcpTimeWaitTimeoutSec_;
  }

  public static final int TCP_TRANSITORY_IDLE_TIMEOUT_SEC_FIELD_NUMBER = 205028774;
  private int tcpTransitoryIdleTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
   *
   * @return Whether the tcpTransitoryIdleTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasTcpTransitoryIdleTimeoutSec() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
   *
   * @return The tcpTransitoryIdleTimeoutSec.
   */
  @java.lang.Override
  public int getTcpTransitoryIdleTimeoutSec() {
    return tcpTransitoryIdleTimeoutSec_;
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UDP_IDLE_TIMEOUT_SEC_FIELD_NUMBER = 64919878;
  private int udpIdleTimeoutSec_ = 0;

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
   *
   * @return Whether the udpIdleTimeoutSec field is set.
   */
  @java.lang.Override
  public boolean hasUdpIdleTimeoutSec() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
   * </pre>
   *
   * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
   *
   * @return The udpIdleTimeoutSec.
   */
  @java.lang.Override
  public int getUdpIdleTimeoutSec() {
    return udpIdleTimeoutSec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(3647562, icmpIdleTimeoutSec_);
    }
    for (int i = 0; i < nat64Subnetworks_.size(); i++) {
      output.writeMessage(63585701, nat64Subnetworks_.get(i));
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeInt32(64919878, udpIdleTimeoutSec_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(108873975, rules_.get(i));
    }
    for (int i = 0; i < natIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 117635086, natIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(186193587, minPortsPerVm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(205028774, tcpTransitoryIdleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeInt32(223098349, tcpEstablishedIdleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 248116185, sourceSubnetworkIpRangesToNat64_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt32(250062049, maxPortsPerVm_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 252213211, sourceSubnetworkIpRangesToNat_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(259441819, enableEndpointIndependentMapping_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 269770211, autoNetworkTier_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(351299741, getLogConfig());
    }
    for (int i = 0; i < subnetworks_.size(); i++) {
      output.writeMessage(415853125, subnetworks_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 429726845, natIpAllocateOption_);
    }
    for (int i = 0; i < endpointTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 502633807, endpointTypes_.getRaw(i));
    }
    for (int i = 0; i < drainNatIps_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 504078535, drainNatIps_.getRaw(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeInt32(513596925, tcpTimeWaitTimeoutSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(532106402, enableDynamicPortAllocation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3647562, icmpIdleTimeoutSec_);
    }
    for (int i = 0; i < nat64Subnetworks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              63585701, nat64Subnetworks_.get(i));
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(64919878, udpIdleTimeoutSec_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(108873975, rules_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < natIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(natIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getNatIpsList().size();
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(186193587, minPortsPerVm_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              205028774, tcpTransitoryIdleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              223098349, tcpEstablishedIdleTimeoutSec_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              248116185, sourceSubnetworkIpRangesToNat64_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(250062049, maxPortsPerVm_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              252213211, sourceSubnetworkIpRangesToNat_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              259441819, enableEndpointIndependentMapping_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(269770211, autoNetworkTier_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(351299741, getLogConfig());
    }
    for (int i = 0; i < subnetworks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(415853125, subnetworks_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(429726845, natIpAllocateOption_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < endpointTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(endpointTypes_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getEndpointTypesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < drainNatIps_.size(); i++) {
        dataSize += computeStringSizeNoTag(drainNatIps_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDrainNatIpsList().size();
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(513596925, tcpTimeWaitTimeoutSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              532106402, enableDynamicPortAllocation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterNat)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterNat other = (com.google.cloud.compute.v1.RouterNat) obj;

    if (hasAutoNetworkTier() != other.hasAutoNetworkTier()) return false;
    if (hasAutoNetworkTier()) {
      if (!getAutoNetworkTier().equals(other.getAutoNetworkTier())) return false;
    }
    if (!getDrainNatIpsList().equals(other.getDrainNatIpsList())) return false;
    if (hasEnableDynamicPortAllocation() != other.hasEnableDynamicPortAllocation()) return false;
    if (hasEnableDynamicPortAllocation()) {
      if (getEnableDynamicPortAllocation() != other.getEnableDynamicPortAllocation()) return false;
    }
    if (hasEnableEndpointIndependentMapping() != other.hasEnableEndpointIndependentMapping())
      return false;
    if (hasEnableEndpointIndependentMapping()) {
      if (getEnableEndpointIndependentMapping() != other.getEnableEndpointIndependentMapping())
        return false;
    }
    if (!getEndpointTypesList().equals(other.getEndpointTypesList())) return false;
    if (hasIcmpIdleTimeoutSec() != other.hasIcmpIdleTimeoutSec()) return false;
    if (hasIcmpIdleTimeoutSec()) {
      if (getIcmpIdleTimeoutSec() != other.getIcmpIdleTimeoutSec()) return false;
    }
    if (hasLogConfig() != other.hasLogConfig()) return false;
    if (hasLogConfig()) {
      if (!getLogConfig().equals(other.getLogConfig())) return false;
    }
    if (hasMaxPortsPerVm() != other.hasMaxPortsPerVm()) return false;
    if (hasMaxPortsPerVm()) {
      if (getMaxPortsPerVm() != other.getMaxPortsPerVm()) return false;
    }
    if (hasMinPortsPerVm() != other.hasMinPortsPerVm()) return false;
    if (hasMinPortsPerVm()) {
      if (getMinPortsPerVm() != other.getMinPortsPerVm()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getNat64SubnetworksList().equals(other.getNat64SubnetworksList())) return false;
    if (hasNatIpAllocateOption() != other.hasNatIpAllocateOption()) return false;
    if (hasNatIpAllocateOption()) {
      if (!getNatIpAllocateOption().equals(other.getNatIpAllocateOption())) return false;
    }
    if (!getNatIpsList().equals(other.getNatIpsList())) return false;
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (hasSourceSubnetworkIpRangesToNat() != other.hasSourceSubnetworkIpRangesToNat())
      return false;
    if (hasSourceSubnetworkIpRangesToNat()) {
      if (!getSourceSubnetworkIpRangesToNat().equals(other.getSourceSubnetworkIpRangesToNat()))
        return false;
    }
    if (hasSourceSubnetworkIpRangesToNat64() != other.hasSourceSubnetworkIpRangesToNat64())
      return false;
    if (hasSourceSubnetworkIpRangesToNat64()) {
      if (!getSourceSubnetworkIpRangesToNat64().equals(other.getSourceSubnetworkIpRangesToNat64()))
        return false;
    }
    if (!getSubnetworksList().equals(other.getSubnetworksList())) return false;
    if (hasTcpEstablishedIdleTimeoutSec() != other.hasTcpEstablishedIdleTimeoutSec()) return false;
    if (hasTcpEstablishedIdleTimeoutSec()) {
      if (getTcpEstablishedIdleTimeoutSec() != other.getTcpEstablishedIdleTimeoutSec())
        return false;
    }
    if (hasTcpTimeWaitTimeoutSec() != other.hasTcpTimeWaitTimeoutSec()) return false;
    if (hasTcpTimeWaitTimeoutSec()) {
      if (getTcpTimeWaitTimeoutSec() != other.getTcpTimeWaitTimeoutSec()) return false;
    }
    if (hasTcpTransitoryIdleTimeoutSec() != other.hasTcpTransitoryIdleTimeoutSec()) return false;
    if (hasTcpTransitoryIdleTimeoutSec()) {
      if (getTcpTransitoryIdleTimeoutSec() != other.getTcpTransitoryIdleTimeoutSec()) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (hasUdpIdleTimeoutSec() != other.hasUdpIdleTimeoutSec()) return false;
    if (hasUdpIdleTimeoutSec()) {
      if (getUdpIdleTimeoutSec() != other.getUdpIdleTimeoutSec()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoNetworkTier()) {
      hash = (37 * hash) + AUTO_NETWORK_TIER_FIELD_NUMBER;
      hash = (53 * hash) + getAutoNetworkTier().hashCode();
    }
    if (getDrainNatIpsCount() > 0) {
      hash = (37 * hash) + DRAIN_NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getDrainNatIpsList().hashCode();
    }
    if (hasEnableDynamicPortAllocation()) {
      hash = (37 * hash) + ENABLE_DYNAMIC_PORT_ALLOCATION_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDynamicPortAllocation());
    }
    if (hasEnableEndpointIndependentMapping()) {
      hash = (37 * hash) + ENABLE_ENDPOINT_INDEPENDENT_MAPPING_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getEnableEndpointIndependentMapping());
    }
    if (getEndpointTypesCount() > 0) {
      hash = (37 * hash) + ENDPOINT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointTypesList().hashCode();
    }
    if (hasIcmpIdleTimeoutSec()) {
      hash = (37 * hash) + ICMP_IDLE_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getIcmpIdleTimeoutSec();
    }
    if (hasLogConfig()) {
      hash = (37 * hash) + LOG_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLogConfig().hashCode();
    }
    if (hasMaxPortsPerVm()) {
      hash = (37 * hash) + MAX_PORTS_PER_VM_FIELD_NUMBER;
      hash = (53 * hash) + getMaxPortsPerVm();
    }
    if (hasMinPortsPerVm()) {
      hash = (37 * hash) + MIN_PORTS_PER_VM_FIELD_NUMBER;
      hash = (53 * hash) + getMinPortsPerVm();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getNat64SubnetworksCount() > 0) {
      hash = (37 * hash) + NAT64_SUBNETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getNat64SubnetworksList().hashCode();
    }
    if (hasNatIpAllocateOption()) {
      hash = (37 * hash) + NAT_IP_ALLOCATE_OPTION_FIELD_NUMBER;
      hash = (53 * hash) + getNatIpAllocateOption().hashCode();
    }
    if (getNatIpsCount() > 0) {
      hash = (37 * hash) + NAT_IPS_FIELD_NUMBER;
      hash = (53 * hash) + getNatIpsList().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    if (hasSourceSubnetworkIpRangesToNat()) {
      hash = (37 * hash) + SOURCE_SUBNETWORK_IP_RANGES_TO_NAT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSubnetworkIpRangesToNat().hashCode();
    }
    if (hasSourceSubnetworkIpRangesToNat64()) {
      hash = (37 * hash) + SOURCE_SUBNETWORK_IP_RANGES_TO_NAT64_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSubnetworkIpRangesToNat64().hashCode();
    }
    if (getSubnetworksCount() > 0) {
      hash = (37 * hash) + SUBNETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetworksList().hashCode();
    }
    if (hasTcpEstablishedIdleTimeoutSec()) {
      hash = (37 * hash) + TCP_ESTABLISHED_IDLE_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getTcpEstablishedIdleTimeoutSec();
    }
    if (hasTcpTimeWaitTimeoutSec()) {
      hash = (37 * hash) + TCP_TIME_WAIT_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getTcpTimeWaitTimeoutSec();
    }
    if (hasTcpTransitoryIdleTimeoutSec()) {
      hash = (37 * hash) + TCP_TRANSITORY_IDLE_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getTcpTransitoryIdleTimeoutSec();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    if (hasUdpIdleTimeoutSec()) {
      hash = (37 * hash) + UDP_IDLE_TIMEOUT_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getUdpIdleTimeoutSec();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNat parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNat parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNat parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterNat prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterNat}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterNat)
      com.google.cloud.compute.v1.RouterNatOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNat_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNat_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterNat.class,
              com.google.cloud.compute.v1.RouterNat.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterNat.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLogConfigFieldBuilder();
        getNat64SubnetworksFieldBuilder();
        getRulesFieldBuilder();
        getSubnetworksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoNetworkTier_ = "";
      drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enableDynamicPortAllocation_ = false;
      enableEndpointIndependentMapping_ = false;
      endpointTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      icmpIdleTimeoutSec_ = 0;
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      maxPortsPerVm_ = 0;
      minPortsPerVm_ = 0;
      name_ = "";
      if (nat64SubnetworksBuilder_ == null) {
        nat64Subnetworks_ = java.util.Collections.emptyList();
      } else {
        nat64Subnetworks_ = null;
        nat64SubnetworksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      natIpAllocateOption_ = "";
      natIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      sourceSubnetworkIpRangesToNat_ = "";
      sourceSubnetworkIpRangesToNat64_ = "";
      if (subnetworksBuilder_ == null) {
        subnetworks_ = java.util.Collections.emptyList();
      } else {
        subnetworks_ = null;
        subnetworksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      tcpEstablishedIdleTimeoutSec_ = 0;
      tcpTimeWaitTimeoutSec_ = 0;
      tcpTransitoryIdleTimeoutSec_ = 0;
      type_ = "";
      udpIdleTimeoutSec_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNat_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNat getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterNat.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNat build() {
      com.google.cloud.compute.v1.RouterNat result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNat buildPartial() {
      com.google.cloud.compute.v1.RouterNat result =
          new com.google.cloud.compute.v1.RouterNat(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.RouterNat result) {
      if (nat64SubnetworksBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          nat64Subnetworks_ = java.util.Collections.unmodifiableList(nat64Subnetworks_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.nat64Subnetworks_ = nat64Subnetworks_;
      } else {
        result.nat64Subnetworks_ = nat64SubnetworksBuilder_.build();
      }
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      if (subnetworksBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          subnetworks_ = java.util.Collections.unmodifiableList(subnetworks_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.subnetworks_ = subnetworks_;
      } else {
        result.subnetworks_ = subnetworksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterNat result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoNetworkTier_ = autoNetworkTier_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        drainNatIps_.makeImmutable();
        result.drainNatIps_ = drainNatIps_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableDynamicPortAllocation_ = enableDynamicPortAllocation_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enableEndpointIndependentMapping_ = enableEndpointIndependentMapping_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        endpointTypes_.makeImmutable();
        result.endpointTypes_ = endpointTypes_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.icmpIdleTimeoutSec_ = icmpIdleTimeoutSec_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.logConfig_ = logConfigBuilder_ == null ? logConfig_ : logConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxPortsPerVm_ = maxPortsPerVm_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.minPortsPerVm_ = minPortsPerVm_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.natIpAllocateOption_ = natIpAllocateOption_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        natIps_.makeImmutable();
        result.natIps_ = natIps_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.sourceSubnetworkIpRangesToNat_ = sourceSubnetworkIpRangesToNat_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sourceSubnetworkIpRangesToNat64_ = sourceSubnetworkIpRangesToNat64_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.tcpEstablishedIdleTimeoutSec_ = tcpEstablishedIdleTimeoutSec_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.tcpTimeWaitTimeoutSec_ = tcpTimeWaitTimeoutSec_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.tcpTransitoryIdleTimeoutSec_ = tcpTransitoryIdleTimeoutSec_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.udpIdleTimeoutSec_ = udpIdleTimeoutSec_;
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterNat) {
        return mergeFrom((com.google.cloud.compute.v1.RouterNat) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterNat other) {
      if (other == com.google.cloud.compute.v1.RouterNat.getDefaultInstance()) return this;
      if (other.hasAutoNetworkTier()) {
        autoNetworkTier_ = other.autoNetworkTier_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.drainNatIps_.isEmpty()) {
        if (drainNatIps_.isEmpty()) {
          drainNatIps_ = other.drainNatIps_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDrainNatIpsIsMutable();
          drainNatIps_.addAll(other.drainNatIps_);
        }
        onChanged();
      }
      if (other.hasEnableDynamicPortAllocation()) {
        setEnableDynamicPortAllocation(other.getEnableDynamicPortAllocation());
      }
      if (other.hasEnableEndpointIndependentMapping()) {
        setEnableEndpointIndependentMapping(other.getEnableEndpointIndependentMapping());
      }
      if (!other.endpointTypes_.isEmpty()) {
        if (endpointTypes_.isEmpty()) {
          endpointTypes_ = other.endpointTypes_;
          bitField0_ |= 0x00000010;
        } else {
          ensureEndpointTypesIsMutable();
          endpointTypes_.addAll(other.endpointTypes_);
        }
        onChanged();
      }
      if (other.hasIcmpIdleTimeoutSec()) {
        setIcmpIdleTimeoutSec(other.getIcmpIdleTimeoutSec());
      }
      if (other.hasLogConfig()) {
        mergeLogConfig(other.getLogConfig());
      }
      if (other.hasMaxPortsPerVm()) {
        setMaxPortsPerVm(other.getMaxPortsPerVm());
      }
      if (other.hasMinPortsPerVm()) {
        setMinPortsPerVm(other.getMinPortsPerVm());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (nat64SubnetworksBuilder_ == null) {
        if (!other.nat64Subnetworks_.isEmpty()) {
          if (nat64Subnetworks_.isEmpty()) {
            nat64Subnetworks_ = other.nat64Subnetworks_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureNat64SubnetworksIsMutable();
            nat64Subnetworks_.addAll(other.nat64Subnetworks_);
          }
          onChanged();
        }
      } else {
        if (!other.nat64Subnetworks_.isEmpty()) {
          if (nat64SubnetworksBuilder_.isEmpty()) {
            nat64SubnetworksBuilder_.dispose();
            nat64SubnetworksBuilder_ = null;
            nat64Subnetworks_ = other.nat64Subnetworks_;
            bitField0_ = (bitField0_ & ~0x00000400);
            nat64SubnetworksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNat64SubnetworksFieldBuilder()
                    : null;
          } else {
            nat64SubnetworksBuilder_.addAllMessages(other.nat64Subnetworks_);
          }
        }
      }
      if (other.hasNatIpAllocateOption()) {
        natIpAllocateOption_ = other.natIpAllocateOption_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.natIps_.isEmpty()) {
        if (natIps_.isEmpty()) {
          natIps_ = other.natIps_;
          bitField0_ |= 0x00001000;
        } else {
          ensureNatIpsIsMutable();
          natIps_.addAll(other.natIps_);
        }
        onChanged();
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00002000);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (other.hasSourceSubnetworkIpRangesToNat()) {
        sourceSubnetworkIpRangesToNat_ = other.sourceSubnetworkIpRangesToNat_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSourceSubnetworkIpRangesToNat64()) {
        sourceSubnetworkIpRangesToNat64_ = other.sourceSubnetworkIpRangesToNat64_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (subnetworksBuilder_ == null) {
        if (!other.subnetworks_.isEmpty()) {
          if (subnetworks_.isEmpty()) {
            subnetworks_ = other.subnetworks_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureSubnetworksIsMutable();
            subnetworks_.addAll(other.subnetworks_);
          }
          onChanged();
        }
      } else {
        if (!other.subnetworks_.isEmpty()) {
          if (subnetworksBuilder_.isEmpty()) {
            subnetworksBuilder_.dispose();
            subnetworksBuilder_ = null;
            subnetworks_ = other.subnetworks_;
            bitField0_ = (bitField0_ & ~0x00010000);
            subnetworksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSubnetworksFieldBuilder()
                    : null;
          } else {
            subnetworksBuilder_.addAllMessages(other.subnetworks_);
          }
        }
      }
      if (other.hasTcpEstablishedIdleTimeoutSec()) {
        setTcpEstablishedIdleTimeoutSec(other.getTcpEstablishedIdleTimeoutSec());
      }
      if (other.hasTcpTimeWaitTimeoutSec()) {
        setTcpTimeWaitTimeoutSec(other.getTcpTimeWaitTimeoutSec());
      }
      if (other.hasTcpTransitoryIdleTimeoutSec()) {
        setTcpTransitoryIdleTimeoutSec(other.getTcpTransitoryIdleTimeoutSec());
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasUdpIdleTimeoutSec()) {
        setUdpIdleTimeoutSec(other.getUdpIdleTimeoutSec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 28604882
            case 29180496:
              {
                icmpIdleTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 29180496
            case 508685610:
              {
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.parser(),
                        extensionRegistry);
                if (nat64SubnetworksBuilder_ == null) {
                  ensureNat64SubnetworksIsMutable();
                  nat64Subnetworks_.add(m);
                } else {
                  nat64SubnetworksBuilder_.addMessage(m);
                }
                break;
              } // case 508685610
            case 519359024:
              {
                udpIdleTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00200000;
                break;
              } // case 519359024
            case 870991802:
              {
                com.google.cloud.compute.v1.RouterNatRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterNatRule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 870991802
            case 941080690:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNatIpsIsMutable();
                natIps_.add(s);
                break;
              } // case 941080690
            case 1489548696:
              {
                minPortsPerVm_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 1489548696
            case 1640230192:
              {
                tcpTransitoryIdleTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 1640230192
            case 1784786792:
              {
                tcpEstablishedIdleTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00020000;
                break;
              } // case 1784786792
            case 1984929482:
              {
                sourceSubnetworkIpRangesToNat64_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 1984929482
            case 2000496392:
              {
                maxPortsPerVm_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 2000496392
            case 2017705690:
              {
                sourceSubnetworkIpRangesToNat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 2017705690
            case 2075534552:
              {
                enableEndpointIndependentMapping_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 2075534552
            case -2136805606:
              {
                autoNetworkTier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -2136805606
            case -1484569366:
              {
                input.readMessage(getLogConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -1484569366
            case -968142294:
              {
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterNatSubnetworkToNat.parser(),
                        extensionRegistry);
                if (subnetworksBuilder_ == null) {
                  ensureSubnetworksIsMutable();
                  subnetworks_.add(m);
                } else {
                  subnetworksBuilder_.addMessage(m);
                }
                break;
              } // case -968142294
            case -857152534:
              {
                natIpAllocateOption_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -857152534
            case -273896838:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEndpointTypesIsMutable();
                endpointTypes_.add(s);
                break;
              } // case -273896838
            case -262339014:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDrainNatIpsIsMutable();
                drainNatIps_.add(s);
                break;
              } // case -262339014
            case -186191896:
              {
                tcpTimeWaitTimeoutSec_ = input.readInt32();
                bitField0_ |= 0x00040000;
                break;
              } // case -186191896
            case -38116080:
              {
                enableDynamicPortAllocation_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -38116080
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object autoNetworkTier_ = "";

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @return Whether the autoNetworkTier field is set.
     */
    public boolean hasAutoNetworkTier() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @return The autoNetworkTier.
     */
    public java.lang.String getAutoNetworkTier() {
      java.lang.Object ref = autoNetworkTier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        autoNetworkTier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @return The bytes for autoNetworkTier.
     */
    public com.google.protobuf.ByteString getAutoNetworkTierBytes() {
      java.lang.Object ref = autoNetworkTier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        autoNetworkTier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @param value The autoNetworkTier to set.
     * @return This builder for chaining.
     */
    public Builder setAutoNetworkTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      autoNetworkTier_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoNetworkTier() {
      autoNetworkTier_ = getDefaultInstance().getAutoNetworkTier();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
     * Check the AutoNetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string auto_network_tier = 269770211;</code>
     *
     * @param value The bytes for autoNetworkTier to set.
     * @return This builder for chaining.
     */
    public Builder setAutoNetworkTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      autoNetworkTier_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList drainNatIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDrainNatIpsIsMutable() {
      if (!drainNatIps_.isModifiable()) {
        drainNatIps_ = new com.google.protobuf.LazyStringArrayList(drainNatIps_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return A list containing the drainNatIps.
     */
    public com.google.protobuf.ProtocolStringList getDrainNatIpsList() {
      drainNatIps_.makeImmutable();
      return drainNatIps_;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return The count of drainNatIps.
     */
    public int getDrainNatIpsCount() {
      return drainNatIps_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index of the element to return.
     * @return The drainNatIps at the given index.
     */
    public java.lang.String getDrainNatIps(int index) {
      return drainNatIps_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the drainNatIps at the given index.
     */
    public com.google.protobuf.ByteString getDrainNatIpsBytes(int index) {
      return drainNatIps_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param index The index to set the value at.
     * @param value The drainNatIps to set.
     * @return This builder for chaining.
     */
    public Builder setDrainNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpsIsMutable();
      drainNatIps_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param value The drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDrainNatIpsIsMutable();
      drainNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param values The drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllDrainNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureDrainNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, drainNatIps_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDrainNatIps() {
      drainNatIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     * </pre>
     *
     * <code>repeated string drain_nat_ips = 504078535;</code>
     *
     * @param value The bytes of the drainNatIps to add.
     * @return This builder for chaining.
     */
    public Builder addDrainNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDrainNatIpsIsMutable();
      drainNatIps_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean enableDynamicPortAllocation_;

    /**
     *
     *
     * <pre>
     * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
     *
     * @return Whether the enableDynamicPortAllocation field is set.
     */
    @java.lang.Override
    public boolean hasEnableDynamicPortAllocation() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
     *
     * @return The enableDynamicPortAllocation.
     */
    @java.lang.Override
    public boolean getEnableDynamicPortAllocation() {
      return enableDynamicPortAllocation_;
    }

    /**
     *
     *
     * <pre>
     * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
     *
     * @param value The enableDynamicPortAllocation to set.
     * @return This builder for chaining.
     */
    public Builder setEnableDynamicPortAllocation(boolean value) {

      enableDynamicPortAllocation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enable Dynamic Port Allocation. If not specified, it is disabled by default. If set to true, - Dynamic Port Allocation will be enabled on this NAT config. - enableEndpointIndependentMapping cannot be set to true. - If minPorts is set, minPortsPerVm must be set to a power of two greater than or equal to 32. If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional bool enable_dynamic_port_allocation = 532106402;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableDynamicPortAllocation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableDynamicPortAllocation_ = false;
      onChanged();
      return this;
    }

    private boolean enableEndpointIndependentMapping_;

    /**
     * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
     *
     * @return Whether the enableEndpointIndependentMapping field is set.
     */
    @java.lang.Override
    public boolean hasEnableEndpointIndependentMapping() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
     *
     * @return The enableEndpointIndependentMapping.
     */
    @java.lang.Override
    public boolean getEnableEndpointIndependentMapping() {
      return enableEndpointIndependentMapping_;
    }

    /**
     * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
     *
     * @param value The enableEndpointIndependentMapping to set.
     * @return This builder for chaining.
     */
    public Builder setEnableEndpointIndependentMapping(boolean value) {

      enableEndpointIndependentMapping_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>optional bool enable_endpoint_independent_mapping = 259441819;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableEndpointIndependentMapping() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enableEndpointIndependentMapping_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList endpointTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEndpointTypesIsMutable() {
      if (!endpointTypes_.isModifiable()) {
        endpointTypes_ = new com.google.protobuf.LazyStringArrayList(endpointTypes_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @return A list containing the endpointTypes.
     */
    public com.google.protobuf.ProtocolStringList getEndpointTypesList() {
      endpointTypes_.makeImmutable();
      return endpointTypes_;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @return The count of endpointTypes.
     */
    public int getEndpointTypesCount() {
      return endpointTypes_.size();
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param index The index of the element to return.
     * @return The endpointTypes at the given index.
     */
    public java.lang.String getEndpointTypes(int index) {
      return endpointTypes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the endpointTypes at the given index.
     */
    public com.google.protobuf.ByteString getEndpointTypesBytes(int index) {
      return endpointTypes_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param index The index to set the value at.
     * @param value The endpointTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndpointTypesIsMutable();
      endpointTypes_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param value The endpointTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEndpointTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndpointTypesIsMutable();
      endpointTypes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param values The endpointTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEndpointTypes(java.lang.Iterable<java.lang.String> values) {
      ensureEndpointTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpointTypes_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointTypes() {
      endpointTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of NAT-ted endpoint types supported by the Nat Gateway. If the list is empty, then it will be equivalent to include ENDPOINT_TYPE_VM
     * Check the EndpointTypes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string endpoint_types = 502633807;</code>
     *
     * @param value The bytes of the endpointTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEndpointTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEndpointTypesIsMutable();
      endpointTypes_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int icmpIdleTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
     *
     * @return Whether the icmpIdleTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasIcmpIdleTimeoutSec() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
     *
     * @return The icmpIdleTimeoutSec.
     */
    @java.lang.Override
    public int getIcmpIdleTimeoutSec() {
      return icmpIdleTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
     *
     * @param value The icmpIdleTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setIcmpIdleTimeoutSec(int value) {

      icmpIdleTimeoutSec_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 icmp_idle_timeout_sec = 3647562;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIcmpIdleTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      icmpIdleTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.RouterNatLogConfig logConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatLogConfig,
            com.google.cloud.compute.v1.RouterNatLogConfig.Builder,
            com.google.cloud.compute.v1.RouterNatLogConfigOrBuilder>
        logConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     *
     * @return Whether the logConfig field is set.
     */
    public boolean hasLogConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     *
     * @return The logConfig.
     */
    public com.google.cloud.compute.v1.RouterNatLogConfig getLogConfig() {
      if (logConfigBuilder_ == null) {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.RouterNatLogConfig.getDefaultInstance()
            : logConfig_;
      } else {
        return logConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(com.google.cloud.compute.v1.RouterNatLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logConfig_ = value;
      } else {
        logConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public Builder setLogConfig(
        com.google.cloud.compute.v1.RouterNatLogConfig.Builder builderForValue) {
      if (logConfigBuilder_ == null) {
        logConfig_ = builderForValue.build();
      } else {
        logConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public Builder mergeLogConfig(com.google.cloud.compute.v1.RouterNatLogConfig value) {
      if (logConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && logConfig_ != null
            && logConfig_ != com.google.cloud.compute.v1.RouterNatLogConfig.getDefaultInstance()) {
          getLogConfigBuilder().mergeFrom(value);
        } else {
          logConfig_ = value;
        }
      } else {
        logConfigBuilder_.mergeFrom(value);
      }
      if (logConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public Builder clearLogConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      logConfig_ = null;
      if (logConfigBuilder_ != null) {
        logConfigBuilder_.dispose();
        logConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.RouterNatLogConfig.Builder getLogConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getLogConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    public com.google.cloud.compute.v1.RouterNatLogConfigOrBuilder getLogConfigOrBuilder() {
      if (logConfigBuilder_ != null) {
        return logConfigBuilder_.getMessageOrBuilder();
      } else {
        return logConfig_ == null
            ? com.google.cloud.compute.v1.RouterNatLogConfig.getDefaultInstance()
            : logConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Configure logging on this NAT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.RouterNatLogConfig log_config = 351299741;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatLogConfig,
            com.google.cloud.compute.v1.RouterNatLogConfig.Builder,
            com.google.cloud.compute.v1.RouterNatLogConfigOrBuilder>
        getLogConfigFieldBuilder() {
      if (logConfigBuilder_ == null) {
        logConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNatLogConfig,
                com.google.cloud.compute.v1.RouterNatLogConfig.Builder,
                com.google.cloud.compute.v1.RouterNatLogConfigOrBuilder>(
                getLogConfig(), getParentForChildren(), isClean());
        logConfig_ = null;
      }
      return logConfigBuilder_;
    }

    private int maxPortsPerVm_;

    /**
     *
     *
     * <pre>
     * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional int32 max_ports_per_vm = 250062049;</code>
     *
     * @return Whether the maxPortsPerVm field is set.
     */
    @java.lang.Override
    public boolean hasMaxPortsPerVm() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional int32 max_ports_per_vm = 250062049;</code>
     *
     * @return The maxPortsPerVm.
     */
    @java.lang.Override
    public int getMaxPortsPerVm() {
      return maxPortsPerVm_;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional int32 max_ports_per_vm = 250062049;</code>
     *
     * @param value The maxPortsPerVm to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPortsPerVm(int value) {

      maxPortsPerVm_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of ports allocated to a VM from this NAT config when Dynamic Port Allocation is enabled. If Dynamic Port Allocation is not enabled, this field has no effect. If Dynamic Port Allocation is enabled, and this field is set, it must be set to a power of two greater than minPortsPerVm, or 64 if minPortsPerVm is not set. If Dynamic Port Allocation is enabled and this field is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
     * </pre>
     *
     * <code>optional int32 max_ports_per_vm = 250062049;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPortsPerVm() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxPortsPerVm_ = 0;
      onChanged();
      return this;
    }

    private int minPortsPerVm_;

    /**
     *
     *
     * <pre>
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     * </pre>
     *
     * <code>optional int32 min_ports_per_vm = 186193587;</code>
     *
     * @return Whether the minPortsPerVm field is set.
     */
    @java.lang.Override
    public boolean hasMinPortsPerVm() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     * </pre>
     *
     * <code>optional int32 min_ports_per_vm = 186193587;</code>
     *
     * @return The minPortsPerVm.
     */
    @java.lang.Override
    public int getMinPortsPerVm() {
      return minPortsPerVm_;
    }

    /**
     *
     *
     * <pre>
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     * </pre>
     *
     * <code>optional int32 min_ports_per_vm = 186193587;</code>
     *
     * @param value The minPortsPerVm to set.
     * @return This builder for chaining.
     */
    public Builder setMinPortsPerVm(int value) {

      minPortsPerVm_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     * </pre>
     *
     * <code>optional int32 min_ports_per_vm = 186193587;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinPortsPerVm() {
      bitField0_ = (bitField0_ & ~0x00000100);
      minPortsPerVm_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64>
        nat64Subnetworks_ = java.util.Collections.emptyList();

    private void ensureNat64SubnetworksIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        nat64Subnetworks_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64>(
                nat64Subnetworks_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder>
        nat64SubnetworksBuilder_;

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64>
        getNat64SubnetworksList() {
      if (nat64SubnetworksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nat64Subnetworks_);
      } else {
        return nat64SubnetworksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public int getNat64SubnetworksCount() {
      if (nat64SubnetworksBuilder_ == null) {
        return nat64Subnetworks_.size();
      } else {
        return nat64SubnetworksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 getNat64Subnetworks(int index) {
      if (nat64SubnetworksBuilder_ == null) {
        return nat64Subnetworks_.get(index);
      } else {
        return nat64SubnetworksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder setNat64Subnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 value) {
      if (nat64SubnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.set(index, value);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder setNat64Subnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder builderForValue) {
      if (nat64SubnetworksBuilder_ == null) {
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.set(index, builderForValue.build());
        onChanged();
      } else {
        nat64SubnetworksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder addNat64Subnetworks(
        com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 value) {
      if (nat64SubnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.add(value);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder addNat64Subnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat64 value) {
      if (nat64SubnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.add(index, value);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder addNat64Subnetworks(
        com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder builderForValue) {
      if (nat64SubnetworksBuilder_ == null) {
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.add(builderForValue.build());
        onChanged();
      } else {
        nat64SubnetworksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder addNat64Subnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder builderForValue) {
      if (nat64SubnetworksBuilder_ == null) {
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.add(index, builderForValue.build());
        onChanged();
      } else {
        nat64SubnetworksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder addAllNat64Subnetworks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNat64>
            values) {
      if (nat64SubnetworksBuilder_ == null) {
        ensureNat64SubnetworksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nat64Subnetworks_);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder clearNat64Subnetworks() {
      if (nat64SubnetworksBuilder_ == null) {
        nat64Subnetworks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public Builder removeNat64Subnetworks(int index) {
      if (nat64SubnetworksBuilder_ == null) {
        ensureNat64SubnetworksIsMutable();
        nat64Subnetworks_.remove(index);
        onChanged();
      } else {
        nat64SubnetworksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder
        getNat64SubnetworksBuilder(int index) {
      return getNat64SubnetworksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder
        getNat64SubnetworksOrBuilder(int index) {
      if (nat64SubnetworksBuilder_ == null) {
        return nat64Subnetworks_.get(index);
      } else {
        return nat64SubnetworksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder>
        getNat64SubnetworksOrBuilderList() {
      if (nat64SubnetworksBuilder_ != null) {
        return nat64SubnetworksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nat64Subnetworks_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder
        addNat64SubnetworksBuilder() {
      return getNat64SubnetworksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder
        addNat64SubnetworksBuilder(int index) {
      return getNat64SubnetworksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of Subnetwork resources whose traffic should be translated by NAT64 Gateway. It is used only when LIST_OF_IPV6_SUBNETWORKS is selected for the SubnetworkIpRangeToNat64Option above.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat64 nat64_subnetworks = 63585701;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder>
        getNat64SubnetworksBuilderList() {
      return getNat64SubnetworksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder>
        getNat64SubnetworksFieldBuilder() {
      if (nat64SubnetworksBuilder_ == null) {
        nat64SubnetworksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat64,
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat64.Builder,
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat64OrBuilder>(
                nat64Subnetworks_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        nat64Subnetworks_ = null;
      }
      return nat64SubnetworksBuilder_;
    }

    private java.lang.Object natIpAllocateOption_ = "";

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @return Whether the natIpAllocateOption field is set.
     */
    public boolean hasNatIpAllocateOption() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @return The natIpAllocateOption.
     */
    public java.lang.String getNatIpAllocateOption() {
      java.lang.Object ref = natIpAllocateOption_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        natIpAllocateOption_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @return The bytes for natIpAllocateOption.
     */
    public com.google.protobuf.ByteString getNatIpAllocateOptionBytes() {
      java.lang.Object ref = natIpAllocateOption_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        natIpAllocateOption_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @param value The natIpAllocateOption to set.
     * @return This builder for chaining.
     */
    public Builder setNatIpAllocateOption(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      natIpAllocateOption_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatIpAllocateOption() {
      natIpAllocateOption_ = getDefaultInstance().getNatIpAllocateOption();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     * Check the NatIpAllocateOption enum for the list of possible values.
     * </pre>
     *
     * <code>optional string nat_ip_allocate_option = 429726845;</code>
     *
     * @param value The bytes for natIpAllocateOption to set.
     * @return This builder for chaining.
     */
    public Builder setNatIpAllocateOptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      natIpAllocateOption_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList natIps_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNatIpsIsMutable() {
      if (!natIps_.isModifiable()) {
        natIps_ = new com.google.protobuf.LazyStringArrayList(natIps_);
      }
      bitField0_ |= 0x00001000;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @return A list containing the natIps.
     */
    public com.google.protobuf.ProtocolStringList getNatIpsList() {
      natIps_.makeImmutable();
      return natIps_;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @return The count of natIps.
     */
    public int getNatIpsCount() {
      return natIps_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param index The index of the element to return.
     * @return The natIps at the given index.
     */
    public java.lang.String getNatIps(int index) {
      return natIps_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the natIps at the given index.
     */
    public com.google.protobuf.ByteString getNatIpsBytes(int index) {
      return natIps_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param index The index to set the value at.
     * @param value The natIps to set.
     * @return This builder for chaining.
     */
    public Builder setNatIps(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatIpsIsMutable();
      natIps_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param value The natIps to add.
     * @return This builder for chaining.
     */
    public Builder addNatIps(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNatIpsIsMutable();
      natIps_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param values The natIps to add.
     * @return This builder for chaining.
     */
    public Builder addAllNatIps(java.lang.Iterable<java.lang.String> values) {
      ensureNatIpsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, natIps_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatIps() {
      natIps_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     * </pre>
     *
     * <code>repeated string nat_ips = 117635086;</code>
     *
     * @param value The bytes of the natIps to add.
     * @return This builder for chaining.
     */
    public Builder addNatIpsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNatIpsIsMutable();
      natIps_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterNatRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        rules_ = new java.util.ArrayList<com.google.cloud.compute.v1.RouterNatRule>(rules_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatRule,
            com.google.cloud.compute.v1.RouterNatRule.Builder,
            com.google.cloud.compute.v1.RouterNatRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder setRules(int index, com.google.cloud.compute.v1.RouterNatRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder setRules(
        int index, com.google.cloud.compute.v1.RouterNatRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder addRules(com.google.cloud.compute.v1.RouterNatRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder addRules(int index, com.google.cloud.compute.v1.RouterNatRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder addRules(com.google.cloud.compute.v1.RouterNatRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder addRules(
        int index, com.google.cloud.compute.v1.RouterNatRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterNatRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterNatRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterNatRule.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public com.google.cloud.compute.v1.RouterNatRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.RouterNatRule.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of rules associated with this NAT.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatRule rules = 108873975;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatRule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatRule,
            com.google.cloud.compute.v1.RouterNatRule.Builder,
            com.google.cloud.compute.v1.RouterNatRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNatRule,
                com.google.cloud.compute.v1.RouterNatRule.Builder,
                com.google.cloud.compute.v1.RouterNatRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private java.lang.Object sourceSubnetworkIpRangesToNat_ = "";

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @return Whether the sourceSubnetworkIpRangesToNat field is set.
     */
    public boolean hasSourceSubnetworkIpRangesToNat() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @return The sourceSubnetworkIpRangesToNat.
     */
    public java.lang.String getSourceSubnetworkIpRangesToNat() {
      java.lang.Object ref = sourceSubnetworkIpRangesToNat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSubnetworkIpRangesToNat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @return The bytes for sourceSubnetworkIpRangesToNat.
     */
    public com.google.protobuf.ByteString getSourceSubnetworkIpRangesToNatBytes() {
      java.lang.Object ref = sourceSubnetworkIpRangesToNat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSubnetworkIpRangesToNat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @param value The sourceSubnetworkIpRangesToNat to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSubnetworkIpRangesToNat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceSubnetworkIpRangesToNat_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceSubnetworkIpRangesToNat() {
      sourceSubnetworkIpRangesToNat_ = getDefaultInstance().getSourceSubnetworkIpRangesToNat();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
     * Check the SourceSubnetworkIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     *
     * @param value The bytes for sourceSubnetworkIpRangesToNat to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSubnetworkIpRangesToNatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceSubnetworkIpRangesToNat_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceSubnetworkIpRangesToNat64_ = "";

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @return Whether the sourceSubnetworkIpRangesToNat64 field is set.
     */
    public boolean hasSourceSubnetworkIpRangesToNat64() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @return The sourceSubnetworkIpRangesToNat64.
     */
    public java.lang.String getSourceSubnetworkIpRangesToNat64() {
      java.lang.Object ref = sourceSubnetworkIpRangesToNat64_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSubnetworkIpRangesToNat64_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @return The bytes for sourceSubnetworkIpRangesToNat64.
     */
    public com.google.protobuf.ByteString getSourceSubnetworkIpRangesToNat64Bytes() {
      java.lang.Object ref = sourceSubnetworkIpRangesToNat64_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSubnetworkIpRangesToNat64_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @param value The sourceSubnetworkIpRangesToNat64 to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSubnetworkIpRangesToNat64(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceSubnetworkIpRangesToNat64_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceSubnetworkIpRangesToNat64() {
      sourceSubnetworkIpRangesToNat64_ = getDefaultInstance().getSourceSubnetworkIpRangesToNat64();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. Note that if this field contains NAT64_ALL_V6_SUBNETWORKS no other Router.Nat section in this region can also enable NAT64 for any Subnetworks in this network. Other Router.Nat sections can still be present to enable NAT44 only.
     * Check the SourceSubnetworkIpRangesToNat64 enum for the list of possible values.
     * </pre>
     *
     * <code>optional string source_subnetwork_ip_ranges_to_nat64 = 248116185;</code>
     *
     * @param value The bytes for sourceSubnetworkIpRangesToNat64 to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSubnetworkIpRangesToNat64Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceSubnetworkIpRangesToNat64_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat> subnetworks_ =
        java.util.Collections.emptyList();

    private void ensureSubnetworksIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        subnetworks_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterNatSubnetworkToNat>(
                subnetworks_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder>
        subnetworksBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat>
        getSubnetworksList() {
      if (subnetworksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(subnetworks_);
      } else {
        return subnetworksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public int getSubnetworksCount() {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.size();
      } else {
        return subnetworksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat getSubnetworks(int index) {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.get(index);
      } else {
        return subnetworksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder setSubnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.set(index, value);
        onChanged();
      } else {
        subnetworksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder setSubnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.set(index, builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(com.google.cloud.compute.v1.RouterNatSubnetworkToNat value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.add(value);
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat value) {
      if (subnetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubnetworksIsMutable();
        subnetworks_.add(index, value);
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.add(builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder addSubnetworks(
        int index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder builderForValue) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.add(index, builderForValue.build());
        onChanged();
      } else {
        subnetworksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder addAllSubnetworks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNat> values) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subnetworks_);
        onChanged();
      } else {
        subnetworksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder clearSubnetworks() {
      if (subnetworksBuilder_ == null) {
        subnetworks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        subnetworksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public Builder removeSubnetworks(int index) {
      if (subnetworksBuilder_ == null) {
        ensureSubnetworksIsMutable();
        subnetworks_.remove(index);
        onChanged();
      } else {
        subnetworksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder getSubnetworksBuilder(
        int index) {
      return getSubnetworksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder getSubnetworksOrBuilder(
        int index) {
      if (subnetworksBuilder_ == null) {
        return subnetworks_.get(index);
      } else {
        return subnetworksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder>
        getSubnetworksOrBuilderList() {
      if (subnetworksBuilder_ != null) {
        return subnetworksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(subnetworks_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder addSubnetworksBuilder() {
      return getSubnetworksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterNatSubnetworkToNat.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder addSubnetworksBuilder(
        int index) {
      return getSubnetworksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterNatSubnetworkToNat.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 415853125;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder>
        getSubnetworksBuilderList() {
      return getSubnetworksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder>
        getSubnetworksFieldBuilder() {
      if (subnetworksBuilder_ == null) {
        subnetworksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat,
                com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder,
                com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder>(
                subnetworks_, ((bitField0_ & 0x00010000) != 0), getParentForChildren(), isClean());
        subnetworks_ = null;
      }
      return subnetworksBuilder_;
    }

    private int tcpEstablishedIdleTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
     *
     * @return Whether the tcpEstablishedIdleTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasTcpEstablishedIdleTimeoutSec() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
     *
     * @return The tcpEstablishedIdleTimeoutSec.
     */
    @java.lang.Override
    public int getTcpEstablishedIdleTimeoutSec() {
      return tcpEstablishedIdleTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
     *
     * @param value The tcpEstablishedIdleTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setTcpEstablishedIdleTimeoutSec(int value) {

      tcpEstablishedIdleTimeoutSec_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_established_idle_timeout_sec = 223098349;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTcpEstablishedIdleTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00020000);
      tcpEstablishedIdleTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    private int tcpTimeWaitTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
     *
     * @return Whether the tcpTimeWaitTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasTcpTimeWaitTimeoutSec() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
     *
     * @return The tcpTimeWaitTimeoutSec.
     */
    @java.lang.Override
    public int getTcpTimeWaitTimeoutSec() {
      return tcpTimeWaitTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
     *
     * @param value The tcpTimeWaitTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setTcpTimeWaitTimeoutSec(int value) {

      tcpTimeWaitTimeoutSec_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP connections that are in TIME_WAIT state. Defaults to 120s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_time_wait_timeout_sec = 513596925;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTcpTimeWaitTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00040000);
      tcpTimeWaitTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    private int tcpTransitoryIdleTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     *
     * @return Whether the tcpTransitoryIdleTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasTcpTransitoryIdleTimeoutSec() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     *
     * @return The tcpTransitoryIdleTimeoutSec.
     */
    @java.lang.Override
    public int getTcpTransitoryIdleTimeoutSec() {
      return tcpTransitoryIdleTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     *
     * @param value The tcpTransitoryIdleTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setTcpTransitoryIdleTimeoutSec(int value) {

      tcpTransitoryIdleTimeoutSec_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTcpTransitoryIdleTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00080000);
      tcpTransitoryIdleTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates whether this NAT is used for public or private IP translation. If unspecified, it defaults to PUBLIC.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private int udpIdleTimeoutSec_;

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
     *
     * @return Whether the udpIdleTimeoutSec field is set.
     */
    @java.lang.Override
    public boolean hasUdpIdleTimeoutSec() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
     *
     * @return The udpIdleTimeoutSec.
     */
    @java.lang.Override
    public int getUdpIdleTimeoutSec() {
      return udpIdleTimeoutSec_;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
     *
     * @param value The udpIdleTimeoutSec to set.
     * @return This builder for chaining.
     */
    public Builder setUdpIdleTimeoutSec(int value) {

      udpIdleTimeoutSec_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * </pre>
     *
     * <code>optional int32 udp_idle_timeout_sec = 64919878;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUdpIdleTimeoutSec() {
      bitField0_ = (bitField0_ & ~0x00200000);
      udpIdleTimeoutSec_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterNat)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterNat)
  private static final com.google.cloud.compute.v1.RouterNat DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterNat();
  }

  public static com.google.cloud.compute.v1.RouterNat getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterNat> PARSER =
      new com.google.protobuf.AbstractParser<RouterNat>() {
        @java.lang.Override
        public RouterNat parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterNat> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterNat> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNat getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
