/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Defines the IP ranges that want to use NAT for a subnetwork.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterNatSubnetworkToNat}
 */
public final class RouterNatSubnetworkToNat extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterNatSubnetworkToNat)
    RouterNatSubnetworkToNatOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterNatSubnetworkToNat.newBuilder() to construct.
  private RouterNatSubnetworkToNat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterNatSubnetworkToNat() {
    name_ = "";
    secondaryIpRangeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    sourceIpRangesToNat_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterNatSubnetworkToNat();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatSubnetworkToNat_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterNatSubnetworkToNat_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat.class,
            com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.RouterNatSubnetworkToNat.SourceIpRangesToNat}
   */
  public enum SourceIpRangesToNat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_IP_RANGES_TO_NAT = 0;</code>
     */
    UNDEFINED_SOURCE_IP_RANGES_TO_NAT(0),
    /**
     *
     *
     * <pre>
     * The primary and all the secondary ranges are allowed to Nat.
     * </pre>
     *
     * <code>ALL_IP_RANGES = 35608496;</code>
     */
    ALL_IP_RANGES(35608496),
    /**
     *
     *
     * <pre>
     * A list of secondary ranges are allowed to Nat.
     * </pre>
     *
     * <code>LIST_OF_SECONDARY_IP_RANGES = 192289308;</code>
     */
    LIST_OF_SECONDARY_IP_RANGES(192289308),
    /**
     *
     *
     * <pre>
     * The primary range is allowed to Nat.
     * </pre>
     *
     * <code>PRIMARY_IP_RANGE = 297109954;</code>
     */
    PRIMARY_IP_RANGE(297109954),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SOURCE_IP_RANGES_TO_NAT = 0;</code>
     */
    public static final int UNDEFINED_SOURCE_IP_RANGES_TO_NAT_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The primary and all the secondary ranges are allowed to Nat.
     * </pre>
     *
     * <code>ALL_IP_RANGES = 35608496;</code>
     */
    public static final int ALL_IP_RANGES_VALUE = 35608496;

    /**
     *
     *
     * <pre>
     * A list of secondary ranges are allowed to Nat.
     * </pre>
     *
     * <code>LIST_OF_SECONDARY_IP_RANGES = 192289308;</code>
     */
    public static final int LIST_OF_SECONDARY_IP_RANGES_VALUE = 192289308;

    /**
     *
     *
     * <pre>
     * The primary range is allowed to Nat.
     * </pre>
     *
     * <code>PRIMARY_IP_RANGE = 297109954;</code>
     */
    public static final int PRIMARY_IP_RANGE_VALUE = 297109954;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceIpRangesToNat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SourceIpRangesToNat forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SOURCE_IP_RANGES_TO_NAT;
        case 35608496:
          return ALL_IP_RANGES;
        case 192289308:
          return LIST_OF_SECONDARY_IP_RANGES;
        case 297109954:
          return PRIMARY_IP_RANGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SourceIpRangesToNat>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SourceIpRangesToNat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SourceIpRangesToNat>() {
              public SourceIpRangesToNat findValueByNumber(int number) {
                return SourceIpRangesToNat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.RouterNatSubnetworkToNat.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SourceIpRangesToNat[] VALUES = values();

    public static SourceIpRangesToNat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SourceIpRangesToNat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.RouterNatSubnetworkToNat.SourceIpRangesToNat)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * URL for the subnetwork resource that will use NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * URL for the subnetwork resource that will use NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URL for the subnetwork resource that will use NAT.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_IP_RANGE_NAMES_FIELD_NUMBER = 264315097;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList secondaryIpRangeNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
   * </pre>
   *
   * <code>repeated string secondary_ip_range_names = 264315097;</code>
   *
   * @return A list containing the secondaryIpRangeNames.
   */
  public com.google.protobuf.ProtocolStringList getSecondaryIpRangeNamesList() {
    return secondaryIpRangeNames_;
  }

  /**
   *
   *
   * <pre>
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
   * </pre>
   *
   * <code>repeated string secondary_ip_range_names = 264315097;</code>
   *
   * @return The count of secondaryIpRangeNames.
   */
  public int getSecondaryIpRangeNamesCount() {
    return secondaryIpRangeNames_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
   * </pre>
   *
   * <code>repeated string secondary_ip_range_names = 264315097;</code>
   *
   * @param index The index of the element to return.
   * @return The secondaryIpRangeNames at the given index.
   */
  public java.lang.String getSecondaryIpRangeNames(int index) {
    return secondaryIpRangeNames_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
   * </pre>
   *
   * <code>repeated string secondary_ip_range_names = 264315097;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the secondaryIpRangeNames at the given index.
   */
  public com.google.protobuf.ByteString getSecondaryIpRangeNamesBytes(int index) {
    return secondaryIpRangeNames_.getByteString(index);
  }

  public static final int SOURCE_IP_RANGES_TO_NAT_FIELD_NUMBER = 388310386;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourceIpRangesToNat_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * Check the SourceIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
   *
   * @return A list containing the sourceIpRangesToNat.
   */
  public com.google.protobuf.ProtocolStringList getSourceIpRangesToNatList() {
    return sourceIpRangesToNat_;
  }

  /**
   *
   *
   * <pre>
   * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * Check the SourceIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
   *
   * @return The count of sourceIpRangesToNat.
   */
  public int getSourceIpRangesToNatCount() {
    return sourceIpRangesToNat_.size();
  }

  /**
   *
   *
   * <pre>
   * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * Check the SourceIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceIpRangesToNat at the given index.
   */
  public java.lang.String getSourceIpRangesToNat(int index) {
    return sourceIpRangesToNat_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
   * Check the SourceIpRangesToNat enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourceIpRangesToNat at the given index.
   */
  public com.google.protobuf.ByteString getSourceIpRangesToNatBytes(int index) {
    return sourceIpRangesToNat_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    for (int i = 0; i < secondaryIpRangeNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 264315097, secondaryIpRangeNames_.getRaw(i));
    }
    for (int i = 0; i < sourceIpRangesToNat_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 388310386, sourceIpRangesToNat_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < secondaryIpRangeNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(secondaryIpRangeNames_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSecondaryIpRangeNamesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceIpRangesToNat_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceIpRangesToNat_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSourceIpRangesToNatList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterNatSubnetworkToNat)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterNatSubnetworkToNat other =
        (com.google.cloud.compute.v1.RouterNatSubnetworkToNat) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getSecondaryIpRangeNamesList().equals(other.getSecondaryIpRangeNamesList())) return false;
    if (!getSourceIpRangesToNatList().equals(other.getSourceIpRangesToNatList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getSecondaryIpRangeNamesCount() > 0) {
      hash = (37 * hash) + SECONDARY_IP_RANGE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryIpRangeNamesList().hashCode();
    }
    if (getSourceIpRangesToNatCount() > 0) {
      hash = (37 * hash) + SOURCE_IP_RANGES_TO_NAT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceIpRangesToNatList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterNatSubnetworkToNat prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines the IP ranges that want to use NAT for a subnetwork.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterNatSubnetworkToNat}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterNatSubnetworkToNat)
      com.google.cloud.compute.v1.RouterNatSubnetworkToNatOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatSubnetworkToNat_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatSubnetworkToNat_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterNatSubnetworkToNat.class,
              com.google.cloud.compute.v1.RouterNatSubnetworkToNat.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterNatSubnetworkToNat.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      secondaryIpRangeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceIpRangesToNat_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterNatSubnetworkToNat_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterNatSubnetworkToNat.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat build() {
      com.google.cloud.compute.v1.RouterNatSubnetworkToNat result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterNatSubnetworkToNat buildPartial() {
      com.google.cloud.compute.v1.RouterNatSubnetworkToNat result =
          new com.google.cloud.compute.v1.RouterNatSubnetworkToNat(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterNatSubnetworkToNat result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        secondaryIpRangeNames_.makeImmutable();
        result.secondaryIpRangeNames_ = secondaryIpRangeNames_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        sourceIpRangesToNat_.makeImmutable();
        result.sourceIpRangesToNat_ = sourceIpRangesToNat_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterNatSubnetworkToNat) {
        return mergeFrom((com.google.cloud.compute.v1.RouterNatSubnetworkToNat) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterNatSubnetworkToNat other) {
      if (other == com.google.cloud.compute.v1.RouterNatSubnetworkToNat.getDefaultInstance())
        return this;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.secondaryIpRangeNames_.isEmpty()) {
        if (secondaryIpRangeNames_.isEmpty()) {
          secondaryIpRangeNames_ = other.secondaryIpRangeNames_;
          bitField0_ |= 0x00000002;
        } else {
          ensureSecondaryIpRangeNamesIsMutable();
          secondaryIpRangeNames_.addAll(other.secondaryIpRangeNames_);
        }
        onChanged();
      }
      if (!other.sourceIpRangesToNat_.isEmpty()) {
        if (sourceIpRangesToNat_.isEmpty()) {
          sourceIpRangesToNat_ = other.sourceIpRangesToNat_;
          bitField0_ |= 0x00000004;
        } else {
          ensureSourceIpRangesToNatIsMutable();
          sourceIpRangesToNat_.addAll(other.sourceIpRangesToNat_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26989658
            case 2114520778:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSecondaryIpRangeNamesIsMutable();
                secondaryIpRangeNames_.add(s);
                break;
              } // case 2114520778
            case -1188484206:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourceIpRangesToNatIsMutable();
                sourceIpRangesToNat_.add(s);
                break;
              } // case -1188484206
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URL for the subnetwork resource that will use NAT.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList secondaryIpRangeNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSecondaryIpRangeNamesIsMutable() {
      if (!secondaryIpRangeNames_.isModifiable()) {
        secondaryIpRangeNames_ =
            new com.google.protobuf.LazyStringArrayList(secondaryIpRangeNames_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @return A list containing the secondaryIpRangeNames.
     */
    public com.google.protobuf.ProtocolStringList getSecondaryIpRangeNamesList() {
      secondaryIpRangeNames_.makeImmutable();
      return secondaryIpRangeNames_;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @return The count of secondaryIpRangeNames.
     */
    public int getSecondaryIpRangeNamesCount() {
      return secondaryIpRangeNames_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param index The index of the element to return.
     * @return The secondaryIpRangeNames at the given index.
     */
    public java.lang.String getSecondaryIpRangeNames(int index) {
      return secondaryIpRangeNames_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the secondaryIpRangeNames at the given index.
     */
    public com.google.protobuf.ByteString getSecondaryIpRangeNamesBytes(int index) {
      return secondaryIpRangeNames_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param index The index to set the value at.
     * @param value The secondaryIpRangeNames to set.
     * @return This builder for chaining.
     */
    public Builder setSecondaryIpRangeNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecondaryIpRangeNamesIsMutable();
      secondaryIpRangeNames_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param value The secondaryIpRangeNames to add.
     * @return This builder for chaining.
     */
    public Builder addSecondaryIpRangeNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecondaryIpRangeNamesIsMutable();
      secondaryIpRangeNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param values The secondaryIpRangeNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllSecondaryIpRangeNames(java.lang.Iterable<java.lang.String> values) {
      ensureSecondaryIpRangeNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secondaryIpRangeNames_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecondaryIpRangeNames() {
      secondaryIpRangeNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the secondary ranges of the Subnetwork that are allowed to use NAT. This can be populated only if "LIST_OF_SECONDARY_IP_RANGES" is one of the values in source_ip_ranges_to_nat.
     * </pre>
     *
     * <code>repeated string secondary_ip_range_names = 264315097;</code>
     *
     * @param value The bytes of the secondaryIpRangeNames to add.
     * @return This builder for chaining.
     */
    public Builder addSecondaryIpRangeNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSecondaryIpRangeNamesIsMutable();
      secondaryIpRangeNames_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourceIpRangesToNat_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourceIpRangesToNatIsMutable() {
      if (!sourceIpRangesToNat_.isModifiable()) {
        sourceIpRangesToNat_ = new com.google.protobuf.LazyStringArrayList(sourceIpRangesToNat_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @return A list containing the sourceIpRangesToNat.
     */
    public com.google.protobuf.ProtocolStringList getSourceIpRangesToNatList() {
      sourceIpRangesToNat_.makeImmutable();
      return sourceIpRangesToNat_;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @return The count of sourceIpRangesToNat.
     */
    public int getSourceIpRangesToNatCount() {
      return sourceIpRangesToNat_.size();
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param index The index of the element to return.
     * @return The sourceIpRangesToNat at the given index.
     */
    public java.lang.String getSourceIpRangesToNat(int index) {
      return sourceIpRangesToNat_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourceIpRangesToNat at the given index.
     */
    public com.google.protobuf.ByteString getSourceIpRangesToNatBytes(int index) {
      return sourceIpRangesToNat_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param index The index to set the value at.
     * @param value The sourceIpRangesToNat to set.
     * @return This builder for chaining.
     */
    public Builder setSourceIpRangesToNat(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceIpRangesToNatIsMutable();
      sourceIpRangesToNat_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param value The sourceIpRangesToNat to add.
     * @return This builder for chaining.
     */
    public Builder addSourceIpRangesToNat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceIpRangesToNatIsMutable();
      sourceIpRangesToNat_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param values The sourceIpRangesToNat to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceIpRangesToNat(java.lang.Iterable<java.lang.String> values) {
      ensureSourceIpRangesToNatIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceIpRangesToNat_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceIpRangesToNat() {
      sourceIpRangesToNat_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specify the options for NAT ranges in the Subnetwork. All options of a single value are valid except NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with multiple values is: ["PRIMARY_IP_RANGE", "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
     * Check the SourceIpRangesToNat enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string source_ip_ranges_to_nat = 388310386;</code>
     *
     * @param value The bytes of the sourceIpRangesToNat to add.
     * @return This builder for chaining.
     */
    public Builder addSourceIpRangesToNatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourceIpRangesToNatIsMutable();
      sourceIpRangesToNat_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterNatSubnetworkToNat)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterNatSubnetworkToNat)
  private static final com.google.cloud.compute.v1.RouterNatSubnetworkToNat DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterNatSubnetworkToNat();
  }

  public static com.google.cloud.compute.v1.RouterNatSubnetworkToNat getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterNatSubnetworkToNat> PARSER =
      new com.google.protobuf.AbstractParser<RouterNatSubnetworkToNat>() {
        @java.lang.Override
        public RouterNatSubnetworkToNat parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterNatSubnetworkToNat> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterNatSubnetworkToNat> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterNatSubnetworkToNat getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
