/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.RouterStatus}
 */
public final class RouterStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.RouterStatus)
    RouterStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouterStatus.newBuilder() to construct.
  private RouterStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouterStatus() {
    bestRoutes_ = java.util.Collections.emptyList();
    bestRoutesForRouter_ = java.util.Collections.emptyList();
    bgpPeerStatus_ = java.util.Collections.emptyList();
    natStatus_ = java.util.Collections.emptyList();
    network_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouterStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_RouterStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.RouterStatus.class,
            com.google.cloud.compute.v1.RouterStatus.Builder.class);
  }

  private int bitField0_;
  public static final int BEST_ROUTES_FIELD_NUMBER = 395826693;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Route> bestRoutes_;

  /**
   *
   *
   * <pre>
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Route> getBestRoutesList() {
    return bestRoutes_;
  }

  /**
   *
   *
   * <pre>
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
      getBestRoutesOrBuilderList() {
    return bestRoutes_;
  }

  /**
   *
   *
   * <pre>
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
   */
  @java.lang.Override
  public int getBestRoutesCount() {
    return bestRoutes_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Route getBestRoutes(int index) {
    return bestRoutes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouteOrBuilder getBestRoutesOrBuilder(int index) {
    return bestRoutes_.get(index);
  }

  public static final int BEST_ROUTES_FOR_ROUTER_FIELD_NUMBER = 119389689;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Route> bestRoutesForRouter_;

  /**
   *
   *
   * <pre>
   * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Route> getBestRoutesForRouterList() {
    return bestRoutesForRouter_;
  }

  /**
   *
   *
   * <pre>
   * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
      getBestRoutesForRouterOrBuilderList() {
    return bestRoutesForRouter_;
  }

  /**
   *
   *
   * <pre>
   * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
   */
  @java.lang.Override
  public int getBestRoutesForRouterCount() {
    return bestRoutesForRouter_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Route getBestRoutesForRouter(int index) {
    return bestRoutesForRouter_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouteOrBuilder getBestRoutesForRouterOrBuilder(int index) {
    return bestRoutesForRouter_.get(index);
  }

  public static final int BGP_PEER_STATUS_FIELD_NUMBER = 218459131;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus> bgpPeerStatus_;

  /**
   * <code>repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus>
      getBgpPeerStatusList() {
    return bgpPeerStatus_;
  }

  /**
   * <code>repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder>
      getBgpPeerStatusOrBuilderList() {
    return bgpPeerStatus_;
  }

  /**
   * <code>repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
   * </code>
   */
  @java.lang.Override
  public int getBgpPeerStatusCount() {
    return bgpPeerStatus_.size();
  }

  /**
   * <code>repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus getBgpPeerStatus(int index) {
    return bgpPeerStatus_.get(index);
  }

  /**
   * <code>repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder getBgpPeerStatusOrBuilder(
      int index) {
    return bgpPeerStatus_.get(index);
  }

  public static final int NAT_STATUS_FIELD_NUMBER = 63098064;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatus> natStatus_;

  /** <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatus> getNatStatusList() {
    return natStatus_;
  }

  /** <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder>
      getNatStatusOrBuilderList() {
    return natStatus_;
  }

  /** <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code> */
  @java.lang.Override
  public int getNatStatusCount() {
    return natStatus_.size();
  }

  /** <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatus getNatStatus(int index) {
    return natStatus_.get(index);
  }

  /** <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder getNatStatusOrBuilder(
      int index) {
    return natStatus_.get(index);
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URI of the network to which this router belongs.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < natStatus_.size(); i++) {
      output.writeMessage(63098064, natStatus_.get(i));
    }
    for (int i = 0; i < bestRoutesForRouter_.size(); i++) {
      output.writeMessage(119389689, bestRoutesForRouter_.get(i));
    }
    for (int i = 0; i < bgpPeerStatus_.size(); i++) {
      output.writeMessage(218459131, bgpPeerStatus_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    for (int i = 0; i < bestRoutes_.size(); i++) {
      output.writeMessage(395826693, bestRoutes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < natStatus_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(63098064, natStatus_.get(i));
    }
    for (int i = 0; i < bestRoutesForRouter_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              119389689, bestRoutesForRouter_.get(i));
    }
    for (int i = 0; i < bgpPeerStatus_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              218459131, bgpPeerStatus_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    for (int i = 0; i < bestRoutes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(395826693, bestRoutes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.RouterStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.RouterStatus other = (com.google.cloud.compute.v1.RouterStatus) obj;

    if (!getBestRoutesList().equals(other.getBestRoutesList())) return false;
    if (!getBestRoutesForRouterList().equals(other.getBestRoutesForRouterList())) return false;
    if (!getBgpPeerStatusList().equals(other.getBgpPeerStatusList())) return false;
    if (!getNatStatusList().equals(other.getNatStatusList())) return false;
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBestRoutesCount() > 0) {
      hash = (37 * hash) + BEST_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getBestRoutesList().hashCode();
    }
    if (getBestRoutesForRouterCount() > 0) {
      hash = (37 * hash) + BEST_ROUTES_FOR_ROUTER_FIELD_NUMBER;
      hash = (53 * hash) + getBestRoutesForRouterList().hashCode();
    }
    if (getBgpPeerStatusCount() > 0) {
      hash = (37 * hash) + BGP_PEER_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getBgpPeerStatusList().hashCode();
    }
    if (getNatStatusCount() > 0) {
      hash = (37 * hash) + NAT_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getNatStatusList().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.RouterStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.RouterStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.RouterStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.RouterStatus)
      com.google.cloud.compute.v1.RouterStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.RouterStatus.class,
              com.google.cloud.compute.v1.RouterStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.RouterStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bestRoutesBuilder_ == null) {
        bestRoutes_ = java.util.Collections.emptyList();
      } else {
        bestRoutes_ = null;
        bestRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (bestRoutesForRouterBuilder_ == null) {
        bestRoutesForRouter_ = java.util.Collections.emptyList();
      } else {
        bestRoutesForRouter_ = null;
        bestRoutesForRouterBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (bgpPeerStatusBuilder_ == null) {
        bgpPeerStatus_ = java.util.Collections.emptyList();
      } else {
        bgpPeerStatus_ = null;
        bgpPeerStatusBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (natStatusBuilder_ == null) {
        natStatus_ = java.util.Collections.emptyList();
      } else {
        natStatus_ = null;
        natStatusBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      network_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_RouterStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.RouterStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatus build() {
      com.google.cloud.compute.v1.RouterStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.RouterStatus buildPartial() {
      com.google.cloud.compute.v1.RouterStatus result =
          new com.google.cloud.compute.v1.RouterStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.RouterStatus result) {
      if (bestRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          bestRoutes_ = java.util.Collections.unmodifiableList(bestRoutes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.bestRoutes_ = bestRoutes_;
      } else {
        result.bestRoutes_ = bestRoutesBuilder_.build();
      }
      if (bestRoutesForRouterBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bestRoutesForRouter_ = java.util.Collections.unmodifiableList(bestRoutesForRouter_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bestRoutesForRouter_ = bestRoutesForRouter_;
      } else {
        result.bestRoutesForRouter_ = bestRoutesForRouterBuilder_.build();
      }
      if (bgpPeerStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          bgpPeerStatus_ = java.util.Collections.unmodifiableList(bgpPeerStatus_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.bgpPeerStatus_ = bgpPeerStatus_;
      } else {
        result.bgpPeerStatus_ = bgpPeerStatusBuilder_.build();
      }
      if (natStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          natStatus_ = java.util.Collections.unmodifiableList(natStatus_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.natStatus_ = natStatus_;
      } else {
        result.natStatus_ = natStatusBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.RouterStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.RouterStatus) {
        return mergeFrom((com.google.cloud.compute.v1.RouterStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.RouterStatus other) {
      if (other == com.google.cloud.compute.v1.RouterStatus.getDefaultInstance()) return this;
      if (bestRoutesBuilder_ == null) {
        if (!other.bestRoutes_.isEmpty()) {
          if (bestRoutes_.isEmpty()) {
            bestRoutes_ = other.bestRoutes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBestRoutesIsMutable();
            bestRoutes_.addAll(other.bestRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.bestRoutes_.isEmpty()) {
          if (bestRoutesBuilder_.isEmpty()) {
            bestRoutesBuilder_.dispose();
            bestRoutesBuilder_ = null;
            bestRoutes_ = other.bestRoutes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            bestRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBestRoutesFieldBuilder()
                    : null;
          } else {
            bestRoutesBuilder_.addAllMessages(other.bestRoutes_);
          }
        }
      }
      if (bestRoutesForRouterBuilder_ == null) {
        if (!other.bestRoutesForRouter_.isEmpty()) {
          if (bestRoutesForRouter_.isEmpty()) {
            bestRoutesForRouter_ = other.bestRoutesForRouter_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBestRoutesForRouterIsMutable();
            bestRoutesForRouter_.addAll(other.bestRoutesForRouter_);
          }
          onChanged();
        }
      } else {
        if (!other.bestRoutesForRouter_.isEmpty()) {
          if (bestRoutesForRouterBuilder_.isEmpty()) {
            bestRoutesForRouterBuilder_.dispose();
            bestRoutesForRouterBuilder_ = null;
            bestRoutesForRouter_ = other.bestRoutesForRouter_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bestRoutesForRouterBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBestRoutesForRouterFieldBuilder()
                    : null;
          } else {
            bestRoutesForRouterBuilder_.addAllMessages(other.bestRoutesForRouter_);
          }
        }
      }
      if (bgpPeerStatusBuilder_ == null) {
        if (!other.bgpPeerStatus_.isEmpty()) {
          if (bgpPeerStatus_.isEmpty()) {
            bgpPeerStatus_ = other.bgpPeerStatus_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureBgpPeerStatusIsMutable();
            bgpPeerStatus_.addAll(other.bgpPeerStatus_);
          }
          onChanged();
        }
      } else {
        if (!other.bgpPeerStatus_.isEmpty()) {
          if (bgpPeerStatusBuilder_.isEmpty()) {
            bgpPeerStatusBuilder_.dispose();
            bgpPeerStatusBuilder_ = null;
            bgpPeerStatus_ = other.bgpPeerStatus_;
            bitField0_ = (bitField0_ & ~0x00000004);
            bgpPeerStatusBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBgpPeerStatusFieldBuilder()
                    : null;
          } else {
            bgpPeerStatusBuilder_.addAllMessages(other.bgpPeerStatus_);
          }
        }
      }
      if (natStatusBuilder_ == null) {
        if (!other.natStatus_.isEmpty()) {
          if (natStatus_.isEmpty()) {
            natStatus_ = other.natStatus_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureNatStatusIsMutable();
            natStatus_.addAll(other.natStatus_);
          }
          onChanged();
        }
      } else {
        if (!other.natStatus_.isEmpty()) {
          if (natStatusBuilder_.isEmpty()) {
            natStatusBuilder_.dispose();
            natStatusBuilder_ = null;
            natStatus_ = other.natStatus_;
            bitField0_ = (bitField0_ & ~0x00000008);
            natStatusBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNatStatusFieldBuilder()
                    : null;
          } else {
            natStatusBuilder_.addAllMessages(other.natStatus_);
          }
        }
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 504784514:
              {
                com.google.cloud.compute.v1.RouterStatusNatStatus m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterStatusNatStatus.parser(),
                        extensionRegistry);
                if (natStatusBuilder_ == null) {
                  ensureNatStatusIsMutable();
                  natStatus_.add(m);
                } else {
                  natStatusBuilder_.addMessage(m);
                }
                break;
              } // case 504784514
            case 955117514:
              {
                com.google.cloud.compute.v1.Route m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Route.parser(), extensionRegistry);
                if (bestRoutesForRouterBuilder_ == null) {
                  ensureBestRoutesForRouterIsMutable();
                  bestRoutesForRouter_.add(m);
                } else {
                  bestRoutesForRouterBuilder_.addMessage(m);
                }
                break;
              } // case 955117514
            case 1747673050:
              {
                com.google.cloud.compute.v1.RouterStatusBgpPeerStatus m =
                    input.readMessage(
                        com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.parser(),
                        extensionRegistry);
                if (bgpPeerStatusBuilder_ == null) {
                  ensureBgpPeerStatusIsMutable();
                  bgpPeerStatus_.add(m);
                } else {
                  bgpPeerStatusBuilder_.addMessage(m);
                }
                break;
              } // case 1747673050
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1862979954
            case -1128353750:
              {
                com.google.cloud.compute.v1.Route m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Route.parser(), extensionRegistry);
                if (bestRoutesBuilder_ == null) {
                  ensureBestRoutesIsMutable();
                  bestRoutes_.add(m);
                } else {
                  bestRoutesBuilder_.addMessage(m);
                }
                break;
              } // case -1128353750
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.Route> bestRoutes_ =
        java.util.Collections.emptyList();

    private void ensureBestRoutesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        bestRoutes_ = new java.util.ArrayList<com.google.cloud.compute.v1.Route>(bestRoutes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        bestRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route> getBestRoutesList() {
      if (bestRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bestRoutes_);
      } else {
        return bestRoutesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public int getBestRoutesCount() {
      if (bestRoutesBuilder_ == null) {
        return bestRoutes_.size();
      } else {
        return bestRoutesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public com.google.cloud.compute.v1.Route getBestRoutes(int index) {
      if (bestRoutesBuilder_ == null) {
        return bestRoutes_.get(index);
      } else {
        return bestRoutesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder setBestRoutes(int index, com.google.cloud.compute.v1.Route value) {
      if (bestRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesIsMutable();
        bestRoutes_.set(index, value);
        onChanged();
      } else {
        bestRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder setBestRoutes(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesBuilder_ == null) {
        ensureBestRoutesIsMutable();
        bestRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        bestRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder addBestRoutes(com.google.cloud.compute.v1.Route value) {
      if (bestRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesIsMutable();
        bestRoutes_.add(value);
        onChanged();
      } else {
        bestRoutesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder addBestRoutes(int index, com.google.cloud.compute.v1.Route value) {
      if (bestRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesIsMutable();
        bestRoutes_.add(index, value);
        onChanged();
      } else {
        bestRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder addBestRoutes(com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesBuilder_ == null) {
        ensureBestRoutesIsMutable();
        bestRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        bestRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder addBestRoutes(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesBuilder_ == null) {
        ensureBestRoutesIsMutable();
        bestRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        bestRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder addAllBestRoutes(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Route> values) {
      if (bestRoutesBuilder_ == null) {
        ensureBestRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bestRoutes_);
        onChanged();
      } else {
        bestRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder clearBestRoutes() {
      if (bestRoutesBuilder_ == null) {
        bestRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        bestRoutesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public Builder removeBestRoutes(int index) {
      if (bestRoutesBuilder_ == null) {
        ensureBestRoutesIsMutable();
        bestRoutes_.remove(index);
        onChanged();
      } else {
        bestRoutesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder getBestRoutesBuilder(int index) {
      return getBestRoutesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public com.google.cloud.compute.v1.RouteOrBuilder getBestRoutesOrBuilder(int index) {
      if (bestRoutesBuilder_ == null) {
        return bestRoutes_.get(index);
      } else {
        return bestRoutesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
        getBestRoutesOrBuilderList() {
      if (bestRoutesBuilder_ != null) {
        return bestRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bestRoutes_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addBestRoutesBuilder() {
      return getBestRoutesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addBestRoutesBuilder(int index) {
      return getBestRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the best dynamic routes for this Cloud Router's Virtual Private Cloud (VPC) network in the same region as this Cloud Router. Lists all of the best routes per prefix that are programmed into this region's VPC data plane. When global dynamic routing mode is turned on in the VPC network, this list can include cross-region dynamic routes from Cloud Routers in other regions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes = 395826693;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route.Builder> getBestRoutesBuilderList() {
      return getBestRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        getBestRoutesFieldBuilder() {
      if (bestRoutesBuilder_ == null) {
        bestRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Route,
                com.google.cloud.compute.v1.Route.Builder,
                com.google.cloud.compute.v1.RouteOrBuilder>(
                bestRoutes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        bestRoutes_ = null;
      }
      return bestRoutesBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.Route> bestRoutesForRouter_ =
        java.util.Collections.emptyList();

    private void ensureBestRoutesForRouterIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bestRoutesForRouter_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.Route>(bestRoutesForRouter_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        bestRoutesForRouterBuilder_;

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route> getBestRoutesForRouterList() {
      if (bestRoutesForRouterBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bestRoutesForRouter_);
      } else {
        return bestRoutesForRouterBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public int getBestRoutesForRouterCount() {
      if (bestRoutesForRouterBuilder_ == null) {
        return bestRoutesForRouter_.size();
      } else {
        return bestRoutesForRouterBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public com.google.cloud.compute.v1.Route getBestRoutesForRouter(int index) {
      if (bestRoutesForRouterBuilder_ == null) {
        return bestRoutesForRouter_.get(index);
      } else {
        return bestRoutesForRouterBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder setBestRoutesForRouter(int index, com.google.cloud.compute.v1.Route value) {
      if (bestRoutesForRouterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.set(index, value);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder setBestRoutesForRouter(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesForRouterBuilder_ == null) {
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.set(index, builderForValue.build());
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder addBestRoutesForRouter(com.google.cloud.compute.v1.Route value) {
      if (bestRoutesForRouterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.add(value);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder addBestRoutesForRouter(int index, com.google.cloud.compute.v1.Route value) {
      if (bestRoutesForRouterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.add(index, value);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder addBestRoutesForRouter(
        com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesForRouterBuilder_ == null) {
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.add(builderForValue.build());
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder addBestRoutesForRouter(
        int index, com.google.cloud.compute.v1.Route.Builder builderForValue) {
      if (bestRoutesForRouterBuilder_ == null) {
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.add(index, builderForValue.build());
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder addAllBestRoutesForRouter(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Route> values) {
      if (bestRoutesForRouterBuilder_ == null) {
        ensureBestRoutesForRouterIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bestRoutesForRouter_);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder clearBestRoutesForRouter() {
      if (bestRoutesForRouterBuilder_ == null) {
        bestRoutesForRouter_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public Builder removeBestRoutesForRouter(int index) {
      if (bestRoutesForRouterBuilder_ == null) {
        ensureBestRoutesForRouterIsMutable();
        bestRoutesForRouter_.remove(index);
        onChanged();
      } else {
        bestRoutesForRouterBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder getBestRoutesForRouterBuilder(int index) {
      return getBestRoutesForRouterFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public com.google.cloud.compute.v1.RouteOrBuilder getBestRoutesForRouterOrBuilder(int index) {
      if (bestRoutesForRouterBuilder_ == null) {
        return bestRoutesForRouter_.get(index);
      } else {
        return bestRoutesForRouterBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouteOrBuilder>
        getBestRoutesForRouterOrBuilderList() {
      if (bestRoutesForRouterBuilder_ != null) {
        return bestRoutesForRouterBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bestRoutesForRouter_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addBestRoutesForRouterBuilder() {
      return getBestRoutesForRouterFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public com.google.cloud.compute.v1.Route.Builder addBestRoutesForRouterBuilder(int index) {
      return getBestRoutesForRouterFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of the best BGP routes learned by this Cloud Router. It is possible that routes listed might not be programmed into the data plane, if the Google Cloud control plane finds a more optimal route for a prefix than a route learned by this Cloud Router.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Route best_routes_for_router = 119389689;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Route.Builder>
        getBestRoutesForRouterBuilderList() {
      return getBestRoutesForRouterFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Route,
            com.google.cloud.compute.v1.Route.Builder,
            com.google.cloud.compute.v1.RouteOrBuilder>
        getBestRoutesForRouterFieldBuilder() {
      if (bestRoutesForRouterBuilder_ == null) {
        bestRoutesForRouterBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Route,
                com.google.cloud.compute.v1.Route.Builder,
                com.google.cloud.compute.v1.RouteOrBuilder>(
                bestRoutesForRouter_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        bestRoutesForRouter_ = null;
      }
      return bestRoutesForRouterBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus> bgpPeerStatus_ =
        java.util.Collections.emptyList();

    private void ensureBgpPeerStatusIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        bgpPeerStatus_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus>(
                bgpPeerStatus_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus,
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder>
        bgpPeerStatusBuilder_;

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus>
        getBgpPeerStatusList() {
      if (bgpPeerStatusBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bgpPeerStatus_);
      } else {
        return bgpPeerStatusBuilder_.getMessageList();
      }
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public int getBgpPeerStatusCount() {
      if (bgpPeerStatusBuilder_ == null) {
        return bgpPeerStatus_.size();
      } else {
        return bgpPeerStatusBuilder_.getCount();
      }
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus getBgpPeerStatus(int index) {
      if (bgpPeerStatusBuilder_ == null) {
        return bgpPeerStatus_.get(index);
      } else {
        return bgpPeerStatusBuilder_.getMessage(index);
      }
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder setBgpPeerStatus(
        int index, com.google.cloud.compute.v1.RouterStatusBgpPeerStatus value) {
      if (bgpPeerStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.set(index, value);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder setBgpPeerStatus(
        int index, com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder builderForValue) {
      if (bgpPeerStatusBuilder_ == null) {
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.set(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeerStatusBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder addBgpPeerStatus(com.google.cloud.compute.v1.RouterStatusBgpPeerStatus value) {
      if (bgpPeerStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.add(value);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder addBgpPeerStatus(
        int index, com.google.cloud.compute.v1.RouterStatusBgpPeerStatus value) {
      if (bgpPeerStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.add(index, value);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder addBgpPeerStatus(
        com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder builderForValue) {
      if (bgpPeerStatusBuilder_ == null) {
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.add(builderForValue.build());
        onChanged();
      } else {
        bgpPeerStatusBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder addBgpPeerStatus(
        int index, com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder builderForValue) {
      if (bgpPeerStatusBuilder_ == null) {
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.add(index, builderForValue.build());
        onChanged();
      } else {
        bgpPeerStatusBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder addAllBgpPeerStatus(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterStatusBgpPeerStatus>
            values) {
      if (bgpPeerStatusBuilder_ == null) {
        ensureBgpPeerStatusIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bgpPeerStatus_);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder clearBgpPeerStatus() {
      if (bgpPeerStatusBuilder_ == null) {
        bgpPeerStatus_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.clear();
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public Builder removeBgpPeerStatus(int index) {
      if (bgpPeerStatusBuilder_ == null) {
        ensureBgpPeerStatusIsMutable();
        bgpPeerStatus_.remove(index);
        onChanged();
      } else {
        bgpPeerStatusBuilder_.remove(index);
      }
      return this;
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder getBgpPeerStatusBuilder(
        int index) {
      return getBgpPeerStatusFieldBuilder().getBuilder(index);
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder getBgpPeerStatusOrBuilder(
        int index) {
      if (bgpPeerStatusBuilder_ == null) {
        return bgpPeerStatus_.get(index);
      } else {
        return bgpPeerStatusBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder>
        getBgpPeerStatusOrBuilderList() {
      if (bgpPeerStatusBuilder_ != null) {
        return bgpPeerStatusBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bgpPeerStatus_);
      }
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder addBgpPeerStatusBuilder() {
      return getBgpPeerStatusFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDefaultInstance());
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder addBgpPeerStatusBuilder(
        int index) {
      return getBgpPeerStatusFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.getDefaultInstance());
    }

    /**
     * <code>
     * repeated .google.cloud.compute.v1.RouterStatusBgpPeerStatus bgp_peer_status = 218459131;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder>
        getBgpPeerStatusBuilderList() {
      return getBgpPeerStatusFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus,
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder>
        getBgpPeerStatusFieldBuilder() {
      if (bgpPeerStatusBuilder_ == null) {
        bgpPeerStatusBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterStatusBgpPeerStatus,
                com.google.cloud.compute.v1.RouterStatusBgpPeerStatus.Builder,
                com.google.cloud.compute.v1.RouterStatusBgpPeerStatusOrBuilder>(
                bgpPeerStatus_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        bgpPeerStatus_ = null;
      }
      return bgpPeerStatusBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatus> natStatus_ =
        java.util.Collections.emptyList();

    private void ensureNatStatusIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        natStatus_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.RouterStatusNatStatus>(natStatus_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusNatStatus,
            com.google.cloud.compute.v1.RouterStatusNatStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder>
        natStatusBuilder_;

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatus> getNatStatusList() {
      if (natStatusBuilder_ == null) {
        return java.util.Collections.unmodifiableList(natStatus_);
      } else {
        return natStatusBuilder_.getMessageList();
      }
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public int getNatStatusCount() {
      if (natStatusBuilder_ == null) {
        return natStatus_.size();
      } else {
        return natStatusBuilder_.getCount();
      }
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatus getNatStatus(int index) {
      if (natStatusBuilder_ == null) {
        return natStatus_.get(index);
      } else {
        return natStatusBuilder_.getMessage(index);
      }
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder setNatStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatus value) {
      if (natStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatStatusIsMutable();
        natStatus_.set(index, value);
        onChanged();
      } else {
        natStatusBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder setNatStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatus.Builder builderForValue) {
      if (natStatusBuilder_ == null) {
        ensureNatStatusIsMutable();
        natStatus_.set(index, builderForValue.build());
        onChanged();
      } else {
        natStatusBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder addNatStatus(com.google.cloud.compute.v1.RouterStatusNatStatus value) {
      if (natStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatStatusIsMutable();
        natStatus_.add(value);
        onChanged();
      } else {
        natStatusBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder addNatStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatus value) {
      if (natStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNatStatusIsMutable();
        natStatus_.add(index, value);
        onChanged();
      } else {
        natStatusBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder addNatStatus(
        com.google.cloud.compute.v1.RouterStatusNatStatus.Builder builderForValue) {
      if (natStatusBuilder_ == null) {
        ensureNatStatusIsMutable();
        natStatus_.add(builderForValue.build());
        onChanged();
      } else {
        natStatusBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder addNatStatus(
        int index, com.google.cloud.compute.v1.RouterStatusNatStatus.Builder builderForValue) {
      if (natStatusBuilder_ == null) {
        ensureNatStatusIsMutable();
        natStatus_.add(index, builderForValue.build());
        onChanged();
      } else {
        natStatusBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder addAllNatStatus(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.RouterStatusNatStatus> values) {
      if (natStatusBuilder_ == null) {
        ensureNatStatusIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, natStatus_);
        onChanged();
      } else {
        natStatusBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder clearNatStatus() {
      if (natStatusBuilder_ == null) {
        natStatus_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        natStatusBuilder_.clear();
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public Builder removeNatStatus(int index) {
      if (natStatusBuilder_ == null) {
        ensureNatStatusIsMutable();
        natStatus_.remove(index);
        onChanged();
      } else {
        natStatusBuilder_.remove(index);
      }
      return this;
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatus.Builder getNatStatusBuilder(
        int index) {
      return getNatStatusFieldBuilder().getBuilder(index);
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder getNatStatusOrBuilder(
        int index) {
      if (natStatusBuilder_ == null) {
        return natStatus_.get(index);
      } else {
        return natStatusBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder>
        getNatStatusOrBuilderList() {
      if (natStatusBuilder_ != null) {
        return natStatusBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(natStatus_);
      }
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatus.Builder addNatStatusBuilder() {
      return getNatStatusFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.RouterStatusNatStatus.getDefaultInstance());
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public com.google.cloud.compute.v1.RouterStatusNatStatus.Builder addNatStatusBuilder(
        int index) {
      return getNatStatusFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.RouterStatusNatStatus.getDefaultInstance());
    }

    /**
     * <code>repeated .google.cloud.compute.v1.RouterStatusNatStatus nat_status = 63098064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.RouterStatusNatStatus.Builder>
        getNatStatusBuilderList() {
      return getNatStatusFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.RouterStatusNatStatus,
            com.google.cloud.compute.v1.RouterStatusNatStatus.Builder,
            com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder>
        getNatStatusFieldBuilder() {
      if (natStatusBuilder_ == null) {
        natStatusBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.RouterStatusNatStatus,
                com.google.cloud.compute.v1.RouterStatusNatStatus.Builder,
                com.google.cloud.compute.v1.RouterStatusNatStatusOrBuilder>(
                natStatus_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        natStatus_ = null;
      }
      return natStatusBuilder_;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI of the network to which this router belongs.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.RouterStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.RouterStatus)
  private static final com.google.cloud.compute.v1.RouterStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.RouterStatus();
  }

  public static com.google.cloud.compute.v1.RouterStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouterStatus> PARSER =
      new com.google.protobuf.AbstractParser<RouterStatus>() {
        @java.lang.Override
        public RouterStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouterStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouterStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.RouterStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
