/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Persistent Disk Snapshot resource. You can use snapshots to back up data on a regular interval. For more information, read Creating persistent disk snapshots. LINT.IfChange
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Snapshot}
 */
public final class Snapshot extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Snapshot)
    SnapshotOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Snapshot.newBuilder() to construct.
  private Snapshot(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Snapshot() {
    architecture_ = "";
    chainName_ = "";
    creationTimestamp_ = "";
    description_ = "";
    guestOsFeatures_ = java.util.Collections.emptyList();
    kind_ = "";
    labelFingerprint_ = "";
    licenseCodes_ = emptyLongList();
    licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    locationHint_ = "";
    name_ = "";
    selfLink_ = "";
    snapshotType_ = "";
    sourceDisk_ = "";
    sourceDiskForRecoveryCheckpoint_ = "";
    sourceDiskId_ = "";
    sourceInstantSnapshot_ = "";
    sourceInstantSnapshotId_ = "";
    sourceSnapshotSchedulePolicy_ = "";
    sourceSnapshotSchedulePolicyId_ = "";
    status_ = "";
    storageBytesStatus_ = "";
    storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Snapshot();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Snapshot_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Snapshot_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Snapshot.class,
            com.google.cloud.compute.v1.Snapshot.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Snapshot.Architecture}
   */
  public enum Architecture implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    UNDEFINED_ARCHITECTURE(0),
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    ARCHITECTURE_UNSPECIFIED(394750507),
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    ARM64(62547450),
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    X86_64(425300551),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    public static final int UNDEFINED_ARCHITECTURE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 394750507;

    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    public static final int ARM64_VALUE = 62547450;

    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    public static final int X86_64_VALUE = 425300551;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Architecture valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Architecture forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ARCHITECTURE;
        case 394750507:
          return ARCHITECTURE_UNSPECIFIED;
        case 62547450:
          return ARM64;
        case 425300551:
          return X86_64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Architecture> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Architecture> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Architecture>() {
          public Architecture findValueByNumber(int number) {
            return Architecture.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Snapshot.getDescriptor().getEnumTypes().get(0);
    }

    private static final Architecture[] VALUES = values();

    public static Architecture valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Architecture(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Snapshot.Architecture)
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of the snapshot.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Snapshot.SnapshotType}
   */
  public enum SnapshotType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SNAPSHOT_TYPE = 0;</code>
     */
    UNDEFINED_SNAPSHOT_TYPE(0),
    /** <code>ARCHIVE = 506752162;</code> */
    ARCHIVE(506752162),
    /** <code>STANDARD = 484642493;</code> */
    STANDARD(484642493),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_SNAPSHOT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_SNAPSHOT_TYPE_VALUE = 0;

    /** <code>ARCHIVE = 506752162;</code> */
    public static final int ARCHIVE_VALUE = 506752162;

    /** <code>STANDARD = 484642493;</code> */
    public static final int STANDARD_VALUE = 484642493;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SnapshotType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SnapshotType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_SNAPSHOT_TYPE;
        case 506752162:
          return ARCHIVE;
        case 484642493:
          return STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SnapshotType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SnapshotType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SnapshotType>() {
          public SnapshotType findValueByNumber(int number) {
            return SnapshotType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Snapshot.getDescriptor().getEnumTypes().get(1);
    }

    private static final SnapshotType[] VALUES = values();

    public static SnapshotType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SnapshotType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Snapshot.SnapshotType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Snapshot.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * Snapshot creation is in progress.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    CREATING(455564985),
    /**
     *
     *
     * <pre>
     * Snapshot is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * Snapshot creation failed.
     * </pre>
     *
     * <code>FAILED = 455706685;</code>
     */
    FAILED(455706685),
    /**
     *
     *
     * <pre>
     * Snapshot has been created successfully.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    READY(77848963),
    /**
     *
     *
     * <pre>
     * Snapshot is being uploaded.
     * </pre>
     *
     * <code>UPLOADING = 267603489;</code>
     */
    UPLOADING(267603489),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Snapshot creation is in progress.
     * </pre>
     *
     * <code>CREATING = 455564985;</code>
     */
    public static final int CREATING_VALUE = 455564985;

    /**
     *
     *
     * <pre>
     * Snapshot is currently being deleted.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;

    /**
     *
     *
     * <pre>
     * Snapshot creation failed.
     * </pre>
     *
     * <code>FAILED = 455706685;</code>
     */
    public static final int FAILED_VALUE = 455706685;

    /**
     *
     *
     * <pre>
     * Snapshot has been created successfully.
     * </pre>
     *
     * <code>READY = 77848963;</code>
     */
    public static final int READY_VALUE = 77848963;

    /**
     *
     *
     * <pre>
     * Snapshot is being uploaded.
     * </pre>
     *
     * <code>UPLOADING = 267603489;</code>
     */
    public static final int UPLOADING_VALUE = 267603489;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 455564985:
          return CREATING;
        case 528602024:
          return DELETING;
        case 455706685:
          return FAILED;
        case 77848963:
          return READY;
        case 267603489:
          return UPLOADING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Snapshot.getDescriptor().getEnumTypes().get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Snapshot.Status)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Snapshot.StorageBytesStatus}
   */
  public enum StorageBytesStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STORAGE_BYTES_STATUS = 0;</code>
     */
    UNDEFINED_STORAGE_BYTES_STATUS(0),
    /** <code>UPDATING = 494614342;</code> */
    UPDATING(494614342),
    /** <code>UP_TO_DATE = 101306702;</code> */
    UP_TO_DATE(101306702),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STORAGE_BYTES_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STORAGE_BYTES_STATUS_VALUE = 0;

    /** <code>UPDATING = 494614342;</code> */
    public static final int UPDATING_VALUE = 494614342;

    /** <code>UP_TO_DATE = 101306702;</code> */
    public static final int UP_TO_DATE_VALUE = 101306702;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StorageBytesStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StorageBytesStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STORAGE_BYTES_STATUS;
        case 494614342:
          return UPDATING;
        case 101306702:
          return UP_TO_DATE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>() {
              public StorageBytesStatus findValueByNumber(int number) {
                return StorageBytesStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Snapshot.getDescriptor().getEnumTypes().get(3);
    }

    private static final StorageBytesStatus[] VALUES = values();

    public static StorageBytesStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StorageBytesStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Snapshot.StorageBytesStatus)
  }

  private int bitField0_;
  public static final int ARCHITECTURE_FIELD_NUMBER = 302803283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object architecture_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public java.lang.String getArchitecture() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      architecture_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArchitectureBytes() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      architecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTO_CREATED_FIELD_NUMBER = 463922264;
  private boolean autoCreated_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
   * </pre>
   *
   * <code>optional bool auto_created = 463922264;</code>
   *
   * @return Whether the autoCreated field is set.
   */
  @java.lang.Override
  public boolean hasAutoCreated() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
   * </pre>
   *
   * <code>optional bool auto_created = 463922264;</code>
   *
   * @return The autoCreated.
   */
  @java.lang.Override
  public boolean getAutoCreated() {
    return autoCreated_;
  }

  public static final int CHAIN_NAME_FIELD_NUMBER = 68644169;

  @SuppressWarnings("serial")
  private volatile java.lang.Object chainName_ = "";

  /**
   *
   *
   * <pre>
   * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return Whether the chainName field is set.
   */
  @java.lang.Override
  public boolean hasChainName() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return The chainName.
   */
  @java.lang.Override
  public java.lang.String getChainName() {
    java.lang.Object ref = chainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      chainName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
   * </pre>
   *
   * <code>optional string chain_name = 68644169;</code>
   *
   * @return The bytes for chainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChainNameBytes() {
    java.lang.Object ref = chainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      chainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_SIZE_BYTES_FIELD_NUMBER = 125400077;
  private long creationSizeBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Size in bytes of the snapshot at creation time.
   * </pre>
   *
   * <code>optional int64 creation_size_bytes = 125400077;</code>
   *
   * @return Whether the creationSizeBytes field is set.
   */
  @java.lang.Override
  public boolean hasCreationSizeBytes() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Size in bytes of the snapshot at creation time.
   * </pre>
   *
   * <code>optional int64 creation_size_bytes = 125400077;</code>
   *
   * @return The creationSizeBytes.
   */
  @java.lang.Override
  public long getCreationSizeBytes() {
    return creationSizeBytes_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 316263735;
  private long diskSizeGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Size of the source disk, specified in GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return Whether the diskSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasDiskSizeGb() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Size of the source disk, specified in GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int DOWNLOAD_BYTES_FIELD_NUMBER = 435054068;
  private long downloadBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
   * </pre>
   *
   * <code>optional int64 download_bytes = 435054068;</code>
   *
   * @return Whether the downloadBytes field is set.
   */
  @java.lang.Override
  public boolean hasDownloadBytes() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
   * </pre>
   *
   * <code>optional int64 download_bytes = 435054068;</code>
   *
   * @return The downloadBytes.
   */
  @java.lang.Override
  public long getDownloadBytes() {
    return downloadBytes_;
  }

  public static final int ENABLE_CONFIDENTIAL_COMPUTE_FIELD_NUMBER = 102135228;
  private boolean enableConfidentialCompute_ = false;

  /**
   *
   *
   * <pre>
   * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
   * </pre>
   *
   * <code>optional bool enable_confidential_compute = 102135228;</code>
   *
   * @return Whether the enableConfidentialCompute field is set.
   */
  @java.lang.Override
  public boolean hasEnableConfidentialCompute() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
   * </pre>
   *
   * <code>optional bool enable_confidential_compute = 102135228;</code>
   *
   * @return The enableConfidentialCompute.
   */
  @java.lang.Override
  public boolean getEnableConfidentialCompute() {
    return enableConfidentialCompute_;
  }

  public static final int GUEST_FLUSH_FIELD_NUMBER = 385550813;
  private boolean guestFlush_ = false;

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return Whether the guestFlush field is set.
   */
  @java.lang.Override
  public boolean hasGuestFlush() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return The guestFlush.
   */
  @java.lang.Override
  public boolean getGuestFlush() {
    return guestFlush_;
  }

  public static final int GUEST_OS_FEATURES_FIELD_NUMBER = 79294545;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.GuestOsFeature> guestOsFeatures_;

  /**
   *
   *
   * <pre>
   * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.GuestOsFeature> getGuestOsFeaturesList() {
    return guestOsFeatures_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
      getGuestOsFeaturesOrBuilderList() {
    return guestOsFeatures_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public int getGuestOsFeaturesCount() {
    return guestOsFeatures_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GuestOsFeature getGuestOsFeatures(int index) {
    return guestOsFeatures_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.GuestOsFeatureOrBuilder getGuestOsFeaturesOrBuilder(
      int index) {
    return guestOsFeatures_.get(index);
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_Snapshot_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LICENSE_CODES_FIELD_NUMBER = 45482664;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList licenseCodes_ = emptyLongList();

  /**
   *
   *
   * <pre>
   * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @return A list containing the licenseCodes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getLicenseCodesList() {
    return licenseCodes_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @return The count of licenseCodes.
   */
  public int getLicenseCodesCount() {
    return licenseCodes_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
   * </pre>
   *
   * <code>repeated int64 license_codes = 45482664;</code>
   *
   * @param index The index of the element to return.
   * @return The licenseCodes at the given index.
   */
  public long getLicenseCodes(int index) {
    return licenseCodes_.getLong(index);
  }

  private int licenseCodesMemoizedSerializedSize = -1;

  public static final int LICENSES_FIELD_NUMBER = 337642578;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList licenses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return A list containing the licenses.
   */
  public com.google.protobuf.ProtocolStringList getLicensesList() {
    return licenses_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return The count of licenses.
   */
  public int getLicensesCount() {
    return licenses_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the element to return.
   * @return The licenses at the given index.
   */
  public java.lang.String getLicenses(int index) {
    return licenses_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the licenses at the given index.
   */
  public com.google.protobuf.ByteString getLicensesBytes(int index) {
    return licenses_.getByteString(index);
  }

  public static final int LOCATION_HINT_FIELD_NUMBER = 350519505;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationHint_ = "";

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  @java.lang.Override
  public boolean hasLocationHint() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  @java.lang.Override
  public java.lang.String getLocationHint() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationHint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationHintBytes() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationHint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 480964257;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzi() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER = 43334526;
  private com.google.cloud.compute.v1.CustomerEncryptionKey snapshotEncryptionKey_;

  /**
   *
   *
   * <pre>
   * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
   * </code>
   *
   * @return Whether the snapshotEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotEncryptionKey() {
    return ((bitField0_ & 0x00040000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
   * </code>
   *
   * @return The snapshotEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSnapshotEncryptionKey() {
    return snapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : snapshotEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSnapshotEncryptionKeyOrBuilder() {
    return snapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : snapshotEncryptionKey_;
  }

  public static final int SNAPSHOT_TYPE_FIELD_NUMBER = 124349653;

  @SuppressWarnings("serial")
  private volatile java.lang.Object snapshotType_ = "";

  /**
   *
   *
   * <pre>
   * Indicates the type of the snapshot.
   * Check the SnapshotType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string snapshot_type = 124349653;</code>
   *
   * @return Whether the snapshotType field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotType() {
    return ((bitField0_ & 0x00080000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of the snapshot.
   * Check the SnapshotType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string snapshot_type = 124349653;</code>
   *
   * @return The snapshotType.
   */
  @java.lang.Override
  public java.lang.String getSnapshotType() {
    java.lang.Object ref = snapshotType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      snapshotType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of the snapshot.
   * Check the SnapshotType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string snapshot_type = 124349653;</code>
   *
   * @return The bytes for snapshotType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSnapshotTypeBytes() {
    java.lang.Object ref = snapshotType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      snapshotType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DISK_FIELD_NUMBER = 451753793;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDisk_ = "";

  /**
   *
   *
   * <pre>
   * The source disk used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return Whether the sourceDisk field is set.
   */
  @java.lang.Override
  public boolean hasSourceDisk() {
    return ((bitField0_ & 0x00100000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The source disk used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The sourceDisk.
   */
  @java.lang.Override
  public java.lang.String getSourceDisk() {
    java.lang.Object ref = sourceDisk_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDisk_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The source disk used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The bytes for sourceDisk.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDiskBytes() {
    java.lang.Object ref = sourceDisk_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDisk_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DISK_ENCRYPTION_KEY_FIELD_NUMBER = 531501153;
  private com.google.cloud.compute.v1.CustomerEncryptionKey sourceDiskEncryptionKey_;

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
   * </code>
   *
   * @return Whether the sourceDiskEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSourceDiskEncryptionKey() {
    return ((bitField0_ & 0x00200000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
   * </code>
   *
   * @return The sourceDiskEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceDiskEncryptionKey() {
    return sourceDiskEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceDiskEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceDiskEncryptionKeyOrBuilder() {
    return sourceDiskEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceDiskEncryptionKey_;
  }

  public static final int SOURCE_DISK_FOR_RECOVERY_CHECKPOINT_FIELD_NUMBER = 359837950;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDiskForRecoveryCheckpoint_ = "";

  /**
   *
   *
   * <pre>
   * The source disk whose recovery checkpoint will be used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
   *
   * @return Whether the sourceDiskForRecoveryCheckpoint field is set.
   */
  @java.lang.Override
  public boolean hasSourceDiskForRecoveryCheckpoint() {
    return ((bitField0_ & 0x00400000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The source disk whose recovery checkpoint will be used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
   *
   * @return The sourceDiskForRecoveryCheckpoint.
   */
  @java.lang.Override
  public java.lang.String getSourceDiskForRecoveryCheckpoint() {
    java.lang.Object ref = sourceDiskForRecoveryCheckpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDiskForRecoveryCheckpoint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The source disk whose recovery checkpoint will be used to create this snapshot.
   * </pre>
   *
   * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
   *
   * @return The bytes for sourceDiskForRecoveryCheckpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDiskForRecoveryCheckpointBytes() {
    java.lang.Object ref = sourceDiskForRecoveryCheckpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDiskForRecoveryCheckpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DISK_ID_FIELD_NUMBER = 454190809;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDiskId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return Whether the sourceDiskId field is set.
   */
  @java.lang.Override
  public boolean hasSourceDiskId() {
    return ((bitField0_ & 0x00800000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return The sourceDiskId.
   */
  @java.lang.Override
  public java.lang.String getSourceDiskId() {
    java.lang.Object ref = sourceDiskId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDiskId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
   * </pre>
   *
   * <code>optional string source_disk_id = 454190809;</code>
   *
   * @return The bytes for sourceDiskId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDiskIdBytes() {
    java.lang.Object ref = sourceDiskId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDiskId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_INSTANT_SNAPSHOT_FIELD_NUMBER = 219202054;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceInstantSnapshot_ = "";

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return Whether the sourceInstantSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstantSnapshot() {
    return ((bitField0_ & 0x01000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return The sourceInstantSnapshot.
   */
  @java.lang.Override
  public java.lang.String getSourceInstantSnapshot() {
    java.lang.Object ref = sourceInstantSnapshot_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceInstantSnapshot_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
   * </pre>
   *
   * <code>optional string source_instant_snapshot = 219202054;</code>
   *
   * @return The bytes for sourceInstantSnapshot.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceInstantSnapshotBytes() {
    java.lang.Object ref = sourceInstantSnapshot_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceInstantSnapshot_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_INSTANT_SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER = 436536060;
  private com.google.cloud.compute.v1.CustomerEncryptionKey sourceInstantSnapshotEncryptionKey_;

  /**
   *
   *
   * <pre>
   * Customer provided encryption key when creating Snapshot from Instant Snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
   * </code>
   *
   * @return Whether the sourceInstantSnapshotEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstantSnapshotEncryptionKey() {
    return ((bitField0_ & 0x02000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer provided encryption key when creating Snapshot from Instant Snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
   * </code>
   *
   * @return The sourceInstantSnapshotEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceInstantSnapshotEncryptionKey() {
    return sourceInstantSnapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceInstantSnapshotEncryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Customer provided encryption key when creating Snapshot from Instant Snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceInstantSnapshotEncryptionKeyOrBuilder() {
    return sourceInstantSnapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceInstantSnapshotEncryptionKey_;
  }

  public static final int SOURCE_INSTANT_SNAPSHOT_ID_FIELD_NUMBER = 287582708;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceInstantSnapshotId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return Whether the sourceInstantSnapshotId field is set.
   */
  @java.lang.Override
  public boolean hasSourceInstantSnapshotId() {
    return ((bitField0_ & 0x04000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return The sourceInstantSnapshotId.
   */
  @java.lang.Override
  public java.lang.String getSourceInstantSnapshotId() {
    java.lang.Object ref = sourceInstantSnapshotId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceInstantSnapshotId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
   * </pre>
   *
   * <code>optional string source_instant_snapshot_id = 287582708;</code>
   *
   * @return The bytes for sourceInstantSnapshotId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceInstantSnapshotIdBytes() {
    java.lang.Object ref = sourceInstantSnapshotId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceInstantSnapshotId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_SNAPSHOT_SCHEDULE_POLICY_FIELD_NUMBER = 235756291;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceSnapshotSchedulePolicy_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
   *
   * @return Whether the sourceSnapshotSchedulePolicy field is set.
   */
  @java.lang.Override
  public boolean hasSourceSnapshotSchedulePolicy() {
    return ((bitField0_ & 0x08000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
   *
   * @return The sourceSnapshotSchedulePolicy.
   */
  @java.lang.Override
  public java.lang.String getSourceSnapshotSchedulePolicy() {
    java.lang.Object ref = sourceSnapshotSchedulePolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceSnapshotSchedulePolicy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
   *
   * @return The bytes for sourceSnapshotSchedulePolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceSnapshotSchedulePolicyBytes() {
    java.lang.Object ref = sourceSnapshotSchedulePolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceSnapshotSchedulePolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_SNAPSHOT_SCHEDULE_POLICY_ID_FIELD_NUMBER = 70489047;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceSnapshotSchedulePolicyId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
   *
   * @return Whether the sourceSnapshotSchedulePolicyId field is set.
   */
  @java.lang.Override
  public boolean hasSourceSnapshotSchedulePolicyId() {
    return ((bitField0_ & 0x10000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
   *
   * @return The sourceSnapshotSchedulePolicyId.
   */
  @java.lang.Override
  public java.lang.String getSourceSnapshotSchedulePolicyId() {
    java.lang.Object ref = sourceSnapshotSchedulePolicyId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceSnapshotSchedulePolicyId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] ID of the resource policy which created this scheduled snapshot.
   * </pre>
   *
   * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
   *
   * @return The bytes for sourceSnapshotSchedulePolicyId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceSnapshotSchedulePolicyIdBytes() {
    java.lang.Object ref = sourceSnapshotSchedulePolicyId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceSnapshotSchedulePolicyId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x20000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_BYTES_FIELD_NUMBER = 424631719;
  private long storageBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
   * </pre>
   *
   * <code>optional int64 storage_bytes = 424631719;</code>
   *
   * @return Whether the storageBytes field is set.
   */
  @java.lang.Override
  public boolean hasStorageBytes() {
    return ((bitField0_ & 0x40000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
   * </pre>
   *
   * <code>optional int64 storage_bytes = 424631719;</code>
   *
   * @return The storageBytes.
   */
  @java.lang.Override
  public long getStorageBytes() {
    return storageBytes_;
  }

  public static final int STORAGE_BYTES_STATUS_FIELD_NUMBER = 490739082;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storageBytesStatus_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return Whether the storageBytesStatus field is set.
   */
  @java.lang.Override
  public boolean hasStorageBytesStatus() {
    return ((bitField0_ & 0x80000000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return The storageBytesStatus.
   */
  @java.lang.Override
  public java.lang.String getStorageBytesStatus() {
    java.lang.Object ref = storageBytesStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageBytesStatus_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return The bytes for storageBytesStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageBytesStatusBytes() {
    java.lang.Object ref = storageBytesStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageBytesStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_LOCATIONS_FIELD_NUMBER = 328005274;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList storageLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return A list containing the storageLocations.
   */
  public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
    return storageLocations_;
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return The count of storageLocations.
   */
  public int getStorageLocationsCount() {
    return storageLocations_.size();
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the element to return.
   * @return The storageLocations at the given index.
   */
  public java.lang.String getStorageLocations(int index) {
    return storageLocations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the storageLocations at the given index.
   */
  public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
    return storageLocations_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(43334526, getSnapshotEncryptionKey());
    }
    if (getLicenseCodesList().size() > 0) {
      output.writeUInt32NoTag(363861314);
      output.writeUInt32NoTag(licenseCodesMemoizedSerializedSize);
    }
    for (int i = 0; i < licenseCodes_.size(); i++) {
      output.writeInt64NoTag(licenseCodes_.getLong(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 68644169, chainName_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 70489047, sourceSnapshotSchedulePolicyId_);
    }
    for (int i = 0; i < guestOsFeatures_.size(); i++) {
      output.writeMessage(79294545, guestOsFeatures_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(102135228, enableConfidentialCompute_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 124349653, snapshotType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(125400077, creationSizeBytes_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 219202054, sourceInstantSnapshot_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 235756291, sourceSnapshotSchedulePolicy_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 287582708, sourceInstantSnapshotId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 302803283, architecture_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(316263735, diskSizeGb_);
    }
    for (int i = 0; i < storageLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 328005274, storageLocations_.getRaw(i));
    }
    for (int i = 0; i < licenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 337642578, licenses_.getRaw(i));
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 350519505, locationHint_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 359837950, sourceDiskForRecoveryCheckpoint_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(385550813, guestFlush_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      output.writeInt64(424631719, storageBytes_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt64(435054068, downloadBytes_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeMessage(436536060, getSourceInstantSnapshotEncryptionKey());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 451753793, sourceDisk_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 454190809, sourceDiskId_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(463922264, autoCreated_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeBool(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 490739082, storageBytesStatus_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeMessage(531501153, getSourceDiskEncryptionKey());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              43334526, getSnapshotEncryptionKey());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < licenseCodes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(licenseCodes_.getLong(i));
      }
      size += dataSize;
      if (!getLicenseCodesList().isEmpty()) {
        size += 5;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      licenseCodesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(68644169, chainName_);
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              70489047, sourceSnapshotSchedulePolicyId_);
    }
    for (int i = 0; i < guestOsFeatures_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              79294545, guestOsFeatures_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              102135228, enableConfidentialCompute_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(124349653, snapshotType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(125400077, creationSizeBytes_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              219202054, sourceInstantSnapshot_);
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              235756291, sourceSnapshotSchedulePolicy_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              287582708, sourceInstantSnapshotId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(302803283, architecture_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(316263735, diskSizeGb_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < storageLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(storageLocations_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getStorageLocationsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < licenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(licenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLicensesList().size();
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(350519505, locationHint_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              359837950, sourceDiskForRecoveryCheckpoint_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(385550813, guestFlush_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(424631719, storageBytes_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(435054068, downloadBytes_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              436536060, getSourceInstantSnapshotEncryptionKey());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(451753793, sourceDisk_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(454190809, sourceDiskId_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(463922264, autoCreated_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964257, satisfiesPzi_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(490739082, storageBytesStatus_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              531501153, getSourceDiskEncryptionKey());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Snapshot)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Snapshot other = (com.google.cloud.compute.v1.Snapshot) obj;

    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasAutoCreated() != other.hasAutoCreated()) return false;
    if (hasAutoCreated()) {
      if (getAutoCreated() != other.getAutoCreated()) return false;
    }
    if (hasChainName() != other.hasChainName()) return false;
    if (hasChainName()) {
      if (!getChainName().equals(other.getChainName())) return false;
    }
    if (hasCreationSizeBytes() != other.hasCreationSizeBytes()) return false;
    if (hasCreationSizeBytes()) {
      if (getCreationSizeBytes() != other.getCreationSizeBytes()) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDiskSizeGb() != other.hasDiskSizeGb()) return false;
    if (hasDiskSizeGb()) {
      if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    }
    if (hasDownloadBytes() != other.hasDownloadBytes()) return false;
    if (hasDownloadBytes()) {
      if (getDownloadBytes() != other.getDownloadBytes()) return false;
    }
    if (hasEnableConfidentialCompute() != other.hasEnableConfidentialCompute()) return false;
    if (hasEnableConfidentialCompute()) {
      if (getEnableConfidentialCompute() != other.getEnableConfidentialCompute()) return false;
    }
    if (hasGuestFlush() != other.hasGuestFlush()) return false;
    if (hasGuestFlush()) {
      if (getGuestFlush() != other.getGuestFlush()) return false;
    }
    if (!getGuestOsFeaturesList().equals(other.getGuestOsFeaturesList())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLicenseCodesList().equals(other.getLicenseCodesList())) return false;
    if (!getLicensesList().equals(other.getLicensesList())) return false;
    if (hasLocationHint() != other.hasLocationHint()) return false;
    if (hasLocationHint()) {
      if (!getLocationHint().equals(other.getLocationHint())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSatisfiesPzi() != other.hasSatisfiesPzi()) return false;
    if (hasSatisfiesPzi()) {
      if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSnapshotEncryptionKey() != other.hasSnapshotEncryptionKey()) return false;
    if (hasSnapshotEncryptionKey()) {
      if (!getSnapshotEncryptionKey().equals(other.getSnapshotEncryptionKey())) return false;
    }
    if (hasSnapshotType() != other.hasSnapshotType()) return false;
    if (hasSnapshotType()) {
      if (!getSnapshotType().equals(other.getSnapshotType())) return false;
    }
    if (hasSourceDisk() != other.hasSourceDisk()) return false;
    if (hasSourceDisk()) {
      if (!getSourceDisk().equals(other.getSourceDisk())) return false;
    }
    if (hasSourceDiskEncryptionKey() != other.hasSourceDiskEncryptionKey()) return false;
    if (hasSourceDiskEncryptionKey()) {
      if (!getSourceDiskEncryptionKey().equals(other.getSourceDiskEncryptionKey())) return false;
    }
    if (hasSourceDiskForRecoveryCheckpoint() != other.hasSourceDiskForRecoveryCheckpoint())
      return false;
    if (hasSourceDiskForRecoveryCheckpoint()) {
      if (!getSourceDiskForRecoveryCheckpoint().equals(other.getSourceDiskForRecoveryCheckpoint()))
        return false;
    }
    if (hasSourceDiskId() != other.hasSourceDiskId()) return false;
    if (hasSourceDiskId()) {
      if (!getSourceDiskId().equals(other.getSourceDiskId())) return false;
    }
    if (hasSourceInstantSnapshot() != other.hasSourceInstantSnapshot()) return false;
    if (hasSourceInstantSnapshot()) {
      if (!getSourceInstantSnapshot().equals(other.getSourceInstantSnapshot())) return false;
    }
    if (hasSourceInstantSnapshotEncryptionKey() != other.hasSourceInstantSnapshotEncryptionKey())
      return false;
    if (hasSourceInstantSnapshotEncryptionKey()) {
      if (!getSourceInstantSnapshotEncryptionKey()
          .equals(other.getSourceInstantSnapshotEncryptionKey())) return false;
    }
    if (hasSourceInstantSnapshotId() != other.hasSourceInstantSnapshotId()) return false;
    if (hasSourceInstantSnapshotId()) {
      if (!getSourceInstantSnapshotId().equals(other.getSourceInstantSnapshotId())) return false;
    }
    if (hasSourceSnapshotSchedulePolicy() != other.hasSourceSnapshotSchedulePolicy()) return false;
    if (hasSourceSnapshotSchedulePolicy()) {
      if (!getSourceSnapshotSchedulePolicy().equals(other.getSourceSnapshotSchedulePolicy()))
        return false;
    }
    if (hasSourceSnapshotSchedulePolicyId() != other.hasSourceSnapshotSchedulePolicyId())
      return false;
    if (hasSourceSnapshotSchedulePolicyId()) {
      if (!getSourceSnapshotSchedulePolicyId().equals(other.getSourceSnapshotSchedulePolicyId()))
        return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasStorageBytes() != other.hasStorageBytes()) return false;
    if (hasStorageBytes()) {
      if (getStorageBytes() != other.getStorageBytes()) return false;
    }
    if (hasStorageBytesStatus() != other.hasStorageBytesStatus()) return false;
    if (hasStorageBytesStatus()) {
      if (!getStorageBytesStatus().equals(other.getStorageBytesStatus())) return false;
    }
    if (!getStorageLocationsList().equals(other.getStorageLocationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasAutoCreated()) {
      hash = (37 * hash) + AUTO_CREATED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoCreated());
    }
    if (hasChainName()) {
      hash = (37 * hash) + CHAIN_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getChainName().hashCode();
    }
    if (hasCreationSizeBytes()) {
      hash = (37 * hash) + CREATION_SIZE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCreationSizeBytes());
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDiskSizeGb()) {
      hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    }
    if (hasDownloadBytes()) {
      hash = (37 * hash) + DOWNLOAD_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDownloadBytes());
    }
    if (hasEnableConfidentialCompute()) {
      hash = (37 * hash) + ENABLE_CONFIDENTIAL_COMPUTE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableConfidentialCompute());
    }
    if (hasGuestFlush()) {
      hash = (37 * hash) + GUEST_FLUSH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGuestFlush());
    }
    if (getGuestOsFeaturesCount() > 0) {
      hash = (37 * hash) + GUEST_OS_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getGuestOsFeaturesList().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getLicenseCodesCount() > 0) {
      hash = (37 * hash) + LICENSE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getLicenseCodesList().hashCode();
    }
    if (getLicensesCount() > 0) {
      hash = (37 * hash) + LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getLicensesList().hashCode();
    }
    if (hasLocationHint()) {
      hash = (37 * hash) + LOCATION_HINT_FIELD_NUMBER;
      hash = (53 * hash) + getLocationHint().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSatisfiesPzi()) {
      hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSnapshotEncryptionKey()) {
      hash = (37 * hash) + SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotEncryptionKey().hashCode();
    }
    if (hasSnapshotType()) {
      hash = (37 * hash) + SNAPSHOT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotType().hashCode();
    }
    if (hasSourceDisk()) {
      hash = (37 * hash) + SOURCE_DISK_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDisk().hashCode();
    }
    if (hasSourceDiskEncryptionKey()) {
      hash = (37 * hash) + SOURCE_DISK_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDiskEncryptionKey().hashCode();
    }
    if (hasSourceDiskForRecoveryCheckpoint()) {
      hash = (37 * hash) + SOURCE_DISK_FOR_RECOVERY_CHECKPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDiskForRecoveryCheckpoint().hashCode();
    }
    if (hasSourceDiskId()) {
      hash = (37 * hash) + SOURCE_DISK_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDiskId().hashCode();
    }
    if (hasSourceInstantSnapshot()) {
      hash = (37 * hash) + SOURCE_INSTANT_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstantSnapshot().hashCode();
    }
    if (hasSourceInstantSnapshotEncryptionKey()) {
      hash = (37 * hash) + SOURCE_INSTANT_SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstantSnapshotEncryptionKey().hashCode();
    }
    if (hasSourceInstantSnapshotId()) {
      hash = (37 * hash) + SOURCE_INSTANT_SNAPSHOT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInstantSnapshotId().hashCode();
    }
    if (hasSourceSnapshotSchedulePolicy()) {
      hash = (37 * hash) + SOURCE_SNAPSHOT_SCHEDULE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSnapshotSchedulePolicy().hashCode();
    }
    if (hasSourceSnapshotSchedulePolicyId()) {
      hash = (37 * hash) + SOURCE_SNAPSHOT_SCHEDULE_POLICY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSnapshotSchedulePolicyId().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasStorageBytes()) {
      hash = (37 * hash) + STORAGE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStorageBytes());
    }
    if (hasStorageBytesStatus()) {
      hash = (37 * hash) + STORAGE_BYTES_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStorageBytesStatus().hashCode();
    }
    if (getStorageLocationsCount() > 0) {
      hash = (37 * hash) + STORAGE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getStorageLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Snapshot parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Snapshot parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Snapshot parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Snapshot prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Persistent Disk Snapshot resource. You can use snapshots to back up data on a regular interval. For more information, read Creating persistent disk snapshots. LINT.IfChange
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Snapshot}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Snapshot)
      com.google.cloud.compute.v1.SnapshotOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Snapshot_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Snapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Snapshot.class,
              com.google.cloud.compute.v1.Snapshot.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Snapshot.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGuestOsFeaturesFieldBuilder();
        getSnapshotEncryptionKeyFieldBuilder();
        getSourceDiskEncryptionKeyFieldBuilder();
        getSourceInstantSnapshotEncryptionKeyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      architecture_ = "";
      autoCreated_ = false;
      chainName_ = "";
      creationSizeBytes_ = 0L;
      creationTimestamp_ = "";
      description_ = "";
      diskSizeGb_ = 0L;
      downloadBytes_ = 0L;
      enableConfidentialCompute_ = false;
      guestFlush_ = false;
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeatures_ = java.util.Collections.emptyList();
      } else {
        guestOsFeatures_ = null;
        guestOsFeaturesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      id_ = 0L;
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      licenseCodes_ = emptyLongList();
      licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      locationHint_ = "";
      name_ = "";
      satisfiesPzi_ = false;
      satisfiesPzs_ = false;
      selfLink_ = "";
      snapshotEncryptionKey_ = null;
      if (snapshotEncryptionKeyBuilder_ != null) {
        snapshotEncryptionKeyBuilder_.dispose();
        snapshotEncryptionKeyBuilder_ = null;
      }
      snapshotType_ = "";
      sourceDisk_ = "";
      sourceDiskEncryptionKey_ = null;
      if (sourceDiskEncryptionKeyBuilder_ != null) {
        sourceDiskEncryptionKeyBuilder_.dispose();
        sourceDiskEncryptionKeyBuilder_ = null;
      }
      sourceDiskForRecoveryCheckpoint_ = "";
      sourceDiskId_ = "";
      sourceInstantSnapshot_ = "";
      sourceInstantSnapshotEncryptionKey_ = null;
      if (sourceInstantSnapshotEncryptionKeyBuilder_ != null) {
        sourceInstantSnapshotEncryptionKeyBuilder_.dispose();
        sourceInstantSnapshotEncryptionKeyBuilder_ = null;
      }
      sourceInstantSnapshotId_ = "";
      sourceSnapshotSchedulePolicy_ = "";
      sourceSnapshotSchedulePolicyId_ = "";
      status_ = "";
      storageBytes_ = 0L;
      storageBytesStatus_ = "";
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Snapshot_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Snapshot getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Snapshot.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Snapshot build() {
      com.google.cloud.compute.v1.Snapshot result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Snapshot buildPartial() {
      com.google.cloud.compute.v1.Snapshot result = new com.google.cloud.compute.v1.Snapshot(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Snapshot result) {
      if (guestOsFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          guestOsFeatures_ = java.util.Collections.unmodifiableList(guestOsFeatures_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.guestOsFeatures_ = guestOsFeatures_;
      } else {
        result.guestOsFeatures_ = guestOsFeaturesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Snapshot result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.architecture_ = architecture_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.autoCreated_ = autoCreated_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.chainName_ = chainName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creationSizeBytes_ = creationSizeBytes_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.downloadBytes_ = downloadBytes_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.enableConfidentialCompute_ = enableConfidentialCompute_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.guestFlush_ = guestFlush_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        licenseCodes_.makeImmutable();
        result.licenseCodes_ = licenseCodes_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        licenses_.makeImmutable();
        result.licenses_ = licenses_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.locationHint_ = locationHint_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.snapshotEncryptionKey_ =
            snapshotEncryptionKeyBuilder_ == null
                ? snapshotEncryptionKey_
                : snapshotEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.snapshotType_ = snapshotType_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.sourceDisk_ = sourceDisk_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.sourceDiskEncryptionKey_ =
            sourceDiskEncryptionKeyBuilder_ == null
                ? sourceDiskEncryptionKey_
                : sourceDiskEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.sourceDiskForRecoveryCheckpoint_ = sourceDiskForRecoveryCheckpoint_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.sourceDiskId_ = sourceDiskId_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.sourceInstantSnapshot_ = sourceInstantSnapshot_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.sourceInstantSnapshotEncryptionKey_ =
            sourceInstantSnapshotEncryptionKeyBuilder_ == null
                ? sourceInstantSnapshotEncryptionKey_
                : sourceInstantSnapshotEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.sourceInstantSnapshotId_ = sourceInstantSnapshotId_;
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.sourceSnapshotSchedulePolicy_ = sourceSnapshotSchedulePolicy_;
        to_bitField0_ |= 0x08000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.cloud.compute.v1.Snapshot result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.sourceSnapshotSchedulePolicyId_ = sourceSnapshotSchedulePolicyId_;
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.storageBytes_ = storageBytes_;
        to_bitField0_ |= 0x40000000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.storageBytesStatus_ = storageBytesStatus_;
        to_bitField0_ |= 0x80000000;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        storageLocations_.makeImmutable();
        result.storageLocations_ = storageLocations_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Snapshot) {
        return mergeFrom((com.google.cloud.compute.v1.Snapshot) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Snapshot other) {
      if (other == com.google.cloud.compute.v1.Snapshot.getDefaultInstance()) return this;
      if (other.hasArchitecture()) {
        architecture_ = other.architecture_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAutoCreated()) {
        setAutoCreated(other.getAutoCreated());
      }
      if (other.hasChainName()) {
        chainName_ = other.chainName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreationSizeBytes()) {
        setCreationSizeBytes(other.getCreationSizeBytes());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasDiskSizeGb()) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.hasDownloadBytes()) {
        setDownloadBytes(other.getDownloadBytes());
      }
      if (other.hasEnableConfidentialCompute()) {
        setEnableConfidentialCompute(other.getEnableConfidentialCompute());
      }
      if (other.hasGuestFlush()) {
        setGuestFlush(other.getGuestFlush());
      }
      if (guestOsFeaturesBuilder_ == null) {
        if (!other.guestOsFeatures_.isEmpty()) {
          if (guestOsFeatures_.isEmpty()) {
            guestOsFeatures_ = other.guestOsFeatures_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureGuestOsFeaturesIsMutable();
            guestOsFeatures_.addAll(other.guestOsFeatures_);
          }
          onChanged();
        }
      } else {
        if (!other.guestOsFeatures_.isEmpty()) {
          if (guestOsFeaturesBuilder_.isEmpty()) {
            guestOsFeaturesBuilder_.dispose();
            guestOsFeaturesBuilder_ = null;
            guestOsFeatures_ = other.guestOsFeatures_;
            bitField0_ = (bitField0_ & ~0x00000400);
            guestOsFeaturesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestOsFeaturesFieldBuilder()
                    : null;
          } else {
            guestOsFeaturesBuilder_.addAllMessages(other.guestOsFeatures_);
          }
        }
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00004000;
      if (!other.licenseCodes_.isEmpty()) {
        if (licenseCodes_.isEmpty()) {
          licenseCodes_ = other.licenseCodes_;
          licenseCodes_.makeImmutable();
          bitField0_ |= 0x00008000;
        } else {
          ensureLicenseCodesIsMutable();
          licenseCodes_.addAll(other.licenseCodes_);
        }
        onChanged();
      }
      if (!other.licenses_.isEmpty()) {
        if (licenses_.isEmpty()) {
          licenses_ = other.licenses_;
          bitField0_ |= 0x00010000;
        } else {
          ensureLicensesIsMutable();
          licenses_.addAll(other.licenses_);
        }
        onChanged();
      }
      if (other.hasLocationHint()) {
        locationHint_ = other.locationHint_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasSatisfiesPzi()) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasSnapshotEncryptionKey()) {
        mergeSnapshotEncryptionKey(other.getSnapshotEncryptionKey());
      }
      if (other.hasSnapshotType()) {
        snapshotType_ = other.snapshotType_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasSourceDisk()) {
        sourceDisk_ = other.sourceDisk_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.hasSourceDiskEncryptionKey()) {
        mergeSourceDiskEncryptionKey(other.getSourceDiskEncryptionKey());
      }
      if (other.hasSourceDiskForRecoveryCheckpoint()) {
        sourceDiskForRecoveryCheckpoint_ = other.sourceDiskForRecoveryCheckpoint_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasSourceDiskId()) {
        sourceDiskId_ = other.sourceDiskId_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.hasSourceInstantSnapshot()) {
        sourceInstantSnapshot_ = other.sourceInstantSnapshot_;
        bitField0_ |= 0x10000000;
        onChanged();
      }
      if (other.hasSourceInstantSnapshotEncryptionKey()) {
        mergeSourceInstantSnapshotEncryptionKey(other.getSourceInstantSnapshotEncryptionKey());
      }
      if (other.hasSourceInstantSnapshotId()) {
        sourceInstantSnapshotId_ = other.sourceInstantSnapshotId_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      if (other.hasSourceSnapshotSchedulePolicy()) {
        sourceSnapshotSchedulePolicy_ = other.sourceSnapshotSchedulePolicy_;
        bitField0_ |= 0x80000000;
        onChanged();
      }
      if (other.hasSourceSnapshotSchedulePolicyId()) {
        sourceSnapshotSchedulePolicyId_ = other.sourceSnapshotSchedulePolicyId_;
        bitField1_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField1_ |= 0x00000002;
        onChanged();
      }
      if (other.hasStorageBytes()) {
        setStorageBytes(other.getStorageBytes());
      }
      if (other.hasStorageBytesStatus()) {
        storageBytesStatus_ = other.storageBytesStatus_;
        bitField1_ |= 0x00000008;
        onChanged();
      }
      if (!other.storageLocations_.isEmpty()) {
        if (storageLocations_.isEmpty()) {
          storageLocations_ = other.storageLocations_;
          bitField1_ |= 0x00000010;
        } else {
          ensureStorageLocationsIsMutable();
          storageLocations_.addAll(other.storageLocations_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000800;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 244202930
            case 346676210:
              {
                input.readMessage(
                    getSnapshotEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 346676210
            case 363861312:
              {
                long v = input.readInt64();
                ensureLicenseCodesIsMutable();
                licenseCodes_.addLong(v);
                break;
              } // case 363861312
            case 363861314:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureLicenseCodesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  licenseCodes_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 363861314
            case 549153354:
              {
                chainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 549153354
            case 563912378:
              {
                sourceSnapshotSchedulePolicyId_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000001;
                break;
              } // case 563912378
            case 634356362:
              {
                com.google.cloud.compute.v1.GuestOsFeature m =
                    input.readMessage(
                        com.google.cloud.compute.v1.GuestOsFeature.parser(), extensionRegistry);
                if (guestOsFeaturesBuilder_ == null) {
                  ensureGuestOsFeaturesIsMutable();
                  guestOsFeatures_.add(m);
                } else {
                  guestOsFeaturesBuilder_.addMessage(m);
                }
                break;
              } // case 634356362
            case 817081824:
              {
                enableConfidentialCompute_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 817081824
            case 994797226:
              {
                snapshotType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 994797226
            case 1003200616:
              {
                creationSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 1003200616
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1424998602
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000002;
                break;
              } // case 1450082194
            case 1753616434:
              {
                sourceInstantSnapshot_ = input.readStringRequireUtf8();
                bitField0_ |= 0x10000000;
                break;
              } // case 1753616434
            case 1886050330:
              {
                sourceSnapshotSchedulePolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x80000000;
                break;
              } // case 1886050330
            case -1994305630:
              {
                sourceInstantSnapshotId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case -1994305630
            case -1872541030:
              {
                architecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1872541030
            case -1764857416:
              {
                diskSizeGb_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case -1764857416
            case -1670925102:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStorageLocationsIsMutable();
                storageLocations_.add(s);
                break;
              } // case -1670925102
            case -1593826670:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLicensesIsMutable();
                licenses_.add(s);
                break;
              } // case -1593826670
            case -1490811254:
              {
                locationHint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -1490811254
            case -1416263694:
              {
                sourceDiskForRecoveryCheckpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case -1416263694
            case -1210560792:
              {
                guestFlush_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case -1210560792
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -911466526
            case -897913544:
              {
                storageBytes_ = input.readInt64();
                bitField1_ |= 0x00000004;
                break;
              } // case -897913544
            case -814534752:
              {
                downloadBytes_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case -814534752
            case -802678814:
              {
                input.readMessage(
                    getSourceInstantSnapshotEncryptionKeyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case -802678814
            case -680936950:
              {
                sourceDisk_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case -680936950
            case -661440822:
              {
                sourceDiskId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case -661440822
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case -645248918
            case -583589184:
              {
                autoCreated_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -583589184
            case -447253240:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00080000;
                break;
              } // case -447253240
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case -447253160
            case -369054638:
              {
                storageBytesStatus_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000008;
                break;
              } // case -369054638
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case -293404678
            case -42958070:
              {
                input.readMessage(
                    getSourceDiskEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case -42958070
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object architecture_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The architecture.
     */
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The bytes for architecture.
     */
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchitecture() {
      architecture_ = getDefaultInstance().getArchitecture();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The bytes for architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean autoCreated_;

    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     * </pre>
     *
     * <code>optional bool auto_created = 463922264;</code>
     *
     * @return Whether the autoCreated field is set.
     */
    @java.lang.Override
    public boolean hasAutoCreated() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     * </pre>
     *
     * <code>optional bool auto_created = 463922264;</code>
     *
     * @return The autoCreated.
     */
    @java.lang.Override
    public boolean getAutoCreated() {
      return autoCreated_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     * </pre>
     *
     * <code>optional bool auto_created = 463922264;</code>
     *
     * @param value The autoCreated to set.
     * @return This builder for chaining.
     */
    public Builder setAutoCreated(boolean value) {

      autoCreated_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     * </pre>
     *
     * <code>optional bool auto_created = 463922264;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoCreated() {
      bitField0_ = (bitField0_ & ~0x00000002);
      autoCreated_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object chainName_ = "";

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return Whether the chainName field is set.
     */
    public boolean hasChainName() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return The chainName.
     */
    public java.lang.String getChainName() {
      java.lang.Object ref = chainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        chainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return The bytes for chainName.
     */
    public com.google.protobuf.ByteString getChainNameBytes() {
      java.lang.Object ref = chainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        chainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @param value The chainName to set.
     * @return This builder for chaining.
     */
    public Builder setChainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      chainName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChainName() {
      chainName_ = getDefaultInstance().getChainName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     * </pre>
     *
     * <code>optional string chain_name = 68644169;</code>
     *
     * @param value The bytes for chainName to set.
     * @return This builder for chaining.
     */
    public Builder setChainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      chainName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long creationSizeBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] Size in bytes of the snapshot at creation time.
     * </pre>
     *
     * <code>optional int64 creation_size_bytes = 125400077;</code>
     *
     * @return Whether the creationSizeBytes field is set.
     */
    @java.lang.Override
    public boolean hasCreationSizeBytes() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size in bytes of the snapshot at creation time.
     * </pre>
     *
     * <code>optional int64 creation_size_bytes = 125400077;</code>
     *
     * @return The creationSizeBytes.
     */
    @java.lang.Override
    public long getCreationSizeBytes() {
      return creationSizeBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size in bytes of the snapshot at creation time.
     * </pre>
     *
     * <code>optional int64 creation_size_bytes = 125400077;</code>
     *
     * @param value The creationSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setCreationSizeBytes(long value) {

      creationSizeBytes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size in bytes of the snapshot at creation time.
     * </pre>
     *
     * <code>optional int64 creation_size_bytes = 125400077;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      creationSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long diskSizeGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Size of the source disk, specified in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return Whether the diskSizeGb field is set.
     */
    @java.lang.Override
    public boolean hasDiskSizeGb() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size of the source disk, specified in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size of the source disk, specified in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Size of the source disk, specified in GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000040);
      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private long downloadBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     * </pre>
     *
     * <code>optional int64 download_bytes = 435054068;</code>
     *
     * @return Whether the downloadBytes field is set.
     */
    @java.lang.Override
    public boolean hasDownloadBytes() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     * </pre>
     *
     * <code>optional int64 download_bytes = 435054068;</code>
     *
     * @return The downloadBytes.
     */
    @java.lang.Override
    public long getDownloadBytes() {
      return downloadBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     * </pre>
     *
     * <code>optional int64 download_bytes = 435054068;</code>
     *
     * @param value The downloadBytes to set.
     * @return This builder for chaining.
     */
    public Builder setDownloadBytes(long value) {

      downloadBytes_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     * </pre>
     *
     * <code>optional int64 download_bytes = 435054068;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDownloadBytes() {
      bitField0_ = (bitField0_ & ~0x00000080);
      downloadBytes_ = 0L;
      onChanged();
      return this;
    }

    private boolean enableConfidentialCompute_;

    /**
     *
     *
     * <pre>
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     * </pre>
     *
     * <code>optional bool enable_confidential_compute = 102135228;</code>
     *
     * @return Whether the enableConfidentialCompute field is set.
     */
    @java.lang.Override
    public boolean hasEnableConfidentialCompute() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     * </pre>
     *
     * <code>optional bool enable_confidential_compute = 102135228;</code>
     *
     * @return The enableConfidentialCompute.
     */
    @java.lang.Override
    public boolean getEnableConfidentialCompute() {
      return enableConfidentialCompute_;
    }

    /**
     *
     *
     * <pre>
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     * </pre>
     *
     * <code>optional bool enable_confidential_compute = 102135228;</code>
     *
     * @param value The enableConfidentialCompute to set.
     * @return This builder for chaining.
     */
    public Builder setEnableConfidentialCompute(boolean value) {

      enableConfidentialCompute_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this snapshot is created from a confidential compute mode disk. [Output Only]: This field is not set by user, but from source disk.
     * </pre>
     *
     * <code>optional bool enable_confidential_compute = 102135228;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableConfidentialCompute() {
      bitField0_ = (bitField0_ & ~0x00000100);
      enableConfidentialCompute_ = false;
      onChanged();
      return this;
    }

    private boolean guestFlush_;

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return Whether the guestFlush field is set.
     */
    @java.lang.Override
    public boolean hasGuestFlush() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return The guestFlush.
     */
    @java.lang.Override
    public boolean getGuestFlush() {
      return guestFlush_;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @param value The guestFlush to set.
     * @return This builder for chaining.
     */
    public Builder setGuestFlush(boolean value) {

      guestFlush_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare for the snapshot process.
     * </pre>
     *
     * <code>optional bool guest_flush = 385550813;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGuestFlush() {
      bitField0_ = (bitField0_ & ~0x00000200);
      guestFlush_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.GuestOsFeature> guestOsFeatures_ =
        java.util.Collections.emptyList();

    private void ensureGuestOsFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        guestOsFeatures_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.GuestOsFeature>(guestOsFeatures_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.GuestOsFeature,
            com.google.cloud.compute.v1.GuestOsFeature.Builder,
            com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        guestOsFeaturesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.GuestOsFeature> getGuestOsFeaturesList() {
      if (guestOsFeaturesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestOsFeatures_);
      } else {
        return guestOsFeaturesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public int getGuestOsFeaturesCount() {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.size();
      } else {
        return guestOsFeaturesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature getGuestOsFeatures(int index) {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.get(index);
      } else {
        return guestOsFeaturesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder setGuestOsFeatures(int index, com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.set(index, value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder setGuestOsFeatures(
        int index, com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(int index, com.google.cloud.compute.v1.GuestOsFeature value) {
      if (guestOsFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(index, value);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(
        com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addGuestOsFeatures(
        int index, com.google.cloud.compute.v1.GuestOsFeature.Builder builderForValue) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder addAllGuestOsFeatures(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.GuestOsFeature> values) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestOsFeatures_);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder clearGuestOsFeatures() {
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeatures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public Builder removeGuestOsFeatures(int index) {
      if (guestOsFeaturesBuilder_ == null) {
        ensureGuestOsFeaturesIsMutable();
        guestOsFeatures_.remove(index);
        onChanged();
      } else {
        guestOsFeaturesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder getGuestOsFeaturesBuilder(int index) {
      return getGuestOsFeaturesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeatureOrBuilder getGuestOsFeaturesOrBuilder(
        int index) {
      if (guestOsFeaturesBuilder_ == null) {
        return guestOsFeatures_.get(index);
      } else {
        return guestOsFeaturesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        getGuestOsFeaturesOrBuilderList() {
      if (guestOsFeaturesBuilder_ != null) {
        return guestOsFeaturesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestOsFeatures_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder addGuestOsFeaturesBuilder() {
      return getGuestOsFeaturesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.GuestOsFeature.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public com.google.cloud.compute.v1.GuestOsFeature.Builder addGuestOsFeaturesBuilder(int index) {
      return getGuestOsFeaturesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.GuestOsFeature.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.GuestOsFeature.Builder>
        getGuestOsFeaturesBuilderList() {
      return getGuestOsFeaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.GuestOsFeature,
            com.google.cloud.compute.v1.GuestOsFeature.Builder,
            com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>
        getGuestOsFeaturesFieldBuilder() {
      if (guestOsFeaturesBuilder_ == null) {
        guestOsFeaturesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.GuestOsFeature,
                com.google.cloud.compute.v1.GuestOsFeature.Builder,
                com.google.cloud.compute.v1.GuestOsFeatureOrBuilder>(
                guestOsFeatures_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        guestOsFeatures_ = null;
      }
      return guestOsFeaturesBuilder_;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000800);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a snapshot.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00004000;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    private com.google.protobuf.Internal.LongList licenseCodes_ = emptyLongList();

    private void ensureLicenseCodesIsMutable() {
      if (!licenseCodes_.isModifiable()) {
        licenseCodes_ = makeMutableCopy(licenseCodes_);
      }
      bitField0_ |= 0x00008000;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @return A list containing the licenseCodes.
     */
    public java.util.List<java.lang.Long> getLicenseCodesList() {
      licenseCodes_.makeImmutable();
      return licenseCodes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @return The count of licenseCodes.
     */
    public int getLicenseCodesCount() {
      return licenseCodes_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @param index The index of the element to return.
     * @return The licenseCodes at the given index.
     */
    public long getLicenseCodes(int index) {
      return licenseCodes_.getLong(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @param index The index to set the value at.
     * @param value The licenseCodes to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseCodes(int index, long value) {

      ensureLicenseCodesIsMutable();
      licenseCodes_.setLong(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @param value The licenseCodes to add.
     * @return This builder for chaining.
     */
    public Builder addLicenseCodes(long value) {

      ensureLicenseCodesIsMutable();
      licenseCodes_.addLong(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @param values The licenseCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllLicenseCodes(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureLicenseCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, licenseCodes_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     * </pre>
     *
     * <code>repeated int64 license_codes = 45482664;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenseCodes() {
      licenseCodes_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList licenses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLicensesIsMutable() {
      if (!licenses_.isModifiable()) {
        licenses_ = new com.google.protobuf.LazyStringArrayList(licenses_);
      }
      bitField0_ |= 0x00010000;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return A list containing the licenses.
     */
    public com.google.protobuf.ProtocolStringList getLicensesList() {
      licenses_.makeImmutable();
      return licenses_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return The count of licenses.
     */
    public int getLicensesCount() {
      return licenses_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the element to return.
     * @return The licenses at the given index.
     */
    public java.lang.String getLicenses(int index) {
      return licenses_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the licenses at the given index.
     */
    public com.google.protobuf.ByteString getLicensesBytes(int index) {
      return licenses_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index to set the value at.
     * @param value The licenses to set.
     * @return This builder for chaining.
     */
    public Builder setLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param values The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, licenses_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenses() {
      licenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The bytes of the licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLicensesIsMutable();
      licenses_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object locationHint_ = "";

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return Whether the locationHint field is set.
     */
    public boolean hasLocationHint() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The locationHint.
     */
    public java.lang.String getLocationHint() {
      java.lang.Object ref = locationHint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationHint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The bytes for locationHint.
     */
    public com.google.protobuf.ByteString getLocationHintBytes() {
      java.lang.Object ref = locationHint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationHint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationHint_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationHint() {
      locationHint_ = getDefaultInstance().getLocationHint();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the snapshot close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The bytes for locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationHint_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return Whether the satisfiesPzi field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzi() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 480964257;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00080000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00100000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey snapshotEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        snapshotEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     *
     * @return Whether the snapshotEncryptionKey field is set.
     */
    public boolean hasSnapshotEncryptionKey() {
      return ((bitField0_ & 0x00400000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     *
     * @return The snapshotEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getSnapshotEncryptionKey() {
      if (snapshotEncryptionKeyBuilder_ == null) {
        return snapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : snapshotEncryptionKey_;
      } else {
        return snapshotEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public Builder setSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (snapshotEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotEncryptionKey_ = value;
      } else {
        snapshotEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public Builder setSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (snapshotEncryptionKeyBuilder_ == null) {
        snapshotEncryptionKey_ = builderForValue.build();
      } else {
        snapshotEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public Builder mergeSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (snapshotEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && snapshotEncryptionKey_ != null
            && snapshotEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSnapshotEncryptionKeyBuilder().mergeFrom(value);
        } else {
          snapshotEncryptionKey_ = value;
        }
      } else {
        snapshotEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (snapshotEncryptionKey_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public Builder clearSnapshotEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00400000);
      snapshotEncryptionKey_ = null;
      if (snapshotEncryptionKeyBuilder_ != null) {
        snapshotEncryptionKeyBuilder_.dispose();
        snapshotEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSnapshotEncryptionKeyBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getSnapshotEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSnapshotEncryptionKeyOrBuilder() {
      if (snapshotEncryptionKeyBuilder_ != null) {
        return snapshotEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return snapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : snapshotEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Encrypts the snapshot using a customer-supplied encryption key. After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request. Customer-supplied encryption keys do not protect access to metadata of the snapshot. If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSnapshotEncryptionKeyFieldBuilder() {
      if (snapshotEncryptionKeyBuilder_ == null) {
        snapshotEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSnapshotEncryptionKey(), getParentForChildren(), isClean());
        snapshotEncryptionKey_ = null;
      }
      return snapshotEncryptionKeyBuilder_;
    }

    private java.lang.Object snapshotType_ = "";

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @return Whether the snapshotType field is set.
     */
    public boolean hasSnapshotType() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @return The snapshotType.
     */
    public java.lang.String getSnapshotType() {
      java.lang.Object ref = snapshotType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snapshotType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @return The bytes for snapshotType.
     */
    public com.google.protobuf.ByteString getSnapshotTypeBytes() {
      java.lang.Object ref = snapshotType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        snapshotType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @param value The snapshotType to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      snapshotType_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshotType() {
      snapshotType_ = getDefaultInstance().getSnapshotType();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of the snapshot.
     * Check the SnapshotType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string snapshot_type = 124349653;</code>
     *
     * @param value The bytes for snapshotType to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      snapshotType_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceDisk_ = "";

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return Whether the sourceDisk field is set.
     */
    public boolean hasSourceDisk() {
      return ((bitField0_ & 0x01000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return The sourceDisk.
     */
    public java.lang.String getSourceDisk() {
      java.lang.Object ref = sourceDisk_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDisk_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return The bytes for sourceDisk.
     */
    public com.google.protobuf.ByteString getSourceDiskBytes() {
      java.lang.Object ref = sourceDisk_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDisk_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @param value The sourceDisk to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDisk(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDisk_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDisk() {
      sourceDisk_ = getDefaultInstance().getSourceDisk();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source disk used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @param value The bytes for sourceDisk to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDisk_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey sourceDiskEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        sourceDiskEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     *
     * @return Whether the sourceDiskEncryptionKey field is set.
     */
    public boolean hasSourceDiskEncryptionKey() {
      return ((bitField0_ & 0x02000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     *
     * @return The sourceDiskEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceDiskEncryptionKey() {
      if (sourceDiskEncryptionKeyBuilder_ == null) {
        return sourceDiskEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceDiskEncryptionKey_;
      } else {
        return sourceDiskEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public Builder setSourceDiskEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceDiskEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDiskEncryptionKey_ = value;
      } else {
        sourceDiskEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public Builder setSourceDiskEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (sourceDiskEncryptionKeyBuilder_ == null) {
        sourceDiskEncryptionKey_ = builderForValue.build();
      } else {
        sourceDiskEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public Builder mergeSourceDiskEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceDiskEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && sourceDiskEncryptionKey_ != null
            && sourceDiskEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSourceDiskEncryptionKeyBuilder().mergeFrom(value);
        } else {
          sourceDiskEncryptionKey_ = value;
        }
      } else {
        sourceDiskEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (sourceDiskEncryptionKey_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public Builder clearSourceDiskEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x02000000);
      sourceDiskEncryptionKey_ = null;
      if (sourceDiskEncryptionKeyBuilder_ != null) {
        sourceDiskEncryptionKeyBuilder_.dispose();
        sourceDiskEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSourceDiskEncryptionKeyBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getSourceDiskEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSourceDiskEncryptionKeyOrBuilder() {
      if (sourceDiskEncryptionKeyBuilder_ != null) {
        return sourceDiskEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return sourceDiskEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceDiskEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSourceDiskEncryptionKeyFieldBuilder() {
      if (sourceDiskEncryptionKeyBuilder_ == null) {
        sourceDiskEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSourceDiskEncryptionKey(), getParentForChildren(), isClean());
        sourceDiskEncryptionKey_ = null;
      }
      return sourceDiskEncryptionKeyBuilder_;
    }

    private java.lang.Object sourceDiskForRecoveryCheckpoint_ = "";

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @return Whether the sourceDiskForRecoveryCheckpoint field is set.
     */
    public boolean hasSourceDiskForRecoveryCheckpoint() {
      return ((bitField0_ & 0x04000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @return The sourceDiskForRecoveryCheckpoint.
     */
    public java.lang.String getSourceDiskForRecoveryCheckpoint() {
      java.lang.Object ref = sourceDiskForRecoveryCheckpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDiskForRecoveryCheckpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @return The bytes for sourceDiskForRecoveryCheckpoint.
     */
    public com.google.protobuf.ByteString getSourceDiskForRecoveryCheckpointBytes() {
      java.lang.Object ref = sourceDiskForRecoveryCheckpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDiskForRecoveryCheckpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @param value The sourceDiskForRecoveryCheckpoint to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskForRecoveryCheckpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDiskForRecoveryCheckpoint_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDiskForRecoveryCheckpoint() {
      sourceDiskForRecoveryCheckpoint_ = getDefaultInstance().getSourceDiskForRecoveryCheckpoint();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source disk whose recovery checkpoint will be used to create this snapshot.
     * </pre>
     *
     * <code>optional string source_disk_for_recovery_checkpoint = 359837950;</code>
     *
     * @param value The bytes for sourceDiskForRecoveryCheckpoint to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskForRecoveryCheckpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDiskForRecoveryCheckpoint_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceDiskId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @return Whether the sourceDiskId field is set.
     */
    public boolean hasSourceDiskId() {
      return ((bitField0_ & 0x08000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @return The sourceDiskId.
     */
    public java.lang.String getSourceDiskId() {
      java.lang.Object ref = sourceDiskId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDiskId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @return The bytes for sourceDiskId.
     */
    public com.google.protobuf.ByteString getSourceDiskIdBytes() {
      java.lang.Object ref = sourceDiskId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDiskId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @param value The sourceDiskId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDiskId_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDiskId() {
      sourceDiskId_ = getDefaultInstance().getSourceDiskId();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     * </pre>
     *
     * <code>optional string source_disk_id = 454190809;</code>
     *
     * @param value The bytes for sourceDiskId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDiskId_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceInstantSnapshot_ = "";

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @return Whether the sourceInstantSnapshot field is set.
     */
    public boolean hasSourceInstantSnapshot() {
      return ((bitField0_ & 0x10000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @return The sourceInstantSnapshot.
     */
    public java.lang.String getSourceInstantSnapshot() {
      java.lang.Object ref = sourceInstantSnapshot_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceInstantSnapshot_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @return The bytes for sourceInstantSnapshot.
     */
    public com.google.protobuf.ByteString getSourceInstantSnapshotBytes() {
      java.lang.Object ref = sourceInstantSnapshot_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceInstantSnapshot_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @param value The sourceInstantSnapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstantSnapshot(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceInstantSnapshot_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstantSnapshot() {
      sourceInstantSnapshot_ = getDefaultInstance().getSourceInstantSnapshot();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source instant snapshot used to create this snapshot. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot
     * </pre>
     *
     * <code>optional string source_instant_snapshot = 219202054;</code>
     *
     * @param value The bytes for sourceInstantSnapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstantSnapshotBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceInstantSnapshot_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey sourceInstantSnapshotEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        sourceInstantSnapshotEncryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     *
     * @return Whether the sourceInstantSnapshotEncryptionKey field is set.
     */
    public boolean hasSourceInstantSnapshotEncryptionKey() {
      return ((bitField0_ & 0x20000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     *
     * @return The sourceInstantSnapshotEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey
        getSourceInstantSnapshotEncryptionKey() {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ == null) {
        return sourceInstantSnapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceInstantSnapshotEncryptionKey_;
      } else {
        return sourceInstantSnapshotEncryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public Builder setSourceInstantSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInstantSnapshotEncryptionKey_ = value;
      } else {
        sourceInstantSnapshotEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public Builder setSourceInstantSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ == null) {
        sourceInstantSnapshotEncryptionKey_ = builderForValue.build();
      } else {
        sourceInstantSnapshotEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public Builder mergeSourceInstantSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && sourceInstantSnapshotEncryptionKey_ != null
            && sourceInstantSnapshotEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSourceInstantSnapshotEncryptionKeyBuilder().mergeFrom(value);
        } else {
          sourceInstantSnapshotEncryptionKey_ = value;
        }
      } else {
        sourceInstantSnapshotEncryptionKeyBuilder_.mergeFrom(value);
      }
      if (sourceInstantSnapshotEncryptionKey_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public Builder clearSourceInstantSnapshotEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x20000000);
      sourceInstantSnapshotEncryptionKey_ = null;
      if (sourceInstantSnapshotEncryptionKeyBuilder_ != null) {
        sourceInstantSnapshotEncryptionKeyBuilder_.dispose();
        sourceInstantSnapshotEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSourceInstantSnapshotEncryptionKeyBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getSourceInstantSnapshotEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSourceInstantSnapshotEncryptionKeyOrBuilder() {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ != null) {
        return sourceInstantSnapshotEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return sourceInstantSnapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceInstantSnapshotEncryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer provided encryption key when creating Snapshot from Instant Snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_instant_snapshot_encryption_key = 436536060;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSourceInstantSnapshotEncryptionKeyFieldBuilder() {
      if (sourceInstantSnapshotEncryptionKeyBuilder_ == null) {
        sourceInstantSnapshotEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSourceInstantSnapshotEncryptionKey(), getParentForChildren(), isClean());
        sourceInstantSnapshotEncryptionKey_ = null;
      }
      return sourceInstantSnapshotEncryptionKeyBuilder_;
    }

    private java.lang.Object sourceInstantSnapshotId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @return Whether the sourceInstantSnapshotId field is set.
     */
    public boolean hasSourceInstantSnapshotId() {
      return ((bitField0_ & 0x40000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @return The sourceInstantSnapshotId.
     */
    public java.lang.String getSourceInstantSnapshotId() {
      java.lang.Object ref = sourceInstantSnapshotId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceInstantSnapshotId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @return The bytes for sourceInstantSnapshotId.
     */
    public com.google.protobuf.ByteString getSourceInstantSnapshotIdBytes() {
      java.lang.Object ref = sourceInstantSnapshotId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceInstantSnapshotId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @param value The sourceInstantSnapshotId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstantSnapshotId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceInstantSnapshotId_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstantSnapshotId() {
      sourceInstantSnapshotId_ = getDefaultInstance().getSourceInstantSnapshotId();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique ID of the instant snapshot used to create this snapshot. This value identifies the exact instant snapshot that was used to create this snapshot. For example, if you created the snapshot from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact instant snapshot that was used.
     * </pre>
     *
     * <code>optional string source_instant_snapshot_id = 287582708;</code>
     *
     * @param value The bytes for sourceInstantSnapshotId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstantSnapshotIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceInstantSnapshotId_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceSnapshotSchedulePolicy_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @return Whether the sourceSnapshotSchedulePolicy field is set.
     */
    public boolean hasSourceSnapshotSchedulePolicy() {
      return ((bitField0_ & 0x80000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @return The sourceSnapshotSchedulePolicy.
     */
    public java.lang.String getSourceSnapshotSchedulePolicy() {
      java.lang.Object ref = sourceSnapshotSchedulePolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSnapshotSchedulePolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @return The bytes for sourceSnapshotSchedulePolicy.
     */
    public com.google.protobuf.ByteString getSourceSnapshotSchedulePolicyBytes() {
      java.lang.Object ref = sourceSnapshotSchedulePolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSnapshotSchedulePolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @param value The sourceSnapshotSchedulePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshotSchedulePolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceSnapshotSchedulePolicy_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceSnapshotSchedulePolicy() {
      sourceSnapshotSchedulePolicy_ = getDefaultInstance().getSourceSnapshotSchedulePolicy();
      bitField0_ = (bitField0_ & ~0x80000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy = 235756291;</code>
     *
     * @param value The bytes for sourceSnapshotSchedulePolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshotSchedulePolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceSnapshotSchedulePolicy_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    private java.lang.Object sourceSnapshotSchedulePolicyId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @return Whether the sourceSnapshotSchedulePolicyId field is set.
     */
    public boolean hasSourceSnapshotSchedulePolicyId() {
      return ((bitField1_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @return The sourceSnapshotSchedulePolicyId.
     */
    public java.lang.String getSourceSnapshotSchedulePolicyId() {
      java.lang.Object ref = sourceSnapshotSchedulePolicyId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSnapshotSchedulePolicyId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @return The bytes for sourceSnapshotSchedulePolicyId.
     */
    public com.google.protobuf.ByteString getSourceSnapshotSchedulePolicyIdBytes() {
      java.lang.Object ref = sourceSnapshotSchedulePolicyId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSnapshotSchedulePolicyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @param value The sourceSnapshotSchedulePolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshotSchedulePolicyId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceSnapshotSchedulePolicyId_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceSnapshotSchedulePolicyId() {
      sourceSnapshotSchedulePolicyId_ = getDefaultInstance().getSourceSnapshotSchedulePolicyId();
      bitField1_ = (bitField1_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] ID of the resource policy which created this scheduled snapshot.
     * </pre>
     *
     * <code>optional string source_snapshot_schedule_policy_id = 70489047;</code>
     *
     * @param value The bytes for sourceSnapshotSchedulePolicyId to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshotSchedulePolicyIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceSnapshotSchedulePolicyId_ = value;
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField1_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField1_ = (bitField1_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long storageBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return Whether the storageBytes field is set.
     */
    @java.lang.Override
    public boolean hasStorageBytes() {
      return ((bitField1_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return The storageBytes.
     */
    @java.lang.Override
    public long getStorageBytes() {
      return storageBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @param value The storageBytes to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytes(long value) {

      storageBytes_ = value;
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytes() {
      bitField1_ = (bitField1_ & ~0x00000004);
      storageBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object storageBytesStatus_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return Whether the storageBytesStatus field is set.
     */
    public boolean hasStorageBytesStatus() {
      return ((bitField1_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return The storageBytesStatus.
     */
    public java.lang.String getStorageBytesStatus() {
      java.lang.Object ref = storageBytesStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageBytesStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return The bytes for storageBytesStatus.
     */
    public com.google.protobuf.ByteString getStorageBytesStatusBytes() {
      java.lang.Object ref = storageBytesStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageBytesStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @param value The storageBytesStatus to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytesStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storageBytesStatus_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytesStatus() {
      storageBytesStatus_ = getDefaultInstance().getStorageBytesStatus();
      bitField1_ = (bitField1_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @param value The bytes for storageBytesStatus to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytesStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storageBytesStatus_ = value;
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList storageLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStorageLocationsIsMutable() {
      if (!storageLocations_.isModifiable()) {
        storageLocations_ = new com.google.protobuf.LazyStringArrayList(storageLocations_);
      }
      bitField1_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return A list containing the storageLocations.
     */
    public com.google.protobuf.ProtocolStringList getStorageLocationsList() {
      storageLocations_.makeImmutable();
      return storageLocations_;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return The count of storageLocations.
     */
    public int getStorageLocationsCount() {
      return storageLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the element to return.
     * @return The storageLocations at the given index.
     */
    public java.lang.String getStorageLocations(int index) {
      return storageLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the storageLocations at the given index.
     */
    public com.google.protobuf.ByteString getStorageLocationsBytes(int index) {
      return storageLocations_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param index The index to set the value at.
     * @param value The storageLocations to set.
     * @return This builder for chaining.
     */
    public Builder setStorageLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.set(index, value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param values The storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllStorageLocations(java.lang.Iterable<java.lang.String> values) {
      ensureStorageLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, storageLocations_);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageLocations() {
      storageLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField1_ = (bitField1_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * </pre>
     *
     * <code>repeated string storage_locations = 328005274;</code>
     *
     * @param value The bytes of the storageLocations to add.
     * @return This builder for chaining.
     */
    public Builder addStorageLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStorageLocationsIsMutable();
      storageLocations_.add(value);
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Snapshot)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Snapshot)
  private static final com.google.cloud.compute.v1.Snapshot DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Snapshot();
  }

  public static com.google.cloud.compute.v1.Snapshot getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Snapshot> PARSER =
      new com.google.protobuf.AbstractParser<Snapshot>() {
        @java.lang.Override
        public Snapshot parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Snapshot> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Snapshot> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Snapshot getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
