/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Configuration and status of a managed SSL certificate.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SslCertificateManagedSslCertificate}
 */
public final class SslCertificateManagedSslCertificate
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SslCertificateManagedSslCertificate)
    SslCertificateManagedSslCertificateOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SslCertificateManagedSslCertificate.newBuilder() to construct.
  private SslCertificateManagedSslCertificate(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SslCertificateManagedSslCertificate() {
    domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SslCertificateManagedSslCertificate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 360305613:
        return internalGetDomainStatus();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.class,
            com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Status of the managed certificate resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SslCertificateManagedSslCertificate.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The certificate management is working, and a certificate has been provisioned.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /** <code>MANAGED_CERTIFICATE_STATUS_UNSPECIFIED = 474800850;</code> */
    MANAGED_CERTIFICATE_STATUS_UNSPECIFIED(474800850),
    /**
     *
     *
     * <pre>
     * The certificate management is working. GCP will attempt to provision the first certificate.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    PROVISIONING(290896621),
    /**
     *
     *
     * <pre>
     * Certificate provisioning failed due to an issue with the DNS or load balancing configuration. For details of which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>PROVISIONING_FAILED = 76813775;</code>
     */
    PROVISIONING_FAILED(76813775),
    /**
     *
     *
     * <pre>
     * Certificate provisioning failed due to an issue with the DNS or load balancing configuration. It won't be retried. To try again delete and create a new managed SslCertificate resource. For details of which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>PROVISIONING_FAILED_PERMANENTLY = 275036203;</code>
     */
    PROVISIONING_FAILED_PERMANENTLY(275036203),
    /**
     *
     *
     * <pre>
     * Renewal of the certificate has failed due to an issue with the DNS or load balancing configuration. The existing cert is still serving; however, it will expire shortly. To provision a renewed certificate, delete and create a new managed SslCertificate resource. For details on which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>RENEWAL_FAILED = 434659076;</code>
     */
    RENEWAL_FAILED(434659076),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The certificate management is working, and a certificate has been provisioned.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;

    /** <code>MANAGED_CERTIFICATE_STATUS_UNSPECIFIED = 474800850;</code> */
    public static final int MANAGED_CERTIFICATE_STATUS_UNSPECIFIED_VALUE = 474800850;

    /**
     *
     *
     * <pre>
     * The certificate management is working. GCP will attempt to provision the first certificate.
     * </pre>
     *
     * <code>PROVISIONING = 290896621;</code>
     */
    public static final int PROVISIONING_VALUE = 290896621;

    /**
     *
     *
     * <pre>
     * Certificate provisioning failed due to an issue with the DNS or load balancing configuration. For details of which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>PROVISIONING_FAILED = 76813775;</code>
     */
    public static final int PROVISIONING_FAILED_VALUE = 76813775;

    /**
     *
     *
     * <pre>
     * Certificate provisioning failed due to an issue with the DNS or load balancing configuration. It won't be retried. To try again delete and create a new managed SslCertificate resource. For details of which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>PROVISIONING_FAILED_PERMANENTLY = 275036203;</code>
     */
    public static final int PROVISIONING_FAILED_PERMANENTLY_VALUE = 275036203;

    /**
     *
     *
     * <pre>
     * Renewal of the certificate has failed due to an issue with the DNS or load balancing configuration. The existing cert is still serving; however, it will expire shortly. To provision a renewed certificate, delete and create a new managed SslCertificate resource. For details on which domain failed, consult domain_status field.
     * </pre>
     *
     * <code>RENEWAL_FAILED = 434659076;</code>
     */
    public static final int RENEWAL_FAILED_VALUE = 434659076;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 314733318:
          return ACTIVE;
        case 474800850:
          return MANAGED_CERTIFICATE_STATUS_UNSPECIFIED;
        case 290896621:
          return PROVISIONING;
        case 76813775:
          return PROVISIONING_FAILED;
        case 275036203:
          return PROVISIONING_FAILED_PERMANENTLY;
        case 434659076:
          return RENEWAL_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SslCertificateManagedSslCertificate.Status)
  }

  private int bitField0_;
  public static final int DOMAIN_STATUS_FIELD_NUMBER = 360305613;

  private static final class DomainStatusDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_DomainStatusEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> domainStatus_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetDomainStatus() {
    if (domainStatus_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DomainStatusDefaultEntryHolder.defaultEntry);
    }
    return domainStatus_;
  }

  public int getDomainStatusCount() {
    return internalGetDomainStatus().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * [Output only] Detailed statuses of the domains specified for managed certificate resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
   */
  @java.lang.Override
  public boolean containsDomainStatus(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDomainStatus().getMap().containsKey(key);
  }

  /** Use {@link #getDomainStatusMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDomainStatus() {
    return getDomainStatusMap();
  }

  /**
   *
   *
   * <pre>
   * [Output only] Detailed statuses of the domains specified for managed certificate resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDomainStatusMap() {
    return internalGetDomainStatus().getMap();
  }

  /**
   *
   *
   * <pre>
   * [Output only] Detailed statuses of the domains specified for managed certificate resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDomainStatusOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDomainStatus().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * [Output only] Detailed statuses of the domains specified for managed certificate resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
   */
  @java.lang.Override
  public java.lang.String getDomainStatusOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDomainStatus().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DOMAINS_FIELD_NUMBER = 226935855;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList domains_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
   * </pre>
   *
   * <code>repeated string domains = 226935855;</code>
   *
   * @return A list containing the domains.
   */
  public com.google.protobuf.ProtocolStringList getDomainsList() {
    return domains_;
  }

  /**
   *
   *
   * <pre>
   * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
   * </pre>
   *
   * <code>repeated string domains = 226935855;</code>
   *
   * @return The count of domains.
   */
  public int getDomainsCount() {
    return domains_.size();
  }

  /**
   *
   *
   * <pre>
   * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
   * </pre>
   *
   * <code>repeated string domains = 226935855;</code>
   *
   * @param index The index of the element to return.
   * @return The domains at the given index.
   */
  public java.lang.String getDomains(int index) {
    return domains_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
   * </pre>
   *
   * <code>repeated string domains = 226935855;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the domains at the given index.
   */
  public com.google.protobuf.ByteString getDomainsBytes(int index) {
    return domains_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * [Output only] Status of the managed certificate resource.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Status of the managed certificate resource.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output only] Status of the managed certificate resource.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    for (int i = 0; i < domains_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 226935855, domains_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDomainStatus(), DomainStatusDefaultEntryHolder.defaultEntry, 360305613);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domains_.size(); i++) {
        dataSize += computeStringSizeNoTag(domains_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDomainsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDomainStatus().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> domainStatus__ =
          DomainStatusDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(360305613, domainStatus__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SslCertificateManagedSslCertificate)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SslCertificateManagedSslCertificate other =
        (com.google.cloud.compute.v1.SslCertificateManagedSslCertificate) obj;

    if (!internalGetDomainStatus().equals(other.internalGetDomainStatus())) return false;
    if (!getDomainsList().equals(other.getDomainsList())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetDomainStatus().getMap().isEmpty()) {
      hash = (37 * hash) + DOMAIN_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDomainStatus().hashCode();
    }
    if (getDomainsCount() > 0) {
      hash = (37 * hash) + DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getDomainsList().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SslCertificateManagedSslCertificate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration and status of a managed SSL certificate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SslCertificateManagedSslCertificate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SslCertificateManagedSslCertificate)
      com.google.cloud.compute.v1.SslCertificateManagedSslCertificateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 360305613:
          return internalGetDomainStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 360305613:
          return internalGetMutableDomainStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.class,
              com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableDomainStatus().clear();
      domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SslCertificateManagedSslCertificate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate build() {
      com.google.cloud.compute.v1.SslCertificateManagedSslCertificate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate buildPartial() {
      com.google.cloud.compute.v1.SslCertificateManagedSslCertificate result =
          new com.google.cloud.compute.v1.SslCertificateManagedSslCertificate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SslCertificateManagedSslCertificate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.domainStatus_ = internalGetDomainStatus();
        result.domainStatus_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        domains_.makeImmutable();
        result.domains_ = domains_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SslCertificateManagedSslCertificate) {
        return mergeFrom((com.google.cloud.compute.v1.SslCertificateManagedSslCertificate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.SslCertificateManagedSslCertificate other) {
      if (other
          == com.google.cloud.compute.v1.SslCertificateManagedSslCertificate.getDefaultInstance())
        return this;
      internalGetMutableDomainStatus().mergeFrom(other.internalGetDomainStatus());
      bitField0_ |= 0x00000001;
      if (!other.domains_.isEmpty()) {
        if (domains_.isEmpty()) {
          domains_ = other.domains_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDomainsIsMutable();
          domains_.addAll(other.domains_);
        }
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1450082194
            case 1815486842:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDomainsIsMutable();
                domains_.add(s);
                break;
              } // case 1815486842
            case -1412522390:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> domainStatus__ =
                    input.readMessage(
                        DomainStatusDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDomainStatus()
                    .getMutableMap()
                    .put(domainStatus__.getKey(), domainStatus__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case -1412522390
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> domainStatus_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDomainStatus() {
      if (domainStatus_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DomainStatusDefaultEntryHolder.defaultEntry);
      }
      return domainStatus_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDomainStatus() {
      if (domainStatus_ == null) {
        domainStatus_ =
            com.google.protobuf.MapField.newMapField(DomainStatusDefaultEntryHolder.defaultEntry);
      }
      if (!domainStatus_.isMutable()) {
        domainStatus_ = domainStatus_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return domainStatus_;
    }

    public int getDomainStatusCount() {
      return internalGetDomainStatus().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    @java.lang.Override
    public boolean containsDomainStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDomainStatus().getMap().containsKey(key);
    }

    /** Use {@link #getDomainStatusMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDomainStatus() {
      return getDomainStatusMap();
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDomainStatusMap() {
      return internalGetDomainStatus().getMap();
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDomainStatusOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDomainStatus().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    @java.lang.Override
    public java.lang.String getDomainStatusOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDomainStatus().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDomainStatus() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableDomainStatus().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    public Builder removeDomainStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDomainStatus().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDomainStatus() {
      bitField0_ |= 0x00000001;
      return internalGetMutableDomainStatus().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    public Builder putDomainStatus(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDomainStatus().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Detailed statuses of the domains specified for managed certificate resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; domain_status = 360305613;</code>
     */
    public Builder putAllDomainStatus(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDomainStatus().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList domains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDomainsIsMutable() {
      if (!domains_.isModifiable()) {
        domains_ = new com.google.protobuf.LazyStringArrayList(domains_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @return A list containing the domains.
     */
    public com.google.protobuf.ProtocolStringList getDomainsList() {
      domains_.makeImmutable();
      return domains_;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @return The count of domains.
     */
    public int getDomainsCount() {
      return domains_.size();
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param index The index of the element to return.
     * @return The domains at the given index.
     */
    public java.lang.String getDomains(int index) {
      return domains_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the domains at the given index.
     */
    public com.google.protobuf.ByteString getDomainsBytes(int index) {
      return domains_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param index The index to set the value at.
     * @param value The domains to set.
     * @return This builder for chaining.
     */
    public Builder setDomains(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainsIsMutable();
      domains_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param value The domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomains(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param values The domains to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomains(java.lang.Iterable<java.lang.String> values) {
      ensureDomainsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, domains_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomains() {
      domains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domains for which a managed SSL certificate will be generated. Each Google-managed SSL certificate supports up to the [maximum number of domains per Google-managed SSL certificate](/load-balancing/docs/quotas#ssl_certificates).
     * </pre>
     *
     * <code>repeated string domains = 226935855;</code>
     *
     * @param value The bytes of the domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomainsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Status of the managed certificate resource.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SslCertificateManagedSslCertificate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SslCertificateManagedSslCertificate)
  private static final com.google.cloud.compute.v1.SslCertificateManagedSslCertificate
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SslCertificateManagedSslCertificate();
  }

  public static com.google.cloud.compute.v1.SslCertificateManagedSslCertificate
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SslCertificateManagedSslCertificate> PARSER =
      new com.google.protobuf.AbstractParser<SslCertificateManagedSslCertificate>() {
        @java.lang.Override
        public SslCertificateManagedSslCertificate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SslCertificateManagedSslCertificate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SslCertificateManagedSslCertificate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SslCertificateManagedSslCertificate
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
