/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Configuration of preserved resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.StatefulPolicyPreservedState}
 */
public final class StatefulPolicyPreservedState extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.StatefulPolicyPreservedState)
    StatefulPolicyPreservedStateOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StatefulPolicyPreservedState.newBuilder() to construct.
  private StatefulPolicyPreservedState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StatefulPolicyPreservedState() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StatefulPolicyPreservedState();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 95594102:
        return internalGetDisks();
      case 532687245:
        return internalGetExternalIPs();
      case 215731675:
        return internalGetInternalIPs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.StatefulPolicyPreservedState.class,
            com.google.cloud.compute.v1.StatefulPolicyPreservedState.Builder.class);
  }

  public static final int DISKS_FIELD_NUMBER = 95594102;

  private static final class DisksDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_DisksEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
      disks_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
      internalGetDisks() {
    if (disks_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DisksDefaultEntryHolder.defaultEntry);
    }
    return disks_;
  }

  public int getDisksCount() {
    return internalGetDisks().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
   * </code>
   */
  @java.lang.Override
  public boolean containsDisks(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDisks().getMap().containsKey(key);
  }

  /** Use {@link #getDisksMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
      getDisks() {
    return getDisksMap();
  }

  /**
   *
   *
   * <pre>
   * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
      getDisksMap() {
    return internalGetDisks().getMap();
  }

  /**
   *
   *
   * <pre>
   * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice
      getDisksOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        map = internalGetDisks().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice getDisksOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        map = internalGetDisks().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXTERNAL_I_PS_FIELD_NUMBER = 532687245;

  private static final class ExternalIPsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_ExternalIPsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      externalIPs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      internalGetExternalIPs() {
    if (externalIPs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ExternalIPsDefaultEntryHolder.defaultEntry);
    }
    return externalIPs_;
  }

  public int getExternalIPsCount() {
    return internalGetExternalIPs().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
   * </code>
   */
  @java.lang.Override
  public boolean containsExternalIPs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetExternalIPs().getMap().containsKey(key);
  }

  /** Use {@link #getExternalIPsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      getExternalIPs() {
    return getExternalIPsMap();
  }

  /**
   *
   *
   * <pre>
   * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      getExternalIPsMap() {
    return internalGetExternalIPs().getMap();
  }

  /**
   *
   *
   * <pre>
   * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
      getExternalIPsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        map = internalGetExternalIPs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp getExternalIPsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        map = internalGetExternalIPs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int INTERNAL_I_PS_FIELD_NUMBER = 215731675;

  private static final class InternalIPsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_InternalIPsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      internalIPs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      internalGetInternalIPs() {
    if (internalIPs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(InternalIPsDefaultEntryHolder.defaultEntry);
    }
    return internalIPs_;
  }

  public int getInternalIPsCount() {
    return internalGetInternalIPs().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
   * </code>
   */
  @java.lang.Override
  public boolean containsInternalIPs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetInternalIPs().getMap().containsKey(key);
  }

  /** Use {@link #getInternalIPsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      getInternalIPs() {
    return getInternalIPsMap();
  }

  /**
   *
   *
   * <pre>
   * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
      getInternalIPsMap() {
    return internalGetInternalIPs().getMap();
  }

  /**
   *
   *
   * <pre>
   * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
      getInternalIPsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        map = internalGetInternalIPs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp getInternalIPsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        map = internalGetInternalIPs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDisks(), DisksDefaultEntryHolder.defaultEntry, 95594102);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetInternalIPs(), InternalIPsDefaultEntryHolder.defaultEntry, 215731675);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetExternalIPs(), ExternalIPsDefaultEntryHolder.defaultEntry, 532687245);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        entry : internalGetDisks().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
          disks__ =
              DisksDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(95594102, disks__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        entry : internalGetInternalIPs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          internalIPs__ =
              InternalIPsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(215731675, internalIPs__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        entry : internalGetExternalIPs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          externalIPs__ =
              ExternalIPsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(532687245, externalIPs__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedState)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.StatefulPolicyPreservedState other =
        (com.google.cloud.compute.v1.StatefulPolicyPreservedState) obj;

    if (!internalGetDisks().equals(other.internalGetDisks())) return false;
    if (!internalGetExternalIPs().equals(other.internalGetExternalIPs())) return false;
    if (!internalGetInternalIPs().equals(other.internalGetInternalIPs())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetDisks().getMap().isEmpty()) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDisks().hashCode();
    }
    if (!internalGetExternalIPs().getMap().isEmpty()) {
      hash = (37 * hash) + EXTERNAL_I_PS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetExternalIPs().hashCode();
    }
    if (!internalGetInternalIPs().getMap().isEmpty()) {
      hash = (37 * hash) + INTERNAL_I_PS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInternalIPs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.StatefulPolicyPreservedState prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration of preserved resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.StatefulPolicyPreservedState}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.StatefulPolicyPreservedState)
      com.google.cloud.compute.v1.StatefulPolicyPreservedStateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 95594102:
          return internalGetDisks();
        case 532687245:
          return internalGetExternalIPs();
        case 215731675:
          return internalGetInternalIPs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 95594102:
          return internalGetMutableDisks();
        case 532687245:
          return internalGetMutableExternalIPs();
        case 215731675:
          return internalGetMutableInternalIPs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.StatefulPolicyPreservedState.class,
              com.google.cloud.compute.v1.StatefulPolicyPreservedState.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.StatefulPolicyPreservedState.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableDisks().clear();
      internalGetMutableExternalIPs().clear();
      internalGetMutableInternalIPs().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StatefulPolicyPreservedState_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedState getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.StatefulPolicyPreservedState.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedState build() {
      com.google.cloud.compute.v1.StatefulPolicyPreservedState result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedState buildPartial() {
      com.google.cloud.compute.v1.StatefulPolicyPreservedState result =
          new com.google.cloud.compute.v1.StatefulPolicyPreservedState(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.StatefulPolicyPreservedState result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.disks_ = internalGetDisks().build(DisksDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.externalIPs_ =
            internalGetExternalIPs().build(ExternalIPsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.internalIPs_ =
            internalGetInternalIPs().build(InternalIPsDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedState) {
        return mergeFrom((com.google.cloud.compute.v1.StatefulPolicyPreservedState) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.StatefulPolicyPreservedState other) {
      if (other == com.google.cloud.compute.v1.StatefulPolicyPreservedState.getDefaultInstance())
        return this;
      internalGetMutableDisks().mergeFrom(other.internalGetDisks());
      bitField0_ |= 0x00000001;
      internalGetMutableExternalIPs().mergeFrom(other.internalGetExternalIPs());
      bitField0_ |= 0x00000002;
      internalGetMutableInternalIPs().mergeFrom(other.internalGetInternalIPs());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 764752818:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
                    disks__ =
                        input.readMessage(
                            DisksDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableDisks()
                    .ensureBuilderMap()
                    .put(disks__.getKey(), disks__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 764752818
            case 1725853402:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
                    internalIPs__ =
                        input.readMessage(
                            InternalIPsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableInternalIPs()
                    .ensureBuilderMap()
                    .put(internalIPs__.getKey(), internalIPs__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 1725853402
            case -33469334:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
                    externalIPs__ =
                        input.readMessage(
                            ExternalIPsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableExternalIPs()
                    .ensureBuilderMap()
                    .put(externalIPs__.getKey(), externalIPs__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case -33469334
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private static final class DisksConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice> {
      @java.lang.Override
      public com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice build(
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice) {
          return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice) val;
        }
        return ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
          defaultEntry() {
        return DisksDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final DisksConverter disksConverter = new DisksConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder>
        disks_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder>
        internalGetDisks() {
      if (disks_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(disksConverter);
      }
      return disks_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder>
        internalGetMutableDisks() {
      if (disks_ == null) {
        disks_ = new com.google.protobuf.MapFieldBuilder<>(disksConverter);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return disks_;
    }

    public int getDisksCount() {
      return internalGetDisks().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    @java.lang.Override
    public boolean containsDisks(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDisks().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getDisksMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        getDisks() {
      return getDisksMap();
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        getDisksMap() {
      return internalGetDisks().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice
        getDisksOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder>
          map = internalGetMutableDisks().ensureBuilderMap();
      return map.containsKey(key) ? disksConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice getDisksOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder>
          map = internalGetMutableDisks().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return disksConverter.build(map.get(key));
    }

    public Builder clearDisks() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableDisks().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    public Builder removeDisks(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDisks().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
        getMutableDisks() {
      bitField0_ |= 0x00000001;
      return internalGetMutableDisks().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    public Builder putDisks(
        java.lang.String key,
        com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDisks().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    public Builder putAllDisks(
        java.util.Map<
                java.lang.String,
                com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableDisks().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Disks created on the instances that will be preserved on instance delete, update, etc. This map is keyed with the device names of the disks.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice&gt; disks = 95594102;
     * </code>
     */
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder
        putDisksBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder>
          builderMap = internalGetMutableDisks().ensureBuilderMap();
      com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDeviceOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice) {
        entry =
            ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateDiskDevice.Builder) entry;
    }

    private static final class ExternalIPsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp> {
      @java.lang.Override
      public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp build(
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) {
          return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) val;
        }
        return ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          defaultEntry() {
        return ExternalIPsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final ExternalIPsConverter externalIPsConverter = new ExternalIPsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        externalIPs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        internalGetExternalIPs() {
      if (externalIPs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(externalIPsConverter);
      }
      return externalIPs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        internalGetMutableExternalIPs() {
      if (externalIPs_ == null) {
        externalIPs_ = new com.google.protobuf.MapFieldBuilder<>(externalIPsConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return externalIPs_;
    }

    public int getExternalIPsCount() {
      return internalGetExternalIPs().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    @java.lang.Override
    public boolean containsExternalIPs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetExternalIPs().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getExternalIPsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getExternalIPs() {
      return getExternalIPsMap();
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getExternalIPsMap() {
      return internalGetExternalIPs().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
        getExternalIPsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          map = internalGetMutableExternalIPs().ensureBuilderMap();
      return map.containsKey(key) ? externalIPsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp getExternalIPsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          map = internalGetMutableExternalIPs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return externalIPsConverter.build(map.get(key));
    }

    public Builder clearExternalIPs() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableExternalIPs().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    public Builder removeExternalIPs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableExternalIPs().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getMutableExternalIPs() {
      bitField0_ |= 0x00000002;
      return internalGetMutableExternalIPs().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    public Builder putExternalIPs(
        java.lang.String key,
        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableExternalIPs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    public Builder putAllExternalIPs(
        java.util.Map<
                java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableExternalIPs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; external_i_ps = 532687245;
     * </code>
     */
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder
        putExternalIPsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          builderMap = internalGetMutableExternalIPs().ensureBuilderMap();
      com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) {
        entry =
            ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder) entry;
    }

    private static final class InternalIPsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp> {
      @java.lang.Override
      public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp build(
          com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) {
          return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) val;
        }
        return ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          defaultEntry() {
        return InternalIPsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final InternalIPsConverter internalIPsConverter = new InternalIPsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        internalIPs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        internalGetInternalIPs() {
      if (internalIPs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(internalIPsConverter);
      }
      return internalIPs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp,
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder>
        internalGetMutableInternalIPs() {
      if (internalIPs_ == null) {
        internalIPs_ = new com.google.protobuf.MapFieldBuilder<>(internalIPsConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return internalIPs_;
    }

    public int getInternalIPsCount() {
      return internalGetInternalIPs().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    @java.lang.Override
    public boolean containsInternalIPs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInternalIPs().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getInternalIPsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getInternalIPs() {
      return getInternalIPsMap();
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getInternalIPsMap() {
      return internalGetInternalIPs().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp
        getInternalIPsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          map = internalGetMutableInternalIPs().ensureBuilderMap();
      return map.containsKey(key) ? internalIPsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp getInternalIPsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          map = internalGetMutableInternalIPs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return internalIPsConverter.build(map.get(key));
    }

    public Builder clearInternalIPs() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableInternalIPs().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    public Builder removeInternalIPs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableInternalIPs().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
        getMutableInternalIPs() {
      bitField0_ |= 0x00000004;
      return internalGetMutableInternalIPs().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    public Builder putInternalIPs(
        java.lang.String key,
        com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableInternalIPs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    public Builder putAllInternalIPs(
        java.util.Map<
                java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableInternalIPs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp&gt; internal_i_ps = 215731675;
     * </code>
     */
    public com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder
        putInternalIPsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder>
          builderMap = internalGetMutableInternalIPs().ensureBuilderMap();
      com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIpOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) {
        entry =
            ((com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.StatefulPolicyPreservedStateNetworkIp.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.StatefulPolicyPreservedState)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.StatefulPolicyPreservedState)
  private static final com.google.cloud.compute.v1.StatefulPolicyPreservedState DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.StatefulPolicyPreservedState();
  }

  public static com.google.cloud.compute.v1.StatefulPolicyPreservedState getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StatefulPolicyPreservedState> PARSER =
      new com.google.protobuf.AbstractParser<StatefulPolicyPreservedState>() {
        @java.lang.Override
        public StatefulPolicyPreservedState parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StatefulPolicyPreservedState> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StatefulPolicyPreservedState> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicyPreservedState getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
