/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] Contains output only fields.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.StoragePoolResourceStatus}
 */
public final class StoragePoolResourceStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.StoragePoolResourceStatus)
    StoragePoolResourceStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StoragePoolResourceStatus.newBuilder() to construct.
  private StoragePoolResourceStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StoragePoolResourceStatus() {
    lastResizeTimestamp_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StoragePoolResourceStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StoragePoolResourceStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StoragePoolResourceStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.StoragePoolResourceStatus.class,
            com.google.cloud.compute.v1.StoragePoolResourceStatus.Builder.class);
  }

  private int bitField0_;
  public static final int DISK_COUNT_FIELD_NUMBER = 182933485;
  private long diskCount_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Number of disks used.
   * </pre>
   *
   * <code>optional int64 disk_count = 182933485;</code>
   *
   * @return Whether the diskCount field is set.
   */
  @java.lang.Override
  public boolean hasDiskCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Number of disks used.
   * </pre>
   *
   * <code>optional int64 disk_count = 182933485;</code>
   *
   * @return The diskCount.
   */
  @java.lang.Override
  public long getDiskCount() {
    return diskCount_;
  }

  public static final int LAST_RESIZE_TIMESTAMP_FIELD_NUMBER = 500825556;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastResizeTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_resize_timestamp = 500825556;</code>
   *
   * @return Whether the lastResizeTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasLastResizeTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_resize_timestamp = 500825556;</code>
   *
   * @return The lastResizeTimestamp.
   */
  @java.lang.Override
  public java.lang.String getLastResizeTimestamp() {
    java.lang.Object ref = lastResizeTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastResizeTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * </pre>
   *
   * <code>optional string last_resize_timestamp = 500825556;</code>
   *
   * @return The bytes for lastResizeTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastResizeTimestampBytes() {
    java.lang.Object ref = lastResizeTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastResizeTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_TOTAL_PROVISIONED_DISK_CAPACITY_GB_FIELD_NUMBER = 165818207;
  private long maxTotalProvisionedDiskCapacityGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum allowed aggregate disk size in gigabytes.
   * </pre>
   *
   * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
   *
   * @return Whether the maxTotalProvisionedDiskCapacityGb field is set.
   */
  @java.lang.Override
  public boolean hasMaxTotalProvisionedDiskCapacityGb() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum allowed aggregate disk size in gigabytes.
   * </pre>
   *
   * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
   *
   * @return The maxTotalProvisionedDiskCapacityGb.
   */
  @java.lang.Override
  public long getMaxTotalProvisionedDiskCapacityGb() {
    return maxTotalProvisionedDiskCapacityGb_;
  }

  public static final int POOL_USED_CAPACITY_BYTES_FIELD_NUMBER = 510407877;
  private long poolUsedCapacityBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
   * </pre>
   *
   * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
   *
   * @return Whether the poolUsedCapacityBytes field is set.
   */
  @java.lang.Override
  public boolean hasPoolUsedCapacityBytes() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
   * </pre>
   *
   * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
   *
   * @return The poolUsedCapacityBytes.
   */
  @java.lang.Override
  public long getPoolUsedCapacityBytes() {
    return poolUsedCapacityBytes_;
  }

  public static final int POOL_USED_IOPS_FIELD_NUMBER = 99558536;
  private long poolUsedIops_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
   * </pre>
   *
   * <code>optional int64 pool_used_iops = 99558536;</code>
   *
   * @return Whether the poolUsedIops field is set.
   */
  @java.lang.Override
  public boolean hasPoolUsedIops() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
   * </pre>
   *
   * <code>optional int64 pool_used_iops = 99558536;</code>
   *
   * @return The poolUsedIops.
   */
  @java.lang.Override
  public long getPoolUsedIops() {
    return poolUsedIops_;
  }

  public static final int POOL_USED_THROUGHPUT_FIELD_NUMBER = 206130633;
  private long poolUsedThroughput_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
   * </pre>
   *
   * <code>optional int64 pool_used_throughput = 206130633;</code>
   *
   * @return Whether the poolUsedThroughput field is set.
   */
  @java.lang.Override
  public boolean hasPoolUsedThroughput() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
   * </pre>
   *
   * <code>optional int64 pool_used_throughput = 206130633;</code>
   *
   * @return The poolUsedThroughput.
   */
  @java.lang.Override
  public long getPoolUsedThroughput() {
    return poolUsedThroughput_;
  }

  public static final int POOL_USER_WRITTEN_BYTES_FIELD_NUMBER = 228964050;
  private long poolUserWrittenBytes_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Amount of data written into the pool, before it is compacted.
   * </pre>
   *
   * <code>optional int64 pool_user_written_bytes = 228964050;</code>
   *
   * @return Whether the poolUserWrittenBytes field is set.
   */
  @java.lang.Override
  public boolean hasPoolUserWrittenBytes() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Amount of data written into the pool, before it is compacted.
   * </pre>
   *
   * <code>optional int64 pool_user_written_bytes = 228964050;</code>
   *
   * @return The poolUserWrittenBytes.
   */
  @java.lang.Override
  public long getPoolUserWrittenBytes() {
    return poolUserWrittenBytes_;
  }

  public static final int TOTAL_PROVISIONED_DISK_CAPACITY_GB_FIELD_NUMBER = 520930980;
  private long totalProvisionedDiskCapacityGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
   *
   * @return Whether the totalProvisionedDiskCapacityGb field is set.
   */
  @java.lang.Override
  public boolean hasTotalProvisionedDiskCapacityGb() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
   *
   * @return The totalProvisionedDiskCapacityGb.
   */
  @java.lang.Override
  public long getTotalProvisionedDiskCapacityGb() {
    return totalProvisionedDiskCapacityGb_;
  }

  public static final int TOTAL_PROVISIONED_DISK_IOPS_FIELD_NUMBER = 32812549;
  private long totalProvisionedDiskIops_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
   *
   * @return Whether the totalProvisionedDiskIops field is set.
   */
  @java.lang.Override
  public boolean hasTotalProvisionedDiskIops() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
   *
   * @return The totalProvisionedDiskIops.
   */
  @java.lang.Override
  public long getTotalProvisionedDiskIops() {
    return totalProvisionedDiskIops_;
  }

  public static final int TOTAL_PROVISIONED_DISK_THROUGHPUT_FIELD_NUMBER = 447677830;
  private long totalProvisionedDiskThroughput_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
   *
   * @return Whether the totalProvisionedDiskThroughput field is set.
   */
  @java.lang.Override
  public boolean hasTotalProvisionedDiskThroughput() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
   * </pre>
   *
   * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
   *
   * @return The totalProvisionedDiskThroughput.
   */
  @java.lang.Override
  public long getTotalProvisionedDiskThroughput() {
    return totalProvisionedDiskThroughput_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt64(32812549, totalProvisionedDiskIops_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(99558536, poolUsedIops_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(165818207, maxTotalProvisionedDiskCapacityGb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(182933485, diskCount_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(206130633, poolUsedThroughput_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(228964050, poolUserWrittenBytes_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt64(447677830, totalProvisionedDiskThroughput_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 500825556, lastResizeTimestamp_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(510407877, poolUsedCapacityBytes_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt64(520930980, totalProvisionedDiskCapacityGb_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              32812549, totalProvisionedDiskIops_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(99558536, poolUsedIops_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              165818207, maxTotalProvisionedDiskCapacityGb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(182933485, diskCount_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(206130633, poolUsedThroughput_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(228964050, poolUserWrittenBytes_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              447677830, totalProvisionedDiskThroughput_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(500825556, lastResizeTimestamp_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(510407877, poolUsedCapacityBytes_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              520930980, totalProvisionedDiskCapacityGb_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.StoragePoolResourceStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.StoragePoolResourceStatus other =
        (com.google.cloud.compute.v1.StoragePoolResourceStatus) obj;

    if (hasDiskCount() != other.hasDiskCount()) return false;
    if (hasDiskCount()) {
      if (getDiskCount() != other.getDiskCount()) return false;
    }
    if (hasLastResizeTimestamp() != other.hasLastResizeTimestamp()) return false;
    if (hasLastResizeTimestamp()) {
      if (!getLastResizeTimestamp().equals(other.getLastResizeTimestamp())) return false;
    }
    if (hasMaxTotalProvisionedDiskCapacityGb() != other.hasMaxTotalProvisionedDiskCapacityGb())
      return false;
    if (hasMaxTotalProvisionedDiskCapacityGb()) {
      if (getMaxTotalProvisionedDiskCapacityGb() != other.getMaxTotalProvisionedDiskCapacityGb())
        return false;
    }
    if (hasPoolUsedCapacityBytes() != other.hasPoolUsedCapacityBytes()) return false;
    if (hasPoolUsedCapacityBytes()) {
      if (getPoolUsedCapacityBytes() != other.getPoolUsedCapacityBytes()) return false;
    }
    if (hasPoolUsedIops() != other.hasPoolUsedIops()) return false;
    if (hasPoolUsedIops()) {
      if (getPoolUsedIops() != other.getPoolUsedIops()) return false;
    }
    if (hasPoolUsedThroughput() != other.hasPoolUsedThroughput()) return false;
    if (hasPoolUsedThroughput()) {
      if (getPoolUsedThroughput() != other.getPoolUsedThroughput()) return false;
    }
    if (hasPoolUserWrittenBytes() != other.hasPoolUserWrittenBytes()) return false;
    if (hasPoolUserWrittenBytes()) {
      if (getPoolUserWrittenBytes() != other.getPoolUserWrittenBytes()) return false;
    }
    if (hasTotalProvisionedDiskCapacityGb() != other.hasTotalProvisionedDiskCapacityGb())
      return false;
    if (hasTotalProvisionedDiskCapacityGb()) {
      if (getTotalProvisionedDiskCapacityGb() != other.getTotalProvisionedDiskCapacityGb())
        return false;
    }
    if (hasTotalProvisionedDiskIops() != other.hasTotalProvisionedDiskIops()) return false;
    if (hasTotalProvisionedDiskIops()) {
      if (getTotalProvisionedDiskIops() != other.getTotalProvisionedDiskIops()) return false;
    }
    if (hasTotalProvisionedDiskThroughput() != other.hasTotalProvisionedDiskThroughput())
      return false;
    if (hasTotalProvisionedDiskThroughput()) {
      if (getTotalProvisionedDiskThroughput() != other.getTotalProvisionedDiskThroughput())
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDiskCount()) {
      hash = (37 * hash) + DISK_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskCount());
    }
    if (hasLastResizeTimestamp()) {
      hash = (37 * hash) + LAST_RESIZE_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getLastResizeTimestamp().hashCode();
    }
    if (hasMaxTotalProvisionedDiskCapacityGb()) {
      hash = (37 * hash) + MAX_TOTAL_PROVISIONED_DISK_CAPACITY_GB_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(getMaxTotalProvisionedDiskCapacityGb());
    }
    if (hasPoolUsedCapacityBytes()) {
      hash = (37 * hash) + POOL_USED_CAPACITY_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPoolUsedCapacityBytes());
    }
    if (hasPoolUsedIops()) {
      hash = (37 * hash) + POOL_USED_IOPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPoolUsedIops());
    }
    if (hasPoolUsedThroughput()) {
      hash = (37 * hash) + POOL_USED_THROUGHPUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPoolUsedThroughput());
    }
    if (hasPoolUserWrittenBytes()) {
      hash = (37 * hash) + POOL_USER_WRITTEN_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPoolUserWrittenBytes());
    }
    if (hasTotalProvisionedDiskCapacityGb()) {
      hash = (37 * hash) + TOTAL_PROVISIONED_DISK_CAPACITY_GB_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalProvisionedDiskCapacityGb());
    }
    if (hasTotalProvisionedDiskIops()) {
      hash = (37 * hash) + TOTAL_PROVISIONED_DISK_IOPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalProvisionedDiskIops());
    }
    if (hasTotalProvisionedDiskThroughput()) {
      hash = (37 * hash) + TOTAL_PROVISIONED_DISK_THROUGHPUT_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalProvisionedDiskThroughput());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.StoragePoolResourceStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Contains output only fields.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.StoragePoolResourceStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.StoragePoolResourceStatus)
      com.google.cloud.compute.v1.StoragePoolResourceStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolResourceStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolResourceStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.StoragePoolResourceStatus.class,
              com.google.cloud.compute.v1.StoragePoolResourceStatus.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.StoragePoolResourceStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      diskCount_ = 0L;
      lastResizeTimestamp_ = "";
      maxTotalProvisionedDiskCapacityGb_ = 0L;
      poolUsedCapacityBytes_ = 0L;
      poolUsedIops_ = 0L;
      poolUsedThroughput_ = 0L;
      poolUserWrittenBytes_ = 0L;
      totalProvisionedDiskCapacityGb_ = 0L;
      totalProvisionedDiskIops_ = 0L;
      totalProvisionedDiskThroughput_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolResourceStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolResourceStatus getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.StoragePoolResourceStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolResourceStatus build() {
      com.google.cloud.compute.v1.StoragePoolResourceStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolResourceStatus buildPartial() {
      com.google.cloud.compute.v1.StoragePoolResourceStatus result =
          new com.google.cloud.compute.v1.StoragePoolResourceStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.StoragePoolResourceStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.diskCount_ = diskCount_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.lastResizeTimestamp_ = lastResizeTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxTotalProvisionedDiskCapacityGb_ = maxTotalProvisionedDiskCapacityGb_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.poolUsedCapacityBytes_ = poolUsedCapacityBytes_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.poolUsedIops_ = poolUsedIops_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.poolUsedThroughput_ = poolUsedThroughput_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.poolUserWrittenBytes_ = poolUserWrittenBytes_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.totalProvisionedDiskCapacityGb_ = totalProvisionedDiskCapacityGb_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.totalProvisionedDiskIops_ = totalProvisionedDiskIops_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.totalProvisionedDiskThroughput_ = totalProvisionedDiskThroughput_;
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.StoragePoolResourceStatus) {
        return mergeFrom((com.google.cloud.compute.v1.StoragePoolResourceStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.StoragePoolResourceStatus other) {
      if (other == com.google.cloud.compute.v1.StoragePoolResourceStatus.getDefaultInstance())
        return this;
      if (other.hasDiskCount()) {
        setDiskCount(other.getDiskCount());
      }
      if (other.hasLastResizeTimestamp()) {
        lastResizeTimestamp_ = other.lastResizeTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMaxTotalProvisionedDiskCapacityGb()) {
        setMaxTotalProvisionedDiskCapacityGb(other.getMaxTotalProvisionedDiskCapacityGb());
      }
      if (other.hasPoolUsedCapacityBytes()) {
        setPoolUsedCapacityBytes(other.getPoolUsedCapacityBytes());
      }
      if (other.hasPoolUsedIops()) {
        setPoolUsedIops(other.getPoolUsedIops());
      }
      if (other.hasPoolUsedThroughput()) {
        setPoolUsedThroughput(other.getPoolUsedThroughput());
      }
      if (other.hasPoolUserWrittenBytes()) {
        setPoolUserWrittenBytes(other.getPoolUserWrittenBytes());
      }
      if (other.hasTotalProvisionedDiskCapacityGb()) {
        setTotalProvisionedDiskCapacityGb(other.getTotalProvisionedDiskCapacityGb());
      }
      if (other.hasTotalProvisionedDiskIops()) {
        setTotalProvisionedDiskIops(other.getTotalProvisionedDiskIops());
      }
      if (other.hasTotalProvisionedDiskThroughput()) {
        setTotalProvisionedDiskThroughput(other.getTotalProvisionedDiskThroughput());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 262500392:
              {
                totalProvisionedDiskIops_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 262500392
            case 796468288:
              {
                poolUsedIops_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 796468288
            case 1326545656:
              {
                maxTotalProvisionedDiskCapacityGb_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 1326545656
            case 1463467880:
              {
                diskCount_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 1463467880
            case 1649045064:
              {
                poolUsedThroughput_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 1649045064
            case 1831712400:
              {
                poolUserWrittenBytes_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 1831712400
            case -713544656:
              {
                totalProvisionedDiskThroughput_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case -713544656
            case -288362846:
              {
                lastResizeTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -288362846
            case -211704280:
              {
                poolUsedCapacityBytes_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case -211704280
            case -127519456:
              {
                totalProvisionedDiskCapacityGb_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case -127519456
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long diskCount_;

    /**
     *
     *
     * <pre>
     * [Output Only] Number of disks used.
     * </pre>
     *
     * <code>optional int64 disk_count = 182933485;</code>
     *
     * @return Whether the diskCount field is set.
     */
    @java.lang.Override
    public boolean hasDiskCount() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of disks used.
     * </pre>
     *
     * <code>optional int64 disk_count = 182933485;</code>
     *
     * @return The diskCount.
     */
    @java.lang.Override
    public long getDiskCount() {
      return diskCount_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of disks used.
     * </pre>
     *
     * <code>optional int64 disk_count = 182933485;</code>
     *
     * @param value The diskCount to set.
     * @return This builder for chaining.
     */
    public Builder setDiskCount(long value) {

      diskCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Number of disks used.
     * </pre>
     *
     * <code>optional int64 disk_count = 182933485;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      diskCount_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object lastResizeTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @return Whether the lastResizeTimestamp field is set.
     */
    public boolean hasLastResizeTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @return The lastResizeTimestamp.
     */
    public java.lang.String getLastResizeTimestamp() {
      java.lang.Object ref = lastResizeTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastResizeTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @return The bytes for lastResizeTimestamp.
     */
    public com.google.protobuf.ByteString getLastResizeTimestampBytes() {
      java.lang.Object ref = lastResizeTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastResizeTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @param value The lastResizeTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastResizeTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastResizeTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastResizeTimestamp() {
      lastResizeTimestamp_ = getDefaultInstance().getLastResizeTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
     * </pre>
     *
     * <code>optional string last_resize_timestamp = 500825556;</code>
     *
     * @param value The bytes for lastResizeTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setLastResizeTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastResizeTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long maxTotalProvisionedDiskCapacityGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum allowed aggregate disk size in gigabytes.
     * </pre>
     *
     * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
     *
     * @return Whether the maxTotalProvisionedDiskCapacityGb field is set.
     */
    @java.lang.Override
    public boolean hasMaxTotalProvisionedDiskCapacityGb() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum allowed aggregate disk size in gigabytes.
     * </pre>
     *
     * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
     *
     * @return The maxTotalProvisionedDiskCapacityGb.
     */
    @java.lang.Override
    public long getMaxTotalProvisionedDiskCapacityGb() {
      return maxTotalProvisionedDiskCapacityGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum allowed aggregate disk size in gigabytes.
     * </pre>
     *
     * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
     *
     * @param value The maxTotalProvisionedDiskCapacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setMaxTotalProvisionedDiskCapacityGb(long value) {

      maxTotalProvisionedDiskCapacityGb_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum allowed aggregate disk size in gigabytes.
     * </pre>
     *
     * <code>optional int64 max_total_provisioned_disk_capacity_gb = 165818207;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxTotalProvisionedDiskCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxTotalProvisionedDiskCapacityGb_ = 0L;
      onChanged();
      return this;
    }

    private long poolUsedCapacityBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
     * </pre>
     *
     * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
     *
     * @return Whether the poolUsedCapacityBytes field is set.
     */
    @java.lang.Override
    public boolean hasPoolUsedCapacityBytes() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
     * </pre>
     *
     * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
     *
     * @return The poolUsedCapacityBytes.
     */
    @java.lang.Override
    public long getPoolUsedCapacityBytes() {
      return poolUsedCapacityBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
     * </pre>
     *
     * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
     *
     * @param value The poolUsedCapacityBytes to set.
     * @return This builder for chaining.
     */
    public Builder setPoolUsedCapacityBytes(long value) {

      poolUsedCapacityBytes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Space used by data stored in disks within the storage pool (in bytes). This will reflect the total number of bytes written to the disks in the pool, in contrast to the capacity of those disks.
     * </pre>
     *
     * <code>optional int64 pool_used_capacity_bytes = 510407877;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoolUsedCapacityBytes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      poolUsedCapacityBytes_ = 0L;
      onChanged();
      return this;
    }

    private long poolUsedIops_;

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
     * </pre>
     *
     * <code>optional int64 pool_used_iops = 99558536;</code>
     *
     * @return Whether the poolUsedIops field is set.
     */
    @java.lang.Override
    public boolean hasPoolUsedIops() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
     * </pre>
     *
     * <code>optional int64 pool_used_iops = 99558536;</code>
     *
     * @return The poolUsedIops.
     */
    @java.lang.Override
    public long getPoolUsedIops() {
      return poolUsedIops_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
     * </pre>
     *
     * <code>optional int64 pool_used_iops = 99558536;</code>
     *
     * @param value The poolUsedIops to set.
     * @return This builder for chaining.
     */
    public Builder setPoolUsedIops(long value) {

      poolUsedIops_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS, minus some amount that is allowed per disk that is not counted towards pool's IOPS capacity. For more information, see https://cloud.google.com/compute/docs/disks/storage-pools.
     * </pre>
     *
     * <code>optional int64 pool_used_iops = 99558536;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoolUsedIops() {
      bitField0_ = (bitField0_ & ~0x00000010);
      poolUsedIops_ = 0L;
      onChanged();
      return this;
    }

    private long poolUsedThroughput_;

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
     * </pre>
     *
     * <code>optional int64 pool_used_throughput = 206130633;</code>
     *
     * @return Whether the poolUsedThroughput field is set.
     */
    @java.lang.Override
    public boolean hasPoolUsedThroughput() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
     * </pre>
     *
     * <code>optional int64 pool_used_throughput = 206130633;</code>
     *
     * @return The poolUsedThroughput.
     */
    @java.lang.Override
    public long getPoolUsedThroughput() {
      return poolUsedThroughput_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
     * </pre>
     *
     * <code>optional int64 pool_used_throughput = 206130633;</code>
     *
     * @param value The poolUsedThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setPoolUsedThroughput(long value) {

      poolUsedThroughput_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
     * </pre>
     *
     * <code>optional int64 pool_used_throughput = 206130633;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoolUsedThroughput() {
      bitField0_ = (bitField0_ & ~0x00000020);
      poolUsedThroughput_ = 0L;
      onChanged();
      return this;
    }

    private long poolUserWrittenBytes_;

    /**
     *
     *
     * <pre>
     * [Output Only] Amount of data written into the pool, before it is compacted.
     * </pre>
     *
     * <code>optional int64 pool_user_written_bytes = 228964050;</code>
     *
     * @return Whether the poolUserWrittenBytes field is set.
     */
    @java.lang.Override
    public boolean hasPoolUserWrittenBytes() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Amount of data written into the pool, before it is compacted.
     * </pre>
     *
     * <code>optional int64 pool_user_written_bytes = 228964050;</code>
     *
     * @return The poolUserWrittenBytes.
     */
    @java.lang.Override
    public long getPoolUserWrittenBytes() {
      return poolUserWrittenBytes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Amount of data written into the pool, before it is compacted.
     * </pre>
     *
     * <code>optional int64 pool_user_written_bytes = 228964050;</code>
     *
     * @param value The poolUserWrittenBytes to set.
     * @return This builder for chaining.
     */
    public Builder setPoolUserWrittenBytes(long value) {

      poolUserWrittenBytes_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Amount of data written into the pool, before it is compacted.
     * </pre>
     *
     * <code>optional int64 pool_user_written_bytes = 228964050;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoolUserWrittenBytes() {
      bitField0_ = (bitField0_ & ~0x00000040);
      poolUserWrittenBytes_ = 0L;
      onChanged();
      return this;
    }

    private long totalProvisionedDiskCapacityGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
     *
     * @return Whether the totalProvisionedDiskCapacityGb field is set.
     */
    @java.lang.Override
    public boolean hasTotalProvisionedDiskCapacityGb() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
     *
     * @return The totalProvisionedDiskCapacityGb.
     */
    @java.lang.Override
    public long getTotalProvisionedDiskCapacityGb() {
      return totalProvisionedDiskCapacityGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
     *
     * @param value The totalProvisionedDiskCapacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setTotalProvisionedDiskCapacityGb(long value) {

      totalProvisionedDiskCapacityGb_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's provisioned capacity is the same as its total capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_capacity_gb = 520930980;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalProvisionedDiskCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000080);
      totalProvisionedDiskCapacityGb_ = 0L;
      onChanged();
      return this;
    }

    private long totalProvisionedDiskIops_;

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
     *
     * @return Whether the totalProvisionedDiskIops field is set.
     */
    @java.lang.Override
    public boolean hasTotalProvisionedDiskIops() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
     *
     * @return The totalProvisionedDiskIops.
     */
    @java.lang.Override
    public long getTotalProvisionedDiskIops() {
      return totalProvisionedDiskIops_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
     *
     * @param value The totalProvisionedDiskIops to set.
     * @return This builder for chaining.
     */
    public Builder setTotalProvisionedDiskIops(long value) {

      totalProvisionedDiskIops_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_iops = 32812549;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalProvisionedDiskIops() {
      bitField0_ = (bitField0_ & ~0x00000100);
      totalProvisionedDiskIops_ = 0L;
      onChanged();
      return this;
    }

    private long totalProvisionedDiskThroughput_;

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
     *
     * @return Whether the totalProvisionedDiskThroughput field is set.
     */
    @java.lang.Override
    public boolean hasTotalProvisionedDiskThroughput() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
     *
     * @return The totalProvisionedDiskThroughput.
     */
    @java.lang.Override
    public long getTotalProvisionedDiskThroughput() {
      return totalProvisionedDiskThroughput_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
     *
     * @param value The totalProvisionedDiskThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setTotalProvisionedDiskThroughput(long value) {

      totalProvisionedDiskThroughput_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Sum of all the disks' provisioned throughput in MB/s, minus some amount that is allowed per disk that is not counted towards pool's throughput capacity.
     * </pre>
     *
     * <code>optional int64 total_provisioned_disk_throughput = 447677830;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalProvisionedDiskThroughput() {
      bitField0_ = (bitField0_ & ~0x00000200);
      totalProvisionedDiskThroughput_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.StoragePoolResourceStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.StoragePoolResourceStatus)
  private static final com.google.cloud.compute.v1.StoragePoolResourceStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.StoragePoolResourceStatus();
  }

  public static com.google.cloud.compute.v1.StoragePoolResourceStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StoragePoolResourceStatus> PARSER =
      new com.google.protobuf.AbstractParser<StoragePoolResourceStatus>() {
        @java.lang.Override
        public StoragePoolResourceStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StoragePoolResourceStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StoragePoolResourceStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.StoragePoolResourceStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
