/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.StoragePoolType}
 */
public final class StoragePoolType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.StoragePoolType)
    StoragePoolTypeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StoragePoolType.newBuilder() to construct.
  private StoragePoolType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StoragePoolType() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
    selfLinkWithId_ = "";
    supportedDiskTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StoragePoolType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StoragePoolType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_StoragePoolType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.StoragePoolType.class,
            com.google.cloud.compute.v1.StoragePoolType.Builder.class);
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPRECATED_FIELD_NUMBER = 515138995;
  private com.google.cloud.compute.v1.DeprecationStatus deprecated_;

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this storage pool type.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   *
   * @return Whether the deprecated field is set.
   */
  @java.lang.Override
  public boolean hasDeprecated() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this storage pool type.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   *
   * @return The deprecated.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DeprecationStatus getDeprecated() {
    return deprecated_ == null
        ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
        : deprecated_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this storage pool type.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DeprecationStatusOrBuilder getDeprecatedOrBuilder() {
    return deprecated_ == null
        ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
        : deprecated_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_POOL_PROVISIONED_CAPACITY_GB_FIELD_NUMBER = 182139085;
  private long maxPoolProvisionedCapacityGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum storage pool size in GB.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
   *
   * @return Whether the maxPoolProvisionedCapacityGb field is set.
   */
  @java.lang.Override
  public boolean hasMaxPoolProvisionedCapacityGb() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum storage pool size in GB.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
   *
   * @return The maxPoolProvisionedCapacityGb.
   */
  @java.lang.Override
  public long getMaxPoolProvisionedCapacityGb() {
    return maxPoolProvisionedCapacityGb_;
  }

  public static final int MAX_POOL_PROVISIONED_IOPS_FIELD_NUMBER = 515270652;
  private long maxPoolProvisionedIops_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
   *
   * @return Whether the maxPoolProvisionedIops field is set.
   */
  @java.lang.Override
  public boolean hasMaxPoolProvisionedIops() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
   *
   * @return The maxPoolProvisionedIops.
   */
  @java.lang.Override
  public long getMaxPoolProvisionedIops() {
    return maxPoolProvisionedIops_;
  }

  public static final int MAX_POOL_PROVISIONED_THROUGHPUT_FIELD_NUMBER = 228928061;
  private long maxPoolProvisionedThroughput_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum provisioned throughput.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
   *
   * @return Whether the maxPoolProvisionedThroughput field is set.
   */
  @java.lang.Override
  public boolean hasMaxPoolProvisionedThroughput() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum provisioned throughput.
   * </pre>
   *
   * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
   *
   * @return The maxPoolProvisionedThroughput.
   */
  @java.lang.Override
  public long getMaxPoolProvisionedThroughput() {
    return maxPoolProvisionedThroughput_;
  }

  public static final int MIN_POOL_PROVISIONED_CAPACITY_GB_FIELD_NUMBER = 191022751;
  private long minPoolProvisionedCapacityGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum storage pool size in GB.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
   *
   * @return Whether the minPoolProvisionedCapacityGb field is set.
   */
  @java.lang.Override
  public boolean hasMinPoolProvisionedCapacityGb() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum storage pool size in GB.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
   *
   * @return The minPoolProvisionedCapacityGb.
   */
  @java.lang.Override
  public long getMinPoolProvisionedCapacityGb() {
    return minPoolProvisionedCapacityGb_;
  }

  public static final int MIN_POOL_PROVISIONED_IOPS_FIELD_NUMBER = 416473706;
  private long minPoolProvisionedIops_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
   *
   * @return Whether the minPoolProvisionedIops field is set.
   */
  @java.lang.Override
  public boolean hasMinPoolProvisionedIops() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum provisioned IOPS.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
   *
   * @return The minPoolProvisionedIops.
   */
  @java.lang.Override
  public long getMinPoolProvisionedIops() {
    return minPoolProvisionedIops_;
  }

  public static final int MIN_POOL_PROVISIONED_THROUGHPUT_FIELD_NUMBER = 367761963;
  private long minPoolProvisionedThroughput_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum provisioned throughput.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
   *
   * @return Whether the minPoolProvisionedThroughput field is set.
   */
  @java.lang.Override
  public boolean hasMinPoolProvisionedThroughput() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Minimum provisioned throughput.
   * </pre>
   *
   * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
   *
   * @return The minPoolProvisionedThroughput.
   */
  @java.lang.Override
  public long getMinPoolProvisionedThroughput() {
    return minPoolProvisionedThroughput_;
  }

  public static final int MIN_SIZE_GB_FIELD_NUMBER = 385278188;
  private long minSizeGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
   * </pre>
   *
   * <code>optional int64 min_size_gb = 385278188;</code>
   *
   * @return Whether the minSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasMinSizeGb() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
   * </pre>
   *
   * <code>optional int64 min_size_gb = 385278188;</code>
   *
   * @return The minSizeGb.
   */
  @java.lang.Override
  public long getMinSizeGb() {
    return minSizeGb_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_WITH_ID_FIELD_NUMBER = 44520962;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLinkWithId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return Whether the selfLinkWithId field is set.
   */
  @java.lang.Override
  public boolean hasSelfLinkWithId() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The selfLinkWithId.
   */
  @java.lang.Override
  public java.lang.String getSelfLinkWithId() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLinkWithId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The bytes for selfLinkWithId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLinkWithId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_DISK_TYPES_FIELD_NUMBER = 150587272;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedDiskTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] The list of disk types supported in this storage pool type.
   * </pre>
   *
   * <code>repeated string supported_disk_types = 150587272;</code>
   *
   * @return A list containing the supportedDiskTypes.
   */
  public com.google.protobuf.ProtocolStringList getSupportedDiskTypesList() {
    return supportedDiskTypes_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The list of disk types supported in this storage pool type.
   * </pre>
   *
   * <code>repeated string supported_disk_types = 150587272;</code>
   *
   * @return The count of supportedDiskTypes.
   */
  public int getSupportedDiskTypesCount() {
    return supportedDiskTypes_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The list of disk types supported in this storage pool type.
   * </pre>
   *
   * <code>repeated string supported_disk_types = 150587272;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedDiskTypes at the given index.
   */
  public java.lang.String getSupportedDiskTypes(int index) {
    return supportedDiskTypes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The list of disk types supported in this storage pool type.
   * </pre>
   *
   * <code>repeated string supported_disk_types = 150587272;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedDiskTypes at the given index.
   */
  public com.google.protobuf.ByteString getSupportedDiskTypesBytes(int index) {
    return supportedDiskTypes_.getByteString(index);
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 44520962, selfLinkWithId_);
    }
    for (int i = 0; i < supportedDiskTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 150587272, supportedDiskTypes_.getRaw(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(182139085, maxPoolProvisionedCapacityGb_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt64(191022751, minPoolProvisionedCapacityGb_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt64(228928061, maxPoolProvisionedThroughput_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt64(367761963, minPoolProvisionedThroughput_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeInt64(385278188, minSizeGb_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt64(416473706, minPoolProvisionedIops_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(515138995, getDeprecated());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(515270652, maxPoolProvisionedIops_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(44520962, selfLinkWithId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedDiskTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedDiskTypes_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSupportedDiskTypesList().size();
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              182139085, maxPoolProvisionedCapacityGb_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              191022751, minPoolProvisionedCapacityGb_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              228928061, maxPoolProvisionedThroughput_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              367761963, minPoolProvisionedThroughput_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(385278188, minSizeGb_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              416473706, minPoolProvisionedIops_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(515138995, getDeprecated());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              515270652, maxPoolProvisionedIops_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.StoragePoolType)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.StoragePoolType other =
        (com.google.cloud.compute.v1.StoragePoolType) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDeprecated() != other.hasDeprecated()) return false;
    if (hasDeprecated()) {
      if (!getDeprecated().equals(other.getDeprecated())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMaxPoolProvisionedCapacityGb() != other.hasMaxPoolProvisionedCapacityGb()) return false;
    if (hasMaxPoolProvisionedCapacityGb()) {
      if (getMaxPoolProvisionedCapacityGb() != other.getMaxPoolProvisionedCapacityGb())
        return false;
    }
    if (hasMaxPoolProvisionedIops() != other.hasMaxPoolProvisionedIops()) return false;
    if (hasMaxPoolProvisionedIops()) {
      if (getMaxPoolProvisionedIops() != other.getMaxPoolProvisionedIops()) return false;
    }
    if (hasMaxPoolProvisionedThroughput() != other.hasMaxPoolProvisionedThroughput()) return false;
    if (hasMaxPoolProvisionedThroughput()) {
      if (getMaxPoolProvisionedThroughput() != other.getMaxPoolProvisionedThroughput())
        return false;
    }
    if (hasMinPoolProvisionedCapacityGb() != other.hasMinPoolProvisionedCapacityGb()) return false;
    if (hasMinPoolProvisionedCapacityGb()) {
      if (getMinPoolProvisionedCapacityGb() != other.getMinPoolProvisionedCapacityGb())
        return false;
    }
    if (hasMinPoolProvisionedIops() != other.hasMinPoolProvisionedIops()) return false;
    if (hasMinPoolProvisionedIops()) {
      if (getMinPoolProvisionedIops() != other.getMinPoolProvisionedIops()) return false;
    }
    if (hasMinPoolProvisionedThroughput() != other.hasMinPoolProvisionedThroughput()) return false;
    if (hasMinPoolProvisionedThroughput()) {
      if (getMinPoolProvisionedThroughput() != other.getMinPoolProvisionedThroughput())
        return false;
    }
    if (hasMinSizeGb() != other.hasMinSizeGb()) return false;
    if (hasMinSizeGb()) {
      if (getMinSizeGb() != other.getMinSizeGb()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSelfLinkWithId() != other.hasSelfLinkWithId()) return false;
    if (hasSelfLinkWithId()) {
      if (!getSelfLinkWithId().equals(other.getSelfLinkWithId())) return false;
    }
    if (!getSupportedDiskTypesList().equals(other.getSupportedDiskTypesList())) return false;
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDeprecated()) {
      hash = (37 * hash) + DEPRECATED_FIELD_NUMBER;
      hash = (53 * hash) + getDeprecated().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMaxPoolProvisionedCapacityGb()) {
      hash = (37 * hash) + MAX_POOL_PROVISIONED_CAPACITY_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxPoolProvisionedCapacityGb());
    }
    if (hasMaxPoolProvisionedIops()) {
      hash = (37 * hash) + MAX_POOL_PROVISIONED_IOPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxPoolProvisionedIops());
    }
    if (hasMaxPoolProvisionedThroughput()) {
      hash = (37 * hash) + MAX_POOL_PROVISIONED_THROUGHPUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxPoolProvisionedThroughput());
    }
    if (hasMinPoolProvisionedCapacityGb()) {
      hash = (37 * hash) + MIN_POOL_PROVISIONED_CAPACITY_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinPoolProvisionedCapacityGb());
    }
    if (hasMinPoolProvisionedIops()) {
      hash = (37 * hash) + MIN_POOL_PROVISIONED_IOPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinPoolProvisionedIops());
    }
    if (hasMinPoolProvisionedThroughput()) {
      hash = (37 * hash) + MIN_POOL_PROVISIONED_THROUGHPUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinPoolProvisionedThroughput());
    }
    if (hasMinSizeGb()) {
      hash = (37 * hash) + MIN_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinSizeGb());
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSelfLinkWithId()) {
      hash = (37 * hash) + SELF_LINK_WITH_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLinkWithId().hashCode();
    }
    if (getSupportedDiskTypesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_DISK_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedDiskTypesList().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.StoragePoolType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.StoragePoolType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.StoragePoolType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.StoragePoolType)
      com.google.cloud.compute.v1.StoragePoolTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.StoragePoolType.class,
              com.google.cloud.compute.v1.StoragePoolType.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.StoragePoolType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDeprecatedFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      deprecated_ = null;
      if (deprecatedBuilder_ != null) {
        deprecatedBuilder_.dispose();
        deprecatedBuilder_ = null;
      }
      description_ = "";
      id_ = 0L;
      kind_ = "";
      maxPoolProvisionedCapacityGb_ = 0L;
      maxPoolProvisionedIops_ = 0L;
      maxPoolProvisionedThroughput_ = 0L;
      minPoolProvisionedCapacityGb_ = 0L;
      minPoolProvisionedIops_ = 0L;
      minPoolProvisionedThroughput_ = 0L;
      minSizeGb_ = 0L;
      name_ = "";
      selfLink_ = "";
      selfLinkWithId_ = "";
      supportedDiskTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_StoragePoolType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolType getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.StoragePoolType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolType build() {
      com.google.cloud.compute.v1.StoragePoolType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.StoragePoolType buildPartial() {
      com.google.cloud.compute.v1.StoragePoolType result =
          new com.google.cloud.compute.v1.StoragePoolType(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.StoragePoolType result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deprecated_ = deprecatedBuilder_ == null ? deprecated_ : deprecatedBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.maxPoolProvisionedCapacityGb_ = maxPoolProvisionedCapacityGb_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxPoolProvisionedIops_ = maxPoolProvisionedIops_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxPoolProvisionedThroughput_ = maxPoolProvisionedThroughput_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.minPoolProvisionedCapacityGb_ = minPoolProvisionedCapacityGb_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.minPoolProvisionedIops_ = minPoolProvisionedIops_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.minPoolProvisionedThroughput_ = minPoolProvisionedThroughput_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.minSizeGb_ = minSizeGb_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLinkWithId_ = selfLinkWithId_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        supportedDiskTypes_.makeImmutable();
        result.supportedDiskTypes_ = supportedDiskTypes_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.StoragePoolType) {
        return mergeFrom((com.google.cloud.compute.v1.StoragePoolType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.StoragePoolType other) {
      if (other == com.google.cloud.compute.v1.StoragePoolType.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDeprecated()) {
        mergeDeprecated(other.getDeprecated());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasMaxPoolProvisionedCapacityGb()) {
        setMaxPoolProvisionedCapacityGb(other.getMaxPoolProvisionedCapacityGb());
      }
      if (other.hasMaxPoolProvisionedIops()) {
        setMaxPoolProvisionedIops(other.getMaxPoolProvisionedIops());
      }
      if (other.hasMaxPoolProvisionedThroughput()) {
        setMaxPoolProvisionedThroughput(other.getMaxPoolProvisionedThroughput());
      }
      if (other.hasMinPoolProvisionedCapacityGb()) {
        setMinPoolProvisionedCapacityGb(other.getMinPoolProvisionedCapacityGb());
      }
      if (other.hasMinPoolProvisionedIops()) {
        setMinPoolProvisionedIops(other.getMinPoolProvisionedIops());
      }
      if (other.hasMinPoolProvisionedThroughput()) {
        setMinPoolProvisionedThroughput(other.getMinPoolProvisionedThroughput());
      }
      if (other.hasMinSizeGb()) {
        setMinSizeGb(other.getMinSizeGb());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSelfLinkWithId()) {
        selfLinkWithId_ = other.selfLinkWithId_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.supportedDiskTypes_.isEmpty()) {
        if (supportedDiskTypes_.isEmpty()) {
          supportedDiskTypes_ = other.supportedDiskTypes_;
          bitField0_ |= 0x00008000;
        } else {
          ensureSupportedDiskTypesIsMutable();
          supportedDiskTypes_.addAll(other.supportedDiskTypes_);
        }
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 356167698:
              {
                selfLinkWithId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 356167698
            case 1204698178:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedDiskTypesIsMutable();
                supportedDiskTypes_.add(s);
                break;
              } // case 1204698178
            case 1457112680:
              {
                maxPoolProvisionedCapacityGb_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 1457112680
            case 1528182008:
              {
                minPoolProvisionedCapacityGb_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 1528182008
            case 1831424488:
              {
                maxPoolProvisionedThroughput_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 1831424488
            case -1352871592:
              {
                minPoolProvisionedThroughput_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case -1352871592
            case -1212741792:
              {
                minSizeGb_ = input.readInt64();
                bitField0_ |= 0x00000800;
                break;
              } // case -1212741792
            case -963177648:
              {
                minPoolProvisionedIops_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case -963177648
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -645248918
            case -173855334:
              {
                input.readMessage(getDeprecatedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -173855334
            case -172802080:
              {
                maxPoolProvisionedIops_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case -172802080
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.DeprecationStatus deprecated_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DeprecationStatus,
            com.google.cloud.compute.v1.DeprecationStatus.Builder,
            com.google.cloud.compute.v1.DeprecationStatusOrBuilder>
        deprecatedBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     *
     * @return Whether the deprecated field is set.
     */
    public boolean hasDeprecated() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     *
     * @return The deprecated.
     */
    public com.google.cloud.compute.v1.DeprecationStatus getDeprecated() {
      if (deprecatedBuilder_ == null) {
        return deprecated_ == null
            ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
            : deprecated_;
      } else {
        return deprecatedBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder setDeprecated(com.google.cloud.compute.v1.DeprecationStatus value) {
      if (deprecatedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deprecated_ = value;
      } else {
        deprecatedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder setDeprecated(
        com.google.cloud.compute.v1.DeprecationStatus.Builder builderForValue) {
      if (deprecatedBuilder_ == null) {
        deprecated_ = builderForValue.build();
      } else {
        deprecatedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder mergeDeprecated(com.google.cloud.compute.v1.DeprecationStatus value) {
      if (deprecatedBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && deprecated_ != null
            && deprecated_ != com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()) {
          getDeprecatedBuilder().mergeFrom(value);
        } else {
          deprecated_ = value;
        }
      } else {
        deprecatedBuilder_.mergeFrom(value);
      }
      if (deprecated_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder clearDeprecated() {
      bitField0_ = (bitField0_ & ~0x00000002);
      deprecated_ = null;
      if (deprecatedBuilder_ != null) {
        deprecatedBuilder_.dispose();
        deprecatedBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public com.google.cloud.compute.v1.DeprecationStatus.Builder getDeprecatedBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDeprecatedFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public com.google.cloud.compute.v1.DeprecationStatusOrBuilder getDeprecatedOrBuilder() {
      if (deprecatedBuilder_ != null) {
        return deprecatedBuilder_.getMessageOrBuilder();
      } else {
        return deprecated_ == null
            ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
            : deprecated_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this storage pool type.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DeprecationStatus,
            com.google.cloud.compute.v1.DeprecationStatus.Builder,
            com.google.cloud.compute.v1.DeprecationStatusOrBuilder>
        getDeprecatedFieldBuilder() {
      if (deprecatedBuilder_ == null) {
        deprecatedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.DeprecationStatus,
                com.google.cloud.compute.v1.DeprecationStatus.Builder,
                com.google.cloud.compute.v1.DeprecationStatusOrBuilder>(
                getDeprecated(), getParentForChildren(), isClean());
        deprecated_ = null;
      }
      return deprecatedBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long maxPoolProvisionedCapacityGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
     *
     * @return Whether the maxPoolProvisionedCapacityGb field is set.
     */
    @java.lang.Override
    public boolean hasMaxPoolProvisionedCapacityGb() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
     *
     * @return The maxPoolProvisionedCapacityGb.
     */
    @java.lang.Override
    public long getMaxPoolProvisionedCapacityGb() {
      return maxPoolProvisionedCapacityGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
     *
     * @param value The maxPoolProvisionedCapacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPoolProvisionedCapacityGb(long value) {

      maxPoolProvisionedCapacityGb_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_capacity_gb = 182139085;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPoolProvisionedCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000020);
      maxPoolProvisionedCapacityGb_ = 0L;
      onChanged();
      return this;
    }

    private long maxPoolProvisionedIops_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
     *
     * @return Whether the maxPoolProvisionedIops field is set.
     */
    @java.lang.Override
    public boolean hasMaxPoolProvisionedIops() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
     *
     * @return The maxPoolProvisionedIops.
     */
    @java.lang.Override
    public long getMaxPoolProvisionedIops() {
      return maxPoolProvisionedIops_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
     *
     * @param value The maxPoolProvisionedIops to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPoolProvisionedIops(long value) {

      maxPoolProvisionedIops_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_iops = 515270652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPoolProvisionedIops() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxPoolProvisionedIops_ = 0L;
      onChanged();
      return this;
    }

    private long maxPoolProvisionedThroughput_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
     *
     * @return Whether the maxPoolProvisionedThroughput field is set.
     */
    @java.lang.Override
    public boolean hasMaxPoolProvisionedThroughput() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
     *
     * @return The maxPoolProvisionedThroughput.
     */
    @java.lang.Override
    public long getMaxPoolProvisionedThroughput() {
      return maxPoolProvisionedThroughput_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
     *
     * @param value The maxPoolProvisionedThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPoolProvisionedThroughput(long value) {

      maxPoolProvisionedThroughput_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 max_pool_provisioned_throughput = 228928061;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPoolProvisionedThroughput() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxPoolProvisionedThroughput_ = 0L;
      onChanged();
      return this;
    }

    private long minPoolProvisionedCapacityGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
     *
     * @return Whether the minPoolProvisionedCapacityGb field is set.
     */
    @java.lang.Override
    public boolean hasMinPoolProvisionedCapacityGb() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
     *
     * @return The minPoolProvisionedCapacityGb.
     */
    @java.lang.Override
    public long getMinPoolProvisionedCapacityGb() {
      return minPoolProvisionedCapacityGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
     *
     * @param value The minPoolProvisionedCapacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setMinPoolProvisionedCapacityGb(long value) {

      minPoolProvisionedCapacityGb_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum storage pool size in GB.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_capacity_gb = 191022751;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinPoolProvisionedCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000100);
      minPoolProvisionedCapacityGb_ = 0L;
      onChanged();
      return this;
    }

    private long minPoolProvisionedIops_;

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
     *
     * @return Whether the minPoolProvisionedIops field is set.
     */
    @java.lang.Override
    public boolean hasMinPoolProvisionedIops() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
     *
     * @return The minPoolProvisionedIops.
     */
    @java.lang.Override
    public long getMinPoolProvisionedIops() {
      return minPoolProvisionedIops_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
     *
     * @param value The minPoolProvisionedIops to set.
     * @return This builder for chaining.
     */
    public Builder setMinPoolProvisionedIops(long value) {

      minPoolProvisionedIops_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned IOPS.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_iops = 416473706;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinPoolProvisionedIops() {
      bitField0_ = (bitField0_ & ~0x00000200);
      minPoolProvisionedIops_ = 0L;
      onChanged();
      return this;
    }

    private long minPoolProvisionedThroughput_;

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
     *
     * @return Whether the minPoolProvisionedThroughput field is set.
     */
    @java.lang.Override
    public boolean hasMinPoolProvisionedThroughput() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
     *
     * @return The minPoolProvisionedThroughput.
     */
    @java.lang.Override
    public long getMinPoolProvisionedThroughput() {
      return minPoolProvisionedThroughput_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
     *
     * @param value The minPoolProvisionedThroughput to set.
     * @return This builder for chaining.
     */
    public Builder setMinPoolProvisionedThroughput(long value) {

      minPoolProvisionedThroughput_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Minimum provisioned throughput.
     * </pre>
     *
     * <code>optional int64 min_pool_provisioned_throughput = 367761963;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinPoolProvisionedThroughput() {
      bitField0_ = (bitField0_ & ~0x00000400);
      minPoolProvisionedThroughput_ = 0L;
      onChanged();
      return this;
    }

    private long minSizeGb_;

    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
     * </pre>
     *
     * <code>optional int64 min_size_gb = 385278188;</code>
     *
     * @return Whether the minSizeGb field is set.
     */
    @java.lang.Override
    public boolean hasMinSizeGb() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
     * </pre>
     *
     * <code>optional int64 min_size_gb = 385278188;</code>
     *
     * @return The minSizeGb.
     */
    @java.lang.Override
    public long getMinSizeGb() {
      return minSizeGb_;
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
     * </pre>
     *
     * <code>optional int64 min_size_gb = 385278188;</code>
     *
     * @param value The minSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setMinSizeGb(long value) {

      minSizeGb_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
     * </pre>
     *
     * <code>optional int64 min_size_gb = 385278188;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000800);
      minSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLinkWithId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return Whether the selfLinkWithId field is set.
     */
    public boolean hasSelfLinkWithId() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The selfLinkWithId.
     */
    public java.lang.String getSelfLinkWithId() {
      java.lang.Object ref = selfLinkWithId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLinkWithId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The bytes for selfLinkWithId.
     */
    public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
      java.lang.Object ref = selfLinkWithId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLinkWithId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLinkWithId_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLinkWithId() {
      selfLinkWithId_ = getDefaultInstance().getSelfLinkWithId();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The bytes for selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLinkWithId_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedDiskTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedDiskTypesIsMutable() {
      if (!supportedDiskTypes_.isModifiable()) {
        supportedDiskTypes_ = new com.google.protobuf.LazyStringArrayList(supportedDiskTypes_);
      }
      bitField0_ |= 0x00008000;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @return A list containing the supportedDiskTypes.
     */
    public com.google.protobuf.ProtocolStringList getSupportedDiskTypesList() {
      supportedDiskTypes_.makeImmutable();
      return supportedDiskTypes_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @return The count of supportedDiskTypes.
     */
    public int getSupportedDiskTypesCount() {
      return supportedDiskTypes_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedDiskTypes at the given index.
     */
    public java.lang.String getSupportedDiskTypes(int index) {
      return supportedDiskTypes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedDiskTypes at the given index.
     */
    public com.google.protobuf.ByteString getSupportedDiskTypesBytes(int index) {
      return supportedDiskTypes_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedDiskTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedDiskTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedDiskTypesIsMutable();
      supportedDiskTypes_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param value The supportedDiskTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedDiskTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedDiskTypesIsMutable();
      supportedDiskTypes_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param values The supportedDiskTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedDiskTypes(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedDiskTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedDiskTypes_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedDiskTypes() {
      supportedDiskTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The list of disk types supported in this storage pool type.
     * </pre>
     *
     * <code>repeated string supported_disk_types = 150587272;</code>
     *
     * @param value The bytes of the supportedDiskTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedDiskTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedDiskTypesIsMutable();
      supportedDiskTypes_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the zone where the storage pool type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.StoragePoolType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.StoragePoolType)
  private static final com.google.cloud.compute.v1.StoragePoolType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.StoragePoolType();
  }

  public static com.google.cloud.compute.v1.StoragePoolType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StoragePoolType> PARSER =
      new com.google.protobuf.AbstractParser<StoragePoolType>() {
        @java.lang.Override
        public StoragePoolType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StoragePoolType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StoragePoolType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.StoragePoolType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
